/* unity-lens.c generated by valac 0.12.1, the Vala compiler
 * generated from unity-lens.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "unity.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define UNITY_TYPE_LENS_IMPL (unity_lens_impl_get_type ())
#define UNITY_LENS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_LENS_IMPL, UnityLensImpl))
#define UNITY_LENS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_LENS_IMPL, UnityLensImplClass))
#define UNITY_IS_LENS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_LENS_IMPL))
#define UNITY_IS_LENS_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_LENS_IMPL))
#define UNITY_LENS_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_LENS_IMPL, UnityLensImplClass))

typedef struct _UnityLensImpl UnityLensImpl;
typedef struct _UnityLensImplClass UnityLensImplClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _UnityLensPrivate {
	gboolean _active;
	gboolean _visible;
	gboolean _searching;
	gboolean _exported;
	gboolean _search_in_global;
	gchar* _id;
	gchar* _dbus_path;
	gchar* _search_hint;
	UnityLensImpl* _pimpl;
	GList* _categories;
	GList* _filters;
};


static gpointer unity_lens_parent_class = NULL;

GType unity_lens_impl_get_type (void) G_GNUC_CONST;
#define UNITY_LENS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_LENS, UnityLensPrivate))
enum  {
	UNITY_LENS_DUMMY_PROPERTY,
	UNITY_LENS_ACTIVE,
	UNITY_LENS_VISIBLE,
	UNITY_LENS_SEARCHING,
	UNITY_LENS_EXPORTED,
	UNITY_LENS_SEARCH_IN_GLOBAL,
	UNITY_LENS_ID,
	UNITY_LENS_DBUS_PATH,
	UNITY_LENS_SEARCH_HINT,
	UNITY_LENS_FILTERS,
	UNITY_LENS_CATEGORIES
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
void unity_lens_impl_export (UnityLensImpl* self, GError** error);
static void unity_lens_set_exported (UnityLens* self, gboolean value);
void unity_lens_impl_add_local_scope (UnityLensImpl* self, UnityScope* scope);
void unity_lens_set_active_internal (UnityLens* self, gboolean is_active);
static void unity_lens_set_active (UnityLens* self, gboolean value);
static void unity_lens_set_searching (UnityLens* self, gboolean value);
void unity_lens_impl_load_filters (UnityLensImpl* self, GList* filters);
void unity_lens_impl_load_categories (UnityLensImpl* self, GList* categories);
static GObject * unity_lens_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
UnityLensImpl* unity_lens_impl_new (UnityLens* owner);
UnityLensImpl* unity_lens_impl_construct (GType object_type, UnityLens* owner);
static void unity_lens_finalize (GObject* obj);
static void _vala_unity_lens_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_lens_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


UnityLens* unity_lens_construct (GType object_type, const gchar* dbus_path_, const gchar* id_) {
	UnityLens * self = NULL;
	g_return_val_if_fail (dbus_path_ != NULL, NULL);
	g_return_val_if_fail (id_ != NULL, NULL);
	self = (UnityLens*) g_object_new (object_type, "dbus-path", dbus_path_, "id", id_, NULL);
	return self;
}


UnityLens* unity_lens_new (const gchar* dbus_path_, const gchar* id_) {
	return unity_lens_construct (UNITY_TYPE_LENS, dbus_path_, id_);
}


void unity_lens_export (UnityLens* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->_exported) {
		unity_lens_impl_export (self->priv->_pimpl, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		unity_lens_set_exported (self, TRUE);
	}
}


void unity_lens_add_local_scope (UnityLens* self, UnityScope* scope) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scope != NULL);
	unity_lens_impl_add_local_scope (self->priv->_pimpl, scope);
}


void unity_lens_set_active_internal (UnityLens* self, gboolean is_active) {
	g_return_if_fail (self != NULL);
	unity_lens_set_active (self, is_active);
}


gboolean unity_lens_get_active (UnityLens* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


static void unity_lens_set_active (UnityLens* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


gboolean unity_lens_get_visible (UnityLens* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_visible;
	return result;
}


void unity_lens_set_visible (UnityLens* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_visible = value;
	g_object_notify ((GObject *) self, "visible");
}


gboolean unity_lens_get_searching (UnityLens* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_searching;
	return result;
}


static void unity_lens_set_searching (UnityLens* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_searching = value;
	g_object_notify ((GObject *) self, "searching");
}


gboolean unity_lens_get_exported (UnityLens* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_exported;
	return result;
}


static void unity_lens_set_exported (UnityLens* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_exported = value;
	g_object_notify ((GObject *) self, "exported");
}


gboolean unity_lens_get_search_in_global (UnityLens* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_search_in_global;
	return result;
}


void unity_lens_set_search_in_global (UnityLens* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_search_in_global = value;
	g_object_notify ((GObject *) self, "search-in-global");
}


const gchar* unity_lens_get_id (UnityLens* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_id;
	return result;
}


static void unity_lens_set_id (UnityLens* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


const gchar* unity_lens_get_dbus_path (UnityLens* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dbus_path;
	return result;
}


static void unity_lens_set_dbus_path (UnityLens* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_dbus_path = _tmp0_;
	g_object_notify ((GObject *) self, "dbus-path");
}


const gchar* unity_lens_get_search_hint (UnityLens* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_search_hint;
	return result;
}


void unity_lens_set_search_hint (UnityLens* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_search_hint);
	self->priv->_search_hint = _tmp0_;
	g_object_notify ((GObject *) self, "search-hint");
}


GList* unity_lens_get_filters (UnityLens* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filters;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_lens_set_filters (UnityLens* self, GList* value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_filters == NULL) {
		__g_list_free__g_object_unref0_0 (self->priv->_filters);
		self->priv->_filters = NULL;
		{
			GList* f_collection;
			GList* f_it;
			f_collection = value;
			for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
				UnityFilter* _tmp0_;
				UnityFilter* f;
				_tmp0_ = _g_object_ref0 ((UnityFilter*) f_it->data);
				f = _tmp0_;
				{
					UnityFilter* _tmp1_;
					_tmp1_ = _g_object_ref0 (f);
					self->priv->_filters = g_list_prepend (self->priv->_filters, _tmp1_);
					_g_object_unref0 (f);
				}
			}
		}
		self->priv->_filters = g_list_reverse (self->priv->_filters);
		unity_lens_impl_load_filters (self->priv->_pimpl, self->priv->_filters);
	} else {
		g_warning ("unity-lens.vala:50: Filters can only be set once");
	}
	g_object_notify ((GObject *) self, "filters");
}


GList* unity_lens_get_categories (UnityLens* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_categories;
	return result;
}


void unity_lens_set_categories (UnityLens* self, GList* value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_categories == NULL) {
		__g_list_free__g_object_unref0_0 (self->priv->_categories);
		self->priv->_categories = NULL;
		{
			GList* cat_collection;
			GList* cat_it;
			cat_collection = value;
			for (cat_it = cat_collection; cat_it != NULL; cat_it = cat_it->next) {
				UnityCategory* _tmp0_;
				UnityCategory* cat;
				_tmp0_ = _g_object_ref0 ((UnityCategory*) cat_it->data);
				cat = _tmp0_;
				{
					UnityCategory* _tmp1_;
					_tmp1_ = _g_object_ref0 (cat);
					self->priv->_categories = g_list_prepend (self->priv->_categories, _tmp1_);
					_g_object_unref0 (cat);
				}
			}
		}
		self->priv->_categories = g_list_reverse (self->priv->_categories);
		unity_lens_impl_load_categories (self->priv->_pimpl, self->priv->_categories);
	} else {
		g_warning ("unity-lens.vala:68: Categories can only be set once");
	}
	g_object_notify ((GObject *) self, "categories");
}


static GObject * unity_lens_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityLens * self;
	UnityLensImpl* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_lens_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_LENS (obj);
	_tmp0_ = unity_lens_impl_new (self);
	_g_object_unref0 (self->priv->_pimpl);
	self->priv->_pimpl = _tmp0_;
	return obj;
}


static void unity_lens_class_init (UnityLensClass * klass) {
	unity_lens_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLensPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_lens_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_lens_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_lens_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_lens_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_VISIBLE, g_param_spec_boolean ("visible", "visible", "visible", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_SEARCHING, g_param_spec_boolean ("searching", "searching", "searching", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_EXPORTED, g_param_spec_boolean ("exported", "exported", "exported", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_SEARCH_IN_GLOBAL, g_param_spec_boolean ("search-in-global", "search-in-global", "search-in-global", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_SEARCH_HINT, g_param_spec_string ("search-hint", "search-hint", "search-hint", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_FILTERS, g_param_spec_pointer ("filters", "filters", "filters", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LENS_CATEGORIES, g_param_spec_pointer ("categories", "categories", "categories", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_lens_instance_init (UnityLens * self) {
	self->priv = UNITY_LENS_GET_PRIVATE (self);
	self->priv->_active = FALSE;
	self->priv->_visible = TRUE;
	self->priv->_searching = FALSE;
	self->priv->_exported = FALSE;
	self->priv->_search_in_global = TRUE;
	self->priv->_categories = NULL;
	self->priv->_filters = NULL;
}


static void unity_lens_finalize (GObject* obj) {
	UnityLens * self;
	self = UNITY_LENS (obj);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_dbus_path);
	_g_free0 (self->priv->_search_hint);
	_g_object_unref0 (self->priv->_pimpl);
	__g_list_free__g_object_unref0_0 (self->priv->_categories);
	__g_list_free__g_object_unref0_0 (self->priv->_filters);
	G_OBJECT_CLASS (unity_lens_parent_class)->finalize (obj);
}


GType unity_lens_get_type (void) {
	static volatile gsize unity_lens_type_id__volatile = 0;
	if (g_once_init_enter (&unity_lens_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLensClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_lens_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLens), 0, (GInstanceInitFunc) unity_lens_instance_init, NULL };
		GType unity_lens_type_id;
		unity_lens_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityLens", &g_define_type_info, 0);
		g_once_init_leave (&unity_lens_type_id__volatile, unity_lens_type_id);
	}
	return unity_lens_type_id__volatile;
}


static void _vala_unity_lens_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLens * self;
	self = UNITY_LENS (object);
	switch (property_id) {
		case UNITY_LENS_ACTIVE:
		g_value_set_boolean (value, unity_lens_get_active (self));
		break;
		case UNITY_LENS_VISIBLE:
		g_value_set_boolean (value, unity_lens_get_visible (self));
		break;
		case UNITY_LENS_SEARCHING:
		g_value_set_boolean (value, unity_lens_get_searching (self));
		break;
		case UNITY_LENS_EXPORTED:
		g_value_set_boolean (value, unity_lens_get_exported (self));
		break;
		case UNITY_LENS_SEARCH_IN_GLOBAL:
		g_value_set_boolean (value, unity_lens_get_search_in_global (self));
		break;
		case UNITY_LENS_ID:
		g_value_set_string (value, unity_lens_get_id (self));
		break;
		case UNITY_LENS_DBUS_PATH:
		g_value_set_string (value, unity_lens_get_dbus_path (self));
		break;
		case UNITY_LENS_SEARCH_HINT:
		g_value_set_string (value, unity_lens_get_search_hint (self));
		break;
		case UNITY_LENS_FILTERS:
		g_value_set_pointer (value, unity_lens_get_filters (self));
		break;
		case UNITY_LENS_CATEGORIES:
		g_value_set_pointer (value, unity_lens_get_categories (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_lens_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityLens * self;
	self = UNITY_LENS (object);
	switch (property_id) {
		case UNITY_LENS_ACTIVE:
		unity_lens_set_active (self, g_value_get_boolean (value));
		break;
		case UNITY_LENS_VISIBLE:
		unity_lens_set_visible (self, g_value_get_boolean (value));
		break;
		case UNITY_LENS_SEARCHING:
		unity_lens_set_searching (self, g_value_get_boolean (value));
		break;
		case UNITY_LENS_EXPORTED:
		unity_lens_set_exported (self, g_value_get_boolean (value));
		break;
		case UNITY_LENS_SEARCH_IN_GLOBAL:
		unity_lens_set_search_in_global (self, g_value_get_boolean (value));
		break;
		case UNITY_LENS_ID:
		unity_lens_set_id (self, g_value_get_string (value));
		break;
		case UNITY_LENS_DBUS_PATH:
		unity_lens_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_LENS_SEARCH_HINT:
		unity_lens_set_search_hint (self, g_value_get_string (value));
		break;
		case UNITY_LENS_FILTERS:
		unity_lens_set_filters (self, g_value_get_pointer (value));
		break;
		case UNITY_LENS_CATEGORIES:
		unity_lens_set_categories (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



