#include <gio/gio.h>

#include "unity-webapps-interest-tracker.h"
#include "unity-webapps-window-tracker-mock.h"

typedef struct _InterestTestFixture {
  UnityWebappsInterestManager *interest_manager;
  UnityWebappsInterestTracker *interest_tracker;
  UnityWebappsWindowTracker *window_tracker;

  gint id1;
  gint id2;
  gint id3;
} InterestTestFixture;


static void
setup_fixture_scenario_one (InterestTestFixture *fixture, gconstpointer user_data)
{
  UnityWebappsInterestManager *manager;
  UnityWebappsWindowTracker *tracker;
  gint most_recent;
  guint64 active_win;

  fixture->interest_manager = unity_webapps_interest_manager_new ();
  
  fixture->id1 = unity_webapps_interest_manager_add_interest (fixture->interest_manager, ":1");
  fixture->id2 = unity_webapps_interest_manager_add_interest (fixture->interest_manager, ":2");
  fixture->id3 = unity_webapps_interest_manager_add_interest (fixture->interest_manager, ":3");
  
  fixture->window_tracker = UNITY_WEBAPPS_WINDOW_TRACKER (unity_webapps_window_tracker_mock_new ());
  
  fixture->interest_tracker = unity_webapps_interest_tracker_new (fixture->window_tracker,
								  fixture->interest_manager);
  
  g_object_get (fixture->interest_tracker,
		"interest-manager", &manager,
		"window-tracker", &tracker,
		"most-recent-interest", &most_recent,
		NULL);
  g_object_get (fixture->window_tracker,
		"active-window-id", &active_win,
		NULL);

  g_assert (manager == fixture->interest_manager);
  g_assert (tracker == fixture->window_tracker);
  g_assert (most_recent == -1);
  
  unity_webapps_interest_manager_set_interest_window (fixture->interest_manager,
						      fixture->id1, 1);
  unity_webapps_interest_manager_set_interest_window (fixture->interest_manager,
						      fixture->id2, 2);
  unity_webapps_interest_manager_set_interest_window (fixture->interest_manager,
						      fixture->id3, 3);
  
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker),
						       1);
}

#define ASSERTMR(i) g_assert(unity_webapps_interest_tracker_get_most_recent_interest (fixture->interest_tracker) == i)

static void
test_scenario_1_test1 (InterestTestFixture *fixture, gconstpointer user_data)
{
  unity_webapps_interest_manager_set_interest_is_active (fixture->interest_manager,
							 fixture->id1, TRUE);
  ASSERTMR(fixture->id1);
}

static void
test_scenario_1_test2 (InterestTestFixture *fixture, gconstpointer user_data)
{
  unity_webapps_interest_manager_set_interest_is_active (fixture->interest_manager,
							 fixture->id1, FALSE);
  unity_webapps_interest_manager_set_interest_is_active (fixture->interest_manager,
							 fixture->id2, TRUE);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 2);
  ASSERTMR(fixture->id2);
}

static void
test_scenario_1_test3 (InterestTestFixture *fixture, gconstpointer user_data)
{
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 7);
  unity_webapps_interest_manager_set_interest_is_active (fixture->interest_manager,
							 fixture->id2, TRUE);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 2);
  ASSERTMR(fixture->id2);
}

static void
test_scenario_1_test4 (InterestTestFixture *fixture, gconstpointer user_data)
{
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 7);
  unity_webapps_interest_manager_set_interest_is_active (fixture->interest_manager,
							 fixture->id2, TRUE);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 2);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 3);
  unity_webapps_interest_manager_set_interest_is_active (fixture->interest_manager,
							 fixture->id3, TRUE);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 2);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 1);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 2);
  ASSERTMR(fixture->id2);
}

static void
test_scenario_1_test5 (InterestTestFixture *fixture, gconstpointer user_data)
{
  unity_webapps_interest_manager_set_interest_is_active (fixture->interest_manager,
							 fixture->id1, TRUE);
  unity_webapps_interest_manager_set_interest_is_active (fixture->interest_manager,
							 fixture->id2, TRUE);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 2);
  ASSERTMR(fixture->id2);
}

static void
test_scenario_1_test6 (InterestTestFixture *fixture, gconstpointer user_data)
{
  unity_webapps_interest_manager_set_interest_is_active (fixture->interest_manager,
							 fixture->id1, TRUE);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 8);
  ASSERTMR(fixture->id1);
  unity_webapps_window_tracker_mock_set_active_window (UNITY_WEBAPPS_WINDOW_TRACKER_MOCK (fixture->window_tracker), 1);
  ASSERTMR(fixture->id1);
}

static void
teardown_fixture (InterestTestFixture *fixture, gconstpointer user_data)
{
  g_object_unref (G_OBJECT (fixture->interest_tracker));
  g_object_unref (G_OBJECT (fixture->window_tracker));
  g_object_unref (G_OBJECT (fixture->interest_manager));
}

int 
main (int argc, char **argv)
{
  g_type_init ();
  g_test_init (&argc, &argv, NULL);
  
  g_test_add("/Interest/Scenario1/InterestBecomesActiveFromTab", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_test1, teardown_fixture);
  g_test_add("/Interest/Scenario1/InterestBecomesActiveFromWindow", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_test2, teardown_fixture);
  g_test_add("/Interest/Scenario1/InterestBecomesActiveFromWindowWhileInactive", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_test3, teardown_fixture);
  g_test_add("/Interest/Scenario1/InterestBecomesActiveReturns", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_test4, teardown_fixture);
  g_test_add("/Interest/Scenario1/StealActivity", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_test5, teardown_fixture);
  g_test_add("/Interest/Scenario1/BoringWindowRestore", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_test6, teardown_fixture);


  
  return g_test_run ();
}
