#include <gio/gio.h>

#include "unity-webapps-interest-manager.h"

typedef struct _InterestTestFixture {
  UnityWebappsInterestManager *interest_manager;
  gint id1;
  gint id2;
  gint id3;
} InterestTestFixture;


static void
setup_fixture_scenario_one (InterestTestFixture *fixture, gconstpointer user_data)
{
  fixture->interest_manager = unity_webapps_interest_manager_new ();
  
  fixture->id1 = unity_webapps_interest_manager_add_interest (fixture->interest_manager, ":1");
  fixture->id2 = unity_webapps_interest_manager_add_interest (fixture->interest_manager, ":2");
  fixture->id3 = unity_webapps_interest_manager_add_interest (fixture->interest_manager, ":3");
  
  unity_webapps_interest_manager_set_interest_location (fixture->interest_manager, fixture->id1, "Foo");
  unity_webapps_interest_manager_set_interest_location (fixture->interest_manager, fixture->id2, "Bar");
}

static void
test_scenario_1_list_interest (InterestTestFixture *fixture, gconstpointer user_data)
{
  GVariant *interests;
  
  interests = unity_webapps_interest_manager_list_interests (fixture->interest_manager);
  
  g_variant_unref (interests);
}

static void
test_scenario_1_interest_owners (InterestTestFixture *fixture, gconstpointer user_data)
{
  g_assert_cmpstr (unity_webapps_interest_manager_get_interest_owner (fixture->interest_manager, fixture->id1), ==, ":1");
  g_assert_cmpstr (unity_webapps_interest_manager_get_interest_owner (fixture->interest_manager, fixture->id2), ==, ":2");
  g_assert_cmpstr (unity_webapps_interest_manager_get_interest_owner (fixture->interest_manager, fixture->id3), ==, ":3");
}

static void
test_scenario_1_interest_locations (InterestTestFixture *fixture, gconstpointer user_data)
{
  g_assert_cmpstr (unity_webapps_interest_manager_get_interest_location (fixture->interest_manager, fixture->id1), ==, "Foo");
  g_assert_cmpstr (unity_webapps_interest_manager_get_interest_location (fixture->interest_manager, fixture->id2), ==, "Bar");
}

static void
test_scenario_1_update_locations (InterestTestFixture *fixture, gconstpointer user_data)
{
  unity_webapps_interest_manager_set_interest_location (fixture->interest_manager, fixture->id1, "Baz");
  unity_webapps_interest_manager_set_interest_location (fixture->interest_manager, fixture->id1, "Baz");
}

static void
teardown_fixture (InterestTestFixture *fixture, gconstpointer user_data)
{
  unity_webapps_interest_manager_remove_interests_with_name (fixture->interest_manager, ":1");
  unity_webapps_interest_manager_remove_interests_with_name (fixture->interest_manager, ":2");
  unity_webapps_interest_manager_remove_interests_with_name (fixture->interest_manager, ":3");
  g_object_unref (G_OBJECT (fixture->interest_manager));
}


int 
main (int argc, char **argv)
{
  g_type_init ();
  g_test_init (&argc, &argv, NULL);
  
  g_test_add("/Interest/Scenario1/ListInterests", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_list_interest, teardown_fixture);
  g_test_add("/Interest/Scenario1/InterestOwners", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_interest_owners, teardown_fixture);
  g_test_add("/Interest/Scenario1/InterestLocations", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_interest_locations, teardown_fixture);
  g_test_add("/Interest/Scenario1/UpdateLocations", InterestTestFixture, NULL,
	     setup_fixture_scenario_one, test_scenario_1_update_locations, teardown_fixture);


  
  return g_test_run ();
}
