/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.BunchMap;
import org.apache.jena.mem.HashCommon;
import org.apache.jena.mem.HashedBunchMap;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.NullIterator;

public abstract class NodeToTriplesMapBase {
    public BunchMap bunchMap = new HashedBunchMap();
    protected int size = 0;
    protected final Triple.Field indexField;
    protected final Triple.Field f2;
    protected final Triple.Field f3;

    public NodeToTriplesMapBase(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        this.indexField = indexField;
        this.f2 = f2;
        this.f3 = f3;
    }

    public abstract boolean add(Triple var1);

    public abstract boolean remove(Triple var1);

    public abstract Iterator<Triple> iterator(Object var1, HashCommon.NotifyEmpty var2);

    public abstract boolean contains(Triple var1);

    public abstract boolean containsBySameValueAs(Triple var1);

    public final Iterator<Object> domain() {
        return this.bunchMap.keyIterator();
    }

    protected final Object getIndexField(Triple t) {
        return this.indexField.getField(t).getIndexingValue();
    }

    public void clear() {
        this.bunchMap.clear();
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void removedOneViaIterator() {
        --this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public abstract ExtendedIterator<Triple> iterator(Node var1, Node var2, Node var3);

    public abstract Iterator<Triple> iteratorForIndexed(Object var1);

    public ExtendedIterator<Triple> iterateAll() {
        final Iterator<Object> nodes = this.domain();
        return new NiceIterator<Triple>(){
            private Iterator<Triple> current = NullIterator.instance();
            private NotifyMe emptier = new NotifyMe();

            @Override
            public Triple next() {
                if (!this.hasNext()) {
                    this.noElements("NodeToTriples iterator");
                }
                return this.current.next();
            }

            @Override
            public boolean hasNext() {
                while (!this.current.hasNext()) {
                    if (!nodes.hasNext()) {
                        return false;
                    }
                    Object next = nodes.next();
                    this.current = NodeToTriplesMapBase.this.iterator(next, this.emptier);
                }
                return true;
            }

            @Override
            public void remove() {
                this.current.remove();
            }

            class NotifyMe
            implements HashCommon.NotifyEmpty {
                NotifyMe() {
                }

                @Override
                public void emptied() {
                    nodes.remove();
                }
            }
        };
    }
}

