/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.rootdev.javardfa.EvalContext;
import net.rootdev.javardfa.ParserFactory;
import net.rootdev.javardfa.ProfileCollector;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.StatementSink;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SimpleProfileCollector
implements ProfileCollector {
    public void getProfile(String profileURI, EvalContext context) {
        try {
            XMLReader reader = ParserFactory.createReaderForFormat((StatementSink)new SimpleCollector(context), ParserFactory.Format.XHTML, Setting.OnePointOne);
            reader.parse(profileURI);
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static final class Value {
        String prefix;
        String term;
        String uri;

        Value() {
        }
    }

    static class SimpleCollector
    implements StatementSink {
        private final EvalContext context;
        private final Map<String, Value> subjToVals;

        SimpleCollector(EvalContext context) {
            this.context = context;
            this.subjToVals = new HashMap<String, Value>();
        }

        public void start() {
        }

        public void end() {
        }

        public void addObject(String subject, String predicate, String object) {
        }

        public void addLiteral(String subject, String predicate, String lex, String lang, String datatype) {
            Value val = this.subjToVals.get(subject);
            if (val == null && (predicate.equals("http://www.w3.org/ns/rdfa#prefix") || predicate.equals("http://www.w3.org/ns/rdfa#term") || predicate.equals("http://www.w3.org/ns/rdfa#uri"))) {
                val = new Value();
                this.subjToVals.put(subject, val);
            }
            if (val == null) {
                return;
            }
            if (predicate.equals("http://www.w3.org/ns/rdfa#prefix")) {
                if (val.uri != null) {
                    this.context.setPrefix(lex, val.uri);
                } else {
                    val.prefix = lex;
                }
            } else if (predicate.equals("http://www.w3.org/ns/rdfa#term")) {
                if (val.uri != null) {
                    this.context.setTerm(lex, val.uri);
                } else {
                    val.term = lex;
                }
            } else if (predicate.equals("http://www.w3.org/ns/rdfa#uri")) {
                if (val.prefix != null) {
                    this.context.setPrefix(val.prefix, lex);
                } else if (val.term != null) {
                    this.context.setTerm(val.term, lex);
                } else {
                    val.uri = lex;
                }
            }
        }

        public void addPrefix(String prefix, String uri) {
        }

        public void setBase(String base) {
        }
    }
}

