/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.Length;

public class NonNegativePixelLength
extends Length {
    private String mLength;
    private static final Pattern pixelLengthPattern = Pattern.compile("^([0-9]+(\\.[0-9]*)?|\\.[0-9]+)(px)$");

    public NonNegativePixelLength(String pixelLength) throws NumberFormatException {
        super(pixelLength);
        if (!NonNegativePixelLength.isValid(pixelLength)) {
            throw new NumberFormatException("parameter is invalid for datatype NonNegativePixelLength");
        }
    }

    @Override
    public String toString() {
        return this.mLength;
    }

    public static NonNegativePixelLength valueOf(String stringValue) throws NumberFormatException {
        return new NonNegativePixelLength(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && pixelLengthPattern.matcher(stringValue).matches();
    }
}

