/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class ODFFileFilter
implements FileFilter {
    private boolean m_bRecursive;
    private Pattern m_aExcludePattern = null;

    public ODFFileFilter(boolean bRecursive) {
        this.m_bRecursive = bRecursive;
    }

    public ODFFileFilter(String aExcludeRegExp, boolean bRecursive) {
        this.m_bRecursive = bRecursive;
        if (aExcludeRegExp != null) {
            this.m_aExcludePattern = Pattern.compile(aExcludeRegExp);
        }
    }

    @Override
    public boolean accept(File aFile) {
        return !this.exclude(aFile) && (aFile.isDirectory() ? this.m_bRecursive : this.hasODFExtension(aFile));
    }

    private boolean exclude(File aFile) {
        boolean bExclude = false;
        if (this.m_aExcludePattern != null) {
            bExclude = this.m_aExcludePattern.matcher(aFile.getAbsolutePath()).matches();
        }
        return bExclude;
    }

    private boolean hasODFExtension(File aFile) {
        String aExt;
        String aName = aFile.getName();
        int nIndex = aName.lastIndexOf(46);
        if (nIndex != -1 && aName.length() > nIndex + 1 && (aExt = aName.substring(nIndex + 1)).length() == 3) {
            return aExt.equalsIgnoreCase("odt") || aExt.equalsIgnoreCase("ods") || aExt.equalsIgnoreCase("odg") || aExt.equalsIgnoreCase("odp") || aExt.equalsIgnoreCase("odf") || aExt.equalsIgnoreCase("odc") || aExt.equalsIgnoreCase("odb") || aExt.equalsIgnoreCase("ott") || aExt.equalsIgnoreCase("ots") || aExt.equalsIgnoreCase("otg") || aExt.equalsIgnoreCase("otp") || aExt.equalsIgnoreCase("otf") || aExt.equalsIgnoreCase("otc");
        }
        return false;
    }
}

