/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.incubator.search;

import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextHeading;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextSpan;
import org.odftoolkit.odfdom.incubator.doc.text.OdfWhitespaceProcessor;
import org.odftoolkit.odfdom.incubator.search.InvalidNavigationException;
import org.odftoolkit.odfdom.incubator.search.Selection;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSelection
extends Selection {
    private String mMatchedText;
    private OdfTextParagraph mParagraph;
    private OdfTextHeading mHeading;
    private int mIndexInContainer;
    private boolean mIsInserted;

    TextSelection(String text, OdfElement containerElement, int index) {
        this.mMatchedText = text;
        if (containerElement instanceof OdfTextParagraph) {
            this.mParagraph = (OdfTextParagraph)containerElement;
        } else if (containerElement instanceof OdfTextHeading) {
            this.mHeading = (OdfTextHeading)containerElement;
        }
        this.mIndexInContainer = index;
    }

    @Override
    public OdfElement getElement() {
        return this.getContainerElement();
    }

    public OdfElement getContainerElement() {
        if (this.mParagraph != null) {
            return this.mParagraph;
        }
        return this.mHeading;
    }

    @Override
    public int getIndex() {
        return this.mIndexInContainer;
    }

    public String getText() {
        return this.mMatchedText;
    }

    private boolean validate() {
        if (this.getContainerElement() == null) {
            return false;
        }
        OdfElement container = this.getContainerElement();
        if (container == null) {
            return false;
        }
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        String content = textProcessor.getText(container);
        return content.indexOf(this.mMatchedText, this.mIndexInContainer) == this.mIndexInContainer;
    }

    @Override
    public void cut() throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement container = this.getContainerElement();
        this.delete(this.mIndexInContainer, this.mMatchedText.length(), container);
        Selection.SelectionManager.refreshAfterCut(this);
        this.mMatchedText = "";
    }

    public void applyStyle(OdfStyleBase style) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.appendStyle(index, leftLength, parentElement, style);
    }

    private void appendStyle(int fromindex, int leftLength, Node pNode, OdfStyleBase style) {
        if (fromindex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromindex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : textProcessor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromindex) {
                fromindex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                node.setNodeValue(value.substring(0, fromindex));
                int endLength = fromindex + leftLength;
                int nextLength = value.length() - endLength;
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)node.getOwnerDocument());
                Node newNode = null;
                if (nextLength >= 0) {
                    textSpan.setTextContent(value.substring(fromindex, endLength));
                    newNode = node.cloneNode(true);
                    newNode.setNodeValue(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    textSpan.setTextContent(value.substring(fromindex, value.length()));
                    leftLength = endLength - value.length();
                }
                textSpan.setProperties(style.getStyleProperties());
                if (nextNode != null) {
                    parNode.insertBefore(textSpan, nextNode);
                    if (newNode != null) {
                        parNode.insertBefore(newNode, nextNode);
                    }
                } else {
                    parNode.appendChild(textSpan);
                    if (newNode != null) {
                        parNode.appendChild(newNode);
                    }
                }
                fromindex = 0;
                if (nextNode != null) {
                    node = nextNode;
                    continue;
                }
                node = textSpan;
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromindex));
                leftLength -= nodeLength - fromindex;
                fromindex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromindex = 0;
                --leftLength;
                continue;
            }
            this.appendStyle(fromindex, leftLength, node, style);
            int length = fromindex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromindex = 0;
        }
    }

    public void replaceWith(String newText) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.delete(index, leftLength, parentElement);
        OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)parentElement.getOwnerDocument());
        textSpan.addContentWhitespace(newText);
        this.mIsInserted = false;
        this.insertSpan(textSpan, index, parentElement);
        this.optimize(parentElement);
        int offset = newText.length() - leftLength;
        Selection.SelectionManager.refresh(this.getContainerElement(), offset, index + this.getText().length());
        this.mMatchedText = newText;
    }

    @Override
    public void pasteAtFrontOf(Selection positionItem) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        int indexOfNew = 0;
        OdfElement newElement = positionItem.getElement();
        if (positionItem instanceof TextSelection) {
            indexOfNew = ((TextSelection)positionItem).getIndex();
            newElement = ((TextSelection)positionItem).getContainerElement();
        }
        OdfTextSpan textSpan = this.getSpan((OdfFileDom)positionItem.getElement().getOwnerDocument());
        this.mIsInserted = false;
        this.insertSpan(textSpan, indexOfNew, newElement);
        this.adjustStyle(newElement, textSpan, null);
        Selection.SelectionManager.refreshAfterPasteAtFrontOf(this, positionItem);
    }

    @Override
    public void pasteAtEndOf(Selection positionItem) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        int indexOfNew = 0;
        OdfElement newElement = positionItem.getElement();
        if (positionItem instanceof TextSelection) {
            indexOfNew = ((TextSelection)positionItem).getIndex() + ((TextSelection)positionItem).getText().length();
            newElement = ((TextSelection)positionItem).getContainerElement();
        }
        OdfTextSpan textSpan = this.getSpan((OdfFileDom)positionItem.getElement().getOwnerDocument());
        this.mIsInserted = false;
        this.insertSpan(textSpan, indexOfNew, newElement);
        this.adjustStyle(newElement, textSpan, null);
        Selection.SelectionManager.refreshAfterPasteAtEndOf(this, positionItem);
    }

    public void addHref(URL url) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.addHref(index, leftLength, parentElement, url.toString());
    }

    private void addHref(int fromindex, int leftLength, Node pNode, String href) {
        if (fromindex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromindex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : textProcessor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromindex) {
                fromindex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                node.setNodeValue(value.substring(0, fromindex));
                int endLength = fromindex + leftLength;
                int nextLength = value.length() - endLength;
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                TextAElement textLink = new TextAElement((OdfFileDom)node.getOwnerDocument());
                Node newNode = null;
                if (nextLength >= 0) {
                    textLink.setTextContent(value.substring(fromindex, endLength));
                    newNode = node.cloneNode(true);
                    newNode.setNodeValue(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    textLink.setTextContent(value.substring(fromindex, value.length()));
                    leftLength = endLength - value.length();
                }
                textLink.setXlinkTypeAttribute("simple");
                textLink.setXlinkHrefAttribute(href);
                if (nextNode != null) {
                    parNode.insertBefore(textLink, nextNode);
                    if (newNode != null) {
                        parNode.insertBefore(newNode, nextNode);
                    }
                } else {
                    parNode.appendChild(textLink);
                    if (newNode != null) {
                        parNode.appendChild(newNode);
                    }
                }
                fromindex = 0;
                if (nextNode != null) {
                    node = nextNode;
                    continue;
                }
                node = textLink;
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromindex));
                leftLength -= nodeLength - fromindex;
                fromindex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromindex = 0;
                --leftLength;
                continue;
            }
            this.addHref(fromindex, leftLength, node, href);
            int length = fromindex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromindex = 0;
        }
    }

    private void delete(int fromindex, int leftLength, Node pNode) {
        if (fromindex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromindex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : textProcessor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromindex) {
                fromindex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromindex));
                int endLength = fromindex + leftLength;
                int nextLength = value.length() - endLength;
                fromindex = 0;
                if (nextLength >= 0) {
                    buffer.append(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    leftLength = endLength - value.length();
                }
                node.setNodeValue(buffer.toString());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromindex));
                leftLength -= nodeLength - fromindex;
                fromindex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromindex = 0;
                --leftLength;
                continue;
            }
            this.delete(fromindex, leftLength, node);
            int length = fromindex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromindex = 0;
        }
    }

    @Override
    protected void refreshAfterFrontalDelete(Selection deleteItem) {
        if (deleteItem instanceof TextSelection) {
            this.mIndexInContainer -= ((TextSelection)deleteItem).getText().length();
        }
    }

    @Override
    protected void refreshAfterFrontalInsert(Selection pasteItem) {
        if (pasteItem instanceof TextSelection) {
            this.mIndexInContainer += ((TextSelection)pasteItem).getText().length();
        }
    }

    @Override
    protected void refresh(int offset) {
        this.mIndexInContainer += offset;
    }

    public String toString() {
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        return "[" + this.mMatchedText + "] started from " + this.mIndexInContainer + " in paragraph:" + textProcessor.getText(this.getContainerElement());
    }

    private OdfTextSpan getSpan(OdfFileDom ownerDoc) {
        OdfElement parentElement = this.getContainerElement();
        if (parentElement != null) {
            Node copyParentNode = parentElement.cloneNode(true);
            if (ownerDoc != parentElement.getOwnerDocument()) {
                copyParentNode = ownerDoc.adoptNode(copyParentNode);
            }
            OdfTextSpan textSpan = new OdfTextSpan(ownerDoc);
            int sIndex = this.mIndexInContainer;
            int eIndex = sIndex + this.mMatchedText.length();
            OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
            this.delete(eIndex, textProcessor.getText(copyParentNode).length() - eIndex, copyParentNode);
            this.delete(0, sIndex, copyParentNode);
            this.optimize(copyParentNode);
            for (Node childNode = copyParentNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                textSpan.appendChild(childNode.cloneNode(true));
            }
            if (copyParentNode instanceof OdfStylableElement) {
                this.applyTextStyleProperties(this.getTextStylePropertiesDeep((OdfStylableElement)copyParentNode), textSpan);
            }
            return textSpan;
        }
        return null;
    }

    private void optimize(Node pNode) {
        OdfWhitespaceProcessor textProcess = new OdfWhitespaceProcessor();
        Node node = pNode.getFirstChild();
        while (node != null) {
            Node nextNode = node.getNextSibling();
            if (node instanceof OdfTextSpan) {
                if (textProcess.getText(node).length() == 0) {
                    node.getParentNode().removeChild(node);
                } else {
                    this.optimize(node);
                }
            }
            node = nextNode;
        }
    }

    private void applyTextStyleProperties(Map<OdfStyleProperty, String> styleMap, OdfStylableElement toElement) {
        if (styleMap != null) {
            OdfStyle resultStyleElement = toElement.getAutomaticStyles().newStyle(OdfStyleFamily.Text);
            for (Map.Entry<OdfStyleProperty, String> entry : styleMap.entrySet()) {
                if (toElement.hasProperty(entry.getKey())) {
                    resultStyleElement.setProperty(entry.getKey(), toElement.getProperty(entry.getKey()));
                    continue;
                }
                resultStyleElement.setProperty(entry.getKey(), entry.getValue());
            }
            toElement.setStyleName(resultStyleElement.getStyleNameAttribute());
        }
    }

    private void insertSpan(OdfTextSpan textSpan, int fromindex, Node pNode) {
        if (fromindex < 0) {
            fromindex = 0;
        }
        if (fromindex == 0 && this.mIsInserted) {
            return;
        }
        OdfWhitespaceProcessor textProcessor = new OdfWhitespaceProcessor();
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromindex <= 0 && this.mIsInserted) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
                if (fromindex != 0 && nodeLength < fromindex) {
                    fromindex -= nodeLength;
                    continue;
                }
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromindex));
                node.setNodeValue(buffer.toString());
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                Node newNode = node.cloneNode(true);
                newNode.setNodeValue(value.substring(fromindex, value.length()));
                if (nextNode != null) {
                    parNode.insertBefore(textSpan, nextNode);
                    parNode.insertBefore(newNode, nextNode);
                } else {
                    parNode.appendChild(textSpan);
                    parNode.appendChild(newNode);
                }
                this.mIsInserted = true;
                return;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                try {
                    nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                }
                catch (Exception e) {
                    nodeLength = 1;
                }
                fromindex -= nodeLength;
                continue;
            }
            if (node.getLocalName().equals("line-break")) {
                nodeLength = 1;
                --fromindex;
                continue;
            }
            if (node.getLocalName().equals("tab")) {
                nodeLength = 1;
                --fromindex;
                continue;
            }
            nodeLength = textProcessor.getText(node).length();
            this.insertSpan(textSpan, fromindex, node);
            fromindex -= nodeLength;
        }
    }

    private void adjustStyle(Node parentNode, OdfTextSpan textSpan, Map<OdfStyleProperty, String> styleMap) {
        if (parentNode instanceof OdfStylableElement) {
            OdfStylableElement pStyleNode = (OdfStylableElement)parentNode;
            if (styleMap == null) {
                styleMap = this.getTextStylePropertiesDeep(pStyleNode);
            }
            for (Node node = parentNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() == 3) {
                    if (node.getTextContent().length() <= 0) continue;
                    Node nextNode = node.getNextSibling();
                    OdfTextSpan span = new OdfTextSpan((OdfFileDom)node.getOwnerDocument());
                    span.appendChild(node);
                    if (nextNode != null) {
                        parentNode.insertBefore(span, nextNode);
                    } else {
                        parentNode.appendChild(span);
                    }
                    node = span;
                    this.applyTextStyleProperties(styleMap, (OdfStylableElement)node);
                    continue;
                }
                if (!(node instanceof OdfStylableElement) || node.equals(textSpan)) continue;
                Map<OdfStyleProperty, String> styles = this.getTextStylePropertiesDeep(pStyleNode);
                Map<OdfStyleProperty, String> styles1 = this.getTextStylePropertiesDeep((OdfStylableElement)node);
                if (styles == null) {
                    styles = styles1;
                } else if (styles1 != null) {
                    styles.putAll(styles1);
                }
                short comp = node.compareDocumentPosition(textSpan);
                if ((comp & 0x10) > 0) {
                    this.adjustStyle(node, textSpan, styles);
                    continue;
                }
                this.applyTextStyleProperties(styles, (OdfStylableElement)node);
            }
            pStyleNode.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name");
        }
    }

    private Map<OdfStyleProperty, String> getTextStyleProperties(OdfStylableElement element) {
        String styleName = element.getStyleName();
        OdfStyleBase styleElement = element.getAutomaticStyles().getStyle(styleName, element.getStyleFamily());
        if (styleElement == null) {
            styleElement = element.getDocumentStyle();
        }
        if (styleElement != null) {
            if (styleElement.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties) == null && styleElement.getPropertiesElement(OdfStylePropertiesSet.TextProperties) == null) {
                styleElement = ((OdfDocument)((OdfFileDom)styleElement.getOwnerDocument()).getDocument()).getDocumentStyles().getDefaultStyle(styleElement.getFamily());
            }
            TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
            OdfStyleFamily family = OdfStyleFamily.Text;
            if (family != null) {
                for (OdfStyleProperty property : family.getProperties()) {
                    if (!styleElement.hasProperty(property)) continue;
                    result.put(property, styleElement.getProperty(property));
                }
            }
            return result;
        }
        return null;
    }

    private Map<OdfStyleProperty, String> getTextStylePropertiesDeep(OdfStylableElement element) {
        String styleName = element.getStyleName();
        OdfStyleBase styleElement = element.getAutomaticStyles().getStyle(styleName, element.getStyleFamily());
        if (styleElement == null) {
            styleElement = element.getDocumentStyle();
        }
        TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
        while (styleElement != null) {
            OdfStyleFamily family;
            if (styleElement.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties) == null && styleElement.getPropertiesElement(OdfStylePropertiesSet.TextProperties) == null) {
                styleElement = ((OdfDocument)((OdfFileDom)styleElement.getOwnerDocument()).getDocument()).getDocumentStyles().getDefaultStyle(styleElement.getFamily());
            }
            if ((family = OdfStyleFamily.Text) != null) {
                for (OdfStyleProperty property : family.getProperties()) {
                    if (!styleElement.hasProperty(property)) continue;
                    result.put(property, styleElement.getProperty(property));
                }
            }
            styleElement = styleElement.getParentStyle();
        }
        return result;
    }
}

