/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_WINACCESSIBILITY_INC_ACCCONTAINEREVENTLISTENER_HXX
#define INCLUDED_WINACCESSIBILITY_INC_ACCCONTAINEREVENTLISTENER_HXX

#include <stdio.h>
#include "AccEventListener.hxx"
#include <com/sun/star/accessibility/XAccessibleEventListener.hpp>
#include <com/sun/star/accessibility/XAccessible.hpp>


/**
 * AccContainerEventListener is inherited from AccEventListener. It handles the evnets
 * generated by container controls. The accessible roles are: CANVAS, COMBO_BOX, DOCUMENT,
 * EMBEDDED_OBJECT, END_NOTE, FILLER, FOOTNOTE, FOOTER, GRAPHIC, HEADER, LAYERED_PANE,
 * MENU_BAR, POPUP_MENU, OPTION_PANE, PAGE_TAB, PAGE_TAB_LIST, PANEL, SCROLL_PANE, SPLIT_PANE,
 * STATUS_BAR, TABLE_CELL, TEXT_FRAME, TOOL_BAR, VIEW_PORT.
 * It defines the procedure of specific event handling related with containsers and provides
 * the detailed support for some related methods.
 */
class AccContainerEventListener: public AccEventListener
{
public:
    AccContainerEventListener(css::accessibility::XAccessible* pAcc, AccObjectManagerAgent* Agent);
    virtual ~AccContainerEventListener();

    //AccessibleEventListener
    virtual void SAL_CALL notifyEvent( const css::accessibility::AccessibleEventObject& aEvent ) throw (css::uno::RuntimeException) override;

    //for child changed event
    virtual void HandleChildChangedEvent(
            css::uno::Any oldValue, css::uno::Any newValue);

    //for selection changed event
    virtual void HandleSelectionChangedEvent(
            const css::uno::Any &oldValue, const css::uno::Any &newValue);

    //for all children changed event
    virtual void HandleAllChildrenChangedEvent();

    //for text changed event
    virtual void HandleTextChangedEvent(
            css::uno::Any oldValue, css::uno::Any newValue);
    virtual void HandleStateChangedEvent(
            css::uno::Any oldValue, css::uno::Any newValue) override;

    //for value changed event
    virtual void HandleValueChangedEvent(
            css::uno::Any oldValue, css::uno::Any newValue);

    //state changed
    virtual void SetComponentState(short state, bool enable) override;
    virtual void FireStatePropertyChange(short state, bool set) override;
    virtual void FireStateFocusedChange(bool enable) override;
    virtual bool IsEditable(css::uno::Reference<css::accessibility::XAccessibleContext> xContext);

    // update all children's state
    void UpdateAllChildrenState( css::accessibility::XAccessible* pXAccessible);

    bool NotifyChildEvent(short nWinEvent, const css::uno::Any &Value);

    virtual void HandleSelectionChangedAddEvent(
            const css::uno::Any &oldValue, const css::uno::Any &newValue);
    virtual void HandleSelectionChangedRemoveEvent(
            const css::uno::Any &oldValue, const css::uno::Any &newValue);
    virtual void HandleSelectionChangedWithinEvent(
            const css::uno::Any &oldValue, const css::uno::Any &newValue);

    virtual void HandlePageChangedEvent(
            const css::uno::Any &oldValue, const css::uno::Any &newValue);

    virtual void HandleSectionChangedEvent(
            const css::uno::Any &oldValue, const css::uno::Any &newValue);
    virtual void HandleColumnChangedEvent(
            const css::uno::Any &oldValue, const css::uno::Any &newValue);

    //for name changed event
    virtual void HandleNameChangedEvent(css::uno::Any name) override;
};

#endif // INCLUDED_WINACCESSIBILITY_INC_ACCCONTAINEREVENTLISTENER_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
