/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef SD_SDCOMMANDS_HRC
#define SD_SDCOMMANDS_HRC

#define CMD_SID_OBJECT_MIRROR                       ".uno:Mirror"
#define CMD_SID_ANIMATION_EFFECTS                   ".uno:AnimationEffects"
#define CMD_SID_ANIMATION_OBJECTS                   ".uno:AnimationObjects"
#define CMD_SID_MOREBACK                            ".uno:Backward"
#define CMD_SID_BEFORE_OBJ                          ".uno:BeforeObject"
#define CMD_SID_BEHIND_OBJ                          ".uno:BehindObject"
#define CMD_SID_BREAK                               ".uno:Break"
#define CMD_SID_CAPTUREPOINT                        ".uno:CapturePoint"
#define CMD_SID_CHANGEBEZIER                        ".uno:ChangeBezier"
#define CMD_SID_CHANGEPOLYGON                       ".uno:ChangePolygon"
#define CMD_SID_OBJECT_CLOSE                        ".uno:CloseObject"
#define CMD_SID_COMBINE                             ".uno:Combine"
#define CMD_SID_CONNECT                             ".uno:Connect"
#define CMD_SID_CONNECTION_DLG                      ".uno:ConnectorAttributes"
#define CMD_SID_CONVERT_TO_CONTOUR                  ".uno:convert_to_contour"
#define CMD_SID_CONVERT_TO_3D                       ".uno:ConvertInto3D"
#define CMD_SID_CONVERT_TO_3D_LATHE_FAST            ".uno:ConvertInto3DLatheFast"
#define CMD_SID_CONVERT_TO_BITMAP                   ".uno:ConvertIntoBitmap"
#define CMD_SID_CONVERT_TO_METAFILE                 ".uno:ConvertIntoMetaFile"
#define CMD_SID_CONVERT_TO_1BIT_MATRIX              ".uno:ConvertTo1BitMatrix"
#define CMD_SID_CONVERT_TO_1BIT_THRESHOLD           ".uno:ConvertTo1BitThreshold"
#define CMD_SID_CONVERT_TO_4BIT_COLORS              ".uno:ConvertTo4BitColors"
#define CMD_SID_CONVERT_TO_4BIT_GRAYS               ".uno:ConvertTo4BitGrays"
#define CMD_SID_CONVERT_TO_8BIT_COLORS              ".uno:ConvertTo8BitColors"
#define CMD_SID_CONVERT_TO_8BIT_GRAYS               ".uno:ConvertTo8BitGrays"
#define CMD_SID_CONVERT_TO_24BIT                    ".uno:ConvertToTrueColor"
#define CMD_SID_COPYOBJECTS                         ".uno:CopyObjects"
#define CMD_SID_CUSTOMSHOW_DLG                      ".uno:CustomShowDialog"
#define CMD_SID_DELETE_LAYER                        ".uno:DeleteLayer"
#define CMD_SID_DELETE_PAGE                         ".uno:DeletePage"
#define CMD_SID_DELETE_SNAPITEM                     ".uno:DeleteSnapItem"
#define CMD_SID_DIAMODE                             ".uno:DiaMode"
#define CMD_SID_DISMANTLE                           ".uno:Dismantle"
#define CMD_SID_DRAWINGMODE                         ".uno:DrawingMode"
#define CMD_SID_CUSTOM_ANIMATION_PANEL              ".uno:CustomAnimation"
#define CMD_SID_MOREFRONT                           ".uno:Forward"
#define CMD_SID_GLUE_ESCDIR_BOTTOM                  ".uno:GlueEscapeDirectionBottom"
#define CMD_SID_GLUE_ESCDIR_LEFT                    ".uno:GlueEscapeDirectionLeft"
#define CMD_SID_GLUE_ESCDIR_RIGHT                   ".uno:GlueEscapeDirectionRight"
#define CMD_SID_GLUE_ESCDIR_TOP                     ".uno:GlueEscapeDirectionTop"
#define CMD_SID_GLUE_HORZALIGN_CENTER               ".uno:GlueHorzAlignCenter"
#define CMD_SID_GLUE_HORZALIGN_LEFT                 ".uno:GlueHorzAlignLeft"
#define CMD_SID_GLUE_HORZALIGN_RIGHT                ".uno:GlueHorzAlignRight"
#define CMD_SID_GLUE_INSERT_POINT                   ".uno:GlueInsertPoint"
#define CMD_SID_GLUE_PERCENT                        ".uno:GluePercent"
#define CMD_SID_GLUE_VERTALIGN_BOTTOM               ".uno:GlueVertAlignBottom"
#define CMD_SID_GLUE_VERTALIGN_CENTER               ".uno:GlueVertAlignCenter"
#define CMD_SID_GLUE_VERTALIGN_TOP                  ".uno:GlueVertAlignTop"
#define CMD_SID_GRID_FRONT                          ".uno:GridFront"
#define CMD_SID_HANDOUTMODE                         ".uno:HandoutMode"
#define CMD_SID_HELPLINES_FRONT                     ".uno:HelplinesFront"
#define CMD_SID_HELPLINES_USE                       ".uno:HelplinesUse"
#define CMD_SID_HELPLINES_VISIBLE                   ".uno:HelplinesVisible"
#define CMD_SID_HIDE_SLIDE                          ".uno:HideSlide"
#define CMD_SID_SHOW_SLIDE                          ".uno:ShowSlide"
#define CMD_SID_INSERTLAYER                         ".uno:InsertLayer"
#define CMD_SID_INSERTPAGE                          ".uno:InsertPage"
#define CMD_SID_DUPLICATE_PAGE                      ".uno:DuplicatePage"
#define CMD_SID_MEASURE_DLG                         ".uno:MeasureAttributes"
#define CMD_SID_HORIZONTAL                          ".uno:MirrorHorz"
#define CMD_SID_VERTICAL                            ".uno:MirrorVert"
#define CMD_SID_MODIFYLAYER                         ".uno:ModifyLayer"
#define CMD_SID_MODIFYPAGE                          ".uno:ModifyPage"
#define CMD_SID_PRESENTATIONOBJECT                  ".uno:ModifyPresentationObject"
#define CMD_SID_POLYGON_MORPHING                    ".uno:Morphing"
#define CMD_SID_NAME_GROUP                          ".uno:NameGroup"
#define CMD_SID_OBJECT_TITLE_DESCRIPTION            ".uno:ObjectTitleDescription"
#define CMD_SID_CONNECTION_NEW_ROUTING              ".uno:NewRouting"
#define CMD_SID_NOTESMODE                           ".uno:NotesMode"
#define CMD_SID_POSITION                            ".uno:ObjectPosition"
#define CMD_SID_ORIGINAL_SIZE                       ".uno:OriginalSize"
#define CMD_SID_OUTLINEMODE                         ".uno:OutlineMode"
#define CMD_SID_OUTLINE_TEXT_AUTOFIT                ".uno.OutlineTextAutofit"
#define CMD_SID_PAGESETUP                           ".uno:PageSetup"
#define CMD_SID_PRESENTATION                        ".uno:Presentation"
#define CMD_SID_REMOTE_DLG                          ".uno:Remote"
#define CMD_SID_PRESENTATION_LAYOUT                 ".uno:PresentationLayout"
#define CMD_SID_RENAMELAYER                         ".uno:RenameLayer"
#define CMD_SID_RENAMEPAGE                          ".uno:RenamePage"
#define CMD_SID_REVERSE_ORDER                       ".uno:ReverseOrder"
#define CMD_SID_SET_SNAPITEM                        ".uno:SetSnapItem"
#define CMD_SID_SLIDE_TRANSITIONS_PANEL             ".uno:SlideChangeWindow"
#define CMD_SID_TEXTATTR_DLG                        ".uno:TextAttributes"
#define CMD_SID_INSERT_MASTER_PAGE                  ".uno:InsertMasterPage"
#define CMD_SID_DELETE_MASTER_PAGE                  ".uno:DeleteMasterPage"
#define CMD_SID_RENAME_MASTER_PAGE                  ".uno:RenameMasterPage"
#define CMD_SID_SELECT_BACKGROUND                   ".uno:SelectBackground"
#define CMD_SID_DISPLAY_MASTER_BACKGROUND           ".uno:DisplayMasterBackground"
#define CMD_SID_DISPLAY_MASTER_OBJECTS              ".uno:DisplayMasterObjects"
#define CMD_SID_TABLE_DISTRIBUTE_COLUMNS            ".uno:DistributeColumns"
#define CMD_SID_TABLE_DISTRIBUTE_ROWS               ".uno:DistributeRows"
#define CMD_SID_TP_APPLY_TO_ALL_SLIDES              ".uno:TaskPaneApplyToAllSlides"
#define CMD_SID_TP_APPLY_TO_SELECTED_SLIDES         ".uno:TaskPaneApplyToSelectedSlides"
#define CMD_SID_TP_SHOW_SMALL_PREVIEW               ".uno:TaskPaneShowSmallPreview"
#define CMD_SID_TP_SHOW_LARGE_PREVIEW               ".uno:TaskPaneShowLargePreview"
#define CMD_SID_TP_EDIT_MASTER                      ".uno:TaskPaneEditMaster"
#define CMD_SID_INSERTPAGE_LAYOUT_MENU              ".uno:TaskPaneInsertPage"

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
