// Copyright 2017 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/cxfa_reason.h"

#include "fxjs/xfa/cjx_reason.h"
#include "third_party/base/ptr_util.h"

namespace {

const CXFA_Node::AttributeData kReasonAttributeData[] = {
    {XFA_Attribute::Id, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Name, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Use, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Usehref, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Unknown, XFA_AttributeType::Integer, nullptr}};

constexpr wchar_t kReasonName[] = L"reason";

}  // namespace

CXFA_Reason::CXFA_Reason(CXFA_Document* doc, XFA_PacketType packet)
    : CXFA_Node(doc,
                packet,
                (XFA_XDPPACKET_Template | XFA_XDPPACKET_Form),
                XFA_ObjectType::TextNode,
                XFA_Element::Reason,
                nullptr,
                kReasonAttributeData,
                kReasonName,
                pdfium::MakeUnique<CJX_Reason>(this)) {}

CXFA_Reason::~CXFA_Reason() {}
