/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is a part of the libzmf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef ZMFINTERNALSTREAM_H_INCLUDED
#define ZMFINTERNALSTREAM_H_INCLUDED

#include <vector>

#include <librevenge-stream/librevenge-stream.h>

#include "libzmf_utils.h"

namespace libzmf
{

class ZMFInternalStream : public librevenge::RVNGInputStream
{
public:
  ZMFInternalStream(const unsigned char *data, unsigned long size);
  ZMFInternalStream(const std::vector<unsigned char> &data);
  ZMFInternalStream(const RVNGInputStreamPtr &input, unsigned long size);
  virtual ~ZMFInternalStream();

  virtual bool isStructured();
  virtual unsigned subStreamCount();
  virtual const char *subStreamName(unsigned id);
  virtual bool existsSubStream(const char *name);
  virtual librevenge::RVNGInputStream *getSubStreamByName(const char *name);
  virtual librevenge::RVNGInputStream *getSubStreamById(unsigned id);

  const virtual unsigned char *read(unsigned long numBytes, unsigned long &numBytesRead);
  virtual int seek(long offset, librevenge::RVNG_SEEK_TYPE seekType);
  virtual long tell();
  virtual bool isEnd();

private:
  long m_offset;
  unsigned long m_size;
  const unsigned char *m_data;
  unsigned char *m_tmpBuf;
  bool m_dataOwner;
  ZMFInternalStream(const ZMFInternalStream &);
  ZMFInternalStream &operator=(const ZMFInternalStream &);
};

}

#endif // ZMFINTERNALSTREAM_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
