/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.ArrayBunch;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.HashedTripleBunch;
import com.hp.hpl.jena.mem.NodeToTriplesMapBase;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;

public class NodeToTriplesMapMem
extends NodeToTriplesMapBase {
    public NodeToTriplesMapMem(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        super(indexField, f2, f3);
    }

    @Override
    public boolean add(Triple t) {
        Object o = this.getIndexField(t);
        TripleBunch s = this.bunchMap.get(o);
        if (s == null) {
            s = new ArrayBunch();
            this.bunchMap.put(o, s);
        }
        if (s.contains(t)) {
            return false;
        }
        if (s.size() == 9 && s instanceof ArrayBunch) {
            s = new HashedTripleBunch(s);
            this.bunchMap.put(o, s);
        }
        s.add(t);
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(Triple t) {
        Object o = this.getIndexField(t);
        TripleBunch s = this.bunchMap.get(o);
        if (s == null || !s.contains(t)) {
            return false;
        }
        s.remove(t);
        --this.size;
        if (s.size() == 0) {
            this.bunchMap.remove(o);
        }
        return true;
    }

    @Override
    public Iterator<Triple> iterator(Object o, HashCommon.NotifyEmpty container) {
        TripleBunch s = this.bunchMap.get(o);
        return s == null ? NullIterator.instance() : s.iterator(container);
    }

    @Override
    public boolean contains(Triple t) {
        TripleBunch s = this.bunchMap.get(this.getIndexField(t));
        return s == null ? false : s.contains(t);
    }

    @Override
    public boolean containsBySameValueAs(Triple t) {
        TripleBunch s = this.bunchMap.get(this.getIndexField(t));
        return s == null ? false : s.containsBySameValueAs(t);
    }

    @Override
    public ExtendedIterator<Triple> iterator(Node index, Node n2, Node n3) {
        Object indexValue = index.getIndexingValue();
        TripleBunch s = this.bunchMap.get(indexValue);
        return s == null ? NullIterator.instance() : this.f2.filterOn(n2).and(this.f3.filterOn(n3)).filterKeep(s.iterator(new NotifyMe(indexValue)));
    }

    protected TripleBunch get(Object index) {
        return this.bunchMap.get(index);
    }

    @Override
    public Iterator<Triple> iteratorForIndexed(Object y) {
        return this.get(y).iterator();
    }

    public class NotifyMe
    implements HashCommon.NotifyEmpty {
        protected final Object key;

        public NotifyMe(Object key) {
            this.key = key;
        }

        @Override
        public void emptied() {
            NodeToTriplesMapMem.this.bunchMap.remove(this.key);
        }
    }
}

