/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef TIMER_H
#define TIMER_H
#include "time.h"
#include "Common.h"

#define ENABLE_TIMER 0

#if ENABLE_TIMER
#define WRITETIME2FILE 1
#define TIMER_FILE "./Time.txt"
#define TRACE_TIME TraceTime tt
#else
#define WRITETIME2FILE 0
#define TRACE_TIME
#endif

#if WRITETIME2FILE
#include <iostream>
#include <iomanip>
#include <fstream>
#endif

#ifdef _WIN32
#include <windows.h>
#endif

#ifdef _linux_
#include <sys/time.h>
#endif

namespace libgltf
{

#ifdef _WIN32
static double dqFreq;
static LARGE_INTEGER temp;
#endif

#if WRITETIME2FILE
static ofstream timerFile;
#endif

static unsigned int queryID[2];
static double gpuTotalTime = 0;

class Timer
{
public :
    Timer()
    {
#if WRITETIME2FILE
        timerFile = ofstream(TIMER_FILE);
#endif
    }

    ~Timer()
    {
#if WRITETIME2FILE
        timerFile << "Total Time Taken by GPU " << std::fixed << gpuTotalTime << " ms";
#endif
    }
};

class TraceTime
{
public:
    TraceTime()
        : startTime(0)
        , stopTime(0)
    {
        glGenQueries(2, queryID);
        glQueryCounter(queryID[0], GL_TIMESTAMP);
        glGetQueryObjectui64v(queryID[0], GL_QUERY_RESULT, &startTime);
    }

    ~TraceTime()
    {
        glQueryCounter(queryID[1], GL_TIMESTAMP);
        GLint stopTimerAvailable = 0;
        while (!stopTimerAvailable)
        {
            glGetQueryObjectiv(queryID[1], GL_QUERY_RESULT_AVAILABLE,
                               &stopTimerAvailable);
        }
        glGetQueryObjectui64v(queryID[1], GL_QUERY_RESULT, &stopTime);
        gpuTotalTime += (double)((stopTime - startTime) / 1000000);
    }
private:
    GLuint64 startTime, stopTime;
};

} // namespace libgltf

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
