/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import java.io.File;
import java.io.InputStream;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.pkg.MediaType;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OdfTextDocument
extends OdfDocument {
    private static final String EMPTY_TEXT_DOCUMENT_PATH = "/OdfTextDocument.odt";
    static final OdfPackageDocument.Resource EMPTY_TEXT_DOCUMENT_RESOURCE = new OdfPackageDocument.Resource("/OdfTextDocument.odt");

    public static OdfTextDocument newTextDocument() throws Exception {
        return (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT);
    }

    public static OdfTextDocument newTextDocument(OdfMediaType mimeType) throws Exception {
        return (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT);
    }

    public static OdfTextDocument newTextTemplateDocument() throws Exception {
        return (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT_TEMPLATE);
    }

    public static OdfTextDocument newTextMasterDocument() throws Exception {
        OdfTextDocument doc = (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT_MASTER);
        doc.changeMode(OdfMediaType.TEXT_MASTER);
        return doc;
    }

    public static OdfTextDocument newTextWebDocument() throws Exception {
        OdfTextDocument doc = (OdfTextDocument)OdfDocument.loadTemplate(EMPTY_TEXT_DOCUMENT_RESOURCE, OdfDocument.OdfMediaType.TEXT_WEB);
        doc.changeMode(OdfMediaType.TEXT_WEB);
        return doc;
    }

    public static OdfTextDocument loadDocument(InputStream inputStream) throws Exception {
        return (OdfTextDocument)OdfDocument.loadDocument(inputStream);
    }

    public static OdfTextDocument loadDocument(String documentPath) throws Exception {
        return (OdfTextDocument)OdfDocument.loadDocument(documentPath);
    }

    public static OdfTextDocument loadDocument(File file) throws Exception {
        return (OdfTextDocument)OdfDocument.loadDocument(file);
    }

    protected OdfTextDocument(OdfPackage pkg, String internalPath, OdfMediaType odfMediaType) throws SAXException {
        super(pkg, internalPath, odfMediaType.mMediaType);
    }

    public OfficeTextElement getContentRoot() throws Exception {
        return super.getContentRoot(OfficeTextElement.class);
    }

    public OdfTextParagraph newParagraph(String text) throws Exception {
        OdfTextParagraph para = this.newParagraph();
        para.addContent(text);
        return para;
    }

    public OdfTextParagraph newParagraph() throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        return (OdfTextParagraph)odfText.newTextPElement();
    }

    public OdfTextParagraph addText(String text) throws Exception {
        OfficeTextElement odfText = this.getContentRoot();
        Node n = odfText.getLastChild();
        OdfTextParagraph para = OdfTextParagraph.class.isInstance(n) ? (OdfTextParagraph)n : this.newParagraph();
        para.addContent(text);
        return para;
    }

    public void changeMode(OdfMediaType mediaType) {
        this.setOdfMediaType(mediaType.mMediaType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType implements MediaType
    {
        TEXT(OdfDocument.OdfMediaType.TEXT),
        TEXT_TEMPLATE(OdfDocument.OdfMediaType.TEXT_TEMPLATE),
        TEXT_MASTER(OdfDocument.OdfMediaType.TEXT_MASTER),
        TEXT_WEB(OdfDocument.OdfMediaType.TEXT_WEB);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        @Override
        public String getMediaTypeString() {
            return this.mMediaType.getMediaTypeString();
        }

        @Override
        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

