/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.lang3;

import org.junit.Test;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

/**
 * Unit tests {@link org.apache.commons.lang3.NotImplementedException}.
 * 
 * @version $Id: NotImplementedExceptionTest.java 905628 2010-02-02 13:29:55Z niallp $
 */
public class NotImplementedExceptionTest {

    @Test
    public void testConstructors() {
        Throwable nested = new RuntimeException();
        String message = "Not Implemented";
        String code = "CODE";

        NotImplementedException nie = new NotImplementedException(message);
        assertCorrect("Issue in (String)", nie, message, null, null);
        nie = new NotImplementedException(nested);
        assertCorrect("Issue in (Throwable)", nie, nested.toString(), nested, null);
        nie = new NotImplementedException(message, nested);
        assertCorrect("Issue in (String, Throwable)", nie, message, nested, null);
        nie = new NotImplementedException(message, code);
        assertCorrect("Issue in (String, String)", nie, message, null, code);
        nie = new NotImplementedException(nested, code);
        assertCorrect("Issue in (Throwable, String)", nie, nested.toString(), nested, code);
        nie = new NotImplementedException(message, nested, code);
        assertCorrect("Issue in (String, Throwable, String)", nie, message, nested, code);
    }

    private void assertCorrect(String assertMessage, NotImplementedException nie, String message, Throwable nested, String code) {
        assertNotNull(assertMessage + ": target is null", nie);
        assertEquals(assertMessage + ": Message not equal", message, nie.getMessage());
        assertEquals(assertMessage + ": Nested throwable not equal", nested, nie.getCause());
        assertEquals(assertMessage + ": Code not equal", code, nie.getCode());
    }
}
