//  (C) Copyright John Maddock 2006-7.
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
   static const boost::array<boost::array<T, 7>, 1000> ibeta_int_data = { {
      { SC_(1), SC_(1), SC_(0.12707412242889404296875), SC_(0.12707412242889404296875), SC_(0.87292587757110595703125), SC_(0.12707412242889404296875), SC_(0.87292587757110595703125) }, 
      { SC_(1), SC_(1), SC_(0.1355634629726409912109375), SC_(0.1355634629726409912109375), SC_(0.8644365370273590087890625), SC_(0.1355634629726409912109375), SC_(0.8644365370273590087890625) }, 
      { SC_(1), SC_(1), SC_(0.221111953258514404296875), SC_(0.221111953258514404296875), SC_(0.778888046741485595703125), SC_(0.221111953258514404296875), SC_(0.778888046741485595703125) }, 
      { SC_(1), SC_(1), SC_(0.3082362115383148193359375), SC_(0.3082362115383148193359375), SC_(0.6917637884616851806640625), SC_(0.3082362115383148193359375), SC_(0.6917637884616851806640625) }, 
      { SC_(1), SC_(1), SC_(0.632396042346954345703125), SC_(0.632396042346954345703125), SC_(0.367603957653045654296875), SC_(0.632396042346954345703125), SC_(0.367603957653045654296875) }, 
      { SC_(1), SC_(1), SC_(0.81474220752716064453125), SC_(0.81474220752716064453125), SC_(0.18525779247283935546875), SC_(0.81474220752716064453125), SC_(0.18525779247283935546875) }, 
      { SC_(1), SC_(1), SC_(0.8350250720977783203125), SC_(0.8350250720977783203125), SC_(0.1649749279022216796875), SC_(0.8350250720977783203125), SC_(0.1649749279022216796875) }, 
      { SC_(1), SC_(1), SC_(0.905801355838775634765625), SC_(0.905801355838775634765625), SC_(0.094198644161224365234375), SC_(0.905801355838775634765625), SC_(0.094198644161224365234375) }, 
      { SC_(1), SC_(1), SC_(0.913384497165679931640625), SC_(0.913384497165679931640625), SC_(0.086615502834320068359375), SC_(0.913384497165679931640625), SC_(0.086615502834320068359375) }, 
      { SC_(1), SC_(1), SC_(0.9688708782196044921875), SC_(0.9688708782196044921875), SC_(0.0311291217803955078125), SC_(0.9688708782196044921875), SC_(0.0311291217803955078125) }, 
      { SC_(1), SC_(5), SC_(0.12707412242889404296875), SC_(0.09862827503959171189398618374792775287033), SC_(0.1013717249604082881060138162520722471297), SC_(0.4931413751979585594699309187396387643517), SC_(0.5068586248020414405300690812603612356483) }, 
      { SC_(1), SC_(5), SC_(0.1355634629726409912109375), SC_(0.1034626062176827277918252157009958542702), SC_(0.09653739378231727220817478429900414572975), SC_(0.5173130310884136389591260785049792713512), SC_(0.4826869689115863610408739214950207286488) }, 
      { SC_(1), SC_(5), SC_(0.221111953258514404296875), SC_(0.1426669309228783966319631141125057294315), SC_(0.05733306907712160336803688588749427056846), SC_(0.7133346546143919831598155705625286471577), SC_(0.2866653453856080168401844294374713528423) }, 
      { SC_(1), SC_(5), SC_(0.3082362115383148193359375), SC_(0.1683175237737739451458299347329965869636), SC_(0.03168247622622605485417006526700341303637), SC_(0.8415876188688697257291496736649829348182), SC_(0.1584123811311302742708503263350170651818) }, 
      { SC_(1), SC_(5), SC_(0.632396042346954345703125), SC_(0.1986574487056847557826435986513304812407), SC_(0.001342551294315244217356401348669518759265), SC_(0.9932872435284237789132179932566524062037), SC_(0.006712756471576221086782006743347593796327) }, 
      { SC_(1), SC_(5), SC_(0.81474220752716064453125), SC_(0.1999563572187662228110513475988795275212), SC_(0.4364278123377718894865240112047247884697e-4), SC_(0.9997817860938311140552567379943976376058), SC_(0.0002182139061688859447432620056023623942349) }, 
      { SC_(1), SC_(5), SC_(0.8350250720977783203125), SC_(0.1999755589571828112759793109250020391598), SC_(0.2444104281718872402068907499796084023135e-4), SC_(0.9998777947859140563798965546250101957988), SC_(0.0001222052140859436201034453749898042011567) }, 
      { SC_(1), SC_(5), SC_(0.905801355838775634765625), SC_(0.1999985166171454414455882653728607369309), SC_(0.1483382854558554411734627139263069093172e-5), SC_(0.9999925830857272072279413268643036846545), SC_(0.7416914272792772058673135696315345465861e-5) }, 
      { SC_(1), SC_(5), SC_(0.913384497165679931640625), SC_(0.1999990249920642955788201451534509989431), SC_(0.9750079357044211798548465490010569373139e-6), SC_(0.9999951249603214778941007257672549947153), SC_(0.487503967852210589927423274500528468657e-5) }, 
      { SC_(1), SC_(5), SC_(0.9688708782196044921875), SC_(0.1999999941539256010178778769929018951446), SC_(0.5846074398982122123007098104855351238397e-8), SC_(0.9999999707696280050893893849645094757232), SC_(0.2923037199491061061503549052427675619198e-7) }, 
      { SC_(1), SC_(9), SC_(0.12707412242889404296875), SC_(0.07841065545742553690357436899840861353416), SC_(0.03270045565368557420753674211270249757695), SC_(0.7056958991168298321321693209856775218074), SC_(0.2943041008831701678678306790143224781926) }, 
      { SC_(1), SC_(9), SC_(0.1355634629726409912109375), SC_(0.08116395928609379109945865148741523126218), SC_(0.02994715182501732001165245962369587984893), SC_(0.7304756335748441198951278633867370813597), SC_(0.2695243664251558801048721366132629186403) }, 
      { SC_(1), SC_(9), SC_(0.221111953258514404296875), SC_(0.09938827101178385357325884148839069014309), SC_(0.01172284009932725753785226962272042096802), SC_(0.8944944391060546821593295733955162112878), SC_(0.1055055608939453178406704266044837887122) }, 
      { SC_(1), SC_(9), SC_(0.3082362115383148193359375), SC_(0.1070804349188103774200633594833764298142), SC_(0.004030676192300733691047751627734681296879), SC_(0.9637239142692933967805702353503878683281), SC_(0.03627608573070660321942976464961213167191) }, 
      { SC_(1), SC_(9), SC_(0.632396042346954345703125), SC_(0.111097491048750043262614932132291317645), SC_(0.1362006236106784849617897881979346612813e-4), SC_(0.9998774194387503893635343891906218588048), SC_(0.0001225805612496106364656108093781411951532) }, 
      { SC_(1), SC_(9), SC_(0.81474220752716064453125), SC_(0.1111110825519232717208655720235017541736), SC_(0.2855918783939024553908760935693748091725e-7), SC_(0.9999997429673094454877901482115157875627), SC_(0.2570326905545122098517884842124373282553e-6) }, 
      { SC_(1), SC_(9), SC_(0.8350250720977783203125), SC_(0.1111111010529400910323964226375274050264), SC_(0.1005817102007871468847358370608472022094e-7), SC_(0.9999999094764608192915678037377466452375), SC_(0.905235391807084321962622533547624819885e-7) }, 
      { SC_(1), SC_(9), SC_(0.905801355838775634765625), SC_(0.1111111110462238627980857535394333033615), SC_(0.6488724831302535757167780774965012167349e-10), SC_(0.9999999994160147651827717818548997302531), SC_(0.5839852348172282181451002697468510950614e-9) }, 
      { SC_(1), SC_(9), SC_(0.913384497165679931640625), SC_(0.1111111110806238669246786783796986176146), SC_(0.3048724418643243273141249349655461366324e-10), SC_(0.999999999725614802322108105417287558531), SC_(0.2743851976778918945827124414689915229691e-9) }, 
      { SC_(1), SC_(9), SC_(0.9688708782196044921875), SC_(0.1111111111111080613957531527507243932621), SC_(0.3049715357958360386717849044032940135015e-14), SC_(0.9999999999999725525617783747565195393586), SC_(0.2744743822162524348046064139629646121513e-13) }, 
      { SC_(1), SC_(13), SC_(0.12707412242889404296875), SC_(0.06377802111972172856117668420887073531375), SC_(0.01314505580335519451574639271420618776317), SC_(0.8291142745563824712952968947153195590788), SC_(0.1708857254436175287047031052846804409212) }, 
      { SC_(1), SC_(13), SC_(0.1355634629726409912109375), SC_(0.06534631396335302561085740765853120632746), SC_(0.01157676295972389746606566926454571674946), SC_(0.849502081523589332941146299560905682257), SC_(0.150497918476410667058853700439094317743) }, 
      { SC_(1), SC_(13), SC_(0.221111953258514404296875), SC_(0.073936098027053229980456629155316619064), SC_(0.002986978896023693096466447767760304012923), SC_(0.961169274351691989745936179019116047832), SC_(0.03883072564830801025406382098088395216799) }, 
      { SC_(1), SC_(13), SC_(0.3082362115383148193359375), SC_(0.07628406587795866730026283989957329242692), SC_(0.0006390110451182557766602370235036306499997), SC_(0.99169285641346267490341691869445280155), SC_(0.008307143586537325096583081305547198449996) }, 
      { SC_(1), SC_(13), SC_(0.632396042346954345703125), SC_(0.07692290473662908828301426763349698076011), SC_(0.1721864478347939088092895799423168144275e-6), SC_(0.9999977615761781476791854792354607498814), SC_(0.2238423821852320814520764539250118587558e-5) }, 
      { SC_(1), SC_(13), SC_(0.81474220752716064453125), SC_(0.07692307689978791728736106957085988607084), SC_(0.2328900578956200735221703700608178721351e-10), SC_(0.9999999996972429247356939044211785189209), SC_(0.3027570752643060955788214810790632337757e-9) }, 
      { SC_(1), SC_(13), SC_(0.8350250720977783203125), SC_(0.0769230769179188206511773543901190630926), SC_(0.5158102425745722532957859984322934593166e-11), SC_(0.9999999999329446684653056070715478202038), SC_(0.6705533153469439292845217979619814971115e-10) }, 
      { SC_(1), SC_(13), SC_(0.905801355838775634765625), SC_(0.0769230769230733860601287482474701785501), SC_(0.3537016794328675606744526819400056704101e-14), SC_(0.9999999999999540187816737272171123211513), SC_(0.4598121832627278288767884865220073715331e-13) }, 
      { SC_(1), SC_(13), SC_(0.913384497165679931640625), SC_(0.07692307692307573512230480395666742897924), SC_(0.11879546182729664094940976869286312538e-14), SC_(0.9999999999999845565899624514366765767301), SC_(0.154434100375485633234232699300722062994e-13) }, 
      { SC_(1), SC_(13), SC_(0.9688708782196044921875), SC_(0.07692307692307692307494051875730989027246), SC_(0.1982558165767032804462970824488025880236e-20), SC_(0.999999999999999999974226743845028573542), SC_(0.2577325615497142645801862071834433644306e-19) }, 
      { SC_(1), SC_(17), SC_(0.12707412242889404296875), SC_(0.05298684330600258243994453504760446274421), SC_(0.005836686105762123442408406128866125491082), SC_(0.9007763362020439014790570958092758666516), SC_(0.0992236637979560985209429041907241333484) }, 
      { SC_(1), SC_(17), SC_(0.1355634629726409912109375), SC_(0.05388026283526436764556709719993134422191), SC_(0.004943266576500338236785843976539244013386), SC_(0.9159644681994942499746406523988328517724), SC_(0.08403553180050575002535934760116714822756) }, 
      { SC_(1), SC_(17), SC_(0.221111953258514404296875), SC_(0.05798285710551880515383575029657780246697), SC_(0.0008406723062459007285171908798927857683196), SC_(0.9857085707938196876152077550418226419386), SC_(0.01429142920618031238479224495817735806143) }, 
      { SC_(1), SC_(17), SC_(0.3082362115383148193359375), SC_(0.05871162837935254489868170115871457879443), SC_(0.0001119010324121609836712400177560094408654), SC_(0.9980976824489932632775889196981478395053), SC_(0.001902317551006736722411080301852160494712) }, 
      { SC_(1), SC_(17), SC_(0.632396042346954345703125), SC_(0.0588235270073237814057109234005476351883), SC_(0.2404440924476642017775922953046994862122e-8), SC_(0.9999999591245042838970856978093097982011), SC_(0.4087549571610291430219069020179891265608e-7) }, 
      { SC_(1), SC_(17), SC_(0.81474220752716064453125), SC_(0.05882352941174372849881815123439088317093), SC_(0.209773835347899420797050643638214001969e-13), SC_(0.9999999999996433844799085709846450139058), SC_(0.3566155200914290153549860941849638033473e-12) }, 
      { SC_(1), SC_(17), SC_(0.8350250720977783203125), SC_(0.05882352941176178404402556960006402546711), SC_(0.292183832737157640656276818082852678684e-14), SC_(0.9999999999999503287484346832010884329409), SC_(0.4967125156531679891156705907408495537629e-13) }, 
      { SC_(1), SC_(17), SC_(0.905801355838775634765625), SC_(0.0588235294117647056693869968828643991896), SC_(0.2129659442936061890456975009412782209024e-18), SC_(0.9999999999999999963795789470086947862231), SC_(0.362042105299130521377685751600172975534e-17) }, 
      { SC_(1), SC_(17), SC_(0.913384497165679931640625), SC_(0.05882352941176470583122282199788944005315), SC_(0.5113011917858114818214109346195935267832e-19), SC_(0.9999999999999999991307879739641204809036), SC_(0.8692120260358795190963985888533089955315e-18) }, 
      { SC_(1), SC_(17), SC_(0.9688708782196044921875), SC_(0.05882352941176470588235293975287103627759), SC_(0.1423599551957705623143914190179850430127e-26), SC_(0.999999999999999999999999975798807616719), SC_(0.2420119238328099559344654123305745731216e-25) }, 
      { SC_(1), SC_(21), SC_(0.12707412242889404296875), SC_(0.04487554463330296498867403464237823454315), SC_(0.002743502985744654058945012976669384504466), SC_(0.9423864372993622647621547274899429254062), SC_(0.05761356270063773523784527251005707459379) }, 
      { SC_(1), SC_(21), SC_(0.1355634629726409912109375), SC_(0.04538456944202070712243042905333157192264), SC_(0.002234478177026911925188618565716047124978), SC_(0.9530759582824348495710390101199630103755), SC_(0.04692404171756515042896098988003698962453) }, 
      { SC_(1), SC_(21), SC_(0.221111953258514404296875), SC_(0.04736857715324135788740328993622036050871), SC_(0.0002504704658062611602157576828272585389136), SC_(0.9947401202180685156354690886606275706828), SC_(0.005259879781931484364530911339372429317186) }, 
      { SC_(1), SC_(21), SC_(0.3082362115383148193359375), SC_(0.04759830349897238434749159984329463475294), SC_(0.2074412007523470012744777575298429467938e-4), SC_(0.9995643734784200712973235967091873298117), SC_(0.0004356265215799287026764032908126701882671) }, 
      { SC_(1), SC_(21), SC_(0.632396042346954345703125), SC_(0.04761904758350377036083284895385707746354), SC_(0.3554384868678619866519054158407918425781e-10), SC_(0.9999999992535791775774898280309986267343), SC_(0.7464208224225101719690013732656628694139e-9) }, 
      { SC_(1), SC_(21), SC_(0.81474220752716064453125), SC_(0.04761904761904759904499906888538095785439), SC_(0.2000261997873366666119323071333816841757e-16), SC_(0.9999999999999995799449804465930001149422), SC_(0.420055019553406999885057844980101536769e-15) }, 
      { SC_(1), SC_(21), SC_(0.8350250720977783203125), SC_(0.04761904761904761729552426147647975508515), SC_(0.1752094786142567863962469394405144410183e-17), SC_(0.9999999999999999632060094910060748567881), SC_(0.3679399050899392514321185728250803261385e-16) }, 
      { SC_(1), SC_(21), SC_(0.905801355838775634765625), SC_(0.04761904761904761904760547328931447509706), SC_(0.1357432973314395056196355375980761242815e-22), SC_(0.9999999999999999999997149390756039770382), SC_(0.2850609243960229618012346289559598609911e-21) }, 
      { SC_(1), SC_(21), SC_(0.913384497165679931640625), SC_(0.04761904761904761904761671797829140797469), SC_(0.2329640756211072932013929197542902737565e-23), SC_(0.9999999999999999999999510775441195674684), SC_(0.4892245588043253157229251314840095748887e-22) }, 
      { SC_(1), SC_(21), SC_(0.9688708782196044921875), SC_(0.0476190476190476190476190476190465369039), SC_(0.1082143719333844138479652053317883063834e-32), SC_(0.9999999999999999999999999999999772749819), SC_(0.2272501810601072690807269311967554434051e-31) }, 
      { SC_(1), SC_(25), SC_(0.12707412242889404296875), SC_(0.03866188266790096489540055400757505247595), SC_(0.001338117332099035104599445992424947524048), SC_(0.9665470666975241223850138501893763118988), SC_(0.0334529333024758776149861498106236881012) }, 
      { SC_(1), SC_(25), SC_(0.1355634629726409912109375), SC_(0.03895193585668554399222700056164278492628), SC_(0.001048064143314456007772999438357215073721), SC_(0.973798396417138599805675014041069623157), SC_(0.02620160358286140019432498595893037684303) }, 
      { SC_(1), SC_(25), SC_(0.221111953258514404296875), SC_(0.03992256523844820971686527722437468671455), SC_(0.7743476155179028313472277562531328544896e-4), SC_(0.9980641309612052429216319306093671678638), SC_(0.001935869038794757078368069390632832136224) }, 
      { SC_(1), SC_(25), SC_(0.3082362115383148193359375), SC_(0.03999600969951197898506865781814981287243), SC_(0.3990300488021014931342181850187127567775e-5), SC_(0.9999002424877994746267164454537453218108), SC_(0.9975751220052537328355454625467818919438e-4) }, 
      { SC_(1), SC_(25), SC_(0.632396042346954345703125), SC_(0.03999999999945478919887309462649226357181), SC_(0.5452108011269053735077364281874526493256e-12), SC_(0.9999999999863697299718273656623065892953), SC_(0.1363027002817263433769341070468631623314e-10) }, 
      { SC_(1), SC_(25), SC_(0.81474220752716064453125), SC_(0.03999999999999999998020880085008348590831), SC_(0.1979119914991651409168940620112675879012e-19), SC_(0.9999999999999999995052200212520871477078), SC_(0.4947799787479128522922351550281689697531e-18) }, 
      { SC_(1), SC_(25), SC_(0.8350250720977783203125), SC_(0.03999999999999999999890979373789628355727), SC_(0.1090206262103716442728242247277974178835e-20), SC_(0.9999999999999999999727448434474070889318), SC_(0.2725515655259291106820605618194935447087e-19) }, 
      { SC_(1), SC_(25), SC_(0.905801355838775634765625), SC_(0.03999999999999999999999999910220684911358), SC_(0.8977931508864228447781756436984842693672e-27), SC_(0.9999999999999999999999999775551712278394), SC_(0.2244482877216057111945439109246210673418e-25) }, 
      { SC_(1), SC_(25), SC_(0.913384497165679931640625), SC_(0.03999999999999999999999999988985855613212), SC_(0.110141443867877273799269854833922919789e-27), SC_(0.9999999999999999999999999972464639033031), SC_(0.2753536096696931844981746370848072994724e-26) }, 
      { SC_(1), SC_(25), SC_(0.9688708782196044921875), SC_(0.03999999999999999999999999999999999999915), SC_(0.8535553781643920467580658144985633896027e-39), SC_(0.9999999999999999999999999999999999999787), SC_(0.2133888445410980116895164536246408474007e-37) }, 
      { SC_(1), SC_(29), SC_(0.12707412242889404296875), SC_(0.0338129577935794692629945243270780430846), SC_(0.0006698008271101859094192687763702327774669), SC_(0.9805757760138046086268412054852632494535), SC_(0.01942422398619539137315879451473675054654) }, 
      { SC_(1), SC_(29), SC_(0.1355634629726409912109375), SC_(0.03397825727003684284951305462864306374949), SC_(0.000504501350652812322900738474805212112581), SC_(0.9853694608310684426358785842306488487352), SC_(0.01463053916893155736412141576935115126485) }, 
      { SC_(1), SC_(29), SC_(0.221111953258514404296875), SC_(0.03445819014954100940747931915221047170347), SC_(0.2456847114864576493447395123780415860198e-4), SC_(0.9992875143366892728169002554141036794005), SC_(0.0007124856633107271830997445858963205994575) }, 
      { SC_(1), SC_(29), SC_(0.3082362115383148193359375), SC_(0.03448197088792511073696751642308608507103), SC_(0.7877327645444354462766803621907910391701e-6), SC_(0.9999771557498282113720579762694964670599), SC_(0.2284425017178862794202373050353294013593e-4) }, 
      { SC_(1), SC_(29), SC_(0.632396042346954345703125), SC_(0.03448275862068107240832609688846853373868), SC_(0.8582764087696214979742123387249709836686e-14), SC_(0.9999999999997510998414568097655874784218), SC_(0.2489001585431902344125215782302415852639e-12) }, 
      { SC_(1), SC_(29), SC_(0.81474220752716064453125), SC_(0.03448275862068965517239369662051856932495), SC_(0.2009648292970653711870041632254773881049e-22), SC_(0.9999999999999999999994172019950385104236), SC_(0.5827980049614895764423120733538844255043e-21) }, 
      { SC_(1), SC_(29), SC_(0.8350250720977783203125), SC_(0.03448275862068965517241309692195848763947), SC_(0.6961814897882226031777233180469927812415e-24), SC_(0.9999999999999999999999798107367961415445), SC_(0.20189263203858455492153976223362790656e-22) }, 
      { SC_(1), SC_(29), SC_(0.905801355838775634765625), SC_(0.03448275862068965517241379310338733663996), SC_(0.6093922210984556783709527035835563848764e-31), SC_(0.9999999999999999999999999999982327625588), SC_(0.1767237441185521467275762840392313516142e-29) }, 
      { SC_(1), SC_(29), SC_(0.913384497165679931640625), SC_(0.03448275862068965517241379310344293175316), SC_(0.5344108907950052856021250086575088322768e-32), SC_(0.9999999999999999999999999999998450208417), SC_(0.1549791583305515328246162525106775613603e-30) }, 
      { SC_(1), SC_(29), SC_(0.9688708782196044921875), SC_(0.03448275862068965517241379310344827586207), SC_(0.6909413557153258190411357794417167737147e-45), SC_(1), SC_(0.2003729931574444875219293760380978643773e-43) }, 
      { SC_(1), SC_(33), SC_(0.12707412242889404296875), SC_(0.02996125615429966162477994069300808354005), SC_(0.0003417741487306414055230896100222194902487), SC_(0.9887214530918888336177380428692667568218), SC_(0.01127854690811116638226195713073324317821) }, 
      { SC_(1), SC_(33), SC_(0.1355634629726409912109375), SC_(0.03005547122833160852998996598916397182363), SC_(0.0002475590746986945003130643138663312066772), SC_(0.9918305505349430814896688776424110701797), SC_(0.008169449465056918510331122357588929820349) }, 
      { SC_(1), SC_(33), SC_(0.221111953258514404296875), SC_(0.03029508405080924943654310503234404320316), SC_(0.7946252221053593759925270686259827142484e-5), SC_(0.9997377736767052314059224660673534257043), SC_(0.000262226323294768594077533932646574295702) }, 
      { SC_(1), SC_(33), SC_(0.3082362115383148193359375), SC_(0.03030287177930661038921739207309849425036), SC_(0.1585237236926410856382299318087799406495e-6), SC_(0.999994768717118142844173938412250310262), SC_(0.5231282881857155826061587749689738041435e-5) }, 
      { SC_(1), SC_(33), SC_(0.632396042346954345703125), SC_(0.03030303030303016529922494748359051931652), SC_(0.1377310780828194397837137809520143740978e-15), SC_(0.9999999999999954548744232669584871374452), SC_(0.4545125576733041512862554771416474345228e-14) }, 
      { SC_(1), SC_(33), SC_(0.81474220752716064453125), SC_(0.03030303030303030303030300950079256675483), SC_(0.2080223773627546824208717474076926668685e-25), SC_(0.9999999999999999999999993135261547029095), SC_(0.686473845297090451988876766445385800666e-24) }, 
      { SC_(1), SC_(33), SC_(0.8350250720977783203125), SC_(0.03030303030303030303030302984984238928731), SC_(0.4531879137429939427313174492172092688101e-27), SC_(0.9999999999999999999999999850447988464812), SC_(0.1495520115351880011013347582416790587073e-25) }, 
      { SC_(1), SC_(33), SC_(0.905801355838775634765625), SC_(0.03030303030303030303030303030303029881373), SC_(0.4216572496202426141521639811295284364552e-35), SC_(0.9999999999999999999999999999999998608531), SC_(0.1391468923746800626702141137727443840302e-33) }, 
      { SC_(1), SC_(33), SC_(0.913384497165679931640625), SC_(0.03030303030303030303030303030303030276598), SC_(0.2643272160792120456870309892556627184259e-36), SC_(0.9999999999999999999999999999999999912772), SC_(0.8722798130613997507672022645436869708055e-35) }, 
      { SC_(1), SC_(33), SC_(0.9688708782196044921875), SC_(0.0303030303030303030303030303030303030303), SC_(0.5701547144108821479765624946797517577224e-51), SC_(1), SC_(0.1881510557555911088322656232443180800484e-49) }, 
      { SC_(1), SC_(37), SC_(0.12707412242889404296875), SC_(0.02685003206744144508733016520491446621219), SC_(0.0001769949595855819396968618221125608148349), SC_(0.9934511864953334682312161125818352498511), SC_(0.00654881350466653176878388741816475014889) }, 
      { SC_(1), SC_(37), SC_(0.1355634629726409912109375), SC_(0.02690373825526310061165833807151310437019), SC_(0.0001232887717639264153686889555139226568345), SC_(0.9954383154447347226313585086459848616971), SC_(0.004561684555265277368641491354015138302878) }, 
      { SC_(1), SC_(37), SC_(0.221111953258514404296875), SC_(0.02702441862386815669167732436924253361327), SC_(0.260840315887033534970265778449341376096e-5), SC_(0.9999034890831217975920610016619737436908), SC_(0.9651091687820240793899833802625630915554e-4) }, 
      { SC_(1), SC_(37), SC_(0.3082362115383148193359375), SC_(0.02702699464993954748546840544393492461385), SC_(0.3237708747954155862158309210241317614237e-7), SC_(0.9999988020477632569623310014255922107125), SC_(0.1197952236743037668998574407789287517268e-5) }, 
      { SC_(1), SC_(37), SC_(0.632396042346954345703125), SC_(0.02702702702702702478384314230872306214527), SC_(0.224318388471830396488175637418087186813e-17), SC_(0.999999999999999917002196265422753299375), SC_(0.829978037345772467006249858446922591208e-16) }, 
      { SC_(1), SC_(37), SC_(0.81474220752716064453125), SC_(0.0270270270270270270270270270051731643394), SC_(0.2185386268763041505685533969169915442671e-28), SC_(0.9999999999999999999999999991914070805577), SC_(0.8085929194423253571036475685928687137884e-27) }, 
      { SC_(1), SC_(37), SC_(0.8350250720977783203125), SC_(0.02702702702702702702702702702672761976919), SC_(0.2994072578348473361092624804983152575799e-30), SC_(0.9999999999999999999999999999889219314601), SC_(0.1107806853988935143604271177843766453046e-28) }, 
      { SC_(1), SC_(37), SC_(0.905801355838775634765625), SC_(0.02702702702702702702702702702702702702673), SC_(0.2961081731340483860236647047452899258232e-39), SC_(0.999999999999999999999999999999999999989), SC_(0.1095600240595979028287559407557572725546e-37) }, 
      { SC_(1), SC_(37), SC_(0.913384497165679931640625), SC_(0.02702702702702702702702702702702702702701), SC_(0.1326895195650138348534156104409073960527e-40), SC_(0.9999999999999999999999999999999999999995), SC_(0.4909512223905511889576377586313573653949e-39) }, 
      { SC_(1), SC_(37), SC_(0.9688708782196044921875), SC_(0.02702702702702702702702702702702702702703), SC_(0.4774989373311929856464989113561258414683e-57), SC_(1), SC_(0.1766746068125414046892045972017665613433e-55) }, 
      { SC_(5), SC_(1), SC_(0.12707412242889404296875), SC_(0.6626978955378501583431412360064835909866e-5), SC_(0.1999933730210446214984165685876399351641), SC_(0.3313489477689250791715706180032417954933e-4), SC_(0.9999668651052231074920828429381996758205) }, 
      { SC_(5), SC_(1), SC_(0.1355634629726409912109375), SC_(0.9156790279322187765365273101769107871856e-5), SC_(0.1999908432097206778122346347268982308921), SC_(0.4578395139661093882682636550884553935928e-4), SC_(0.9999542160486033890611731736344911544606) }, 
      { SC_(5), SC_(1), SC_(0.221111953258514404296875), SC_(0.0001057039218760148704158598412930603107971), SC_(0.1998942960781239851295841401587069396892), SC_(0.0005285196093800743520792992064653015539857), SC_(0.999471480390619925647920700793534698446) }, 
      { SC_(5), SC_(1), SC_(0.3082362115383148193359375), SC_(0.0005564783681523892578337221648065064981452), SC_(0.1994435216318476107421662778351934935019), SC_(0.002782391840761946289168610824032532490726), SC_(0.9972176081592380537108313891759674675093) }, 
      { SC_(5), SC_(1), SC_(0.632396042346954345703125), SC_(0.02022906046565341559849863176562205767169), SC_(0.1797709395343465844015013682343779423283), SC_(0.1011453023282670779924931588281102883585), SC_(0.8988546976717329220075068411718897116415) }, 
      { SC_(5), SC_(1), SC_(0.81474220752716064453125), SC_(0.07180109586964185870286826689259153110583), SC_(0.1281989041303581412971317331074084688942), SC_(0.3590054793482092935143413344629576555292), SC_(0.6409945206517907064856586655370423444708) }, 
      { SC_(5), SC_(1), SC_(0.8350250720977783203125), SC_(0.08119467985221136420855443387695744866813), SC_(0.1188053201477886357914455661230425513319), SC_(0.4059733992610568210427721693847872433407), SC_(0.5940266007389431789572278306152127566593) }, 
      { SC_(5), SC_(1), SC_(0.905801355838775634765625), SC_(0.1219536569434409919952862978686654317061), SC_(0.07804634305655900800471370213133456829386), SC_(0.6097682847172049599764314893433271585307), SC_(0.3902317152827950400235685106566728414693) }, 
      { SC_(5), SC_(1), SC_(0.913384497165679931640625), SC_(0.1271446750017346562381435372624835222717), SC_(0.07285532499826534376185646273751647772832), SC_(0.6357233750086732811907176863124176113584), SC_(0.3642766249913267188092823136875823886416) }, 
      { SC_(5), SC_(1), SC_(0.9688708782196044921875), SC_(0.1707495262016717323163655029083641498378), SC_(0.02925047379832826768363449709163585016219), SC_(0.8537476310083586615818275145418207491891), SC_(0.1462523689916413384181724854581792508109) }, 
      { SC_(5), SC_(5), SC_(0.12707412242889404296875), SC_(0.4245504630821316504705517655239267695642e-5), SC_(0.001583056082670765985082596069646348033892), SC_(0.002674667917417429397964476122800738648255), SC_(0.9973253320825825706020355238771992613517) }, 
      { SC_(5), SC_(5), SC_(0.1355634629726409912109375), SC_(0.568491679693243391894246334773222488264e-5), SC_(0.001581616670504654867668359123953855076705), SC_(0.003581497582067433368933751909071301676063), SC_(0.9964185024179325666310662480909286983239) }, 
      { SC_(5), SC_(5), SC_(0.221111953258514404296875), SC_(0.4722778330395384243840041708010548627366e-4), SC_(0.001540073803997633459148901170221481815314), SC_(0.0297535034814909207361922627604664563524), SC_(0.9702464965185090792638077372395335436476) }, 
      { SC_(5), SC_(5), SC_(0.3082362115383148193359375), SC_(0.0001733603897707229517241440221390863679688), SC_(0.001413941197530864349863157565162500933619), SC_(0.1092170455555554595862107339476244118203), SC_(0.8907829544444445404137892660523755881797) }, 
      { SC_(5), SC_(5), SC_(0.632396042346954345703125), SC_(0.001265424730310530773247546797195507112824), SC_(0.0003218768569910565283397547901060801887636), SC_(0.797217580095634387145954482233169481079), SC_(0.202782419904365612854045517766830518921) }, 
      { SC_(5), SC_(5), SC_(0.81474220752716064453125), SC_(0.001564855200423749013316774472605337654234), SC_(0.224463868778382882705271146962496473529e-4), SC_(0.9858587762669618783895679177413627221677), SC_(0.01414122373303812161043208225863727783233) }, 
      { SC_(5), SC_(5), SC_(0.8350250720977783203125), SC_(0.001573714493311068400788361358172010167912), SC_(0.1358709399051890079894022912957713367505e-4), SC_(0.9914401307859730924966676556483664057847), SC_(0.00855986921402690750333234435163359421528) }, 
      { SC_(5), SC_(5), SC_(0.905801355838775634765625), SC_(0.0015862306035694300480734657077551310787), SC_(0.1070983732157253513835879546456222887569e-5), SC_(0.9993252802487409302862833958857325795808), SC_(0.0006747197512590697137166041142674204191682) }, 
      { SC_(5), SC_(5), SC_(0.913384497165679931640625), SC_(0.001586578286557488984753535011470563209678), SC_(0.7233007440983168337665758310240919089226e-6), SC_(0.9995443205312180603947270572264548220974), SC_(0.0004556794687819396052729427735451779026212) }, 
      { SC_(5), SC_(5), SC_(0.9688708782196044921875), SC_(0.001587296323997073992065930861320184407354), SC_(0.5263304513309521370725981402894232861762e-8), SC_(0.9999966841181566150015364426317161766333), SC_(0.331588184338499846355736828382336670291e-5) }, 
      { SC_(5), SC_(9), SC_(0.12707412242889404296875), SC_(0.2738541116629531763930695926601761162666e-5), SC_(0.0001526616142835258683914694594735536389927), SC_(0.01762251208551103690089402828768233308176), SC_(0.9823774879144889630991059717123176669182) }, 
      { SC_(5), SC_(9), SC_(0.1355634629726409912109375), SC_(0.3557641921343498689452861597532250542766e-5), SC_(0.0001518425134788119014659472938026231496126), SC_(0.0228934257638454140666291643801200322427), SC_(0.9771065742361545859333708356198799677573) }, 
      { SC_(5), SC_(9), SC_(0.221111953258514404296875), SC_(0.2166199772330550370708351214626779105852e-4), SC_(0.0001337381576768498964483166432538876090969), SC_(0.1393949553494709163550824006612332354616), SC_(0.8606050446505290836449175993387667645384) }, 
      { SC_(5), SC_(9), SC_(0.3082362115383148193359375), SC_(0.5759329184243913101384408645845589387714e-4), SC_(0.9780686355771626914155606894169950627826e-4), SC_(0.3706128330060958080740866963601636770994), SC_(0.6293871669939041919259133036398363229006) }, 
      { SC_(5), SC_(9), SC_(0.632396042346954345703125), SC_(0.0001526268312325674049995117506276554290688), SC_(0.277332416758799515588840477249997108661e-5), SC_(0.9821536589815712511718581152889626860577), SC_(0.01784634101842874882814188471103731394234) }, 
      { SC_(5), SC_(9), SC_(0.81474220752716064453125), SC_(0.0001553863528809879702157915239552677437259), SC_(0.1380251916742993960863144488765642947126e-7), SC_(0.9999111807891575883386184566521479308764), SC_(0.8881921084241166138154334785206912364759e-4) }, 
      { SC_(5), SC_(9), SC_(0.8350250720977783203125), SC_(0.0001553948573366192450812155864041895438366), SC_(0.5298063536155074184568995965856318828896e-8), SC_(0.9999659069611448420976222985109597145883), SC_(0.3409303885515790237770148904028541166394e-4) }, 
      { SC_(5), SC_(9), SC_(0.905801355838775634765625), SC_(0.0001554001098498222684669134918363046144641), SC_(0.4555033313168848666356385078569125112895e-10), SC_(0.9999997068836062975845883199666201940768), SC_(0.2931163937024154116800333798059232010148e-6) }, 
      { SC_(5), SC_(9), SC_(0.913384497165679931640625), SC_(0.0001554001333547398768483335233163736415794), SC_(0.2204541552330706663208378175857603078625e-10), SC_(0.9999998581377511075190262225408643835632), SC_(0.1418622488924809737774591356164367581095e-6) }, 
      { SC_(5), SC_(9), SC_(0.9688708782196044921875), SC_(0.0001554001553974332171045119986287148275732), SC_(0.2722183050888156771440572582249298206365e-14), SC_(0.9999999999824827520675347111757799154332), SC_(0.1751724793246528882422008456677423395796e-10) }, 
      { SC_(5), SC_(13), SC_(0.12707412242889404296875), SC_(0.1779723734487811605150405253566213241832e-5), SC_(0.3054089682142686195658198000823081326108e-4), SC_(0.05506465234505289106335353854533863770228), SC_(0.9449353476549471089366464614546613622977) }, 
      { SC_(5), SC_(13), SC_(0.1355634629726409912109375), SC_(0.2245894166309259354269751353564796920669e-5), SC_(0.3007472638960541420746263390823222958224e-4), SC_(0.06948796550560848442110610687929481672551), SC_(0.9305120344943915155788938931207051832745) }, 
      { SC_(5), SC_(13), SC_(0.221111953258514404296875), SC_(0.1024148072384398790773477729036601385943e-4), SC_(0.2207913983207068565399760797143101264348e-4), SC_(0.3168714135957329858653140093639244688106), SC_(0.6831285864042670141346859906360755311894) }, 
      { SC_(5), SC_(13), SC_(0.3082362115383148193359375), SC_(0.2066629443881893108191084318606536115475e-4), SC_(0.1165432611709574247982154207573166534816e-4), SC_(0.639415149937057727674321488176862274128), SC_(0.360584850062942272325678511823137725872) }, 
      { SC_(5), SC_(13), SC_(0.632396042346954345703125), SC_(0.3228793557582153566118449168980081732074e-4), SC_(0.3268498009313790054789357199620918217083e-7), SC_(0.9989887267159183133570481728824372879036), SC_(0.001011273284081686642951827117562712096365) }, 
      { SC_(5), SC_(13), SC_(0.81474220752716064453125), SC_(0.3232060959604372994758946840890806934451e-4), SC_(0.1095987094361414291685288895715840358553e-10), SC_(0.999999660901593004578418152571615665519), SC_(0.3390984069954215818474283843344810069362e-6) }, 
      { SC_(5), SC_(13), SC_(0.8350250720977783203125), SC_(0.3232061790085022986652515988530040185708e-4), SC_(0.2655064443695207225376496624645826146566e-11), SC_(0.9999999178523061120702884468511944334581), SC_(0.8214769388792971155314880556654186097475e-7) }, 
      { SC_(5), SC_(13), SC_(0.905801355838775634765625), SC_(0.3232062055346138249795666940923437497225e-4), SC_(0.2453291063775715852562651530659411183593e-14), SC_(0.9999999999240951744867793515217115616414), SC_(0.7590482551322064847828843835860218202036e-10) }, 
      { SC_(5), SC_(13), SC_(0.913384497165679931640625), SC_(0.3232062055506501502957895027089824686831e-4), SC_(0.8496585321534349908987796346034008559339e-15), SC_(0.9999999999737115650151727213815917581054), SC_(0.2628843498482727861840824189462922248259e-10) }, 
      { SC_(5), SC_(13), SC_(0.9688708782196044921875), SC_(0.3232062055591467179860545106384050413085e-4), SC_(0.1763126934197956522372058719926831178672e-20), SC_(0.9999999999999999454488526559152251978085), SC_(0.545511473440847748021914967945361566681e-16) }, 
      { SC_(5), SC_(17), SC_(0.12707412242889404296875), SC_(0.1166026704006254576699947414470994192763e-5), SC_(0.8662466096622768962540310092040382287654e-5), SC_(0.1186373869991163719063361496853513041427), SC_(0.8813626130008836280936638503146486958573) }, 
      { SC_(5), SC_(17), SC_(0.1355634629726409912109375), SC_(0.1431369508447339936845007917083886457771e-5), SC_(0.8397123292181683602395249589427490022646e-5), SC_(0.1456346906369746018742953305237000276459), SC_(0.8543653093630253981257046694762999723541) }, 
      { SC_(5), SC_(17), SC_(0.221111953258514404296875), SC_(0.5011277114303216952294257963835060160421e-5), SC_(0.4817215686325806586945999542676316319996e-5), SC_(0.509872389994780808811179276530398196022), SC_(0.490127610005219191188820723469601803978) }, 
      { SC_(5), SC_(17), SC_(0.3082362115383148193359375), SC_(0.8091756115838843416056203114247919435688e-5), SC_(0.1736736684790180123184054392263457044729e-5), SC_(0.8232957260060231233666383858591545629841), SC_(0.1767042739939768766333616141408454370159) }, 
      { SC_(5), SC_(17), SC_(0.632396042346954345703125), SC_(0.9828053726739783161021682511091418189587e-5), SC_(0.4390738892403782185749954199582908297525e-9), SC_(0.9999553264271392377181510870909963436995), SC_(0.4467357286076228184891290900365630047317e-4) }, 
      { SC_(5), SC_(17), SC_(0.81474220752716064453125), SC_(0.9828492790901396677359775252477495832872e-5), SC_(0.9727626861880482254033880647544635678525e-14), SC_(0.9999999990102626049379703330633228135156), SC_(0.9897373950620296669366771864844289571115e-9) }, 
      { SC_(5), SC_(17), SC_(0.8350250720977783203125), SC_(0.9828492799144128868586891207195923353865e-5), SC_(0.148489467065336629931545312655166112944e-14), SC_(0.999999999848919391734373245876149221639), SC_(0.1510806082656267541238507783609987616149e-9) }, 
      { SC_(5), SC_(17), SC_(0.905801355838775634765625), SC_(0.9828492800628876806485666936528864428055e-5), SC_(0.1467327545905699825120523617387640923315e-18), SC_(0.9999999999999850706758841824571293112325), SC_(0.1492932411581754287068876754511055257427e-13) }, 
      { SC_(5), SC_(17), SC_(0.913384497165679931640625), SC_(0.9828492800628987190976769515674215989182e-5), SC_(0.3634826348799083716049123440466086679689e-19), SC_(0.9999999999999963017459314143722731058194), SC_(0.369825406858562772689418064450221989225e-14) }, 
      { SC_(5), SC_(17), SC_(0.9688708782196044921875), SC_(0.9828492800629023539238994059895208279817e-5), SC_(0.1263446616168200599324575301788207724665e-26), SC_(0.99999999999999999999987145062403796643), SC_(0.128549375962033569978278914080441194946e-21) }, 
      { SC_(5), SC_(21), SC_(0.12707412242889404296875), SC_(0.770679359488142113319146684943433220236e-6), SC_(0.2993672230950404846966944035929896348746e-5), SC_(0.2047309718480249524032313168552230349557), SC_(0.7952690281519750475967686831447769650443) }, 
      { SC_(5), SC_(21), SC_(0.1355634629726409912109375), SC_(0.921730897091594102115555159459971560238e-6), SC_(0.2842620693346952858170535561413358008744e-5), SC_(0.2448578128123819732269972281105414449772), SC_(0.7551421871876180267730027718894585550228) }, 
      { SC_(5), SC_(21), SC_(0.221111953258514404296875), SC_(0.2547022148036034491511054377284407220826e-5), SC_(0.1217329442402512468775036343588922348156e-5), SC_(0.6766164336257725626699115953256027782123), SC_(0.3233835663742274373300884046743972217877) }, 
      { SC_(5), SC_(21), SC_(0.3082362115383148193359375), SC_(0.3473764108013440053103188600895684249321e-5), SC_(0.2905874824251069071829021199776453196605e-6), SC_(0.9228054352937703501068620518279385208322), SC_(0.07719456470622964989313794817206147916781) }, 
      { SC_(5), SC_(21), SC_(0.632396042346954345703125), SC_(0.3764345256922491272943553996549144891883e-5), SC_(0.6333516055687342536724324184677098371443e-11), SC_(0.9999983175014598066574551191832803405288), SC_(0.1682498540193342544880816719659471182374e-5) }, 
      { SC_(5), SC_(21), SC_(0.81474220752716064453125), SC_(0.376435159042935766837008995513978406577e-5), SC_(0.9189291916000765733545503211678367492792e-17), SC_(0.9999999999975588646025143965828836370718), SC_(0.244113539748560341711636292818235832446e-11) }, 
      { SC_(5), SC_(21), SC_(0.8350250720977783203125), SC_(0.3764351590437663724016186730329502410868e-5), SC_(0.8832362699039905438271581133800554541482e-18), SC_(0.9999999999997653682849000049120323154472), SC_(0.2346317150999950879676845528194117313945e-12) }, 
      { SC_(5), SC_(21), SC_(0.905801355838775634765625), SC_(0.3764351590438546950972963113868472214067e-5), SC_(0.9313127607004857354914547451839437002614e-23), SC_(0.999999999999999997525967651199159643667), SC_(0.2474032348800840356333049530581146439744e-17) }, 
      { SC_(5), SC_(21), SC_(0.913384497165679931640625), SC_(0.3764351590438546958636335911529738352501e-5), SC_(0.1649754809343591216480335881999014410191e-23), SC_(0.999999999999999999561742634897874993342), SC_(0.4382573651021250066580012270530381780673e-18) }, 
      { SC_(5), SC_(21), SC_(0.9688708782196044921875), SC_(0.3764351590438546960286090719914174598136e-5), SC_(0.9591549708462225730170137556512342611693e-33), SC_(0.9999999999999999999999999997452004819947), SC_(0.2547995180052990265219697041887503814796e-27) }, 
      { SC_(5), SC_(25), SC_(0.12707412242889404296875), SC_(0.514205387350499361077745705515171463481e-6), SC_(0.116993422782359857164087666827961612441e-5), SC_(0.3053223038740427581239384562922709357284), SC_(0.6946776961259572418760615437077290642716) }, 
      { SC_(5), SC_(25), SC_(0.1355634629726409912109375), SC_(0.600205346705767839537944808581282760012e-6), SC_(0.1083934268468330093180677565213504827879e-5), SC_(0.3563869297402172989216431787153511708261), SC_(0.6436130702597827010783568212846488291739) }, 
      { SC_(5), SC_(25), SC_(0.221111953258514404296875), SC_(0.1348402319236622539907419237943739516174e-5), SC_(0.3357372959374753928112031358510480717174e-6), SC_(0.800647587104725548633527858010043931216), SC_(0.199352412895274451366472141989956068784) }, 
      { SC_(5), SC_(25), SC_(0.3082362115383148193359375), SC_(0.1632046487220810591456304618179811389981e-5), SC_(0.5209312795328734126231775561497619790983e-7), SC_(0.9690684029495368089419672746597175080861), SC_(0.03093159705046319105803272534028249191391) }, 
      { SC_(5), SC_(25), SC_(0.632396042346954345703125), SC_(0.168413951964990541720537670144554768637e-5), SC_(0.9552419251551324567234923990152077877191e-13), SC_(0.9999999432801225891011225509008300774745), SC_(0.5671987741089887744909916992252550041529e-7) }, 
      { SC_(5), SC_(25), SC_(0.81474220752716064453125), SC_(0.1684139615174088899084961367582947019843e-5), SC_(0.9033633661006211840568048317554150034612e-20), SC_(0.9999999999999946360541729360365643667071), SC_(0.5363945827063963435633292889755715436802e-14) }, 
      { SC_(5), SC_(25), SC_(0.8350250720977783203125), SC_(0.1684139615174097386211664286342067313351e-5), SC_(0.5465069580874527202745400124445652699559e-21), SC_(0.999999999999999675497830961622761018985), SC_(0.3245021690383772389810149958892717431681e-15) }, 
      { SC_(5), SC_(25), SC_(0.905801355838775634765625), SC_(0.1684139615174097932718008214362361523638e-5), SC_(0.6141594324260642529721466861127678910553e-27), SC_(0.9999999999999999999996353274830112136982), SC_(0.3646725169887863018085363985466087545114e-21) }, 
      { SC_(5), SC_(25), SC_(0.913384497165679931640625), SC_(0.1684139615174097932718544584157675269689e-5), SC_(0.777896371123182018221360856111041505908e-28), SC_(0.9999999999999999999999538104582236332597), SC_(0.4618954177636674028693885423373336701705e-22) }, 
      { SC_(5), SC_(25), SC_(0.9688708782196044921875), SC_(0.1684139615174097932718622373794786832026e-5), SC_(0.7558652339348910731722796651845551186667e-39), SC_(0.9999999999999999999999999999999995511861), SC_(0.4488138792796899469728703581949592155863e-33) }, 
      { SC_(5), SC_(29), SC_(0.12707412242889404296875), SC_(0.3465610210840724596919411684893370711377e-6), SC_(0.496126139734345310894906170304609064299e-6), SC_(0.4112570325000471064672327458229265155777), SC_(0.5887429674999528935327672541770734844223) }, 
      { SC_(5), SC_(29), SC_(0.1355634629726409912109375), SC_(0.3955306269772238166507554992747815494381e-6), SC_(0.4471565338411939539360918395191645859986e-6), SC_(0.4693682844213319587431185358793977690872), SC_(0.5306317155786680412568814641206022309128) }, 
      { SC_(5), SC_(29), SC_(0.221111953258514404296875), SC_(0.7446856911208254351486408432696311838836e-6), SC_(0.9800146969759233543820649552431495155309e-7), SC_(0.883703615939261127382189115891205933291), SC_(0.116296384060738872617810884108794066709) }, 
      { SC_(5), SC_(29), SC_(0.3082362115383148193359375), SC_(0.8329173078668092942128932378368916820652e-6), SC_(0.9769852951608476373954100957054453371478e-8), SC_(0.9884063108993852532565561474762826212731), SC_(0.01159368910061474674344385252371737872687) }, 
      { SC_(5), SC_(29), SC_(0.632396042346954345703125), SC_(0.8426871593330927388358007279970214701951e-6), SC_(0.1485325031751046610796924665241597967403e-14), SC_(0.9999999982373944913216680078995054382511), SC_(0.1762605508678331992100494561748899475957e-8) }, 
      { SC_(5), SC_(29), SC_(0.81474220752716064453125), SC_(0.8426871608184177614571331873332569178482e-6), SC_(0.9129714151460689217588484018764203944526e-23), SC_(0.9999999999999999891659508107446293192721), SC_(0.1083404918925537068072790221538710553689e-16) }, 
      { SC_(5), SC_(29), SC_(0.8350250720977783203125), SC_(0.8426871608184177702392883160849213039798e-6), SC_(0.3475590227090248314568885651656125480045e-24), SC_(0.9999999999999999995875586589316544130067), SC_(0.412441341068345586993260522510729098466e-18) }, 
      { SC_(5), SC_(29), SC_(0.905801355838775634765625), SC_(0.8426871608184177705868472971962304887967e-6), SC_(0.4159771564663997407827812648092520905612e-31), SC_(0.9999999999999999999999999506368227964453), SC_(0.4936317720355472443921108713238432708271e-25) }, 
      { SC_(5), SC_(29), SC_(0.913384497165679931640625), SC_(0.8426871608184177705868473350269372242016e-6), SC_(0.3767008911235081945651281329191714918149e-32), SC_(0.9999999999999999999999999955297658652156), SC_(0.4470234134784447043265462527725224259069e-26) }, 
      { SC_(5), SC_(29), SC_(0.9688708782196044921875), SC_(0.8426871608184177705868473387939461354361e-6), SC_(0.6114586184815846003326386784098295666671e-45), SC_(0.9999999999999999999999999999999999999993), SC_(0.7256057133797268135227356668953765501725e-39) }, 
      { SC_(5), SC_(33), SC_(0.12707412242889404296875), SC_(0.2360864948041268798988934006343364744152e-6), SC_(0.2227374934316260617364011758367105848672e-6), SC_(0.5145469741281724728364396832815268309408), SC_(0.4854530258718275271635603167184731690592) }, 
      { SC_(5), SC_(33), SC_(0.1355634629726409912109375), SC_(0.2639740368361771124229405855684407218344e-6), SC_(0.1948499513995758292123539909026063374479e-6), SC_(0.5753274536738954738691126621376330266273), SC_(0.4246725463261045261308873378623669733727) }, 
      { SC_(5), SC_(33), SC_(0.221111953258514404296875), SC_(0.4290726787828334575184951515484659551106e-6), SC_(0.297513094529194841167994249225811041718e-7), SC_(0.9351574673170037781596974053726083221741), SC_(0.06484253268299622184030259462739167782587) }, 
      { SC_(5), SC_(33), SC_(0.3082362115383148193359375), SC_(0.4569329134568559076654414332637153195377e-6), SC_(0.1891074778897033969853143207331739744606e-8), SC_(0.9958784308855155979182146221767685832027), SC_(0.004121569114484402081785377823231416797273) }, 
      { SC_(5), SC_(33), SC_(0.632396042346954345703125), SC_(0.4588239882121402674046013299751916413373e-6), SC_(0.2361267423069324649585541794503350266984e-16), SC_(0.9999999999485365307043175296609805544201), SC_(0.5146346929568247033901944557993134356637e-10) }, 
      { SC_(5), SC_(33), SC_(0.81474220752716064453125), SC_(0.4588239882357529416258782988046778574158e-6), SC_(0.9416277666369201866561953947069536548985e-26), SC_(0.9999999999999999999794773640703133200699), SC_(0.2052263592968667993014378019832884886546e-19) }, 
      { SC_(5), SC_(33), SC_(0.8350250720977783203125), SC_(0.4588239882357529416350690361458492267544e-6), SC_(0.2255403251978325279789973628337736351731e-27), SC_(0.9999999999999999999995084382443362019728), SC_(0.4915617556637980272423050673357671312551e-21) }, 
      { SC_(5), SC_(33), SC_(0.905801355838775634765625), SC_(0.4588239882357529416352945764681735029791e-6), SC_(0.2873556303208231772042174053171930786083e-35), SC_(0.9999999999999999999999999999937371271405), SC_(0.6262872859497793023689337716277425569307e-29) }, 
      { SC_(5), SC_(33), SC_(0.913384497165679931640625), SC_(0.458823988235752941635294576470861016039e-6), SC_(0.1860432433146185166790861480849446922973e-36), SC_(0.9999999999999999999999999999995945215418), SC_(0.4054784581555613378243180734589156826916e-30) }, 
      { SC_(5), SC_(33), SC_(0.9688708782196044921875), SC_(0.4588239882357529416352945764710470592824e-6), SC_(0.5043120465776822624408006045468302710732e-51), SC_(1), SC_(0.109914054083535982575578830560074837335e-44) }, 
      { SC_(5), SC_(37), SC_(0.12707412242889404296875), SC_(0.1626504642036919834016975929052152351601e-6), SC_(0.1042304188517738705237198755161042773019e-6), SC_(0.6094496628665918248863268636399124339924), SC_(0.3905503371334081751136731363600875660076) }, 
      { SC_(5), SC_(37), SC_(0.1355634629726409912109375), SC_(0.1785340708563088974897302925149156430213e-6), SC_(0.8834681219915695643568717590640386944068e-7), SC_(0.6689653781578808758050445087504637652445), SC_(0.3310346218421191241949554912495362347555) }, 
      { SC_(5), SC_(37), SC_(0.221111953258514404296875), SC_(0.2575879416059304066311258791508165223587e-6), SC_(0.9292941449535447294291589270502990103308e-8), SC_(0.9651794413180051743427623579193180011128), SC_(0.03482055868199482565723764208068199888719) }, 
      { SC_(5), SC_(37), SC_(0.3082362115383148193359375), SC_(0.266506247378562541507712833763002985758e-6), SC_(0.3746356769033124177046346583165267039643e-9), SC_(0.9985962438650000574039849109816345576055), SC_(0.001403756134999942596015089018365442394487) }, 
      { SC_(5), SC_(37), SC_(0.632396042346954345703125), SC_(0.2668808830550841162368525949582861712004e-6), SC_(0.3817376885648734630333412615876398321174e-18), SC_(0.9999999999985696326983243047827487006262), SC_(0.1430367301675695217251299373756270574545e-11) }, 
      { SC_(5), SC_(37), SC_(0.81474220752716064453125), SC_(0.2668808830554658539254076042410641756684e-6), SC_(0.9864180255336793575946139789715629967452e-29), SC_(0.9999999999999999999999630390152250555878), SC_(0.3696098477494441216113442633066656833174e-22) }, 
      { SC_(5), SC_(37), SC_(0.8350250720977783203125), SC_(0.2668808830554658539254173197814100940587e-6), SC_(0.1486399094184032550274416749708991661108e-30), SC_(0.9999999999999999999999994430477458083372), SC_(0.5569522541916628125552736816992094664256e-24) }, 
      { SC_(5), SC_(37), SC_(0.905801355838775634765625), SC_(0.266880883055465853925417468421319310928e-6), SC_(0.201534028457057230761765476521046754852e-39), SC_(0.999999999999999999999999999999999244854), SC_(0.7551459892883088730920276228695969799627e-33) }, 
      { SC_(5), SC_(37), SC_(0.913384497165679931640625), SC_(0.2668808830554658539254174684213195031338e-6), SC_(0.9328165997084304013720170443602910538353e-41), SC_(0.9999999999999999999999999999999999650475), SC_(0.349525447094149162963693414504756697581e-34) }, 
      { SC_(5), SC_(37), SC_(0.9688708782196044921875), SC_(0.266880883055465853925417468421319512462e-6), SC_(0.4221880736804865224264667002914361297586e-57), SC_(1), SC_(0.1581934490200046194666746461325008263844e-50) }, 
      { SC_(9), SC_(1), SC_(0.12707412242889404296875), SC_(0.9600007293119584485871944755170290688733e-9), SC_(0.1111111101511103817991526625239166355941), SC_(0.864000656380762603728475027965326161986e-8), SC_(0.9999999913599934361923739627152497203467) }, 
      { SC_(9), SC_(1), SC_(0.1355634629726409912109375), SC_(0.1718072078585785871462620138863849638492e-8), SC_(0.1111111093930390325253252396484909722473), SC_(0.1546264870727207284316358124977464674643e-7), SC_(0.9999999845373512927279271568364187502254) }, 
      { SC_(9), SC_(1), SC_(0.221111953258514404296875), SC_(0.1403677957818562130364732574093946241147e-6), SC_(0.1111109707433153292548980746378537017165), SC_(0.1263310162036705917328259316684551617033e-5), SC_(0.9999987366898379632940826717406833154484) }, 
      { SC_(9), SC_(1), SC_(0.3082362115383148193359375), SC_(0.2790682407315739714493485678037235803803e-5), SC_(0.1111083204287037953713966176254330738753), SC_(0.2511614166584165743044137110233512223423e-4), SC_(0.9999748838583341583425695586288976648778) }, 
      { SC_(9), SC_(1), SC_(0.632396042346954345703125), SC_(0.001797462261343820207401048841770692354426), SC_(0.1093136488497672909037100622693404187567), SC_(0.01617716035209438186660943957593623118983), SC_(0.9838228396479056181333905604240637688102) }, 
      { SC_(9), SC_(1), SC_(0.81474220752716064453125), SC_(0.01757678454898685216162527733472978560017), SC_(0.09353432656212425894948583377638132551094), SC_(0.1581910609408816694546274960125680704015), SC_(0.8418089390591183305453725039874319295985) }, 
      { SC_(9), SC_(1), SC_(0.8350250720977783203125), SC_(0.02193073217064876341502293890767740093568), SC_(0.08918037894046234769608817220343371017543), SC_(0.1973765895358388707352064501690966084211), SC_(0.8026234104641611292647935498309033915789) }, 
      { SC_(9), SC_(1), SC_(0.905801355838775634765625), SC_(0.04560938206818327137484950287428185938697), SC_(0.06550172904292783973626160823682925172414), SC_(0.4104844386136494423736455258685367344828), SC_(0.5895155613863505576263544741314632655172) }, 
      { SC_(9), SC_(1), SC_(0.913384497165679931640625), SC_(0.04916320816656398360707963717384276476164), SC_(0.06194790294454712750403147393726834634947), SC_(0.4424688734990758524637167345645848828548), SC_(0.5575311265009241475362832654354151171452) }, 
      { SC_(9), SC_(1), SC_(0.9688708782196044921875), SC_(0.08358928519989995718729365410737505997528), SC_(0.02752182591121115392381745700373605113583), SC_(0.7523035667990996146856428869663755397775), SC_(0.2476964332009003853143571130336244602225) }, 
      { SC_(9), SC_(5), SC_(0.12707412242889404296875), SC_(0.5911962348176420782926572925912737568304e-9), SC_(0.0001553995642039205825133218627428628088816), SC_(0.3804347771051526773813249677824846625204e-5), SC_(0.9999961956522289484732261867503221751534) }, 
      { SC_(9), SC_(5), SC_(0.1355634629726409912109375), SC_(0.1022163544547098264140191440738464754833e-8), SC_(0.0001553991332366108530571360152087146616906), SC_(0.6577622409160577329742131921152020697347e-5), SC_(0.9999934223775908394226702578680788479793) }, 
      { SC_(9), SC_(5), SC_(0.221111953258514404296875), SC_(0.580040224947455435634697006166641506016e-7), SC_(0.0001553421513776606546118366856995387360048), SC_(0.0003732558847536875728309275234682338091213), SC_(0.9996267441152463124271690724765317661909) }, 
      { SC_(9), SC_(5), SC_(0.3082362115383148193359375), SC_(0.7678657202757242640909897359639788181599e-6), SC_(0.0001546322896798796758913091656641914213372), SC_(0.004941215909974285639425518950928203694859), SC_(0.9950587840900257143605744810490717963051) }, 
      { SC_(9), SC_(5), SC_(0.632396042346954345703125), SC_(0.6944726970016251324937502025002293600507e-4), SC_(0.8595288569999288690602513515013246415033e-4), SC_(0.4468931805205457727597282553088975931926), SC_(0.5531068194794542272402717446911024068074) }, 
      { SC_(9), SC_(5), SC_(0.81474220752716064453125), SC_(0.0001436598318245511583198180568309052861974), SC_(0.1174032357560424183558209856925011395802e-4), SC_(0.9244510177909867037880291957068755166801), SC_(0.07554898220901329621197080429312448331988) }, 
      { SC_(9), SC_(5), SC_(0.8350250720977783203125), SC_(0.0001477506004315488220256152553071656177256), SC_(0.7649554968606578129784900092989782429797e-5), SC_(0.9507751137770166697348341679016107500643), SC_(0.04922488622298333026516583209838924993574) }, 
      { SC_(9), SC_(5), SC_(0.905801355838775634765625), SC_(0.0001546242206782728300085407133746324580236), SC_(0.7759347218825701468594420255229421317707e-6), SC_(0.9950068600646856611049594905657598673821), SC_(0.004993139935314338895040509434240132617944) }, 
      { SC_(9), SC_(5), SC_(0.913384497165679931640625), SC_(0.0001548620266733779185899240546488179371643), SC_(0.5381287267774815654761007513374629910564e-6), SC_(0.9965371416431869061261612916651434256526), SC_(0.003462858356813093873838708334856574347448) }, 
      { SC_(9), SC_(5), SC_(0.9688708782196044921875), SC_(0.0001553954152106535724229067681317137952525), SC_(0.4740189501827732493387268441604902949926e-8), SC_(0.9999694968805557385414050529275782724495), SC_(0.3050311944426145859494707242172755048277e-4) }, 
      { SC_(9), SC_(9), SC_(0.12707412242889404296875), SC_(0.365114822213992556345329140334181294922e-9), SC_(0.4570227691064709541426012182628942293864e-5), SC_(0.7988347195219943140279456261371552551598e-4), SC_(0.9999201165280478005685972054373862844745) }, 
      { SC_(9), SC_(9), SC_(0.1355634629726409912109375), SC_(0.610152691651135739697098606689513824693e-9), SC_(0.4569982653195272398242660413162586961334e-5), SC_(0.0001334953074063519884883282041575987297046), SC_(0.9998665046925936480115116717958424012703) }, 
      { SC_(9), SC_(9), SC_(0.221111953258514404296875), SC_(0.2423580261394174225971697595057999767884e-7), SC_(0.454635700327298179172264053581869647748e-5), SC_(0.005302551253904313789003477168227397692153), SC_(0.9946974487460956862109965228317726023078) }, 
      { SC_(9), SC_(9), SC_(0.3082362115383148193359375), SC_(0.2172401744211505160711625206970020959146e-6), SC_(0.4353352631465773017911194991072274379244e-5), SC_(0.04752997776160352141120964790329708856515), SC_(0.9524700222383964785887903520967029114349) }, 
      { SC_(9), SC_(9), SC_(0.632396042346954345703125), SC_(0.3978184846839884079699119544393118644599e-5), SC_(0.5924079590470394542832379673761578305602e-6), SC_(0.8703870626400982377973703651177704282517), SC_(0.1296129373599017622026296348822295717483) }, 
      { SC_(9), SC_(9), SC_(0.81474220752716064453125), SC_(0.4563874950628763803259723843591687248194e-5), SC_(0.6717855258159730722633668177589226965175e-8), SC_(0.9985302004480672325151949797394252530323), SC_(0.001469799551932767484805020260574746967711) }, 
      { SC_(9), SC_(9), SC_(0.8350250720977783203125), SC_(0.4567787277591357527778319082868542948224e-5), SC_(0.2805528295566006204038428900733526934415e-8), SC_(0.999386178464213113502618432140808511642), SC_(0.0006138215357868864973815678591914883579807) }, 
      { SC_(9), SC_(9), SC_(0.905801355838775634765625), SC_(0.4570560783709862982580469869987536805188e-5), SC_(0.3202217706055140188764178173966997109798e-10), SC_(0.999992993867880921958781002854573177607), SC_(0.7006132119078041218997145426822392976526e-5) }, 
      { SC_(9), SC_(9), SC_(0.913384497165679931640625), SC_(0.4570576845663014383938801538683062757893e-5), SC_(0.1596022390915004355597308621371726560972e-10), SC_(0.9999965080626109170619703886484673007995), SC_(0.349193738908293802961135153269920054275e-5) }, 
      { SC_(9), SC_(9), SC_(0.9688708782196044921875), SC_(0.4570592803456766122517353841644323447487e-5), SC_(0.2430157411465003670124953027672279152818e-14), SC_(0.9999999994683058599455718470133615270756), SC_(0.5316941400544281529866384729244179558451e-9) }, 
      { SC_(9), SC_(13), SC_(0.12707412242889404296875), SC_(0.2261833503782177598016467634292753146595e-9), SC_(0.3777927705199688414417467188716236662398e-6), SC_(0.0005983386495900259152464822985729020391407), SC_(0.9994016613504099740847535177014270979609) }, 
      { SC_(9), SC_(13), SC_(0.1355634629726409912109375), SC_(0.3655236740663012597289237033544768982873e-9), SC_(0.3776534301962807579418194419316984646562e-6), SC_(0.0009669453616647713634491028971428325524223), SC_(0.9990330546383352286365508971028571674476) }, 
      { SC_(9), SC_(13), SC_(0.221111953258514404296875), SC_(0.1025595542826979075957219535902627155099e-7), SC_(0.3677629984420772684419761702760266700035e-6), SC_(0.02713079681128205638164949843690732797285), SC_(0.9728692031887179436183505015630926720272) }, 
      { SC_(9), SC_(13), SC_(0.3082362115383148193359375), SC_(0.6358531377806950417496665184007671141947e-7), SC_(0.314433640092277555026581713794976230135e-6), SC_(0.1682066815090917242593315317781837300877), SC_(0.8317933184909082757406684682218162699123) }, 
      { SC_(9), SC_(13), SC_(0.632396042346954345703125), SC_(0.3716509420878360768872488222881018243539e-6), SC_(0.6368011782510982314299543346951117200584e-8), SC_(0.9831542526708989227152214170162759230911), SC_(0.01684574732910107728477858298372407690891) }, 
      { SC_(9), SC_(13), SC_(0.81474220752716064453125), SC_(0.3780137764914382886251099671839297353021e-6), SC_(0.5177378908770576438398451123206252371508e-11), SC_(0.9999863039171561055802071538893522038762), SC_(0.1369608284389441979284611064779612383602e-4) }, 
      { SC_(9), SC_(13), SC_(0.8350250720977783203125), SC_(0.3780175833039471887910119484759429363003e-6), SC_(0.1370566399870410536417159110005254203661e-11), SC_(0.9999963743447627748120792781398051654007), SC_(0.3625655237225187920721860194834599312739e-5) }, 
      { SC_(9), SC_(13), SC_(0.905801355838775634765625), SC_(0.3780189521674069635165612543056322249926e-6), SC_(0.1702940095684987111329420716561926998646e-14), SC_(0.9999999954950933590778056453024903190286), SC_(0.4504906640922194354697509680971424824409e-8) }, 
      { SC_(9), SC_(13), SC_(0.913384497165679931640625), SC_(0.3780189532622542197475672763943742938078e-6), SC_(0.6080928394539810892406786477466645613037e-15), SC_(0.9999999983913694452936220459553859256104), SC_(0.1608630554706377954044614074389594030536e-8) }, 
      { SC_(9), SC_(13), SC_(0.9688708782196044921875), SC_(0.3780189538703454911038381761736583857504e-6), SC_(0.1568097710189461394555804090932182962311e-20), SC_(0.9999999999999958518013603961045106839125), SC_(0.4148198639603895489316087468029268843008e-14) }, 
      { SC_(9), SC_(17), SC_(0.12707412242889404296875), SC_(0.1405816969722189388567383083558414104832e-9), SC_(0.5424633498635044096207749295297193357997e-7), SC_(0.002584844031346370879497604509619475950238), SC_(0.9974151559686536291205023954903805240498) }, 
      { SC_(9), SC_(17), SC_(0.1355634629726409912109375), SC_(0.219827311566730938457448707610070806601e-9), SC_(0.5416708937175592896247678255371770418385e-7), SC_(0.004041915316632379250955956460867159655041), SC_(0.995958084683367620749044043539132840345) }, 
      { SC_(9), SC_(17), SC_(0.221111953258514404296875), SC_(0.4403759649937895651506999528497174447242e-8), SC_(0.4998315703338476424942723173283060054321e-7), SC_(0.08097093783748685131773761125558363469719), SC_(0.9190290621625131486822623887444163653028) }, 
      { SC_(9), SC_(17), SC_(0.3082362115383148193359375), SC_(0.1939268463451185948776872401679044738104e-7), SC_(0.3499423204881080041316550724453732760941e-7), SC_(0.3565689290207267952332187805338221781445), SC_(0.6434310709792732047667812194661778218555) }, 
      { SC_(9), SC_(17), SC_(0.632396042346954345703125), SC_(0.5430543083648195549548238757030435069709e-7), SC_(0.8148584684070440545184369102342429335785e-10), SC_(0.9985017380684555072554481767179827777885), SC_(0.001498261931544492744551823282017222211505) }, 
      { SC_(9), SC_(17), SC_(0.81474220752716064453125), SC_(0.5438691216175813790086103883960385391871e-7), SC_(0.4521564522000073192421723921071736173815e-14), SC_(0.9999999168630104860021042274100571511362), SC_(0.831369895139978957725899428488637718873e-7) }, 
      { SC_(9), SC_(17), SC_(0.8350250720977783203125), SC_(0.543869159273491028994886950315149108395e-7), SC_(0.7559735570014455362298128641509463332837e-15), SC_(0.999999986100084301464746250588082574751), SC_(0.1389991569853525374941191742524901626716e-7) }, 
      { SC_(9), SC_(17), SC_(0.905801355838775634765625), SC_(0.5438691668322151247695198624115232674994e-7), SC_(0.101147423982245020175448240505006769982e-18), SC_(0.9999999999981402250734088568191635726777), SC_(0.1859774926591143180836427322311445853136e-11) }, 
      { SC_(9), SC_(17), SC_(0.913384497165679931640625), SC_(0.5438691668329680959974693067868335200459e-7), SC_(0.2585030118730058264442298585501309228758e-19), SC_(0.9999999999995246963283868713295480895543), SC_(0.475303671613128670451910445744308349946e-12) }, 
      { SC_(9), SC_(17), SC_(0.9688708782196044921875), SC_(0.5438691668332265989981286920192394657951e-7), SC_(0.1121362059403828410940572756400961267229e-26), SC_(0.9999999999999999999793817681202051728694), SC_(0.2061823187979482713057184964307428460426e-19) }, 
      { SC_(9), SC_(21), SC_(0.12707412242889404296875), SC_(0.8768914672004667740277052868479883353486e-10), SC_(0.1100677472135701480295706065573409173228e-7), SC_(0.007903865185623009669799204727678133676613), SC_(0.9920961348143769903302007952723218663234) }, 
      { SC_(9), SC_(21), SC_(0.1355634629726409912109375), SC_(0.1327634015137674561649132693037503578721e-9), SC_(0.1096170046656329402419491791511514020794e-7), SC_(0.01196663516979649778095998494979065717557), SC_(0.9880333648302035022190400150502093428244) }, 
      { SC_(9), SC_(21), SC_(0.221111953258514404296875), SC_(0.1922672531283948327609305550541565130277e-8), SC_(0.917179133679311315275052563387732543554e-8), SC_(0.1733001751275425902867394982168137473879), SC_(0.8266998248724574097132605017831862526121) }, 
      { SC_(9), SC_(21), SC_(0.3082362115383148193359375), SC_(0.6210682675170413227453775424547729841374e-8), SC_(0.4883781192906648252906055759871160724443e-8), SC_(0.5598001624072055789251412833115037339001), SC_(0.4401998375927944210748587166884962660999) }, 
      { SC_(9), SC_(21), SC_(0.632396042346954345703125), SC_(0.1109332286589567728080756173149978998778e-7), SC_(0.1141002181384199552269452919100578033294e-11), SC_(0.9998971557170358370110672130090114880394), SC_(0.0001028442829641629889327869909885119605569) }, 
      { SC_(9), SC_(21), SC_(0.81474220752716064453125), SC_(0.1109446386384866611786130719707792051271e-7), SC_(0.4228395362498523987340970053102520559123e-17), SC_(0.99999999961887339372340422796744223392), SC_(0.38112660627659577203255776608004808021e-9) }, 
      { SC_(9), SC_(21), SC_(0.8350250720977783203125), SC_(0.1109446386763128060547137188768980063864e-7), SC_(0.4457808748884592967290899271816976280214e-18), SC_(0.9999999999598195207817893513086551266044), SC_(0.401804792182106486913448733955690388781e-10) }, 
      { SC_(9), SC_(21), SC_(0.905801355838775634765625), SC_(0.1109446386807705508865848396211270588468e-7), SC_(0.6391701347222306184681139076368879875802e-23), SC_(0.9999999999999994238837114415568070399872), SC_(0.576116288558443192960012781299767424205e-15) }, 
      { SC_(9), SC_(21), SC_(0.913384497165679931640625), SC_(0.1109446386807706031175078794921786520131e-7), SC_(0.1168609043235201025364511247610860798748e-23), SC_(0.9999999999999998946673713005882099947236), SC_(0.1053326286994117900052763627064110805839e-15) }, 
      { SC_(9), SC_(21), SC_(0.9688708782196044921875), SC_(0.1109446386807706148035983033424803803278e-7), SC_(0.8501708525330398886156929343196786267896e-33), SC_(0.9999999999999999999999999233698119492461), SC_(0.7663018805075391434717047034108627741122e-25) }, 
      { SC_(9), SC_(25), SC_(0.12707412242889404296875), SC_(0.5490758403303128374170602424503878959011e-10), SC_(0.2826074162354721778093669492999221502501e-8), SC_(0.01905863655744288740875275366894751951801), SC_(0.980941363442557112591247246331052480482) }, 
      { SC_(9), SC_(25), SC_(0.1355634629726409912109375), SC_(0.8054869498750192807248003186160847620173e-10), SC_(0.2800433051400251133762895485382651815889e-8), SC_(0.02795876617007237049147730173128856236268), SC_(0.9720412338299276295085226982687114376373) }, 
      { SC_(9), SC_(25), SC_(0.221111953258514404296875), SC_(0.8554800556152143717442153924434872614658e-9), SC_(0.2025501690772538690091160124800773030625e-8), SC_(0.2969404636762578077684669651571649580551), SC_(0.7030595363237421922315330348428350419449) }, 
      { SC_(9), SC_(25), SC_(0.3082362115383148193359375), SC_(0.2104446012990466374535163580402195482282e-8), SC_(0.7765357333972866873002119368420648098089e-9), SC_(0.7304614184484415414200159658955656204626), SC_(0.2695385815515584585799840341044343795374) }, 
      { SC_(9), SC_(25), SC_(0.632396042346954345703125), SC_(0.2880964877142493115694532299196703738177e-8), SC_(0.1686924525994614084321804755655391435629e-13), SC_(0.9999941446191802161807233697271427346658), SC_(0.5855380819783819276630272857265334233333e-5) }, 
      { SC_(9), SC_(25), SC_(0.81474220752716064453125), SC_(0.2880981746383624885033409613998148623252e-8), SC_(0.4128176801965903246111668838875453117095e-20), SC_(0.9999999999985670937321481073162519799105), SC_(0.1432906267851892683748020089482141391211e-11) }, 
      { SC_(9), SC_(25), SC_(0.8350250720977783203125), SC_(0.2880981746387478864640885646284461723272e-8), SC_(0.2741971944898709597985688190228332374008e-21), SC_(0.9999999999999048250844235072793571735485), SC_(0.9517491557649272064282645150121960575143e-13) }, 
      { SC_(9), SC_(25), SC_(0.905801355838775634765625), SC_(0.2880981746387753061415142486660740151915e-8), SC_(0.4202330305835201401758370334655908953849e-27), SC_(0.9999999999999999998541354761756408836164), SC_(0.1458645238243591163835797200803371155926e-18) }, 
      { SC_(9), SC_(25), SC_(0.913384497165679931640625), SC_(0.2880981746387753061780424050251452838414e-8), SC_(0.5495146699280745367708579396857089233567e-28), SC_(0.9999999999999999999809261314960752608796), SC_(0.1907386850392473912038581972108743415619e-19) }, 
      { SC_(9), SC_(25), SC_(0.9688708782196044921875), SC_(0.2880981746387753061835375517243590921079e-8), SC_(0.6693710121702900475154372706269412258546e-39), SC_(0.9999999999999999999999999999997676587111), SC_(0.2323412888712551396237935868399667445649e-30) }, 
      { SC_(9), SC_(29), SC_(0.12707412242889404296875), SC_(0.3452371057410482986140888659571381026189e-10), SC_(0.8586264333775833212640254947439217333912e-9), SC_(0.03865387114125827184819027413408647032515), SC_(0.9613461288587417281518097258659135296749) }, 
      { SC_(9), SC_(29), SC_(0.1355634629726409912109375), SC_(0.4911185816313617700142369684998872055879e-10), SC_(0.8440382857885519741240106844896468230943e-9), SC_(0.05498723646378621874744067737729074417013), SC_(0.9450127635362137812525593226227092558299) }, 
      { SC_(9), SC_(29), SC_(0.221111953258514404296875), SC_(0.3888497801301485178490666386636823315268e-9), SC_(0.5043003638215396332763677426759532121263e-9), SC_(0.4353688825595509208225265312389464011478), SC_(0.5646311174404490791774734687610535988522) }, 
      { SC_(9), SC_(29), SC_(0.3082362115383148193359375), SC_(0.7592087943688000689521139738405827604688e-9), SC_(0.1339413495828880821733204074990527831843e-9), SC_(0.8500349011978290927050332649851841848072), SC_(0.1499650988021709072949667350148158151928) }, 
      { SC_(9), SC_(29), SC_(0.632396042346954345703125), SC_(0.8931498853652602449945499332845656074749e-9), SC_(0.2585864279061308844480550699361782222622e-15), SC_(0.9999997104782105704746800277422260652763), SC_(0.2895217894295253199722577739347236583312e-6) }, 
      { SC_(9), SC_(29), SC_(0.81474220752716064453125), SC_(0.8931501439516839998949414346601599624334e-9), SC_(0.4151230492946679475581219656326947232619e-23), SC_(0.999999999999995352147093007437456321952), SC_(0.4647852906992562543678047963360053253581e-14) }, 
      { SC_(9), SC_(29), SC_(0.8350250720977783203125), SC_(0.8931501439516879774963097346160686112977e-9), SC_(0.1736291246467235669323553649753388014101e-24), SC_(0.9999999999999998055991752086473042087243), SC_(0.1944008247913526957912757227641802185969e-15) }, 
      { SC_(9), SC_(29), SC_(0.905801355838775634765625), SC_(0.8931501439516881511254059811626303005332e-9), SC_(0.2840017700524311984063840724224177571042e-31), SC_(0.9999999999999999999999682022365471629722), SC_(0.3179776345283702779442316874772184432244e-22) }, 
      { SC_(9), SC_(29), SC_(0.913384497165679931640625), SC_(0.8931501439516881511254317256115259571246e-9), SC_(0.2655728109586528453005070615648804265977e-32), SC_(0.9999999999999999999999970265602848851124), SC_(0.2973439715114887585081475966481059094231e-23) }, 
      { SC_(9), SC_(29), SC_(0.9688708782196044921875), SC_(0.893150143951688151125434381339635543112e-9), SC_(0.5411285344768365457940643138260757523988e-45), SC_(0.9999999999999999999999999999999999993941), SC_(0.6058651371679194520056963763750188659337e-36) }, 
      { SC_(9), SC_(33), SC_(0.12707412242889404296875), SC_(0.2180414614903352446359330756444194325311e-10), SC_(0.2953448533227024873313175283491878992448e-9), SC_(0.06875048064270083638580992874041251871339), SC_(0.9312495193572991636141900712595874812866) }, 
      { SC_(9), SC_(33), SC_(0.1355634629726409912109375), SC_(0.3010491921805923699749491128345171935457e-10), SC_(0.2870440802536767747974159246301781231434e-9), SC_(0.09492358250602696923794036959562880777653), SC_(0.9050764174939730307620596304043711922235) }, 
      { SC_(9), SC_(33), SC_(0.221111953258514404296875), SC_(0.1809996092362792695419651818580881215635e-9), SC_(0.1361493902354567422529456540555417209344e-9), SC_(0.5707084352710050596423519902623232493344), SC_(0.4292915647289949403576480097376767506656) }, 
      { SC_(9), SC_(33), SC_(0.3082362115383148193359375), SC_(0.2927589155916207427645318631547645209126e-9), SC_(0.243900838801152690303789727588653215853e-10), SC_(0.9230958195651224563326664364435911409284), SC_(0.07690418043487754366733356355640885907159) }, 
      { SC_(9), SC_(33), SC_(0.632396042346954345703125), SC_(0.3171489954046790723255138774566892446515e-9), SC_(0.4067056939469396958456940597846390425167e-17), SC_(0.9999999871761949549147203505663467876154), SC_(0.1282380504508527964943365321238462169541e-7) }, 
      { SC_(9), SC_(33), SC_(0.81474220752716064453125), SC_(0.3171489994717360075296266753530419707679e-9), SC_(0.4265284160560587871729976126969716350339e-26), SC_(0.9999999999999999865511662730605412187012), SC_(0.1344883372693945878129878298318716765895e-16) }, 
      { SC_(9), SC_(33), SC_(0.8350250720977783203125), SC_(0.3171489994717360116826067472843899435575e-9), SC_(0.1123040886292398989404234096407758667584e-27), SC_(0.9999999999999999996458948670300051750848), SC_(0.3541051329699948249152489394870430787349e-18) }, 
      { SC_(9), SC_(33), SC_(0.905801355838775634765625), SC_(0.3171489994717360117949108339550478058366e-9), SC_(0.1958582036661275320842735719191727187854e-35), SC_(0.9999999999999999999999999938244104823802), SC_(0.6175589517619847040155065525930217593502e-26) }, 
      { SC_(9), SC_(33), SC_(0.913384497165679931640625), SC_(0.317148999471736011794910835782670236395e-9), SC_(0.1309596061029528241043983124271877347579e-36), SC_(0.9999999999999999999999999995870723025421), SC_(0.4129276974579382448119755326015227852742e-27) }, 
      { SC_(9), SC_(33), SC_(0.9688708782196044921875), SC_(0.3171489994717360117949108359136298424979e-9), SC_(0.4460790569104597941105137765177222559491e-51), SC_(1), SC_(0.1406528343628635330520590604021488907461e-41) }, 
      { SC_(9), SC_(37), SC_(0.12707412242889404296875), SC_(0.1383704492141968468396235002853402389294e-10), SC_(0.1115474432418247850954210037047614952341e-9), SC_(0.1103569119603098678722640429092774506042), SC_(0.8896430880396901321277359570907225493958) }, 
      { SC_(9), SC_(37), SC_(0.1355634629726409912109375), SC_(0.1856085101182889844926537002203677054054e-10), SC_(0.1068236371514155713301179837112587485865e-9), SC_(0.1480314772881919686005787487109681130073), SC_(0.8519685227118080313994212512890318869927) }, 
      { SC_(9), SC_(37), SC_(0.221111953258514404296875), SC_(0.8647787220309051130283136633381664942978e-10), SC_(0.3890661596015395847655198739947886969731e-10), SC_(0.689701521056580397663829801700375767165), SC_(0.310298478943419602336170198299624232835) }, 
      { SC_(9), SC_(37), SC_(0.3082362115383148193359375), SC_(0.1207708075515478329224629779078500515997e-9), SC_(0.4613680611696636856920375825445467527391e-11), SC_(0.9632037369272517155252340398183052855195), SC_(0.03679626307274828447476596018169471448052) }, 
      { SC_(9), SC_(37), SC_(0.632396042346954345703125), SC_(0.1253844880980385959590801961350683341059e-9), SC_(0.6520587382030315759822718502118352040574e-19), SC_(0.9999999994799526259148715449112033455146), SC_(0.5200473740851284550887966544853732686778e-9) }, 
      { SC_(9), SC_(37), SC_(0.81474220752716064453125), SC_(0.1253844881632444697749284881276179716098e-9), SC_(0.4454865605677547517242647788609988719479e-29), SC_(0.9999999999999999999644703609598219962371), SC_(0.3552963904017800376292090188049900406371e-19) }, 
      { SC_(9), SC_(37), SC_(0.8350250720977783203125), SC_(0.1253844881632444697793095310414124232805e-9), SC_(0.7382269188309584656546054091780188010287e-31), SC_(0.9999999999999999999994112294673406305799), SC_(0.5887705326593694200813474609266358224277e-21) }, 
      { SC_(9), SC_(37), SC_(0.905801355838775634765625), SC_(0.1253844881632444697793833537331583374179e-9), SC_(0.1371817091855418534944290435586179007902e-39), SC_(0.9999999999999999999999999999989059116387), SC_(0.1094088361288662590097005516474607557082e-29) }, 
      { SC_(9), SC_(37), SC_(0.913384497165679931640625), SC_(0.125384488163244469779383353733288960736e-9), SC_(0.6558391105453115676973948995295981791386e-41), SC_(0.9999999999999999999999999999999476937602), SC_(0.5230623980308003725442393759501428729441e-31) }, 
      { SC_(9), SC_(37), SC_(0.9688708782196044921875), SC_(0.1253844881632444697793833537332955191271e-9), SC_(0.3732881801413353628047212232725882164977e-57), SC_(1), SC_(0.2977148015752414393704547368146445601461e-47) }, 
      { SC_(13), SC_(1), SC_(0.12707412242889404296875), SC_(0.1733002529979310893170054451864859513361e-12), SC_(0.07692307692290362282392514583375991763174), SC_(0.225290328897310416112107078742431736737e-11), SC_(0.9999999999977470967110268958388789292126) }, 
      { SC_(13), SC_(1), SC_(0.1355634629726409912109375), SC_(0.4017086232034524013346443940305631574062e-12), SC_(0.07692307692267521445371962452174227868289), SC_(0.5222212101644881217350377122397321046281e-11), SC_(0.9999999999947777878983551187826496228776) }, 
      { SC_(13), SC_(1), SC_(0.221111953258514404296875), SC_(0.2322819811850248034763754868397705193984e-9), SC_(0.07692307669079494189189827344670143623715), SC_(0.301966575540532244519288132891701675218e-8), SC_(0.999999996980334244594677554807118671083) }, 
      { SC_(13), SC_(1), SC_(0.3082362115383148193359375), SC_(0.1743990860218583594833841527485473727731e-7), SC_(0.07692305948316832089108712858466164822219), SC_(0.2267188118284158673283993985731115846051e-6), SC_(0.9999997732811881715841326716006014268884) }, 
      { SC_(13), SC_(1), SC_(0.632396042346954345703125), SC_(0.0001990286107315085858608431972838241951467), SC_(0.07672404831234541449106223372579309888178), SC_(0.002587371939509611616190961564689714536907), SC_(0.9974126280604903883838090384353102854631) }, 
      { SC_(13), SC_(1), SC_(0.81474220752716064453125), SC_(0.005361909111769781127530574652935057460667), SC_(0.07156116781130714194939250227014186561626), SC_(0.06970481845300715465789747048815574698867), SC_(0.9302951815469928453421025295118442530113) }, 
      { SC_(13), SC_(1), SC_(0.8350250720977783203125), SC_(0.007381597333093284397839696122287263460674), SC_(0.06954147958998363867908338080078965961625), SC_(0.09596076533021269717191604958973442498876), SC_(0.9040392346697873028280839504102655750112) }, 
      { SC_(13), SC_(1), SC_(0.905801355838775634765625), SC_(0.02125617960979388014145807905051735104901), SC_(0.05566689731328304293546499787255957202792), SC_(0.2763303349273204418389550276567255636371), SC_(0.7236696650726795581610449723432744363629) }, 
      { SC_(13), SC_(1), SC_(0.913384497165679931640625), SC_(0.0236893921175736522609622831934239337223), SC_(0.05323368480550327081596079372965298935463), SC_(0.3079620975284574793925096815145111383899), SC_(0.6920379024715425206074903184854888616101) }, 
      { SC_(13), SC_(1), SC_(0.9688708782196044921875), SC_(0.05099333051512162562167400412619472990646), SC_(0.02592974640795529745524907279688219317046), SC_(0.662913296696581133081762053640531488784), SC_(0.337086703303418866918237946359468511216) }, 
      { SC_(13), SC_(5), SC_(0.12707412242889404296875), SC_(0.1049349708530902245175333182105057233316e-12), SC_(0.323206204509797027086421607442637082924e-4), SC_(0.3246687998194611546572480865433047079879e-8), SC_(0.999999996753312001805388453427519134567) }, 
      { SC_(13), SC_(5), SC_(0.1355634629726409912109375), SC_(0.2346793115735462331255442924335212726727e-12), SC_(0.3232062032123536198818615213625273406939e-4), SC_(0.7260977900085520452904340407893148176494e-8), SC_(0.9999999927390220999144795470956595921069) }, 
      { SC_(13), SC_(5), SC_(0.221111953258514404296875), SC_(0.9283197775127802819707660619041861159179e-10), SC_(0.323205277239369222837041881851908360843e-4), SC_(0.287222139162454219241755019553155184265e-5), SC_(0.9999971277786083754578075824498044684482) }, 
      { SC_(13), SC_(5), SC_(0.3082362115383148193359375), SC_(0.4550032329452985234731567480169189521966e-8), SC_(0.3231607052358522057649765369431685731339e-4), SC_(0.0001407780002732753631625946978364347238096), SC_(0.9998592219997267246368374053021635652762) }, 
      { SC_(13), SC_(5), SC_(0.632396042346954345703125), SC_(0.6181001903713975786046925273586262555986e-5), SC_(0.2613961865220069777568545998821076394692e-4), SC_(0.1912401989009104108202918679647589634822), SC_(0.8087598010990895891797081320352410365178) }, 
      { SC_(13), SC_(5), SC_(0.81474220752716064453125), SC_(0.2606209419824176335745101937952663193835e-4), SC_(0.6258526357672910204281365882270394564562e-5), SC_(0.8063611944936001582795345396025539921725), SC_(0.1936388055063998417204654603974460078275) }, 
      { SC_(13), SC_(5), SC_(0.8350250720977783203125), SC_(0.2795251768014809625638517612767087995285e-4), SC_(0.4368102875766577305347209134126146550057e-5), SC_(0.8648508970237820981725573493901370257412), SC_(0.1351491029762179018274426506098629742588) }, 
      { SC_(13), SC_(5), SC_(0.905801355838775634765625), SC_(0.3175635978581118945601414806607578908808e-4), SC_(0.5642607701034841057182371957212374148304e-6), SC_(0.9825417717729982017690777411643849143851), SC_(0.01745822822700179823092225883561508561485) }, 
      { SC_(13), SC_(5), SC_(0.913384497165679931640625), SC_(0.3191902782278661757531614604545866868971e-4), SC_(0.4015927331280559864162392163383578131963e-6), SC_(0.9875747208370179477802815586464912092597), SC_(0.01242527916298205221971844135350879074029) }, 
      { SC_(13), SC_(5), SC_(0.9688708782196044921875), SC_(0.3231635005339767867915412929179819769162e-4), SC_(0.4270502516994882578255969998828811287032e-8), SC_(0.9998678706521241783330287602882362365788), SC_(0.0001321293478758216669712397117637634212208) }, 
      { SC_(13), SC_(9), SC_(0.12707412242889404296875), SC_(0.6363687477274261679783312058957698481325e-13), SC_(0.3780188902334722864589315678019323519775e-6), SC_(0.1683430794175701361984838022140492683154e-6), SC_(0.9999998316569205824298638015161977859507) }, 
      { SC_(13), SC_(9), SC_(0.1355634629726409912109375), SC_(0.1373455500114442324959819423891593714353e-12), SC_(0.3780188165247970477573158696531105523951e-6), SC_(0.3633297976337742293178957509380105264139e-6), SC_(0.9999996366702023662257706821042490619895) }, 
      { SC_(13), SC_(9), SC_(0.221111953258514404296875), SC_(0.3732275227173758385929218866367623226223e-10), SC_(0.3779816311180753216176890734463892653222e-6), SC_(0.9873248917708645221385577712522919453954e-4), SC_(0.9999012675108229135477861442228747708055) }, 
      { SC_(13), SC_(9), SC_(0.3082362115383148193359375), SC_(0.1205092410397426794177708544466782614586e-8), SC_(0.3768138614599496324073706570905861589399e-6), SC_(0.003187915309693040918513884852276092725146), SC_(0.9968120846903069590814861151477239072749) }, 
      { SC_(13), SC_(9), SC_(0.632396042346954345703125), SC_(0.2435153729309657811172960805971441642318e-6), SC_(0.1345035809393812780842522850379087773227e-6), SC_(0.6441882620903889483942615327292672577339), SC_(0.3558117379096110516057384672707327422661) }, 
      { SC_(13), SC_(9), SC_(0.81474220752716064453125), SC_(0.3747233990110008640796533407529882362731e-6), SC_(0.3295554859346195121895024882064705281355e-8), SC_(0.9912820380417313558103925580277324905899), SC_(0.008717961958268644189607441972267509410139) }, 
      { SC_(13), SC_(9), SC_(0.8350250720977783203125), SC_(0.3765246072329650647349975718758926023878e-6), SC_(0.1494346637381994466550793759160339166682e-8), SC_(0.9960469002358687932980205267133300135786), SC_(0.003953099764131206701979473286669986421366) }, 
      { SC_(13), SC_(9), SC_(0.905801355838775634765625), SC_(0.3779964077422230446218278996721603303988e-6), SC_(0.2254612812401457972046596289261115570025e-10), SC_(0.999940357149044575551244870955742773227), SC_(0.5964285095542444875512904425722677295477e-4) }, 
      { SC_(13), SC_(9), SC_(0.913384497165679931640625), SC_(0.3780073845848789164271692216597818292162e-6), SC_(0.1156928546814277437914397527111233829272e-10), SC_(0.9999693949593011391489406439021370575537), SC_(0.3060504069886085105935609786294244634941e-4) }, 
      { SC_(13), SC_(9), SC_(0.9688708782196044921875), SC_(0.3780189517005877565620978926009516832973e-6), SC_(0.2169759302639450473034101258257187460391e-14), SC_(0.9999999942601838335766769021497795544442), SC_(0.5739816166423323097850220445555815992096e-8) }, 
      { SC_(13), SC_(13), SC_(0.12707412242889404296875), SC_(0.3865512569645572509527745473777219147141e-13), SC_(0.1479200736588788412172679729087342081038e-7), SC_(0.2613237252070623193768627522346877455014e-5), SC_(0.9999973867627479293768062313724776531225) }, 
      { SC_(13), SC_(13), SC_(0.1355634629726409912109375), SC_(0.8053474330512965176841139593170463471869e-13), SC_(0.1479196548627027544780012415693222687793e-7), SC_(0.5444462732925654465186507169427366955059e-5), SC_(0.999994555537267074345534813492830572633) }, 
      { SC_(13), SC_(13), SC_(0.221111953258514404296875), SC_(0.1510649711093669926167337485247019111029e-10), SC_(0.1477693952390264387819021919347568839146e-7), SC_(0.001021258120038053523216240666188909552801), SC_(0.9989787418799619464767837593338110904472) }, 
      { SC_(13), SC_(13), SC_(0.3082362115383148193359375), SC_(0.3249523214780560632663394943820884813598e-9), SC_(0.1446709369953552451418555307394607010121e-7), SC_(0.021968044245970354295451288544257271485), SC_(0.978031955754029645704548711455742728515) }, 
      { SC_(13), SC_(13), SC_(0.632396042346954345703125), SC_(0.1351041388183666100932354368198339988506e-7), SC_(0.128163213917691956812834888634475869751e-8), SC_(0.9133566690262974472082079147224375674894), SC_(0.08664333097370255279179208527756243251058) }, 
      { SC_(13), SC_(13), SC_(0.81474220752716064453125), SC_(0.1478959002596594700180977920542784489939e-7), SC_(0.2455995047633575642113362900313683179346e-11), SC_(0.9998339651563992845156481324258234837937), SC_(0.0001660348436007154843518675741765162062882) }, 
      { SC_(13), SC_(13), SC_(0.8350250720977783203125), SC_(0.1479133632664708284107024225320482872398e-7), SC_(0.7096943664977363816503151233298585846847e-12), SC_(0.9999520218930167236794285502614339205732), SC_(0.4797810698327632057144973856607942677317e-4) }, 
      { SC_(13), SC_(13), SC_(0.905801355838775634765625), SC_(0.1479204483796327352001603122554367964044e-7), SC_(0.1183050307057435861342784478942127933193e-14), SC_(0.9999999200211853467198117733685323640443), SC_(0.7997881465328018822663146763595572258276e-7) }, 
      { SC_(13), SC_(13), SC_(0.913384497165679931640625), SC_(0.1479204558551398483926670877926456970178e-7), SC_(0.4354995957381851837890635888807889631726e-15), SC_(0.999999970558528879675302653642524043662), SC_(0.2944147112032469734635747595633796898742e-7) }, 
      { SC_(13), SC_(13), SC_(0.9688708782196044921875), SC_(0.1479204602101218583185030998840780895963e-7), SC_(0.1394745601582579920349622939142522909086e-20), SC_(0.9999999999999057097578251714253226761258), SC_(0.9429024217482857467732387421549720449357e-13) }, 
      { SC_(13), SC_(17), SC_(0.12707412242889404296875), SC_(0.2352124847988583066925872856168985685137e-13), SC_(0.1133466595304284909376372317388538584669e-8), SC_(0.2075117209792706588915857708554170512241e-4), SC_(0.9999792488279020729341108414229144582949) }, 
      { SC_(13), SC_(17), SC_(0.1355634629726409912109375), SC_(0.47319270822763713423074609346223051508e-13), SC_(0.1133442797281942031493618501507754051475e-8), SC_(0.4174652264871421726676262625529372760153e-4), SC_(0.9999582534773512857827332373737447062724) }, 
      { SC_(13), SC_(17), SC_(0.221111953258514404296875), SC_(0.6160762906790184416410860361106870045241e-11), SC_(0.1127329353645974610790630715755993404481e-8), SC_(0.005435215373140305974905206024099337150662), SC_(0.9945647846268596940250947939759006628493) }, 
      { SC_(13), SC_(17), SC_(0.3082362115383148193359375), SC_(0.8952226461288120516359735057745244768884e-10), SC_(0.1043967851939883590043444225539647826837e-8), SC_(0.07897930763184901416015911201957463974446), SC_(0.9210206923681509858398408879804253602555) }, 
      { SC_(13), SC_(17), SC_(0.632396042346954345703125), SC_(0.11180679479784150696274141584955338368e-8), SC_(0.1542216857434972557962741762156643772574e-10), SC_(0.9863940864158105675588809095851866703433), SC_(0.01360591358418943244111909041481332965674) }, 
      { SC_(13), SC_(17), SC_(0.81474220752716064453125), SC_(0.1133488009470085581960423750432941428013e-8), SC_(0.2107082679213246617825684158846512945387e-14), SC_(0.9999981410665620786995404999237105535187), SC_(0.1858933437921300459500076289446481283438e-5) }, 
      { SC_(13), SC_(17), SC_(0.8350250720977783203125), SC_(0.1133489730946306587794199409101569817382e-8), SC_(0.3856064582074128421670155304571442322139e-15), SC_(0.9999996598060692578940726205001490858939), SC_(0.3401939307421059273794998509141061151301e-6) }, 
      { SC_(13), SC_(17), SC_(0.905801355838775634765625), SC_(0.113349011648300562407403591833334958047e-8), SC_(0.6975917113300565778375069405658671871199e-19), SC_(0.9999999999384563040168702544933779087256), SC_(0.615436959831297455066220912744136814944e-10) }, 
      { SC_(13), SC_(17), SC_(0.913384497165679931640625), SC_(0.1133490116534372810871580625101502830968e-8), SC_(0.1839198433546095101559744355783714171321e-19), SC_(0.9999999999837740231989003049479583084103), SC_(0.1622597680109969505204169158974264579789e-10) }, 
      { SC_(13), SC_(17), SC_(0.9688708782196044921875), SC_(0.1133490116552764794211739397096407765002e-8), SC_(0.9953021790206925095238592270107470107856e-27), SC_(0.999999999999999999121913667807124223803), SC_(0.878086332192875776197030349699699509944e-18) }, 
      { SC_(13), SC_(21), SC_(0.12707412242889404296875), SC_(0.1433895809524435166472862460535204215339e-13), SC_(0.134192885252514370330107422799816711254e-9), SC_(0.0001068419243418850176591475313048984543213), SC_(0.9998931580756581149823408524686951015457) }, 
      { SC_(13), SC_(21), SC_(0.1355634629726409912109375), SC_(0.278638317836437586917685567700386414577e-13), SC_(0.1341793603788259709230803828676520246547e-9), SC_(0.0002076179724864692641685405328416723082277), SC_(0.9997923820275135307358314594671583276918) }, 
      { SC_(13), SC_(21), SC_(0.221111953258514404296875), SC_(0.253398575663959635332944201416930086486e-11), SC_(0.1316732384539700183284427094102527624313e-9), SC_(0.01888114273686970946337263954382202054201), SC_(0.981118857263130290536627360456177979458) }, 
      { SC_(13), SC_(21), SC_(0.3082362115383148193359375), SC_(0.2530203856516996717200426497794949951687e-10), SC_(0.1089051856454396475097678864464725637793e-9), SC_(0.1885296317988353150256291788889639107923), SC_(0.8114703682011646849743708211110360892077) }, 
      { SC_(13), SC_(21), SC_(0.632396042346954345703125), SC_(0.133998982951326656037504620619304022662e-9), SC_(0.2082412592829586442675308051180406341264e-12), SC_(0.9984483602838237053355733884909220653095), SC_(0.001551639716176294664426611509077934690489) }, 
      { SC_(13), SC_(21), SC_(0.81474220752716064453125), SC_(0.1342072222615875095910765247567454971919e-9), SC_(0.1949022105090695626667676566104244098257e-17), SC_(0.9999999854775172010701814370111438739499), SC_(0.1452248279892981856298885612605012536295e-7) }, 
      { SC_(13), SC_(21), SC_(0.8350250720977783203125), SC_(0.1342072239853292640917458089217367890432e-9), SC_(0.2252803505900263425026852742529665828947e-18), SC_(0.999999998321399224854715122899697481908), SC_(0.1678600775145284877100302518091954704837e-8) }, 
      { SC_(13), SC_(21), SC_(0.905801355838775634765625), SC_(0.1342072242106052264885795995812597570386e-9), SC_(0.4388193192551843162306257563480913565756e-23), SC_(0.9999999999999673028540873067320098935421), SC_(0.3269714591269326799010645788598458007362e-13) }, 
      { SC_(13), SC_(21), SC_(0.913384497165679931640625), SC_(0.1342072242106087866596464982485856962323e-9), SC_(0.8280221256531758363670638616754702749953e-24), SC_(0.9999999999999938302715779757749052810772), SC_(0.6169728422024225094718922849039362526983e-14) }, 
      { SC_(13), SC_(21), SC_(0.9688708782196044921875), SC_(0.1342072242106096146817713978305389764226e-9), SC_(0.7535938830868735508286328967836961971016e-33), SC_(0.9999999999999999999999943848485987291662), SC_(0.5615151401270833810161885377713181791345e-23) }, 
      { SC_(13), SC_(25), SC_(0.12707412242889404296875), SC_(0.8758534854591758457448109617092620554102e-14), SC_(0.2158388230793347343358602045024222821501e-10), SC_(0.0004056259222001141266040453154502037633389), SC_(0.9995943740777998858733959546845497962367) }, 
      { SC_(13), SC_(25), SC_(0.1355634629726409912109375), SC_(0.1644594195911352543478043398664769635096e-13), SC_(0.2157619490082895166660868812587267313922e-10), SC_(0.0007616456958115183275386065238441337133182), SC_(0.9992383543041884816724613934761558662867) }, 
      { SC_(13), SC_(25), SC_(0.221111953258514404296875), SC_(0.1052319341738460143720597868717541819681e-11), SC_(0.2054032150104960504832287069114177901589e-10), SC_(0.04873509217331026238665309316882716369695), SC_(0.9512649078266897376133469068311728363031) }, 
      { SC_(13), SC_(25), SC_(0.3082362115383148193359375), SC_(0.7371706577683233810965792701677289892302e-11), SC_(0.1422093426510483138107767585818203094327e-10), SC_(0.3413990271664885927276602329379520051213), SC_(0.6586009728335114072723397670620479948787) }, 
      { SC_(13), SC_(25), SC_(0.632396042346954345703125), SC_(0.215896343198773414457604784727540613281e-10), SC_(0.3006522910723746282990087105259507464146e-14), SC_(0.9998607616857699958489335664900236975064), SC_(0.0001392383142300041510664335099763024936167) }, 
      { SC_(13), SC_(25), SC_(0.81474220752716064453125), SC_(0.2159264084089924516833086005814810827368e-10), SC_(0.1888820023712608501711212561885701636223e-20), SC_(0.9999999999125248255892018989943735456641), SC_(0.8747517441079810100562645433587149941582e-10) }, 
      { SC_(13), SC_(25), SC_(0.8350250720977783203125), SC_(0.2159264084265036617763745709402285031088e-10), SC_(0.1376990144060114658364705246857782025488e-21), SC_(0.9999999999936228729311726179839225859091), SC_(0.6377127068827382016077414090890059081225e-11) }, 
      { SC_(13), SC_(25), SC_(0.905801355838775634765625), SC_(0.2159264084278806490443189673329867527873e-10), SC_(0.2876115718265606455568387061223695378352e-27), SC_(0.9999999999999999866801113434615935735793), SC_(0.133198886565384064264206663651582666017e-16) }, 
      { SC_(13), SC_(25), SC_(0.913384497165679931640625), SC_(0.2159264084278806515321720583844293912428e-10), SC_(0.3882626272141638171128833633530944062053e-28), SC_(0.9999999999999999982018752127586866960998), SC_(0.1798124787241313303900175607857242328695e-17) }, 
      { SC_(13), SC_(25), SC_(0.9688708782196044921875), SC_(0.2159264084278806519204346855926653286993e-10), SC_(0.5927879656431963330490213739811929803124e-39), SC_(0.9999999999999999999999999999725467593353), SC_(0.2745324066468633525157162324351792049558e-28) }, 
      { SC_(13), SC_(29), SC_(0.12707412242889404296875), SC_(0.5361159256319312396010308732646528656994e-14), SC_(0.4360288305107121339397117160045072382257e-11), SC_(0.001228032461168072260485150589813286577727), SC_(0.9987719675388319277395148494101867134223) }, 
      { SC_(13), SC_(29), SC_(0.1355634629726409912109375), SC_(0.973115458128150406049849219265123028997e-14), SC_(0.4355918309782159147732628976585067680624e-11), SC_(0.002229027928310871066621235397291920611244), SC_(0.9977709720716891289333787646027080793888) }, 
      { SC_(13), SC_(29), SC_(0.221111953258514404296875), SC_(0.4417728762305500138302424753507472837691e-12), SC_(0.3923876588132890637962884993426971627145e-11), SC_(0.101192933568468562710343070408942604), SC_(0.898807066431531437289656929591057396) }, 
      { SC_(13), SC_(29), SC_(0.3082362115383148193359375), SC_(0.2225659358449399429487291383915778848566e-11), SC_(0.2139990105914041222305836084861940062348e-11), SC_(0.509811742013951378868184627844159288568), SC_(0.490188257986048621131815372155840711432) }, 
      { SC_(13), SC_(29), SC_(0.632396042346954345703125), SC_(0.4365604138162920927035687714491568431311e-11), SC_(0.4532620051972475743975428615047960306151e-16), SC_(0.9999896175355145391151404776679190863663), SC_(0.1038246448546088485952233208091363373536e-4) }, 
      { SC_(13), SC_(29), SC_(0.81474220752716064453125), SC_(0.4365649464361551356602134035263708826298e-11), SC_(0.1889295190993433514010084616055794066717e-23), SC_(0.9999999999995672361680854939239192693303), SC_(0.4327638319145060760807306696845368551879e-12) }, 
      { SC_(13), SC_(29), SC_(0.8350250720977783203125), SC_(0.4365649464363353852131159325985247587363e-11), SC_(0.8679966196814279247132355069362734092997e-25), SC_(0.999999999999980117583265288769420531397), SC_(0.1988241673471123057946860295534458126341e-13) }, 
      { SC_(13), SC_(29), SC_(0.905801355838775634765625), SC_(0.4365649464363440651773734087390733264319e-11), SC_(0.1939338138698564659560352004535505620327e-31), SC_(0.9999999999999999999955577328080752325579), SC_(0.4442267191924767442100604825291307796978e-20) }, 
      { SC_(13), SC_(29), SC_(0.913384497165679931640625), SC_(0.436564946436344065179125490053149297079e-11), SC_(0.1872568246225940124030792998307632982611e-32), SC_(0.9999999999999999999995710676586584394916), SC_(0.428932341341560508376735767079939971018e-21) }, 
      { SC_(13), SC_(29), SC_(0.9688708782196044921875), SC_(0.4365649464363440651793127468777718432018e-11), SC_(0.4788961419963612190629714846753884460829e-45), SC_(0.9999999999999999999999999999999998903036), SC_(0.1096964256763087377864191877102778850244e-33) }, 
      { SC_(13), SC_(33), SC_(0.12707412242889404296875), SC_(0.3288973462262453181042334440885281140506e-14), SC_(0.105036218757340536009108668852798462749e-11), SC_(0.003121501293682070982666124689418962387496), SC_(0.9968784987063179290173338753105810376125) }, 
      { SC_(13), SC_(33), SC_(0.1355634629726409912109375), SC_(0.577345972895251702853306017062997171679e-14), SC_(0.1047877701306715296243595962798239936914e-11), SC_(0.005479479302502354461832088666637476098479), SC_(0.9945205206974976455381679113333625239015) }, 
      { SC_(13), SC_(33), SC_(0.221111953258514404296875), SC_(0.1877385210054651906597590821365675018216e-12), SC_(0.8659126400302026226123699408323024068093e-12), SC_(0.1781790102342134988581029892573944395977), SC_(0.8218209897657865011418970107426055604023) }, 
      { SC_(13), SC_(33), SC_(0.3082362115383148193359375), SC_(0.7001678178082966479538164343787058795213e-12), SC_(0.3534833432273711653183125885901640291097e-12), SC_(0.6645157749554217246065582234795082397798), SC_(0.3354842250445782753934417765204917602202) }, 
      { SC_(13), SC_(33), SC_(0.632396042346954345703125), SC_(0.1053650456836596895550481635719300497655e-11), SC_(0.7041990709177216473872495694109755941443e-18), SC_(0.999999331658240450718434404420838283949), SC_(0.6683417595492815655955791617160509826654e-6) }, 
      { SC_(13), SC_(33), SC_(0.81474220752716064453125), SC_(0.1053651161035665879831915205800822678459e-11), SC_(0.1933440213817168047230172436200258699305e-26), SC_(0.9999999999999981650091744627063177422548), SC_(0.1834990825537293682257745227412229157099e-14) }, 
      { SC_(13), SC_(33), SC_(0.8350250720977783203125), SC_(0.1053651161035667757321894831395963671896e-11), SC_(0.559502341915729062367353675286778066221e-28), SC_(0.9999999999999999468987115844131837889953), SC_(0.5310128841558681621100472450186624077517e-16) }, 
      { SC_(13), SC_(33), SC_(0.905801355838775634765625), SC_(0.1053651161035667813272127687827969437745e-11), SC_(0.1335140900470886415004847211583517347364e-35), SC_(0.9999999999999999999999987328435161040081), SC_(0.1267156483895991943153828502822970968195e-23) }, 
      { SC_(13), SC_(33), SC_(0.913384497165679931640625), SC_(0.1053651161035667813272128930772613731852e-11), SC_(0.9219625617677870083359949327942422655437e-37), SC_(0.9999999999999999999999999124983110290924), SC_(0.8750168897090761800089664476012832985385e-25) }, 
      { SC_(13), SC_(33), SC_(0.9688708782196044921875), SC_(0.1053651161035667813272129022968869908631e-11), SC_(0.3945756076153737976738818594960825664508e-51), SC_(0.9999999999999999999999999999999999999996), SC_(0.3744841008171363545743343990230561886635e-39) }, 
      { SC_(13), SC_(37), SC_(0.12707412242889404296875), SC_(0.2022562869462821197532524196367295063988e-14), SC_(0.2909097260202935105285466924113715803533e-12), SC_(0.006904540558258509618995969227757285931115), SC_(0.9930954594417414903810040307722427140689) }, 
      { SC_(13), SC_(37), SC_(0.1355634629726409912109375), SC_(0.3435252850050776981876902622169062086269e-14), SC_(0.289497036039705554744202313985569813331e-12), SC_(0.01172712254791283179389152808161757926114), SC_(0.9882728774520871682061084719183824207389) }, 
      { SC_(13), SC_(37), SC_(0.221111953258514404296875), SC_(0.8088396793739206089649936989705372158734e-13), SC_(0.2120483209523642708295798467106851538299e-12), SC_(0.2761183078995854773692687452784452718887), SC_(0.7238816921004145226307312547215547281113) }, 
      { SC_(13), SC_(37), SC_(0.3082362115383148193359375), SC_(0.2307015172999821943741658118588814090458e-12), SC_(0.6223077158977413735191340474885746637145e-13), SC_(0.7875591938818516824225994810596464473036), SC_(0.2124408061181483175774005189403535526964) }, 
      { SC_(13), SC_(37), SC_(0.632396042346954345703125), SC_(0.2929322777052393233493640992892548903408e-12), SC_(0.1118451700837671511731848398507642646195e-19), SC_(0.9999999618187634734047543279035462028577), SC_(0.3818123652659524567209645379714234771436e-7) }, 
      { SC_(13), SC_(37), SC_(0.81474220752716064453125), SC_(0.2929322888897563297130057815841027242773e-12), SC_(0.2013073435023636151140001077919348843227e-29), SC_(0.999999999999999993127854076266591674071), SC_(0.6872145923733408325929013106938484121814e-17) }, 
      { SC_(13), SC_(37), SC_(0.8350250720977783203125), SC_(0.2929322888897563316893989427919634093409e-12), SC_(0.3668027381577546607640565398729017244369e-31), SC_(0.9999999999999999998747824148891284839159), SC_(0.1252175851108715160841487692918167436277e-18) }, 
      { SC_(13), SC_(37), SC_(0.905801355838775634765625), SC_(0.2929322888897563317260792165143500621711e-12), SC_(0.9338881324612367306445017045551535793132e-40), SC_(0.9999999999999999999999999996811931740264), SC_(0.3188068259735959221297890844065788017623e-27) }, 
      { SC_(13), SC_(37), SC_(0.913384497165679931640625), SC_(0.2929322888897563317260792166031273934966e-12), SC_(0.4611481920649220009551844818591041972218e-41), SC_(0.9999999999999999999999999999842575158303), SC_(0.1574248416972814223346612150887286352704e-28) }, 
      { SC_(13), SC_(37), SC_(0.9688708782196044921875), SC_(0.2929322888897563317260792166077388754173e-12), SC_(0.3300557259447356892320638226975609186744e-57), SC_(1), SC_(0.1126730437247737431192274969236662316508e-44) }, 
      { SC_(17), SC_(1), SC_(0.12707412242889404296875), SC_(0.3455589170449344136182647463074894445431e-16), SC_(0.05882352941176467132646123668302922640882), SC_(0.5874501589763885031510500687227320557233e-15), SC_(0.9999999999999994125498410236114968489499) }, 
      { SC_(17), SC_(1), SC_(0.1355634629726409912109375), SC_(0.1037471566286679865741630596192829041388e-15), SC_(0.05882352941176460213519631250848401407223), SC_(0.176370166268735577176077201352780937036e-14), SC_(0.999999999999998236298337312644228239228) }, 
      { SC_(17), SC_(1), SC_(0.221111953258514404296875), SC_(0.424579319630979338056120972173360267065e-12), SC_(0.05882352941134012656272196183841446726312), SC_(0.7217848433726648746954056526947124540105e-11), SC_(0.9999999999927821515662733512530459434731) }, 
      { SC_(17), SC_(1), SC_(0.3082362115383148193359375), SC_(0.120385247067193425087370035830263511127e-9), SC_(0.05882352929137945881515951608910055240503), SC_(0.2046549200142288226485290609114479689158e-8), SC_(0.9999999979534507998577117735147093908855) }, 
      { SC_(17), SC_(1), SC_(0.632396042346954345703125), SC_(0.2434257495519355800604913767586915292838e-4), SC_(0.05879918683680951232434689203879471908237), SC_(0.0004138237742382904861028353404897755997824), SC_(0.9995861762257617095138971646595102244002) }, 
      { SC_(17), SC_(1), SC_(0.81474220752716064453125), SC_(0.001806736177003102370328013705923400337458), SC_(0.05701679323476160351202492747054718789784), SC_(0.03071451500905274029557623300069780573679), SC_(0.9692854849909472597044237669993021942632) }, 
      { SC_(17), SC_(1), SC_(0.8350250720977783203125), SC_(0.002744371143035658271490246601262371009535), SC_(0.05607915826872904761086269457520821722576), SC_(0.04665430943160619061533419222146030716209), SC_(0.9533456905683938093846658077785396928379) }, 
      { SC_(17), SC_(1), SC_(0.905801355838775634765625), SC_(0.01094237282157960237920849645137318344709), SC_(0.04788115659018510350314444472509740478821), SC_(0.1860203379668532404465444396733441186005), SC_(0.8139796620331467595534555603266558813995) }, 
      { SC_(17), SC_(1), SC_(0.913384497165679931640625), SC_(0.01260848458627428532642359161103272440478), SC_(0.04621504482549042055592934956543786383051), SC_(0.2143442379666628505492010573875563148813), SC_(0.7856557620333371494507989426124436851187) }, 
      { SC_(17), SC_(1), SC_(0.9688708782196044921875), SC_(0.03436144493442266427804911831798360955278), SC_(0.02446208447734204160430382285848697868251), SC_(0.5841445638851852927268350114057213623973), SC_(0.4158554361148147072731649885942786376027) }, 
      { SC_(17), SC_(5), SC_(0.12707412242889404296875), SC_(0.2072886826056739210676158786753561537425e-16), SC_(0.9828492800608294670979690114404614892549e-5), SC_(0.2109058701171429309902457757582411186253e-11), SC_(0.9999999999978909412988285706900975422424) }, 
      { SC_(17), SC_(5), SC_(0.1355634629726409912109375), SC_(0.6000032219902288940599088142213778413742e-16), SC_(0.9828492800569023217041234617105385598995e-5), SC_(0.6104732782139583882612542230295408847062e-11), SC_(0.9999999999938952672178604161173874577697) }, 
      { SC_(17), SC_(5), SC_(0.221111953258514404296875), SC_(0.1665764801691496286837173051298240558784e-12), SC_(0.9828492634052543370090628822794071350593e-5), SC_(0.1694832397481012897042481721043394856535e-7), SC_(0.9999999830516760251898710295751827895661) }, 
      { SC_(17), SC_(5), SC_(0.3082362115383148193359375), SC_(0.3049846216354742482291073340070565260151e-10), SC_(0.9828462302166859991815434595777975774764e-5), SC_(0.310306603283013273860705256985479662394e-5), SC_(0.9999968969339671698672613929474301452034) }, 
      { SC_(17), SC_(5), SC_(0.632396042346954345703125), SC_(0.6692019827769954957507858649508563918272e-6), SC_(0.915929081785202804348947164156052008859e-5), SC_(0.06808795573764540671516370782942488358645), SC_(0.9319120442623545932848362921705751164135) }, 
      { SC_(17), SC_(5), SC_(0.81474220752716064453125), SC_(0.6420428797929947593508613437761402534226e-5), SC_(0.3408064002699075945731644068749973946191e-5), SC_(0.6532465280453825179015338742250339008448), SC_(0.3467534719546174820984661257749660991552) }, 
      { SC_(17), SC_(5), SC_(0.8350250720977783203125), SC_(0.7294732432948802710470403123163856404491e-5), SC_(0.2533760367680220828769854383347520075925e-5), SC_(0.742202551390375931776811165766306569875), SC_(0.257797448609624068223188834233693430125) }, 
      { SC_(17), SC_(5), SC_(0.905801355838775634765625), SC_(0.9416536979900673098657555375819158294469e-5), SC_(0.4119558207283504405827021306922181859475e-6), SC_(0.9580855550199939844229129717127202606708), SC_(0.04191444498000601557708702828727973932923) }, 
      { SC_(17), SC_(5), SC_(0.913384497165679931640625), SC_(0.9527818168102876696863407685813463158965e-5), SC_(0.3006746325261468423768498206979133214515e-6), SC_(0.9694078595136271895223674149930908091089), SC_(0.03059214048637281047763258500690919089108) }, 
      { SC_(17), SC_(5), SC_(0.9688708782196044921875), SC_(0.9824644124149441142529189225292052305136e-5), SC_(0.3848676479582396711068281219324175281132e-8), SC_(0.999608416411584889046632357727339861786), SC_(0.0003915835884151109533676422726601382139788) }, 
      { SC_(17), SC_(9), SC_(0.12707412242889404296875), SC_(0.1244642922277403464684296913190363760687e-16), SC_(0.5438691667087623067816019661448480585854e-7), SC_(0.228849693672571050893706133760257506359e-9), SC_(0.9999999997711503063274289491062938662397) }, 
      { SC_(17), SC_(9), SC_(0.1355634629726409912109375), SC_(0.3473875004841170634061875630941888362948e-16), SC_(0.5438691664858390985252252492070901868103e-7), SC_(0.6387335809213851518510304330411153940464e-9), SC_(0.9999999993612664190786148481489695669589) }, 
      { SC_(17), SC_(9), SC_(0.221111953258514404296875), SC_(0.6559652066288660376476746213822527959933e-13), SC_(0.5438685108680199701433046649386563676517e-7), SC_(0.1206108466211346833936932253656567115305e-5), SC_(0.9999987938915337886531660630677463434329) }, 
      { SC_(17), SC_(9), SC_(0.3082362115383148193359375), SC_(0.7799029262007009612686288524376477389297e-11), SC_(0.5437911765406065289132154497280339851306e-7), SC_(0.0001433989962589389341712999326827923050496), SC_(0.999856601003741061065828700067317207695) }, 
      { SC_(17), SC_(9), SC_(0.632396042346954345703125), SC_(0.2144615956148576964372762335664563056486e-7), SC_(0.3294075712183689025720660790468214442559e-7), SC_(0.3943257104711375121410499719433879639292), SC_(0.6056742895288624878589500280566120360708) }, 
      { SC_(17), SC_(9), SC_(0.81474220752716064453125), SC_(0.5275588763073187450219380232999144699815e-7), SC_(0.1631029052590785398740428931336327992294e-8), SC_(0.9700106357915500618000744498360284878795), SC_(0.02998936420844993819992555016397151212051) }, 
      { SC_(17), SC_(9), SC_(0.8350250720977783203125), SC_(0.535858053002699379738247951848024753814e-7), SC_(0.8011113830527219271094360765252996090506e-9), SC_(0.9852701452498707887886723984840465342808), SC_(0.0147298547501292112113276015159534657192) }, 
      { SC_(17), SC_(9), SC_(0.905801355838775634765625), SC_(0.5437101687973372982417510751808552342216e-7), SC_(0.1589980358893007675912374324225156828433e-10), SC_(0.9997076538888661501878972625358469499206), SC_(0.0002923461111338498121027374641530500794411) }, 
      { SC_(17), SC_(9), SC_(0.913384497165679931640625), SC_(0.5437851920796593979896856662078551978212e-7), SC_(0.8397475356720101965664640542255208324087e-11), SC_(0.999845597510047942747180266528893675492), SC_(0.0001544024899520572528197334711063245080331) }, 
      { SC_(17), SC_(9), SC_(0.9688708782196044921875), SC_(0.5438691474578649132651660365571974039089e-7), SC_(0.1937536168574417627605608034599557752388e-14), SC_(0.9999999643749584140601123251818963296257), SC_(0.3562504158593988767481810367037428349266e-7) }, 
      { SC_(17), SC_(13), SC_(0.12707412242889404296875), SC_(0.7480859381334768217934506564841474824408e-17), SC_(0.1133490109071905413872273358182593709685e-8), SC_(0.6599845267364118859525914778083469867458e-8), SC_(0.9999999934001547326358811404740852219165) }, 
      { SC_(17), SC_(13), SC_(0.1355634629726409912109375), SC_(0.2013656534186665668941343374754947418964e-16), SC_(0.1133490096416199453340384886703666526977e-8), SC_(0.1776510006378100150175895068012377667111e-7), SC_(0.9999999822348999362189984982410493198762) }, 
      { SC_(17), SC_(13), SC_(0.221111953258514404296875), SC_(0.2593743880464816664577297209883706746282e-13), SC_(0.1133464179113960147040395803145001437459e-8), SC_(0.228828098506324822200094371415670544869e-4), SC_(0.9999771171901493675177799905628584329455) }, 
      { SC_(17), SC_(13), SC_(0.3082362115383148193359375), SC_(0.2016157924511856207887042305963957574232e-11), SC_(0.1131473958628252938999154533811136316952e-8), SC_(0.001778716810203437340395491392493446128457), SC_(0.9982212831897965626596045086075065538715) }, 
      { SC_(17), SC_(13), SC_(0.632396042346954345703125), SC_(0.8648988279883846099451499930880836988007e-9), SC_(0.2685912885643801852618915830290165757255e-9), SC_(0.7630404671006436040361355793113438954279), SC_(0.2369595328993563959638644206886561045721) }, 
      { SC_(17), SC_(13), SC_(0.81474220752716064453125), SC_(0.1132319700032117413861065428842827360015e-8), SC_(0.1170416520647381345976147274272914511025e-11), SC_(0.9989674223854664747757331589415663961567), SC_(0.00103257761453352522426684105843360384332) }, 
      { SC_(17), SC_(13), SC_(0.8350250720977783203125), SC_(0.1133121388357000035297853252804201648485e-8), SC_(0.3687281957647599091883233128986260407203e-12), SC_(0.9996746965938387206558566668001120801038), SC_(0.0003253034061612793441433331998879198961749) }, 
      { SC_(17), SC_(13), SC_(0.905801355838775634765625), SC_(0.1133489293975572258778417156056945100609e-8), SC_(0.8225771925364286244200601551739172811034e-15), SC_(0.9999992742969872219992545742714733470761), SC_(0.7257030127780007454257285266529239235638e-6) }, 
      { SC_(17), SC_(13), SC_(0.913384497165679931640625), SC_(0.1133489804441014210937702402834489042667e-8), SC_(0.3121117505842693391732826112318588764036e-15), SC_(0.9999997246453709420232879800963218049801), SC_(0.2753546290579767120199036781950199090432e-6) }, 
      { SC_(17), SC_(13), SC_(0.9688708782196044921875), SC_(0.1133490116551524144098833195337430127658e-8), SC_(0.1240651108208380779670146867996491316445e-20), SC_(0.9999999999989054592624225783782508085239), SC_(0.1094540737577421621749191476133991390967e-11) }, 
      { SC_(17), SC_(17), SC_(0.12707412242889404296875), SC_(0.4501104401384726468399319000167966894684e-17), SC_(0.5041426754498631042555739446805936003823e-10), SC_(0.8928234443749658154706991623172726301659e-7), SC_(0.9999999107176555625034184529300837682727) }, 
      { SC_(17), SC_(17), SC_(0.1355634629726409912109375), SC_(0.1168682688037678139679248262862148551892e-16), SC_(0.5041426035926383143350246607489573158471e-10), SC_(0.2318158411509388505946494168468409133769e-6), SC_(0.9999997681841588490611494053505831531591) }, 
      { SC_(17), SC_(17), SC_(0.221111953258514404296875), SC_(0.1030247405718712763002286322402480344816e-13), SC_(0.5040396957203352468265384000415433540275e-10), SC_(0.0002043562991005443923015193050752450454678), SC_(0.9997956437008994556076984806949247549545) }, 
      { SC_(17), SC_(17), SC_(0.3082362115383148193359375), SC_(0.5278696597815982566181527044888823132706e-12), SC_(0.4988640238630911355366571016288947789293e-10), SC_(0.01047063933203278303207485718689316034032), SC_(0.9895293606679672169679251428131068396597) }, 
      { SC_(17), SC_(17), SC_(0.632396042346954345703125), SC_(0.4742477090789729780152900993851558840539e-10), SC_(0.2989501138193414008754852928862771800809e-11), SC_(0.9407012931683255408021435963751752546931), SC_(0.05929870683167445919785640362482474530688) }, 
      { SC_(17), SC_(17), SC_(0.81474220752716064453125), SC_(0.5041328740203105582709342181622064217828e-10), SC_(0.9846440596559831904410511577180279161972e-15), SC_(0.9999804689422321563458158562070375935769), SC_(0.1953105776784365418414379296240642308666e-4) }, 
      { SC_(17), SC_(17), SC_(0.8350250720977783203125), SC_(0.5041407495403353117704013165711366403818e-10), SC_(0.1970920571806332437312102646961680228837e-15), SC_(0.9999960905503703307680905656096045059951), SC_(0.3909449629669231909434390395494004921116e-5) }, 
      { SC_(17), SC_(17), SC_(0.905801355838775634765625), SC_(0.5041427199795417997300798478198323183398e-10), SC_(0.4813653183727587808539512837222375584088e-19), SC_(0.9999999990451804641100923558736620168195), SC_(0.9548195358899076441263379831805185708274e-9) }, 
      { SC_(17), SC_(17), SC_(0.913384497165679931640625), SC_(0.504142720329995303942201460083421863852e-10), SC_(0.1309118141606371685903617382099799305512e-19), SC_(0.9999999997403278697727650705821917333137), SC_(0.2596721302272349294178082666862977072081e-9) }, 
      { SC_(17), SC_(17), SC_(0.9688708782196044921875), SC_(0.5041427204609071092682889105538356630829e-10), SC_(0.8834549718119947938979048025202066343997e-27), SC_(0.999999999999999982476093852861636365994), SC_(0.1752390614713836363400603388309671996062e-16) }, 
      { SC_(17), SC_(21), SC_(0.12707412242889404296875), SC_(0.2711268431152249676576763823198939186526e-17), SC_(0.3698341570105018748890838459839222530473e-11), SC_(0.7331033091774162812828385468516624505236e-6), SC_(0.9999992668966908225837187171614531483375) }, 
      { SC_(17), SC_(21), SC_(0.1355634629726409912109375), SC_(0.6791714635253686583713400912091235361114e-17), SC_(0.3698337489658814647453931323202133638177e-11), SC_(0.1836420332595821841512612682072643724824e-5), SC_(0.9999981635796674041781584873873179273563) }, 
      { SC_(17), SC_(21), SC_(0.221111953258514404296875), SC_(0.4112805893318977010672080066828094638943e-14), SC_(0.3694231475480130924129842956536217634773e-11), SC_(0.001112066800820287334910801652214218852126), SC_(0.9988879331991797126650891983477857811479) }, 
      { SC_(17), SC_(21), SC_(0.3082362115383148193359375), SC_(0.1402814460086186503576777382896402277517e-12), SC_(0.3558062835364831250782837298313405501661e-11), SC_(0.03793087807296363701926444271654541412587), SC_(0.9620691219270363629807355572834545858741) }, 
      { SC_(17), SC_(21), SC_(0.632396042346954345703125), SC_(0.3659745883607275711892273487346974759411e-11), SC_(0.3859839776617418924824154925607097000145e-13), SC_(0.9895633302825339056166638074789896052754), SC_(0.01043666971746609438333619252101039472461) }, 
      { SC_(17), SC_(21), SC_(0.81474220752716064453125), SC_(0.3698343381338226030593944246582262360824e-11), SC_(0.9000352238705465707900207833685881492368e-18), SC_(0.9999997566383345099765792000962586833127), SC_(0.2433616654900234207999037413166873158777e-6) }, 
      { SC_(17), SC_(21), SC_(0.8350250720977783203125), SC_(0.369834416737018620302670818336307728771e-11), SC_(0.1140032636981138068532399684417027819878e-18), SC_(0.9999999691745129645484100977773885450412), SC_(0.3082548703545158990222261145495879709173e-7) }, 
      { SC_(17), SC_(21), SC_(0.905801355838775634765625), SC_(0.3698344281370436144852353276093587078393e-11), SC_(0.3013756288161760509458651019578997758205e-23), SC_(0.9999999999991851066155900052465638261216), SC_(0.8148933844099947534361738784155636013807e-12) }, 
      { SC_(17), SC_(21), SC_(0.913384497165679931640625), SC_(0.3698344281372863032229302970363453884603e-11), SC_(0.5868689112120662395918448096714694350908e-24), SC_(0.9999999999998413157709065091687919246427), SC_(0.1586842290934908312080753573177164206544e-12) }, 
      { SC_(17), SC_(21), SC_(0.9688708782196044921875), SC_(0.3698344281373449901139847027507109107661e-11), SC_(0.6680090959366217516696915384601178591235e-33), SC_(0.9999999999999999999998193761734674025602), SC_(0.1806238265325974397859125348699804430501e-21) }, 
      { SC_(17), SC_(25), SC_(0.12707412242889404296875), SC_(0.1635078018707154843774100627777225548757e-17), SC_(0.388056095087620461893434223124058348189e-12), SC_(0.4213491683335970610750365334069702743563e-5), SC_(0.9999957865083166640293892496346659302973) }, 
      { SC_(17), SC_(25), SC_(0.1355634629726409912109375), SC_(0.3952463048604918595110443980423528372043e-17), SC_(0.3880537777025905641296828867807057018862e-12), SC_(0.1018524498125019460342412953940261882694e-4), SC_(0.9999898147550187498053965758704605973812) }, 
      { SC_(17), SC_(25), SC_(0.221111953258514404296875), SC_(0.1651047356806530453504567518298165542128e-14), SC_(0.3864066828088326385947734297063879598725e-12), SC_(0.004254643648257682729347076732373945962158), SC_(0.9957453563517423172706529232676260540378) }, 
      { SC_(17), SC_(25), SC_(0.3082362115383148193359375), SC_(0.3793817188476325924283048784540469200569e-13), SC_(0.3501195582808759098054475093792814334089e-12), SC_(0.09776424726436881070074303808691707268047), SC_(0.9022357527356311892992569619130829273195) }, 
      { SC_(17), SC_(25), SC_(0.632396042346954345703125), SC_(0.3875161134822392363264510132203724015409e-12), SC_(0.5416166833999327218269840043137238737227e-15), SC_(0.9986042883795440739995473383335659413325), SC_(0.001395711620455926000452661666434058667451) }, 
      { SC_(17), SC_(25), SC_(0.81474220752716064453125), SC_(0.3880577293002868033474262095290670830119e-12), SC_(0.8653523657008517876956190424026418709787e-21), SC_(0.9999999977700421910639856878750000401766), SC_(0.2229957808936014312124999959823426791235e-8) }, 
      { SC_(17), SC_(25), SC_(0.8350250720977783203125), SC_(0.3880577300964208773979263728082734821661e-12), SC_(0.6921829165035162441641264324850951527341e-22), SC_(0.9999999998216288807832628912014174353462), SC_(0.1783711192167371087985825646538207568632e-9) }, 
      { SC_(17), SC_(25), SC_(0.905801355838775634765625), SC_(0.388057730165638972154206999403000934154e-12), SC_(0.1968940709978216851912606030005141820729e-27), SC_(0.9999999999999994926165472498663750651681), SC_(0.5073834527501336249348318555685731073304e-15) }, 
      { SC_(17), SC_(25), SC_(0.913384497165679931640625), SC_(0.3880577301656391416096176900781384745912e-12), SC_(0.2743866030714654765082337042105642323807e-28), SC_(0.9999999999999999292923238626516035897591), SC_(0.7070767613734839641024088653989350616353e-16) }, 
      { SC_(17), SC_(25), SC_(0.9688708782196044921875), SC_(0.388057730165639169048277996699707178075e-12), SC_(0.5249789473396122787512390343100361600527e-39), SC_(0.9999999999999999999999999986471627633457), SC_(0.1352837236654271628642101444763991444219e-26) }, 
      { SC_(17), SC_(29), SC_(0.12707412242889404296875), SC_(0.9872918140438641934896720843309209173182e-18), SC_(0.5332618492967971086759946977739684910434e-13), SC_(0.1851386025013964310926802802434585977741e-4), SC_(0.9999814861397498603568907319719756541402) }, 
      { SC_(17), SC_(29), SC_(0.1355634629726409912109375), SC_(0.2303553460733769401164061314339908141253e-17), SC_(0.5332486866803302096239179538816684011712e-13), SC_(0.4319661749859880812142712173247177547481e-4), SC_(0.9999568033825014011918785728782675282245) }, 
      { SC_(17), SC_(29), SC_(0.221111953258514404296875), SC_(0.6669288563421073059003544198162253767829e-15), SC_(0.5266024336515164742589260502966495464848e-13), SC_(0.01250636080180712552838124285848886950454), SC_(0.9874936391981928744716187571415111304955) }, 
      { SC_(17), SC_(29), SC_(0.3082362115383148193359375), SC_(0.1047320132133571602062681587723165985874e-13), SC_(0.4285397090015803871116614357224952016652e-13), SC_(0.1963952125163397561947275799506982155343), SC_(0.8036047874836602438052724200493017844657) }, 
      { SC_(17), SC_(29), SC_(0.632396042346954345703125), SC_(0.5331916477652752734159824119908298219052e-13), SC_(0.8007444966227390194718250398197834742178e-17), SC_(0.9998498430606264182564597756927830601236), SC_(0.0001501569393735817435402243072169398763983) }, 
      { SC_(17), SC_(29), SC_(0.81474220752716064453125), SC_(0.5332717222063306143030072327764345645794e-13), SC_(0.8606933014922361718377235673235865529297e-24), SC_(0.9999999999838601361062732312683656701923), SC_(0.1613986389372676873163432980773744372773e-10) }, 
      { SC_(17), SC_(29), SC_(0.8350250720977783203125), SC_(0.5332717222145033077768037083241680090662e-13), SC_(0.4342395411258861706437911864568403953555e-25), SC_(0.9999999999991857067925479386551151214209), SC_(0.814293207452061344884878579120777138097e-12) }, 
      { SC_(17), SC_(29), SC_(0.905801355838775634765625), SC_(0.5332717222149375471854744105793085833251e-13), SC_(0.1324551839155032169275189467197797815682e-31), SC_(0.9999999999999999997516178368405655607208), SC_(0.2483821631594344392791716377955083237946e-18) }, 
      { SC_(17), SC_(29), SC_(0.913384497165679931640625), SC_(0.533271722214937547304723929001563980227e-13), SC_(0.1320566549324782002564274249945202440174e-32), SC_(0.9999999999999999999752365165015721242023), SC_(0.2476348349842787579770193074692823319967e-19) }, 
      { SC_(17), SC_(29), SC_(0.9688708782196044921875), SC_(0.5332717222149375473179295944948075619707e-13), SC_(0.4238281868008054198963544417631769831786e-45), SC_(0.9999999999999999999999999999999920523034), SC_(0.7947696627161107520894487683797235062379e-32) }, 
      { SC_(17), SC_(33), SC_(0.12707412242889404296875), SC_(0.5969311584398026290678227253272761407527e-18), SC_(0.9050192743391369614932500367175101435504e-14), SC_(0.6595348913237167548633505424790158644717e-4), SC_(0.9999340465108676283245136649457520984136) }, 
      { SC_(17), SC_(33), SC_(0.1355634629726409912109375), SC_(0.1344652719402168706639521004401611464681e-17), SC_(0.904944502183040724885492866889602710018e-14), SC_(0.0001485674474552467569456352056677591839051), SC_(0.9998514325525447532430543647943322408161) }, 
      { SC_(17), SC_(33), SC_(0.221111953258514404296875), SC_(0.2712733411770249176072453333149679788065e-15), SC_(0.8779516333372784499954322856585460732838e-14), SC_(0.02997233953406592476132519429963183225053), SC_(0.9700276604659340752386748057003681677495) }, 
      { SC_(17), SC_(33), SC_(0.3082362115383148193359375), SC_(0.2961604990065722574684347821996474574634e-14), SC_(0.6089184684484086842877220367903954137011e-14), SC_(0.3272206179305602099582951900078086200385), SC_(0.6727793820694397900417048099921913799615) }, 
      { SC_(17), SC_(33), SC_(0.632396042346954345703125), SC_(0.9050667016774727872871710422830481962572e-14), SC_(0.1226577750815446898577670699467490721005e-18), SC_(0.999986447837206244023572541086785884727), SC_(0.1355216279375597642745891321411527296089e-4) }, 
      { SC_(17), SC_(33), SC_(0.81474220752716064453125), SC_(0.9050789674548932329625958331870154398538e-14), SC_(0.8770879356098580302743131065084755448001e-27), SC_(0.9999999999999030926618396438649665912269), SC_(0.9690733816035613503340877313536872448214e-13) }, 
      { SC_(17), SC_(33), SC_(0.8350250720977783203125), SC_(0.9050789674549781527255385047024797101036e-14), SC_(0.2789030618314287563161060856341907161129e-28), SC_(0.9999999999999969184670966812459130358843), SC_(0.3081532903318754086964115674915156397409e-14) }, 
      { SC_(17), SC_(33), SC_(0.905801355838775634765625), SC_(0.9050789674549809417560657905473231961528e-14), SC_(0.9102844271967501166315561751329566240893e-36), SC_(0.9999999999999999999998994248612630556906), SC_(0.1005751387369443094387636644344224842611e-21) }, 
      { SC_(17), SC_(33), SC_(0.913384497165679931640625), SC_(0.9050789674549809417561503275247686885427e-14), SC_(0.6491465274182621783969415182857343112471e-37), SC_(0.9999999999999999999999928277360234807242), SC_(0.717226397651927576548015934282449610752e-23) }, 
      { SC_(17), SC_(33), SC_(0.9688708782196044921875), SC_(0.9050789674549809417561568189900428711295e-14), SC_(0.3490234302127337406050804897615799747808e-51), SC_(0.9999999999999999999999999999999999999614), SC_(0.3856276002017407746236199330460677229646e-37) }, 
      { SC_(17), SC_(37), SC_(0.12707412242889404296875), SC_(0.3614159584396375640916646004431432036295e-18), SC_(0.1820305418428503156737843532961529889356e-14), SC_(0.0001985074652943485929292623851541803415466), SC_(0.9998014925347056514070707376148458196585) }, 
      { SC_(17), SC_(37), SC_(0.1355634629726409912109375), SC_(0.7862226787631134729950927215512551123252e-18), SC_(0.1819880611708179680828940104840421777448e-14), SC_(0.000431832262725789341525539305960794836374), SC_(0.9995681677372742106584744606940392051636) }, 
      { SC_(17), SC_(37), SC_(0.221111953258514404296875), SC_(0.1111960293022607992333155420889507222058e-15), SC_(0.1709470805084681995068619655473022310354e-14), SC_(0.06107434221467700037019281594471733535258), SC_(0.9389256577853229996298071840552826646474) }, 
      { SC_(17), SC_(37), SC_(0.3082362115383148193359375), SC_(0.861204317266186416775713314295822636171e-15), SC_(0.9594625171207563775262218832661503963891e-15), SC_(0.4730158758322041977901065038596973313215), SC_(0.5269841241677958022098934961403026686785) }, 
      { SC_(17), SC_(37), SC_(0.632396042346954345703125), SC_(0.1820664906975209469063706519848260034022e-14), SC_(0.1927411733325238228677713712998537794419e-20), SC_(0.9999989413704380602732790539082945309573), SC_(0.1058629561939726720946091705469042663754e-5) }, 
      { SC_(17), SC_(37), SC_(0.81474220752716064453125), SC_(0.1820666834386941884080032325802373420234e-14), SC_(0.9102219028717595996123263795638338787183e-30), SC_(0.999999999999999500061249164100551532283), SC_(0.4999387508358994484677170243702880150121e-15) }, 
      { SC_(17), SC_(37), SC_(0.8350250720977783203125), SC_(0.1820666834386942776068403745802663174057e-14), SC_(0.1823353145175930985850276166513865052584e-31), SC_(0.9999999999999999899852454565643102436952), SC_(0.100147545434356897563048345285065794268e-16) }, 
      { SC_(17), SC_(37), SC_(0.905801355838775634765625), SC_(0.1820666834386942794301935133978338907528e-14), SC_(0.6358363412503227119154892436393887532953e-40), SC_(0.9999999999999999999999999650767329177816), SC_(0.3492326708221838495938821019002890628759e-25) }, 
      { SC_(17), SC_(37), SC_(0.913384497165679931640625), SC_(0.1820666834386942794301935194319124749941e-14), SC_(0.3242848282619390744620779136039336345006e-41), SC_(0.9999999999999999999999999982188678228374), SC_(0.1781132177162620013414483640719099153548e-26) }, 
      { SC_(17), SC_(37), SC_(0.9688708782196044921875), SC_(0.182066683438694279430193519756197303256e-14), SC_(0.2918334629915971906488165343385233887635e-57), SC_(1), SC_(0.1602893277780081703084482349145795656061e-42) }, 
      { SC_(21), SC_(1), SC_(0.12707412242889404296875), SC_(0.7294242668802688484011545133745007323249e-20), SC_(0.04761904761904761904032480495024493056361), SC_(0.1531790960448564581642424478086451537882e-18), SC_(0.9999999999999999998468209039551435418358) }, 
      { SC_(21), SC_(1), SC_(0.1355634629726409912109375), SC_(0.2836458586643004639127948800546815158699e-19), SC_(0.04761904761904761901925446175261757265634), SC_(0.5956563031950309742168692481148311833269e-18), SC_(0.9999999999999999994043436968049690257831) }, 
      { SC_(21), SC_(1), SC_(0.221111953258514404296875), SC_(0.8215563328332255052635416331346604662141e-15), SC_(0.04761904761904679749128621439354235550599), SC_(0.172526829894977356105343742958278697905e-13), SC_(0.9999999999999827473170105022643894656257) }, 
      { SC_(21), SC_(1), SC_(0.3082362115383148193359375), SC_(0.8797059470622085225222899933145876991794e-12), SC_(0.0476190476181679131005568390965253290543), SC_(0.1847382488830637897296808985960634168277e-10), SC_(0.9999999999815261751116936210270319101404) }, 
      { SC_(21), SC_(1), SC_(0.632396042346954345703125), SC_(0.3151756927556768320394368423111216198718e-5), SC_(0.04761589586212006227929865325062450783142), SC_(0.6618689547869213472828173688533554017307e-4), SC_(0.9999338131045213078652717182631146644598) }, 
      { SC_(21), SC_(1), SC_(0.81474220752716064453125), SC_(0.0006444737443095229527764243777579572840634), SC_(0.04697457387473809609484262324128966176356), SC_(0.01353394863049998200830491193291710296533), SC_(0.9864660513695000179916950880670828970347) }, 
      { SC_(21), SC_(1), SC_(0.8350250720977783203125), SC_(0.001080116332688790483344997826725696320845), SC_(0.04653893128635882856427404979232192272677), SC_(0.02268244298646460015024495436123962273775), SC_(0.9773175570135353998497550456387603772623) }, 
      { SC_(21), SC_(1), SC_(0.905801355838775634765625), SC_(0.005963112461447485812300694603202482005336), SC_(0.04165593515760013323531835301584513704228), SC_(0.1252253616903972020583145866672521221121), SC_(0.8747746383096027979416854133327478778879) }, 
      { SC_(21), SC_(1), SC_(0.913384497165679931640625), SC_(0.007104067230262221199213233815432633387676), SC_(0.04051498038878539784840581380361498565994), SC_(0.1491854118355066451834779101240853011412), SC_(0.8508145881644933548165220898759146988588) }, 
      { SC_(21), SC_(1), SC_(0.9688708782196044921875), SC_(0.02451120453688859590009625897873570467311), SC_(0.0231078430821590231475227886403119143745), SC_(0.5147352952746605139020214385534497981354), SC_(0.4852647047253394860979785614465502018646) }, 
      { SC_(21), SC_(5), SC_(0.12707412242889404296875), SC_(0.4349608451058638231780982467271012670049e-20), SC_(0.3764351590438542610677639662235097787999e-5), SC_(0.1155473485023727246272617992430544515799e-14), SC_(0.999999999999998844526514976272753727382) }, 
      { SC_(21), SC_(5), SC_(0.1355634629726409912109375), SC_(0.1629927342727793558364248343783282197776e-19), SC_(0.3764351590438530661012663442937745926498e-5), SC_(0.4329901985956383587794625725260289158392e-14), SC_(0.9999999999999956700980140436164122053743) }, 
      { SC_(21), SC_(5), SC_(0.221111953258514404296875), SC_(0.3185676126214388092443585016143970491664e-15), SC_(0.3764351590119979347664651911628971067367e-5), SC_(0.8462748629288521967576383595386457611106e-10), SC_(0.9999999999153725137071147803242361640461) }, 
      { SC_(21), SC_(5), SC_(0.3082362115383148193359375), SC_(0.2187555433481517304747161569809722895452e-12), SC_(0.3764351371683003612134360246157172588009e-5), SC_(0.5811241009043650720060834710199528871768e-7), SC_(0.9999999418875899095634927993916528980047) }, 
      { SC_(21), SC_(5), SC_(0.632396042346954345703125), SC_(0.8021407309836162851339428663693568572303e-7), SC_(0.3684137517340185331772696434236393883259e-5), SC_(0.02130886851857976661458319224510196491232), SC_(0.9786911314814202333854168077548980350877) }, 
      { SC_(21), SC_(5), SC_(0.81474220752716064453125), SC_(0.1864387696873891317722156093554928549939e-5), SC_(0.1899963893564655642563934627318401019043e-5), SC_(0.4952745916745492285528907662528667692913), SC_(0.5047254083254507714471092337471332307087) }, 
      { SC_(21), SC_(5), SC_(0.8350250720977783203125), SC_(0.2269070528404020041896562493365377049084e-5), SC_(0.1495281062034526918389528227507952519897e-5), SC_(0.6027785858705279241298218263625124130892), SC_(0.3972214141294720758701781736374875869108) }, 
      { SC_(21), SC_(5), SC_(0.905801355838775634765625), SC_(0.3462325313035738951349065531664375600095e-5), SC_(0.3020262774028080089370251892089539688866e-6), SC_(0.9197667194079440524258792584866413781653), SC_(0.08023328059205594757412074151335862183473) }, 
      { SC_(21), SC_(5), SC_(0.913384497165679931640625), SC_(0.3538459797671569545487073678420019491128e-5), SC_(0.2258917927669774147990170424533100778535e-6), SC_(0.9399918452514524497586411226722781778182), SC_(0.06000815474854755024135887732772182218178) }, 
      { SC_(21), SC_(5), SC_(0.9688708782196044921875), SC_(0.376088185709946033661553093198062469918e-5), SC_(0.3469733339086623670559788892704869801724e-8), SC_(0.9990782653384716384219157920806529513372), SC_(0.0009217346615283615780842079193470486628281) }, 
      { SC_(21), SC_(9), SC_(0.12707412242889404296875), SC_(0.259539437600598552093891429529556896292e-20), SC_(0.1109446386807446608598382519889795165152e-7), SC_(0.2339359888740464251991774822576093967734e-12), SC_(0.9999999999997660640111259535748008225177) }, 
      { SC_(21), SC_(9), SC_(0.1355634629726409912109375), SC_(0.9373229187590739712725669780042143907182e-20), SC_(0.1109446386806768825117224044470616489604e-7), SC_(0.8448564346188047655898153182792387429703e-12), SC_(0.9999999999991551435653811952344101846817) }, 
      { SC_(21), SC_(9), SC_(0.221111953258514404296875), SC_(0.1238403677878477177864808921312742640734e-15), SC_(0.1109446374423669369251211339793799843454e-7), SC_(0.111623571233742044958317556038925516996e-7), SC_(0.9999999888376428766257955041682443961074) }, 
      { SC_(21), SC_(9), SC_(0.3082362115383148193359375), SC_(0.5474381842910442973171512165238317442776e-13), SC_(0.1109440912425863237593009946929723818264e-7), SC_(0.4934336537579157083567480417318031784289e-5), SC_(0.9999950656634624208429164325195826819682) }, 
      { SC_(21), SC_(9), SC_(0.632396042346954345703125), SC_(0.2268049390630802092608338122240656863128e-8), SC_(0.8826414477446259387751493062178233702689e-8), SC_(0.2044307338867299250033467240233771071876), SC_(0.7955692661132700749966532759766228928124) }, 
      { SC_(21), SC_(9), SC_(0.81474220752716064453125), SC_(0.1027922570872574945279147403683643505545e-7), SC_(0.8152381593513120275683571475824555103677e-9), SC_(0.9265184718211523195860848879265837313625), SC_(0.07348152817884768041391511207341626863749) }, 
      { SC_(21), SC_(9), SC_(0.8350250720977783203125), SC_(0.1066191848543188276648014820003027613969e-7), SC_(0.4325453826451787138796829843886144261257e-9), SC_(0.9610125024707345975914126496163979412135), SC_(0.03898749752926540240858735038360205878649) }, 
      { SC_(21), SC_(9), SC_(0.905801355838775634765625), SC_(0.1108323206982855438357402329213271913987e-7), SC_(0.1123179824850709678580789228617142594687e-10), SC_(0.9989876213594398916483918502674307856446), SC_(0.001012378640560108351608149732569214355435) }, 
      { SC_(21), SC_(9), SC_(0.913384497165679931640625), SC_(0.1108836014392564269808286973758535822954e-7), SC_(0.6103724151418782276961446833532336281641e-11), SC_(0.9994498405489442812456208775263944553603), SC_(0.0005501594510557187543791224736055446397008) }, 
      { SC_(21), SC_(9), SC_(0.9688708782196044921875), SC_(0.1109446213766220023920848160285442954146e-7), SC_(0.1730414861241151349581564461024361935189e-14), SC_(0.9999998440289786133600672536549561351684), SC_(0.1559710213866399327463450438648316091245e-6) }, 
      { SC_(21), SC_(13), SC_(0.12707412242889404296875), SC_(0.154971731886196345053032330795508006275e-20), SC_(0.1342072242090598973629101879738917399882e-9), SC_(0.1154719746255993375055755979210527995326e-10), SC_(0.9999999999884528025374400662494424402079) }, 
      { SC_(21), SC_(13), SC_(0.1355634629726409912109375), SC_(0.5394551327045656113592192306613856320913e-20), SC_(0.1342072242052150633547264953108298709896e-9), SC_(0.4019568513376044761719434219030428226768e-10), SC_(0.9999999999598043148662395523828056578097) }, 
      { SC_(21), SC_(13), SC_(0.221111953258514404296875), SC_(0.4827432322777391554671178736010303161681e-16), SC_(0.1342071759362863869078566047126347031931e-9), SC_(0.3596998858423422958840028352739542846452e-6), SC_(0.9999996403001141576577041159971647260457) }, 
      { SC_(21), SC_(13), SC_(0.3082362115383148193359375), SC_(0.1379915212126827412253790026010786687836e-13), SC_(0.1341934250584883464076496135241619554293e-9), SC_(0.0001028197416527552045288692367430943009706), SC_(0.999897180258347244795471130763256905699) }, 
      { SC_(21), SC_(13), SC_(0.632396042346954345703125), SC_(0.7503858009968977096736667799928835409677e-10), SC_(0.5916864411091984371440547342513370919941e-10), SC_(0.5591247456391224046871518950452195698644), SC_(0.4408752543608775953128481049547804301356) }, 
      { SC_(21), SC_(13), SC_(0.81474220752716064453125), SC_(0.1336466248419378473896149772057057867239e-9), SC_(0.5605993686717672921571742187162765722699e-12), SC_(0.9958228823226980229643958229237819350312), SC_(0.004177117677301977035604177076218064968783) }, 
      { SC_(21), SC_(13), SC_(0.8350250720977783203125), SC_(0.1340149439729420917213971535993835022569e-9), SC_(0.1922802376675229603749978250385610392604e-12), SC_(0.9985672884690187754953868186109937663833), SC_(0.001432711530981224504613181389006233616743) }, 
      { SC_(21), SC_(13), SC_(0.905801355838775634765625), SC_(0.1342066517617575421675957834423935169831e-9), SC_(0.5724488520725141763679820285463131146605e-15), SC_(0.9999957345898818816355598612109392837074), SC_(0.4265410118118364440138789060716292619718e-5) }, 
      { SC_(21), SC_(13), SC_(0.913384497165679931640625), SC_(0.1342070003644248183967919050834916553298e-9), SC_(0.223846184796284980246340930407966363882e-15), SC_(0.9999983320854289855057644075477965931162), SC_(0.1667914571014494235592452203406883769538e-5) }, 
      { SC_(21), SC_(13), SC_(0.9688708782196044921875), SC_(0.1342072242095059488978071575123209025933e-9), SC_(0.1103665783964993912101160702826466812426e-20), SC_(0.9999999999917764055515146796121309624012), SC_(0.8223594448485320387869037598790270968534e-11) }, 
      { SC_(21), SC_(17), SC_(0.12707412242889404296875), SC_(0.9260000436175661541258328669440760090788e-21), SC_(0.3698344280447449857522948882477212862468e-11), SC_(0.2503823260266290225411970112378922978693e-9), SC_(0.9999999997496176739733709774588029887621) }, 
      { SC_(21), SC_(17), SC_(0.1355634629726409912109375), SC_(0.3107302064043854136454290789647130802048e-20), SC_(0.3698344278266147837096660900148754939765e-11), SC_(0.840187345373346072045990500205209325403e-9), SC_(0.9999999991598126546266539279540094997948) }, 
      { SC_(21), SC_(17), SC_(0.221111953258514404296875), SC_(0.1887434888364382560913154020209837309989e-16), SC_(0.3698325407024566257314905905062843631039e-11), SC_(0.5103459128644042888679017326677563177364e-5), SC_(0.9999948965408713559571113209826733224368) }, 
      { SC_(21), SC_(17), SC_(0.3082362115383148193359375), SC_(0.3507267075841475940235477564736915053109e-14), SC_(0.3694837014297608425200279559038308814359e-11), SC_(0.00094833439209693754178066631313124997715), SC_(0.9990516656079030624582193336868687500229) }, 
      { SC_(21), SC_(17), SC_(0.632396042346954345703125), SC_(0.31016544428767633074685341778080793418e-11), SC_(0.596689838496686593671980858794966387612e-12), SC_(0.8386602779243974094436642579616614263206), SC_(0.1613397220756025905563357420383385736794) }, 
      { SC_(21), SC_(17), SC_(0.81474220752716064453125), SC_(0.36978827664971293913296539378695655631e-11), SC_(0.461514876320509810861098733480166312779e-15), SC_(0.9998752104073585281364923916548208268665), SC_(0.0001247895926414718635076083451791731335068) }, 
      { SC_(21), SC_(17), SC_(0.8350250720977783203125), SC_(0.3698243321889224879904009334562147280343e-11), SC_(0.1009594842250212365057020408984490695063e-15), SC_(0.999972701437036703346638543849375881354), SC_(0.2729856296329665336145615062411864600013e-4) }, 
      { SC_(21), SC_(17), SC_(0.905801355838775634765625), SC_(0.3698344248139346854598434679502946524224e-11), SC_(0.3323410304654208035710009920518843722914e-19), SC_(0.9999999910137887340764366636278657479863), SC_(0.8986211265923563336372134252013700665689e-8) }, 
      { SC_(21), SC_(17), SC_(0.913384497165679931640625), SC_(0.3698344272051154114303280048406500855665e-11), SC_(0.9322295786837234988196544873746840436206e-20), SC_(0.9999999974793326208734616168489647491949), SC_(0.2520667379126538383151035250805066237702e-8) }, 
      { SC_(21), SC_(17), SC_(0.9688708782196044921875), SC_(0.3698344281373449116926704907271791277447e-11), SC_(0.7842138101293312544519649640324395031714e-27), SC_(0.9999999999999997879554334411239114076494), SC_(0.2120445665588760885923506395279432578781e-15) }, 
      { SC_(21), SC_(21), SC_(0.12707412242889404296875), SC_(0.5537238188173160071041484762857307462177e-21), SC_(0.1769376714444431089107949374237645933203e-12), SC_(0.3129485160305785980821502434793082864394e-8), SC_(0.9999999968705148396942140191784975652069) }, 
      { SC_(21), SC_(21), SC_(0.1355634629726409912109375), SC_(0.1791396548643944720235950259611457244773e-20), SC_(0.1769376702067703790841662242919628099946e-12), SC_(0.1012444963479853836965616194112630614685e-7), SC_(0.9999999898755503652014616303438380588737) }, 
      { SC_(21), SC_(21), SC_(0.221111953258514404296875), SC_(0.7403738049452549438072876591121232714065e-17), SC_(0.1769302682601174751786728716513219483733e-12), SC_(0.4184376320679324909484929111941015081877e-4), SC_(0.9999581562367932067509051507088805898492) }, 
      { SC_(21), SC_(21), SC_(0.3082362115383148193359375), SC_(0.8999673897926082009607253226117197705277e-15), SC_(0.1760377046083743195271502192053013498355e-12), SC_(0.00508635261009838454806473996973150930773), SC_(0.9949136473899016154519352600302684906923) }, 
      { SC_(21), SC_(21), SC_(0.632396042346954345703125), SC_(0.1696493299693199595978355217418133502399e-12), SC_(0.7288342028846968130275422786099719366157e-14), SC_(0.958808421369291694586675064153507033899), SC_(0.04119157863070830541332493584649296610104) }, 
      { SC_(21), SC_(21), SC_(0.81474220752716064453125), SC_(0.1769372555481242639678697466305729374431e-12), SC_(0.4164500426637602411978973401321628859766e-18), SC_(0.9999976463460948662495180278996121828891), SC_(0.2353653905133750481972100387817110888699e-5) }, 
      { SC_(21), SC_(21), SC_(0.8350250720977783203125), SC_(0.1769376142230299129665111855420530160018e-12), SC_(0.5777513701476159975898586005360424101021e-19), SC_(0.9999996734718143270238713091396741140826), SC_(0.3265281856729761286908603258859173938848e-6) }, 
      { SC_(21), SC_(21), SC_(0.905801355838775634765625), SC_(0.1769376719960963638484833537187039108669e-12), SC_(0.2070563879627590809209158739118880118508e-23), SC_(0.9999999999882977782162238359986984857169), SC_(0.1170222178377616400130151428313612835615e-10) }, 
      { SC_(21), SC_(21), SC_(0.913384497165679931640625), SC_(0.1769376719977508538264361894421514141562e-12), SC_(0.4160739016747550857616554498744349783537e-24), SC_(0.9999999999976484719337831820989686900055), SC_(0.2351528066216817901031309994503081031619e-11) }, 
      { SC_(21), SC_(21), SC_(0.9688708782196044921875), SC_(0.176937671998166927727518781372251355139e-12), SC_(0.5921631556617144669911484902390887465353e-33), SC_(0.9999999999999999999966532669443743485528), SC_(0.3346733055625651447232957850830323459183e-20) }, 
      { SC_(21), SC_(25), SC_(0.12707412242889404296875), SC_(0.3313708078488295609288064769052136957425e-21), SC_(0.1261881038477753118294269247938577302018e-13), SC_(0.2626006644388231491547209706334837962852e-7), SC_(0.9999999737399335561176850845279029366516) }, 
      { SC_(21), SC_(25), SC_(0.1355634629726409912109375), SC_(0.1033711565534185321631677773087683769502e-20), SC_(0.1261880968243677349758693177651447683771e-13), SC_(0.8191830345876737690279326818488998031541e-7), SC_(0.99999991808169654123262309720673181511) }, 
      { SC_(21), SC_(25), SC_(0.221111953258514404296875), SC_(0.291467091502045477544699190593995932416e-17), SC_(0.1261589604523331857699680641628630996607e-13), SC_(0.0002309782578234999245329049288897875443298), SC_(0.9997690217421765000754670950711102124557) }, 
      { SC_(21), SC_(25), SC_(0.3082362115383148193359375), SC_(0.2334899485425350468185864315872513996604e-15), SC_(0.1238532076760580398495366697660499852573e-13), SC_(0.018503324425315064816982021180534017551), SC_(0.981496675574684935183017978819465982449) }, 
      { SC_(21), SC_(25), SC_(0.632396042346954345703125), SC_(0.1252000174930032003560184401968988568645e-13), SC_(0.9880896684801899617040938850236423894235e-16), SC_(0.9921697084558394402732671794177686657498), SC_(0.007830291544160559726732820582231334250245) }, 
      { SC_(21), SC_(25), SC_(0.81474220752716064453125), SC_(0.1261881031913780283187869871217570271569e-13), SC_(0.3970105361998935546960165472097003124333e-21), SC_(0.9999999685381970511818761075725260477739), SC_(0.3146180294881812389242747395222612495931e-7) }, 
      { SC_(21), SC_(25), SC_(0.8350250720977783203125), SC_(0.1261881068131809989348861972254701362282e-13), SC_(0.3483023913828363368564523630257100201532e-22), SC_(0.9999999972398160237310440795511009467908), SC_(0.2760183976268955920448899053209204326659e-8) }, 
      { SC_(21), SC_(25), SC_(0.905801355838775634765625), SC_(0.126188107161482042062375233357163046047e-13), SC_(0.1348255347300724759453206924777950915085e-27), SC_(0.9999999999999893155117575750829334765532), SC_(0.1068448824242491706652344675124683726355e-13) }, 
      { SC_(21), SC_(25), SC_(0.913384497165679931640625), SC_(0.1261881071614831963660287482798789598213e-13), SC_(0.1939516937858020435394326376542651447466e-28), SC_(0.9999999999999984629954585371398015323787), SC_(0.1537004541462860198467621325840458049406e-14) }, 
      { SC_(21), SC_(25), SC_(0.9688708782196044921875), SC_(0.1261881071614833903177225294325481542283e-13), SC_(0.464937434502564519996863834839769996215e-39), SC_(0.9999999999999999999999999631552097134176), SC_(0.3684479028658242372195833727650323695252e-25) }, 
      { SC_(21), SC_(29), SC_(0.12707412242889404296875), SC_(0.198467883744500350835784531674247245132e-21), SC_(0.1219440178984669832476451107487647889377e-14), SC_(0.1627532492889119626924492722692009540408e-6), SC_(0.999999837246750711088037307550727730799) }, 
      { SC_(21), SC_(29), SC_(0.1355634629726409912109375), SC_(0.5970723496885531978845351762582949928191e-21), SC_(0.1219439780380203888423604058737003305329e-14), SC_(0.4896281611864080683553190751868761035065e-6), SC_(0.9999995103718388135919316446809248131239) }, 
      { SC_(21), SC_(29), SC_(0.221111953258514404296875), SC_(0.1151967189553619234639296833965926223126e-17), SC_(0.1218288410262999957742162646438213637401e-14), SC_(0.0009446687274371808200176375575263052044711), SC_(0.9990553312725628191799823624424736947955) }, 
      { SC_(21), SC_(29), SC_(0.3082362115383148193359375), SC_(0.6135506545478440235749010582024774519063e-16), SC_(0.1158085311997769174619311837451931818433e-14), SC_(0.05031411669585430569546657584574426399243), SC_(0.9496858833041456943045334241542557360076) }, 
      { SC_(21), SC_(29), SC_(0.632396042346954345703125), SC_(0.1218012898504042099142607809946950296164e-14), SC_(0.1427478948511477834194133325229267460058e-17), SC_(0.9988293983249156281964578045353646720229), SC_(0.001170601675084371803542195464635327977097) }, 
      { SC_(21), SC_(29), SC_(0.81474220752716064453125), SC_(0.1219440377060047211312008522556930079754e-14), SC_(0.3925063656647934207152494838703196478597e-24), SC_(0.9999999996781258248273272393010169379192), SC_(0.3218741751726727606989830620807842234154e-9) }, 
      { SC_(21), SC_(29), SC_(0.8350250720977783203125), SC_(0.1219440377430812955216249103740152681706e-14), SC_(0.2174062176055283953202688191751654714461e-25), SC_(0.9999999999821716402355237483259225719471), SC_(0.1782835976447625167407742805291814639081e-10) }, 
      { SC_(21), SC_(29), SC_(0.905801355838775634765625), SC_(0.1219440377452553567928452076435243489307e-14), SC_(0.9048349866836936074316844178763986508196e-32), SC_(0.9999999999999999925799161368272861604859), SC_(0.7420083863172713839514094987423517556924e-17) }, 
      { SC_(21), SC_(29), SC_(0.913384497165679931640625), SC_(0.1219440377452553576045365808104915092595e-14), SC_(0.9314361351672644710287372197227322870634e-33), SC_(0.9999999999999999992361773872757422928398), SC_(0.7638226127242577071602147547862669614168e-18) }, 
      { SC_(21), SC_(29), SC_(0.9688708782196044921875), SC_(0.1219440377452553576976801943271804464555e-14), SC_(0.375099069212898587315421817717697617128e-45), SC_(0.9999999999999999999999999999996924006486), SC_(0.3075993514307697887140591123591667881188e-30) }, 
      { SC_(21), SC_(33), SC_(0.12707412242889404296875), SC_(0.1189702296503024561057736571996474338538e-21), SC_(0.1497516985767483284496511182682366861476e-15), SC_(0.7944493202092911681780125869978627128266e-6), SC_(0.9999992055506797907088318219874130021373) }, 
      { SC_(21), SC_(33), SC_(0.1355634629726409912109375), SC_(0.3452203872057258601902387537040301998282e-21), SC_(0.1497514723265907730262470338031401817648e-15), SC_(0.2305283454055095545455093559199413917764e-5), SC_(0.9999976947165459449044545449064408005861) }, 
      { SC_(21), SC_(33), SC_(0.221111953258514404296875), SC_(0.4572714234940211682069698709933274949536e-18), SC_(0.1492945461234839575839002541709005583e-15), SC_(0.003053528371036782757400906381331415409256), SC_(0.9969464716289632172425990936186685845907) }, 
      { SC_(21), SC_(33), SC_(0.3082362115383148193359375), SC_(0.1636292677544220657122693080653504708949e-16), SC_(0.1333888907715357721808802932353588387055e-15), SC_(0.1092669661275334127960112829500737624499), SC_(0.8907330338724665872039887170499262375501) }, 
      { SC_(21), SC_(33), SC_(0.632396042346954345703125), SC_(0.1497303076034594041038282556117706249953e-15), SC_(0.2150994351857464827896843012326079972561e-19), SC_(0.9998563627215287262923340851908352239751), SC_(0.0001436372784712737076659148091647760249308) }, 
      { SC_(21), SC_(33), SC_(0.81474220752716064453125), SC_(0.1497518175465797782802865698098713227397e-15), SC_(0.3982004718206542320225630552455081633154e-27), SC_(0.9999999999973409306254614470542562071476), SC_(0.2659069374538552945743792852394028428809e-11) }, 
      { SC_(21), SC_(33), SC_(0.8350250720977783203125), SC_(0.1497518175469640676880572856605256677815e-15), SC_(0.1391106404993838136821801351422199926433e-28), SC_(0.9999999999999071058750550763556485062567), SC_(0.9289412494492364435149374328007959582022e-13) }, 
      { SC_(21), SC_(33), SC_(0.905801355838775634765625), SC_(0.1497518175469779787514865075964397075416e-15), SC_(0.6207164454541782533940128513100306250127e-36), SC_(0.99999999999999999999585503230864322532), SC_(0.4144967691356774679955275709120880890447e-20) }, 
      { SC_(21), SC_(33), SC_(0.913384497165679931640625), SC_(0.1497518175469779787520615124015918198119e-15), SC_(0.4571164030206598304394256583843189511998e-37), SC_(0.9999999999999999999996947506811546645367), SC_(0.3052493188453354633183747048852830148141e-21) }, 
      { SC_(21), SC_(33), SC_(0.9688708782196044921875), SC_(0.1497518175469779787521072240418938854863e-15), SC_(0.3087343269887266708010726965442317880614e-51), SC_(0.9999999999999999999999999999999999979384), SC_(0.2061639932295813330393697572077665859135e-35) }, 
      { SC_(21), SC_(37), SC_(0.12707412242889404296875), SC_(0.7138001376200267680117553743248179098422e-22), SC_(0.2233134000857067342526901293597305925957e-16), SC_(0.3196395092093969992992531501495110926677e-5), SC_(0.9999968036049079060300070074684985048891) }, 
      { SC_(21), SC_(37), SC_(0.1355634629726409912109375), SC_(0.1998164535489254855020200979611557065138e-21), SC_(0.2233121157213088650246031209141253058565e-16), SC_(0.8947775403531789011655368788675514159923e-5), SC_(0.9999910522245964682109883446312113244858) }, 
      { SC_(21), SC_(37), SC_(0.221111953258514404296875), SC_(0.1823826053540969463557990694948405447136e-18), SC_(0.2214902878323033848159001504201565119664e-16), SC_(0.008167088151326112263236570546248161384273), SC_(0.9918329118486738877367634294537518386157) }, 
      { SC_(21), SC_(37), SC_(0.3082362115383148193359375), SC_(0.4439444640175211794236098190877517013073e-17), SC_(0.1789196674840922363370971592063297472828e-16), SC_(0.1987982113143375081211298208381957117004), SC_(0.8012017886856624918788701791618042882996) }, 
      { SC_(21), SC_(37), SC_(0.632396042346954345703125), SC_(0.2233107749113890525733799193571189340879e-16), SC_(0.3338974455301706078221757985983325689918e-21), SC_(0.9999850480813899270513554928186726856957), SC_(0.1495191861007294864450718132731430431042e-4) }, 
      { SC_(21), SC_(37), SC_(0.81474220752716064453125), SC_(0.2233141138858402360592903579132301230911e-16), SC_(0.4118220167783201874794322527733737277681e-30), SC_(0.9999999999999815586211900229943333345898), SC_(0.1844137880997700566666541019848807318769e-13) }, 
      { SC_(21), SC_(37), SC_(0.8350250720977783203125), SC_(0.2233141138858442635993091128161282217038e-16), SC_(0.9068014902829897669570979227246228322515e-32), SC_(0.9999999999999995939345370948938685601712), SC_(0.4060654629051061314398288321849254150616e-15) }, 
      { SC_(21), SC_(37), SC_(0.905801355838775634765625), SC_(0.2233141138858443542794577081541553801987e-16), SC_(0.4329609495372148580647268796255728983386e-40), SC_(0.9999999999999999999999980612020350915232), SC_(0.1938797964908476817862602747865866229882e-23) }, 
      { SC_(21), SC_(37), SC_(0.913384497165679931640625), SC_(0.2233141138858443542794581183087193431472e-16), SC_(0.2280638557426637886745925383933352153482e-41), SC_(0.9999999999999999999999998978730668768892), SC_(0.1021269331231108162898587042022721416594e-24) }, 
      { SC_(21), SC_(37), SC_(0.9688708782196044921875), SC_(0.2233141138858443542794581411151049174136e-16), SC_(0.258040407736505315612211991409378862823e-57), SC_(1), SC_(0.1155504250252685100918600480904214206e-40) }, 
      { SC_(25), SC_(1), SC_(0.12707412242889404296875), SC_(0.1597673273661498548434357104638852421695e-23), SC_(0.03999999999999999999999840232672633850145), SC_(0.3994183184153746371085892761597131054237e-22), SC_(0.9999999999999999999999600581681584625363) }, 
      { SC_(25), SC_(1), SC_(0.1355634629726409912109375), SC_(0.8046858242348116713348913655426886675354e-23), SC_(0.03999999999999999999999195314175765188329), SC_(0.2011714560587029178337228413856721668838e-21), SC_(0.9999999999999999999997988285439412970822) }, 
      { SC_(25), SC_(1), SC_(0.221111953258514404296875), SC_(0.1649550128790510916897395121185273199834e-17), SC_(0.0399999999999999983504498712094890831026), SC_(0.4123875321976277292243487802963182999585e-16), SC_(0.9999999999999999587612467802372270775651) }, 
      { SC_(25), SC_(1), SC_(0.3082362115383148193359375), SC_(0.66703933817976178521321519828444827342e-14), SC_(0.03999999999999332960661820238214786784802), SC_(0.166759834544940446303303799571112068355e-12), SC_(0.9999999999998332401654550595536966962004) }, 
      { SC_(25), SC_(1), SC_(0.632396042346954345703125), SC_(0.4234367772775465006548723909339369376012e-6), SC_(0.03999957656322272245349934512760906606306), SC_(0.1058591943193866251637180977334842344003e-4), SC_(0.9999894140805680613374836281902266515766) }, 
      { SC_(25), SC_(1), SC_(0.81474220752716064453125), SC_(0.0002385422859244572859877041998679867831854), SC_(0.03976145771407554271401229580013201321681), SC_(0.005963557148111432149692604996699669579636), SC_(0.9940364428518885678503073950033003304204) }, 
      { SC_(25), SC_(1), SC_(0.8350250720977783203125), SC_(0.0004411109936915462521507520548180191069017), SC_(0.0395588890063084537478492479451819808931), SC_(0.01102777484228865630376880137045047767254), SC_(0.9889722251577113436962311986295495223275) }, 
      { SC_(25), SC_(1), SC_(0.905801355838775634765625), SC_(0.003371973491045919734247811521628730656085), SC_(0.03662802650895408026575218847837126934392), SC_(0.08429933727614799335619528804071826640212), SC_(0.9157006627238520066438047119592817335979) }, 
      { SC_(25), SC_(1), SC_(0.913384497165679931640625), SC_(0.004153372596466300397076080323237859154679), SC_(0.03584662740353369960292391967676214084532), SC_(0.103834314911657509926902008080946478867), SC_(0.896165685088342490073097991919053521133) }, 
      { SC_(25), SC_(1), SC_(0.9688708782196044921875), SC_(0.01814293519667633789459798895390515379617), SC_(0.02185706480332366210540201104609484620383), SC_(0.4535733799169084473649497238476288449042), SC_(0.5464266200830915526350502761523711550958) }, 
      { SC_(25), SC_(5), SC_(0.12707412242889404296875), SC_(0.9487940470277985317723177449112695450859e-24), SC_(0.1684139615174097931769828326766989056119e-5), SC_(0.5633701852739310732031079689846890741334e-18), SC_(0.9999999999999999994366298147260689267969) }, 
      { SC_(25), SC_(5), SC_(0.1355634629726409912109375), SC_(0.4603548305942073532099496737452861883025e-23), SC_(0.1684139615174097928115074067852714055792e-5), SC_(0.2733471895360754711522378675281073064593e-17), SC_(0.9999999999999999972665281046392452884776) }, 
      { SC_(25), SC_(5), SC_(0.221111953258514404296875), SC_(0.6344759430783656841529448418424936121451e-18), SC_(0.1684139615173463456775544008110634643049e-5), SC_(0.3767359531013565841079148234650266445515e-12), SC_(0.9999999999996232640468986434158920851765) }, 
      { SC_(25), SC_(5), SC_(0.3082362115383148193359375), SC_(0.1637568762480553311414327139397252108032e-14), SC_(0.1684139613536529170238069062380460448494e-5), SC_(0.9723473919418905424850420971956033704468e-9), SC_(0.9999999990276526080581094575149579028044) }, 
      { SC_(25), SC_(5), SC_(0.632396042346954345703125), SC_(0.1022087253566025704798084955859225701084e-7), SC_(0.167391874263843767567064152423619533088e-5), SC_(0.006068898589861669128664828946653117406611), SC_(0.9939311014101383308713351710533468825934) }, 
      { SC_(25), SC_(5), SC_(0.81474220752716064453125), SC_(0.5975909401486118346260824166156026614746e-6), SC_(0.1086548675025486098092539957179184926416e-5), SC_(0.3548345604867419921051020869259294703171), SC_(0.6451654395132580078948979130740705296829) }, 
      { SC_(25), SC_(5), SC_(0.8350250720977783203125), SC_(0.7850543785110883794409623126964464521014e-6), SC_(0.8990852366630095532776600610983411357897e-6), SC_(0.4661456636004215025025573972213324920965), SC_(0.5338543363995784974974426027786675079035) }, 
      { SC_(25), SC_(5), SC_(0.905801355838775634765625), SC_(0.1461720628422142927272752673995526187651e-5), SC_(0.2224189867519550054458696997992614002405e-6), SC_(0.8679331661413579166413787190016935620722), SC_(0.1320668338586420833586212809983064379278) }, 
      { SC_(25), SC_(5), SC_(0.913384497165679931640625), SC_(0.1513813850912902376345766785400455845569e-5), SC_(0.1703257642611955563728555883943317423218e-6), SC_(0.8988648193258086085147076730011556697029), SC_(0.1011351806741913914852923269988443302971) }, 
      { SC_(25), SC_(5), SC_(0.9688708782196044921875), SC_(0.1681010394182010403168739226875575320462e-5), SC_(0.3129220992087529549883146919212267428793e-8), SC_(0.9981419468054232271415181344380447359075), SC_(0.001858053194576772858481865561955264092531) }, 
      { SC_(25), SC_(9), SC_(0.12707412242889404296875), SC_(0.5637170210157629032537918462938425448836e-24), SC_(0.2880981746387752498118354501481357038299e-8), SC_(0.195668376490953265194713839636793293315e-15), SC_(0.9999999999999998043316235090467348052862) }, 
      { SC_(25), SC_(9), SC_(0.1355634629726409912109375), SC_(0.2635102620919176084225519958499703296747e-23), SC_(0.2880981746387750426732754598068176066571e-8), SC_(0.9146543966212676036214064571230851631439e-15), SC_(0.9999999999999990853456033787323963785935) }, 
      { SC_(25), SC_(9), SC_(0.221111953258514404296875), SC_(0.2444880979179872528185530784916877690654e-18), SC_(0.28809817461432649639173882644257072136e-8), SC_(0.8486277229091525560360576590147094222489e-10), SC_(0.9999999999151372277090847443963942340985) }, 
      { SC_(25), SC_(9), SC_(0.3082362115383148193359375), SC_(0.4038650785814602843037667815639092866685e-15), SC_(0.2880981342522674480375091213477478728182e-8), SC_(0.1401831438494313323769462345712810126488e-6), SC_(0.999999859816856150568667623053765428719) }, 
      { SC_(25), SC_(9), SC_(0.632396042346954345703125), SC_(0.2661981908662332060967511990839419762082e-9), SC_(0.2614783555521519855738624318160318315883e-8), SC_(0.09239843022261392414568611853171268731558), SC_(0.9076015697773860758543138814682873126844) }, 
      { SC_(25), SC_(9), SC_(0.81474220752716064453125), SC_(0.2468984032019285337815541640272684777745e-8), SC_(0.4119977143684677240198338769715755143462e-9), SC_(0.8569939865516188159685919839510459498259), SC_(0.1430060134483811840314080160489540501741) }, 
      { SC_(25), SC_(9), SC_(0.8350250720977783203125), SC_(0.2645592376399593501318152479346957314938e-8), SC_(0.235389369988159560517223037897302977153e-9), SC_(0.9182954316585668627221858663759983371486), SC_(0.08170456834143313727781413362400166285143) }, 
      { SC_(25), SC_(9), SC_(0.905801355838775634765625), SC_(0.2873033232371580944317776713742804864576e-8), SC_(0.7948514016172117517598803501455427515652e-11), SC_(0.9972410397857819949383831366693111654331), SC_(0.00275896021421800506161686333068883456685) }, 
      { SC_(25), SC_(9), SC_(0.913384497165679931640625), SC_(0.2876538750348971356689093263857836006753e-8), SC_(0.4442996038781705146282253386424285338096e-11), SC_(0.9984578187472543188950753593487839235044), SC_(0.001542181252745681104924640651216076495566) }, 
      { SC_(25), SC_(9), SC_(0.9688708782196044921875), SC_(0.288098020072804409355824943882433405969e-8), SC_(0.1545659708968277126078419926232401453822e-14), SC_(0.9999994634954869442460332573887377670211), SC_(0.5365045130557539667426112622329788509874e-6) }, 
      { SC_(25), SC_(13), SC_(0.12707412242889404296875), SC_(0.3350916166751864296461726063303381388727e-24), SC_(0.2159264084278773010042679337342967466296e-10), SC_(0.155187880498233229012371262426988340298e-13), SC_(0.9999999999999844812119501766770987628738) }, 
      { SC_(25), SC_(13), SC_(0.1355634629726409912109375), SC_(0.1509214132866284863147989056512232005957e-23), SC_(0.2159264084278655597791060227499617284651e-10), SC_(0.6989483796144193626684591896957482142605e-13), SC_(0.999999999999930105162038558063733154081) }, 
      { SC_(25), SC_(13), SC_(0.221111953258514404296875), SC_(0.9439614963228655634239362868429510625108e-19), SC_(0.2159264074839191555975691221746569215127e-10), SC_(0.4371681552042062455592003776909863414404e-8), SC_(0.9999999956283184479579375444079962230901) }, 
      { SC_(25), SC_(13), SC_(0.3082362115383148193359375), SC_(0.1001164061721693872133742019627737355061e-15), SC_(0.2159254072638189302265625518565735806183e-10), SC_(0.4636598501364330956112888323027704250512e-5), SC_(0.9999953634014986356690438871116769722957) }, 
      { SC_(25), SC_(13), SC_(0.632396042346954345703125), SC_(0.7748273354100763692766601315332866540312e-11), SC_(0.1384436748868730149927686724452645429526e-10), SC_(0.3588386159207887902866074283341342336467), SC_(0.6411613840792112097133925716658657663533) }, 
      { SC_(25), SC_(13), SC_(0.81474220752716064453125), SC_(0.2132262384478714203692299006494588810698e-10), SC_(0.2700169980009231551204784949134327285912e-12), SC_(0.9874949525643080965709160814197298344574), SC_(0.01250504743569190342908391858027016554263) }, 
      { SC_(25), SC_(13), SC_(0.8350250720977783203125), SC_(0.214919710748069213834602618775955858396e-10), SC_(0.1006697679811438085832066822637349959644e-12), SC_(0.9953377741650916461492232692488214033131), SC_(0.004662225834908353850776730751178596686854) }, 
      { SC_(25), SC_(13), SC_(0.905801355838775634765625), SC_(0.2159224209232146647927749175592259548062e-10), SC_(0.3987504665987127659768039367253549440847e-15), SC_(0.9999815330385244704661384960844197605011), SC_(0.1846696147552953386150391558023949889954e-4) }, 
      { SC_(25), SC_(13), SC_(0.913384497165679931640625), SC_(0.2159248017831380357193894700214509293394e-10), SC_(0.1606644742616201045215577142279016325159e-15), SC_(0.9999925592948342267275240517904740046239), SC_(0.7440705165773272475948209525995376074909e-5) }, 
      { SC_(25), SC_(13), SC_(0.9688708782196044921875), SC_(0.2159264084180618342101840134990799597713e-10), SC_(0.9818817710250672099513248584418208147095e-21), SC_(0.9999999999545270178773424375952002178016), SC_(0.454729821226575624047997821983895028632e-10) }, 
      { SC_(25), SC_(17), SC_(0.12707412242889404296875), SC_(0.1992909724420474112019979605863084136253e-24), SC_(0.388057730165439878075835949813484127454e-12), SC_(0.5135601147720514175424803045763973504684e-12), SC_(0.9999999999994864398852279485824575196954) }, 
      { SC_(25), SC_(17), SC_(0.1355634629726409912109375), SC_(0.8648948380462826819428133087502619748455e-24), SC_(0.3880577301647742742102317145427433121058e-12), SC_(0.2228778789375255107734277184310316304392e-11), SC_(0.9999999999977712212106247448922657228157) }, 
      { SC_(25), SC_(17), SC_(0.221111953258514404296875), SC_(0.3652349726072341079010259061224413702247e-19), SC_(0.3880576936421419083248672071220955131705e-12), SC_(0.9411872106022385906808362840265327362488e-7), SC_(0.9999999058812789397761409319163715973467) }, 
      { SC_(25), SC_(17), SC_(0.3082362115383148193359375), SC_(0.2496262712802569687651951946536271952254e-16), SC_(0.3880327675385111433514014777052207626951e-12), SC_(0.6432709668577046521969878576149138336361e-4), SC_(0.9999356729033142295347803012142385086166) }, 
      { SC_(25), SC_(17), SC_(0.632396042346954345703125), SC_(0.2646429281737904917977139702727220311317e-12), SC_(0.1234148019918486772505640269519640942829e-12), SC_(0.6819679331238418831072097975854543362382), SC_(0.3180320668761581168927902024145456637618) }, 
      { SC_(25), SC_(17), SC_(0.81474220752716064453125), SC_(0.3878407020563625006846760858647278688486e-12), SC_(0.2170281092766683636019113599582565659727e-15), SC_(0.9994407324158082568135396937898541706609), SC_(0.0005592675841917431864603062101458293390931) }, 
      { SC_(25), SC_(17), SC_(0.8350250720977783203125), SC_(0.3880058918885488631236410197281765638219e-12), SC_(0.5183827709030592463697749650956159272313e-16), SC_(0.9998664160688973282575998974926653590977), SC_(0.0001335839311026717424001025073346409023336) }, 
      { SC_(25), SC_(17), SC_(0.905801355838775634765625), SC_(0.3880577072074346989782583979101387112185e-12), SC_(0.2295820447007001959931454741419608602497e-19), SC_(0.9999999408381725567726645665819816195673), SC_(0.5916182744322733543341801838043267912682e-7) }, 
      { SC_(25), SC_(17), SC_(0.913384497165679931640625), SC_(0.3880577235241188230535612284543838343887e-12), SC_(0.6641520345994716768770302291025878277164e-20), SC_(0.9999999828852260122228725427378660110318), SC_(0.1711477398777712745726213398896824175453e-7) }, 
      { SC_(25), SC_(17), SC_(0.9688708782196044921875), SC_(0.388057730165638472894163501155500052392e-12), SC_(0.6961541144960691860730226034004261917255e-27), SC_(0.9999999999999982060552840967201606517304), SC_(0.1793944715903279839348269620658520128882e-14) }, 
      { SC_(25), SC_(21), SC_(0.12707412242889404296875), SC_(0.1185884050465238540351786744021300530552e-24), SC_(0.1261881071602975062672572955415707125099e-13), SC_(0.9397748148703572421028816985845306450517e-11), SC_(0.9999999999906022518512964275789711830142) }, 
      { SC_(25), SC_(21), SC_(0.1355634629726409912109375), SC_(0.4959593571500662677978774434022416950148e-24), SC_(0.1261881071565237967462218714039437248199e-13), SC_(0.3930317747895094684650920983745686158765e-10), SC_(0.9999999999606968225210490531534907901625) }, 
      { SC_(25), SC_(21), SC_(0.221111953258514404296875), SC_(0.1416402601279854124334018039656279925802e-19), SC_(0.1261879655212232623323101006801185336259e-13), SC_(0.1122453322377899245785714645066577809028e-5), SC_(0.9999988775466776221007542142853549334222) }, 
      { SC_(25), SC_(21), SC_(0.3082362115383148193359375), SC_(0.6265030830726706551406462648814214870228e-17), SC_(0.1261254568531761232522084694554343571052e-13), SC_(0.000496483462004016217098620161235948202506), SC_(0.9995035165379959837829013798387640517975) }, 
      { SC_(25), SC_(21), SC_(0.632396042346954345703125), SC_(0.1121154142627829279864024096719166626271e-13), SC_(0.1407269289870046233132012441000583662686e-14), SC_(0.8884784531977202506079957099675130066778), SC_(0.1115215468022797493920042900324869933222) }, 
      { SC_(25), SC_(21), SC_(0.81474220752716064453125), SC_(0.1261861761191155172026561533059498585108e-13), SC_(0.1931042367873115066380775972640743111534e-18), SC_(0.9999846971128158539301787351301829931314), SC_(0.1530288718414606982126486981700686857832e-4) }, 
      { SC_(25), SC_(21), SC_(0.8350250720977783203125), SC_(0.1261878139133779896553706542843523494919e-13), SC_(0.2932481054006623518797975701497620142916e-19), SC_(0.9999976761034617518142170413763993513404), SC_(0.232389653824818578295862360064865958596e-5) }, 
      { SC_(25), SC_(21), SC_(0.905801355838775634765625), SC_(0.126188107147252487303576146240600328477e-13), SC_(0.1423090301414638784132217077687530413246e-23), SC_(0.9999999998872246891227629851303593433852), SC_(0.1127753108772370148696406566147551465869e-9) }, 
      { SC_(25), SC_(21), SC_(0.913384497165679931640625), SC_(0.1261881071585326298762551363328048634991e-13), SC_(0.2950760441467397749117635754775678716797e-24), SC_(0.999999999976616176374756944158598640165), SC_(0.2338382362524305584140135983504319815732e-10) }, 
      { SC_(25), SC_(21), SC_(0.9688708782196044921875), SC_(0.1261881071614833903124730754096607830842e-13), SC_(0.5249458672261716169739178886906241496435e-33), SC_(0.9999999999999999999583997352021140599877), SC_(0.4160026479788594001225132024785775101059e-19) }, 
      { SC_(25), SC_(25), SC_(0.12707412242889404296875), SC_(0.7060520931340766014711564885713026615537e-25), SC_(0.6328582881252841342253223740023436939057e-15), SC_(0.1115655915871534728950221046104151735519e-9), SC_(0.9999999998884344084128465271049778953896) }, 
      { SC_(25), SC_(25), SC_(0.1355634629726409912109375), SC_(0.284584412360132242921874127265186831456e-24), SC_(0.6328582879113049311785977912275852154976e-15), SC_(0.449681101864695034342074108585620412827e-9), SC_(0.9999999995503188981353049656579258914144) }, 
      { SC_(25), SC_(25), SC_(0.221111953258514404296875), SC_(0.5506558615053064790713840353402613897828e-20), SC_(0.6328527816372742904739393203091059401489e-15), SC_(0.8701092673923571115101361874068045339889e-5), SC_(0.9999912989073260764288848986381259319547) }, 
      { SC_(25), SC_(25), SC_(0.3082362115383148193359375), SC_(0.1584136035331111611226845160870340380182e-17), SC_(0.6312741521605582319275031889885890023826e-15), SC_(0.002503144961326274339588583378644514221829), SC_(0.9974968550386737256604114166213554857782) }, 
      { SC_(25), SC_(25), SC_(0.632396042346954345703125), SC_(0.6145615735747614935920133681592871070965e-15), SC_(0.1829671462112784994671666599017223566632e-16), SC_(0.9710887651115593083241314996500952959314), SC_(0.02891123488844069167586850034990470406855) }, 
      { SC_(25), SC_(25), SC_(0.81474220752716064453125), SC_(0.632858105782207140896271131335371340049e-15), SC_(0.1824136822026424589028140880027138375553e-21), SC_(0.9999997117621976277574719649254295076868), SC_(0.2882378023722425280350745704923132312664e-6) }, 
      { SC_(25), SC_(25), SC_(0.8350250720977783203125), SC_(0.6328582706505150740656429628503860566507e-15), SC_(0.1754537426947308707129907328611206498145e-22), SC_(0.9999999722759824802322135676992015878606), SC_(0.2772401751976778643230079841213936809198e-7) }, 
      { SC_(25), SC_(25), SC_(0.905801355838775634765625), SC_(0.632858288195796995403048729986878092092e-15), SC_(0.9234813568130416258125067083061004972295e-28), SC_(0.9999999999998540777020641317105877414836), SC_(0.1459222979358682894122585164483947924076e-12) }, 
      { SC_(25), SC_(25), SC_(0.913384497165679931640625), SC_(0.6328582881958756309315369723480535360178e-15), SC_(0.1371260719306180140580674495698942116768e-28), SC_(0.999999999999978332262611029718310789097), SC_(0.216677373889702816892109029736898860476e-13) }, 
      { SC_(25), SC_(25), SC_(0.9688708782196044921875), SC_(0.6328582881958893435387296223769521963407e-15), SC_(0.4117725071464220629993752510861279906261e-39), SC_(0.9999999999999999999999993493448457153402), SC_(0.6506551542846597782985219254162764050258e-24) }, 
      { SC_(25), SC_(29), SC_(0.12707412242889404296875), SC_(0.420611432349547100857095557297213576972e-25), SC_(0.4425091245110315048639933225770436057889e-16), SC_(0.9505147095317446720132842792522152794e-9), SC_(0.9999999990494852904682553279867157207478) }, 
      { SC_(25), SC_(29), SC_(0.1355634629726409912109375), SC_(0.1634071187997616852710113194029004522142e-24), SC_(0.4425091232975717492159235707240259690571e-16), SC_(0.3692740094907741663478235362057875441152e-8), SC_(0.9999999963072599050922583365217646379421) }, 
      { SC_(25), SC_(29), SC_(0.221111953258514404296875), SC_(0.2146570050397844633011193348523284543062e-20), SC_(0.4424876592311389587672103115006539302406e-16), SC_(0.4850905731558503569106139000469882478699e-4), SC_(0.9999514909426844149643089386099953011752) }, 
      { SC_(25), SC_(29), SC_(0.3082362115383148193359375), SC_(0.4039737370958195688046173028636550984052e-18), SC_(0.438469387560684741525494250405502612102e-16), SC_(0.00912916173555118975228135687292292617951), SC_(0.9908708382644488102477186431270770738205) }, 
      { SC_(25), SC_(29), SC_(0.632396042346954345703125), SC_(0.4399374608427732917928933263254032865428e-16), SC_(0.2571664088869645420647097108735876543243e-18), SC_(0.9941884495844760129245069341005641359269), SC_(0.005811550415523987075493065899435864073126) }, 
      { SC_(25), SC_(29), SC_(0.81474220752716064453125), SC_(0.4425091231397148200352401776757749886751e-16), SC_(0.1791928117178300245758364174411008321544e-24), SC_(0.999999995950528438356813031709594649454), SC_(0.4049471561643186968290405350545988509044e-8) }, 
      { SC_(25), SC_(29), SC_(0.8350250720977783203125), SC_(0.4425091248227092420099846531426319287587e-16), SC_(0.1089336952035557702915072343273927336388e-25), SC_(0.9999999997538272341380905591407946884341), SC_(0.2461727658619094408592053115659363298255e-9) }, 
      { SC_(25), SC_(29), SC_(0.905801355838775634765625), SC_(0.4425091249316428753895607135273678949147e-16), SC_(0.6182397970990677126817134552205058970714e-32), SC_(0.9999999999999998602876726678639777210096), SC_(0.1397123273321360222789904275625311938791e-15) }, 
      { SC_(25), SC_(29), SC_(0.913384497165679931640625), SC_(0.442509124931642930642749715957030087114e-16), SC_(0.6570790707477109075972070412455046245134e-33), SC_(0.9999999999999999851510616679551209574539), SC_(0.1484893833204487904254613630627722892519e-16) }, 
      { SC_(25), SC_(29), SC_(0.9688708782196044921875), SC_(0.4425091249316429372135404234308193789348e-16), SC_(0.3319784151265326249624682268363438739173e-45), SC_(0.9999999999999999999999999999924978176399), SC_(0.7502182360144897351557612530333526374496e-29) }, 
      { SC_(25), SC_(33), SC_(0.12707412242889404296875), SC_(0.2507180844822598230635401653400372593939e-25), SC_(0.4028411441104207354462282200036111387967e-17), SC_(0.6223745677108174707809305216514346272325e-8), SC_(0.9999999937762543228918252921906947834857) }, 
      { SC_(25), SC_(33), SC_(0.1355634629726409912109375), SC_(0.9389426105511353587635040444161298773852e-25), SC_(0.4028411372281754747574728630039723480357e-17), SC_(0.2330801156820333544128228821249110251068e-7), SC_(0.9999999766919884317966645587177117875089) }, 
      { SC_(25), SC_(33), SC_(0.221111953258514404296875), SC_(0.8392347178787635872892307504559278402262e-21), SC_(0.402757223145813703910097527563967199413e-17), SC_(0.000208328946763576310529108980065378850629), SC_(0.9997916710532364236894708910199346211494) }, 
      { SC_(25), SC_(33), SC_(0.3082362115383148193359375), SC_(0.1040250145693519217977233328584869266979e-18), SC_(0.3924386451606663880890541173531640995273e-17), SC_(0.02582283747397284722455245974131517178288), SC_(0.9741771625260271527754475402586848282171) }, 
      { SC_(25), SC_(33), SC_(0.632396042346954345703125), SC_(0.4024609960012784670488140890868799840123e-17), SC_(0.380150616323113220012361552132808184737e-20), SC_(0.9990563262479143607156105698064679702359), SC_(0.0009436737520856392843894301935320297640739) }, 
      { SC_(25), SC_(33), SC_(0.81474220752716064453125), SC_(0.402841146599508002535062676138389687798e-17), SC_(0.1809357773376377450062310439900132657087e-27), SC_(0.9999999999550850803457295071231420937833), SC_(0.4491491965427049287685790621666329510578e-10) }, 
      { SC_(25), SC_(33), SC_(0.8350250720977783203125), SC_(0.4028411466169073006346513110242902298882e-17), SC_(0.694279634175139614722562308823936037372e-29), SC_(0.999999999998276542403861770664754093951), SC_(0.1723457596138229335245906048974027645062e-11) }, 
      { SC_(25), SC_(33), SC_(0.905801355838775634765625), SC_(0.402841146617601580226493649298536518479e-17), SC_(0.4233280134047627371808354737857276724757e-36), SC_(0.9999999999999999998949144056015190549724), SC_(0.1050855943984809450276282819783802315575e-18) }, 
      { SC_(25), SC_(33), SC_(0.913384497165679931640625), SC_(0.4028411466176015802656071123984092761405e-17), SC_(0.3219338240603516056554195194586226905773e-37), SC_(0.9999999999999999999920084175421646176586), SC_(0.7991582457835382341371928610097689695411e-20) }, 
      { SC_(25), SC_(33), SC_(0.9688708782196044921875), SC_(0.4028411466176015802688264506390127648871e-17), SC_(0.27309973983458816191874933601349110623e-51), SC_(0.9999999999999999999999999999999999322066), SC_(0.6779340743308654133704673826415092789561e-34) }, 
      { SC_(25), SC_(37), SC_(0.12707412242889404296875), SC_(0.149541436594757210258881856296585372672e-25), SC_(0.4547116912000528335297157731247786712367e-18), SC_(0.3288708748220492804064557188618123294613e-7), SC_(0.9999999671129125177950719593544281138188) }, 
      { SC_(25), SC_(37), SC_(0.1355634629726409912109375), SC_(0.5399201297574950841618974185791274793483e-25), SC_(0.4547116521621835172559283828232224429825e-18), SC_(0.1187389993373963658973590145735048760446e-6), SC_(0.9999998812610006626036341026409854264951) }, 
      { SC_(25), SC_(37), SC_(0.221111953258514404296875), SC_(0.3291616537385116387654856460980177615201e-21), SC_(0.4543825445004579813666713133668662831337e-18), SC_(0.0007238908725760629634980437741312887897312), SC_(0.9992761091274239370365019562258687112103) }, 
      { SC_(25), SC_(37), SC_(0.3082362115383148193359375), SC_(0.2708743885551737638268264871573917028017e-19), SC_(0.427624267298679116622754150297225130615e-18), SC_(0.05957057733264470273320754993540283997613), SC_(0.9404294226673552972667924500645971600239) }, 
      { SC_(25), SC_(37), SC_(0.632396042346954345703125), SC_(0.4546535183941957567994070618739309780929e-18), SC_(0.5818776000073620602973713903332280235539e-22), SC_(0.9998720337321137620848963034994270315816), SC_(0.0001279662678862379151036965005729684184087) }, 
      { SC_(25), SC_(37), SC_(0.81474220752716064453125), SC_(0.4547117061540100443791574246633133814737e-18), SC_(0.186448626279374349650919421486781302788e-30), SC_(0.9999999999995899629946712916130054919079), SC_(0.4100370053287083869945080921375958268716e-12) }, 
      { SC_(25), SC_(37), SC_(0.8350250720977783203125), SC_(0.4547117061541919810481111043813605590789e-18), SC_(0.4511957325694631603741816348086713914586e-32), SC_(0.9999999999999900773231376528722347392176), SC_(0.9922676862347127765260782396240754506182e-14) }, 
      { SC_(25), SC_(37), SC_(0.905801355838775634765625), SC_(0.4547117061541964930054073136771865442123e-18), SC_(0.294853357777566829131475576176464516766e-40), SC_(0.9999999999999999999999351559782193996075), SC_(0.6484402178060039246539832372700121880531e-22) }, 
      { SC_(25), SC_(37), SC_(0.913384497165679931640625), SC_(0.4547117061541964930054351949152644980517e-18), SC_(0.160409769980284346353714714889085494167e-41), SC_(0.9999999999999999999999964722753382142295), SC_(0.352772466178577046002196102840876753031e-23) }, 
      { SC_(25), SC_(37), SC_(0.9688708782196044921875), SC_(0.454711706154196493005436799012964300895e-18), SC_(0.2281629868641911844869186334568622614942e-57), SC_(0.9999999999999999999999999999999999999995), SC_(0.5017750451025758994963207620132509440486e-39) }, 
      { SC_(29), SC_(1), SC_(0.12707412242889404296875), SC_(0.359135600102960082837952038861467781969e-27), SC_(0.03448275862068965517241379274431267575911), SC_(0.104149324029858424023006091269825656771e-25), SC_(0.9999999999999999999999999895850675970142) }, 
      { SC_(29), SC_(1), SC_(0.1355634629726409912109375), SC_(0.2342820302505420134768135575484898253716e-26), SC_(0.03448275862068965517241379076062797335665), SC_(0.6794178877265718390827593168906204935777e-25), SC_(0.9999999999999999999999999320582112273428) }, 
      { SC_(29), SC_(1), SC_(0.221111953258514404296875), SC_(0.3399041077394536427355776465402732826712e-20), SC_(0.03448275862068965516901475202605373943471), SC_(0.9857219124444155639331751749667925197464e-19), SC_(0.9999999999999999999014278087555584436067) }, 
      { SC_(29), SC_(1), SC_(0.3082362115383148193359375), SC_(0.5190725831816841799591964830005430822855e-16), SC_(0.03448275862068960326515547493503027994242), SC_(0.1505310491226884121881669800701574938628e-14), SC_(0.9999999999999984946895087731158781183302) }, 
      { SC_(29), SC_(1), SC_(0.632396042346954345703125), SC_(0.5838310116402752871484187863604365706318e-7), SC_(0.03448270023758849114488507826156963981841), SC_(0.1693109933756798332730414480445266054832e-5), SC_(0.9999983068900662432016672695855195547339) }, 
      { SC_(29), SC_(1), SC_(0.81474220752716064453125), SC_(0.9061252846134422176383261830550795151111e-4), SC_(0.03439214609222831095064996048514276791056), SC_(0.002627763325378982431151145930859730593822), SC_(0.9973722366746210175688488540691402694062) }, 
      { SC_(29), SC_(1), SC_(0.8350250720977783203125), SC_(0.0001848791581692297171397829183562882380917), SC_(0.03429787946252042545527401018509198762398), SC_(0.00536149558690766179705370463233235890466), SC_(0.9946385044130923382029462953676676410953) }, 
      { SC_(29), SC_(1), SC_(0.905801355838775634765625), SC_(0.001956852214904967807578610223315721711456), SC_(0.03252590640578468736483518288013255415061), SC_(0.05674871423224406641977969647615592963221), SC_(0.9432512857677559335802203035238440703678) }, 
      { SC_(29), SC_(1), SC_(0.913384497165679931640625), SC_(0.002492053996831051086418819527327685032298), SC_(0.03199070462385860408599497357612059082977), SC_(0.07226956590810048150614576629250286593663), SC_(0.9277304340918995184938542337074971340634) }, 
      { SC_(29), SC_(1), SC_(0.9688708782196044921875), SC_(0.01378202931700787193533889766796402678691), SC_(0.02070072930368178323707489543548424907516), SC_(0.3996788501932282861248280323709567768204), SC_(0.6003211498067717138751719676290432231796) }, 
      { SC_(29), SC_(5), SC_(0.12707412242889404296875), SC_(0.2126347425242740860642744294789474996536e-27), SC_(0.8426871608184177705866347040514218613506e-6), SC_(0.2523293962587055724507531799740774188889e-21), SC_(0.9999999999999999999997476706037412944275) }, 
      { SC_(29), SC_(5), SC_(0.1355634629726409912109375), SC_(0.1335964999300211307408108524422129960327e-26), SC_(0.8426871608184177705855113737946459241293e-6), SC_(0.1585362945369574754275054223761253181321e-20), SC_(0.9999999999999999999984146370546304252457) }, 
      { SC_(29), SC_(5), SC_(0.221111953258514404296875), SC_(0.1299673364596398393416588929496977268851e-20), SC_(0.8426871608184164709134827423955527188478e-6), SC_(0.15422963882992540454995977508554729854e-14), SC_(0.9999999999999984577036117007459545004022) }, 
      { SC_(29), SC_(5), SC_(0.3082362115383148193359375), SC_(0.1262415254724635545923739529192840121759e-16), SC_(0.8426871608057936180396009833347087401448e-6), SC_(0.1498082934476630509636783224502559515689e-10), SC_(0.999999999985019170655233694903632167755) }, 
      { SC_(29), SC_(5), SC_(0.632396042346954345703125), SC_(0.1355985287795916432137820232873133824776e-8), SC_(0.8413311755306218541547095185610730016119e-6), SC_(0.001609120621321658111689308513945890447185), SC_(0.9983908793786783418883106914860541095528) }, 
      { SC_(29), SC_(5), SC_(0.81474220752716064453125), SC_(0.2042517799583145461080120159564677949804e-6), SC_(0.6384353808601032244788353228374783404563e-6), SC_(0.2423815022409327055754556990952212029474), SC_(0.7576184977590672944245443009047787970526) }, 
      { SC_(29), SC_(5), SC_(0.8350250720977783203125), SC_(0.2911612956639961426159637119792973346304e-6), SC_(0.5515258651544216279708836268146488008062e-6), SC_(0.3455152863385509425195118177315925610593), SC_(0.6544847136614490574804881822684074389407) }, 
      { SC_(29), SC_(5), SC_(0.905801355838775634765625), SC_(0.6781199767540766913432874305173946835987e-6), SC_(0.1645671840643410792435599082765514518379e-6), SC_(0.804711414014527728083252328046381923133), SC_(0.195288585985472271916747671953618076867) }, 
      { SC_(29), SC_(5), SC_(0.913384497165679931640625), SC_(0.7137668307880234101566187874410169835149e-6), SC_(0.1289203300303943604302285513529291519218e-6), SC_(0.8470128227595316203646563826805060339975), SC_(0.1529871772404683796353436173194939660025) }, 
      { SC_(29), SC_(5), SC_(0.9688708782196044921875), SC_(0.8398640037955100963065731803119629397334e-6), SC_(0.2823157022907674280274158481983195703313e-8), SC_(0.9966498160240559210850842616126001813228), SC_(0.003350183975944078914915738387399818677208) }, 
      { SC_(29), SC_(9), SC_(0.12707412242889404296875), SC_(0.1259405114018007768399065174704760121913e-27), SC_(0.8931501439516881509994938699378347668132e-9), SC_(0.1410070997073176204192687811142841313578e-18), SC_(0.9999999999999999998589929002926823795807) }, 
      { SC_(29), SC_(9), SC_(0.1355634629726409912109375), SC_(0.7621348334747549356053936689491234847869e-27), SC_(0.8931501439516881503632995478648806080477e-9), SC_(0.8533109899112102334196007754811730160106e-18), SC_(0.9999999999999999991466890100887897665804) }, 
      { SC_(29), SC_(9), SC_(0.221111953258514404296875), SC_(0.497635989196415747203540281180919732023e-21), SC_(0.8931501439511905151362379655924320033719e-9), SC_(0.5571694664848350897941275901525186063378e-12), SC_(0.9999999999994428305335151649102058724098) }, 
      { SC_(29), SC_(9), SC_(0.3082362115383148193359375), SC_(0.3080904334509785707754678711102434521584e-17), SC_(0.8931501408707838166156486735849568325506e-9), SC_(0.3449480868780374407220496932382693407683e-8), SC_(0.9999999965505191312196255927795030676173) }, 
      { SC_(29), SC_(9), SC_(0.632396042346954345703125), SC_(0.3334821741306036690082541464898171315279e-10), SC_(0.8598019265386277842246089666906538305003e-9), SC_(0.03733775070058570428891776313300918987007), SC_(0.9626622492994142957110822368669908101299) }, 
      { SC_(29), SC_(9), SC_(0.81474220752716064453125), SC_(0.6823701774382258858737849339806104419797e-9), SC_(0.2107799665134622652516494473590251016734e-9), SC_(0.7640038822802186392236513799978405391287), SC_(0.2359961177197813607763486200021594608713) }, 
      { SC_(29), SC_(9), SC_(0.8350250720977783203125), SC_(0.7639380413812777918049984610894066585057e-9), SC_(0.1292121025704103593204359202502288851474e-9), SC_(0.8553299202318668177353332838855619877319), SC_(0.1446700797681331822646667161144380122681) }, 
      { SC_(29), SC_(9), SC_(0.905801355838775634765625), SC_(0.8875144753627104906968167790579857206715e-9), SC_(0.5635668588977660428617602281649822981624e-11), SC_(0.9936901218376979824919429681239825220385), SC_(0.006309878162302017508057031876017477961459) }, 
      { SC_(29), SC_(9), SC_(0.913384497165679931640625), SC_(0.8899110438490427283783652133482390747571e-9), SC_(0.3239100102645422747069167991396468895994e-11), SC_(0.9963733979951968405045082600033393537271), SC_(0.003626602004803159495491739996660646272911) }, 
      { SC_(29), SC_(9), SC_(0.9688708782196044921875), SC_(0.8931487631164461637137348622164355237021e-9), SC_(0.1380835241987411699519123200019950954663e-14), SC_(0.9999984539718754587099113452193322238063), SC_(0.1546028124541290088654780667776193738842e-5) }, 
      { SC_(29), SC_(13), SC_(0.12707412242889404296875), SC_(0.746203870114713043856169271922912782028e-28), SC_(0.4365649464363440577172740457306414525297e-11), SC_(0.1709261992301339552990385085687752542884e-16), SC_(0.9999999999999999829073800769866044700961) }, 
      { SC_(29), SC_(13), SC_(0.1355634629726409912109375), SC_(0.4349665779572004212754337596697704422365e-27), SC_(0.436564946436344021682654951157729763548e-11), SC_(0.9963387612949893505106504868754216648643e-16), SC_(0.999999999999999900366123870501064948935) }, 
      { SC_(29), SC_(13), SC_(0.221111953258514404296875), SC_(0.1908226565143387659814342101284655449987e-21), SC_(0.4365649464172617995278788702796284700786e-11), SC_(0.4371002712700910638951353462213802806259e-10), SC_(0.9999999999562899728729908936104864653779) }, 
      { SC_(29), SC_(13), SC_(0.3082362115383148193359375), SC_(0.7547770430069072306020087096591862282703e-18), SC_(0.4365648709586397644885896866769009251728e-11), SC_(0.1728899787232372223383657890365391019286e-6), SC_(0.9999998271100212767627776616342109634609) }, 
      { SC_(29), SC_(13), SC_(0.632396042346954345703125), SC_(0.8898435322826115098047937360533082849551e-12), SC_(0.3475805932080829141988333732724410625959e-11), SC_(0.2038284428345326187386796062030167011499), SC_(0.7961715571654673812613203937969832988501) }, 
      { SC_(29), SC_(13), SC_(0.81474220752716064453125), SC_(0.4234789075669683566873437142812860783949e-11), SC_(0.1308603886937570849196903259648581269648e-12), SC_(0.9700249894633173536095126758562968186421), SC_(0.02997501053668264639048732414370318135793) }, 
      { SC_(29), SC_(13), SC_(0.8350250720977783203125), SC_(0.431271279290785253204283601373955796176e-11), SC_(0.5293667145558811975029145503816094915393e-13), SC_(0.9878742734872079647567835255896372657052), SC_(0.01212572651279203524321647441036273429481) }, 
      { SC_(29), SC_(13), SC_(0.905801355838775634765625), SC_(0.4365371435983209426119374671905038771978e-11), SC_(0.2780283802312256737527968726801389365868e-15), SC_(0.9999363145432310229592370825274174878031), SC_(0.6368545676897704076291747258251219693489e-4) }, 
      { SC_(29), SC_(13), SC_(0.913384497165679931640625), SC_(0.4365534056698073669658766848136998963361e-11), SC_(0.1154076653669821343606206407199475534051e-15), SC_(0.9999735646056081578158075310989357911835), SC_(0.2643539439184218419246890106420881646051e-4) }, 
      { SC_(29), SC_(13), SC_(0.9688708782196044921875), SC_(0.4365649463489835883402985521636924647749e-11), SC_(0.8736047683901419471407942631655144270752e-21), SC_(0.9999999997998912245425726000618215783557), SC_(0.2001087754574273999381784216443418938087e-9) }, 
      { SC_(29), SC_(17), SC_(0.12707412242889404296875), SC_(0.4422990195145064616477830993629497092141e-28), SC_(0.5332717222149371050189100799883501524695e-13), SC_(0.8294064753282302640287466849573043430296e-15), SC_(0.9999999999999991705935246717697359712533) }, 
      { SC_(29), SC_(17), SC_(0.1355634629726409912109375), SC_(0.2483558378618974475403580846794774653117e-27), SC_(0.5332717222149350637595509755203363966718e-13), SC_(0.4657209964750325141439854217267115298534e-14), SC_(0.9999999999999953427900352496748585601458) }, 
      { SC_(29), SC_(17), SC_(0.221111953258514404296875), SC_(0.7328808908195017293825934520885245819069e-22), SC_(0.5332717214820566564984278651122183481641e-13), SC_(0.1374310431791676394046346516466665505932e-8), SC_(0.9999999986256895682083236059536534835333) }, 
      { SC_(29), SC_(17), SC_(0.3082362115383148193359375), SC_(0.1856994687702489576077306114425747498308e-18), SC_(0.5332698652202498448283535171886973745051e-13), SC_(0.3482267313911723938213482397198008799448e-5), SC_(0.9999965177326860882760617865176028019912) }, 
      { SC_(29), SC_(17), SC_(0.632396042346954345703125), SC_(0.2668006007731591873019856659248746942853e-13), SC_(0.2664711214417783600159439285699371059673e-13), SC_(0.5003089225601653308472781853721239069024), SC_(0.4996910774398346691527218146278760930976) }, 
      { SC_(29), SC_(17), SC_(0.81474220752716064453125), SC_(0.5322474920477367996505546368580538060038e-13), SC_(0.1024230167200747667374957636757994248842e-15), SC_(0.9980793465609865450020137033434048914148), SC_(0.001920653439013454997986296656595108585174) }, 
      { SC_(29), SC_(17), SC_(0.8350250720977783203125), SC_(0.5330048775722113950687119294993783954302e-13), SC_(0.2668446427261522492176649954334048223904e-16), SC_(0.9994996084892373135712686077788946365591), SC_(0.0005003915107626864287313922211053634409358) }, 
      { SC_(29), SC_(17), SC_(0.905801355838775634765625), SC_(0.5332715635261522245187800159802690779464e-13), SC_(0.1586887853227991495785145427223062312599e-19), SC_(0.9999997024241513056660324488327584127146), SC_(0.2975758486943339675511672415872853606108e-6) }, 
      { SC_(29), SC_(17), SC_(0.913384497165679931640625), SC_(0.5332716748758540842719595303300116787964e-13), SC_(0.473390834630459700641648001214561634053e-20), SC_(0.9999999112289636014756821705327003589456), SC_(0.8877103639852431782946729964105443942224e-7) }, 
      { SC_(29), SC_(17), SC_(0.9688708782196044921875), SC_(0.5332717222149313671911194692311098004522e-13), SC_(0.6180126810125263701999800449037851430522e-27), SC_(0.9999999999999884109234510763426287688781), SC_(0.1158907654892365737123112190004392238109e-13) }, 
      { SC_(29), SC_(21), SC_(0.12707412242889404296875), SC_(0.2622688919478594287842185743973347821686e-28), SC_(0.1219440377452527350087607157329301141767e-14), SC_(0.2150731571606204919024801870635544427316e-13), SC_(0.9999999999999784926842839379508097519813) }, 
      { SC_(29), SC_(21), SC_(0.1355634629726409912109375), SC_(0.1418713501820732224784391138981376672621e-27), SC_(0.121944037745241170562661987004970112451e-14), SC_(0.1163413585487849764030290406387721998878e-12), SC_(0.9999999999998836586414512150235969709594) }, 
      { SC_(29), SC_(21), SC_(0.221111953258514404296875), SC_(0.2819494097990247934422475322933764686613e-22), SC_(0.1219440349257612597074322599047426334286e-14), SC_(0.2312121322307084112246080922653764315221e-7), SC_(0.9999999768787867769291588775391907734624) }, 
      { SC_(29), SC_(21), SC_(0.3082362115383148193359375), SC_(0.4590604053823265741515184961715991390153e-19), SC_(0.121939447141201534431938679142256240371e-14), SC_(0.3764517018382785679447786586291466955818e-4), SC_(0.9999623548298161721432055221341370853304) }, 
      { SC_(29), SC_(21), SC_(0.632396042346954345703125), SC_(0.9403271353207874761066659148355463535727e-15), SC_(0.2791132421317661008701360284366332100512e-15), SC_(0.7711136622236162268814943102092668892095), SC_(0.2288863377763837731185056897907331107905) }, 
      { SC_(29), SC_(21), SC_(0.81474220752716064453125), SC_(0.1219350630989935903702448811237250100366e-14), SC_(0.8974646261767327435313203492946325789025e-19), SC_(0.9999264035665235587445776093948409242391), SC_(0.7359643347644125542239060515907576093559e-4) }, 
      { SC_(29), SC_(21), SC_(0.8350250720977783203125), SC_(0.1219425468599243026969437607234555794277e-14), SC_(0.1490885331055000736433603762376934659784e-19), SC_(0.9999877740202914266004206818657375560257), SC_(0.1222597970857339957931813426244397433674e-4) }, 
      { SC_(29), SC_(21), SC_(0.905801355838775634765625), SC_(0.1219440376474089147245427814030177552889e-14), SC_(0.9784644297313741292420020107346672069241e-24), SC_(0.999999999197611914593631230018077243295), SC_(0.8023880854063687699819227567050143772512e-9) }, 
      { SC_(29), SC_(21), SC_(0.913384497165679931640625), SC_(0.1219440377243221593955741939275749894347e-14), SC_(0.2093319830210600039964296692766610117394e-24), SC_(0.9999999998283376646438749173065769931957), SC_(0.1716623353561250826934230068043360852858e-9) }, 
      { SC_(29), SC_(21), SC_(0.9688708782196044921875), SC_(0.1219440377452553576511428139757496126558e-14), SC_(0.4653738035146834370659829632125960033463e-33), SC_(0.9999999999999999996183710067999693017256), SC_(0.3816289932000306982743556024075820476229e-18) }, 
      { SC_(29), SC_(25), SC_(0.12707412242889404296875), SC_(0.1555808326883127500311456973153521179605e-28), SC_(0.4425091249314873563808521106841080173888e-16), SC_(0.3515878519168305577869856033854732815277e-12), SC_(0.9999999999996484121480831694422130143966) }, 
      { SC_(29), SC_(25), SC_(0.1355634629726409912109375), SC_(0.8108204696267549526636715760145842245675e-28), SC_(0.4425091249308321167439136684814754915101e-16), SC_(0.1832324858277232809710125242158988114775e-11), SC_(0.9999999999981676751417227671902898747578) }, 
      { SC_(29), SC_(25), SC_(0.221111953258514404296875), SC_(0.1086668694038661029726216634065449788827e-22), SC_(0.4425090162647735333474374508124757565411e-16), SC_(0.2455697821387356294375543426541037429617e-6), SC_(0.9999997544302178612643705624456573458963) }, 
      { SC_(29), SC_(25), SC_(0.3082362115383148193359375), SC_(0.114089482338372941935666059958433668607e-19), SC_(0.4423950354493045642716047573741807294175e-16), SC_(0.0002578240219475633068398152847184694676278), SC_(0.9997421759780524366931601847152815305324) }, 
      { SC_(29), SC_(25), SC_(0.632396042346954345703125), SC_(0.4080242199350978159612788601521934573057e-16), SC_(0.3448490499654512125226156328194570578034e-17), SC_(0.922069618334147994700070948689252052613), SC_(0.07793038166585200529992905131074794738703) }, 
      { SC_(29), SC_(25), SC_(0.81474220752716064453125), SC_(0.4425082854672210243880321104453083441682e-16), SC_(0.8394644219128255083129888308189178650662e-22), SC_(0.9999981029443809943972152647456533976069), SC_(0.1897055619005602784735254346602393087313e-5) }, 
      { SC_(29), SC_(25), SC_(0.8350250720977783203125), SC_(0.4425090364473086610412824948891119191047e-16), SC_(0.8848433427617225792854502724398142763227e-23), SC_(0.9999998000395262135193967130560615022596), SC_(0.1999604737864806032869439384977403778204e-6) }, 
      { SC_(29), SC_(25), SC_(0.905801355838775634765625), SC_(0.442509124931010228309223097482730603167e-16), SC_(0.6327089043173259514085599191086274883097e-28), SC_(0.9999999999985701788535658686692872933484), SC_(0.142982114643413133071270665161492231357e-11) }, 
      { SC_(29), SC_(25), SC_(0.913384497165679931640625), SC_(0.4425091249315459655620196066845484300374e-16), SC_(0.9697165152081674959073304865046625530279e-29), SC_(0.9999999999997808595437759694842091843893), SC_(0.219140456224030515790815610680732559929e-12) }, 
      { SC_(29), SC_(25), SC_(0.9688708782196044921875), SC_(0.4425091249316429372135367764785811372145e-16), SC_(0.364695555802587153070833977934303334641e-39), SC_(0.9999999999999999999999917584624755721392), SC_(0.8241537524427860846310497415064245046403e-23) }, 
      { SC_(29), SC_(29), SC_(0.12707412242889404296875), SC_(0.923316069295911087670981747727498439589e-29), SC_(0.2293707585362121777016779926062608013511e-17), SC_(0.4025430596230184829070912070050343720885e-11), SC_(0.9999999999959745694037698151709290879299) }, 
      { SC_(29), SC_(29), SC_(0.1355634629726409912109375), SC_(0.4636311737582912101943600370202696652663e-28), SC_(0.2293707585324991820333909915919881827286e-17), SC_(0.2021317698538406234511919030950089014502e-10), SC_(0.9999999999797868230146159376548808096905) }, 
      { SC_(29), SC_(29), SC_(0.221111953258514404296875), SC_(0.4196338489685137322610015670220356686463e-23), SC_(0.2293703389032865252572416426923647610632e-17), SC_(0.1829500201528846315094395928451544038661e-5), SC_(0.999998170499798471153684905604071548456) }, 
      { SC_(29), SC_(29), SC_(0.3082362115383148193359375), SC_(0.2852508756228290544114355916643662642067e-20), SC_(0.2290855076615126647165624681022674168346e-17), SC_(0.001243623544003960208553088239105025948353), SC_(0.9987563764559960397914469117608949740516) }, 
      { SC_(29), SC_(29), SC_(0.632396042346954345703125), SC_(0.2246805164513807231425995277121752202217e-17), SC_(0.4690242085754770628374375981756562877118e-19), SC_(0.9795516999827359732498061118413741234703), SC_(0.02044830001726402675019388815862587652971) }, 
      { SC_(29), SC_(29), SC_(0.81474220752716064453125), SC_(0.229370750346869012242617646709449563346e-17), SC_(0.8190266481528356256984482219752875387485e-25), SC_(0.9999999642924558746561455237067644626732), SC_(0.357075441253438544762932355373267722163e-7) }, 
      { SC_(29), SC_(29), SC_(0.8350250720977783203125), SC_(0.2293707579908524292389333977729248225557e-17), SC_(0.5462830645320405059210069605431227808573e-26), SC_(0.9999999976183404196067285472715027565409), SC_(0.2381659580393271452728497243459095045749e-8) }, 
      { SC_(29), SC_(29), SC_(0.905801355838775634765625), SC_(0.2293707585371350712639828710355343040589e-17), SC_(0.4225069910326583974790399088824257728504e-32), SC_(0.9999999999999981579736068917702173801735), SC_(0.1842026393108229782619826469927511744716e-14) }, 
      { SC_(29), SC_(29), SC_(0.913384497165679931640625), SC_(0.2293707585371354474096736322666113933706e-17), SC_(0.4636130027142732038972823215178859609506e-33), SC_(0.9999999999999997978761522736938087008911), SC_(0.2021238477263061912991089086787658426483e-15) }, 
      { SC_(29), SC_(29), SC_(0.9688708782196044921875), SC_(0.2293707585371354937709739036645497747857e-17), SC_(0.2938200831315409921330762980283515302148e-45), SC_(0.9999999999999999999999999998719016822347), SC_(0.1280983177652835155613905687265858630952e-27) }, 
      { SC_(29), SC_(33), SC_(0.12707412242889404296875), SC_(0.548196806460790775602055554119956915312e-29), SC_(0.1580548711176344599854102309383253244491e-18), SC_(0.3468395517109841609821669358429932289937e-10), SC_(0.9999999999653160448289015839017833064157) }, 
      { SC_(29), SC_(33), SC_(0.1355634629726409912109375), SC_(0.2652449810146447194046469871415770903927e-28), SC_(0.1580548710965919299485536667538811812762e-18), SC_(0.1678182893889001598023451597171080242531e-9), SC_(0.9999999998321817106110998401976548402829) }, 
      { SC_(29), SC_(33), SC_(0.221111953258514404296875), SC_(0.162388951505564820852236477925874859376e-23), SC_(0.1580532472336013724018096163295666212417e-18), SC_(0.1027421365451447378901609206658752396105e-4), SC_(0.999989725786345485526210983907933412476) }, 
      { SC_(29), SC_(33), SC_(0.3082362115383148193359375), SC_(0.7180411287496169098026099587173438872645e-21), SC_(0.157336829994366811140215528735628536103e-18), SC_(0.004542986392303598492085400502265037404981), SC_(0.995457013607696401507914599497734962595) }, 
      { SC_(29), SC_(33), SC_(0.632396042346954345703125), SC_(0.1573769897387627724854885991196359805104e-18), SC_(0.677881384353655564529539574709899479898e-21), SC_(0.9957111009642618250279531822711310359453), SC_(0.004288899035738174972046817728868964054726) }, 
      { SC_(29), SC_(33), SC_(0.81474220752716064453125), SC_(0.1580548710408296120768139246485208757174e-18), SC_(0.8228681597320421404582500427289959549055e-28), SC_(0.9999999994793781717166621572661905349067), SC_(0.5206218282833378427338094650933428207703e-9) }, 
      { SC_(29), SC_(33), SC_(0.8350250720977783203125), SC_(0.1580548711196491591762331839663979811703e-18), SC_(0.3467268873784954727947898820008694005139e-29), SC_(0.9999999999780628787385860780175353878069), SC_(0.2193712126141392198246461219312176037881e-10) }, 
      { SC_(29), SC_(33), SC_(0.905801355838775634765625), SC_(0.1580548711231164277612628667101561869005e-18), SC_(0.2887552719841896930898022063054002580378e-36), SC_(0.9999999999999999981730694540931640760234), SC_(0.182693054590683592397657191554203992956e-17) }, 
      { SC_(29), SC_(33), SC_(0.913384497165679931640625), SC_(0.1580548711231164280273423031538163301614e-18), SC_(0.2267583554052954982894089741586370627703e-37), SC_(0.9999999999999999998565318779522697082624), SC_(0.1434681220477302917376098453993901464835e-18) }, 
      { SC_(29), SC_(33), SC_(0.9688708782196044921875), SC_(0.1580548711231164280500181386943456384088e-18), SC_(0.241581527904014031115934370038285327774e-51), SC_(0.9999999999999999999999999999999984715338), SC_(0.1528466197766437280200861380250780080934e-32) }, 
      { SC_(29), SC_(37), SC_(0.12707412242889404296875), SC_(0.325627871513340698326401999575383324557e-29), SC_(0.1375136207801982490398262524495062620067e-19), SC_(0.2367968129911411447040366567245330214953e-9), SC_(0.9999999997632031870088588552959633432755) }, 
      { SC_(29), SC_(37), SC_(0.1355634629726409912109375), SC_(0.1518299727035249962837552673597231578651e-28), SC_(0.1375136206609310634876353259983911946046e-19), SC_(0.110410860979551362635040882911848951428e-8), SC_(0.9999999988958913902044863736495911708815) }, 
      { SC_(29), SC_(37), SC_(0.221111953258514404296875), SC_(0.6298352557615355314077078984966842384189e-24), SC_(0.1375073224602034208358462452031614951219e-19), SC_(0.4580166328534982936961100529105950591546e-4), SC_(0.9999541983367146501706303889947089404941) }, 
      { SC_(29), SC_(37), SC_(0.3082362115383148193359375), SC_(0.1821385646344246906363877052148152889067e-21), SC_(0.1356922351664167892847964452299983090752e-19), SC_(0.01324512899579781362205186132580217616893), SC_(0.9867548710042021863779481386741978238311) }, 
      { SC_(29), SC_(37), SC_(0.632396042346954345703125), SC_(0.1374115311872362967066765712181182442339e-19), SC_(0.1020896255247394844837510640282177303367e-22), SC_(0.9992576035383160695862644825324792948634), SC_(0.000742396461683930413735517467520705136584) }, 
      { SC_(29), SC_(37), SC_(0.81474220752716064453125), SC_(0.1375136208119163221256409091899627109334e-19), SC_(0.8447140655194130921837510308913248831732e-31), SC_(0.9999999999938572334832956050972498397108), SC_(0.6142766516704394902750160289153867155914e-11) }, 
      { SC_(29), SC_(37), SC_(0.8350250720977783203125), SC_(0.1375136208127385747492579511780708771816e-19), SC_(0.2246144190237110407558478270852670786081e-32), SC_(0.9999999999998366602394030866833291025589), SC_(0.1633397605969133166708974410803630595077e-12) }, 
      { SC_(29), SC_(37), SC_(0.905801355838775634765625), SC_(0.1375136208127610361909594969437691810585e-19), SC_(0.2008253383772809058229826155174069350823e-40), SC_(0.9999999999999999999985395967527411317561), SC_(0.146040324725886824391598116606089568059e-20) }, 
      { SC_(29), SC_(37), SC_(0.913384497165679931640625), SC_(0.1375136208127610361911490386083350471782e-19), SC_(0.1128367381141478612557840407965125641831e-41), SC_(0.9999999999999999999999179450461363484083), SC_(0.8205495386365159173861528923246261311757e-22) }, 
      { SC_(29), SC_(37), SC_(0.9688708782196044921875), SC_(0.1375136208127610361911603222821464619623e-19), SC_(0.2017472114947164350714869437390792212068e-57), SC_(0.9999999999999999999999999999999999999853), SC_(0.1467107114933843906766705943017863953664e-37) }, 
      { SC_(33), SC_(1), SC_(0.12707412242889404296875), SC_(0.8229453437029361024955107993279757815054e-31), SC_(0.03030303030303030303030303030294800849593), SC_(0.2715719634219689138235185637782320078968e-29), SC_(0.9999999999999999999999999999972842803658) }, 
      { SC_(33), SC_(1), SC_(0.1355634629726409912109375), SC_(0.6953343020389542949026699937929590951752e-30), SC_(0.03030303030303030303030303030233496872826), SC_(0.2294603196728549173178810979516765014078e-28), SC_(0.9999999999999999999999999999770539680327) }, 
      { SC_(33), SC_(1), SC_(0.221111953258514404296875), SC_(0.7139854397833551755002029129895412354711e-23), SC_(0.03030303030303030303029589044863246947855), SC_(0.2356151951285072079150669612865486077055e-21), SC_(0.9999999999999999999997643848048714927921) }, 
      { SC_(33), SC_(1), SC_(0.3082362115383148193359375), SC_(0.4117624899561525549513752195639221276796e-18), SC_(0.03030303030303030261854054034687774807893), SC_(0.1358816216855303431339538224560943021343e-16), SC_(0.9999999999999999864118378314469656866046) }, 
      { SC_(33), SC_(1), SC_(0.632396042346954345703125), SC_(0.8205929687777687411017031994522859152417e-8), SC_(0.03030302209710061525261561928599830850744), SC_(0.2707956796966636845635620558192543520298e-6), SC_(0.9999997292043203033363154364379441807456) }, 
      { SC_(33), SC_(1), SC_(0.81474220752716064453125), SC_(0.3508756004588363151953241854350576832713e-4), SC_(0.03026794274298441939878349788448679726198), SC_(0.001157889481514159840144569811935690354795), SC_(0.9988421105184858401598554301880643096452) }, 
      { SC_(33), SC_(1), SC_(0.8350250720977783203125), SC_(0.7898962925645755921173217410200412877812e-4), SC_(0.03022404067377384547109129812892829890152), SC_(0.002606657765463099453987161745366136249678), SC_(0.9973933422345369005460128382546338637503) }, 
      { SC_(33), SC_(1), SC_(0.905801355838775634765625), SC_(0.001157641138967587107174938586281028219738), SC_(0.02914538916406271592312809171674927481057), SC_(0.03820215758593037453677297334727393125134), SC_(0.9617978424140696254632270266527260687487) }, 
      { SC_(33), SC_(1), SC_(0.913384497165679931640625), SC_(0.001524249462404083631367707417633389597229), SC_(0.02877878084062621939893532288539691343307), SC_(0.05030023225933475983513434478190185670854), SC_(0.9496997677406652401648656552180981432915) }, 
      { SC_(33), SC_(1), SC_(0.9688708782196044921875), SC_(0.01067236909908634389643896955703768540217), SC_(0.01963066120394395913386406074599261762813), SC_(0.3521881802698493485824859953822436182716), SC_(0.6478118197301506514175140046177563817284) }, 
      { SC_(33), SC_(5), SC_(0.12707412242889404296875), SC_(0.4861242410858350651210750044610828525388e-31), SC_(0.4588239882357529416352945278586229506988e-6), SC_(0.1059500491582961236905406156097863160866e-24), SC_(0.9999999999999999999999998940499508417039) }, 
      { SC_(33), SC_(5), SC_(0.1355634629726409912109375), SC_(0.395523587810379904974742698202752485948e-30), SC_(0.4588239882357529416352941809474592489024e-6), SC_(0.8620377267789058471938770895924260018364e-24), SC_(0.9999999999999999999999991379622732210942) }, 
      { SC_(33), SC_(5), SC_(0.221111953258514404296875), SC_(0.2717714760027027114949194512965783627861e-23), SC_(0.4588239882357529389175798164440199443332e-6), SC_(0.5923218553757505191625045203091230930169e-17), SC_(0.999999999999999994076781446242494808375) }, 
      { SC_(33), SC_(5), SC_(0.3082362115383148193359375), SC_(0.9942915062384085003717590319580177235695e-19), SC_(0.4588239882356535124846707356210098833792e-6), SC_(0.2167043423474017750432743233767020258254e-12), SC_(0.9999999999997832956576525982249567256766) }, 
      { SC_(33), SC_(5), SC_(0.632396042346954345703125), SC_(0.1850940547269471522524025147232537009206e-9), SC_(0.4586388941810259944830421739563238055814e-6), SC_(0.0004034097158665604141268274948016105923509), SC_(0.9995965902841334395858731725051983894076) }, 
      { SC_(33), SC_(5), SC_(0.81474220752716064453125), SC_(0.7297758146670120989887221862681662231408e-7), SC_(0.3858464067690517317364223578442304369683e-6), SC_(0.1590535441429532864564435174138674260842), SC_(0.8409464558570467135435564825861325739158) }, 
      { SC_(33), SC_(5), SC_(0.8350250720977783203125), SC_(0.1133018363154299696748263966765230053351e-6), SC_(0.3455221519203229719604681797945240539473e-6), SC_(0.2469396527219348874567390091605317422828), SC_(0.7530603472780651125432609908394682577172) }, 
      { SC_(33), SC_(5), SC_(0.905801355838775634765625), SC_(0.3364553193416880269418126094364541685812e-6), SC_(0.1223686688940649146934819670345928907011e-6), SC_(0.7332993216754189293992764550776103136103), SC_(0.2667006783245810706007235449223896863897) }, 
      { SC_(33), SC_(5), SC_(0.913384497165679931640625), SC_(0.3608503506138044798070188172760285786614e-6), SC_(0.9797363762194846182827575919501848062091e-7), SC_(0.7864679264075276566722004069708451467639), SC_(0.2135320735924723433277995930291548532361) }, 
      { SC_(33), SC_(5), SC_(0.9688708782196044921875), SC_(0.4562760097130274562592707263529845954458e-6), SC_(0.2547978522725485376023850118062463836525e-8), SC_(0.9944467190293976455052366590254346310053), SC_(0.005553280970602354494763340974565368994749) }, 
      { SC_(33), SC_(9), SC_(0.12707412242889404296875), SC_(0.2872403011112381324953143121434002613421e-31), SC_(0.3171489994717360117948821118835187186847e-9), SC_(0.9056951199268616601211568572065747490248e-22), SC_(0.999999999999999999999909430488007313834) }, 
      { SC_(33), SC_(9), SC_(0.1355634629726409912109375), SC_(0.2250570591077292532036273301640222097365e-30), SC_(0.3171489994717360117946857788545221132447e-9), SC_(0.7096256317459582705993182280298601812843e-21), SC_(0.9999999999999999999992903743682540417294) }, 
      { SC_(33), SC_(9), SC_(0.221111953258514404296875), SC_(0.1035589711616644970431132987911914179191e-23), SC_(0.3171489994717349762051992192686594113649e-9), SC_(0.3265309723005875810521464461767457275606e-14), SC_(0.9999999999999967346902769941241894785355) }, 
      { SC_(33), SC_(9), SC_(0.3082362115383148193359375), SC_(0.2407433633575457728602683914095049551027e-19), SC_(0.317148999447661675459156258627603003357e-9), SC_(0.7590859935189566014309200759289920677026e-10), SC_(0.9999999999240914006481043398569079924071) }, 
      { SC_(33), SC_(9), SC_(0.632396042346954345703125), SC_(0.4364972486092405220641258337458026157155e-11), SC_(0.3127840269856436065742695775761718163408e-9), SC_(0.01376316019714073547981663028827916129585), SC_(0.9862368398028592645201833697117208387042) }, 
      { SC_(33), SC_(9), SC_(0.81474220752716064453125), SC_(0.2078402746327265531095554477906310709689e-9), SC_(0.109308724839009458685355388122998771529e-9), SC_(0.6553395248886763765790714202972695670273), SC_(0.3446604751113236234209285797027304329727) }, 
      { SC_(33), SC_(9), SC_(0.8350250720977783203125), SC_(0.2455431753406602761824699305391511384021e-9), SC_(0.716058241310757356124409053744787040958e-10), SC_(0.7742202426924030955048599537334972371145), SC_(0.2257797573075969044951400462665027628855) }, 
      { SC_(33), SC_(9), SC_(0.905801355838775634765625), SC_(0.3131451849754727650329623124259166443254e-9), SC_(0.400381449626324676194852348771319817251e-11), SC_(0.9873756042020240945584982314134549200922), SC_(0.01262439579797590544150176858654507990778) }, 
      { SC_(33), SC_(9), SC_(0.913384497165679931640625), SC_(0.3147837636079300605664617586820853132601e-9), SC_(0.2365235863805951228449077231544529237824e-11), SC_(0.9925421935186753172056811877556632325352), SC_(0.007457806481324682794318812244336767464834) }, 
      { SC_(33), SC_(9), SC_(0.9688708782196044921875), SC_(0.3171477656986804735330738603716525984753e-9), SC_(0.1233773055538261836975541977244022625908e-14), SC_(0.9999961097999438960411871748582529666221), SC_(0.3890200056103958812825141747033377855311e-5) }, 
      { SC_(33), SC_(13), SC_(0.12707412242889404296875), SC_(0.1697731624589095568538151749882247152956e-31), SC_(0.1053651161035667813255151706722978952946e-11), SC_(0.161128434853176665295433261222786656718e-19), SC_(0.9999999999999999999838871565146823334705) }, 
      { SC_(33), SC_(13), SC_(0.1355634629726409912109375), SC_(0.1281029464579810845850674598847966386292e-30), SC_(0.1053651161035667813144026076510888824046e-11), SC_(0.121580036349093521808352406803095995222e-18), SC_(0.9999999999999999998784199636509064781916) }, 
      { SC_(33), SC_(13), SC_(0.221111953258514404296875), SC_(0.3950658830541128462490728474306430250456e-24), SC_(0.1053651161035272747389074910122620835784e-11), SC_(0.3749494117823491115036368336804139057282e-12), SC_(0.9999999999996250505882176508884963631663) }, 
      { SC_(33), SC_(13), SC_(0.3082362115383148193359375), SC_(0.5846316826050804897939448468310039141968e-20), SC_(0.1053651155189350987221324125029421440321e-11), SC_(0.5548626568497557534203204440182821081119e-8), SC_(0.9999999944513734315024424657967955598172) }, 
      { SC_(33), SC_(13), SC_(0.632396042346954345703125), SC_(0.1095019592114454570806258575984482695513e-12), SC_(0.9441492018242223561915031653704216390797e-12), SC_(0.1039261980253620551511687081304413084482), SC_(0.8960738019746379448488312918695586915518) }, 
      { SC_(33), SC_(13), SC_(0.81474220752716064453125), SC_(0.9897979556898189827786285446513050208297e-12), SC_(0.6385320534584883049350047831756488780129e-13), SC_(0.9393981540502594338542955363598247827758), SC_(0.06060184594974056614570446364017521722425) }, 
      { SC_(33), SC_(13), SC_(0.8350250720977783203125), SC_(0.1025681995141237591043684828728005569406e-11), SC_(0.2796916589443022222844419424086433922542e-13), SC_(0.9734550039626602563327171663317533485973), SC_(0.0265449960373397436672828336682466514027) }, 
      { SC_(33), SC_(13), SC_(0.905801355838775634765625), SC_(0.1053457108000677852566819764971494066174e-11), SC_(0.1940530349899607053092579973758424573486e-15), SC_(0.9998158280063021809805341367005066353936), SC_(0.0001841719936978190194658632994933646063643) }, 
      { SC_(33), SC_(13), SC_(0.913384497165679931640625), SC_(0.1053568193371307532735215508976186894704e-11), SC_(0.8296766436028053691351399268301392671577e-16), SC_(0.999921256989572593518054213058740466703), SC_(0.7874301042740648194578694125953329700795e-4) }, 
      { SC_(33), SC_(13), SC_(0.9688708782196044921875), SC_(0.1053651160258337766650834272157123636077e-11), SC_(0.7773300466212947508117462725538212750308e-21), SC_(0.9999999992622510415522800731577940863977), SC_(0.7377489584477199268422059136023296862401e-9) }, 
      { SC_(33), SC_(17), SC_(0.12707412242889404296875), SC_(0.1003742234964539776436421900507254745055e-31), SC_(0.905078967454980940752414584025503094728e-14), SC_(0.1109010673164788123887843223948045815264e-17), SC_(0.9999999999999999988909893268352118761122) }, 
      { SC_(33), SC_(17), SC_(0.1355634629726409912109375), SC_(0.7294184766299883217656215126470183445666e-31), SC_(0.9050789674549809344619720526901596535082e-14), SC_(0.8059169452153576242085990928445120709536e-17), SC_(0.999999999999999991940830547846423757914) }, 
      { SC_(33), SC_(17), SC_(0.221111953258514404296875), SC_(0.150896907155069734948134052558505332002e-24), SC_(0.9050789674398912510406498454952294659086e-14), SC_(0.1667223663139375944760008661676239408997e-10), SC_(0.9999999999833277633686062405523999133832) }, 
      { SC_(33), SC_(17), SC_(0.3082362115383148193359375), SC_(0.1424383939646312780197621490082064316522e-20), SC_(0.905078825016586977124878799227893862958e-14), SC_(0.1573767583674583969060511764333573613404e-6), SC_(0.9999998426232416325416030939488235666426) }, 
      { SC_(33), SC_(17), SC_(0.632396042346954345703125), SC_(0.2996641162552694500614590937854863328791e-14), SC_(0.6054148511997114916946977252045565382853e-14), SC_(0.3310916804286194902730705959529071438085), SC_(0.6689083195713805097269294040470928561915) }, 
      { SC_(33), SC_(17), SC_(0.81474220752716064453125), SC_(0.9002264012583455756579664787599117992579e-14), SC_(0.4852566196635366098190340230131071906578e-16), SC_(0.9946385162277271291817885353177352199422), SC_(0.005361483772272870818211464682264780057833) }, 
      { SC_(33), SC_(17), SC_(0.8350250720977783203125), SC_(0.903701575968861101520578445409704751779e-14), SC_(0.1377391486119840235578373580338119385477e-16), SC_(0.9984781532488894651691209228490872581561), SC_(0.00152184675111053483087907715091274184389) }, 
      { SC_(33), SC_(17), SC_(0.905801355838775634765625), SC_(0.9050778699185167502525964555913744014043e-14), SC_(0.1097536464191503560363398668469760157931e-19), SC_(0.9999987873583370546111535660583336914955), SC_(0.1212641662945388846433941666308504451951e-5) }, 
      { SC_(33), SC_(17), SC_(0.913384497165679931640625), SC_(0.905078629866721392104730517937040198347e-14), SC_(0.3375882595496514263010530026728174114826e-20), SC_(0.9999996270068450502986338942978111420048), SC_(0.3729931549497013661057021888579951665526e-6) }, 
      { SC_(33), SC_(17), SC_(0.9688708782196044921875), SC_(0.9050789674549260748200686701672714694951e-14), SC_(0.5486693608814882277140166932116220213174e-27), SC_(0.999999999999939378840895584141099895075), SC_(0.6062115910441585890010492504526941051787e-13) }, 
      { SC_(33), SC_(21), SC_(0.12707412242889404296875), SC_(0.5936205823844925416735091300457011401217e-32), SC_(0.1497518175469779728159014001969684690599e-15), SC_(0.3964029232555193933548080800633621787115e-16), SC_(0.9999999999999999603597076744480606645192) }, 
      { SC_(33), SC_(21), SC_(0.1355634629726409912109375), SC_(0.4154805811235142921248055517863502074043e-31), SC_(0.1497518175469779372040491116904646733144e-15), SC_(0.2774461024442496139120290320294759676348e-15), SC_(0.999999999999999722553897555750386087971) }, 
      { SC_(33), SC_(21), SC_(0.221111953258514404296875), SC_(0.5771038169069744214395419818168825988592e-25), SC_(0.1497518174892675970614097818979396876133e-15), SC_(0.3853734975376400634670473876276300088668e-9), SC_(0.9999999996146265024623599365329526123724) }, 
      { SC_(33), SC_(21), SC_(0.3082362115383148193359375), SC_(0.3482858186626835926485418770134109237449e-21), SC_(0.1497514692611593160685145755000168723841e-15), SC_(0.2325753532530076922870773210052394450532e-5), SC_(0.9999976742464674699230771292267899476055) }, 
      { SC_(33), SC_(21), SC_(0.632396042346954345703125), SC_(0.9258457642654557173733143236819125823592e-16), SC_(0.5716724112043240701477579167370262755906e-16), SC_(0.6182534405467317599928954508441356999113), SC_(0.3817465594532682400071045491558643000887) }, 
      { SC_(33), SC_(21), SC_(0.81474220752716064453125), SC_(0.1497100039355602707156750627389681540943e-15), SC_(0.4181361141770803643216130292573170068691e-19), SC_(0.9997207806081913438294223176859746975912), SC_(0.000279219391808656170577682314025302408846) }, 
      { SC_(33), SC_(21), SC_(0.8350250720977783203125), SC_(0.1497442244995520260745325461198993018171e-15), SC_(0.759304742595267757467792199458397787002e-20), SC_(0.999949295791194182358883518640125900551), SC_(0.5070420880581764111648135987409944901045e-4) }, 
      { SC_(33), SC_(21), SC_(0.905801355838775634765625), SC_(0.1497518168739516375551025117495311703328e-15), SC_(0.6730263411970047122923627154622307154768e-24), SC_(0.9999999955057217186304092590787747234282), SC_(0.4494278281369590740921225276571839293236e-8) }, 
      { SC_(33), SC_(21), SC_(0.913384497165679931640625), SC_(0.1497518173984256048319816902321668511661e-15), SC_(0.1485523739201255338097270346289025841429e-24), SC_(0.9999999990080095430325990721279937837392), SC_(0.991990456967400927872006216260782170666e-9) }, 
      { SC_(33), SC_(21), SC_(0.9688708782196044921875), SC_(0.1497518175469779783395314158571992323438e-15), SC_(0.4125758081846946534512118986719180546631e-33), SC_(0.9999999999999999972449362221913111282498), SC_(0.2755063777808688871750187971240661469615e-17) }, 
      { SC_(33), SC_(25), SC_(0.12707412242889404296875), SC_(0.351183072704703197527191715327134390287e-32), SC_(0.4028411466176012290857537459358152650053e-17), SC_(0.8717656467154905683135686076765048057188e-15), SC_(0.9999999999999991282343532845094316864314) }, 
      { SC_(33), SC_(25), SC_(0.1355634629726409912109375), SC_(0.2367480690055051311375775109076619373264e-31), SC_(0.4028411466175992127881363955877014164219e-17), SC_(0.5876958473416299116127524099145230564142e-14), SC_(0.9999999999999941230415265837008838724759) }, 
      { SC_(33), SC_(25), SC_(0.221111953258514404296875), SC_(0.2210177452085690847172801760387412927072e-25), SC_(0.4028411444074241281831356034662110318096e-17), SC_(0.5486473938035207240073054399476371876635e-8), SC_(0.9999999945135260619647927599269456005236) }, 
      { SC_(33), SC_(25), SC_(0.3082362115383148193359375), SC_(0.8550211441428100929542412784891728150157e-22), SC_(0.4028325964061601521678969082262279004689e-17), SC_(0.212247718814692486122101639291330582779e-4), SC_(0.9999787752281185307513877898360708669417) }, 
      { SC_(33), SC_(25), SC_(0.632396042346954345703125), SC_(0.3364647663899230350231499653108362170888e-17), SC_(0.6637638022767854524567648532817657510826e-18), SC_(0.835229393062256957190086230610472862056), SC_(0.164770606937743042809913769389527137944) }, 
      { SC_(33), SC_(25), SC_(0.81474220752716064453125), SC_(0.4028372768605503683747832726164095492936e-17), SC_(0.3869757051211894043178022603242903418155e-22), SC_(0.9999903938386540109941610137915863542665), SC_(0.960616134598900583898620841364573354917e-5) }, 
      { SC_(33), SC_(25), SC_(0.8350250720977783203125), SC_(0.4028406998344879003975203241651000247313e-17), SC_(0.4467831136798713061264739127674657230807e-23), SC_(0.9999988909198639929853106818024166668952), SC_(0.1109080136007014689318197583333104817338e-5) }, 
      { SC_(33), SC_(25), SC_(0.905801355838775634765625), SC_(0.4028411466132654423074000643937738157356e-17), SC_(0.4336137961426386245238976461475994565956e-28), SC_(0.9999999999892361095736268446916035145649), SC_(0.1076389042637315530839648543506971480439e-10) }, 
      { SC_(33), SC_(25), SC_(0.913384497165679931640625), SC_(0.4028411466169156650341775451703644121176e-17), SC_(0.6859152346489054686483800794271224761599e-29), SC_(0.9999999999982973059221777734802914079281), SC_(0.1702694077822226519708592071853997480416e-11) }, 
      { SC_(33), SC_(25), SC_(0.9688708782196044921875), SC_(0.4028411466176015802687941497870889771796e-17), SC_(0.3230085192381501741050846980584183214858e-39), SC_(0.9999999999999999999999198173965221166489), SC_(0.8018260347788335105297067257344595321415e-22) }, 
      { SC_(33), SC_(29), SC_(0.12707412242889404296875), SC_(0.2078263170752095046936592893974534653461e-32), SC_(0.1580548711231143497868473865992989433974e-18), SC_(0.1314899791435872540292420541953171624129e-13), SC_(0.9999999999999868510020856412745970757946) }, 
      { SC_(33), SC_(29), SC_(0.1355634629726409912109375), SC_(0.1349551876910710640961807824643176579428e-31), SC_(0.1580548711231029325312490315879362619121e-18), SC_(0.8538502276589000156605246985131393441257e-13), SC_(0.9999999999999146149772341099984339475301) }, 
      { SC_(33), SC_(29), SC_(0.221111953258514404296875), SC_(0.8476958464957693533339818068936371367305e-26), SC_(0.1580548626461579630923246053545278110539e-18), SC_(0.5363300988271717947249064327248369310177e-7), SC_(0.9999999463669901172828205275093567275163) }, 
      { SC_(33), SC_(29), SC_(0.3082362115383148193359375), SC_(0.2108352084843069780256314847246544819443e-22), SC_(0.1580337876022679973522155755458734145421e-18), SC_(0.0001333936796671565056510944671183205929248), SC_(0.9998666063203328434943489055328816794071) }, 
      { SC_(33), SC_(29), SC_(0.632396042346954345703125), SC_(0.149376557586460818378855941366438639559e-18), SC_(0.8678313536655609671162197327907240431314e-20), SC_(0.945093033356145916800568644427919441693), SC_(0.05490696664385408319943135557208055830701) }, 
      { SC_(33), SC_(29), SC_(0.81474220752716064453125), SC_(0.1580548336422809376231603533408863784801e-18), SC_(0.3748083549042685778535345950151024338164e-25), SC_(0.9999997628618768653371074496755392378888), SC_(0.2371381231346628925503244607621111885968e-6) }, 
      { SC_(33), SC_(29), SC_(0.8350250720977783203125), SC_(0.15805486838118101724271030290169350217e-18), SC_(0.2741935410807307835792652377820319482332e-26), SC_(0.999999982652003121931721887002015125993), SC_(0.1734799687806827811299798487400700701591e-7) }, 
      { SC_(33), SC_(29), SC_(0.905801355838775634765625), SC_(0.1580548711231135400146449515787964146117e-18), SC_(0.2888035373187115549465378624044034393684e-32), SC_(0.9999999999999817276408334325364965779125), SC_(0.1827235916656746350342208751931515936114e-13) }, 
      { SC_(33), SC_(29), SC_(0.913384497165679931640625), SC_(0.1580548711231161008836019360345683558421e-18), SC_(0.3271664162026597775241482410772494846175e-33), SC_(0.9999999999999979300453451522265695071036), SC_(0.2069954654847773430492896441922849745735e-14) }, 
      { SC_(33), SC_(29), SC_(0.9688708782196044921875), SC_(0.1580548711231164280500181384342934382996e-18), SC_(0.2600524416907527398744901212482451719942e-45), SC_(0.9999999999999999999999999983546698697556), SC_(0.1645330130244360335315027139953365876762e-26) }, 
      { SC_(33), SC_(33), SC_(0.12707412242889404296875), SC_(0.1230309921542619492984190972043851742351e-32), SC_(0.8394855792252206344749750461342236541114e-20), SC_(0.1465552180989122854946334136502463681282e-12), SC_(0.9999999999998534447819010877145053665863) }, 
      { SC_(33), SC_(33), SC_(0.1355634629726409912109375), SC_(0.7696018471329899664856903268453869070807e-32), SC_(0.8394855792245740636199963181170363828818e-20), SC_(0.9167541005804523023603599853940277773624e-12), SC_(0.9999999999990832458994195476976396400146) }, 
      { SC_(33), SC_(33), SC_(0.221111953258514404296875), SC_(0.3256390660463019532037424359959955583219e-26), SC_(0.8394852535862776191651761043410860772131e-20), SC_(0.3879031088857935519120129396737462480874e-6), SC_(0.9999996120968911142064480879870603262538) }, 
      { SC_(33), SC_(33), SC_(0.3082362115383148193359375), SC_(0.5224637251287593472809054632169438294515e-23), SC_(0.8389631155002149061198484026203051293792e-20), SC_(0.0006223617630345429273325451831591647408451), SC_(0.9993776382369654570726674548168408352592) }, 
      { SC_(33), SC_(33), SC_(0.632396042346954345703125), SC_(0.8272720626296260560546773869546017800921e-20), SC_(0.1221351659571760941245192112892029311653e-21), SC_(0.9854511895165752131044881449673107884731), SC_(0.01454881048342478689551185503268921152685) }, 
      { SC_(33), SC_(33), SC_(0.81474220752716064453125), SC_(0.8394855754795861586952818206135308738965e-20), SC_(0.3745757506771847487469991199312156916278e-28), SC_(0.9999999955380323385324391147890154710619), SC_(0.4461967661467560885210984528938139857954e-8) }, 
      { SC_(33), SC_(33), SC_(0.8350250720977783203125), SC_(0.8394855790520700655717188808317857800164e-20), SC_(0.1732735998954104272517362931921977384658e-29), SC_(0.9999999997935955015983681584922040197162), SC_(0.2064044984016318415077959802838389751254e-9) }, 
      { SC_(33), SC_(33), SC_(0.905801355838775634765625), SC_(0.8394855792253436457677028943284593258906e-20), SC_(0.1969942641375506274731806724467650661651e-36), SC_(0.9999999999999999765339311344297282144898), SC_(0.2346606886557027178551018489010807278239e-16) }, 
      { SC_(33), SC_(33), SC_(0.913384497165679931640625), SC_(0.8394855792253436638697131907011038438284e-20), SC_(0.1597416117382418229380170622945272966504e-37), SC_(0.9999999999999999980971488291002283296028), SC_(0.1902851170899771670397207831281237524968e-17) }, 
      { SC_(33), SC_(33), SC_(0.9688708782196044921875), SC_(0.8394855792253436654671293080835007028272e-20), SC_(0.2137038139187587356074671893581920146435e-51), SC_(0.9999999999999999999999999999999745434801), SC_(0.2545651994593632923632668870479677183771e-31) }, 
      { SC_(33), SC_(37), SC_(0.12707412242889404296875), SC_(0.7285853212734233331854479582364611069602e-33), SC_(0.5720050994065464625310859364901099296336e-21), SC_(0.1273739206221064013662468916707422394935e-11), SC_(0.9999999999987262607937789359863375310833) }, 
      { SC_(33), SC_(37), SC_(0.1355634629726409912109375), SC_(0.4390583599737356613280946641936797134501e-32), SC_(0.5720050994028844642526220032100144309499e-21), SC_(0.7675777024168108260969960031043150523179e-11), SC_(0.999999999992324222975831891739030039969) }, 
      { SC_(33), SC_(37), SC_(0.221111953258514404296875), SC_(0.1253038455227315347473265432842145831742e-26), SC_(0.572003846368819820537011886557862535446e-21), SC_(0.2190607140610709345189453766707572664516e-5), SC_(0.9999978093928593892906548105462332924273) }, 
      { SC_(33), SC_(37), SC_(0.3082362115383148193359375), SC_(0.1301879224495875261739036395620542959801e-23), SC_(0.5707032201827791725906203234276748346321e-21), SC_(0.002275992339657308496638948213581201417837), SC_(0.9977240076603426915033610517864187985822) }, 
      { SC_(33), SC_(37), SC_(0.632396042346954345703125), SC_(0.5702000964850858299568144141006277422619e-21), SC_(0.1805002922189217895544945722667635329949e-23), SC_(0.996844428617752527395147275516427061647), SC_(0.003155571382247472604852724483572938352978) }, 
      { SC_(33), SC_(37), SC_(0.81474220752716064453125), SC_(0.5720050993689770882613878160809899087848e-21), SC_(0.3829795959097154374230546880708399774445e-31), SC_(0.9999999999330461220876233833858861179858), SC_(0.6695387791237661661411388201416955600054e-10) }, 
      { SC_(33), SC_(37), SC_(0.8350250720977783203125), SC_(0.5720050994061562819361855494417429786621e-21), SC_(0.1118765916173810381552398929761038052868e-32), SC_(0.9999999999980441329678125219956729935701), SC_(0.1955867032187478004327006429854365510474e-11) }, 
      { SC_(33), SC_(37), SC_(0.905801355838775634765625), SC_(0.5720050994072750478386793264226745098158e-21), SC_(0.1368003340062086777606654087033805046052e-40), SC_(0.9999999999999999999760840709028705588364), SC_(0.2391592909712944116359968696807138108169e-19) }, 
      { SC_(33), SC_(37), SC_(0.913384497165679931640625), SC_(0.5720050994072750478515655500584547697405e-21), SC_(0.793809764840607851315167617591115441285e-42), SC_(0.9999999999999999999986122330628465166784), SC_(0.1387766937153483321619936317086154731009e-20) }, 
      { SC_(33), SC_(37), SC_(0.9688708782196044921875), SC_(0.5720050994072750478523593598232953774135e-21), SC_(0.1783917603822084521665487856779564144674e-57), SC_(0.9999999999999999999999999999999999996881), SC_(0.3118709266177209472822493711394611582209e-36) }, 
      { SC_(37), SC_(1), SC_(0.12707412242889404296875), SC_(0.1913866694140651973620209084204258658603e-34), SC_(0.02702702702702702702702702702702700788836), SC_(0.7081306768320412302394773611555757036831e-33), SC_(0.9999999999999999999999999999999992918693) }, 
      { SC_(37), SC_(1), SC_(0.1355634629726409912109375), SC_(0.2094481302283473556544275430162133809304e-33), SC_(0.0270270270270270270270270270270268175789), SC_(0.7749580818448852159213819091599895094426e-32), SC_(0.9999999999999999999999999999999922504192) }, 
      { SC_(37), SC_(1), SC_(0.221111953258514404296875), SC_(0.1522125478019930782618535858363091426624e-25), SC_(0.02702702702702702702702701180577224682772), SC_(0.5631864268673743895688582675943438278508e-24), SC_(0.9999999999999999999999994368135731326256) }, 
      { SC_(37), SC_(1), SC_(0.3082362115383148193359375), SC_(0.3315077075190969124367733223906869011355e-20), SC_(0.02702702702702702702371194995183605790266), SC_(0.1226578517820658576016061292845541534202e-18), SC_(0.9999999999999999998773421482179341423984) }, 
      { SC_(37), SC_(1), SC_(0.632396042346954345703125), SC_(0.1170567819805101951715039582856917625312e-8), SC_(0.02702702585645920722192507531198744417011), SC_(0.4331100933278877221345646456570595213656e-7), SC_(0.999999956688990667211227786543535434294) }, 
      { SC_(37), SC_(1), SC_(0.81474220752716064453125), SC_(0.1378942783416201592372365937441298558625e-4), SC_(0.02701323759919286501110330336765261404144), SC_(0.0005102088298639945891777753968532804666911), SC_(0.9994897911701360054108222246031467195333) }, 
      { SC_(37), SC_(1), SC_(0.8350250720977783203125), SC_(0.3425155978936427978522724098975190106055e-4), SC_(0.02699277546723766274724179978603727512597), SC_(0.00126730771220647835205340791662082033924), SC_(0.9987326922877935216479465920833791796608) }, 
      { SC_(37), SC_(1), SC_(0.905801355838775634765625), SC_(0.0006950531778868697451647344862329718136642), SC_(0.02633197384914015728186229254079405521336), SC_(0.02571696758181418057109517599061995710558), SC_(0.9742830324181858194289048240093800428944) }, 
      { SC_(37), SC_(1), SC_(0.913384497165679931640625), SC_(0.000946199710034559212915476605876519313475), SC_(0.02608082731699246781411155042115050771355), SC_(0.03500938927127869087787263441743121459857), SC_(0.9649906107287213091221273655825687854014) }, 
      { SC_(37), SC_(1), SC_(0.9688708782196044921875), SC_(0.008387579736311963674588890850383234914083), SC_(0.01863944729071506335243813617664379211294), SC_(0.3103404502435426559597889614641796918211), SC_(0.6896595497564573440402110385358203081789) }, 
      { SC_(37), SC_(5), SC_(0.12707412242889404296875), SC_(0.1128494622544072532685008314333501227297e-34), SC_(0.2668808830554658539254174684100345662366e-6), SC_(0.4228458065726414339245399303724485763669e-28), SC_(0.9999999999999999999999999999577154193427) }, 
      { SC_(37), SC_(5), SC_(0.1355634629726409912109375), SC_(0.1189064328186999506994152559944967459886e-33), SC_(0.2668808830554658539254174683024130796433e-6), SC_(0.445541214707340528271201970058819362252e-27), SC_(0.9999999999999999999999999995544587852927) }, 
      { SC_(37), SC_(5), SC_(0.221111953258514404296875), SC_(0.5773208039862400764333589548507392971206e-26), SC_(0.2668808830554658539196442603814571116977e-6), SC_(0.2163215279328401703995031670236171638918e-19), SC_(0.99999999999999999997836784720671598296) }, 
      { SC_(37), SC_(5), SC_(0.3082362115383148193359375), SC_(0.7959995668115188181441448247625544203386e-21), SC_(0.2668808830554650579258506569025013683172e-6), SC_(0.2982602416847092896397929216937043787465e-14), SC_(0.9999999999999970173975831529071036020708) }, 
      { SC_(37), SC_(5), SC_(0.632396042346954345703125), SC_(0.2580450978256403600471477404235808210546e-10), SC_(0.2668550785456832898894127536472771543799e-6), SC_(0.9668924011016961726930621118897531006833e-4), SC_(0.9999033107598898303827306937888110246899) }, 
      { SC_(37), SC_(5), SC_(0.81474220752716064453125), SC_(0.2692477857350550576081457455416917192588e-7), SC_(0.2399561044819603481646028938671503405361e-6), SC_(0.1008868760671393950307146027087263455146), SC_(0.8991131239328606049692853972912736544854) }, 
      { SC_(37), SC_(5), SC_(0.8350250720977783203125), SC_(0.4564938189791655803981883801247834822343e-7), SC_(0.2212315011575492958855986304088411642386e-6), SC_(0.1710477774776743638096207878443762460097), SC_(0.8289522225223256361903792121556237539903) }, 
      { SC_(37), SC_(5), SC_(0.905801355838775634765625), SC_(0.1754142168238037723494271308027148430891e-6), SC_(0.9146666623166208157599033761860466937288e-7), SC_(0.6572753162966244969555799648464644899065), SC_(0.3427246837033755030444200351535355100935) }, 
      { SC_(37), SC_(5), SC_(0.913384497165679931640625), SC_(0.1921105748236999333987355111240336099689e-6), SC_(0.7477030823176592052668195729728590249306e-7), SC_(0.7198364027586554134457279728266426962175), SC_(0.2801635972413445865542720271733573037825) }, 
      { SC_(37), SC_(5), SC_(0.9688708782196044921875), SC_(0.2645803857305109882287126511078342644041e-6), SC_(0.2300497324954865696704817313485248057942e-8), SC_(0.9913800595283673677831040165745439103794), SC_(0.008619940471632632216895983425456089620629) }, 
      { SC_(37), SC_(9), SC_(0.12707412242889404296875), SC_(0.6655570763059608111783982205247468471267e-35), SC_(0.1253844881632444697793833470777247560675e-9), SC_(0.530812930734652006458893170240767910018e-25), SC_(0.9999999999999999999999999469187069265348) }, 
      { SC_(37), SC_(9), SC_(0.1355634629726409912109375), SC_(0.6752242961168721925524748101238166071667e-34), SC_(0.1253844881632444697793832862108659074399e-9), SC_(0.5385229911675862096919622567730659564947e-24), SC_(0.9999999999999999999999994614770088324138) }, 
      { SC_(37), SC_(9), SC_(0.221111953258514404296875), SC_(0.2191599317590748548537396230443711820992e-26), SC_(0.1253844881632444675877840361425469705897e-9), SC_(0.1747903069746070542691738837476463897494e-16), SC_(0.9999999999999999825209693025392945730826) }, 
      { SC_(37), SC_(9), SC_(0.3082362115383148193359375), SC_(0.1915464707747466537816391509579911984652e-21), SC_(0.1253844881630529233086086070795138799761e-9), SC_(0.1527672789359418361913072599065045603609e-11), SC_(0.9999999999984723272106405816380869274009) }, 
      { SC_(37), SC_(9), SC_(0.632396042346954345703125), SC_(0.589420006940180388195858404716216388799e-12), SC_(0.1247950681563042893911874953285793027383e-9), SC_(0.004700900530636488092422429901454789903929), SC_(0.9952990994693635119075775700985452100961) }, 
      { SC_(37), SC_(9), SC_(0.81474220752716064453125), SC_(0.6784655322319837314358834928370544304779e-10), SC_(0.5753793494004609663579500444959007607929e-10), SC_(0.5411080287289244256463985107565107784502), SC_(0.4588919712710755743536014892434892215498) }, 
      { SC_(37), SC_(9), SC_(0.8350250720977783203125), SC_(0.8528785121850841112319907288110237449494e-10), SC_(0.4009663694473605865618428085219314463215e-10), SC_(0.6802105465188628526232266548807004619454), SC_(0.3197894534811371473767733451192995380546) }, 
      { SC_(37), SC_(9), SC_(0.905801355838775634765625), SC_(0.1225339947591074704550052796786259622938e-9), SC_(0.2850493404136999324378074054669556833276e-11), SC_(0.9772659804582382123829461957340667771481), SC_(0.02273401954176178761705380426593322285193) }, 
      { SC_(37), SC_(9), SC_(0.913384497165679931640625), SC_(0.1236544243802604474152624525469236891668e-9), SC_(0.1730063782984022364120901186371829960308e-11), SC_(0.9862019312888882717821045961709356789802), SC_(0.01379806871111172821789540382906432101982) }, 
      { SC_(37), SC_(9), SC_(0.9688708782196044921875), SC_(0.1253833856208952171254910249612084192646e-9), SC_(0.1102542349252653892328772087099862452543e-14), SC_(0.9999912067085378440298773358458893558355), SC_(0.8793291462155970122664154110644164521126e-5) }, 
      { SC_(37), SC_(13), SC_(0.12707412242889404296875), SC_(0.392619492799588947053202892481973165335e-35), SC_(0.2929322888897563317260752904128108795278e-12), SC_(0.1340308008678925178326386744489204631352e-22), SC_(0.9999999999999999999999865969199132107482) }, 
      { SC_(37), SC_(13), SC_(0.1355634629726409912109375), SC_(0.3835376912246461216092659531438867642672e-34), SC_(0.2929322888897563317260408628386164108051e-12), SC_(0.1309304934182208573267445569554403651992e-21), SC_(0.9999999999999999999998690695065817791427) }, 
      { SC_(37), SC_(13), SC_(0.221111953258514404296875), SC_(0.8327278759078331664531773935175465779689e-27), SC_(0.2929322888897554989982033087745724222399e-12), SC_(0.2842731605532315785663601756871384082971e-14), SC_(0.9999999999999971572683944676842143363982) }, 
      { SC_(37), SC_(13), SC_(0.3082362115383148193359375), SC_(0.4620193905780370783509380349315130566184e-22), SC_(0.2929322888435543926682755087726450719241e-12), SC_(0.1577222478031146201206842811251156964816e-9), SC_(0.9999999998422777521968853798793157188749) }, 
      { SC_(37), SC_(13), SC_(0.632396042346954345703125), SC_(0.1412827378151559513658749812009330082937e-13), SC_(0.2788040151082407365894917184876455745879e-12), SC_(0.04823051031712213711159108475320266127814), SC_(0.9517694896828778628884089152467973387219) }, 
      { SC_(37), SC_(13), SC_(0.81474220752716064453125), SC_(0.2615401644966002836258119298950072260893e-12), SC_(0.3139212439315604810026728671273164932798e-13), SC_(0.8928348782848915497015692681664196170436), SC_(0.1071651217151084502984307318335803829564) }, 
      { SC_(37), SC_(13), SC_(0.8350250720977783203125), SC_(0.278077865881119056902705167492772086213e-12), SC_(0.1485442300863727482337404911496678920428e-13), SC_(0.9492905918124045861056506459116833562307), SC_(0.05070940818759541389434935408831664376934) }, 
      { SC_(37), SC_(13), SC_(0.905801355838775634765625), SC_(0.2927967024625285246345760853740034327444e-12), SC_(0.135586427227807091503131233735442672911e-15), SC_(0.9995371407237430408499204043139161724397), SC_(0.000462859276256959150079595686083827560296) }, 
      { SC_(37), SC_(13), SC_(0.913384497165679931640625), SC_(0.2928725911335584059006481745821517225259e-12), SC_(0.5969775619792582543104202558715289132277e-16), SC_(0.9997962062959184646560416547864780201418), SC_(0.0002037937040815353439583452135219798582082) }, 
      { SC_(37), SC_(13), SC_(0.9688708782196044921875), SC_(0.2929322881980351671724017900866478324219e-12), SC_(0.6917211645536774265210910429953338310985e-21), SC_(0.9999999976386312100473041943388297357636), SC_(0.2361368789952695805661170264236437763777e-8) }, 
      { SC_(37), SC_(17), SC_(0.12707412242889404296875), SC_(0.2316658393182091760507871041575739736439e-35), SC_(0.18206668343869427942996185391687909408e-14), SC_(0.1272423020745670836626242354286779605021e-20), SC_(0.9999999999999999999987275769792543291634) }, 
      { SC_(37), SC_(17), SC_(0.1355634629726409912109375), SC_(0.2179158878158653195962770298457312358696e-34), SC_(0.18206668343869427942801436087803865006e-14), SC_(0.1196901507184548835621060808173464166388e-19), SC_(0.9999999999999999999880309849281545116438) }, 
      { SC_(37), SC_(17), SC_(0.221111953258514404296875), SC_(0.3167127005513650091401039137958912403293e-27), SC_(0.1820666834386626081601383832552832928646e-14), SC_(0.173954231806506710169603514970096822109e-12), SC_(0.999999999999826045768193493289830396485) }, 
      { SC_(37), SC_(17), SC_(0.3082362115383148193359375), SC_(0.1117284707149662777483606761677198690162e-22), SC_(0.1820666823214095722805307422725905415788e-14), SC_(0.6136678529248193157890018329791505807387e-8), SC_(0.9999999938633214707518068421099816702085) }, 
      { SC_(37), SC_(17), SC_(0.632396042346954345703125), SC_(0.3619401922431647019021200796311128424104e-15), SC_(0.145872664214377809239981511793086019015e-14), SC_(0.1987954003484869622208456356810718141056), SC_(0.8012045996515130377791543643189281858944) }, 
      { SC_(37), SC_(17), SC_(0.81474220752716064453125), SC_(0.1797578448872147831632375323107784888429e-14), SC_(0.2308838551479496266955987445418814413123e-16), SC_(0.9873187202190293576601799836162460327801), SC_(0.01268127978097064233982001638375396721992) }, 
      { SC_(37), SC_(17), SC_(0.8350250720977783203125), SC_(0.181353597570150272786414579485530112889e-14), SC_(0.7130858685440066437789402706671903670613e-17), SC_(0.9960833807972114908865057080473884254761), SC_(0.003916619202788509113494291952611574523867) }, 
      { SC_(37), SC_(17), SC_(0.905801355838775634765625), SC_(0.182065923870732487905136274724260659795e-14), SC_(0.7595679617915250572450319366434610564898e-20), SC_(0.9999958280782214210667047072229244628135), SC_(0.4171921778578933295292777075537186512617e-5) }, 
      { SC_(37), SC_(17), SC_(0.913384497165679931640625), SC_(0.1820664425714415207369368902638114963868e-14), SC_(0.2408672527586932566294923858068692437318e-20), SC_(0.999998677038279549929967346525457876789), SC_(0.1322961720450070032653474542123210956566e-5) }, 
      { SC_(37), SC_(17), SC_(0.9688708782196044921875), SC_(0.1820666834386455663477988348135040902836e-14), SC_(0.4871308239468494269321297245371483386562e-27), SC_(0.9999999999997324437317435527817935843859), SC_(0.2675562682564472182064156141462812890408e-12) }, 
      { SC_(37), SC_(21), SC_(0.12707412242889404296875), SC_(0.1367283871473772887888995288893743573017e-35), SC_(0.2233141138858443542657853024003671885347e-16), SC_(0.6122693490715561833546216029687369139466e-19), SC_(0.9999999999999999999387730650928443816645) }, 
      { SC_(37), SC_(21), SC_(0.1355634629726409912109375), SC_(0.1238495205921040448141595760880756421893e-34), SC_(0.2233141138858443541556086205230008725994e-16), SC_(0.5545978193541968287671344509103650138834e-18), SC_(0.9999999999999999994454021806458031712329) }, 
      { SC_(37), SC_(21), SC_(0.221111953258514404296875), SC_(0.1205792304100742296901099459483486916224e-27), SC_(0.2233141138846385619753573988182038179541e-16), SC_(0.5399534687346853794138796143482768070262e-11), SC_(0.9999999999946004653126531462058612038565) }, 
      { SC_(37), SC_(21), SC_(0.3082362115383148193359375), SC_(0.2709504253526723921055069480191643748653e-23), SC_(0.2233140867908018190122189305644101154971e-16), SC_(0.1213315274336754105519794881058059145102e-6), SC_(0.9999998786684725663245894480205118941941) }, 
      { SC_(37), SC_(21), SC_(0.632396042346954345703125), SC_(0.1016715309898744400019197158899233635504e-16), SC_(0.1216425828959699142775384252251815538631e-16), SC_(0.4552848416999194913983301030365992664685), SC_(0.5447151583000805086016698969634007335315) }, 
      { SC_(37), SC_(21), SC_(0.81474220752716064453125), SC_(0.2231187795051185908671646958387512725844e-16), SC_(0.1953343807257634122934452763536448291547e-19), SC_(0.9991252931696667585671441040105075394297), SC_(0.0008747068303332414328558959894924605703486) }, 
      { SC_(37), SC_(21), SC_(0.8350250720977783203125), SC_(0.2232753700152236943025410245050934559895e-16), SC_(0.3874387062065997691711661001146142410678e-20), SC_(0.9998265050518013142476162991529082094046), SC_(0.0001734949481986857523837008470917905954161) }, 
      { SC_(37), SC_(21), SC_(0.905801355838775634765625), SC_(0.2233141092545812912080763536104581373885e-16), SC_(0.4631263063071381787504646780025124567342e-24), SC_(0.9999999792612164879160704961751111285463), SC_(0.2073878351208392950382488887145374200939e-7) }, 
      { SC_(37), SC_(21), SC_(0.913384497165679931640625), SC_(0.2233141128312866079608005762325434276835e-16), SC_(0.1054557746318657564882561489730079535716e-24), SC_(0.9999999952776932547230958242069873380801), SC_(0.4722306745276904175793012661919897993125e-8) }, 
      { SC_(37), SC_(21), SC_(0.9688708782196044921875), SC_(0.2233141138858443506216565535708804853736e-16), SC_(0.3657801587544224432040014109455408426581e-33), SC_(0.999999999999999983620374351197295238402), SC_(0.1637962564880270476159798955693057856045e-16) }, 
      { SC_(37), SC_(25), SC_(0.12707412242889404296875), SC_(0.8071700065818245626961924402523662309835e-36), SC_(0.454711706154196492198266792431139738199e-18), SC_(0.1775124756317811951436445419736660264706e-17), SC_(0.9999999999999999982248752436821880485636) }, 
      { SC_(37), SC_(25), SC_(0.1355634629726409912109375), SC_(0.7040901204626361508125947713906654422191e-35), SC_(0.4547117061541964859645355943866027927693e-18), SC_(0.1548431920562593519429142980041967750624e-16), SC_(0.9999999999999999845156807943740648057086) }, 
      { SC_(37), SC_(25), SC_(0.221111953258514404296875), SC_(0.4595686308880832927234566509286237213654e-28), SC_(0.4547117061082396299166284697406186358023e-18), SC_(0.1010681327681147879770979448698852571981e-9), SC_(0.9999999998989318672318852120229020551301) }, 
      { SC_(37), SC_(25), SC_(0.3082362115383148193359375), SC_(0.6591079834839574506016947096871578466335e-24), SC_(0.4547110470462130090479861973182546137374e-18), SC_(0.1449507401202573159070668978058785564683e-5), SC_(0.9999985504925987974268409293310219412144) }, 
      { SC_(37), SC_(25), SC_(0.632396042346954345703125), SC_(0.3237210645255087178872589725932935850287e-18), SC_(0.1309906416286877751181778264196707158665e-18), SC_(0.7119259525193139248744690384012773103738), SC_(0.2880740474806860751255309615987226896262) }, 
      { SC_(37), SC_(25), SC_(0.81474220752716064453125), SC_(0.4546938349892849959165146004631223823109e-18), SC_(0.1787116491149708892219854984191858434934e-22), SC_(0.9999606978121090270999489734178963983272), SC_(0.3930218789097290005102658210360167278716e-4) }, 
      { SC_(37), SC_(25), SC_(0.8350250720977783203125), SC_(0.4547094473165351008040658988913111228318e-18), SC_(0.2258837661392201370900121653178063368484e-23), SC_(0.9999950323740717020140356938715477558239), SC_(0.4967625928297985964306128452244176057518e-5) }, 
      { SC_(37), SC_(25), SC_(0.905801355838775634765625), SC_(0.4547117061244709905492548288621730202575e-18), SC_(0.2972550245618197015079128063767961580802e-28), SC_(0.9999999999346278047081950274296909639257), SC_(0.653721952918049725703090360742526644479e-10) }, 
      { SC_(37), SC_(25), SC_(0.913384497165679931640625), SC_(0.4547117061493436113293187609028179203e-18), SC_(0.485288167611803811014638059520816300323e-29), SC_(0.9999999999893275637938549444879816573376), SC_(0.1067243620614505551201834266244538095768e-10) }, 
      { SC_(37), SC_(25), SC_(0.9688708782196044921875), SC_(0.4547117061541964930051507055370937092949e-18), SC_(0.2860934758705916002847465492653977221396e-39), SC_(0.9999999999999999999993708244762593049649), SC_(0.6291755237406950351066449839824147319877e-21) }, 
      { SC_(37), SC_(29), SC_(0.12707412242889404296875), SC_(0.4766330808725786443659155604415316685681e-36), SC_(0.1375136208127610314248295135563600183051e-19), SC_(0.3466079054972770261780389909617086325127e-16), SC_(0.9999999999999999653392094502722973821961) }, 
      { SC_(37), SC_(29), SC_(0.1355634629726409912109375), SC_(0.4004006054486037593711343143831791648418e-35), SC_(0.1375136208127609961510997774217705248508e-19), SC_(0.2911715967349812132453165500933749097082e-15), SC_(0.9999999999999997088284032650187867546834) }, 
      { SC_(37), SC_(29), SC_(0.221111953258514404296875), SC_(0.1753587499707554747005620785876106633731e-28), SC_(0.1375136206374022862204048475815843833767e-19), SC_(0.1275210040534998938970298246567218844378e-8), SC_(0.9999999987247899594650010610297017534328) }, 
      { SC_(37), SC_(29), SC_(0.3082362115383148193359375), SC_(0.1608786173729871882808705880355057485693e-24), SC_(0.1375120120265873063192775135762661069068e-19), SC_(0.1169910416307341673298134563086833102055e-4), SC_(0.999988300895836926583267018654369131669) }, 
      { SC_(37), SC_(29), SC_(0.632396042346954345703125), SC_(0.1211817029840737712700634042710214063881e-19), SC_(0.1633191782868726492109691801112505557621e-20), SC_(0.8812341807876264574086829999902870889094), SC_(0.1187658192123735425913170000097129110906) }, 
      { SC_(37), SC_(29), SC_(0.81474220752716064453125), SC_(0.1375134490666369054158046750705216931691e-19), SC_(0.1717461241307753556472116247687952022222e-25), SC_(0.9999987510609995163650009753189533339105), SC_(0.1248939000483634999024681046666089532256e-5) }, 
      { SC_(37), SC_(29), SC_(0.8350250720977783203125), SC_(0.1375136070374709087705383773559060076924e-19), SC_(0.137752901274206219449262404542718836151e-26), SC_(0.9999998998259950832281638040481079049166), SC_(0.1001740049167718361959518920950833547538e-6) }, 
      { SC_(37), SC_(29), SC_(0.905801355838775634765625), SC_(0.1375136208127412908262196047290587793477e-19), SC_(0.1974536494071755308768261658782637976138e-32), SC_(0.9999999999998564115698211241054490648372), SC_(0.1435884301788758945509351628456887462036e-12) }, 
      { SC_(37), SC_(29), SC_(0.913384497165679931640625), SC_(0.1375136208127587270061499750741568866244e-19), SC_(0.2309185010347207989575339864017076569671e-33), SC_(0.9999999999999832075906612087444484899632), SC_(0.1679240933879125555151003684677899740315e-13) }, 
      { SC_(37), SC_(29), SC_(0.9688708782196044921875), SC_(0.1375136208127610361911603199804487667413e-19), SC_(0.2301697695222936221483666697794390147364e-45), SC_(0.9999999999999999999999999832620384684879), SC_(0.1673796153151210231687675483695080784991e-25) }, 
      { SC_(37), SC_(33), SC_(0.12707412242889404296875), SC_(0.2815266604188693653913302322995077909319e-36), SC_(0.5720050994072747663256989409539299862616e-21), SC_(0.4921750884923820105209519233224389835091e-15), SC_(0.9999999999999995078249115076179894790481) }, 
      { SC_(37), SC_(33), SC_(0.1355634629726409912109375), SC_(0.2277707779163919100908933095549890064306e-35), SC_(0.5720050994072727701445801959041944686588e-21), SC_(0.3981971107467630507203470725973361693706e-14), SC_(0.9999999999999960180288925323694927965293) }, 
      { SC_(37), SC_(33), SC_(0.221111953258514404296875), SC_(0.6699377276839075532455324311258095644127e-29), SC_(0.5720050927078977710132838273679710663338e-21), SC_(0.1171209362255882974546065024517529113122e-7), SC_(0.9999999882879063774411702545393497548247) }, 
      { SC_(37), SC_(33), SC_(0.3082362115383148193359375), SC_(0.3941556123526471052080162297773181229352e-25), SC_(0.5719656838460397831418385582003176457796e-21), SC_(0.6890770952235920510157252810387715473455e-4), SC_(0.9999310922904776407948984274718961228453) }, 
      { SC_(37), SC_(33), SC_(0.632396042346954345703125), SC_(0.5497340418871139522096404153992420609406e-21), SC_(0.2227105752016109564271894442405331665125e-22), SC_(0.9610649318629521274528570243755901534052), SC_(0.03893506813704787254714297562440984659483) }, 
      { SC_(37), SC_(33), SC_(0.81474220752716064453125), SC_(0.5720050823395897515434476704627684761846e-21), SC_(0.1706768529630891168936052690140727778083e-28), SC_(0.9999999701616553523826219507757071998362), SC_(0.2983834464761737804922429280016380616641e-7) }, 
      { SC_(37), SC_(33), SC_(0.8350250720977783203125), SC_(0.5720050985407469884566837838946864514369e-21), SC_(0.8665280593956755759286089261549931701012e-30), SC_(0.9999999984851043106196220087456203622238), SC_(0.1514895689380377991254379637776220948978e-8) }, 
      { SC_(37), SC_(33), SC_(0.905801355838775634765625), SC_(0.572005099407274913436774974821917171636e-21), SC_(0.1344155843850013782059558794526739210542e-36), SC_(0.9999999999999997650098145553493760303857), SC_(0.2349901854446506239696142929776751238858e-15) }, 
      { SC_(37), SC_(33), SC_(0.913384497165679931640625), SC_(0.5720050994072750365977061126186163585042e-21), SC_(0.1125465324720467901908766696294229578058e-37), SC_(0.999999999999999980324208195229357614054), SC_(0.1967579180477064238594600964257347683977e-16) }, 
      { SC_(37), SC_(33), SC_(0.9688708782196044921875), SC_(0.5720050994072750478523593598231063318166e-21), SC_(0.1890457752154400724263869930444876559631e-51), SC_(0.9999999999999999999999999999996695033394), SC_(0.3304966606265113541490993068263355840044e-30) }, 
      { SC_(37), SC_(37), SC_(0.12707412242889404296875), SC_(0.1663315126472082518689392220455877254431e-36), SC_(0.3095647894727759768982379894849795807496e-22), SC_(0.5373075953841159720995259363454571859457e-14), SC_(0.9999999999999946269240461588402790047406) }, 
      { SC_(37), SC_(37), SC_(0.1355634629726409912109375), SC_(0.1296111998868566405720542382682176670195e-35), SC_(0.309564789472764679093375775903441064718e-22), SC_(0.4186884435649110798542051137448125301801e-13), SC_(0.9999999999999581311556435088920145794886) }, 
      { SC_(37), SC_(37), SC_(0.221111953258514404296875), SC_(0.2562741045594853507301922042614016365325e-29), SC_(0.3095647638453671842648293885482778440017e-22), SC_(0.8278528866152636518115304178551121854591e-7), SC_(0.9999999172147113384736348188469582144888) }, 
      { SC_(37), SC_(37), SC_(0.3082362115383148193359375), SC_(0.9697027380656677021427830653945592127811e-26), SC_(0.3094678191989710734431501832609588142206e-22), SC_(0.0003132471040124351596576730870327977659869), SC_(0.999686752895987564840342326912967202234) }, 
      { SC_(37), SC_(37), SC_(0.632396042346954345703125), SC_(0.3063451207632721012988627372821913143173e-22), SC_(0.3219668709505538914501724285306955824562e-24), SC_(0.9895993704097000715411905826153733915169), SC_(0.01040062959029992845880941738462660848308) }, 
      { SC_(37), SC_(37), SC_(0.81474220752716064453125), SC_(0.3095647892990086195192122018743245560235e-22), SC_(0.1737690206941522596931737141183088624137e-31), SC_(0.9999999994386667133878509901348317251675), SC_(0.5613332866121490098651682748324536630957e-9) }, 
      { SC_(37), SC_(37), SC_(0.8350250720977783203125), SC_(0.3095647894672021976547480411236536892802e-22), SC_(0.557544255861642044384458086164795234761e-33), SC_(0.9999999999819894162765991478047915369078), SC_(0.180105837234008521952084630921920026118e-10) }, 
      { SC_(37), SC_(37), SC_(0.905801355838775634765625), SC_(0.3095647894727776401201650427507053565973e-22), SC_(0.9319941881679291354451743800364440933825e-41), SC_(0.9999999999999999996989340455175098675848), SC_(0.3010659544824901324152261922870847584496e-18) }, 
      { SC_(37), SC_(37), SC_(0.913384497165679931640625), SC_(0.3095647894727776402077793811087210433219e-22), SC_(0.5585080458777226819971826512604809980239e-42), SC_(0.9999999999999999999819582825673125691735), SC_(0.1804171743268743082647407545766726774271e-19) }, 
      { SC_(37), SC_(37), SC_(0.9688708782196044921875), SC_(0.3095647894727776402133644615674982685644e-22), SC_(0.1577418664709856221006413731479117116045e-57), SC_(0.9999999999999999999999999999999999949044), SC_(0.5095601044926236696504373430890795334844e-35) }
   } };
#undef SC_

