/* Generated by re2c 0.13.2 on Thu Oct 09 21:18:08 2008 */
#line 1 "idl.re"
/*=============================================================================
    Boost.Wave: A Standard compliant C++ preprocessor library

    Sample: IDL lexer 

    http://www.boost.org/

    Copyright (c) 2001-2009 Hartmut Kaiser. Distributed under the Boost
    Software License, Version 1.0. (See accompanying file
    LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
=============================================================================*/

#include <ctime>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <boost/config.hpp>

#if defined(BOOST_HAS_UNISTD_H)
#include <unistd.h>
#else
#include <io.h>
#endif 

#include <boost/assert.hpp>
#include <boost/detail/workaround.hpp>

// reuse the token ids and re2c helper functions from the default C++ lexer
#include <boost/wave/token_ids.hpp>
#include <boost/wave/cpplexer/re2clex/aq.hpp>
#include <boost/wave/cpplexer/re2clex/scanner.hpp>
#include <boost/wave/cpplexer/cpplexer_exceptions.hpp>

#include "idl_re.hpp"

#if defined(_MSC_VER) && !defined(__COMO__)
#pragma warning (disable: 4101)     // 'foo' : unreferenced local variable
#pragma warning (disable: 4102)     // 'foo' : unreferenced label
#endif

#define BOOST_WAVE_BSIZE     196608

#define YYCTYPE   uchar
#define YYCURSOR  cursor
#define YYLIMIT   s->lim
#define YYMARKER  s->ptr
#define YYFILL(n) {cursor = fill(s, cursor);}

//#define BOOST_WAVE_RET(i)    {s->cur = cursor; return (i);}
#define BOOST_WAVE_RET(i)    \
    { \
        s->line += count_backslash_newlines(s, cursor); \
        s->cur = cursor; \
        return (i); \
    } \
    /**/

///////////////////////////////////////////////////////////////////////////////
namespace boost {
namespace wave {
namespace idllexer {
namespace re2clex {

#define RE2C_ASSERT BOOST_ASSERT

int 
get_one_char(boost::wave::cpplexer::re2clex::Scanner *s)
{
    using namespace boost::wave::cpplexer::re2clex;
    if (0 != s->act) {
        RE2C_ASSERT(s->first != 0 && s->last != 0);
        RE2C_ASSERT(s->first <= s->act && s->act <= s->last);
        if (s->act < s->last) 
            return *(s->act)++;
    }
    return -1;
}

std::ptrdiff_t 
rewind_stream (boost::wave::cpplexer::re2clex::Scanner *s, int cnt)
{
    if (0 != s->act) {
        RE2C_ASSERT(s->first != 0 && s->last != 0);
        s->act += cnt;
        RE2C_ASSERT(s->first <= s->act && s->act <= s->last);
        return s->act - s->first;
    }
    return 0;
}

std::size_t 
get_first_eol_offset(boost::wave::cpplexer::re2clex::Scanner* s)
{
    if (!AQ_EMPTY(s->eol_offsets))
    {
        return s->eol_offsets->queue[s->eol_offsets->head];
    }
    else
    {
        return (unsigned int)-1;
    }
}

void 
adjust_eol_offsets(boost::wave::cpplexer::re2clex::Scanner* s, 
    std::size_t adjustment)
{
    boost::wave::cpplexer::re2clex::aq_queue q;
    std::size_t i;
    
    if (!s->eol_offsets)
        s->eol_offsets = boost::wave::cpplexer::re2clex::aq_create();

    q = s->eol_offsets;

    if (AQ_EMPTY(q))
        return;

    i = q->head;
    while (i != q->tail)
    {
        if (adjustment > q->queue[i])
            q->queue[i] = 0;
        else
            q->queue[i] -= adjustment;
        ++i;
        if (i == q->max_size)
            i = 0;
    }
    if (adjustment > q->queue[i])
        q->queue[i] = 0;
    else
        q->queue[i] -= adjustment;
}

int 
count_backslash_newlines(boost::wave::cpplexer::re2clex::Scanner *s, 
    boost::wave::cpplexer::re2clex::uchar *cursor)
{
    using namespace boost::wave::cpplexer::re2clex;

    std::size_t diff, offset;
    int skipped = 0;
    
    /* figure out how many backslash-newlines skipped over unknowingly. */
    diff = cursor - s->bot;
    offset = get_first_eol_offset(s);
    while (offset <= diff && offset != (unsigned int)-1)
    {
        skipped++;
        boost::wave::cpplexer::re2clex::aq_pop(s->eol_offsets);
        offset = get_first_eol_offset(s);
    }
    return skipped;
}

bool is_backslash(
  boost::wave::cpplexer::re2clex::uchar *p, 
  boost::wave::cpplexer::re2clex::uchar *end, int &len)
{
    if (*p == '\\') {
        len = 1;
        return true;
    }
    else if (*p == '?' && *(p+1) == '?' && (p+2 < end && *(p+2) == '/')) {
        len = 3;
        return true;
    }
    return false;
}

boost::wave::cpplexer::re2clex::uchar *
fill(boost::wave::cpplexer::re2clex::Scanner *s, 
    boost::wave::cpplexer::re2clex::uchar *cursor)
{
    using namespace std;    // some systems have memcpy etc. in namespace std
    using namespace boost::wave::cpplexer::re2clex;

    if(!s->eof)
    {
        uchar* p;
        std::ptrdiff_t cnt = s->tok - s->bot;
        if(cnt)
        {
            memcpy(s->bot, s->tok, s->lim - s->tok);
            s->tok = s->bot;
            s->ptr -= cnt;
            cursor -= cnt;
            s->lim -= cnt;
            adjust_eol_offsets(s, cnt);
        }

        if((s->top - s->lim) < BOOST_WAVE_BSIZE)
        {
            uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BOOST_WAVE_BSIZE)*sizeof(uchar));
            if (buf == 0)
            {
                using namespace std;      // some systems have printf in std
                if (0 != s->error_proc) {
                    (*s->error_proc)(s, 
                        cpplexer::lexing_exception::unexpected_error,
                        "Out of memory!");
                }
                else 
                    printf("Out of memory!\n");
                    
                /* get the scanner to stop */
                *cursor = 0;
                return cursor;
            }

            memcpy(buf, s->tok, s->lim - s->tok);
            s->tok = buf;
            s->ptr = &buf[s->ptr - s->bot];
            cursor = &buf[cursor - s->bot];
            s->lim = &buf[s->lim - s->bot];
            s->top = &s->lim[BOOST_WAVE_BSIZE];
            free(s->bot);
            s->bot = buf;
        }

        if (s->act != 0) {
            cnt = s->last - s->act;
            if (cnt > BOOST_WAVE_BSIZE)
                cnt = BOOST_WAVE_BSIZE;
            memcpy(s->lim, s->act, cnt);
            s->act += cnt;
            if (cnt != BOOST_WAVE_BSIZE) 
            {
                s->eof = &s->lim[cnt]; *(s->eof)++ = '\0';
            }
        }
        
        /* backslash-newline erasing time */

        /* first scan for backslash-newline and erase them */
        for (p = s->lim; p < s->lim + cnt - 2; ++p)
        {
            int len = 0;
            if (is_backslash(p, s->lim + cnt, len))
            {
                if (*(p+len) == '\n')
                {
                    int offset = len + 1;
                    memmove(p, p + offset, s->lim + cnt - p - offset);
                    cnt -= offset;
                    --p;
                    aq_enqueue(s->eol_offsets, p - s->bot + 1);    
                }
                else if (*(p+len) == '\r')
                {
                    if (*(p+len+1) == '\n')
                    {
                        int offset = len + 2;
                        memmove(p, p + offset, s->lim + cnt - p - offset);
                        cnt -= offset;
                        --p;
                    }
                    else
                    {
                        int offset = len + 1;
                        memmove(p, p + offset, s->lim + cnt - p - offset);
                        cnt -= offset;
                        --p;
                    }
                    aq_enqueue(s->eol_offsets, p - s->bot + 1);    
                }
            }
        }

        /* FIXME: the following code should be fixed to recognize correctly the 
                  trigraph backslash token */

        /* check to see if what we just read ends in a backslash */
        if (cnt >= 2)
        {
            uchar last = s->lim[cnt-1];
            uchar last2 = s->lim[cnt-2];
            /* check \ EOB */
            if (last == '\\')
            {
                int next = get_one_char(s);
                /* check for \ \n or \ \r or \ \r \n straddling the border */
                if (next == '\n')
                {
                    --cnt; /* chop the final \, we've already read the \n. */
                    boost::wave::cpplexer::re2clex::aq_enqueue(s->eol_offsets, 
                        cnt + (s->lim - s->bot));    
                }
                else if (next == '\r')
                {
                    int next2 = get_one_char(s);
                    if (next2 == '\n')
                    {
                        --cnt; /* skip the backslash */
                    }
                    else
                    {
                        /* rewind one, and skip one char */
                        rewind_stream(s, -1);
                        --cnt;
                    }
                    boost::wave::cpplexer::re2clex::aq_enqueue(s->eol_offsets, 
                        cnt + (s->lim - s->bot));    
                }
                else if (next != -1) /* -1 means end of file */
                {
                    /* next was something else, so rewind the stream */
                    rewind_stream(s, -1);
                }
            }
            /* check \ \r EOB */
            else if (last == '\r' && last2 == '\\')
            {
                int next = get_one_char(s);
                if (next == '\n')
                {
                    cnt -= 2; /* skip the \ \r */
                }
                else
                {
                    /* rewind one, and skip two chars */
                    rewind_stream(s, -1);
                    cnt -= 2;
                }
                boost::wave::cpplexer::re2clex::aq_enqueue(s->eol_offsets, 
                    cnt + (s->lim - s->bot));    
            }
            /* check \ \n EOB */
            else if (last == '\n' && last2 == '\\')
            {
                cnt -= 2;
                boost::wave::cpplexer::re2clex::aq_enqueue(s->eol_offsets, 
                    cnt + (s->lim - s->bot));    
            }
        }
        
        s->lim += cnt;
        if (s->eof) /* eof needs adjusting if we erased backslash-newlines */
        {
            s->eof = s->lim;
            *(s->eof)++ = '\0';
        }
    }
    return cursor;
}

boost::wave::token_id  
scan(boost::wave::cpplexer::re2clex::Scanner *s)
{
    using namespace boost::wave::cpplexer::re2clex;

    uchar *cursor = s->tok = s->cur;

#line 378 "idl.re"



#line 366 "idl_re.cpp"
{
    YYCTYPE yych;
    unsigned int yyaccept = 0;
    static const unsigned char yybm[] = {
        /* table 1 .. 8: 0 */
          0,   0,   0,   0,   0,   0,   0,   0, 
          0,  60,  32,  56,  56,  64,   0,   0, 
          0,   0,   0,   0,   0,   0,   0,   0, 
          0,   0,   0,   0,   0,   0,   0,   0, 
         60,  56,  40,  56,  56,  56,  56,  56, 
         56,  56, 152,  56,  56,  56,  56,  56, 
         59,  59,  59,  59,  59,  59,  59,  59, 
         58,  58,  56,  56,  56,  56,  48,  56, 
         56,  58,  58,  58,  58,  58,  58,  58, 
         58,  58,  58,  58,  58,  58,  58,  58, 
         58,  58,  58,  58,  58,  58,  58,  58, 
         58,  58,  58,  56,  56,  56,  56,  58, 
         56,  58,  58,  58,  58,  58,  58,  58, 
         58,  58,  58,  58,  58,  58,  58,  58, 
         58,  58,  58,  58,  58,  58,  58,  58, 
         58,  58,  58,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
         56,  56,  56,  56,  56,  56,  56,  56, 
        /* table 9 .. 15: 256 */
          0,   0,   0,   0,   0,   0,   0,   0, 
          0,  70,   0,  70,  70,   0,   0,   0, 
          0,   0,   0,   0,   0,   0,   0,   0, 
          0,   0,   0,   0,   0,   0,   0,   0, 
         70,  68,  64,  68,  68,  68,  68,   4, 
         68,  68,  68,  68,  68,  68,  68,  68, 
        204, 204, 204, 204, 204, 204, 204, 204, 
        204, 204,  68,  68,  68,  68,  68,  16, 
         68,  76,  76,  76,  76,  76,  76,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  32,  68,  68,  68, 
         68,  76,  76,  76,  76,  76,  76,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
         68,  68,  68,  68,  68,  68,  68,  68, 
    };

    if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
    yych = *YYCURSOR;
    switch (yych) {
    case 0x00:    goto yy69;
    case 0x09:
    case 0x0B:
    case 0x0C:
    case ' ':    goto yy64;
    case 0x0A:    goto yy66;
    case 0x0D:    goto yy68;
    case '!':    goto yy45;
    case '"':    goto yy63;
    case '#':    goto yy15;
    case '%':    goto yy35;
    case '&':    goto yy39;
    case '\'':    goto yy62;
    case '(':    goto yy17;
    case ')':    goto yy19;
    case '*':    goto yy33;
    case '+':    goto yy29;
    case ',':    goto yy53;
    case '-':    goto yy31;
    case '.':    goto yy27;
    case '/':    goto yy2;
    case '0':    goto yy59;
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':    goto yy61;
    case ':':    goto yy23;
    case ';':    goto yy21;
    case '<':    goto yy49;
    case '=':    goto yy47;
    case '>':    goto yy51;
    case '?':    goto yy25;
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'G':
    case 'H':
    case 'I':
    case 'J':
    case 'K':
    case 'M':
    case 'N':
    case 'O':
    case 'P':
    case 'Q':
    case 'R':
    case 'S':
    case 'U':
    case 'V':
    case 'W':
    case 'X':
    case 'Y':
    case 'Z':
    case '_':
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'g':
    case 'h':
    case 'i':
    case 'j':
    case 'k':
    case 'l':
    case 'm':
    case 'n':
    case 'o':
    case 'p':
    case 'q':
    case 'r':
    case 's':
    case 't':
    case 'u':
    case 'v':
    case 'w':
    case 'x':
    case 'y':
    case 'z':    goto yy55;
    case 'F':    goto yy6;
    case 'L':    goto yy56;
    case 'T':    goto yy4;
    case '[':    goto yy11;
    case '\\':    goto yy57;
    case ']':    goto yy13;
    case '^':    goto yy37;
    case '{':    goto yy7;
    case '|':    goto yy41;
    case '}':    goto yy9;
    case '~':    goto yy43;
    default:    goto yy71;
    }
yy2:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) == '*') goto yy356;
    if (yych == '/') goto yy354;
#line 402 "idl.re"
    { BOOST_WAVE_RET(T_DIVIDE); }
#line 548 "idl_re.cpp"
yy4:
    yyaccept = 0;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych == 'R') goto yy350;
    goto yy202;
yy5:
#line 425 "idl.re"
    { BOOST_WAVE_RET(T_IDENTIFIER); }
#line 557 "idl_re.cpp"
yy6:
    yyaccept = 0;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych == 'A') goto yy345;
    goto yy202;
yy7:
    ++YYCURSOR;
#line 387 "idl.re"
    { BOOST_WAVE_RET(T_LEFTBRACE); }
#line 567 "idl_re.cpp"
yy9:
    ++YYCURSOR;
#line 388 "idl.re"
    { BOOST_WAVE_RET(T_RIGHTBRACE); }
#line 572 "idl_re.cpp"
yy11:
    ++YYCURSOR;
#line 389 "idl.re"
    { BOOST_WAVE_RET(T_LEFTBRACKET); }
#line 577 "idl_re.cpp"
yy13:
    ++YYCURSOR;
#line 390 "idl.re"
    { BOOST_WAVE_RET(T_RIGHTBRACKET); }
#line 582 "idl_re.cpp"
yy15:
    yyaccept = 1;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych <= 'e') {
        if (yych <= '"') {
            if (yych <= 0x09) {
                if (yych >= 0x09) goto yy239;
            } else {
                if (yych == ' ') goto yy239;
            }
        } else {
            if (yych <= '.') {
                if (yych <= '#') goto yy343;
            } else {
                if (yych <= '/') goto yy239;
                if (yych >= 'd') goto yy239;
            }
        }
    } else {
        if (yych <= 'o') {
            if (yych <= 'i') {
                if (yych >= 'i') goto yy239;
            } else {
                if (yych == 'l') goto yy239;
            }
        } else {
            if (yych <= 'u') {
                if (yych <= 'p') goto yy239;
                if (yych >= 'u') goto yy239;
            } else {
                if (yych == 'w') goto yy239;
            }
        }
    }
yy16:
#line 391 "idl.re"
    { BOOST_WAVE_RET(T_POUND); }
#line 620 "idl_re.cpp"
yy17:
    ++YYCURSOR;
#line 393 "idl.re"
    { BOOST_WAVE_RET(T_LEFTPAREN); }
#line 625 "idl_re.cpp"
yy19:
    ++YYCURSOR;
#line 394 "idl.re"
    { BOOST_WAVE_RET(T_RIGHTPAREN); }
#line 630 "idl_re.cpp"
yy21:
    ++YYCURSOR;
#line 395 "idl.re"
    { BOOST_WAVE_RET(T_SEMICOLON); }
#line 635 "idl_re.cpp"
yy23:
    ++YYCURSOR;
#line 396 "idl.re"
    { BOOST_WAVE_RET(T_COLON); }
#line 640 "idl_re.cpp"
yy25:
    yyaccept = 2;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych == '?') goto yy341;
yy26:
#line 397 "idl.re"
    { BOOST_WAVE_RET(T_QUESTION_MARK); }
#line 648 "idl_re.cpp"
yy27:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) <= '/') goto yy28;
    if (yych <= '9') goto yy168;
yy28:
#line 398 "idl.re"
    { BOOST_WAVE_RET(T_DOT); }
#line 656 "idl_re.cpp"
yy29:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) == '+') goto yy339;
#line 399 "idl.re"
    { BOOST_WAVE_RET(T_PLUS); }
#line 662 "idl_re.cpp"
yy31:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) == '-') goto yy337;
#line 400 "idl.re"
    { BOOST_WAVE_RET(T_MINUS); }
#line 668 "idl_re.cpp"
yy33:
    ++YYCURSOR;
#line 401 "idl.re"
    { BOOST_WAVE_RET(T_STAR); }
#line 673 "idl_re.cpp"
yy35:
    yyaccept = 3;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych == ':') goto yy238;
yy36:
#line 403 "idl.re"
    { BOOST_WAVE_RET(T_PERCENT); }
#line 681 "idl_re.cpp"
yy37:
    ++YYCURSOR;
#line 404 "idl.re"
    { BOOST_WAVE_RET(T_XOR); }
#line 686 "idl_re.cpp"
yy39:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) == '&') goto yy236;
#line 405 "idl.re"
    { BOOST_WAVE_RET(T_AND); }
#line 692 "idl_re.cpp"
yy41:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) == '|') goto yy234;
#line 406 "idl.re"
    { BOOST_WAVE_RET(T_OR); }
#line 698 "idl_re.cpp"
yy43:
    ++YYCURSOR;
#line 407 "idl.re"
    { BOOST_WAVE_RET(T_COMPL); }
#line 703 "idl_re.cpp"
yy45:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) == '=') goto yy232;
#line 408 "idl.re"
    { BOOST_WAVE_RET(T_NOT); }
#line 709 "idl_re.cpp"
yy47:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) == '=') goto yy230;
#line 409 "idl.re"
    { BOOST_WAVE_RET(T_ASSIGN); }
#line 715 "idl_re.cpp"
yy49:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) <= ';') goto yy50;
    if (yych <= '<') goto yy228;
    if (yych <= '=') goto yy226;
yy50:
#line 410 "idl.re"
    { BOOST_WAVE_RET(T_LESS); }
#line 724 "idl_re.cpp"
yy51:
    ++YYCURSOR;
    if ((yych = *YYCURSOR) <= '<') goto yy52;
    if (yych <= '=') goto yy222;
    if (yych <= '>') goto yy224;
yy52:
#line 411 "idl.re"
    { BOOST_WAVE_RET(T_GREATER); }
#line 733 "idl_re.cpp"
yy53:
    ++YYCURSOR;
#line 422 "idl.re"
    { BOOST_WAVE_RET(T_COMMA); }
#line 738 "idl_re.cpp"
yy55:
    yyaccept = 0;
    yych = *(YYMARKER = ++YYCURSOR);
    goto yy202;
yy56:
    yyaccept = 0;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yybm[0+yych] & 2) {
        goto yy201;
    }
    if (yych <= '\'') {
        if (yych == '"') goto yy75;
        if (yych <= '&') goto yy5;
        goto yy221;
    } else {
        if (yych <= '?') {
            if (yych <= '>') goto yy5;
            goto yy204;
        } else {
            if (yych == '\\') goto yy203;
            goto yy5;
        }
    }
yy57:
    yyaccept = 4;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych == 'U') goto yy193;
    if (yych == 'u') goto yy192;
yy58:
#line 492 "idl.re"
    {
        BOOST_WAVE_RET(TOKEN_FROM_ID(*s->tok, UnknownTokenType));
    }
#line 772 "idl_re.cpp"
yy59:
    yyaccept = 5;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yybm[0+yych] & 1) {
        goto yy185;
    }
    if (yych <= 'U') {
        if (yych <= 'C') {
            if (yych <= '.') {
                if (yych >= '.') goto yy168;
            } else {
                if (yych <= '/') goto yy60;
                if (yych <= '9') goto yy187;
            }
        } else {
            if (yych <= 'K') {
                if (yych <= 'D') goto yy164;
                if (yych <= 'E') goto yy171;
            } else {
                if (yych <= 'L') goto yy173;
                if (yych >= 'U') goto yy172;
            }
        }
    } else {
        if (yych <= 'k') {
            if (yych <= 'c') {
                if (yych == 'X') goto yy189;
            } else {
                if (yych <= 'd') goto yy164;
                if (yych <= 'e') goto yy171;
            }
        } else {
            if (yych <= 'u') {
                if (yych <= 'l') goto yy173;
                if (yych >= 'u') goto yy172;
            } else {
                if (yych == 'x') goto yy189;
            }
        }
    }
yy60:
#line 428 "idl.re"
    { BOOST_WAVE_RET(T_INTLIT); }
#line 816 "idl_re.cpp"
yy61:
    yyaccept = 5;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yybm[256+yych] & 128) {
        goto yy166;
    }
    if (yych <= 'T') {
        if (yych <= 'D') {
            if (yych == '.') goto yy168;
            if (yych <= 'C') goto yy60;
            goto yy164;
        } else {
            if (yych <= 'E') goto yy171;
            if (yych == 'L') goto yy173;
            goto yy60;
        }
    } else {
        if (yych <= 'e') {
            if (yych <= 'U') goto yy172;
            if (yych <= 'c') goto yy60;
            if (yych <= 'd') goto yy164;
            goto yy171;
        } else {
            if (yych <= 'l') {
                if (yych <= 'k') goto yy60;
                goto yy173;
            } else {
                if (yych == 'u') goto yy172;
                goto yy60;
            }
        }
    }
yy62:
    yyaccept = 4;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych <= 0x0C) {
        if (yych == 0x09) goto yy121;
        if (yych <= 0x0A) goto yy58;
        goto yy121;
    } else {
        if (yych <= 0x1F) goto yy58;
        if (yych == '\'') goto yy58;
        goto yy121;
    }
yy63:
    yyaccept = 4;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych <= 0x0A) {
        if (yych == 0x09) goto yy76;
        goto yy58;
    } else {
        if (yych <= 0x0C) goto yy76;
        if (yych <= 0x1F) goto yy58;
        goto yy76;
    }
yy64:
    ++YYCURSOR;
    yych = *YYCURSOR;
    goto yy74;
yy65:
#line 467 "idl.re"
    { BOOST_WAVE_RET(T_SPACE); }
#line 879 "idl_re.cpp"
yy66:
    ++YYCURSOR;
yy67:
#line 470 "idl.re"
    {
        s->line++;
        BOOST_WAVE_RET(T_NEWLINE);
    }
#line 888 "idl_re.cpp"
yy68:
    yych = *++YYCURSOR;
    if (yych == 0x0A) goto yy72;
    goto yy67;
yy69:
    ++YYCURSOR;
#line 476 "idl.re"
    {
        if(cursor != s->eof) 
        {
            using namespace std;      // some systems have printf in std
            if (0 != s->error_proc) {
                (*s->error_proc)(s, 
                    cpplexer::lexing_exception::generic_lexing_error,
                    "'\\000' in input stream");
            }
            else
                printf("Error: 0 in file\n");
        }
        BOOST_WAVE_RET(T_EOF);
    }
#line 910 "idl_re.cpp"
yy71:
    yych = *++YYCURSOR;
    goto yy58;
yy72:
    yych = *++YYCURSOR;
    goto yy67;
yy73:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
yy74:
    if (yybm[256+yych] & 2) {
        goto yy73;
    }
    goto yy65;
yy75:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
yy76:
    if (yybm[256+yych] & 4) {
        goto yy75;
    }
    if (yych <= '!') goto yy77;
    if (yych <= '"') goto yy80;
    if (yych <= '[') goto yy78;
    goto yy79;
yy77:
    YYCURSOR = YYMARKER;
    if (yyaccept <= 6) {
        if (yyaccept <= 3) {
            if (yyaccept <= 1) {
                if (yyaccept <= 0) {
                    goto yy5;
                } else {
                    goto yy16;
                }
            } else {
                if (yyaccept <= 2) {
                    goto yy26;
                } else {
                    goto yy36;
                }
            }
        } else {
            if (yyaccept <= 5) {
                if (yyaccept <= 4) {
                    goto yy58;
                } else {
                    goto yy60;
                }
            } else {
                goto yy81;
            }
        }
    } else {
        if (yyaccept <= 9) {
            if (yyaccept <= 8) {
                if (yyaccept <= 7) {
                    goto yy131;
                } else {
                    goto yy170;
                }
            } else {
                goto yy294;
            }
        } else {
            if (yyaccept <= 11) {
                if (yyaccept <= 10) {
                    goto yy302;
                } else {
                    goto yy349;
                }
            } else {
                goto yy353;
            }
        }
    }
yy78:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 4) {
        goto yy75;
    }
    if (yych <= '!') goto yy77;
    if (yych <= '"') goto yy80;
    if (yych <= '[') goto yy91;
yy79:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '`') {
        if (yych <= '7') {
            if (yych <= '&') {
                if (yych == '"') goto yy75;
                goto yy77;
            } else {
                if (yych <= '\'') goto yy75;
                if (yych <= '/') goto yy77;
                goto yy86;
            }
        } else {
            if (yych <= 'T') {
                if (yych == '?') goto yy84;
                goto yy77;
            } else {
                if (yych <= 'U') goto yy83;
                if (yych == '\\') goto yy75;
                goto yy77;
            }
        }
    } else {
        if (yych <= 'r') {
            if (yych <= 'f') {
                if (yych <= 'b') goto yy75;
                if (yych <= 'e') goto yy77;
                goto yy75;
            } else {
                if (yych == 'n') goto yy75;
                if (yych <= 'q') goto yy77;
                goto yy75;
            }
        } else {
            if (yych <= 'u') {
                if (yych <= 's') goto yy77;
                if (yych <= 't') goto yy75;
                goto yy82;
            } else {
                if (yych <= 'v') goto yy75;
                if (yych == 'x') goto yy85;
                goto yy77;
            }
        }
    }
yy80:
    ++YYCURSOR;
yy81:
#line 440 "idl.re"
    { BOOST_WAVE_RET(T_STRINGLIT); }
#line 1051 "idl_re.cpp"
yy82:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy117;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy117;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy117;
        goto yy77;
    }
yy83:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy110;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy110;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy110;
        goto yy77;
    }
yy84:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 4) {
        goto yy75;
    }
    if (yych <= '!') goto yy77;
    if (yych <= '"') goto yy80;
    if (yych <= '[') goto yy90;
    goto yy79;
yy85:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 8) {
        goto yy88;
    }
    goto yy77;
yy86:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '"') {
        if (yych <= 0x0A) {
            if (yych == 0x09) goto yy75;
            goto yy77;
        } else {
            if (yych <= 0x0C) goto yy75;
            if (yych <= 0x1F) goto yy77;
            if (yych <= '!') goto yy75;
            goto yy80;
        }
    } else {
        if (yych <= '>') {
            if (yych <= '/') goto yy75;
            if (yych >= '8') goto yy75;
        } else {
            if (yych <= '?') goto yy78;
            if (yych == '\\') goto yy79;
            goto yy75;
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 4) {
        goto yy75;
    }
    if (yych <= '!') goto yy77;
    if (yych <= '"') goto yy80;
    if (yych <= '[') goto yy78;
    goto yy79;
yy88:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 8) {
        goto yy88;
    }
    if (yych <= '!') {
        if (yych <= 0x0A) {
            if (yych == 0x09) goto yy75;
            goto yy77;
        } else {
            if (yych <= 0x0C) goto yy75;
            if (yych <= 0x1F) goto yy77;
            goto yy75;
        }
    } else {
        if (yych <= '?') {
            if (yych <= '"') goto yy80;
            if (yych <= '>') goto yy75;
            goto yy78;
        } else {
            if (yych == '\\') goto yy79;
            goto yy75;
        }
    }
yy90:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 4) {
        goto yy75;
    }
    if (yych <= '!') goto yy77;
    if (yych <= '"') goto yy80;
    if (yych >= '\\') goto yy79;
yy91:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 16) {
        goto yy91;
    }
    if (yych <= '!') {
        if (yych <= 0x0A) {
            if (yych == 0x09) goto yy75;
            goto yy77;
        } else {
            if (yych <= 0x0C) goto yy75;
            if (yych <= 0x1F) goto yy77;
            goto yy75;
        }
    } else {
        if (yych <= '/') {
            if (yych <= '"') goto yy80;
            if (yych <= '.') goto yy75;
        } else {
            if (yych == '\\') goto yy79;
            goto yy75;
        }
    }
yy93:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 32) {
        goto yy93;
    }
    if (yych <= '7') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy97;
                if (yych <= '/') goto yy75;
                goto yy86;
            }
        }
    } else {
        if (yych <= 'U') {
            if (yych == '?') goto yy98;
            if (yych <= 'T') goto yy75;
            goto yy96;
        } else {
            if (yych <= 'u') {
                if (yych <= 't') goto yy75;
            } else {
                if (yych == 'x') goto yy88;
                goto yy75;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
                goto yy107;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
            goto yy107;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych <= 'f') goto yy107;
                goto yy75;
            }
        }
    }
yy96:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
                goto yy100;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
            goto yy100;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych <= 'f') goto yy100;
                goto yy75;
            }
        }
    }
yy97:
    yyaccept = 6;
    YYMARKER = ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 4) {
        goto yy75;
    }
    if (yych <= '!') goto yy81;
    if (yych <= '"') goto yy80;
    if (yych <= '[') goto yy78;
    goto yy79;
yy98:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 4) {
        goto yy75;
    }
    if (yych <= '!') goto yy77;
    if (yych <= '"') goto yy80;
    if (yych >= '\\') goto yy79;
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 16) {
        goto yy91;
    }
    if (yych <= '!') {
        if (yych <= 0x0A) {
            if (yych == 0x09) goto yy75;
            goto yy77;
        } else {
            if (yych <= 0x0C) goto yy75;
            if (yych <= 0x1F) goto yy77;
            goto yy75;
        }
    } else {
        if (yych <= '/') {
            if (yych <= '"') goto yy80;
            if (yych <= '.') goto yy75;
            goto yy93;
        } else {
            if (yych == '\\') goto yy79;
            goto yy75;
        }
    }
yy100:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych >= 'g') goto yy75;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych >= 'g') goto yy75;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych >= 'g') goto yy75;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych >= 'g') goto yy75;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych >= 'g') goto yy75;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych >= 'g') goto yy75;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 4) {
        goto yy75;
    }
    if (yych <= '!') goto yy77;
    if (yych <= '"') goto yy80;
    if (yych <= '[') goto yy78;
    goto yy79;
yy107:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych >= 'g') goto yy75;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy75;
            if (yych <= 0x0A) goto yy77;
            goto yy75;
        } else {
            if (yych <= '!') {
                if (yych <= 0x1F) goto yy77;
                goto yy75;
            } else {
                if (yych <= '"') goto yy80;
                if (yych <= '/') goto yy75;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy78;
            if (yych <= '@') goto yy75;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy75;
                goto yy79;
            } else {
                if (yych <= '`') goto yy75;
                if (yych >= 'g') goto yy75;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 4) {
        goto yy75;
    }
    if (yych <= '!') goto yy77;
    if (yych <= '"') goto yy80;
    if (yych <= '[') goto yy78;
    goto yy79;
yy110:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy111;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy111:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy112;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy112:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy113;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy113:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy114;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy114:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy115;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy115:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy116;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy116:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy75;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy75;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy75;
        goto yy77;
    }
yy117:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy118;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy118:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy119;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy119:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy75;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy75;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy75;
        goto yy77;
    }
yy120:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
yy121:
    if (yybm[256+yych] & 64) {
        goto yy120;
    }
    if (yych <= '&') goto yy77;
    if (yych <= '\'') goto yy130;
    if (yych >= '\\') goto yy123;
yy122:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 64) {
        goto yy120;
    }
    if (yych <= '&') goto yy77;
    if (yych <= '\'') goto yy130;
    if (yych <= '[') goto yy135;
yy123:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '`') {
        if (yych <= '7') {
            if (yych <= '&') {
                if (yych == '"') goto yy120;
                goto yy77;
            } else {
                if (yych <= '\'') goto yy120;
                if (yych <= '/') goto yy77;
                goto yy128;
            }
        } else {
            if (yych <= 'T') {
                if (yych == '?') goto yy126;
                goto yy77;
            } else {
                if (yych <= 'U') goto yy125;
                if (yych == '\\') goto yy120;
                goto yy77;
            }
        }
    } else {
        if (yych <= 'r') {
            if (yych <= 'f') {
                if (yych <= 'b') goto yy120;
                if (yych <= 'e') goto yy77;
                goto yy120;
            } else {
                if (yych == 'n') goto yy120;
                if (yych <= 'q') goto yy77;
                goto yy120;
            }
        } else {
            if (yych <= 'u') {
                if (yych <= 's') goto yy77;
                if (yych <= 't') goto yy120;
            } else {
                if (yych <= 'v') goto yy120;
                if (yych == 'x') goto yy127;
                goto yy77;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy161;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy161;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy161;
        goto yy77;
    }
yy125:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy154;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy154;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy154;
        goto yy77;
    }
yy126:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 64) {
        goto yy120;
    }
    if (yych <= '&') goto yy77;
    if (yych <= '\'') goto yy130;
    if (yych <= '[') goto yy134;
    goto yy123;
yy127:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy132;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy132;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy132;
        goto yy77;
    }
yy128:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '\'') {
        if (yych <= 0x0A) {
            if (yych == 0x09) goto yy120;
            goto yy77;
        } else {
            if (yych <= 0x0C) goto yy120;
            if (yych <= 0x1F) goto yy77;
            if (yych <= '&') goto yy120;
            goto yy130;
        }
    } else {
        if (yych <= '>') {
            if (yych <= '/') goto yy120;
            if (yych >= '8') goto yy120;
        } else {
            if (yych <= '?') goto yy122;
            if (yych == '\\') goto yy123;
            goto yy120;
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 64) {
        goto yy120;
    }
    if (yych <= '&') goto yy77;
    if (yych <= '\'') goto yy130;
    if (yych <= '[') goto yy122;
    goto yy123;
yy130:
    ++YYCURSOR;
yy131:
#line 437 "idl.re"
    { BOOST_WAVE_RET(T_CHARLIT); }
#line 1898 "idl_re.cpp"
yy132:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
                goto yy132;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
            goto yy132;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych <= 'f') goto yy132;
                goto yy120;
            }
        }
    }
yy134:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 64) {
        goto yy120;
    }
    if (yych <= '&') goto yy77;
    if (yych <= '\'') goto yy130;
    if (yych >= '\\') goto yy123;
yy135:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '\'') {
        if (yych <= 0x0A) {
            if (yych == 0x09) goto yy120;
            goto yy77;
        } else {
            if (yych <= 0x0C) goto yy120;
            if (yych <= 0x1F) goto yy77;
            if (yych <= '&') goto yy120;
            goto yy130;
        }
    } else {
        if (yych <= '>') {
            if (yych != '/') goto yy120;
        } else {
            if (yych <= '?') goto yy135;
            if (yych == '\\') goto yy123;
            goto yy120;
        }
    }
yy137:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '>') {
        if (yych <= 0x1F) {
            if (yych <= 0x09) {
                if (yych <= 0x08) goto yy77;
                goto yy120;
            } else {
                if (yych <= 0x0A) goto yy77;
                if (yych <= 0x0C) goto yy120;
                goto yy77;
            }
        } else {
            if (yych <= '\'') {
                if (yych <= '&') goto yy120;
                goto yy141;
            } else {
                if (yych <= '/') goto yy120;
                if (yych <= '7') goto yy128;
                goto yy120;
            }
        }
    } else {
        if (yych <= '\\') {
            if (yych <= 'T') {
                if (yych <= '?') goto yy142;
                goto yy120;
            } else {
                if (yych <= 'U') goto yy140;
                if (yych <= '[') goto yy120;
                goto yy137;
            }
        } else {
            if (yych <= 'u') {
                if (yych <= 't') goto yy120;
            } else {
                if (yych == 'x') goto yy132;
                goto yy120;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
                goto yy151;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
            goto yy151;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych <= 'f') goto yy151;
                goto yy120;
            }
        }
    }
yy140:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
                goto yy144;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
            goto yy144;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych <= 'f') goto yy144;
                goto yy120;
            }
        }
    }
yy141:
    yyaccept = 7;
    YYMARKER = ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 64) {
        goto yy120;
    }
    if (yych <= '&') goto yy131;
    if (yych <= '\'') goto yy130;
    if (yych <= '[') goto yy122;
    goto yy123;
yy142:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 64) {
        goto yy120;
    }
    if (yych <= '&') goto yy77;
    if (yych <= '\'') goto yy130;
    if (yych >= '\\') goto yy123;
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '\'') {
        if (yych <= 0x0A) {
            if (yych == 0x09) goto yy120;
            goto yy77;
        } else {
            if (yych <= 0x0C) goto yy120;
            if (yych <= 0x1F) goto yy77;
            if (yych <= '&') goto yy120;
            goto yy130;
        }
    } else {
        if (yych <= '>') {
            if (yych == '/') goto yy137;
            goto yy120;
        } else {
            if (yych <= '?') goto yy135;
            if (yych == '\\') goto yy123;
            goto yy120;
        }
    }
yy144:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych >= 'g') goto yy120;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych >= 'g') goto yy120;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych >= 'g') goto yy120;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych >= 'g') goto yy120;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych >= 'g') goto yy120;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych >= 'g') goto yy120;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 64) {
        goto yy120;
    }
    if (yych <= '&') goto yy77;
    if (yych <= '\'') goto yy130;
    if (yych <= '[') goto yy122;
    goto yy123;
yy151:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych >= 'g') goto yy120;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '9') {
        if (yych <= 0x0C) {
            if (yych == 0x09) goto yy120;
            if (yych <= 0x0A) goto yy77;
            goto yy120;
        } else {
            if (yych <= '&') {
                if (yych <= 0x1F) goto yy77;
                goto yy120;
            } else {
                if (yych <= '\'') goto yy130;
                if (yych <= '/') goto yy120;
            }
        }
    } else {
        if (yych <= 'F') {
            if (yych == '?') goto yy122;
            if (yych <= '@') goto yy120;
        } else {
            if (yych <= '\\') {
                if (yych <= '[') goto yy120;
                goto yy123;
            } else {
                if (yych <= '`') goto yy120;
                if (yych >= 'g') goto yy120;
            }
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 64) {
        goto yy120;
    }
    if (yych <= '&') goto yy77;
    if (yych <= '\'') goto yy130;
    if (yych <= '[') goto yy122;
    goto yy123;
yy154:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy155;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy155:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy156;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy156:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy157;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy157:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy158;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy158:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy159;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy159:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy160;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy160:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy120;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy120;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy120;
        goto yy77;
    }
yy161:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy162;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy162:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy163;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy163:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy120;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy120;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy120;
        goto yy77;
    }
yy164:
    ++YYCURSOR;
#line 434 "idl.re"
    { BOOST_WAVE_RET(T_FIXEDPOINTLIT); }
#line 2522 "idl_re.cpp"
yy166:
    yyaccept = 5;
    YYMARKER = ++YYCURSOR;
    if ((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
    yych = *YYCURSOR;
    if (yybm[256+yych] & 128) {
        goto yy166;
    }
    if (yych <= 'T') {
        if (yych <= 'D') {
            if (yych == '.') goto yy168;
            if (yych <= 'C') goto yy60;
            goto yy164;
        } else {
            if (yych <= 'E') goto yy171;
            if (yych == 'L') goto yy173;
            goto yy60;
        }
    } else {
        if (yych <= 'e') {
            if (yych <= 'U') goto yy172;
            if (yych <= 'c') goto yy60;
            if (yych <= 'd') goto yy164;
            goto yy171;
        } else {
            if (yych <= 'l') {
                if (yych <= 'k') goto yy60;
                goto yy173;
            } else {
                if (yych == 'u') goto yy172;
                goto yy60;
            }
        }
    }
yy168:
    yyaccept = 8;
    YYMARKER = ++YYCURSOR;
    if ((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
    yych = *YYCURSOR;
    if (yych <= 'K') {
        if (yych <= 'C') {
            if (yych <= '/') goto yy170;
            if (yych <= '9') goto yy168;
        } else {
            if (yych <= 'D') goto yy164;
            if (yych <= 'E') goto yy181;
            if (yych <= 'F') goto yy178;
        }
    } else {
        if (yych <= 'e') {
            if (yych <= 'L') goto yy179;
            if (yych <= 'c') goto yy170;
            if (yych <= 'd') goto yy164;
            goto yy181;
        } else {
            if (yych <= 'f') goto yy178;
            if (yych == 'l') goto yy179;
        }
    }
yy170:
#line 431 "idl.re"
    { BOOST_WAVE_RET(T_FLOATLIT); }
#line 2585 "idl_re.cpp"
yy171:
    yych = *++YYCURSOR;
    if (yych <= ',') {
        if (yych == '+') goto yy175;
        goto yy77;
    } else {
        if (yych <= '-') goto yy175;
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy176;
        goto yy77;
    }
yy172:
    yych = *++YYCURSOR;
    if (yych == 'L') goto yy174;
    if (yych == 'l') goto yy174;
    goto yy60;
yy173:
    yych = *++YYCURSOR;
    if (yych == 'U') goto yy174;
    if (yych != 'u') goto yy60;
yy174:
    yych = *++YYCURSOR;
    goto yy60;
yy175:
    yych = *++YYCURSOR;
    if (yych <= '/') goto yy77;
    if (yych >= ':') goto yy77;
yy176:
    ++YYCURSOR;
    if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
    yych = *YYCURSOR;
    if (yych <= 'K') {
        if (yych <= '9') {
            if (yych <= '/') goto yy170;
            goto yy176;
        } else {
            if (yych != 'F') goto yy170;
        }
    } else {
        if (yych <= 'f') {
            if (yych <= 'L') goto yy179;
            if (yych <= 'e') goto yy170;
        } else {
            if (yych == 'l') goto yy179;
            goto yy170;
        }
    }
yy178:
    yych = *++YYCURSOR;
    if (yych == 'L') goto yy180;
    if (yych == 'l') goto yy180;
    goto yy170;
yy179:
    yych = *++YYCURSOR;
    if (yych == 'F') goto yy180;
    if (yych != 'f') goto yy170;
yy180:
    yych = *++YYCURSOR;
    goto yy170;
yy181:
    yych = *++YYCURSOR;
    if (yych <= ',') {
        if (yych != '+') goto yy77;
    } else {
        if (yych <= '-') goto yy182;
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy183;
        goto yy77;
    }
yy182:
    yych = *++YYCURSOR;
    if (yych <= '/') goto yy77;
    if (yych >= ':') goto yy77;
yy183:
    ++YYCURSOR;
    if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
    yych = *YYCURSOR;
    if (yych <= 'K') {
        if (yych <= '9') {
            if (yych <= '/') goto yy170;
            goto yy183;
        } else {
            if (yych == 'F') goto yy178;
            goto yy170;
        }
    } else {
        if (yych <= 'f') {
            if (yych <= 'L') goto yy179;
            if (yych <= 'e') goto yy170;
            goto yy178;
        } else {
            if (yych == 'l') goto yy179;
            goto yy170;
        }
    }
yy185:
    yyaccept = 5;
    YYMARKER = ++YYCURSOR;
    if ((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
    yych = *YYCURSOR;
    if (yybm[0+yych] & 1) {
        goto yy185;
    }
    if (yych <= 'L') {
        if (yych <= '9') {
            if (yych == '.') goto yy168;
            if (yych <= '/') goto yy60;
        } else {
            if (yych <= 'D') {
                if (yych <= 'C') goto yy60;
                goto yy164;
            } else {
                if (yych <= 'E') goto yy171;
                if (yych <= 'K') goto yy60;
                goto yy173;
            }
        }
    } else {
        if (yych <= 'e') {
            if (yych <= 'U') {
                if (yych <= 'T') goto yy60;
                goto yy172;
            } else {
                if (yych <= 'c') goto yy60;
                if (yych <= 'd') goto yy164;
                goto yy171;
            }
        } else {
            if (yych <= 'l') {
                if (yych <= 'k') goto yy60;
                goto yy173;
            } else {
                if (yych == 'u') goto yy172;
                goto yy60;
            }
        }
    }
yy187:
    ++YYCURSOR;
    if ((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
    yych = *YYCURSOR;
    if (yych <= 'C') {
        if (yych <= '.') {
            if (yych <= '-') goto yy77;
            goto yy168;
        } else {
            if (yych <= '/') goto yy77;
            if (yych <= '9') goto yy187;
            goto yy77;
        }
    } else {
        if (yych <= 'c') {
            if (yych <= 'D') goto yy164;
            if (yych <= 'E') goto yy171;
            goto yy77;
        } else {
            if (yych <= 'd') goto yy164;
            if (yych <= 'e') goto yy171;
            goto yy77;
        }
    }
yy189:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy190;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy190:
    ++YYCURSOR;
    if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
    yych = *YYCURSOR;
    if (yych <= 'T') {
        if (yych <= '@') {
            if (yych <= '/') goto yy60;
            if (yych <= '9') goto yy190;
            goto yy60;
        } else {
            if (yych <= 'F') goto yy190;
            if (yych == 'L') goto yy173;
            goto yy60;
        }
    } else {
        if (yych <= 'k') {
            if (yych <= 'U') goto yy172;
            if (yych <= '`') goto yy60;
            if (yych <= 'f') goto yy190;
            goto yy60;
        } else {
            if (yych <= 'l') goto yy173;
            if (yych == 'u') goto yy172;
            goto yy60;
        }
    }
yy192:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy218;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy218;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy218;
        goto yy77;
    }
yy193:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy194;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy194:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy195;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy195:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy196;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy196:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy197;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy197:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy198;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy198:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy199;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy199:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy200;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy200:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy201;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy201:
    yyaccept = 0;
    YYMARKER = ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
yy202:
    if (yybm[0+yych] & 2) {
        goto yy201;
    }
    if (yych == '?') goto yy204;
    if (yych != '\\') goto yy5;
yy203:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych == 'U') goto yy207;
    if (yych == 'u') goto yy206;
    goto yy77;
yy204:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych != '?') goto yy77;
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych == '/') goto yy203;
    goto yy77;
yy206:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy215;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy215;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy215;
        goto yy77;
    }
yy207:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy208;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy208:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy209;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy209:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy210;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy210:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy211;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy211:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy212;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy212:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy213;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy213:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy214;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy214:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy201;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy201;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy201;
        goto yy77;
    }
yy215:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy216;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy216:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy217;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy217:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy201;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy201;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy201;
        goto yy77;
    }
yy218:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy219;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy219:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych >= ':') goto yy77;
    } else {
        if (yych <= 'F') goto yy220;
        if (yych <= '`') goto yy77;
        if (yych >= 'g') goto yy77;
    }
yy220:
    yych = *++YYCURSOR;
    if (yych <= '@') {
        if (yych <= '/') goto yy77;
        if (yych <= '9') goto yy201;
        goto yy77;
    } else {
        if (yych <= 'F') goto yy201;
        if (yych <= '`') goto yy77;
        if (yych <= 'f') goto yy201;
        goto yy77;
    }
yy221:
    yych = *++YYCURSOR;
    if (yych == '\'') goto yy77;
    goto yy121;
yy222:
    ++YYCURSOR;
#line 417 "idl.re"
    { BOOST_WAVE_RET(T_GREATEREQUAL); }
#line 3093 "idl_re.cpp"
yy224:
    ++YYCURSOR;
#line 413 "idl.re"
    { BOOST_WAVE_RET(T_SHIFTRIGHT); }
#line 3098 "idl_re.cpp"
yy226:
    ++YYCURSOR;
#line 416 "idl.re"
    { BOOST_WAVE_RET(T_LESSEQUAL); }
#line 3103 "idl_re.cpp"
yy228:
    ++YYCURSOR;
#line 412 "idl.re"
    { BOOST_WAVE_RET(T_SHIFTLEFT); }
#line 3108 "idl_re.cpp"
yy230:
    ++YYCURSOR;
#line 414 "idl.re"
    { BOOST_WAVE_RET(T_EQUAL); }
#line 3113 "idl_re.cpp"
yy232:
    ++YYCURSOR;
#line 415 "idl.re"
    { BOOST_WAVE_RET(T_NOTEQUAL); }
#line 3118 "idl_re.cpp"
yy234:
    ++YYCURSOR;
#line 419 "idl.re"
    { BOOST_WAVE_RET(T_OROR); }
#line 3123 "idl_re.cpp"
yy236:
    ++YYCURSOR;
#line 418 "idl.re"
    { BOOST_WAVE_RET(T_ANDAND); }
#line 3128 "idl_re.cpp"
yy238:
    ++YYCURSOR;
    if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
    yych = *YYCURSOR;
yy239:
    if (yybm[0+yych] & 4) {
        goto yy238;
    }
    if (yych <= 'k') {
        if (yych <= 'd') {
            if (yych == '/') goto yy240;
            if (yych <= 'c') goto yy77;
            goto yy243;
        } else {
            if (yych <= 'e') goto yy242;
            if (yych == 'i') goto yy241;
            goto yy77;
        }
    } else {
        if (yych <= 't') {
            if (yych <= 'l') goto yy245;
            if (yych == 'p') goto yy246;
            goto yy77;
        } else {
            if (yych <= 'u') goto yy244;
            if (yych == 'w') goto yy247;
            goto yy77;
        }
    }
yy240:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych == '*') goto yy330;
    goto yy77;
yy241:
    yych = *++YYCURSOR;
    if (yych == 'f') goto yy293;
    if (yych == 'n') goto yy295;
    goto yy77;
yy242:
    yych = *++YYCURSOR;
    if (yych <= 'm') {
        if (yych == 'l') goto yy278;
        goto yy77;
    } else {
        if (yych <= 'n') goto yy277;
        if (yych == 'r') goto yy276;
        goto yy77;
    }
yy243:
    yych = *++YYCURSOR;
    if (yych == 'e') goto yy270;
    goto yy77;
yy244:
    yych = *++YYCURSOR;
    if (yych == 'n') goto yy265;
    goto yy77;
yy245:
    yych = *++YYCURSOR;
    if (yych == 'i') goto yy261;
    goto yy77;
yy246:
    yych = *++YYCURSOR;
    if (yych == 'r') goto yy255;
    goto yy77;
yy247:
    yych = *++YYCURSOR;
    if (yych != 'a') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'r') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'n') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'i') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'n') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'g') goto yy77;
    ++YYCURSOR;
#line 464 "idl.re"
    { BOOST_WAVE_RET(T_PP_WARNING); }
#line 3211 "idl_re.cpp"
yy255:
    yych = *++YYCURSOR;
    if (yych != 'a') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'g') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'm') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'a') goto yy77;
    ++YYCURSOR;
#line 462 "idl.re"
    { BOOST_WAVE_RET(T_PP_PRAGMA); }
#line 3224 "idl_re.cpp"
yy261:
    yych = *++YYCURSOR;
    if (yych != 'n') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'e') goto yy77;
    ++YYCURSOR;
#line 460 "idl.re"
    { BOOST_WAVE_RET(T_PP_LINE); }
#line 3233 "idl_re.cpp"
yy265:
    yych = *++YYCURSOR;
    if (yych != 'd') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'e') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'f') goto yy77;
    ++YYCURSOR;
#line 459 "idl.re"
    { BOOST_WAVE_RET(T_PP_UNDEF); }
#line 3244 "idl_re.cpp"
yy270:
    yych = *++YYCURSOR;
    if (yych != 'f') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'i') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'n') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'e') goto yy77;
    ++YYCURSOR;
#line 458 "idl.re"
    { BOOST_WAVE_RET(T_PP_DEFINE); }
#line 3257 "idl_re.cpp"
yy276:
    yych = *++YYCURSOR;
    if (yych == 'r') goto yy289;
    goto yy77;
yy277:
    yych = *++YYCURSOR;
    if (yych == 'd') goto yy285;
    goto yy77;
yy278:
    yych = *++YYCURSOR;
    if (yych == 'i') goto yy280;
    if (yych != 's') goto yy77;
    yych = *++YYCURSOR;
    if (yych == 'e') goto yy283;
    goto yy77;
yy280:
    yych = *++YYCURSOR;
    if (yych != 'f') goto yy77;
    ++YYCURSOR;
#line 456 "idl.re"
    { BOOST_WAVE_RET(T_PP_ELIF); }
#line 3279 "idl_re.cpp"
yy283:
    ++YYCURSOR;
#line 455 "idl.re"
    { BOOST_WAVE_RET(T_PP_ELSE); }
#line 3284 "idl_re.cpp"
yy285:
    yych = *++YYCURSOR;
    if (yych != 'i') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'f') goto yy77;
    ++YYCURSOR;
#line 457 "idl.re"
    { BOOST_WAVE_RET(T_PP_ENDIF); }
#line 3293 "idl_re.cpp"
yy289:
    yych = *++YYCURSOR;
    if (yych != 'o') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'r') goto yy77;
    ++YYCURSOR;
#line 461 "idl.re"
    { BOOST_WAVE_RET(T_PP_ERROR); }
#line 3302 "idl_re.cpp"
yy293:
    yyaccept = 9;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych == 'd') goto yy321;
    if (yych == 'n') goto yy322;
yy294:
#line 452 "idl.re"
    { BOOST_WAVE_RET(T_PP_IF); }
#line 3311 "idl_re.cpp"
yy295:
    yych = *++YYCURSOR;
    if (yych != 'c') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'l') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'u') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'd') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'e') goto yy77;
yy300:
    yyaccept = 10;
    YYMARKER = ++YYCURSOR;
    if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
    yych = *YYCURSOR;
    if (yych <= '!') {
        if (yych <= 0x09) {
            if (yych >= 0x09) goto yy300;
        } else {
            if (yych == ' ') goto yy300;
        }
    } else {
        if (yych <= '/') {
            if (yych <= '"') goto yy304;
            if (yych >= '/') goto yy303;
        } else {
            if (yych == '<') goto yy305;
        }
    }
yy302:
#line 450 "idl.re"
    { BOOST_WAVE_RET(T_PP_INCLUDE); }
#line 3345 "idl_re.cpp"
yy303:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych == '*') goto yy314;
    goto yy77;
yy304:
    yych = *++YYCURSOR;
    if (yych == '"') goto yy77;
    goto yy311;
yy305:
    yych = *++YYCURSOR;
    if (yych == '>') goto yy77;
    goto yy307;
yy306:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
yy307:
    if (yybm[0+yych] & 8) {
        goto yy306;
    }
    if (yych <= '=') goto yy77;
    ++YYCURSOR;
#line 444 "idl.re"
    { BOOST_WAVE_RET(T_PP_HHEADER); }
#line 3372 "idl_re.cpp"
yy310:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
yy311:
    if (yybm[0+yych] & 16) {
        goto yy310;
    }
    if (yych <= '!') goto yy77;
    ++YYCURSOR;
#line 447 "idl.re"
    { BOOST_WAVE_RET(T_PP_QHEADER); }
#line 3385 "idl_re.cpp"
yy314:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[0+yych] & 32) {
        goto yy314;
    }
    if (yych == 0x0D) goto yy316;
    if (yych <= ')') goto yy77;
    goto yy318;
yy316:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[0+yych] & 32) {
        goto yy314;
    }
    if (yych == 0x0D) goto yy316;
    if (yych <= ')') goto yy77;
yy318:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[0+yych] & 128) {
        goto yy318;
    }
    if (yych <= 0x0D) {
        if (yych <= 0x08) goto yy77;
        if (yych <= 0x0C) goto yy314;
    } else {
        if (yych <= 0x1F) goto yy77;
        if (yych == '/') goto yy300;
        goto yy314;
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yybm[0+yych] & 32) {
        goto yy314;
    }
    if (yych == 0x0D) goto yy316;
    if (yych <= ')') goto yy77;
    goto yy318;
yy321:
    yych = *++YYCURSOR;
    if (yych == 'e') goto yy327;
    goto yy77;
yy322:
    yych = *++YYCURSOR;
    if (yych != 'd') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'e') goto yy77;
    yych = *++YYCURSOR;
    if (yych != 'f') goto yy77;
    ++YYCURSOR;
#line 454 "idl.re"
    { BOOST_WAVE_RET(T_PP_IFNDEF); }
#line 3443 "idl_re.cpp"
yy327:
    yych = *++YYCURSOR;
    if (yych != 'f') goto yy77;
    ++YYCURSOR;
#line 453 "idl.re"
    { BOOST_WAVE_RET(T_PP_IFDEF); }
#line 3450 "idl_re.cpp"
yy330:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= 0x0D) {
        if (yych <= 0x08) goto yy77;
        if (yych <= 0x0C) goto yy330;
    } else {
        if (yych <= 0x1F) goto yy77;
        if (yych == '*') goto yy334;
        goto yy330;
    }
yy332:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= 0x0D) {
        if (yych <= 0x08) goto yy77;
        if (yych <= 0x0C) goto yy330;
        goto yy332;
    } else {
        if (yych <= 0x1F) goto yy77;
        if (yych != '*') goto yy330;
    }
yy334:
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= 0x1F) {
        if (yych <= 0x08) goto yy77;
        if (yych <= 0x0C) goto yy330;
        if (yych >= 0x0E) goto yy77;
    } else {
        if (yych <= '*') {
            if (yych <= ')') goto yy330;
            goto yy334;
        } else {
            if (yych == '/') goto yy238;
            goto yy330;
        }
    }
    ++YYCURSOR;
    if (YYLIMIT == YYCURSOR) YYFILL(1);
    yych = *YYCURSOR;
    if (yych <= 0x0D) {
        if (yych <= 0x08) goto yy77;
        if (yych <= 0x0C) goto yy330;
        goto yy332;
    } else {
        if (yych <= 0x1F) goto yy77;
        if (yych == '*') goto yy334;
        goto yy330;
    }
yy337:
    ++YYCURSOR;
#line 421 "idl.re"
    { BOOST_WAVE_RET(T_MINUSMINUS); }
#line 3508 "idl_re.cpp"
yy339:
    ++YYCURSOR;
#line 420 "idl.re"
    { BOOST_WAVE_RET(T_PLUSPLUS); }
#line 3513 "idl_re.cpp"
yy341:
    yych = *++YYCURSOR;
    if (yych == '/') goto yy342;
    if (yych == '=') goto yy238;
    goto yy77;
yy342:
    yych = *++YYCURSOR;
    if (yych == 'U') goto yy193;
    if (yych == 'u') goto yy192;
    goto yy77;
yy343:
    ++YYCURSOR;
#line 392 "idl.re"
    { BOOST_WAVE_RET(T_POUND_POUND); }
#line 3528 "idl_re.cpp"
yy345:
    yyaccept = 0;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych != 'L') goto yy202;
    yyaccept = 0;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych != 'S') goto yy202;
    yyaccept = 0;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych != 'E') goto yy202;
    yyaccept = 11;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yybm[0+yych] & 2) {
        goto yy201;
    }
    if (yych == '?') goto yy204;
    if (yych == '\\') goto yy203;
yy349:
#line 385 "idl.re"
    { BOOST_WAVE_RET(T_FALSE); }
#line 3549 "idl_re.cpp"
yy350:
    yyaccept = 0;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych != 'U') goto yy202;
    yyaccept = 0;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yych != 'E') goto yy202;
    yyaccept = 12;
    yych = *(YYMARKER = ++YYCURSOR);
    if (yybm[0+yych] & 2) {
        goto yy201;
    }
    if (yych == '?') goto yy204;
    if (yych == '\\') goto yy203;
yy353:
#line 384 "idl.re"
    { BOOST_WAVE_RET(T_TRUE); }
#line 3567 "idl_re.cpp"
yy354:
    ++YYCURSOR;
#line 382 "idl.re"
    { goto cppcomment; }
#line 3572 "idl_re.cpp"
yy356:
    ++YYCURSOR;
#line 381 "idl.re"
    { goto ccomment; }
#line 3577 "idl_re.cpp"
}
#line 495 "idl.re"


ccomment:

#line 3584 "idl_re.cpp"
{
    YYCTYPE yych;
    if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
    yych = *YYCURSOR;
    if (yych <= 0x0C) {
        if (yych <= 0x08) {
            if (yych <= 0x00) goto yy366;
            goto yy368;
        } else {
            if (yych == 0x0A) goto yy362;
            goto yy365;
        }
    } else {
        if (yych <= 0x1F) {
            if (yych <= 0x0D) goto yy364;
            goto yy368;
        } else {
            if (yych != '*') goto yy365;
        }
    }
    ++YYCURSOR;
    if ((yych = *YYCURSOR) == '/') goto yy371;
yy361:
#line 508 "idl.re"
    { goto ccomment; }
#line 3610 "idl_re.cpp"
yy362:
    ++YYCURSOR;
yy363:
#line 501 "idl.re"
    {
        /*if(cursor == s->eof) BOOST_WAVE_RET(T_EOF);*/
        /*s->tok = cursor; */
        s->line += count_backslash_newlines(s, cursor) +1;
        goto ccomment;
    }
#line 3621 "idl_re.cpp"
yy364:
    yych = *++YYCURSOR;
    if (yych == 0x0A) goto yy370;
    goto yy363;
yy365:
    yych = *++YYCURSOR;
    goto yy361;
yy366:
    ++YYCURSOR;
#line 511 "idl.re"
    {
        using namespace std;      // some systems have printf in std
        if(cursor == s->eof) 
        {
            if (s->error_proc)
                (*s->error_proc)(s, 
                    cpplexer::lexing_exception::generic_lexing_warning,
                    "Unterminated comment");
            else
                printf("Error: Unterminated comment\n");
        }
        else
        {
            if (s->error_proc)
                (*s->error_proc)(s, 
                    cpplexer::lexing_exception::generic_lexing_error,
                    "'\\000' in input stream");
            else
                printf("Error: 0 in file");
        }
        /* adjust cursor such next call returns T_EOF */
        --YYCURSOR;
        /* the comment is unterminated, but nevertheless its a comment */
        BOOST_WAVE_RET(T_CCOMMENT);
    }
#line 3657 "idl_re.cpp"
yy368:
    ++YYCURSOR;
#line 538 "idl.re"
    {
        if (s->error_proc)
            (*s->error_proc)(s, 
                cpplexer::lexing_exception::generic_lexing_error,
                "invalid character in input stream");
        else
            printf("Error: 0 in file");
    }
#line 3669 "idl_re.cpp"
yy370:
    yych = *++YYCURSOR;
    goto yy363;
yy371:
    ++YYCURSOR;
#line 499 "idl.re"
    { BOOST_WAVE_RET(T_CCOMMENT); }
#line 3677 "idl_re.cpp"
}
#line 547 "idl.re"


cppcomment:

#line 3684 "idl_re.cpp"
{
    YYCTYPE yych;
    if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
    yych = *YYCURSOR;
    if (yych <= 0x0A) {
        if (yych <= 0x00) goto yy381;
        if (yych <= 0x08) goto yy375;
        if (yych <= 0x09) goto yy379;
        goto yy376;
    } else {
        if (yych <= 0x0C) goto yy379;
        if (yych <= 0x0D) goto yy378;
        if (yych >= ' ') goto yy379;
    }
yy375:
yy376:
    ++YYCURSOR;
yy377:
#line 552 "idl.re"
    {
        /*if(cursor == s->eof) BOOST_WAVE_RET(T_EOF); */
        /*s->tok = cursor; */
        s->line++;
        BOOST_WAVE_RET(T_CPPCOMMENT);
    }
#line 3710 "idl_re.cpp"
yy378:
    yych = *++YYCURSOR;
    if (yych == 0x0A) goto yy383;
    goto yy377;
yy379:
    ++YYCURSOR;
#line 559 "idl.re"
    { goto cppcomment; }
#line 3719 "idl_re.cpp"
yy381:
    ++YYCURSOR;
#line 562 "idl.re"
    {
        using namespace std;      // some systems have printf in std
        if(cursor != s->eof) 
        {
            if (s->error_proc)
                (*s->error_proc)(s, 
                    cpplexer::lexing_exception::generic_lexing_error,
                    "'\\000' in input stream");
            else
                printf("Error: 0 in file");
        }
        /* adjust cursor such next call returns T_EOF */
        --YYCURSOR;
        /* the comment is unterminated, but nevertheless its a comment */
        BOOST_WAVE_RET(T_CPPCOMMENT);
    }
#line 3739 "idl_re.cpp"
yy383:
    ++YYCURSOR;
    yych = *YYCURSOR;
    goto yy377;
}
#line 578 "idl.re"


} /* end of scan */

#undef RE2C_ASSERT

///////////////////////////////////////////////////////////////////////////////
}   // namespace re2clex
}   // namespace idllexer
}   // namespace wave
}   // namespace boost
