/*
 * LIBOIL - Library of Optimized Inner Loops
 * Copyright (c) 2003,2004 David A. Schleef <ds@schleef.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LIBOIL_TYPES_H_
#define _LIBOIL_TYPES_H_

#include <liboil/liboil-stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * NULL:
 *
 * FIXME: gtk-doc is broken and doesn't know how to ignore this.
 */
#ifndef NULL
#define NULL ((void *)0)
#endif

/**
 * SECTION:liboiltypes
 * @short_description: Internal Liboil types
 */

typedef struct _OilFunctionClass OilFunctionClass;
typedef struct _OilFunctionImpl OilFunctionImpl;
typedef struct _OilParameter OilParameter;
typedef struct _OilTest OilTest;

typedef void (*OilTestFunction) (OilTest *test);

/**
 * oil_type_s8:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_s8 int8_t
/**
 * oil_type_u8:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_u8 uint8_t
/**
 * oil_type_s16:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_s16 int16_t
/**
 * oil_type_u16:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_u16 uint16_t
/**
 * oil_type_s32:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_s32 int32_t
/**
 * oil_type_u32:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_u32 uint32_t
/**
 * oil_type_s64:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_s64 int64_t
/**
 * oil_type_u64:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_u64 uint64_t
/**
 * oil_type_f32:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_f32 float
/**
 * oil_type_f64:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
#define oil_type_f64 double

#define oil_type_min_s8 (-128)
#define oil_type_min_u8 (0)
#define oil_type_min_s16 (-32768)
#define oil_type_min_u16 (0)
#define oil_type_min_s32 (-2147483647 - 1)
#define oil_type_min_u32 (0)

#define oil_type_max_s8 (127)
#define oil_type_max_u8 (255)
#define oil_type_max_s16 (32767)
#define oil_type_max_u16 (65535)
#define oil_type_max_s32 (2147483647)
#define oil_type_max_u32 (4294967295U)

/**
 * oil_type_min_s8:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_min_u8:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_min_s16:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_min_u16:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_min_s32:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_min_u32:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_min_f32:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_min_f64:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */

/**
 * oil_type_max_s8:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_max_u8:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_max_s16:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_max_u16:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_max_s32:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_max_u32:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_max_f32:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */
/**
 * oil_type_max_f64:
 *
 * Useful for autogenerated code.  Do not use otherwise.
 */

#ifdef __cplusplus
}
#endif

#endif

