/* gridframe.c generated by valac 0.40.8, the Vala compiler
 * generated from gridframe.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2015 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */
/* A container that guarantees that the internal allocated space is a fixed*/
/* multiple of an integer. This is a fairly literal translation of the LGPLv2+*/
/* original by Callum McKenzie, itself based on GtkFrame and GtkAspectFrame.*/


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define GAMES_TYPE_GRID_FRAME (games_grid_frame_get_type ())
#define GAMES_GRID_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GRID_FRAME, GamesGridFrame))
#define GAMES_GRID_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GRID_FRAME, GamesGridFrameClass))
#define GAMES_IS_GRID_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GRID_FRAME))
#define GAMES_IS_GRID_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GRID_FRAME))
#define GAMES_GRID_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GRID_FRAME, GamesGridFrameClass))

typedef struct _GamesGridFrame GamesGridFrame;
typedef struct _GamesGridFrameClass GamesGridFrameClass;
typedef struct _GamesGridFramePrivate GamesGridFramePrivate;
enum  {
	GAMES_GRID_FRAME_0_PROPERTY,
	GAMES_GRID_FRAME_XPADDING_PROPERTY,
	GAMES_GRID_FRAME_YPADDING_PROPERTY,
	GAMES_GRID_FRAME_WIDTH_PROPERTY,
	GAMES_GRID_FRAME_HEIGHT_PROPERTY,
	GAMES_GRID_FRAME_XALIGN_PROPERTY,
	GAMES_GRID_FRAME_YALIGN_PROPERTY,
	GAMES_GRID_FRAME_NUM_PROPERTIES
};
static GParamSpec* games_grid_frame_properties[GAMES_GRID_FRAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GamesGridFrame {
	GtkBin parent_instance;
	GamesGridFramePrivate * priv;
};

struct _GamesGridFrameClass {
	GtkBinClass parent_class;
};

struct _GamesGridFramePrivate {
	gint _xpadding;
	gint _ypadding;
	gint _xmult;
	gint _ymult;
	gfloat _xalign;
	gfloat _yalign;
	GtkAllocation old_allocation;
};


static gpointer games_grid_frame_parent_class = NULL;

GType games_grid_frame_get_type (void) G_GNUC_CONST;
#define GAMES_GRID_FRAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_GRID_FRAME, GamesGridFramePrivate))
GamesGridFrame* games_grid_frame_new (gint width,
                                      gint height);
GamesGridFrame* games_grid_frame_construct (GType object_type,
                                            gint width,
                                            gint height);
void games_grid_frame_set (GamesGridFrame* self,
                           gint width,
                           gint height);
void games_grid_frame_set_width (GamesGridFrame* self,
                                 gint value);
void games_grid_frame_set_height (GamesGridFrame* self,
                                  gint value);
void games_grid_frame_set_padding (GamesGridFrame* self,
                                   gint xpadding,
                                   gint ypadding);
void games_grid_frame_set_xpadding (GamesGridFrame* self,
                                    gint value);
void games_grid_frame_set_ypadding (GamesGridFrame* self,
                                    gint value);
void games_grid_frame_set_alignment (GamesGridFrame* self,
                                     gfloat xalign,
                                     gfloat yalign);
void games_grid_frame_set_xalign (GamesGridFrame* self,
                                  gfloat value);
void games_grid_frame_set_yalign (GamesGridFrame* self,
                                  gfloat value);
static void games_grid_frame_real_size_allocate (GtkWidget* base,
                                          GtkAllocation* allocation);
gint games_grid_frame_get_xpadding (GamesGridFrame* self);
gint games_grid_frame_get_ypadding (GamesGridFrame* self);
gint games_grid_frame_get_width (GamesGridFrame* self);
gint games_grid_frame_get_height (GamesGridFrame* self);
gfloat games_grid_frame_get_xalign (GamesGridFrame* self);
gfloat games_grid_frame_get_yalign (GamesGridFrame* self);
static void games_grid_frame_finalize (GObject * obj);
static void _vala_games_grid_frame_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_games_grid_frame_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);


GamesGridFrame*
games_grid_frame_construct (GType object_type,
                            gint width,
                            gint height)
{
	GamesGridFrame * self = NULL;
	self = (GamesGridFrame*) g_object_new (object_type, "width", width, "height", height, NULL);
	return self;
}


GamesGridFrame*
games_grid_frame_new (gint width,
                      gint height)
{
	return games_grid_frame_construct (GAMES_TYPE_GRID_FRAME, width, height);
}


void
games_grid_frame_set (GamesGridFrame* self,
                      gint width,
                      gint height)
{
	g_return_if_fail (self != NULL);
	games_grid_frame_set_width (self, width);
	games_grid_frame_set_height (self, height);
}


void
games_grid_frame_set_padding (GamesGridFrame* self,
                              gint xpadding,
                              gint ypadding)
{
	g_return_if_fail (self != NULL);
	games_grid_frame_set_xpadding (self, xpadding);
	games_grid_frame_set_ypadding (self, ypadding);
}


void
games_grid_frame_set_alignment (GamesGridFrame* self,
                                gfloat xalign,
                                gfloat yalign)
{
	g_return_if_fail (self != NULL);
	games_grid_frame_set_xalign (self, xalign);
	games_grid_frame_set_yalign (self, yalign);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static void
games_grid_frame_real_size_allocate (GtkWidget* base,
                                     GtkAllocation* allocation)
{
	GamesGridFrame * self;
	GtkAllocation _tmp0_;
	gint xsize = 0;
	GtkAllocation _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint ysize = 0;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint size = 0;
	gint _tmp9_;
	gint _tmp10_;
	GtkAllocation child_allocation = {0};
	GtkAllocation _tmp11_ = {0};
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GtkAllocation _tmp18_;
	gint _tmp19_;
	GtkAllocation _tmp20_;
	gint _tmp21_;
	gfloat _tmp22_;
	GtkAllocation _tmp23_;
	gint _tmp24_;
	GtkAllocation _tmp25_;
	gint _tmp26_;
	GtkAllocation _tmp27_;
	gint _tmp28_;
	gfloat _tmp29_;
	GtkAllocation _tmp30_;
	gint _tmp31_;
	gboolean _tmp32_ = FALSE;
	GtkWidget* child = NULL;
	GtkWidget* _tmp55_;
	GtkWidget* _tmp56_;
	gboolean _tmp57_ = FALSE;
	GtkWidget* _tmp58_;
	GtkAllocation _tmp62_;
	self = (GamesGridFrame*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (games_grid_frame_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin), &_tmp0_);
	_tmp1_ = *allocation;
	_tmp2_ = _tmp1_.width;
	_tmp3_ = self->priv->_xpadding;
	_tmp4_ = self->priv->_xmult;
	xsize = MAX (1, (_tmp2_ - _tmp3_) / _tmp4_);
	_tmp5_ = *allocation;
	_tmp6_ = _tmp5_.height;
	_tmp7_ = self->priv->_ypadding;
	_tmp8_ = self->priv->_ymult;
	ysize = MAX (1, (_tmp6_ - _tmp7_) / _tmp8_);
	_tmp9_ = xsize;
	_tmp10_ = ysize;
	size = MIN (_tmp9_, _tmp10_);
	_tmp11_.x = 0;
	_tmp11_.y = 0;
	_tmp11_.width = 0;
	_tmp11_.height = 0;
	child_allocation = _tmp11_;
	_tmp12_ = size;
	_tmp13_ = self->priv->_xmult;
	_tmp14_ = self->priv->_xpadding;
	child_allocation.width = (_tmp12_ * _tmp13_) + _tmp14_;
	_tmp15_ = size;
	_tmp16_ = self->priv->_ymult;
	_tmp17_ = self->priv->_ypadding;
	child_allocation.height = (_tmp15_ * _tmp16_) + _tmp17_;
	_tmp18_ = *allocation;
	_tmp19_ = _tmp18_.width;
	_tmp20_ = child_allocation;
	_tmp21_ = _tmp20_.width;
	_tmp22_ = self->priv->_xalign;
	_tmp23_ = *allocation;
	_tmp24_ = _tmp23_.x;
	child_allocation.x = (gint) (((_tmp19_ - _tmp21_) * _tmp22_) + _tmp24_);
	_tmp25_ = *allocation;
	_tmp26_ = _tmp25_.height;
	_tmp27_ = child_allocation;
	_tmp28_ = _tmp27_.height;
	_tmp29_ = self->priv->_yalign;
	_tmp30_ = *allocation;
	_tmp31_ = _tmp30_.y;
	child_allocation.y = (gint) (((_tmp26_ - _tmp28_) * _tmp29_) + _tmp31_);
	if (gtk_widget_get_mapped ((GtkWidget*) self)) {
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		GtkAllocation _tmp36_;
		gint _tmp37_;
		GtkAllocation _tmp38_;
		gint _tmp39_;
		_tmp36_ = child_allocation;
		_tmp37_ = _tmp36_.x;
		_tmp38_ = self->priv->old_allocation;
		_tmp39_ = _tmp38_.x;
		if (_tmp37_ != _tmp39_) {
			_tmp35_ = TRUE;
		} else {
			GtkAllocation _tmp40_;
			gint _tmp41_;
			GtkAllocation _tmp42_;
			gint _tmp43_;
			_tmp40_ = child_allocation;
			_tmp41_ = _tmp40_.y;
			_tmp42_ = self->priv->old_allocation;
			_tmp43_ = _tmp42_.y;
			_tmp35_ = _tmp41_ != _tmp43_;
		}
		if (_tmp35_) {
			_tmp34_ = TRUE;
		} else {
			GtkAllocation _tmp44_;
			gint _tmp45_;
			GtkAllocation _tmp46_;
			gint _tmp47_;
			_tmp44_ = child_allocation;
			_tmp45_ = _tmp44_.width;
			_tmp46_ = self->priv->old_allocation;
			_tmp47_ = _tmp46_.width;
			_tmp34_ = _tmp45_ != _tmp47_;
		}
		if (_tmp34_) {
			_tmp33_ = TRUE;
		} else {
			GtkAllocation _tmp48_;
			gint _tmp49_;
			GtkAllocation _tmp50_;
			gint _tmp51_;
			_tmp48_ = child_allocation;
			_tmp49_ = _tmp48_.height;
			_tmp50_ = self->priv->old_allocation;
			_tmp51_ = _tmp50_.height;
			_tmp33_ = _tmp49_ != _tmp51_;
		}
		_tmp32_ = _tmp33_;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GdkWindow* _tmp52_;
		GtkAllocation _tmp53_;
		GdkRectangle _tmp54_;
		_tmp52_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp53_ = *allocation;
		_tmp54_ = _tmp53_;
		gdk_window_invalidate_rect (_tmp52_, &_tmp54_, FALSE);
	}
	_tmp55_ = gtk_bin_get_child ((GtkBin*) self);
	_tmp56_ = _g_object_ref0 (_tmp55_);
	child = _tmp56_;
	_tmp58_ = child;
	if (_tmp58_ != NULL) {
		GtkWidget* _tmp59_;
		_tmp59_ = child;
		_tmp57_ = gtk_widget_get_visible (_tmp59_);
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		GtkWidget* _tmp60_;
		GtkAllocation _tmp61_;
		_tmp60_ = child;
		_tmp61_ = child_allocation;
		gtk_widget_size_allocate (_tmp60_, &_tmp61_);
	}
	_tmp62_ = child_allocation;
	self->priv->old_allocation = _tmp62_;
	_g_object_unref0 (child);
}


gint
games_grid_frame_get_xpadding (GamesGridFrame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_xpadding;
	result = _tmp0_;
	return result;
}


void
games_grid_frame_set_xpadding (GamesGridFrame* self,
                               gint value)
{
	g_return_if_fail (self != NULL);
	if (value >= 0) {
		self->priv->_xpadding = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_XPADDING_PROPERTY]);
}


gint
games_grid_frame_get_ypadding (GamesGridFrame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_ypadding;
	result = _tmp0_;
	return result;
}


void
games_grid_frame_set_ypadding (GamesGridFrame* self,
                               gint value)
{
	g_return_if_fail (self != NULL);
	if (value >= 0) {
		self->priv->_ypadding = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_YPADDING_PROPERTY]);
}


gint
games_grid_frame_get_width (GamesGridFrame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_xmult;
	result = _tmp0_;
	return result;
}


void
games_grid_frame_set_width (GamesGridFrame* self,
                            gint value)
{
	g_return_if_fail (self != NULL);
	if (value > 0) {
		self->priv->_xmult = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_WIDTH_PROPERTY]);
}


gint
games_grid_frame_get_height (GamesGridFrame* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_ymult;
	result = _tmp0_;
	return result;
}


void
games_grid_frame_set_height (GamesGridFrame* self,
                             gint value)
{
	g_return_if_fail (self != NULL);
	if (value > 0) {
		self->priv->_ymult = value;
		gtk_widget_queue_resize ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_HEIGHT_PROPERTY]);
}


gfloat
games_grid_frame_get_xalign (GamesGridFrame* self)
{
	gfloat result;
	gfloat _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->_xalign;
	result = _tmp0_;
	return result;
}


void
games_grid_frame_set_xalign (GamesGridFrame* self,
                             gfloat value)
{
	g_return_if_fail (self != NULL);
	self->priv->_xalign = CLAMP (value, 0.0f, 1.0f);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_XALIGN_PROPERTY]);
}


gfloat
games_grid_frame_get_yalign (GamesGridFrame* self)
{
	gfloat result;
	gfloat _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->_yalign;
	result = _tmp0_;
	return result;
}


void
games_grid_frame_set_yalign (GamesGridFrame* self,
                             gfloat value)
{
	g_return_if_fail (self != NULL);
	self->priv->_yalign = CLAMP (value, 0.0f, 1.0f);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, games_grid_frame_properties[GAMES_GRID_FRAME_YALIGN_PROPERTY]);
}


static void
games_grid_frame_class_init (GamesGridFrameClass * klass)
{
	games_grid_frame_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesGridFramePrivate));
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget *, GtkAllocation*)) games_grid_frame_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_grid_frame_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_grid_frame_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_grid_frame_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_XPADDING_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_XPADDING_PROPERTY] = g_param_spec_int ("xpadding", "xpadding", "xpadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_YPADDING_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_YPADDING_PROPERTY] = g_param_spec_int ("ypadding", "ypadding", "ypadding", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_WIDTH_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_HEIGHT_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_XALIGN_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_XALIGN_PROPERTY] = g_param_spec_float ("xalign", "xalign", "xalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GRID_FRAME_YALIGN_PROPERTY, games_grid_frame_properties[GAMES_GRID_FRAME_YALIGN_PROPERTY] = g_param_spec_float ("yalign", "yalign", "yalign", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
games_grid_frame_instance_init (GamesGridFrame * self)
{
	self->priv = GAMES_GRID_FRAME_GET_PRIVATE (self);
	self->priv->_xpadding = 0;
	self->priv->_ypadding = 0;
	self->priv->_xmult = 1;
	self->priv->_ymult = 1;
	self->priv->_xalign = 0.5f;
	self->priv->_yalign = 0.5f;
}


static void
games_grid_frame_finalize (GObject * obj)
{
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
	G_OBJECT_CLASS (games_grid_frame_parent_class)->finalize (obj);
}


GType
games_grid_frame_get_type (void)
{
	static volatile gsize games_grid_frame_type_id__volatile = 0;
	if (g_once_init_enter (&games_grid_frame_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesGridFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_grid_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGridFrame), 0, (GInstanceInitFunc) games_grid_frame_instance_init, NULL };
		GType games_grid_frame_type_id;
		games_grid_frame_type_id = g_type_register_static (gtk_bin_get_type (), "GamesGridFrame", &g_define_type_info, 0);
		g_once_init_leave (&games_grid_frame_type_id__volatile, games_grid_frame_type_id);
	}
	return games_grid_frame_type_id__volatile;
}


static void
_vala_games_grid_frame_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
	switch (property_id) {
		case GAMES_GRID_FRAME_XPADDING_PROPERTY:
		g_value_set_int (value, games_grid_frame_get_xpadding (self));
		break;
		case GAMES_GRID_FRAME_YPADDING_PROPERTY:
		g_value_set_int (value, games_grid_frame_get_ypadding (self));
		break;
		case GAMES_GRID_FRAME_WIDTH_PROPERTY:
		g_value_set_int (value, games_grid_frame_get_width (self));
		break;
		case GAMES_GRID_FRAME_HEIGHT_PROPERTY:
		g_value_set_int (value, games_grid_frame_get_height (self));
		break;
		case GAMES_GRID_FRAME_XALIGN_PROPERTY:
		g_value_set_float (value, games_grid_frame_get_xalign (self));
		break;
		case GAMES_GRID_FRAME_YALIGN_PROPERTY:
		g_value_set_float (value, games_grid_frame_get_yalign (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_games_grid_frame_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GamesGridFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GRID_FRAME, GamesGridFrame);
	switch (property_id) {
		case GAMES_GRID_FRAME_XPADDING_PROPERTY:
		games_grid_frame_set_xpadding (self, g_value_get_int (value));
		break;
		case GAMES_GRID_FRAME_YPADDING_PROPERTY:
		games_grid_frame_set_ypadding (self, g_value_get_int (value));
		break;
		case GAMES_GRID_FRAME_WIDTH_PROPERTY:
		games_grid_frame_set_width (self, g_value_get_int (value));
		break;
		case GAMES_GRID_FRAME_HEIGHT_PROPERTY:
		games_grid_frame_set_height (self, g_value_get_int (value));
		break;
		case GAMES_GRID_FRAME_XALIGN_PROPERTY:
		games_grid_frame_set_xalign (self, g_value_get_float (value));
		break;
		case GAMES_GRID_FRAME_YALIGN_PROPERTY:
		games_grid_frame_set_yalign (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



