/*
 * Gksu -- a library providing access to su functionality
 * Copyright (C) 2004 Gustavo Noronha Silva
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>

#include "gksu.h"

int
main ()
{
  GksuContext *context;
  GError *error = NULL;
  char *password;

  context = gksu_context_new ();

  gksu_context_set_debug (context, TRUE);
  gksu_context_set_command (context, "/usr/bin/X11/xterm");

  password = getpass ("Type the root password: ");
  gksu_context_set_password (context, password);
  
  printf ("Testing gksu_run...\n");
  gksu_context_run (context, &error);
  if (error)
    fprintf (stderr, "gksu_run failed: %s\n", error->message);
  
  error = NULL;
  /* sudo may already have my authorization */
  gksu_context_set_password (context, "");
  gksu_context_sudo_run (context, &error);
  if (error)
    {
      password = NULL;
      password = getpass ("Type your password(sudo): ");
      gksu_context_set_password (context, password);
      
      /* of course you need to set up /etc/sudoers for this to work */
      printf ("Testing gksu_sudo_run...\n");
      error = NULL;
      gksu_context_sudo_run (context, &error);
      if (error)
	fprintf (stderr, "gksu_run failed: %s\n", error->message);
    }

  return 0;
}

