#ifndef CACHE_COMPONENT_DEBTAGS_PKGIDX_H
#define CACHE_COMPONENT_DEBTAGS_PKGIDX_H

/** @file
 * @author Enrico Zini <enrico@enricozini.org>
 * Quick map from package IDs to package names
 */

/*
 * Copyright (C) 2003-2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <apt-front/cache/component/base.h>
#include <tagcoll/MMapIndex.h>

#include <string>
#include <vector>
#include <map>

namespace aptFront {
namespace cache {
namespace component {
namespace debtags {

class PkgIdx : public Implementation<PkgIdx>, public Tagcoll::MMapIndex
{
	Tagcoll::MasterMMapIndex mastermmap;
	time_t m_timestamp;

public:
	PkgIdx() {}
	void init(Cache& c);

	time_t timestamp() const { return m_timestamp; }

	/// Get the number of packages in the index
	size_t size() const { return *(int*)m_buf / sizeof(int); }

	const char* name(int id) const
	{
		if (id >= 0 || (unsigned)id < size())
			return m_buf + ((int*)m_buf)[id];
		return NULL;
	}
	int size(int id) const
	{
		if (id < 0 || (unsigned)id >= size())
			return 0;
		if ((unsigned)id == size() - 1)
			return m_size - ((int*)m_buf)[id] - 1;
		else
			return ((int*)m_buf)[id + 1] - ((int*)m_buf)[id] - 1;
	}

	static std::string componentName();
	static time_t computeTimestamp();
};

}
}
}
}

// vim:set ts=4 sw=4:
#endif
