package main

import (
	"sort"
	"testing"

	"github.com/stretchr/testify/suite"
)

type utilsTestSuite struct {
	suite.Suite
}

func TestUtilsTestSuite(t *testing.T) {
	suite.Run(t, new(utilsTestSuite))
}

// StringList can be used to sort a list of strings.
func (s *utilsTestSuite) Test_StringList() {
	data := [][]string{{"foo", "bar"}, {"baz", "bza"}}
	sort.Sort(StringList(data))
	s.Equal([][]string{{"baz", "bza"}, {"foo", "bar"}}, data)
}

// The first different string is used in sorting.
func (s *utilsTestSuite) Test_StringList_sort_by_column() {
	data := [][]string{{"foo", "baz"}, {"foo", "bar"}}
	sort.Sort(StringList(data))
	s.Equal([][]string{{"foo", "bar"}, {"foo", "baz"}}, data)
}

// Empty strings are sorted last.
func (s *utilsTestSuite) Test_StringList_empty_strings() {
	data := [][]string{{"", "bar"}, {"foo", "baz"}}
	sort.Sort(StringList(data))
	s.Equal([][]string{{"foo", "baz"}, {"", "bar"}}, data)
}
