-- This file is generated by SWIG. Do *not* modify by hand.
--

with Interfaces.C.Strings;


package llvm.Binding is

   procedure LLVMDisposeMessage
     (Message : in Interfaces.C.Strings.chars_ptr);

   function LLVMContextCreate return  llvm.LLVMContextRef;

   function LLVMGetGlobalContext return  llvm.LLVMContextRef;

   procedure LLVMContextDispose (C : in llvm.LLVMContextRef);

   function LLVMModuleCreateWithName
     (ModuleID : in Interfaces.C.Strings.chars_ptr)
      return     llvm.LLVMModuleRef;

   function LLVMModuleCreateWithNameInContext
     (ModuleID : in Interfaces.C.Strings.chars_ptr;
      C        : in llvm.LLVMContextRef)
      return     llvm.LLVMModuleRef;

   procedure LLVMDisposeModule (M : in llvm.LLVMModuleRef);

   function LLVMGetDataLayout
     (M    : in llvm.LLVMModuleRef)
      return Interfaces.C.Strings.chars_ptr;

   procedure LLVMSetDataLayout
     (M      : in llvm.LLVMModuleRef;
      Triple : in Interfaces.C.Strings.chars_ptr);

   function LLVMGetTarget
     (M    : in llvm.LLVMModuleRef)
      return Interfaces.C.Strings.chars_ptr;

   procedure LLVMSetTarget
     (M      : in llvm.LLVMModuleRef;
      Triple : in Interfaces.C.Strings.chars_ptr);

   function LLVMAddTypeName
     (M    : in llvm.LLVMModuleRef;
      Name : in Interfaces.C.Strings.chars_ptr;
      Ty   : in llvm.LLVMTypeRef)
      return Interfaces.C.int;

   procedure LLVMDeleteTypeName
     (M    : in llvm.LLVMModuleRef;
      Name : in Interfaces.C.Strings.chars_ptr);

   function LLVMGetTypeByName
     (M    : in llvm.LLVMModuleRef;
      Name : in Interfaces.C.Strings.chars_ptr)
      return llvm.LLVMTypeRef;

   procedure LLVMDumpModule (M : in llvm.LLVMModuleRef);

   function LLVMGetTypeKind
     (Ty   : in llvm.LLVMTypeRef)
      return llvm.LLVMTypeKind;

   function LLVMInt1Type return  llvm.LLVMTypeRef;

   function LLVMInt8Type return  llvm.LLVMTypeRef;

   function LLVMInt16Type return  llvm.LLVMTypeRef;

   function LLVMInt32Type return  llvm.LLVMTypeRef;

   function LLVMInt64Type return  llvm.LLVMTypeRef;

   function LLVMIntType
     (NumBits : in Interfaces.C.unsigned)
      return    llvm.LLVMTypeRef;

   function LLVMGetIntTypeWidth
     (IntegerTy : in llvm.LLVMTypeRef)
      return      Interfaces.C.unsigned;

   function LLVMFloatType return  llvm.LLVMTypeRef;

   function LLVMDoubleType return  llvm.LLVMTypeRef;

   function LLVMX86FP80Type return  llvm.LLVMTypeRef;

   function LLVMFP128Type return  llvm.LLVMTypeRef;

   function LLVMPPCFP128Type return  llvm.LLVMTypeRef;

   function LLVMFunctionType
     (ReturnType : in llvm.LLVMTypeRef;
      ParamTypes : access llvm.LLVMTypeRef;
      ParamCount : in Interfaces.C.unsigned;
      IsVarArg   : in Interfaces.C.int)
      return       llvm.LLVMTypeRef;

   function LLVMIsFunctionVarArg
     (FunctionTy : in llvm.LLVMTypeRef)
      return       Interfaces.C.int;

   function LLVMGetReturnType
     (FunctionTy : in llvm.LLVMTypeRef)
      return       llvm.LLVMTypeRef;

   function LLVMCountParamTypes
     (FunctionTy : in llvm.LLVMTypeRef)
      return       Interfaces.C.unsigned;

   procedure LLVMGetParamTypes
     (FunctionTy : in llvm.LLVMTypeRef;
      Dest       : access llvm.LLVMTypeRef);

   function LLVMStructType
     (ElementTypes : access llvm.LLVMTypeRef;
      ElementCount : in Interfaces.C.unsigned;
      Packed       : in Interfaces.C.int)
      return         llvm.LLVMTypeRef;

   function LLVMCountStructElementTypes
     (StructTy : in llvm.LLVMTypeRef)
      return     Interfaces.C.unsigned;

   procedure LLVMGetStructElementTypes
     (StructTy : in llvm.LLVMTypeRef;
      Dest     : access llvm.LLVMTypeRef);

   function LLVMIsPackedStruct
     (StructTy : in llvm.LLVMTypeRef)
      return     Interfaces.C.int;

   function LLVMArrayType
     (ElementType  : in llvm.LLVMTypeRef;
      ElementCount : in Interfaces.C.unsigned)
      return         llvm.LLVMTypeRef;

   function LLVMPointerType
     (ElementType  : in llvm.LLVMTypeRef;
      AddressSpace : in Interfaces.C.unsigned)
      return         llvm.LLVMTypeRef;

   function LLVMVectorType
     (ElementType  : in llvm.LLVMTypeRef;
      ElementCount : in Interfaces.C.unsigned)
      return         llvm.LLVMTypeRef;

   function LLVMGetElementType
     (Ty   : in llvm.LLVMTypeRef)
      return llvm.LLVMTypeRef;

   function LLVMGetArrayLength
     (ArrayTy : in llvm.LLVMTypeRef)
      return    Interfaces.C.unsigned;

   function LLVMGetPointerAddressSpace
     (PointerTy : in llvm.LLVMTypeRef)
      return      Interfaces.C.unsigned;

   function LLVMGetVectorSize
     (VectorTy : in llvm.LLVMTypeRef)
      return     Interfaces.C.unsigned;

   function LLVMVoidType return  llvm.LLVMTypeRef;

   function LLVMLabelType return  llvm.LLVMTypeRef;

   function LLVMOpaqueType return  llvm.LLVMTypeRef;

   function LLVMCreateTypeHandle
     (PotentiallyAbstractTy : in llvm.LLVMTypeRef)
      return                  llvm.LLVMTypeHandleRef;

   procedure LLVMRefineType
     (AbstractTy : in llvm.LLVMTypeRef;
      ConcreteTy : in llvm.LLVMTypeRef);

   function LLVMResolveTypeHandle
     (TypeHandle : in llvm.LLVMTypeHandleRef)
      return       llvm.LLVMTypeRef;

   procedure LLVMDisposeTypeHandle (TypeHandle : in llvm.LLVMTypeHandleRef);

   function LLVMTypeOf (Val : in llvm.LLVMValueRef) return llvm.LLVMTypeRef;

   function LLVMGetValueName
     (Val  : in llvm.LLVMValueRef)
      return Interfaces.C.Strings.chars_ptr;

   procedure LLVMSetValueName
     (Val  : in llvm.LLVMValueRef;
      Name : in Interfaces.C.Strings.chars_ptr);

   procedure LLVMDumpValue (Val : in llvm.LLVMValueRef);

   function LLVMIsAArgument
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsABasicBlock
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAInlineAsm
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAUser
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAConstant
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAConstantAggregateZero
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAConstantArray
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAConstantExpr
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAConstantFP
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAConstantInt
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAConstantPointerNull
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAConstantStruct
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAConstantVector
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAGlobalValue
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAFunction
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAGlobalAlias
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAGlobalVariable
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAUndefValue
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAInstruction
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsABinaryOperator
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsACallInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAIntrinsicInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsADbgInfoIntrinsic
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsADbgDeclareInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsADbgFuncStartInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsADbgRegionEndInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsADbgRegionStartInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsADbgStopPointInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAEHSelectorInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAMemIntrinsic
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAMemCpyInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAMemMoveInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAMemSetInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsACmpInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAFCmpInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAICmpInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAExtractElementInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAGetElementPtrInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAInsertElementInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAInsertValueInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAPHINode
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsASelectInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAShuffleVectorInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAStoreInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsATerminatorInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsABranchInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAInvokeInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAReturnInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsASwitchInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAUnreachableInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAUnwindInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAUnaryInstruction
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAAllocationInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAAllocaInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAMallocInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsACastInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsABitCastInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAFPExtInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAFPToSIInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAFPToUIInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAFPTruncInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAIntToPtrInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAPtrToIntInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsASExtInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsASIToFPInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsATruncInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAUIToFPInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAZExtInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAExtractValueInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAFreeInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsALoadInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMIsAVAArgInst
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMConstNull
     (Ty   : in llvm.LLVMTypeRef)
      return llvm.LLVMValueRef;

   function LLVMConstAllOnes
     (Ty   : in llvm.LLVMTypeRef)
      return llvm.LLVMValueRef;

   function LLVMGetUndef
     (Ty   : in llvm.LLVMTypeRef)
      return llvm.LLVMValueRef;

   function LLVMIsConstant
     (Val  : in llvm.LLVMValueRef)
      return Interfaces.C.int;

   function LLVMIsNull (Val : in llvm.LLVMValueRef) return Interfaces.C.int;

   function LLVMIsUndef
     (Val  : in llvm.LLVMValueRef)
      return Interfaces.C.int;

   function LLVMConstPointerNull
     (Ty   : in llvm.LLVMTypeRef)
      return llvm.LLVMValueRef;

   function LLVMConstInt
     (IntTy      : in llvm.LLVMTypeRef;
      N          : in Interfaces.C.Extensions.unsigned_long_long;
      SignExtend : in Interfaces.C.int)
      return       llvm.LLVMValueRef;

   function LLVMConstReal
     (RealTy : in llvm.LLVMTypeRef;
      N      : in Interfaces.C.double)
      return   llvm.LLVMValueRef;

   function LLVMConstRealOfString
     (RealTy : in llvm.LLVMTypeRef;
      Text   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMConstString
     (Str               : in Interfaces.C.Strings.chars_ptr;
      Length            : in Interfaces.C.unsigned;
      DontNullTerminate : in Interfaces.C.int)
      return              llvm.LLVMValueRef;

   function LLVMConstArray
     (ElementTy    : in llvm.LLVMTypeRef;
      ConstantVals : access llvm.LLVMValueRef;
      Length       : in Interfaces.C.unsigned)
      return         llvm.LLVMValueRef;

   function LLVMConstStruct
     (ConstantVals : access llvm.LLVMValueRef;
      Count        : in Interfaces.C.unsigned;
      packed       : in Interfaces.C.int)
      return         llvm.LLVMValueRef;

   function LLVMConstVector
     (ScalarConstantVals : access llvm.LLVMValueRef;
      Size               : in Interfaces.C.unsigned)
      return               llvm.LLVMValueRef;

   function LLVMSizeOf (Ty : in llvm.LLVMTypeRef) return llvm.LLVMValueRef;

   function LLVMConstNeg
     (ConstantVal : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstNot
     (ConstantVal : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstAdd
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstSub
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstMul
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstUDiv
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstSDiv
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstFDiv
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstURem
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstSRem
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstFRem
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstAnd
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstOr
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstXor
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstICmp
     (Predicate   : in llvm.LLVMIntPredicate;
      LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstFCmp
     (Predicate   : in llvm.LLVMRealPredicate;
      LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstShl
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstLShr
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstAShr
     (LHSConstant : in llvm.LLVMValueRef;
      RHSConstant : in llvm.LLVMValueRef)
      return        llvm.LLVMValueRef;

   function LLVMConstGEP
     (ConstantVal     : in llvm.LLVMValueRef;
      ConstantIndices : access llvm.LLVMValueRef;
      NumIndices      : in Interfaces.C.unsigned)
      return            llvm.LLVMValueRef;

   function LLVMConstTrunc
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstSExt
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstZExt
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstFPTrunc
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstFPExt
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstUIToFP
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstSIToFP
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstFPToUI
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstFPToSI
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstPtrToInt
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstIntToPtr
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstBitCast
     (ConstantVal : in llvm.LLVMValueRef;
      ToType      : in llvm.LLVMTypeRef)
      return        llvm.LLVMValueRef;

   function LLVMConstSelect
     (ConstantCondition : in llvm.LLVMValueRef;
      ConstantIfTrue    : in llvm.LLVMValueRef;
      ConstantIfFalse   : in llvm.LLVMValueRef)
      return              llvm.LLVMValueRef;

   function LLVMConstExtractElement
     (VectorConstant : in llvm.LLVMValueRef;
      IndexConstant  : in llvm.LLVMValueRef)
      return           llvm.LLVMValueRef;

   function LLVMConstInsertElement
     (VectorConstant       : in llvm.LLVMValueRef;
      ElementValueConstant : in llvm.LLVMValueRef;
      IndexConstant        : in llvm.LLVMValueRef)
      return                 llvm.LLVMValueRef;

   function LLVMConstShuffleVector
     (VectorAConstant : in llvm.LLVMValueRef;
      VectorBConstant : in llvm.LLVMValueRef;
      MaskConstant    : in llvm.LLVMValueRef)
      return            llvm.LLVMValueRef;

   function LLVMConstExtractValue
     (AggConstant : in llvm.LLVMValueRef;
      IdxList     : access Interfaces.C.unsigned;
      NumIdx      : in Interfaces.C.unsigned)
      return        llvm.LLVMValueRef;

   function LLVMConstInsertValue
     (AggConstant          : in llvm.LLVMValueRef;
      ElementValueConstant : in llvm.LLVMValueRef;
      IdxList              : access Interfaces.C.unsigned;
      NumIdx               : in Interfaces.C.unsigned)
      return                 llvm.LLVMValueRef;

   function LLVMConstInlineAsm
     (Ty             : in llvm.LLVMTypeRef;
      AsmString      : in Interfaces.C.Strings.chars_ptr;
      Constraints    : in Interfaces.C.Strings.chars_ptr;
      HasSideEffects : in Interfaces.C.int)
      return           llvm.LLVMValueRef;

   function LLVMGetGlobalParent
     (Global : in llvm.LLVMValueRef)
      return   llvm.LLVMModuleRef;

   function LLVMIsDeclaration
     (Global : in llvm.LLVMValueRef)
      return   Interfaces.C.int;

   function LLVMGetLinkage
     (Global : in llvm.LLVMValueRef)
      return   llvm.LLVMLinkage;

   procedure LLVMSetLinkage
     (Global  : in llvm.LLVMValueRef;
      Linkage : in llvm.LLVMLinkage);

   function LLVMGetSection
     (Global : in llvm.LLVMValueRef)
      return   Interfaces.C.Strings.chars_ptr;

   procedure LLVMSetSection
     (Global  : in llvm.LLVMValueRef;
      Section : in Interfaces.C.Strings.chars_ptr);

   function LLVMGetVisibility
     (Global : in llvm.LLVMValueRef)
      return   llvm.LLVMVisibility;

   procedure LLVMSetVisibility
     (Global : in llvm.LLVMValueRef;
      Viz    : in llvm.LLVMVisibility);

   function LLVMGetAlignment
     (Global : in llvm.LLVMValueRef)
      return   Interfaces.C.unsigned;

   procedure LLVMSetAlignment
     (Global : in llvm.LLVMValueRef;
      Bytes  : in Interfaces.C.unsigned);

   function LLVMAddGlobal
     (M    : in llvm.LLVMModuleRef;
      Ty   : in llvm.LLVMTypeRef;
      Name : in Interfaces.C.Strings.chars_ptr)
      return llvm.LLVMValueRef;

   function LLVMGetNamedGlobal
     (M    : in llvm.LLVMModuleRef;
      Name : in Interfaces.C.Strings.chars_ptr)
      return llvm.LLVMValueRef;

   function LLVMGetFirstGlobal
     (M    : in llvm.LLVMModuleRef)
      return llvm.LLVMValueRef;

   function LLVMGetLastGlobal
     (M    : in llvm.LLVMModuleRef)
      return llvm.LLVMValueRef;

   function LLVMGetNextGlobal
     (GlobalVar : in llvm.LLVMValueRef)
      return      llvm.LLVMValueRef;

   function LLVMGetPreviousGlobal
     (GlobalVar : in llvm.LLVMValueRef)
      return      llvm.LLVMValueRef;

   procedure LLVMDeleteGlobal (GlobalVar : in llvm.LLVMValueRef);

   function LLVMGetInitializer
     (GlobalVar : in llvm.LLVMValueRef)
      return      llvm.LLVMValueRef;

   procedure LLVMSetInitializer
     (GlobalVar   : in llvm.LLVMValueRef;
      ConstantVal : in llvm.LLVMValueRef);

   function LLVMIsThreadLocal
     (GlobalVar : in llvm.LLVMValueRef)
      return      Interfaces.C.int;

   procedure LLVMSetThreadLocal
     (GlobalVar     : in llvm.LLVMValueRef;
      IsThreadLocal : in Interfaces.C.int);

   function LLVMIsGlobalConstant
     (GlobalVar : in llvm.LLVMValueRef)
      return      Interfaces.C.int;

   procedure LLVMSetGlobalConstant
     (GlobalVar  : in llvm.LLVMValueRef;
      IsConstant : in Interfaces.C.int);

   function LLVMAddAlias
     (M       : in llvm.LLVMModuleRef;
      Ty      : in llvm.LLVMTypeRef;
      Aliasee : in llvm.LLVMValueRef;
      Name    : in Interfaces.C.Strings.chars_ptr)
      return    llvm.LLVMValueRef;

   function LLVMAddFunction
     (M          : in llvm.LLVMModuleRef;
      Name       : in Interfaces.C.Strings.chars_ptr;
      FunctionTy : in llvm.LLVMTypeRef)
      return       llvm.LLVMValueRef;

   function LLVMGetNamedFunction
     (M    : in llvm.LLVMModuleRef;
      Name : in Interfaces.C.Strings.chars_ptr)
      return llvm.LLVMValueRef;

   function LLVMGetFirstFunction
     (M    : in llvm.LLVMModuleRef)
      return llvm.LLVMValueRef;

   function LLVMGetLastFunction
     (M    : in llvm.LLVMModuleRef)
      return llvm.LLVMValueRef;

   function LLVMGetNextFunction
     (Fn   : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMGetPreviousFunction
     (Fn   : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   procedure LLVMDeleteFunction (Fn : in llvm.LLVMValueRef);

   function LLVMGetIntrinsicID
     (Fn   : in llvm.LLVMValueRef)
      return Interfaces.C.unsigned;

   function LLVMGetFunctionCallConv
     (Fn   : in llvm.LLVMValueRef)
      return Interfaces.C.unsigned;

   procedure LLVMSetFunctionCallConv
     (Fn : in llvm.LLVMValueRef;
      CC : in Interfaces.C.unsigned);

   function LLVMGetGC
     (Fn   : in llvm.LLVMValueRef)
      return Interfaces.C.Strings.chars_ptr;

   procedure LLVMSetGC
     (Fn   : in llvm.LLVMValueRef;
      Name : in Interfaces.C.Strings.chars_ptr);

   procedure LLVMAddFunctionAttr
     (Fn : in llvm.LLVMValueRef;
      PA : in llvm.LLVMAttribute);

   procedure LLVMRemoveFunctionAttr
     (Fn : in llvm.LLVMValueRef;
      PA : in llvm.LLVMAttribute);

   function LLVMCountParams
     (Fn   : in llvm.LLVMValueRef)
      return Interfaces.C.unsigned;

   procedure LLVMGetParams
     (Fn     : in llvm.LLVMValueRef;
      Params : access llvm.LLVMValueRef);

   function LLVMGetParam
     (Fn    : in llvm.LLVMValueRef;
      Index : in Interfaces.C.unsigned)
      return  llvm.LLVMValueRef;

   function LLVMGetParamParent
     (Inst : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMGetFirstParam
     (Fn   : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMGetLastParam
     (Fn   : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMGetNextParam
     (Arg  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMGetPreviousParam
     (Arg  : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   procedure LLVMAddAttribute
     (Arg : in llvm.LLVMValueRef;
      PA  : in llvm.LLVMAttribute);

   procedure LLVMRemoveAttribute
     (Arg : in llvm.LLVMValueRef;
      PA  : in llvm.LLVMAttribute);

   procedure LLVMSetParamAlignment
     (Arg   : in llvm.LLVMValueRef;
      align : in Interfaces.C.unsigned);

   function LLVMBasicBlockAsValue
     (BB   : in llvm.LLVMBasicBlockRef)
      return llvm.LLVMValueRef;

   function LLVMValueIsBasicBlock
     (Val  : in llvm.LLVMValueRef)
      return Interfaces.C.int;

   function LLVMValueAsBasicBlock
     (Val  : in llvm.LLVMValueRef)
      return llvm.LLVMBasicBlockRef;

   function LLVMGetBasicBlockParent
     (BB   : in llvm.LLVMBasicBlockRef)
      return llvm.LLVMValueRef;

   function LLVMCountBasicBlocks
     (Fn   : in llvm.LLVMValueRef)
      return Interfaces.C.unsigned;

   procedure LLVMGetBasicBlocks
     (Fn          : in llvm.LLVMValueRef;
      BasicBlocks : access llvm.LLVMBasicBlockRef);

   function LLVMGetFirstBasicBlock
     (Fn   : in llvm.LLVMValueRef)
      return llvm.LLVMBasicBlockRef;

   function LLVMGetLastBasicBlock
     (Fn   : in llvm.LLVMValueRef)
      return llvm.LLVMBasicBlockRef;

   function LLVMGetNextBasicBlock
     (BB   : in llvm.LLVMBasicBlockRef)
      return llvm.LLVMBasicBlockRef;

   function LLVMGetPreviousBasicBlock
     (BB   : in llvm.LLVMBasicBlockRef)
      return llvm.LLVMBasicBlockRef;

   function LLVMGetEntryBasicBlock
     (Fn   : in llvm.LLVMValueRef)
      return llvm.LLVMBasicBlockRef;

   function LLVMAppendBasicBlock
     (Fn   : in llvm.LLVMValueRef;
      Name : in Interfaces.C.Strings.chars_ptr)
      return llvm.LLVMBasicBlockRef;

   function LLVMInsertBasicBlock
     (InsertBeforeBB : in llvm.LLVMBasicBlockRef;
      Name           : in Interfaces.C.Strings.chars_ptr)
      return           llvm.LLVMBasicBlockRef;

   procedure LLVMDeleteBasicBlock (BB : in llvm.LLVMBasicBlockRef);

   function LLVMGetInstructionParent
     (Inst : in llvm.LLVMValueRef)
      return llvm.LLVMBasicBlockRef;

   function LLVMGetFirstInstruction
     (BB   : in llvm.LLVMBasicBlockRef)
      return llvm.LLVMValueRef;

   function LLVMGetLastInstruction
     (BB   : in llvm.LLVMBasicBlockRef)
      return llvm.LLVMValueRef;

   function LLVMGetNextInstruction
     (Inst : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   function LLVMGetPreviousInstruction
     (Inst : in llvm.LLVMValueRef)
      return llvm.LLVMValueRef;

   procedure LLVMSetInstructionCallConv
     (Instr : in llvm.LLVMValueRef;
      CC    : in Interfaces.C.unsigned);

   function LLVMGetInstructionCallConv
     (Instr : in llvm.LLVMValueRef)
      return  Interfaces.C.unsigned;

   procedure LLVMAddInstrAttribute
     (Instr : in llvm.LLVMValueRef;
      index : in Interfaces.C.unsigned;
      arg_1 : in llvm.LLVMAttribute);

   procedure LLVMRemoveInstrAttribute
     (Instr : in llvm.LLVMValueRef;
      index : in Interfaces.C.unsigned;
      arg_1 : in llvm.LLVMAttribute);

   procedure LLVMSetInstrParamAlignment
     (Instr : in llvm.LLVMValueRef;
      index : in Interfaces.C.unsigned;
      align : in Interfaces.C.unsigned);

   function LLVMIsTailCall
     (CallInst : in llvm.LLVMValueRef)
      return     Interfaces.C.int;

   procedure LLVMSetTailCall
     (CallInst   : in llvm.LLVMValueRef;
      IsTailCall : in Interfaces.C.int);

   procedure LLVMAddIncoming
     (PhiNode        : in llvm.LLVMValueRef;
      IncomingValues : access llvm.LLVMValueRef;
      IncomingBlocks : access llvm.LLVMBasicBlockRef;
      Count          : in Interfaces.C.unsigned);

   function LLVMCountIncoming
     (PhiNode : in llvm.LLVMValueRef)
      return    Interfaces.C.unsigned;

   function LLVMGetIncomingValue
     (PhiNode : in llvm.LLVMValueRef;
      Index   : in Interfaces.C.unsigned)
      return    llvm.LLVMValueRef;

   function LLVMGetIncomingBlock
     (PhiNode : in llvm.LLVMValueRef;
      Index   : in Interfaces.C.unsigned)
      return    llvm.LLVMBasicBlockRef;

   function LLVMCreateBuilder return  llvm.LLVMBuilderRef;

   procedure LLVMPositionBuilder
     (Builder : in llvm.LLVMBuilderRef;
      Block   : in llvm.LLVMBasicBlockRef;
      Instr   : in llvm.LLVMValueRef);

   procedure LLVMPositionBuilderBefore
     (Builder : in llvm.LLVMBuilderRef;
      Instr   : in llvm.LLVMValueRef);

   procedure LLVMPositionBuilderAtEnd
     (Builder : in llvm.LLVMBuilderRef;
      Block   : in llvm.LLVMBasicBlockRef);

   function LLVMGetInsertBlock
     (Builder : in llvm.LLVMBuilderRef)
      return    llvm.LLVMBasicBlockRef;

   procedure LLVMClearInsertionPosition (Builder : in llvm.LLVMBuilderRef);

   procedure LLVMInsertIntoBuilder
     (Builder : in llvm.LLVMBuilderRef;
      Instr   : in llvm.LLVMValueRef);

   procedure LLVMDisposeBuilder (Builder : in llvm.LLVMBuilderRef);

   function LLVMBuildRetVoid
     (arg_1 : in llvm.LLVMBuilderRef)
      return  llvm.LLVMValueRef;

   function LLVMBuildRet
     (arg_1 : in llvm.LLVMBuilderRef;
      V     : in llvm.LLVMValueRef)
      return  llvm.LLVMValueRef;

   function LLVMBuildBr
     (arg_1 : in llvm.LLVMBuilderRef;
      Dest  : in llvm.LLVMBasicBlockRef)
      return  llvm.LLVMValueRef;

   function LLVMBuildCondBr
     (arg_1    : in llvm.LLVMBuilderRef;
      the_If   : in llvm.LLVMValueRef;
      the_Then : in llvm.LLVMBasicBlockRef;
      the_Else : in llvm.LLVMBasicBlockRef)
      return     llvm.LLVMValueRef;

   function LLVMBuildSwitch
     (arg_1    : in llvm.LLVMBuilderRef;
      V        : in llvm.LLVMValueRef;
      the_Else : in llvm.LLVMBasicBlockRef;
      NumCases : in Interfaces.C.unsigned)
      return     llvm.LLVMValueRef;

   function LLVMBuildInvoke
     (arg_1    : in llvm.LLVMBuilderRef;
      Fn       : in llvm.LLVMValueRef;
      Args     : access llvm.LLVMValueRef;
      NumArgs  : in Interfaces.C.unsigned;
      the_Then : in llvm.LLVMBasicBlockRef;
      Catch    : in llvm.LLVMBasicBlockRef;
      Name     : in Interfaces.C.Strings.chars_ptr)
      return     llvm.LLVMValueRef;

   function LLVMBuildUnwind
     (arg_1 : in llvm.LLVMBuilderRef)
      return  llvm.LLVMValueRef;

   function LLVMBuildUnreachable
     (arg_1 : in llvm.LLVMBuilderRef)
      return  llvm.LLVMValueRef;

   procedure LLVMAddCase
     (Switch : in llvm.LLVMValueRef;
      OnVal  : in llvm.LLVMValueRef;
      Dest   : in llvm.LLVMBasicBlockRef);

   function LLVMBuildAdd
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildSub
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildMul
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildUDiv
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildSDiv
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildFDiv
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildURem
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildSRem
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildFRem
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildShl
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildLShr
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildAShr
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildAnd
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildOr
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildXor
     (arg_1 : in llvm.LLVMBuilderRef;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildNeg
     (arg_1 : in llvm.LLVMBuilderRef;
      V     : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildNot
     (arg_1 : in llvm.LLVMBuilderRef;
      V     : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildMalloc
     (arg_1 : in llvm.LLVMBuilderRef;
      Ty    : in llvm.LLVMTypeRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildArrayMalloc
     (arg_1 : in llvm.LLVMBuilderRef;
      Ty    : in llvm.LLVMTypeRef;
      Val   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildAlloca
     (arg_1 : in llvm.LLVMBuilderRef;
      Ty    : in llvm.LLVMTypeRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildArrayAlloca
     (arg_1 : in llvm.LLVMBuilderRef;
      Ty    : in llvm.LLVMTypeRef;
      Val   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildFree
     (arg_1      : in llvm.LLVMBuilderRef;
      PointerVal : in llvm.LLVMValueRef)
      return       llvm.LLVMValueRef;

   function LLVMBuildLoad
     (arg_1      : in llvm.LLVMBuilderRef;
      PointerVal : in llvm.LLVMValueRef;
      Name       : in Interfaces.C.Strings.chars_ptr)
      return       llvm.LLVMValueRef;

   function LLVMBuildStore
     (arg_1 : in llvm.LLVMBuilderRef;
      Val   : in llvm.LLVMValueRef;
      Ptr   : in llvm.LLVMValueRef)
      return  llvm.LLVMValueRef;

   function LLVMBuildGEP
     (B          : in llvm.LLVMBuilderRef;
      Pointer    : in llvm.LLVMValueRef;
      Indices    : access llvm.LLVMValueRef;
      NumIndices : in Interfaces.C.unsigned;
      Name       : in Interfaces.C.Strings.chars_ptr)
      return       llvm.LLVMValueRef;

   function LLVMBuildTrunc
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildZExt
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildSExt
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildFPToUI
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildFPToSI
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildUIToFP
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildSIToFP
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildFPTrunc
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildFPExt
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildPtrToInt
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildIntToPtr
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildBitCast
     (arg_1  : in llvm.LLVMBuilderRef;
      Val    : in llvm.LLVMValueRef;
      DestTy : in llvm.LLVMTypeRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildICmp
     (arg_1 : in llvm.LLVMBuilderRef;
      Op    : in llvm.LLVMIntPredicate;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildFCmp
     (arg_1 : in llvm.LLVMBuilderRef;
      Op    : in llvm.LLVMRealPredicate;
      LHS   : in llvm.LLVMValueRef;
      RHS   : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildPhi
     (arg_1 : in llvm.LLVMBuilderRef;
      Ty    : in llvm.LLVMTypeRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildCall
     (arg_1   : in llvm.LLVMBuilderRef;
      Fn      : in llvm.LLVMValueRef;
      Args    : access llvm.LLVMValueRef;
      NumArgs : in Interfaces.C.unsigned;
      Name    : in Interfaces.C.Strings.chars_ptr)
      return    llvm.LLVMValueRef;

   function LLVMBuildSelect
     (arg_1    : in llvm.LLVMBuilderRef;
      the_If   : in llvm.LLVMValueRef;
      the_Then : in llvm.LLVMValueRef;
      the_Else : in llvm.LLVMValueRef;
      Name     : in Interfaces.C.Strings.chars_ptr)
      return     llvm.LLVMValueRef;

   function LLVMBuildVAArg
     (arg_1 : in llvm.LLVMBuilderRef;
      List  : in llvm.LLVMValueRef;
      Ty    : in llvm.LLVMTypeRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildExtractElement
     (arg_1  : in llvm.LLVMBuilderRef;
      VecVal : in llvm.LLVMValueRef;
      Index  : in llvm.LLVMValueRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildInsertElement
     (arg_1  : in llvm.LLVMBuilderRef;
      VecVal : in llvm.LLVMValueRef;
      EltVal : in llvm.LLVMValueRef;
      Index  : in llvm.LLVMValueRef;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildShuffleVector
     (arg_1 : in llvm.LLVMBuilderRef;
      V1    : in llvm.LLVMValueRef;
      V2    : in llvm.LLVMValueRef;
      Mask  : in llvm.LLVMValueRef;
      Name  : in Interfaces.C.Strings.chars_ptr)
      return  llvm.LLVMValueRef;

   function LLVMBuildExtractValue
     (arg_1  : in llvm.LLVMBuilderRef;
      AggVal : in llvm.LLVMValueRef;
      Index  : in Interfaces.C.unsigned;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMBuildInsertValue
     (arg_1  : in llvm.LLVMBuilderRef;
      AggVal : in llvm.LLVMValueRef;
      EltVal : in llvm.LLVMValueRef;
      Index  : in Interfaces.C.unsigned;
      Name   : in Interfaces.C.Strings.chars_ptr)
      return   llvm.LLVMValueRef;

   function LLVMCreateModuleProviderForExistingModule
     (M    : in llvm.LLVMModuleRef)
      return llvm.LLVMModuleProviderRef;

   procedure LLVMDisposeModuleProvider (MP : in llvm.LLVMModuleProviderRef);

   function LLVMCreateMemoryBufferWithContentsOfFile
     (Path       : in Interfaces.C.Strings.chars_ptr;
      OutMemBuf  : access llvm.LLVMMemoryBufferRef;
      OutMessage : access Interfaces.C.Strings.chars_ptr)
      return       Interfaces.C.int;

   function LLVMCreateMemoryBufferWithSTDIN
     (OutMemBuf  : access llvm.LLVMMemoryBufferRef;
      OutMessage : access Interfaces.C.Strings.chars_ptr)
      return       Interfaces.C.int;

   procedure LLVMDisposeMemoryBuffer (MemBuf : in llvm.LLVMMemoryBufferRef);

   function LLVMCreatePassManager return  llvm.LLVMPassManagerRef;

   function LLVMCreateFunctionPassManager
     (MP   : in llvm.LLVMModuleProviderRef)
      return llvm.LLVMPassManagerRef;

   function LLVMRunPassManager
     (PM   : in llvm.LLVMPassManagerRef;
      M    : in llvm.LLVMModuleRef)
      return Interfaces.C.int;

   function LLVMInitializeFunctionPassManager
     (FPM  : in llvm.LLVMPassManagerRef)
      return Interfaces.C.int;

   function LLVMRunFunctionPassManager
     (FPM  : in llvm.LLVMPassManagerRef;
      F    : in llvm.LLVMValueRef)
      return Interfaces.C.int;

   function LLVMFinalizeFunctionPassManager
     (FPM  : in llvm.LLVMPassManagerRef)
      return Interfaces.C.int;

   procedure LLVMDisposePassManager (PM : in llvm.LLVMPassManagerRef);

private

   pragma Import (C, LLVMDisposeMessage, "Ada_LLVMDisposeMessage");
   pragma Import (C, LLVMContextCreate, "Ada_LLVMContextCreate");
   pragma Import (C, LLVMGetGlobalContext, "Ada_LLVMGetGlobalContext");
   pragma Import (C, LLVMContextDispose, "Ada_LLVMContextDispose");
   pragma Import
     (C,
      LLVMModuleCreateWithName,
      "Ada_LLVMModuleCreateWithName");
   pragma Import
     (C,
      LLVMModuleCreateWithNameInContext,
      "Ada_LLVMModuleCreateWithNameInContext");
   pragma Import (C, LLVMDisposeModule, "Ada_LLVMDisposeModule");
   pragma Import (C, LLVMGetDataLayout, "Ada_LLVMGetDataLayout");
   pragma Import (C, LLVMSetDataLayout, "Ada_LLVMSetDataLayout");
   pragma Import (C, LLVMGetTarget, "Ada_LLVMGetTarget");
   pragma Import (C, LLVMSetTarget, "Ada_LLVMSetTarget");
   pragma Import (C, LLVMAddTypeName, "Ada_LLVMAddTypeName");
   pragma Import (C, LLVMDeleteTypeName, "Ada_LLVMDeleteTypeName");
   pragma Import (C, LLVMGetTypeByName, "Ada_LLVMGetTypeByName");
   pragma Import (C, LLVMDumpModule, "Ada_LLVMDumpModule");
   pragma Import (C, LLVMGetTypeKind, "Ada_LLVMGetTypeKind");
   pragma Import (C, LLVMInt1Type, "Ada_LLVMInt1Type");
   pragma Import (C, LLVMInt8Type, "Ada_LLVMInt8Type");
   pragma Import (C, LLVMInt16Type, "Ada_LLVMInt16Type");
   pragma Import (C, LLVMInt32Type, "Ada_LLVMInt32Type");
   pragma Import (C, LLVMInt64Type, "Ada_LLVMInt64Type");
   pragma Import (C, LLVMIntType, "Ada_LLVMIntType");
   pragma Import (C, LLVMGetIntTypeWidth, "Ada_LLVMGetIntTypeWidth");
   pragma Import (C, LLVMFloatType, "Ada_LLVMFloatType");
   pragma Import (C, LLVMDoubleType, "Ada_LLVMDoubleType");
   pragma Import (C, LLVMX86FP80Type, "Ada_LLVMX86FP80Type");
   pragma Import (C, LLVMFP128Type, "Ada_LLVMFP128Type");
   pragma Import (C, LLVMPPCFP128Type, "Ada_LLVMPPCFP128Type");
   pragma Import (C, LLVMFunctionType, "Ada_LLVMFunctionType");
   pragma Import (C, LLVMIsFunctionVarArg, "Ada_LLVMIsFunctionVarArg");
   pragma Import (C, LLVMGetReturnType, "Ada_LLVMGetReturnType");
   pragma Import (C, LLVMCountParamTypes, "Ada_LLVMCountParamTypes");
   pragma Import (C, LLVMGetParamTypes, "Ada_LLVMGetParamTypes");
   pragma Import (C, LLVMStructType, "Ada_LLVMStructType");
   pragma Import
     (C,
      LLVMCountStructElementTypes,
      "Ada_LLVMCountStructElementTypes");
   pragma Import
     (C,
      LLVMGetStructElementTypes,
      "Ada_LLVMGetStructElementTypes");
   pragma Import (C, LLVMIsPackedStruct, "Ada_LLVMIsPackedStruct");
   pragma Import (C, LLVMArrayType, "Ada_LLVMArrayType");
   pragma Import (C, LLVMPointerType, "Ada_LLVMPointerType");
   pragma Import (C, LLVMVectorType, "Ada_LLVMVectorType");
   pragma Import (C, LLVMGetElementType, "Ada_LLVMGetElementType");
   pragma Import (C, LLVMGetArrayLength, "Ada_LLVMGetArrayLength");
   pragma Import
     (C,
      LLVMGetPointerAddressSpace,
      "Ada_LLVMGetPointerAddressSpace");
   pragma Import (C, LLVMGetVectorSize, "Ada_LLVMGetVectorSize");
   pragma Import (C, LLVMVoidType, "Ada_LLVMVoidType");
   pragma Import (C, LLVMLabelType, "Ada_LLVMLabelType");
   pragma Import (C, LLVMOpaqueType, "Ada_LLVMOpaqueType");
   pragma Import (C, LLVMCreateTypeHandle, "Ada_LLVMCreateTypeHandle");
   pragma Import (C, LLVMRefineType, "Ada_LLVMRefineType");
   pragma Import (C, LLVMResolveTypeHandle, "Ada_LLVMResolveTypeHandle");
   pragma Import (C, LLVMDisposeTypeHandle, "Ada_LLVMDisposeTypeHandle");
   pragma Import (C, LLVMTypeOf, "Ada_LLVMTypeOf");
   pragma Import (C, LLVMGetValueName, "Ada_LLVMGetValueName");
   pragma Import (C, LLVMSetValueName, "Ada_LLVMSetValueName");
   pragma Import (C, LLVMDumpValue, "Ada_LLVMDumpValue");
   pragma Import (C, LLVMIsAArgument, "Ada_LLVMIsAArgument");
   pragma Import (C, LLVMIsABasicBlock, "Ada_LLVMIsABasicBlock");
   pragma Import (C, LLVMIsAInlineAsm, "Ada_LLVMIsAInlineAsm");
   pragma Import (C, LLVMIsAUser, "Ada_LLVMIsAUser");
   pragma Import (C, LLVMIsAConstant, "Ada_LLVMIsAConstant");
   pragma Import
     (C,
      LLVMIsAConstantAggregateZero,
      "Ada_LLVMIsAConstantAggregateZero");
   pragma Import (C, LLVMIsAConstantArray, "Ada_LLVMIsAConstantArray");
   pragma Import (C, LLVMIsAConstantExpr, "Ada_LLVMIsAConstantExpr");
   pragma Import (C, LLVMIsAConstantFP, "Ada_LLVMIsAConstantFP");
   pragma Import (C, LLVMIsAConstantInt, "Ada_LLVMIsAConstantInt");
   pragma Import
     (C,
      LLVMIsAConstantPointerNull,
      "Ada_LLVMIsAConstantPointerNull");
   pragma Import (C, LLVMIsAConstantStruct, "Ada_LLVMIsAConstantStruct");
   pragma Import (C, LLVMIsAConstantVector, "Ada_LLVMIsAConstantVector");
   pragma Import (C, LLVMIsAGlobalValue, "Ada_LLVMIsAGlobalValue");
   pragma Import (C, LLVMIsAFunction, "Ada_LLVMIsAFunction");
   pragma Import (C, LLVMIsAGlobalAlias, "Ada_LLVMIsAGlobalAlias");
   pragma Import (C, LLVMIsAGlobalVariable, "Ada_LLVMIsAGlobalVariable");
   pragma Import (C, LLVMIsAUndefValue, "Ada_LLVMIsAUndefValue");
   pragma Import (C, LLVMIsAInstruction, "Ada_LLVMIsAInstruction");
   pragma Import (C, LLVMIsABinaryOperator, "Ada_LLVMIsABinaryOperator");
   pragma Import (C, LLVMIsACallInst, "Ada_LLVMIsACallInst");
   pragma Import (C, LLVMIsAIntrinsicInst, "Ada_LLVMIsAIntrinsicInst");
   pragma Import (C, LLVMIsADbgInfoIntrinsic, "Ada_LLVMIsADbgInfoIntrinsic");
   pragma Import (C, LLVMIsADbgDeclareInst, "Ada_LLVMIsADbgDeclareInst");
   pragma Import (C, LLVMIsADbgFuncStartInst, "Ada_LLVMIsADbgFuncStartInst");
   pragma Import (C, LLVMIsADbgRegionEndInst, "Ada_LLVMIsADbgRegionEndInst");
   pragma Import
     (C,
      LLVMIsADbgRegionStartInst,
      "Ada_LLVMIsADbgRegionStartInst");
   pragma Import (C, LLVMIsADbgStopPointInst, "Ada_LLVMIsADbgStopPointInst");
   pragma Import (C, LLVMIsAEHSelectorInst, "Ada_LLVMIsAEHSelectorInst");
   pragma Import (C, LLVMIsAMemIntrinsic, "Ada_LLVMIsAMemIntrinsic");
   pragma Import (C, LLVMIsAMemCpyInst, "Ada_LLVMIsAMemCpyInst");
   pragma Import (C, LLVMIsAMemMoveInst, "Ada_LLVMIsAMemMoveInst");
   pragma Import (C, LLVMIsAMemSetInst, "Ada_LLVMIsAMemSetInst");
   pragma Import (C, LLVMIsACmpInst, "Ada_LLVMIsACmpInst");
   pragma Import (C, LLVMIsAFCmpInst, "Ada_LLVMIsAFCmpInst");
   pragma Import (C, LLVMIsAICmpInst, "Ada_LLVMIsAICmpInst");
   pragma Import
     (C,
      LLVMIsAExtractElementInst,
      "Ada_LLVMIsAExtractElementInst");
   pragma Import
     (C,
      LLVMIsAGetElementPtrInst,
      "Ada_LLVMIsAGetElementPtrInst");
   pragma Import
     (C,
      LLVMIsAInsertElementInst,
      "Ada_LLVMIsAInsertElementInst");
   pragma Import (C, LLVMIsAInsertValueInst, "Ada_LLVMIsAInsertValueInst");
   pragma Import (C, LLVMIsAPHINode, "Ada_LLVMIsAPHINode");
   pragma Import (C, LLVMIsASelectInst, "Ada_LLVMIsASelectInst");
   pragma Import
     (C,
      LLVMIsAShuffleVectorInst,
      "Ada_LLVMIsAShuffleVectorInst");
   pragma Import (C, LLVMIsAStoreInst, "Ada_LLVMIsAStoreInst");
   pragma Import (C, LLVMIsATerminatorInst, "Ada_LLVMIsATerminatorInst");
   pragma Import (C, LLVMIsABranchInst, "Ada_LLVMIsABranchInst");
   pragma Import (C, LLVMIsAInvokeInst, "Ada_LLVMIsAInvokeInst");
   pragma Import (C, LLVMIsAReturnInst, "Ada_LLVMIsAReturnInst");
   pragma Import (C, LLVMIsASwitchInst, "Ada_LLVMIsASwitchInst");
   pragma Import (C, LLVMIsAUnreachableInst, "Ada_LLVMIsAUnreachableInst");
   pragma Import (C, LLVMIsAUnwindInst, "Ada_LLVMIsAUnwindInst");
   pragma Import (C, LLVMIsAUnaryInstruction, "Ada_LLVMIsAUnaryInstruction");
   pragma Import (C, LLVMIsAAllocationInst, "Ada_LLVMIsAAllocationInst");
   pragma Import (C, LLVMIsAAllocaInst, "Ada_LLVMIsAAllocaInst");
   pragma Import (C, LLVMIsAMallocInst, "Ada_LLVMIsAMallocInst");
   pragma Import (C, LLVMIsACastInst, "Ada_LLVMIsACastInst");
   pragma Import (C, LLVMIsABitCastInst, "Ada_LLVMIsABitCastInst");
   pragma Import (C, LLVMIsAFPExtInst, "Ada_LLVMIsAFPExtInst");
   pragma Import (C, LLVMIsAFPToSIInst, "Ada_LLVMIsAFPToSIInst");
   pragma Import (C, LLVMIsAFPToUIInst, "Ada_LLVMIsAFPToUIInst");
   pragma Import (C, LLVMIsAFPTruncInst, "Ada_LLVMIsAFPTruncInst");
   pragma Import (C, LLVMIsAIntToPtrInst, "Ada_LLVMIsAIntToPtrInst");
   pragma Import (C, LLVMIsAPtrToIntInst, "Ada_LLVMIsAPtrToIntInst");
   pragma Import (C, LLVMIsASExtInst, "Ada_LLVMIsASExtInst");
   pragma Import (C, LLVMIsASIToFPInst, "Ada_LLVMIsASIToFPInst");
   pragma Import (C, LLVMIsATruncInst, "Ada_LLVMIsATruncInst");
   pragma Import (C, LLVMIsAUIToFPInst, "Ada_LLVMIsAUIToFPInst");
   pragma Import (C, LLVMIsAZExtInst, "Ada_LLVMIsAZExtInst");
   pragma Import (C, LLVMIsAExtractValueInst, "Ada_LLVMIsAExtractValueInst");
   pragma Import (C, LLVMIsAFreeInst, "Ada_LLVMIsAFreeInst");
   pragma Import (C, LLVMIsALoadInst, "Ada_LLVMIsALoadInst");
   pragma Import (C, LLVMIsAVAArgInst, "Ada_LLVMIsAVAArgInst");
   pragma Import (C, LLVMConstNull, "Ada_LLVMConstNull");
   pragma Import (C, LLVMConstAllOnes, "Ada_LLVMConstAllOnes");
   pragma Import (C, LLVMGetUndef, "Ada_LLVMGetUndef");
   pragma Import (C, LLVMIsConstant, "Ada_LLVMIsConstant");
   pragma Import (C, LLVMIsNull, "Ada_LLVMIsNull");
   pragma Import (C, LLVMIsUndef, "Ada_LLVMIsUndef");
   pragma Import (C, LLVMConstPointerNull, "Ada_LLVMConstPointerNull");
   pragma Import (C, LLVMConstInt, "Ada_LLVMConstInt");
   pragma Import (C, LLVMConstReal, "Ada_LLVMConstReal");
   pragma Import (C, LLVMConstRealOfString, "Ada_LLVMConstRealOfString");
   pragma Import (C, LLVMConstString, "Ada_LLVMConstString");
   pragma Import (C, LLVMConstArray, "Ada_LLVMConstArray");
   pragma Import (C, LLVMConstStruct, "Ada_LLVMConstStruct");
   pragma Import (C, LLVMConstVector, "Ada_LLVMConstVector");
   pragma Import (C, LLVMSizeOf, "Ada_LLVMSizeOf");
   pragma Import (C, LLVMConstNeg, "Ada_LLVMConstNeg");
   pragma Import (C, LLVMConstNot, "Ada_LLVMConstNot");
   pragma Import (C, LLVMConstAdd, "Ada_LLVMConstAdd");
   pragma Import (C, LLVMConstSub, "Ada_LLVMConstSub");
   pragma Import (C, LLVMConstMul, "Ada_LLVMConstMul");
   pragma Import (C, LLVMConstUDiv, "Ada_LLVMConstUDiv");
   pragma Import (C, LLVMConstSDiv, "Ada_LLVMConstSDiv");
   pragma Import (C, LLVMConstFDiv, "Ada_LLVMConstFDiv");
   pragma Import (C, LLVMConstURem, "Ada_LLVMConstURem");
   pragma Import (C, LLVMConstSRem, "Ada_LLVMConstSRem");
   pragma Import (C, LLVMConstFRem, "Ada_LLVMConstFRem");
   pragma Import (C, LLVMConstAnd, "Ada_LLVMConstAnd");
   pragma Import (C, LLVMConstOr, "Ada_LLVMConstOr");
   pragma Import (C, LLVMConstXor, "Ada_LLVMConstXor");
   pragma Import (C, LLVMConstICmp, "Ada_LLVMConstICmp");
   pragma Import (C, LLVMConstFCmp, "Ada_LLVMConstFCmp");
   pragma Import (C, LLVMConstShl, "Ada_LLVMConstShl");
   pragma Import (C, LLVMConstLShr, "Ada_LLVMConstLShr");
   pragma Import (C, LLVMConstAShr, "Ada_LLVMConstAShr");
   pragma Import (C, LLVMConstGEP, "Ada_LLVMConstGEP");
   pragma Import (C, LLVMConstTrunc, "Ada_LLVMConstTrunc");
   pragma Import (C, LLVMConstSExt, "Ada_LLVMConstSExt");
   pragma Import (C, LLVMConstZExt, "Ada_LLVMConstZExt");
   pragma Import (C, LLVMConstFPTrunc, "Ada_LLVMConstFPTrunc");
   pragma Import (C, LLVMConstFPExt, "Ada_LLVMConstFPExt");
   pragma Import (C, LLVMConstUIToFP, "Ada_LLVMConstUIToFP");
   pragma Import (C, LLVMConstSIToFP, "Ada_LLVMConstSIToFP");
   pragma Import (C, LLVMConstFPToUI, "Ada_LLVMConstFPToUI");
   pragma Import (C, LLVMConstFPToSI, "Ada_LLVMConstFPToSI");
   pragma Import (C, LLVMConstPtrToInt, "Ada_LLVMConstPtrToInt");
   pragma Import (C, LLVMConstIntToPtr, "Ada_LLVMConstIntToPtr");
   pragma Import (C, LLVMConstBitCast, "Ada_LLVMConstBitCast");
   pragma Import (C, LLVMConstSelect, "Ada_LLVMConstSelect");
   pragma Import (C, LLVMConstExtractElement, "Ada_LLVMConstExtractElement");
   pragma Import (C, LLVMConstInsertElement, "Ada_LLVMConstInsertElement");
   pragma Import (C, LLVMConstShuffleVector, "Ada_LLVMConstShuffleVector");
   pragma Import (C, LLVMConstExtractValue, "Ada_LLVMConstExtractValue");
   pragma Import (C, LLVMConstInsertValue, "Ada_LLVMConstInsertValue");
   pragma Import (C, LLVMConstInlineAsm, "Ada_LLVMConstInlineAsm");
   pragma Import (C, LLVMGetGlobalParent, "Ada_LLVMGetGlobalParent");
   pragma Import (C, LLVMIsDeclaration, "Ada_LLVMIsDeclaration");
   pragma Import (C, LLVMGetLinkage, "Ada_LLVMGetLinkage");
   pragma Import (C, LLVMSetLinkage, "Ada_LLVMSetLinkage");
   pragma Import (C, LLVMGetSection, "Ada_LLVMGetSection");
   pragma Import (C, LLVMSetSection, "Ada_LLVMSetSection");
   pragma Import (C, LLVMGetVisibility, "Ada_LLVMGetVisibility");
   pragma Import (C, LLVMSetVisibility, "Ada_LLVMSetVisibility");
   pragma Import (C, LLVMGetAlignment, "Ada_LLVMGetAlignment");
   pragma Import (C, LLVMSetAlignment, "Ada_LLVMSetAlignment");
   pragma Import (C, LLVMAddGlobal, "Ada_LLVMAddGlobal");
   pragma Import (C, LLVMGetNamedGlobal, "Ada_LLVMGetNamedGlobal");
   pragma Import (C, LLVMGetFirstGlobal, "Ada_LLVMGetFirstGlobal");
   pragma Import (C, LLVMGetLastGlobal, "Ada_LLVMGetLastGlobal");
   pragma Import (C, LLVMGetNextGlobal, "Ada_LLVMGetNextGlobal");
   pragma Import (C, LLVMGetPreviousGlobal, "Ada_LLVMGetPreviousGlobal");
   pragma Import (C, LLVMDeleteGlobal, "Ada_LLVMDeleteGlobal");
   pragma Import (C, LLVMGetInitializer, "Ada_LLVMGetInitializer");
   pragma Import (C, LLVMSetInitializer, "Ada_LLVMSetInitializer");
   pragma Import (C, LLVMIsThreadLocal, "Ada_LLVMIsThreadLocal");
   pragma Import (C, LLVMSetThreadLocal, "Ada_LLVMSetThreadLocal");
   pragma Import (C, LLVMIsGlobalConstant, "Ada_LLVMIsGlobalConstant");
   pragma Import (C, LLVMSetGlobalConstant, "Ada_LLVMSetGlobalConstant");
   pragma Import (C, LLVMAddAlias, "Ada_LLVMAddAlias");
   pragma Import (C, LLVMAddFunction, "Ada_LLVMAddFunction");
   pragma Import (C, LLVMGetNamedFunction, "Ada_LLVMGetNamedFunction");
   pragma Import (C, LLVMGetFirstFunction, "Ada_LLVMGetFirstFunction");
   pragma Import (C, LLVMGetLastFunction, "Ada_LLVMGetLastFunction");
   pragma Import (C, LLVMGetNextFunction, "Ada_LLVMGetNextFunction");
   pragma Import (C, LLVMGetPreviousFunction, "Ada_LLVMGetPreviousFunction");
   pragma Import (C, LLVMDeleteFunction, "Ada_LLVMDeleteFunction");
   pragma Import (C, LLVMGetIntrinsicID, "Ada_LLVMGetIntrinsicID");
   pragma Import (C, LLVMGetFunctionCallConv, "Ada_LLVMGetFunctionCallConv");
   pragma Import (C, LLVMSetFunctionCallConv, "Ada_LLVMSetFunctionCallConv");
   pragma Import (C, LLVMGetGC, "Ada_LLVMGetGC");
   pragma Import (C, LLVMSetGC, "Ada_LLVMSetGC");
   pragma Import (C, LLVMAddFunctionAttr, "Ada_LLVMAddFunctionAttr");
   pragma Import (C, LLVMRemoveFunctionAttr, "Ada_LLVMRemoveFunctionAttr");
   pragma Import (C, LLVMCountParams, "Ada_LLVMCountParams");
   pragma Import (C, LLVMGetParams, "Ada_LLVMGetParams");
   pragma Import (C, LLVMGetParam, "Ada_LLVMGetParam");
   pragma Import (C, LLVMGetParamParent, "Ada_LLVMGetParamParent");
   pragma Import (C, LLVMGetFirstParam, "Ada_LLVMGetFirstParam");
   pragma Import (C, LLVMGetLastParam, "Ada_LLVMGetLastParam");
   pragma Import (C, LLVMGetNextParam, "Ada_LLVMGetNextParam");
   pragma Import (C, LLVMGetPreviousParam, "Ada_LLVMGetPreviousParam");
   pragma Import (C, LLVMAddAttribute, "Ada_LLVMAddAttribute");
   pragma Import (C, LLVMRemoveAttribute, "Ada_LLVMRemoveAttribute");
   pragma Import (C, LLVMSetParamAlignment, "Ada_LLVMSetParamAlignment");
   pragma Import (C, LLVMBasicBlockAsValue, "Ada_LLVMBasicBlockAsValue");
   pragma Import (C, LLVMValueIsBasicBlock, "Ada_LLVMValueIsBasicBlock");
   pragma Import (C, LLVMValueAsBasicBlock, "Ada_LLVMValueAsBasicBlock");
   pragma Import (C, LLVMGetBasicBlockParent, "Ada_LLVMGetBasicBlockParent");
   pragma Import (C, LLVMCountBasicBlocks, "Ada_LLVMCountBasicBlocks");
   pragma Import (C, LLVMGetBasicBlocks, "Ada_LLVMGetBasicBlocks");
   pragma Import (C, LLVMGetFirstBasicBlock, "Ada_LLVMGetFirstBasicBlock");
   pragma Import (C, LLVMGetLastBasicBlock, "Ada_LLVMGetLastBasicBlock");
   pragma Import (C, LLVMGetNextBasicBlock, "Ada_LLVMGetNextBasicBlock");
   pragma Import
     (C,
      LLVMGetPreviousBasicBlock,
      "Ada_LLVMGetPreviousBasicBlock");
   pragma Import (C, LLVMGetEntryBasicBlock, "Ada_LLVMGetEntryBasicBlock");
   pragma Import (C, LLVMAppendBasicBlock, "Ada_LLVMAppendBasicBlock");
   pragma Import (C, LLVMInsertBasicBlock, "Ada_LLVMInsertBasicBlock");
   pragma Import (C, LLVMDeleteBasicBlock, "Ada_LLVMDeleteBasicBlock");
   pragma Import
     (C,
      LLVMGetInstructionParent,
      "Ada_LLVMGetInstructionParent");
   pragma Import (C, LLVMGetFirstInstruction, "Ada_LLVMGetFirstInstruction");
   pragma Import (C, LLVMGetLastInstruction, "Ada_LLVMGetLastInstruction");
   pragma Import (C, LLVMGetNextInstruction, "Ada_LLVMGetNextInstruction");
   pragma Import
     (C,
      LLVMGetPreviousInstruction,
      "Ada_LLVMGetPreviousInstruction");
   pragma Import
     (C,
      LLVMSetInstructionCallConv,
      "Ada_LLVMSetInstructionCallConv");
   pragma Import
     (C,
      LLVMGetInstructionCallConv,
      "Ada_LLVMGetInstructionCallConv");
   pragma Import (C, LLVMAddInstrAttribute, "Ada_LLVMAddInstrAttribute");
   pragma Import
     (C,
      LLVMRemoveInstrAttribute,
      "Ada_LLVMRemoveInstrAttribute");
   pragma Import
     (C,
      LLVMSetInstrParamAlignment,
      "Ada_LLVMSetInstrParamAlignment");
   pragma Import (C, LLVMIsTailCall, "Ada_LLVMIsTailCall");
   pragma Import (C, LLVMSetTailCall, "Ada_LLVMSetTailCall");
   pragma Import (C, LLVMAddIncoming, "Ada_LLVMAddIncoming");
   pragma Import (C, LLVMCountIncoming, "Ada_LLVMCountIncoming");
   pragma Import (C, LLVMGetIncomingValue, "Ada_LLVMGetIncomingValue");
   pragma Import (C, LLVMGetIncomingBlock, "Ada_LLVMGetIncomingBlock");
   pragma Import (C, LLVMCreateBuilder, "Ada_LLVMCreateBuilder");
   pragma Import (C, LLVMPositionBuilder, "Ada_LLVMPositionBuilder");
   pragma Import
     (C,
      LLVMPositionBuilderBefore,
      "Ada_LLVMPositionBuilderBefore");
   pragma Import
     (C,
      LLVMPositionBuilderAtEnd,
      "Ada_LLVMPositionBuilderAtEnd");
   pragma Import (C, LLVMGetInsertBlock, "Ada_LLVMGetInsertBlock");
   pragma Import
     (C,
      LLVMClearInsertionPosition,
      "Ada_LLVMClearInsertionPosition");
   pragma Import (C, LLVMInsertIntoBuilder, "Ada_LLVMInsertIntoBuilder");
   pragma Import (C, LLVMDisposeBuilder, "Ada_LLVMDisposeBuilder");
   pragma Import (C, LLVMBuildRetVoid, "Ada_LLVMBuildRetVoid");
   pragma Import (C, LLVMBuildRet, "Ada_LLVMBuildRet");
   pragma Import (C, LLVMBuildBr, "Ada_LLVMBuildBr");
   pragma Import (C, LLVMBuildCondBr, "Ada_LLVMBuildCondBr");
   pragma Import (C, LLVMBuildSwitch, "Ada_LLVMBuildSwitch");
   pragma Import (C, LLVMBuildInvoke, "Ada_LLVMBuildInvoke");
   pragma Import (C, LLVMBuildUnwind, "Ada_LLVMBuildUnwind");
   pragma Import (C, LLVMBuildUnreachable, "Ada_LLVMBuildUnreachable");
   pragma Import (C, LLVMAddCase, "Ada_LLVMAddCase");
   pragma Import (C, LLVMBuildAdd, "Ada_LLVMBuildAdd");
   pragma Import (C, LLVMBuildSub, "Ada_LLVMBuildSub");
   pragma Import (C, LLVMBuildMul, "Ada_LLVMBuildMul");
   pragma Import (C, LLVMBuildUDiv, "Ada_LLVMBuildUDiv");
   pragma Import (C, LLVMBuildSDiv, "Ada_LLVMBuildSDiv");
   pragma Import (C, LLVMBuildFDiv, "Ada_LLVMBuildFDiv");
   pragma Import (C, LLVMBuildURem, "Ada_LLVMBuildURem");
   pragma Import (C, LLVMBuildSRem, "Ada_LLVMBuildSRem");
   pragma Import (C, LLVMBuildFRem, "Ada_LLVMBuildFRem");
   pragma Import (C, LLVMBuildShl, "Ada_LLVMBuildShl");
   pragma Import (C, LLVMBuildLShr, "Ada_LLVMBuildLShr");
   pragma Import (C, LLVMBuildAShr, "Ada_LLVMBuildAShr");
   pragma Import (C, LLVMBuildAnd, "Ada_LLVMBuildAnd");
   pragma Import (C, LLVMBuildOr, "Ada_LLVMBuildOr");
   pragma Import (C, LLVMBuildXor, "Ada_LLVMBuildXor");
   pragma Import (C, LLVMBuildNeg, "Ada_LLVMBuildNeg");
   pragma Import (C, LLVMBuildNot, "Ada_LLVMBuildNot");
   pragma Import (C, LLVMBuildMalloc, "Ada_LLVMBuildMalloc");
   pragma Import (C, LLVMBuildArrayMalloc, "Ada_LLVMBuildArrayMalloc");
   pragma Import (C, LLVMBuildAlloca, "Ada_LLVMBuildAlloca");
   pragma Import (C, LLVMBuildArrayAlloca, "Ada_LLVMBuildArrayAlloca");
   pragma Import (C, LLVMBuildFree, "Ada_LLVMBuildFree");
   pragma Import (C, LLVMBuildLoad, "Ada_LLVMBuildLoad");
   pragma Import (C, LLVMBuildStore, "Ada_LLVMBuildStore");
   pragma Import (C, LLVMBuildGEP, "Ada_LLVMBuildGEP");
   pragma Import (C, LLVMBuildTrunc, "Ada_LLVMBuildTrunc");
   pragma Import (C, LLVMBuildZExt, "Ada_LLVMBuildZExt");
   pragma Import (C, LLVMBuildSExt, "Ada_LLVMBuildSExt");
   pragma Import (C, LLVMBuildFPToUI, "Ada_LLVMBuildFPToUI");
   pragma Import (C, LLVMBuildFPToSI, "Ada_LLVMBuildFPToSI");
   pragma Import (C, LLVMBuildUIToFP, "Ada_LLVMBuildUIToFP");
   pragma Import (C, LLVMBuildSIToFP, "Ada_LLVMBuildSIToFP");
   pragma Import (C, LLVMBuildFPTrunc, "Ada_LLVMBuildFPTrunc");
   pragma Import (C, LLVMBuildFPExt, "Ada_LLVMBuildFPExt");
   pragma Import (C, LLVMBuildPtrToInt, "Ada_LLVMBuildPtrToInt");
   pragma Import (C, LLVMBuildIntToPtr, "Ada_LLVMBuildIntToPtr");
   pragma Import (C, LLVMBuildBitCast, "Ada_LLVMBuildBitCast");
   pragma Import (C, LLVMBuildICmp, "Ada_LLVMBuildICmp");
   pragma Import (C, LLVMBuildFCmp, "Ada_LLVMBuildFCmp");
   pragma Import (C, LLVMBuildPhi, "Ada_LLVMBuildPhi");
   pragma Import (C, LLVMBuildCall, "Ada_LLVMBuildCall");
   pragma Import (C, LLVMBuildSelect, "Ada_LLVMBuildSelect");
   pragma Import (C, LLVMBuildVAArg, "Ada_LLVMBuildVAArg");
   pragma Import (C, LLVMBuildExtractElement, "Ada_LLVMBuildExtractElement");
   pragma Import (C, LLVMBuildInsertElement, "Ada_LLVMBuildInsertElement");
   pragma Import (C, LLVMBuildShuffleVector, "Ada_LLVMBuildShuffleVector");
   pragma Import (C, LLVMBuildExtractValue, "Ada_LLVMBuildExtractValue");
   pragma Import (C, LLVMBuildInsertValue, "Ada_LLVMBuildInsertValue");
   pragma Import
     (C,
      LLVMCreateModuleProviderForExistingModule,
      "Ada_LLVMCreateModuleProviderForExistingModule");
   pragma Import
     (C,
      LLVMDisposeModuleProvider,
      "Ada_LLVMDisposeModuleProvider");
   pragma Import
     (C,
      LLVMCreateMemoryBufferWithContentsOfFile,
      "Ada_LLVMCreateMemoryBufferWithContentsOfFile");
   pragma Import
     (C,
      LLVMCreateMemoryBufferWithSTDIN,
      "Ada_LLVMCreateMemoryBufferWithSTDIN");
   pragma Import (C, LLVMDisposeMemoryBuffer, "Ada_LLVMDisposeMemoryBuffer");
   pragma Import (C, LLVMCreatePassManager, "Ada_LLVMCreatePassManager");
   pragma Import
     (C,
      LLVMCreateFunctionPassManager,
      "Ada_LLVMCreateFunctionPassManager");
   pragma Import (C, LLVMRunPassManager, "Ada_LLVMRunPassManager");
   pragma Import
     (C,
      LLVMInitializeFunctionPassManager,
      "Ada_LLVMInitializeFunctionPassManager");
   pragma Import
     (C,
      LLVMRunFunctionPassManager,
      "Ada_LLVMRunFunctionPassManager");
   pragma Import
     (C,
      LLVMFinalizeFunctionPassManager,
      "Ada_LLVMFinalizeFunctionPassManager");
   pragma Import (C, LLVMDisposePassManager, "Ada_LLVMDisposePassManager");

end llvm.Binding;
