; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32,RV32-V
; RUN: llc -mtriple=riscv32 -mattr=+zve64x -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32,ZVE64X
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64,RV64-V
; RUN: llc -mtriple=riscv64 -mattr=+zve64x -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64,ZVE64X

define <vscale x 1 x i8> @vremu_vv_nxv1i8(<vscale x 1 x i8> %va, <vscale x 1 x i8> %vb) {
; CHECK-LABEL: vremu_vv_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 1 x i8> %va, %vb
  ret <vscale x 1 x i8> %vc
}

define <vscale x 1 x i8> @vremu_vx_nxv1i8(<vscale x 1 x i8> %va, i8 signext %b) {
; CHECK-LABEL: vremu_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %vc = urem <vscale x 1 x i8> %va, %splat
  ret <vscale x 1 x i8> %vc
}

define <vscale x 1 x i8> @vremu_vi_nxv1i8_0(<vscale x 1 x i8> %va) {
; CHECK-LABEL: vremu_vi_nxv1i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 33
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, mu
; CHECK-NEXT:    vmulhu.vx v9, v8, a0
; CHECK-NEXT:    vsrl.vi v9, v9, 5
; CHECK-NEXT:    li a0, -7
; CHECK-NEXT:    vnmsac.vx v8, a0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i8> poison, i8 -7, i32 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %vc = urem <vscale x 1 x i8> %va, %splat
  ret <vscale x 1 x i8> %vc
}

define <vscale x 2 x i8> @vremu_vv_nxv2i8(<vscale x 2 x i8> %va, <vscale x 2 x i8> %vb) {
; CHECK-LABEL: vremu_vv_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 2 x i8> %va, %vb
  ret <vscale x 2 x i8> %vc
}

define <vscale x 2 x i8> @vremu_vx_nxv2i8(<vscale x 2 x i8> %va, i8 signext %b) {
; CHECK-LABEL: vremu_vx_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %vc = urem <vscale x 2 x i8> %va, %splat
  ret <vscale x 2 x i8> %vc
}

define <vscale x 2 x i8> @vremu_vi_nxv2i8_0(<vscale x 2 x i8> %va) {
; CHECK-LABEL: vremu_vi_nxv2i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 33
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, mu
; CHECK-NEXT:    vmulhu.vx v9, v8, a0
; CHECK-NEXT:    vsrl.vi v9, v9, 5
; CHECK-NEXT:    li a0, -7
; CHECK-NEXT:    vnmsac.vx v8, a0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i8> poison, i8 -7, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %vc = urem <vscale x 2 x i8> %va, %splat
  ret <vscale x 2 x i8> %vc
}

define <vscale x 4 x i8> @vremu_vv_nxv4i8(<vscale x 4 x i8> %va, <vscale x 4 x i8> %vb) {
; CHECK-LABEL: vremu_vv_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 4 x i8> %va, %vb
  ret <vscale x 4 x i8> %vc
}

define <vscale x 4 x i8> @vremu_vx_nxv4i8(<vscale x 4 x i8> %va, i8 signext %b) {
; CHECK-LABEL: vremu_vx_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %vc = urem <vscale x 4 x i8> %va, %splat
  ret <vscale x 4 x i8> %vc
}

define <vscale x 4 x i8> @vremu_vi_nxv4i8_0(<vscale x 4 x i8> %va) {
; CHECK-LABEL: vremu_vi_nxv4i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 33
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, mu
; CHECK-NEXT:    vmulhu.vx v9, v8, a0
; CHECK-NEXT:    vsrl.vi v9, v9, 5
; CHECK-NEXT:    li a0, -7
; CHECK-NEXT:    vnmsac.vx v8, a0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i8> poison, i8 -7, i32 0
  %splat = shufflevector <vscale x 4 x i8> %head, <vscale x 4 x i8> poison, <vscale x 4 x i32> zeroinitializer
  %vc = urem <vscale x 4 x i8> %va, %splat
  ret <vscale x 4 x i8> %vc
}

define <vscale x 8 x i8> @vremu_vv_nxv8i8(<vscale x 8 x i8> %va, <vscale x 8 x i8> %vb) {
; CHECK-LABEL: vremu_vv_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 8 x i8> %va, %vb
  ret <vscale x 8 x i8> %vc
}

define <vscale x 8 x i8> @vremu_vx_nxv8i8(<vscale x 8 x i8> %va, i8 signext %b) {
; CHECK-LABEL: vremu_vx_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = urem <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i8> %vc
}

define <vscale x 8 x i8> @vremu_vi_nxv8i8_0(<vscale x 8 x i8> %va) {
; CHECK-LABEL: vremu_vi_nxv8i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 33
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, mu
; CHECK-NEXT:    vmulhu.vx v9, v8, a0
; CHECK-NEXT:    vsrl.vi v9, v9, 5
; CHECK-NEXT:    li a0, -7
; CHECK-NEXT:    vnmsac.vx v8, a0, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i8> poison, i8 -7, i32 0
  %splat = shufflevector <vscale x 8 x i8> %head, <vscale x 8 x i8> poison, <vscale x 8 x i32> zeroinitializer
  %vc = urem <vscale x 8 x i8> %va, %splat
  ret <vscale x 8 x i8> %vc
}

define <vscale x 16 x i8> @vremu_vv_nxv16i8(<vscale x 16 x i8> %va, <vscale x 16 x i8> %vb) {
; CHECK-LABEL: vremu_vv_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = urem <vscale x 16 x i8> %va, %vb
  ret <vscale x 16 x i8> %vc
}

define <vscale x 16 x i8> @vremu_vx_nxv16i8(<vscale x 16 x i8> %va, i8 signext %b) {
; CHECK-LABEL: vremu_vx_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 16 x i8> %head, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %vc = urem <vscale x 16 x i8> %va, %splat
  ret <vscale x 16 x i8> %vc
}

define <vscale x 16 x i8> @vremu_vi_nxv16i8_0(<vscale x 16 x i8> %va) {
; CHECK-LABEL: vremu_vi_nxv16i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 33
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, mu
; CHECK-NEXT:    vmulhu.vx v10, v8, a0
; CHECK-NEXT:    vsrl.vi v10, v10, 5
; CHECK-NEXT:    li a0, -7
; CHECK-NEXT:    vnmsac.vx v8, a0, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x i8> poison, i8 -7, i32 0
  %splat = shufflevector <vscale x 16 x i8> %head, <vscale x 16 x i8> poison, <vscale x 16 x i32> zeroinitializer
  %vc = urem <vscale x 16 x i8> %va, %splat
  ret <vscale x 16 x i8> %vc
}

define <vscale x 32 x i8> @vremu_vv_nxv32i8(<vscale x 32 x i8> %va, <vscale x 32 x i8> %vb) {
; CHECK-LABEL: vremu_vv_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m4, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v12
; CHECK-NEXT:    ret
  %vc = urem <vscale x 32 x i8> %va, %vb
  ret <vscale x 32 x i8> %vc
}

define <vscale x 32 x i8> @vremu_vx_nxv32i8(<vscale x 32 x i8> %va, i8 signext %b) {
; CHECK-LABEL: vremu_vx_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 32 x i8> %head, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %vc = urem <vscale x 32 x i8> %va, %splat
  ret <vscale x 32 x i8> %vc
}

define <vscale x 32 x i8> @vremu_vi_nxv32i8_0(<vscale x 32 x i8> %va) {
; CHECK-LABEL: vremu_vi_nxv32i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 33
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, mu
; CHECK-NEXT:    vmulhu.vx v12, v8, a0
; CHECK-NEXT:    vsrl.vi v12, v12, 5
; CHECK-NEXT:    li a0, -7
; CHECK-NEXT:    vnmsac.vx v8, a0, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x i8> poison, i8 -7, i32 0
  %splat = shufflevector <vscale x 32 x i8> %head, <vscale x 32 x i8> poison, <vscale x 32 x i32> zeroinitializer
  %vc = urem <vscale x 32 x i8> %va, %splat
  ret <vscale x 32 x i8> %vc
}

define <vscale x 64 x i8> @vremu_vv_nxv64i8(<vscale x 64 x i8> %va, <vscale x 64 x i8> %vb) {
; CHECK-LABEL: vremu_vv_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e8, m8, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v16
; CHECK-NEXT:    ret
  %vc = urem <vscale x 64 x i8> %va, %vb
  ret <vscale x 64 x i8> %vc
}

define <vscale x 64 x i8> @vremu_vx_nxv64i8(<vscale x 64 x i8> %va, i8 signext %b) {
; CHECK-LABEL: vremu_vx_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m8, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 64 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <vscale x 64 x i8> %head, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %vc = urem <vscale x 64 x i8> %va, %splat
  ret <vscale x 64 x i8> %vc
}

define <vscale x 64 x i8> @vremu_vi_nxv64i8_0(<vscale x 64 x i8> %va) {
; CHECK-LABEL: vremu_vi_nxv64i8_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 33
; CHECK-NEXT:    vsetvli a1, zero, e8, m8, ta, mu
; CHECK-NEXT:    vmulhu.vx v16, v8, a0
; CHECK-NEXT:    vsrl.vi v16, v16, 5
; CHECK-NEXT:    li a0, -7
; CHECK-NEXT:    vnmsac.vx v8, a0, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 64 x i8> poison, i8 -7, i32 0
  %splat = shufflevector <vscale x 64 x i8> %head, <vscale x 64 x i8> poison, <vscale x 64 x i32> zeroinitializer
  %vc = urem <vscale x 64 x i8> %va, %splat
  ret <vscale x 64 x i8> %vc
}

define <vscale x 1 x i16> @vremu_vv_nxv1i16(<vscale x 1 x i16> %va, <vscale x 1 x i16> %vb) {
; CHECK-LABEL: vremu_vv_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 1 x i16> %va, %vb
  ret <vscale x 1 x i16> %vc
}

define <vscale x 1 x i16> @vremu_vx_nxv1i16(<vscale x 1 x i16> %va, i16 signext %b) {
; CHECK-LABEL: vremu_vx_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %vc = urem <vscale x 1 x i16> %va, %splat
  ret <vscale x 1 x i16> %vc
}

define <vscale x 1 x i16> @vremu_vi_nxv1i16_0(<vscale x 1 x i16> %va) {
; RV32-LABEL: vremu_vi_nxv1i16_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 2
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e16, mf4, ta, mu
; RV32-NEXT:    vmulhu.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v9, v9, 13
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv1i16_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 2
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e16, mf4, ta, mu
; RV64-NEXT:    vmulhu.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v9, v9, 13
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v9
; RV64-NEXT:    ret
  %head = insertelement <vscale x 1 x i16> poison, i16 -7, i32 0
  %splat = shufflevector <vscale x 1 x i16> %head, <vscale x 1 x i16> poison, <vscale x 1 x i32> zeroinitializer
  %vc = urem <vscale x 1 x i16> %va, %splat
  ret <vscale x 1 x i16> %vc
}

define <vscale x 2 x i16> @vremu_vv_nxv2i16(<vscale x 2 x i16> %va, <vscale x 2 x i16> %vb) {
; CHECK-LABEL: vremu_vv_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 2 x i16> %va, %vb
  ret <vscale x 2 x i16> %vc
}

define <vscale x 2 x i16> @vremu_vx_nxv2i16(<vscale x 2 x i16> %va, i16 signext %b) {
; CHECK-LABEL: vremu_vx_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %vc = urem <vscale x 2 x i16> %va, %splat
  ret <vscale x 2 x i16> %vc
}

define <vscale x 2 x i16> @vremu_vi_nxv2i16_0(<vscale x 2 x i16> %va) {
; RV32-LABEL: vremu_vi_nxv2i16_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 2
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e16, mf2, ta, mu
; RV32-NEXT:    vmulhu.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v9, v9, 13
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv2i16_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 2
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e16, mf2, ta, mu
; RV64-NEXT:    vmulhu.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v9, v9, 13
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v9
; RV64-NEXT:    ret
  %head = insertelement <vscale x 2 x i16> poison, i16 -7, i32 0
  %splat = shufflevector <vscale x 2 x i16> %head, <vscale x 2 x i16> poison, <vscale x 2 x i32> zeroinitializer
  %vc = urem <vscale x 2 x i16> %va, %splat
  ret <vscale x 2 x i16> %vc
}

define <vscale x 4 x i16> @vremu_vv_nxv4i16(<vscale x 4 x i16> %va, <vscale x 4 x i16> %vb) {
; CHECK-LABEL: vremu_vv_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 4 x i16> %va, %vb
  ret <vscale x 4 x i16> %vc
}

define <vscale x 4 x i16> @vremu_vx_nxv4i16(<vscale x 4 x i16> %va, i16 signext %b) {
; CHECK-LABEL: vremu_vx_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %vc = urem <vscale x 4 x i16> %va, %splat
  ret <vscale x 4 x i16> %vc
}

define <vscale x 4 x i16> @vremu_vi_nxv4i16_0(<vscale x 4 x i16> %va) {
; RV32-LABEL: vremu_vi_nxv4i16_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 2
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e16, m1, ta, mu
; RV32-NEXT:    vmulhu.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v9, v9, 13
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv4i16_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 2
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e16, m1, ta, mu
; RV64-NEXT:    vmulhu.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v9, v9, 13
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v9
; RV64-NEXT:    ret
  %head = insertelement <vscale x 4 x i16> poison, i16 -7, i32 0
  %splat = shufflevector <vscale x 4 x i16> %head, <vscale x 4 x i16> poison, <vscale x 4 x i32> zeroinitializer
  %vc = urem <vscale x 4 x i16> %va, %splat
  ret <vscale x 4 x i16> %vc
}

define <vscale x 8 x i16> @vremu_vv_nxv8i16(<vscale x 8 x i16> %va, <vscale x 8 x i16> %vb) {
; CHECK-LABEL: vremu_vv_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = urem <vscale x 8 x i16> %va, %vb
  ret <vscale x 8 x i16> %vc
}

define <vscale x 8 x i16> @vremu_vx_nxv8i16(<vscale x 8 x i16> %va, i16 signext %b) {
; CHECK-LABEL: vremu_vx_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = urem <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i16> %vc
}

define <vscale x 8 x i16> @vremu_vi_nxv8i16_0(<vscale x 8 x i16> %va) {
; RV32-LABEL: vremu_vi_nxv8i16_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 2
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e16, m2, ta, mu
; RV32-NEXT:    vmulhu.vx v10, v8, a0
; RV32-NEXT:    vsrl.vi v10, v10, 13
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv8i16_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 2
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e16, m2, ta, mu
; RV64-NEXT:    vmulhu.vx v10, v8, a0
; RV64-NEXT:    vsrl.vi v10, v10, 13
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v10
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i16> poison, i16 -7, i32 0
  %splat = shufflevector <vscale x 8 x i16> %head, <vscale x 8 x i16> poison, <vscale x 8 x i32> zeroinitializer
  %vc = urem <vscale x 8 x i16> %va, %splat
  ret <vscale x 8 x i16> %vc
}

define <vscale x 16 x i16> @vremu_vv_nxv16i16(<vscale x 16 x i16> %va, <vscale x 16 x i16> %vb) {
; CHECK-LABEL: vremu_vv_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v12
; CHECK-NEXT:    ret
  %vc = urem <vscale x 16 x i16> %va, %vb
  ret <vscale x 16 x i16> %vc
}

define <vscale x 16 x i16> @vremu_vx_nxv16i16(<vscale x 16 x i16> %va, i16 signext %b) {
; CHECK-LABEL: vremu_vx_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 16 x i16> %head, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %vc = urem <vscale x 16 x i16> %va, %splat
  ret <vscale x 16 x i16> %vc
}

define <vscale x 16 x i16> @vremu_vi_nxv16i16_0(<vscale x 16 x i16> %va) {
; RV32-LABEL: vremu_vi_nxv16i16_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 2
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e16, m4, ta, mu
; RV32-NEXT:    vmulhu.vx v12, v8, a0
; RV32-NEXT:    vsrl.vi v12, v12, 13
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv16i16_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 2
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e16, m4, ta, mu
; RV64-NEXT:    vmulhu.vx v12, v8, a0
; RV64-NEXT:    vsrl.vi v12, v12, 13
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v12
; RV64-NEXT:    ret
  %head = insertelement <vscale x 16 x i16> poison, i16 -7, i32 0
  %splat = shufflevector <vscale x 16 x i16> %head, <vscale x 16 x i16> poison, <vscale x 16 x i32> zeroinitializer
  %vc = urem <vscale x 16 x i16> %va, %splat
  ret <vscale x 16 x i16> %vc
}

define <vscale x 32 x i16> @vremu_vv_nxv32i16(<vscale x 32 x i16> %va, <vscale x 32 x i16> %vb) {
; CHECK-LABEL: vremu_vv_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v16
; CHECK-NEXT:    ret
  %vc = urem <vscale x 32 x i16> %va, %vb
  ret <vscale x 32 x i16> %vc
}

define <vscale x 32 x i16> @vremu_vx_nxv32i16(<vscale x 32 x i16> %va, i16 signext %b) {
; CHECK-LABEL: vremu_vx_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m8, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 32 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <vscale x 32 x i16> %head, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %vc = urem <vscale x 32 x i16> %va, %splat
  ret <vscale x 32 x i16> %vc
}

define <vscale x 32 x i16> @vremu_vi_nxv32i16_0(<vscale x 32 x i16> %va) {
; RV32-LABEL: vremu_vi_nxv32i16_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 2
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e16, m8, ta, mu
; RV32-NEXT:    vmulhu.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v16, v16, 13
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv32i16_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 2
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e16, m8, ta, mu
; RV64-NEXT:    vmulhu.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v16, v16, 13
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v16
; RV64-NEXT:    ret
  %head = insertelement <vscale x 32 x i16> poison, i16 -7, i32 0
  %splat = shufflevector <vscale x 32 x i16> %head, <vscale x 32 x i16> poison, <vscale x 32 x i32> zeroinitializer
  %vc = urem <vscale x 32 x i16> %va, %splat
  ret <vscale x 32 x i16> %vc
}

define <vscale x 1 x i32> @vremu_vv_nxv1i32(<vscale x 1 x i32> %va, <vscale x 1 x i32> %vb) {
; CHECK-LABEL: vremu_vv_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 1 x i32> %va, %vb
  ret <vscale x 1 x i32> %vc
}

define <vscale x 1 x i32> @vremu_vx_nxv1i32(<vscale x 1 x i32> %va, i32 signext %b) {
; CHECK-LABEL: vremu_vx_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vc = urem <vscale x 1 x i32> %va, %splat
  ret <vscale x 1 x i32> %vc
}

define <vscale x 1 x i32> @vremu_vi_nxv1i32_0(<vscale x 1 x i32> %va) {
; RV32-LABEL: vremu_vi_nxv1i32_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 131072
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e32, mf2, ta, mu
; RV32-NEXT:    vmulhu.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v9, v9, 29
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv1i32_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 131072
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e32, mf2, ta, mu
; RV64-NEXT:    vmulhu.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v9, v9, 29
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v9
; RV64-NEXT:    ret
  %head = insertelement <vscale x 1 x i32> poison, i32 -7, i32 0
  %splat = shufflevector <vscale x 1 x i32> %head, <vscale x 1 x i32> poison, <vscale x 1 x i32> zeroinitializer
  %vc = urem <vscale x 1 x i32> %va, %splat
  ret <vscale x 1 x i32> %vc
}

define <vscale x 2 x i32> @vremu_vv_nxv2i32(<vscale x 2 x i32> %va, <vscale x 2 x i32> %vb) {
; CHECK-LABEL: vremu_vv_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 2 x i32> %va, %vb
  ret <vscale x 2 x i32> %vc
}

define <vscale x 2 x i32> @vremu_vx_nxv2i32(<vscale x 2 x i32> %va, i32 signext %b) {
; CHECK-LABEL: vremu_vx_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vc = urem <vscale x 2 x i32> %va, %splat
  ret <vscale x 2 x i32> %vc
}

define <vscale x 2 x i32> @vremu_vi_nxv2i32_0(<vscale x 2 x i32> %va) {
; RV32-LABEL: vremu_vi_nxv2i32_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 131072
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; RV32-NEXT:    vmulhu.vx v9, v8, a0
; RV32-NEXT:    vsrl.vi v9, v9, 29
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v9
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv2i32_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 131072
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e32, m1, ta, mu
; RV64-NEXT:    vmulhu.vx v9, v8, a0
; RV64-NEXT:    vsrl.vi v9, v9, 29
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v9
; RV64-NEXT:    ret
  %head = insertelement <vscale x 2 x i32> poison, i32 -7, i32 0
  %splat = shufflevector <vscale x 2 x i32> %head, <vscale x 2 x i32> poison, <vscale x 2 x i32> zeroinitializer
  %vc = urem <vscale x 2 x i32> %va, %splat
  ret <vscale x 2 x i32> %vc
}

define <vscale x 4 x i32> @vremu_vv_nxv4i32(<vscale x 4 x i32> %va, <vscale x 4 x i32> %vb) {
; CHECK-LABEL: vremu_vv_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = urem <vscale x 4 x i32> %va, %vb
  ret <vscale x 4 x i32> %vc
}

define <vscale x 4 x i32> @vremu_vx_nxv4i32(<vscale x 4 x i32> %va, i32 signext %b) {
; CHECK-LABEL: vremu_vx_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vc = urem <vscale x 4 x i32> %va, %splat
  ret <vscale x 4 x i32> %vc
}

define <vscale x 4 x i32> @vremu_vi_nxv4i32_0(<vscale x 4 x i32> %va) {
; RV32-LABEL: vremu_vi_nxv4i32_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 131072
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e32, m2, ta, mu
; RV32-NEXT:    vmulhu.vx v10, v8, a0
; RV32-NEXT:    vsrl.vi v10, v10, 29
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v10
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv4i32_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 131072
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e32, m2, ta, mu
; RV64-NEXT:    vmulhu.vx v10, v8, a0
; RV64-NEXT:    vsrl.vi v10, v10, 29
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v10
; RV64-NEXT:    ret
  %head = insertelement <vscale x 4 x i32> poison, i32 -7, i32 0
  %splat = shufflevector <vscale x 4 x i32> %head, <vscale x 4 x i32> poison, <vscale x 4 x i32> zeroinitializer
  %vc = urem <vscale x 4 x i32> %va, %splat
  ret <vscale x 4 x i32> %vc
}

define <vscale x 8 x i32> @vremu_vv_nxv8i32(<vscale x 8 x i32> %va, <vscale x 8 x i32> %vb) {
; CHECK-LABEL: vremu_vv_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v12
; CHECK-NEXT:    ret
  %vc = urem <vscale x 8 x i32> %va, %vb
  ret <vscale x 8 x i32> %vc
}

define <vscale x 8 x i32> @vremu_vx_nxv8i32(<vscale x 8 x i32> %va, i32 signext %b) {
; CHECK-LABEL: vremu_vx_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = urem <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i32> %vc
}

define <vscale x 8 x i32> @vremu_vi_nxv8i32_0(<vscale x 8 x i32> %va) {
; RV32-LABEL: vremu_vi_nxv8i32_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 131072
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e32, m4, ta, mu
; RV32-NEXT:    vmulhu.vx v12, v8, a0
; RV32-NEXT:    vsrl.vi v12, v12, 29
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v12
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv8i32_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 131072
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e32, m4, ta, mu
; RV64-NEXT:    vmulhu.vx v12, v8, a0
; RV64-NEXT:    vsrl.vi v12, v12, 29
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v12
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i32> poison, i32 -7, i32 0
  %splat = shufflevector <vscale x 8 x i32> %head, <vscale x 8 x i32> poison, <vscale x 8 x i32> zeroinitializer
  %vc = urem <vscale x 8 x i32> %va, %splat
  ret <vscale x 8 x i32> %vc
}

define <vscale x 16 x i32> @vremu_vv_nxv16i32(<vscale x 16 x i32> %va, <vscale x 16 x i32> %vb) {
; CHECK-LABEL: vremu_vv_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v16
; CHECK-NEXT:    ret
  %vc = urem <vscale x 16 x i32> %va, %vb
  ret <vscale x 16 x i32> %vc
}

define <vscale x 16 x i32> @vremu_vx_nxv16i32(<vscale x 16 x i32> %va, i32 signext %b) {
; CHECK-LABEL: vremu_vx_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m8, ta, mu
; CHECK-NEXT:    vremu.vx v8, v8, a0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 16 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <vscale x 16 x i32> %head, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %vc = urem <vscale x 16 x i32> %va, %splat
  ret <vscale x 16 x i32> %vc
}

define <vscale x 16 x i32> @vremu_vi_nxv16i32_0(<vscale x 16 x i32> %va) {
; RV32-LABEL: vremu_vi_nxv16i32_0:
; RV32:       # %bb.0:
; RV32-NEXT:    lui a0, 131072
; RV32-NEXT:    addi a0, a0, 1
; RV32-NEXT:    vsetvli a1, zero, e32, m8, ta, mu
; RV32-NEXT:    vmulhu.vx v16, v8, a0
; RV32-NEXT:    vsrl.vi v16, v16, 29
; RV32-NEXT:    li a0, -7
; RV32-NEXT:    vnmsac.vx v8, a0, v16
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vi_nxv16i32_0:
; RV64:       # %bb.0:
; RV64-NEXT:    lui a0, 131072
; RV64-NEXT:    addiw a0, a0, 1
; RV64-NEXT:    vsetvli a1, zero, e32, m8, ta, mu
; RV64-NEXT:    vmulhu.vx v16, v8, a0
; RV64-NEXT:    vsrl.vi v16, v16, 29
; RV64-NEXT:    li a0, -7
; RV64-NEXT:    vnmsac.vx v8, a0, v16
; RV64-NEXT:    ret
  %head = insertelement <vscale x 16 x i32> poison, i32 -7, i32 0
  %splat = shufflevector <vscale x 16 x i32> %head, <vscale x 16 x i32> poison, <vscale x 16 x i32> zeroinitializer
  %vc = urem <vscale x 16 x i32> %va, %splat
  ret <vscale x 16 x i32> %vc
}

define <vscale x 1 x i64> @vremu_vv_nxv1i64(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb) {
; CHECK-LABEL: vremu_vv_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v9
; CHECK-NEXT:    ret
  %vc = urem <vscale x 1 x i64> %va, %vb
  ret <vscale x 1 x i64> %vc
}

define <vscale x 1 x i64> @vremu_vx_nxv1i64(<vscale x 1 x i64> %va, i64 %b) {
; RV32-LABEL: vremu_vx_nxv1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m1, ta, mu
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vremu.vv v8, v8, v9
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vx_nxv1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m1, ta, mu
; RV64-NEXT:    vremu.vx v8, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 1 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 1 x i64> %head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %vc = urem <vscale x 1 x i64> %va, %splat
  ret <vscale x 1 x i64> %vc
}

define <vscale x 1 x i64> @vremu_vi_nxv1i64_0(<vscale x 1 x i64> %va) {
; RV32-V-LABEL: vremu_vi_nxv1i64_0:
; RV32-V:       # %bb.0:
; RV32-V-NEXT:    addi sp, sp, -16
; RV32-V-NEXT:    .cfi_def_cfa_offset 16
; RV32-V-NEXT:    lui a0, 131072
; RV32-V-NEXT:    sw a0, 12(sp)
; RV32-V-NEXT:    li a0, 1
; RV32-V-NEXT:    sw a0, 8(sp)
; RV32-V-NEXT:    addi a0, sp, 8
; RV32-V-NEXT:    vsetvli a1, zero, e64, m1, ta, mu
; RV32-V-NEXT:    vlse64.v v9, (a0), zero
; RV32-V-NEXT:    vmulhu.vv v9, v8, v9
; RV32-V-NEXT:    li a0, 61
; RV32-V-NEXT:    vsrl.vx v9, v9, a0
; RV32-V-NEXT:    li a0, -7
; RV32-V-NEXT:    vnmsac.vx v8, a0, v9
; RV32-V-NEXT:    addi sp, sp, 16
; RV32-V-NEXT:    ret
;
; ZVE64X-LABEL: vremu_vi_nxv1i64_0:
; ZVE64X:       # %bb.0:
; ZVE64X-NEXT:    li a0, -7
; ZVE64X-NEXT:    vsetvli a1, zero, e64, m1, ta, mu
; ZVE64X-NEXT:    vremu.vx v8, v8, a0
; ZVE64X-NEXT:    ret
;
; RV64-V-LABEL: vremu_vi_nxv1i64_0:
; RV64-V:       # %bb.0:
; RV64-V-NEXT:    li a0, 1
; RV64-V-NEXT:    slli a0, a0, 61
; RV64-V-NEXT:    addi a0, a0, 1
; RV64-V-NEXT:    vsetvli a1, zero, e64, m1, ta, mu
; RV64-V-NEXT:    vmulhu.vx v9, v8, a0
; RV64-V-NEXT:    li a0, 61
; RV64-V-NEXT:    vsrl.vx v9, v9, a0
; RV64-V-NEXT:    li a0, -7
; RV64-V-NEXT:    vnmsac.vx v8, a0, v9
; RV64-V-NEXT:    ret
  %head = insertelement <vscale x 1 x i64> poison, i64 -7, i32 0
  %splat = shufflevector <vscale x 1 x i64> %head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %vc = urem <vscale x 1 x i64> %va, %splat
  ret <vscale x 1 x i64> %vc
}

; fold (urem x, pow2) -> (and x, pow2-1)
define <vscale x 1 x i64> @vremu_vi_nxv1i64_1(<vscale x 1 x i64> %va) {
; CHECK-LABEL: vremu_vi_nxv1i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, mu
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 1 x i64> %head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %vc = urem <vscale x 1 x i64> %va, %splat
  ret <vscale x 1 x i64> %vc
}

; fold (urem x, (shl pow2, y)) -> (and x, (add (shl pow2, y), -1))
define <vscale x 1 x i64> @vremu_vi_nxv1i64_2(<vscale x 1 x i64> %va, <vscale x 1 x i64> %vb) {
; CHECK-LABEL: vremu_vi_nxv1i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, mu
; CHECK-NEXT:    vmv.v.x v10, a0
; CHECK-NEXT:    vsll.vv v9, v10, v9
; CHECK-NEXT:    vadd.vi v9, v9, -1
; CHECK-NEXT:    vand.vv v8, v8, v9
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 1 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 1 x i64> %head, <vscale x 1 x i64> poison, <vscale x 1 x i32> zeroinitializer
  %vc = shl <vscale x 1 x i64> %splat, %vb
  %vd = urem <vscale x 1 x i64> %va, %vc
  ret <vscale x 1 x i64> %vd
}

define <vscale x 2 x i64> @vremu_vv_nxv2i64(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb) {
; CHECK-LABEL: vremu_vv_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v10
; CHECK-NEXT:    ret
  %vc = urem <vscale x 2 x i64> %va, %vb
  ret <vscale x 2 x i64> %vc
}

define <vscale x 2 x i64> @vremu_vx_nxv2i64(<vscale x 2 x i64> %va, i64 %b) {
; RV32-LABEL: vremu_vx_nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m2, ta, mu
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vremu.vv v8, v8, v10
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vx_nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m2, ta, mu
; RV64-NEXT:    vremu.vx v8, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 2 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %vc = urem <vscale x 2 x i64> %va, %splat
  ret <vscale x 2 x i64> %vc
}

define <vscale x 2 x i64> @vremu_vi_nxv2i64_0(<vscale x 2 x i64> %va) {
; RV32-V-LABEL: vremu_vi_nxv2i64_0:
; RV32-V:       # %bb.0:
; RV32-V-NEXT:    addi sp, sp, -16
; RV32-V-NEXT:    .cfi_def_cfa_offset 16
; RV32-V-NEXT:    lui a0, 131072
; RV32-V-NEXT:    sw a0, 12(sp)
; RV32-V-NEXT:    li a0, 1
; RV32-V-NEXT:    sw a0, 8(sp)
; RV32-V-NEXT:    addi a0, sp, 8
; RV32-V-NEXT:    vsetvli a1, zero, e64, m2, ta, mu
; RV32-V-NEXT:    vlse64.v v10, (a0), zero
; RV32-V-NEXT:    vmulhu.vv v10, v8, v10
; RV32-V-NEXT:    li a0, 61
; RV32-V-NEXT:    vsrl.vx v10, v10, a0
; RV32-V-NEXT:    li a0, -7
; RV32-V-NEXT:    vnmsac.vx v8, a0, v10
; RV32-V-NEXT:    addi sp, sp, 16
; RV32-V-NEXT:    ret
;
; ZVE64X-LABEL: vremu_vi_nxv2i64_0:
; ZVE64X:       # %bb.0:
; ZVE64X-NEXT:    li a0, -7
; ZVE64X-NEXT:    vsetvli a1, zero, e64, m2, ta, mu
; ZVE64X-NEXT:    vremu.vx v8, v8, a0
; ZVE64X-NEXT:    ret
;
; RV64-V-LABEL: vremu_vi_nxv2i64_0:
; RV64-V:       # %bb.0:
; RV64-V-NEXT:    li a0, 1
; RV64-V-NEXT:    slli a0, a0, 61
; RV64-V-NEXT:    addi a0, a0, 1
; RV64-V-NEXT:    vsetvli a1, zero, e64, m2, ta, mu
; RV64-V-NEXT:    vmulhu.vx v10, v8, a0
; RV64-V-NEXT:    li a0, 61
; RV64-V-NEXT:    vsrl.vx v10, v10, a0
; RV64-V-NEXT:    li a0, -7
; RV64-V-NEXT:    vnmsac.vx v8, a0, v10
; RV64-V-NEXT:    ret
  %head = insertelement <vscale x 2 x i64> poison, i64 -7, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %vc = urem <vscale x 2 x i64> %va, %splat
  ret <vscale x 2 x i64> %vc
}

; fold (urem x, pow2) -> (and x, pow2-1)
define <vscale x 2 x i64> @vremu_vi_nxv2i64_1(<vscale x 2 x i64> %va) {
; CHECK-LABEL: vremu_vi_nxv2i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, mu
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %vc = urem <vscale x 2 x i64> %va, %splat
  ret <vscale x 2 x i64> %vc
}

; fold (urem x, (shl pow2, y)) -> (and x, (add (shl pow2, y), -1))
define <vscale x 2 x i64> @vremu_vi_nxv2i64_2(<vscale x 2 x i64> %va, <vscale x 2 x i64> %vb) {
; CHECK-LABEL: vremu_vi_nxv2i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, mu
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsll.vv v10, v12, v10
; CHECK-NEXT:    vadd.vi v10, v10, -1
; CHECK-NEXT:    vand.vv v8, v8, v10
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 2 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 2 x i64> %head, <vscale x 2 x i64> poison, <vscale x 2 x i32> zeroinitializer
  %vc = shl <vscale x 2 x i64> %splat, %vb
  %vd = urem <vscale x 2 x i64> %va, %vc
  ret <vscale x 2 x i64> %vd
}

define <vscale x 4 x i64> @vremu_vv_nxv4i64(<vscale x 4 x i64> %va, <vscale x 4 x i64> %vb) {
; CHECK-LABEL: vremu_vv_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v12
; CHECK-NEXT:    ret
  %vc = urem <vscale x 4 x i64> %va, %vb
  ret <vscale x 4 x i64> %vc
}

define <vscale x 4 x i64> @vremu_vx_nxv4i64(<vscale x 4 x i64> %va, i64 %b) {
; RV32-LABEL: vremu_vx_nxv4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m4, ta, mu
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vremu.vv v8, v8, v12
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vx_nxv4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m4, ta, mu
; RV64-NEXT:    vremu.vx v8, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 4 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %vc = urem <vscale x 4 x i64> %va, %splat
  ret <vscale x 4 x i64> %vc
}

define <vscale x 4 x i64> @vremu_vi_nxv4i64_0(<vscale x 4 x i64> %va) {
; RV32-V-LABEL: vremu_vi_nxv4i64_0:
; RV32-V:       # %bb.0:
; RV32-V-NEXT:    addi sp, sp, -16
; RV32-V-NEXT:    .cfi_def_cfa_offset 16
; RV32-V-NEXT:    lui a0, 131072
; RV32-V-NEXT:    sw a0, 12(sp)
; RV32-V-NEXT:    li a0, 1
; RV32-V-NEXT:    sw a0, 8(sp)
; RV32-V-NEXT:    addi a0, sp, 8
; RV32-V-NEXT:    vsetvli a1, zero, e64, m4, ta, mu
; RV32-V-NEXT:    vlse64.v v12, (a0), zero
; RV32-V-NEXT:    vmulhu.vv v12, v8, v12
; RV32-V-NEXT:    li a0, 61
; RV32-V-NEXT:    vsrl.vx v12, v12, a0
; RV32-V-NEXT:    li a0, -7
; RV32-V-NEXT:    vnmsac.vx v8, a0, v12
; RV32-V-NEXT:    addi sp, sp, 16
; RV32-V-NEXT:    ret
;
; ZVE64X-LABEL: vremu_vi_nxv4i64_0:
; ZVE64X:       # %bb.0:
; ZVE64X-NEXT:    li a0, -7
; ZVE64X-NEXT:    vsetvli a1, zero, e64, m4, ta, mu
; ZVE64X-NEXT:    vremu.vx v8, v8, a0
; ZVE64X-NEXT:    ret
;
; RV64-V-LABEL: vremu_vi_nxv4i64_0:
; RV64-V:       # %bb.0:
; RV64-V-NEXT:    li a0, 1
; RV64-V-NEXT:    slli a0, a0, 61
; RV64-V-NEXT:    addi a0, a0, 1
; RV64-V-NEXT:    vsetvli a1, zero, e64, m4, ta, mu
; RV64-V-NEXT:    vmulhu.vx v12, v8, a0
; RV64-V-NEXT:    li a0, 61
; RV64-V-NEXT:    vsrl.vx v12, v12, a0
; RV64-V-NEXT:    li a0, -7
; RV64-V-NEXT:    vnmsac.vx v8, a0, v12
; RV64-V-NEXT:    ret
  %head = insertelement <vscale x 4 x i64> poison, i64 -7, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %vc = urem <vscale x 4 x i64> %va, %splat
  ret <vscale x 4 x i64> %vc
}

; fold (urem x, pow2) -> (and x, pow2-1)
define <vscale x 4 x i64> @vremu_vi_nxv4i64_1(<vscale x 4 x i64> %va) {
; CHECK-LABEL: vremu_vi_nxv4i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, mu
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %vc = urem <vscale x 4 x i64> %va, %splat
  ret <vscale x 4 x i64> %vc
}

;fold (urem x, (shl pow2, y)) -> (and x, (add (shl pow2, y), -1))
define <vscale x 4 x i64> @vremu_vi_nxv4i64_2(<vscale x 4 x i64> %va, <vscale x 4 x i64> %vb) {
; CHECK-LABEL: vremu_vi_nxv4i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vsetvli a1, zero, e64, m4, ta, mu
; CHECK-NEXT:    vmv.v.x v16, a0
; CHECK-NEXT:    vsll.vv v12, v16, v12
; CHECK-NEXT:    vadd.vi v12, v12, -1
; CHECK-NEXT:    vand.vv v8, v8, v12
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 4 x i64> %head, <vscale x 4 x i64> poison, <vscale x 4 x i32> zeroinitializer
  %vc = shl <vscale x 4 x i64> %splat, %vb
  %vd = urem <vscale x 4 x i64> %va, %vc
  ret <vscale x 4 x i64> %vd
}

define <vscale x 8 x i64> @vremu_vv_nxv8i64(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: vremu_vv_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vremu.vv v8, v8, v16
; CHECK-NEXT:    ret
  %vc = urem <vscale x 8 x i64> %va, %vb
  ret <vscale x 8 x i64> %vc
}

define <vscale x 8 x i64> @vremu_vx_nxv8i64(<vscale x 8 x i64> %va, i64 %b) {
; RV32-LABEL: vremu_vx_nxv8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    .cfi_def_cfa_offset 16
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli a1, zero, e64, m8, ta, mu
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vremu.vv v8, v8, v16
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: vremu_vx_nxv8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetvli a1, zero, e64, m8, ta, mu
; RV64-NEXT:    vremu.vx v8, v8, a0
; RV64-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = urem <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i64> %vc
}

define <vscale x 8 x i64> @vremu_vi_nxv8i64_0(<vscale x 8 x i64> %va) {
; RV32-V-LABEL: vremu_vi_nxv8i64_0:
; RV32-V:       # %bb.0:
; RV32-V-NEXT:    addi sp, sp, -16
; RV32-V-NEXT:    .cfi_def_cfa_offset 16
; RV32-V-NEXT:    lui a0, 131072
; RV32-V-NEXT:    sw a0, 12(sp)
; RV32-V-NEXT:    li a0, 1
; RV32-V-NEXT:    sw a0, 8(sp)
; RV32-V-NEXT:    addi a0, sp, 8
; RV32-V-NEXT:    vsetvli a1, zero, e64, m8, ta, mu
; RV32-V-NEXT:    vlse64.v v16, (a0), zero
; RV32-V-NEXT:    vmulhu.vv v16, v8, v16
; RV32-V-NEXT:    li a0, 61
; RV32-V-NEXT:    vsrl.vx v16, v16, a0
; RV32-V-NEXT:    li a0, -7
; RV32-V-NEXT:    vnmsac.vx v8, a0, v16
; RV32-V-NEXT:    addi sp, sp, 16
; RV32-V-NEXT:    ret
;
; ZVE64X-LABEL: vremu_vi_nxv8i64_0:
; ZVE64X:       # %bb.0:
; ZVE64X-NEXT:    li a0, -7
; ZVE64X-NEXT:    vsetvli a1, zero, e64, m8, ta, mu
; ZVE64X-NEXT:    vremu.vx v8, v8, a0
; ZVE64X-NEXT:    ret
;
; RV64-V-LABEL: vremu_vi_nxv8i64_0:
; RV64-V:       # %bb.0:
; RV64-V-NEXT:    li a0, 1
; RV64-V-NEXT:    slli a0, a0, 61
; RV64-V-NEXT:    addi a0, a0, 1
; RV64-V-NEXT:    vsetvli a1, zero, e64, m8, ta, mu
; RV64-V-NEXT:    vmulhu.vx v16, v8, a0
; RV64-V-NEXT:    li a0, 61
; RV64-V-NEXT:    vsrl.vx v16, v16, a0
; RV64-V-NEXT:    li a0, -7
; RV64-V-NEXT:    vnmsac.vx v8, a0, v16
; RV64-V-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 -7, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = urem <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i64> %vc
}

; fold (urem x, pow2) -> (and x, pow2-1)
define <vscale x 8 x i64> @vremu_vi_nxv8i64_1(<vscale x 8 x i64> %va) {
; CHECK-LABEL: vremu_vi_nxv8i64_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, mu
; CHECK-NEXT:    vand.vi v8, v8, 15
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = urem <vscale x 8 x i64> %va, %splat
  ret <vscale x 8 x i64> %vc
}

; fold (urem x, (shl pow2, y)) -> (and x, (add (shl pow2, y), -1))
define <vscale x 8 x i64> @vremu_vi_nxv8i64_2(<vscale x 8 x i64> %va, <vscale x 8 x i64> %vb) {
; CHECK-LABEL: vremu_vi_nxv8i64_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 16
; CHECK-NEXT:    vsetvli a1, zero, e64, m8, ta, mu
; CHECK-NEXT:    vmv.v.x v24, a0
; CHECK-NEXT:    vsll.vv v16, v24, v16
; CHECK-NEXT:    vadd.vi v16, v16, -1
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 8 x i64> poison, i64 16, i32 0
  %splat = shufflevector <vscale x 8 x i64> %head, <vscale x 8 x i64> poison, <vscale x 8 x i32> zeroinitializer
  %vc = shl <vscale x 8 x i64> %splat, %vb
  %vd = urem <vscale x 8 x i64> %va, %vc
  ret <vscale x 8 x i64> %vd
}
