/*
 * Line6 PODxt Pro USB driver - 0.5
 *
 * Copyright (C) 2004, 2005 Markus Grabner (grabner@icg.tu-graz.ac.at)
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation, version 2.
 *
 */

#ifndef MIDI_H
#define MIDI_H


#include <sound/rawmidi.h>


struct snd_podxtpro_midi
{
	/**
		 Pointer back to the PODxt Pro driver data structure.
	*/
	struct usb_podxtpro *podxtpro;

	/**
		 MIDI substream for receiving (or NULL if not active).
	*/
	snd_rawmidi_substream_t *substream_receive;

	/**
		 MIDI substream for transmitting (or NULL if not active).
	*/
	snd_rawmidi_substream_t *substream_transmit;

	/**
		 Number of currently active MIDI send URBs.
	*/
	int num_active_send_urbs;

	/**
		 Spin lock to protect updates of send_urb.
	*/
	spinlock_t send_urb_lock;

	/**
		 Spin lock to protect MIDI buffer handling.
	*/
	spinlock_t midi_transmit_lock;

	/**
		 Wait queue for MIDI transmission.
	*/
	wait_queue_head_t send_wait;
};

typedef struct snd_podxtpro_midi snd_podxtpro_midi_t;


extern int podxtpro_init_midi(struct usb_podxtpro *);
extern void podxtpro_midi_receive(struct usb_podxtpro *podxtpro, unsigned char *data, int length);


#endif
