/* $Id: zdpsmon.h,v 1.4 2005/03/17 09:15:16 akw Exp $
 *
 * Copyright (C) 2004 Zydas Inc.
 * Copyright (C) 2005 Arno WILLIG <akw@users.sourceforge.net>
 * Copyright (C) 2005 Dimitriy KOROVKIN <korovkin@users.sourceforge.net>
 * Copyright (C) 2005 Todor T. ZVISKOV <warderx@users.sourceforge.net>
 * Copyright (C) 2005 Markus KARG <markus-karg@users.sourceforge.net>
 *
 * This file is part of the ZD1211 Wireless USB Driver for Linux.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _ZDPSMON_H_
#define _ZDPSMON_H_

void ResetPSMonitor(void);
void SsInquiry(MacAddr_t *sta, StationState *sst, StationState *asst);
void AssocInfoUpdate(MacAddr_t *sta, U8 MaxRate, U8 lsInterval, U8 ZydasMode, U8 Preamble, BOOLEAN bErpSta, U8 vapId);
U16 AIdLookup(MacAddr_t *sta);
BOOLEAN AgeHashTbl(void);
BOOLEAN UpdateStaStatus(MacAddr_t *sta, StationState staSte,  U8 vapId);
int zd_SetKeyInfo(U8 *addr, U8 encryMode, U8 keyLength, U8 KeyId, U8 *pKeyContent);
Hash_t *HashSearch(MacAddr_t *pMac);
Hash_t *RxInfoIndicate(MacAddr_t *sta, PsMode psm, U8 rate);
void RxInfoUpdate(Hash_t *pHash, PsMode psm, U8 rate);
extern Hash_t *HashTbl[MAX_RECORD];
extern Hash_t *sstByAid[MAX_RECORD];
void initHashBuf(void);
void InitHashTbl(void);
void CleanupHash(Hash_t *hash);
#endif
