/* $Id: zdmic.h,v 1.8 2005/03/27 20:47:38 sagamore Exp $
 * Header file required for TKIP MIC
 *
 * Copyright (C) 2004 Zydas Inc.
 * Copyright (C) 2005 Arno WILLIG <akw@users.sourceforge.net>
 * Copyright (C) 2005 Dimitriy KOROVKIN <korovkin@users.sourceforge.net>
 * Copyright (C) 2005 Todor T. ZVISKOV <warderx@users.sourceforge.net>
 * Copyright (C) 2005 Markus KARG <markus-karg@users.sourceforge.net>
 *
 * This file is part of the ZD1211 Wireless USB Driver for Linux.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _ZDMIC_H_
#define _ZDMIC_H_

// Rotation functions on 32 bit values
#define ROL32(A, n) (((A) << (n)) | (((A)>>(32-(n))) & ((1UL << (n)) - 1 )))
#define ROR32(A, n) ROL32( (A), 32-(n) )

typedef struct {
	U32	K0, K1;		// Key
	U32	L, R;		// Current state
	U32	M;		// Message accumulator (single word)
	int	nBytesInM;	// # bytes in M
} MICvar;			// variable for MIC

// Clear the internal message, 
// resets the object to the state just after construction.
void MICclear(MICvar *MIC);

// Set the key to a new value
void MICsetKey(U8 *key, MICvar *MIC);

// Get the MIC result. Destination should accept 8 bytes of result.
// This also resets the message to empty.
void MICgetMIC(U8 *dst, MICvar *MIC);

// Add a single byte to the internal message
void MICappendByte(U8 b, MICvar *MIC);
void MICappendArr(U8 *pb, MICvar *MIC, U32 Size);

// Get U32 from 4 bytes LSByte first
U32 getUInt32(U8 *p);

// Put U32 into 4 bytes LSByte first
void putUInt32(U8 *p, U32 val);

#endif
