/* $Id: zddebug.c,v 1.11 2005/03/27 20:47:36 sagamore Exp $
 *
 * Copyright (C) 2004 Zydas Inc.
 * Copyright (C) 2005 Arno WILLIG <akw@users.sourceforge.net>
 * Copyright (C) 2005 Dimitriy KOROVKIN <korovkin@users.sourceforge.net>
 * Copyright (C) 2005 Todor T. ZVISKOV <warderx@users.sourceforge.net>
 * Copyright (C) 2005 Markus KARG <markus-karg@users.sourceforge.net>
 *
 * This file is part of the ZD1211 Wireless USB Driver for Linux.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "zd1205.h"
#include "zddebug.h"
#include "zd1211.h"

extern zd_80211Obj_t dot11Obj;

//for debug message show
extern u32 freeSignalCount;
extern u32 freeFdescCount;
extern void zd_ShowQInfo(void);
extern void zd_ShowState(void);

void zd1205_set_sniffer_mode(struct zd1205_private *macp)
{
	struct net_device *dev = macp->device;

	dev->type = ARPHRD_IEEE80211;
	dev->hard_header_len = ETH_HLEN;
	dev->addr_len = ETH_ALEN;

	if (netif_running(dev))
		netif_stop_queue(dev);
 
	zd_writel(0x01, SnifferOn);
	zd_writel(0xffffff, Rx_Filter);
	zd_writel(0x08, EncryType);
	macp->intrMask = RX_COMPLETE_EN;
}

void zd1205_dump_regs(struct zd1205_private *macp)
{
	unsigned long flags;

	printk(KERN_DEBUG "*******************************************************\n");
	printk(KERN_DEBUG "MACAddr_P1         = %08x  MACAddr_P2    = %08x\n",
	zd_readl(MACAddr_P1), zd_readl(MACAddr_P2));
	printk(KERN_DEBUG "BCNInterval        = %08x. BCNPLCPCfg    = %08x\n",
	zd_readl(BCNInterval), zd_readl(BCNPLCPCfg));
	printk(KERN_DEBUG "TSF_LowPart        = %08x, TSF_HighPart  = %08x\n",
	zd_readl(TSF_LowPart), zd_readl(TSF_HighPart));
	printk(KERN_DEBUG "DeviceState        = %08x, NAV_CCA       = %08x\n",
	zd_readl(DeviceState), zd_readl(NAV_CCA));
	printk(KERN_DEBUG "CRC32Cnt           = %08x, CRC16Cnt      = %08x\n",
	zd_readl(CRC32Cnt), zd_readl(CRC16Cnt));
	printk(KERN_DEBUG "TotalRxFrm         = %08x, TotalTxFrm    = %08x\n",
	zd_readl(TotalRxFrm), zd_readl(TotalTxFrm));
	printk(KERN_DEBUG "RxFIFOOverrun      = %08x, UnderrunCnt   = %08x\n",
	zd_readl(RxFIFOOverrun), zd_readl(UnderrunCnt));
	printk(KERN_DEBUG "BSSID_P1           = %08x, BSSID_P2      = %08x\n",
	zd_readl(BSSID_P1), zd_readl(BSSID_P2));
	printk(KERN_DEBUG "Pre_TBTT           = %08x, ATIMWndPeriod = %08x\n",
	zd_readl(Pre_TBTT), zd_readl(ATIMWndPeriod));
	printk(KERN_DEBUG "RetryCnt           = %08x, IFS_Value     = %08x\n",
	zd_readl(RetryCnt), zd_readl(IFS_Value));
	printk(KERN_DEBUG "NAV_CNT            = %08x, CWmin_CWmax   = %08x\n",
	zd_readl(NAV_CNT), zd_readl(CWmin_CWmax));
	// printk(KERN_DEBUG "GroupHash_P1       = %08x, GroupHash_P2  = %08x\n",
	// zd_readl(GroupHash_P1), zd_readl(GroupHash_P2));
	printk(KERN_DEBUG "DecrypErr_UNI      = %08x, DecrypErr_Mul = %08x\n",
	zd_readl(DecrypErr_UNI), zd_readl(DecrypErr_Mul));
}

void zd1205_dump_cnters(struct zd1205_private *macp) {
	zd1205_lock(macp);
	printk(KERN_DEBUG "*************************************************\n");
	printk(KERN_DEBUG "freeTxQ         = %08d, activeTxQ      = %08d\n", macp->freeTxQ->count, macp->activeTxQ->count);
	printk(KERN_DEBUG "freeSignalCount = %08d, freeFdescCount = %08d\n", freeSignalCount, freeFdescCount);
	//printk(KERN_DEBUG "hwTotalRxFrm    = %08d, hwTotalTxFrm   = %08d\n", macp->hwTotalRxFrm, macp->hwTotalTxFrm);
	//printk(KERN_DEBUG "hwRxFIFOOverrun = %08d, hwUnderrunCnt  = %08d\n", macp->hwRxFIFOOverrun, macp->hwUnderrunCnt);
	//printk(KERN_DEBUG "hwCRC32Cnt      = %08d, hwCRC16Cnt     = %08d\n", macp->hwCRC32Cnt, macp->hwCRC16Cnt);
	//printk(KERN_DEBUG "ErrLongFrmCnt   = %08d, ErrShortFrmCnt = %08d\n", macp->ErrLongFrmCnt, macp->ErrShortFrmCnt);
	//printk(KERN_DEBUG "ErrToHostFrmCnt = %08d, ErrZeroLenFrmCnt= %08d\n", macp->ErrToHostFrmCnt, macp->ErrZeroLenFrmCnt);
	printk(KERN_DEBUG "rxOFDMDataFrame = %08d, rx11bDataFrame = %08d\n", macp->rxOFDMDataFrame, macp->rx11bDataFrame);
	printk(KERN_DEBUG "rxSignalQuality = %08d, rxSignalStrength= %08d\n", macp->rxSignalQuality, macp->rxSignalStrength);
	printk(KERN_DEBUG "rxRate          = %08d, txRate         = %08dx\n", macp->rxInfo.rate, macp->cardSetting.CurrTxRate);
	//printk(KERN_DEBUG "rxNeedFragCnt   = %08d, rxCompFragCnt  = %08d\n", macp->rxNeedFragCnt, macp->rxCompFragCnt);
	//printk(KERN_DEBUG "ArFreeFailCnt   = %08d, ArAgedCnt      = %08d\n", macp->ArFreeFailCnt, macp->ArAgedCnt);
	//printk(KERN_DEBUG "ArSearchFailCnt = %08d, DropFirstFragCnt= %08d\n", macp->ArSearchFailCnt, macp->DropFirstFragCnt);
	//printk(KERN_DEBUG "skb_req         = %08d, AllocSkbFailCnt= %08d\n", macp->skb_req, macp->AllocSkbFailCnt);
	printk(KERN_DEBUG "txQueToUpCnt    = %08d, txQueSetCnt    = %08d\n", macp->txQueToUpCnt, macp->txQueSetCnt);
	printk(KERN_DEBUG "sleepCnt        = %08d, wakeupCnt      = %08d\n", macp->sleepCnt, macp->wakeupCnt);
	printk(KERN_DEBUG "WaitLenInfoCnt  = %08d, CompLenInfoCnt = %08d\n", macp->WaitLenInfoCnt, macp->CompLenInfoCnt);
	printk(KERN_DEBUG "Continue2Rx     = %08d, NoMergedRxCnt  = %08d\n", macp->Continue2Rx, macp->NoMergedRxCnt);
	printk(KERN_DEBUG "bcnCnt          = %08d, dtimCnt        = %08d\n", macp->bcnCnt, macp->dtimCnt);
	printk(KERN_DEBUG "txCnt           = %08d, txCmpCnt       = %08d\n", macp->txCnt, macp->txCmpCnt);
	printk(KERN_DEBUG "retryFailCnt    = %08d, rxCnt          = %08d\n", macp->retryFailCnt, macp->rxCnt);
	printk(KERN_DEBUG "usbTxCnt        = %08d, usbTxCompCnt   = %08d\n", macp->usbTxCnt, macp->usbTxCompCnt);
	printk(KERN_DEBUG "regWaitRCompCnt = %08d, regWaitWCompCnt= %08d\n", macp->regWaitRCompCnt, macp->regWaitWCompCnt);
	printk(KERN_DEBUG "regRWCompCnt    = %08d, regUnCompCnt   = %08d\n", macp->regRWCompCnt, macp->regUnCompCnt);
	printk(KERN_DEBUG "regWaitRspCnt   = %08d, regRspCompCnt  = %08d\n", macp->regWaitRspCnt, macp->regRspCompCnt);
	printk(KERN_DEBUG "regRdSleepCnt   = %08d, regRspCompCnt  = %08d\n", macp->regRdSleepCnt, macp->regRspCompCnt);
	zd_ShowQInfo();
	zd_ShowState();
	macp->bcnCnt = 0;
	macp->dtimCnt = 0;
	macp->rxCnt = 0;
	macp->txCmpCnt = 0;
	macp->txCnt = 0;
	macp->retryFailCnt = 0;
	macp->txIdleCnt = 0;
	macp->rxIdleCnt = 0;
	macp->hwTotalRxFrm = 0;
	macp->hwTotalTxFrm = 0;
	macp->hwRxFIFOOverrun = 0;
	macp->hwUnderrunCnt = 0;
	macp->hwCRC32Cnt =0;
	macp->hwCRC16Cnt =0;
	macp->ErrLongFrmCnt = 0;
	macp->ErrShortFrmCnt = 0;
	macp->ErrToHostFrmCnt = 0;
	macp->ErrZeroLenFrmCnt = 0;
	macp->rxOFDMDataFrame = 0;
	macp->rx11bDataFrame = 0;
	macp->ArFreeFailCnt = 0;
	macp->ArAgedCnt = 0;
	macp->ArSearchFailCnt = 0;
	macp->DropFirstFragCnt = 0;
	macp->rxNeedFragCnt = 0;
	macp->rxCompFragCnt = 0;
	macp->txQueToUpCnt = 0;
	macp->txQueSetCnt = 0;
	//macp->sleepCnt = 0;
	//macp->wakeupCnt = 0;
	macp->Continue2Rx = 0;
	macp->NoMergedRxCnt = 0;
	zd1205_unlock(macp);
}

void zd1205_update_brate(struct zd1205_private *macp, u32 value)
{
	u8 ii;
	u8 nRate;
	u8 *pRate;
	card_Setting_t *pSetting = &macp->cardSetting;
	u8 rate_list[4] = { 0x02, 0x04, 0x0B, 0x16 };

	/* Get the number of rates we support */
	nRate = pSetting->Info_SupportedRates[1];
	pRate = &(pSetting->Info_SupportedRates[2]);

	for (ii = 0; ii < nRate; ii++) {
		/* If the Rate is less than the basic Rate, mask 0x80 with the value. */
	if ((*pRate & 0x7f) <= rate_list[value])
		*pRate |= 0x80;
	else *pRate &= 0x7f;
		pRate++;
	}
}

void acquire_ctrl_of_phy_req(void *regp)
{
	u32 tmpValue;

	tmpValue = zd_readl(CtlReg1);
	tmpValue &= ~0x80;
	zd_writel(tmpValue, CtlReg1);
}

void release_ctrl_of_phy_req(void *regp)
{
	u32 tmpValue;	
	tmpValue = zd_readl(CtlReg1);
	tmpValue |= 0x80;
	zd_writel(tmpValue, CtlReg1);
}

void zd1205_dump_phy(struct zd1205_private *macp)
{
	void *regp = macp->regp;
	u32 regValue[4];
	int i;

	acquire_ctrl_of_phy_req(regp);
	for (i=0; i<256; i+=4) {
		// acquire_ctrl_of_phy_req(regp);
		regValue[0] = zd_readl(4*i);
		regValue[1]= zd_readl(4*(i+1));
		regValue[2]= zd_readl(4*(i+2));
		regValue[3]= zd_readl(4*(i+3));
		printk(KERN_DEBUG "CR%03d = %02x  CR%03d = %02x  CR%03d = %02x  CR%03d = %02x\n",
			i, (u8)regValue[0],  i+1, (u8)regValue[1], i+2, (u8)regValue[2], i+3, (u8)regValue[3]);
		// release_ctrl_of_phy_req(regp);
	}
	release_ctrl_of_phy_req(regp);
}

void zd1205_dump_eeprom(struct zd1205_private *macp)
{
	u32 e2pValue, e2pValue1;
	int i;
	for (i=0; i<20; i+=2) {
		e2pValue = zd_readl(E2P_SUBID+4*i);
		e2pValue1 = zd_readl(E2P_SUBID+4*(i+1));
		printk(KERN_DEBUG "0x%x = %08x,     0x%x = %08x\n", E2P_SUBID+4*i, e2pValue,  E2P_SUBID+4*(i+1), e2pValue1);
	}
}

extern void zd_ShowHashInfo(u8 aid);
void zd1205_show_hash(struct zd1205_private *macp, u32 value)
{
	if (value < 33)
		zd_ShowHashInfo(value);
}

void zd1205_show_card_setting(struct zd1205_private *macp)
{
	card_Setting_t *pSetting = &macp->cardSetting;
	printk(KERN_DEBUG "RTSThreshold   = %04x   FragThreshold  = %04x\n", 
		pSetting->RTSThreshold, pSetting->FragThreshold);
	printk(KERN_DEBUG "DtimPeriod     = %04x   BeaconInterval = %04x\n", 
		pSetting->DtimPeriod, pSetting->BeaconInterval);
	printk(KERN_DEBUG "EncryMode      = %04x   EncryOnOff     = %04x\n", 
		pSetting->EncryMode, pSetting->EncryOnOff);
	printk(KERN_DEBUG "EncryKeyId     = %04x   WepKeyLen      = %04x\n", 
		pSetting->EncryKeyId, pSetting->WepKeyLen);
	printk(KERN_DEBUG "PreambleType   = %04x   AuthMode       = %04x\n", 
		pSetting->PreambleType, pSetting->AuthMode);
	printk(KERN_DEBUG "Channel        = %04x   BssType        = %04x\n", 
		pSetting->Channel, pSetting->BssType);
	printk(KERN_DEBUG "SuggestionMode = %04x   PwrState       = %04x\n",
		macp->SuggestionMode, macp->PwrState);
	printk(KERN_DEBUG "bPSMSupported  = %04x   bAssoc         = %04x\n",
		macp->bPSMSupported, macp->bAssoc);
	printk(KERN_DEBUG "bAnyActivity   = %04x   BSS_Members    = %04x\n",
		macp->bAnyActivity, macp->BSS_Members);
}

int zd1205_zd_dbg_ioctl(struct zd1205_private *macp, struct zdap_ioctl *zdreq)
{
	void *regp = macp->regp;
	u16 zd_cmd;
	u32 tmp_value;
	zd_cmd = zdreq->cmd;
	switch(zd_cmd) {
	case ZD_IOCTL_REG_READ:
		acquire_ctrl_of_phy_req(regp);
		tmp_value = zd_readl(zdreq->addr);
		release_ctrl_of_phy_req(regp);
		zdreq->value = tmp_value;

		printk(KERN_DEBUG "zd1211 read register:  reg = 0x%04x, value = 0x%08x\n",
		zdreq->addr, zdreq->value);
		//if (copy_to_user(ifr->ifr_data, &zdreq, sizeof (zdreq)))
			//return -EFAULT;
		break;

	case ZD_IOCTL_REG_WRITE:
		acquire_ctrl_of_phy_req(regp);
		zd_writel(zdreq->value, zdreq->addr);

		release_ctrl_of_phy_req(regp);
		if (zdreq->addr == RX_OFFSET_BYTE)
			macp->rxOffset = zdreq->value;
		break;

	case ZD_IOCTL_MEM_DUMP:
		zd1205_dump_data("mem", (u8 *)zdreq->addr, zdreq->value);
		//memcpy(&zdreq->data[0], (u8 *)zdreq->addr, zdreq->value);
		//if (copy_to_user(ifr->ifr_data, &zdreq, sizeof (zdreq)))
			//return -EFAULT;
		break;

	case ZD_IOCTL_RATE:
		/* Check for the validation of vale */
		if(zdreq->value > 3 || zdreq->value < 0) {
			printk(KERN_DEBUG "zd1205: Basic Rate %x doesn't support\n", zdreq->value);
			break;
		}

		printk(KERN_DEBUG "zd1205: Basic Rate = %x\n", zdreq->value);
		zd1205_update_brate(macp, zdreq->value);
		break;

	case ZD_IOCTL_SNIFFER:
		macp->sniffer_on = zdreq->value;
		printk(KERN_DEBUG "zd1205: sniffer_on = %x\n", macp->sniffer_on);
		zd1205_set_sniffer_mode(macp);
		break;

	case ZD_IOCTL_DUMP_PHY:
		printk(KERN_DEBUG "zd1205: dump phy\n");
		zd1205_dump_phy(macp);
		break;

	case ZD_IOCTL_CARD_SETTING:

		printk(KERN_DEBUG "zd1205: card setting\n");
		zd1205_show_card_setting(macp);
		break;

	case ZD_IOCTL_HASH_DUMP:
		printk(KERN_DEBUG "zd1205: aid = %x\n", zdreq->value);
		zd1205_show_hash(macp, zdreq->value);
		break;

	case ZD_IOCTL_RFD_DUMP:
		printk(KERN_DEBUG "===== zd1205 rfd dump =====\n");
		zd1205_dump_rfds(macp);
		break;

	case ZD_IOCTL_MEM_READ: {
		u32 *p;
		p = (u32 *) bus_to_virt(zdreq->addr);
		printk(KERN_DEBUG "zd1205: read memory addr: 0x%08x value: 0x%08x\n", zdreq->addr, *p);
		break;
	}

	case ZD_IOCTL_MEM_WRITE: {
		u32 *p;
		p = (u32 *) bus_to_virt(zdreq->addr);
		*p = zdreq->value;
		printk(KERN_DEBUG "zd1205: write value: 0x%08x to memory addr: 0x%08x\n", zdreq->value, zdreq->addr);
		break;
	}

	case ZD_IOCTL_TX_RATE:
		printk(KERN_DEBUG "zd1205: set tx rate = %d\n", zdreq->value);
		if (zdreq->value < 0x0c) {
			macp->cardSetting.FixedRate = zdreq->value;
			macp->bFixedRate = 1;
		} else
			macp->bFixedRate = 0;
		break;

	case ZD_IOCTL_EEPROM:
		printk(KERN_DEBUG "zd1205: dump eeprom\n");
		zd1205_dump_eeprom(macp);
		break;

	default :
		printk(KERN_ERR "zd1205: error command = %x\n", zd_cmd);
		break;
	}
	return 0;
}
