/*
 ***************************************************************************
 * Ralink Tech Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2005, Ralink Technology, Inc.
 *
 * This program is free software; you can redistribute it and/or modify  * 
 * it under the terms of the GNU General Public License as published by  * 
 * the Free Software Foundation; either version 2 of the License, or     * 
 * (at your option) any later version.                                   * 
 *                                                                       * 
 * This program is distributed in the hope that it will be useful,       * 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 * GNU General Public License for more details.                          * 
 *                                                                       * 
 * You should have received a copy of the GNU General Public License     * 
 * along with this program; if not, write to the                         * 
 * Free Software Foundation, Inc.,                                       * 
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                       * 
 ************************************************************************

	Module Name:
	rtmp_init.c

	Abstract:
	Miniport generic portion header file

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
	Paul Lin    2002-08-01    created
    John Chang  2004-08-20    RT2561/2661 use scatter-gather scheme
*/

#include    "rt_config.h"

UCHAR    BIT8[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
ULONG    BIT32[] = {0x00000001, 0x00000002, 0x00000004, 0x00000008,
                    0x00000010, 0x00000020, 0x00000040, 0x00000080,
                    0x00000100, 0x00000200, 0x00000400, 0x00000800,
                    0x00001000, 0x00002000, 0x00004000, 0x00008000,
                    0x00010000, 0x00020000, 0x00040000, 0x00080000,
                    0x00100000, 0x00200000, 0x00400000, 0x00800000,
                    0x01000000, 0x02000000, 0x04000000, 0x08000000,
                    0x10000000, 0x20000000, 0x40000000, 0x80000000};

char*   CipherName[] = {"none","wep64","wep128","TKIP","AES","CKIP64","CKIP128"};

const unsigned short ccitt_16Table[] = {
    0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7,
    0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF,
    0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6,
    0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE,
    0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485,
    0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D,
    0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4,
    0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC,
    0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823,
    0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B,
    0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12,
    0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A,
    0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41,
    0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49,
    0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70,
    0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78,
    0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F,
    0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067,
    0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E,
    0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256,
    0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D,
    0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
    0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C,
    0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634,
    0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB,
    0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3,
    0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A,
    0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92,
    0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9,
    0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1,
    0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8,
    0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
};
#define ByteCRC16(v, crc) \
    (unsigned short)((crc << 8) ^  ccitt_16Table[((crc >> 8) ^ (v)) & 255])

//
// BBP register initialization set
//
BBP_REG_PAIR   BBPRegTable[] = {
	{3,     0x00},
	{15,    0x30},
	{17,    0x20},
	{21,    0xc8},
	{22,    0x38},
	{23,    0x06},
	{24,    0xfe},
	{25,    0x0a},
	{26,    0x0d},
	{34,    0x12},
	{37,    0x07},
	{39,	0xf8},
	{41,    0x60},
	{53,    0x10},
	{54,    0x18},
	{60,    0x10},
	{61,    0x04},
	{62,    0x04},
	{75,    0xfe},
	{86,    0xfe},
	{88,    0xfe},
	{90,    0x0f},
	{99,    0x00},
	{102,   0x16},
	{107,   0x04},
};
#define	NUM_BBP_REG_PARMS	(sizeof(BBPRegTable) / sizeof(BBP_REG_PAIR))

//
// ASIC register initialization sets
//
RTMP_REG_PAIR	MACRegTable[] =	{
//	{MAC_CSR11,		0x0000000a}, // 0x302c, power state transition time
//	{TXRX_CSR5,		0x0000000f}, // 0x3054, Basic rate set bitmap
	{TXRX_CSR0,		0x025fb032}, // 0x3040, RX control, default Disable RX
	{TXRX_CSR1,		0x9eb39eb3}, // 0x3044, BBP 30:Ant-A RSSI, R51:Ant-B RSSI, R42:OFDM rate, R47:CCK SIGNAL
	{TXRX_CSR2,		0x8a8b8c8d}, // 0x3048, CCK TXD BBP registers
	{TXRX_CSR3,		0x00858687}, // 0x304c, OFDM TXD BBP registers
	{TXRX_CSR7,		0x2E31353B}, // 0x305c, ACK/CTS payload consume time for 18/12/9/6 mbps    
	{TXRX_CSR8,		0x2a2a2a2c}, // 0x3060, ACK/CTS payload consume time for 54/48/36/24 mbps
	{TXRX_CSR15,	0x0000000f}, // 0x307c, TKIP MIC priority byte "AND" mask
	{MAC_CSR6,		0x00000fff}, // 0x3018, MAX frame length
	{MAC_CSR8,		0x016c030a}, // 0x3020, SIFS time for compensation
	{MAC_CSR10,		0x00000718}, // 0x3028, ASIC PIN control in various power states
	{MAC_CSR12,		0x00000004}, // 0x3030, power state control, set to AWAKE state
	{MAC_CSR13,		0x0000e000}, // 0x3034, GPIO pin#5 Input as bHwRadio, otherwise as output.
//	{INT_SOURCE_CSR,0xffffffff}, // 0x3068, Clear all pending interrupt source
//	{MAC_CSR14,		0x00001e6}, // 0x3038, default both LEDs off
//	{PHY_CSR2,		0x82188200}, // 0x308c, pre-TX BBP control
//	{TXRX_CSR11,	0x0000e78f}, // 0x306c, AES, mask off more data bit for MIC calculation
//	{TX_DMA_DST_CSR,0x000000aa}, // 0x342c, ASIC TX FIFO to host shared memory mapping
	{SEC_CSR0,		0x00000000}, // 0x30a0, invalidate all shared key entries
	{SEC_CSR1,		0x00000000}, // 0x30a4, reset all shared key algorithm to "none"
	{SEC_CSR5,		0x00000000}, // 0x30b4, reset all shared key algorithm to "none"
	{PHY_CSR1,		0x000023b0}, // 0x3084, BBP Register R/W mode set to "Parallel mode"
	{PHY_CSR5,		0x060a100c}, // 0x00040a06
	{PHY_CSR6,		0x00080606},
	{PHY_CSR7,		0x00000a08},
	{PCI_CFG_CSR,	0x3cca4808}, // 0x3460, PCI configuration set to 0x3cca4808
	{AIFSN_CSR,		0x00002273},
	{CWMIN_CSR,		0x00002344},
	{CWMAX_CSR,		0x000034aa},
	{TEST_MODE_CSR, 0x00000200}, // 0x3484, Count TXOP anyway. by Mark 2005/07/27 for WMM S3T07 issue
	{M2H_CMD_DONE_CSR, 0xffffffff}, // 0x2104, clear M2H_CMD_DONE mailbox
};

#define	NUM_MAC_REG_PARMS	(sizeof(MACRegTable) / sizeof(RTMP_REG_PAIR))

//
//  =====================   Tables of FirmareImage   ====================
//
//2005_05_31, support led mode 6
//2005_06_10, firmware not program GPIO except LED MODE #2
//2005_06_23, support Led mode #7
//2005_08_26, firmware bug fixed Led mode #4 & #6
static UCHAR RT2561_FirmwareImage[] = {
    0x02, 0x1c, 0x12, 0x02, 0x13, 0xcb, 0xc2, 0x8c, 0x22, 0x22, 0x00, 0x02, 0x16, 0x0f, 0xc2, 0xaf, 
    0xc2, 0x8d, 0x75, 0x8c, 0x94, 0x75, 0x8a, 0x93, 0xd2, 0xaf, 0x22, 0x02, 0x18, 0xda, 0x12, 0x1b, 
    0xe8, 0x40, 0x03, 0x02, 0x02, 0x1e, 0x90, 0x21, 0x02, 0xe0, 0xf5, 0x2d, 0x90, 0x00, 0x03, 0xe0, 
    0x12, 0x08, 0x25, 0x00, 0xb0, 0x00, 0x00, 0xce, 0x01, 0x00, 0x5e, 0x10, 0x00, 0x6f, 0x11, 0x00, 
    0xf2, 0x20, 0x01, 0x4d, 0x21, 0x01, 0x70, 0x22, 0x01, 0x84, 0x30, 0x01, 0x8f, 0x31, 0x01, 0xd5, 
    0x50, 0x01, 0x9f, 0x51, 0x01, 0xf2, 0x52, 0x02, 0x06, 0x60, 0x00, 0x00, 0x02, 0x14, 0x90, 0x00, 
    0x0a, 0xe0, 0x20, 0xe5, 0x03, 0x30, 0x07, 0x03, 0xd2, 0x08, 0x22, 0x12, 0x17, 0xa5, 0x22, 0x90, 
    0x21, 0x00, 0xe0, 0xf5, 0x11, 0xe5, 0x11, 0xc4, 0x33, 0x54, 0xe0, 0x24, 0x21, 0xf5, 0x82, 0xe4, 
    0x34, 0x21, 0xf5, 0x83, 0xe0, 0x44, 0x80, 0xf0, 0xe5, 0x11, 0xc4, 0x33, 0x54, 0xe0, 0x24, 0x2c, 
    0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe5, 0x11, 0xf0, 0xc4, 0x33, 0x54, 0xe0, 0x24, 0x2d, 
    0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe5, 0x2d, 0xf0, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0x22, 
    0x12, 0x11, 0x31, 0x90, 0x21, 0x00, 0xe0, 0xf5, 0x31, 0x60, 0x05, 0x12, 0x1b, 0x8a, 0x80, 0x03, 
    0x12, 0x1b, 0x3d, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0x62, 0x22, 0x75, 0x31, 
    0xff, 0x90, 0x01, 0x00, 0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x54, 0xfe, 0xf0, 0x54, 
    0x3e, 0xf0, 0xe4, 0x90, 0x00, 0x0b, 0xf0, 0xf0, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 
    0x62, 0x22, 0x7e, 0x2b, 0x7f, 0x80, 0x7d, 0x03, 0x12, 0x04, 0x0e, 0x90, 0x34, 0xcd, 0xe0, 0x20, 
    0xe3, 0xf9, 0x90, 0x21, 0x14, 0x12, 0x08, 0x01, 0x90, 0x34, 0xc0, 0x12, 0x08, 0x0d, 0x90, 0x21, 
    0x18, 0x12, 0x08, 0x01, 0x90, 0x34, 0xc8, 0x12, 0x08, 0x0d, 0x90, 0x21, 0x1c, 0x12, 0x08, 0x01, 
    0x90, 0x34, 0xc4, 0x12, 0x08, 0x0d, 0x90, 0x34, 0xcc, 0x74, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x04, 
    0xf0, 0x90, 0x01, 0x01, 0xe0, 0x44, 0x01, 0xf0, 0x44, 0x40, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 
    0x10, 0xf0, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0x62, 0x22, 0x90, 0x01, 0x00, 
    0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x54, 0xfe, 0xf0, 0x54, 0xbf, 0xf0, 0x90, 0x00, 
    0x0b, 0xe0, 0x54, 0xef, 0xf0, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0x62, 0x22, 
    0x7e, 0x2b, 0x7f, 0x80, 0x7d, 0x03, 0x12, 0x04, 0x0e, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 
    0x12, 0x1c, 0x62, 0x22, 0xd2, 0x05, 0x85, 0x2d, 0x23, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0x22, 0x12, 
    0x1a, 0x74, 0xc2, 0x00, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0x62, 0x22, 0x85, 
    0x2d, 0x25, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfb, 0xff, 0xf0, 0xe4, 0x90, 0x00, 0x07, 0xf0, 0x90, 
    0x00, 0x0a, 0x74, 0x04, 0xf0, 0xe4, 0x90, 0x00, 0x08, 0xf0, 0x90, 0x21, 0x00, 0xe0, 0x90, 0x00, 
    0x09, 0xf0, 0x90, 0x00, 0x07, 0x74, 0x71, 0xf0, 0xef, 0x44, 0x04, 0x90, 0x00, 0x0b, 0xf0, 0xe4, 
    0x90, 0x21, 0x03, 0xf0, 0x22, 0x90, 0x21, 0x00, 0xe0, 0xff, 0x54, 0x1f, 0xf5, 0x30, 0xa3, 0xe0, 
    0xf5, 0x27, 0x8f, 0x26, 0x12, 0x08, 0x90, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 
    0x62, 0x22, 0x90, 0x21, 0x00, 0xe0, 0xf5, 0x2c, 0x12, 0x18, 0x13, 0xe4, 0x90, 0x21, 0x03, 0xf0, 
    0xaf, 0x2d, 0x12, 0x1c, 0x62, 0x22, 0x12, 0x19, 0x53, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 
    0x12, 0x1c, 0x62, 0x22, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0x62, 0x22, 0x8e, 
    0x15, 0x8f, 0x16, 0xca, 0xed, 0xca, 0xc9, 0xeb, 0xc9, 0x30, 0x0a, 0x04, 0x7f, 0x4a, 0x80, 0x02, 
    0x7f, 0x42, 0xcb, 0xef, 0xcb, 0xea, 0xc3, 0x94, 0x04, 0x50, 0x02, 0x80, 0x01, 0xc3, 0x40, 0x04, 
    0xcb, 0x44, 0x20, 0xcb, 0x85, 0x16, 0x82, 0x85, 0x15, 0x83, 0xeb, 0xf0, 0xa3, 0xe4, 0xf0, 0x85, 
    0x16, 0x82, 0x85, 0x15, 0x83, 0xa3, 0xa3, 0xe5, 0x1a, 0xf0, 0xe5, 0x19, 0x85, 0x16, 0x82, 0x85, 
    0x15, 0x83, 0xa3, 0xa3, 0xa3, 0xf0, 0xe5, 0x16, 0x24, 0x04, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 
    0x83, 0x74, 0x0f, 0xf0, 0xe5, 0x16, 0x24, 0x05, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xe4, 
    0xf0, 0xe5, 0x16, 0x24, 0x06, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 0x16, 
    0x24, 0x07, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0x74, 0x10, 0xf0, 0xea, 0x90, 0x1a, 0x9c, 
    0x93, 0xfb, 0xea, 0x64, 0x01, 0x60, 0x08, 0xea, 0x64, 0x02, 0x60, 0x03, 0xba, 0x03, 0x04, 0xcb, 
    0x44, 0x08, 0xcb, 0xe5, 0x16, 0x24, 0x08, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xeb, 0xf0, 
    0xe5, 0x16, 0x24, 0x15, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0x74, 0xff, 0xf0, 0xe5, 0x16, 
    0x24, 0x16, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xe9, 0xf0, 0xe5, 0x16, 0x24, 0x09, 0xf5, 
    0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0x74, 0x04, 0xf0, 0x25, 0x1a, 0xf5, 0x1a, 0xe4, 0x35, 0x19, 
    0xf5, 0x19, 0xea, 0xc3, 0x94, 0x04, 0x40, 0x03, 0x02, 0x03, 0xd6, 0xea, 0x60, 0x03, 0xba, 0x01, 
    0x1f, 0xea, 0x24, 0x01, 0xfd, 0xe4, 0x33, 0xfc, 0xe5, 0x1a, 0xae, 0x19, 0x78, 0x03, 0xc3, 0x33, 
    0xce, 0x33, 0xce, 0xd8, 0xf9, 0xff, 0x12, 0x07, 0x96, 0x8e, 0x19, 0x8f, 0x1a, 0x02, 0x03, 0xb6, 
    0xea, 0x24, 0xff, 0xfd, 0xe4, 0x34, 0xff, 0xfc, 0x7e, 0x00, 0x7f, 0x0b, 0x12, 0x07, 0x84, 0xcc, 
    0xee, 0xcc, 0xcd, 0xef, 0xcd, 0xe5, 0x1a, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 0xe5, 0x19, 
    0xc4, 0x54, 0xf0, 0x48, 0xfe, 0x12, 0x07, 0x96, 0x8c, 0x1b, 0x8d, 0x1c, 0xea, 0x24, 0xff, 0xfd, 
    0xe4, 0x34, 0xff, 0xfc, 0x7e, 0x00, 0x7f, 0x0b, 0x12, 0x07, 0x84, 0xcc, 0xee, 0xcc, 0xcd, 0xef, 
    0xcd, 0xe5, 0x1a, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 0xe5, 0x19, 0xc4, 0x54, 0xf0, 0x48, 
    0xfe, 0x12, 0x07, 0x96, 0x8e, 0x19, 0x8f, 0x1a, 0xe5, 0x1c, 0x45, 0x1b, 0x60, 0x08, 0x05, 0x1a, 
    0xe5, 0x1a, 0x70, 0x02, 0x05, 0x19, 0xea, 0x24, 0xff, 0xfd, 0xe4, 0x34, 0xff, 0xfc, 0x7e, 0x00, 
    0x7f, 0x03, 0x12, 0x07, 0x84, 0xd3, 0xe5, 0x1c, 0x9f, 0xe5, 0x1b, 0x9e, 0x50, 0x18, 0xe5, 0x1c, 
    0x45, 0x1b, 0x60, 0x12, 0xba, 0x03, 0x0f, 0xe5, 0x16, 0x24, 0x09, 0xf5, 0x82, 0xe4, 0x35, 0x15, 
    0xf5, 0x83, 0xe0, 0x44, 0x80, 0xf0, 0xe5, 0x16, 0x24, 0x0a, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 
    0x83, 0xe5, 0x1a, 0xf0, 0xe5, 0x19, 0xff, 0xe5, 0x16, 0x24, 0x0b, 0xf5, 0x82, 0xe4, 0x35, 0x15, 
    0xf5, 0x83, 0xef, 0xf0, 0x80, 0x2d, 0xe5, 0x1a, 0x54, 0x3f, 0xff, 0xe5, 0x16, 0x24, 0x0a, 0xf5, 
    0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x1a, 0xae, 0x19, 0x78, 0x06, 0xce, 0xc3, 
    0x13, 0xce, 0x13, 0xd8, 0xf9, 0xff, 0xe5, 0x16, 0x24, 0x0b, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 
    0x83, 0xef, 0xf0, 0x85, 0x16, 0x82, 0x85, 0x15, 0x83, 0xe0, 0x44, 0x01, 0xf0, 0x22, 0x8e, 0x12, 
    0x8f, 0x13, 0x8d, 0x14, 0xe5, 0x14, 0xa2, 0xe1, 0x92, 0x09, 0xe5, 0x34, 0x24, 0x19, 0xf5, 0x82, 
    0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xfd, 0xe5, 0x34, 0x24, 0x1a, 0xf5, 0x82, 0xe4, 0x35, 0x33, 
    0xf5, 0x83, 0xe0, 0xfb, 0xa2, 0x09, 0x92, 0x0a, 0x75, 0x19, 0x00, 0x75, 0x1a, 0x1a, 0x12, 0x02, 
    0x1f, 0x30, 0x09, 0x04, 0x7f, 0xc8, 0x80, 0x02, 0x7f, 0xe8, 0xe5, 0x13, 0x24, 0x18, 0xf5, 0x82, 
    0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x31, 0x60, 0x04, 0x7f, 0x02, 0x80, 0x02, 0x7f, 
    0x01, 0xe5, 0x13, 0x24, 0x19, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x34, 
    0x24, 0x19, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x7d, 0x1a, 0x7c, 0x00, 0x12, 
    0x0e, 0x64, 0xe5, 0x13, 0x24, 0x1a, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 
    0x13, 0x24, 0x1b, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xee, 0xf0, 0xe5, 0x31, 0x60, 0x60, 
    0xe5, 0x13, 0x24, 0x1c, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0xe5, 0x34, 0x24, 0x12, 0xfd, 0xe4, 0x35, 
    0x33, 0xfc, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x14, 0xab, 0xe5, 0x13, 0x24, 0x22, 0xff, 0xe4, 
    0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x10, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x14, 0xab, 0xe5, 
    0x13, 0x24, 0x28, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x08, 0x75, 0x1b, 0x11, 0x7b, 
    0x06, 0x12, 0x14, 0xab, 0xe5, 0x34, 0x24, 0x18, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 
    0xff, 0xe5, 0x13, 0x24, 0x2d, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x80, 0x3f, 
    0xe5, 0x13, 0x24, 0x1c, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x10, 0x75, 0x1b, 0x11, 
    0x7b, 0x06, 0x12, 0x14, 0xab, 0xe5, 0x13, 0x24, 0x22, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 
    0x7d, 0x08, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x14, 0xab, 0xe5, 0x13, 0x24, 0x28, 0xff, 0xe4, 
    0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x10, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x14, 0xab, 0xe5, 
    0x13, 0x24, 0x2e, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 0x13, 0x24, 0x2f, 
    0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 0x34, 0x24, 0x11, 0xf5, 0x82, 0xe4, 
    0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0xc3, 0x13, 0xff, 0xe5, 0x13, 0x24, 0x30, 0xf5, 0x82, 0xe4, 
    0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x30, 0x09, 0x41, 0xe5, 0x13, 0x24, 0x30, 0xf5, 0x82, 0xe4, 
    0x35, 0x12, 0xf5, 0x83, 0xe0, 0xff, 0xe5, 0x31, 0x60, 0x04, 0x7e, 0x00, 0x80, 0x02, 0x7e, 0x10, 
    0xef, 0x4e, 0xf0, 0xe5, 0x31, 0x60, 0x06, 0x7e, 0x00, 0x7f, 0x00, 0x80, 0x0f, 0xe5, 0x14, 0x30, 
    0xe0, 0x06, 0x7e, 0x00, 0x7f, 0xff, 0x80, 0x04, 0x7e, 0x00, 0x7f, 0x00, 0xe5, 0x13, 0x24, 0x31, 
    0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x22, 0xe5, 0x13, 0x24, 0x30, 0xf5, 0x82, 
    0xe4, 0x35, 0x12, 0xf5, 0x83, 0xe0, 0x44, 0x40, 0xf0, 0xe5, 0x14, 0x30, 0xe0, 0x0f, 0xe5, 0x34, 
    0x24, 0x10, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x80, 0x02, 0x7f, 0x00, 0xe5, 
    0x13, 0x24, 0x31, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x22, 0xe5, 0x34, 0x24, 
    0x11, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0x30, 0xe7, 0x3b, 0xe5, 0x34, 0x24, 0x1c, 
    0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0x65, 0x2b, 0x70, 0x03, 0x75, 0x2b, 0xff, 0xe5, 
    0x34, 0x24, 0x1d, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x12, 0x1c, 0x62, 0x7e, 
    0x22, 0x7f, 0x10, 0x12, 0x18, 0x7c, 0x8e, 0x33, 0x8f, 0x34, 0x90, 0x22, 0x2e, 0xe0, 0xfe, 0xa3, 
    0xe0, 0x8e, 0x33, 0xf5, 0x34, 0xc3, 0x22, 0xd2, 0x0a, 0xe5, 0x34, 0x24, 0x1b, 0xf5, 0x82, 0xe4, 
    0x35, 0x33, 0xf5, 0x83, 0xe0, 0x70, 0x3a, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 
    0x82, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 0xe0, 0xfc, 
    0xa3, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xfe, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 
    0xef, 0xf0, 0xd3, 0x94, 0x00, 0xee, 0x64, 0x80, 0x94, 0x80, 0x50, 0x03, 0x02, 0x07, 0x27, 0x80, 
    0xc6, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xc3, 0xee, 0x64, 0x80, 0x94, 
    0x80, 0x50, 0x03, 0x02, 0x07, 0x27, 0x12, 0x1c, 0x41, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 
    0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0x9f, 0xee, 0x64, 0x80, 0xf8, 0xec, 0x64, 0x80, 0x98, 0x40, 0x20, 
    0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 0xa3, 0xa3, 0xe0, 0xfe, 0xa3, 0xe0, 
    0xff, 0xed, 0x9f, 0xff, 0xec, 0x9e, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 0xc2, 0x0a, 
    0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0xe5, 0x34, 0x24, 0x10, 0xf5, 
    0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xfd, 0xee, 0x94, 0x00, 0xfc, 
    0x12, 0x16, 0x5a, 0x50, 0x2c, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 0xe0, 
    0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 
    0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 0xc2, 
    0x0a, 0x20, 0x0a, 0x03, 0x02, 0x06, 0x37, 0x7e, 0x22, 0x7f, 0x10, 0x12, 0x18, 0x7c, 0x8e, 0x33, 
    0x8f, 0x34, 0x8f, 0x82, 0x8e, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xd3, 0x94, 0x00, 0xee, 0x64, 0x80, 
    0x94, 0x80, 0x40, 0x0d, 0x7e, 0x22, 0x7f, 0x10, 0xad, 0x34, 0xac, 0x33, 0x12, 0x15, 0x0e, 0x80, 
    0x1a, 0x12, 0x1b, 0xab, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xee, 0x8f, 0xf0, 0x12, 0x07, 0xeb, 
    0x7e, 0x22, 0x7f, 0x30, 0xad, 0x34, 0xac, 0x33, 0x12, 0x15, 0x0e, 0x90, 0x22, 0x2e, 0xe0, 0xfe, 
    0xa3, 0xe0, 0xff, 0x65, 0x34, 0x70, 0x03, 0xee, 0x65, 0x33, 0x70, 0x02, 0xd3, 0x22, 0x8e, 0x33, 
    0x8f, 0x34, 0xc3, 0x22, 0xef, 0x8d, 0xf0, 0xa4, 0xa8, 0xf0, 0xcf, 0x8c, 0xf0, 0xa4, 0x28, 0xce, 
    0x8d, 0xf0, 0xa4, 0x2e, 0xfe, 0x22, 0xbc, 0x00, 0x0b, 0xbe, 0x00, 0x29, 0xef, 0x8d, 0xf0, 0x84, 
    0xff, 0xad, 0xf0, 0x22, 0xe4, 0xcc, 0xf8, 0x75, 0xf0, 0x08, 0xef, 0x2f, 0xff, 0xee, 0x33, 0xfe, 
    0xec, 0x33, 0xfc, 0xee, 0x9d, 0xec, 0x98, 0x40, 0x05, 0xfc, 0xee, 0x9d, 0xfe, 0x0f, 0xd5, 0xf0, 
    0xe9, 0xe4, 0xce, 0xfd, 0x22, 0xed, 0xf8, 0xf5, 0xf0, 0xee, 0x84, 0x20, 0xd2, 0x1c, 0xfe, 0xad, 
    0xf0, 0x75, 0xf0, 0x08, 0xef, 0x2f, 0xff, 0xed, 0x33, 0xfd, 0x40, 0x07, 0x98, 0x50, 0x06, 0xd5, 
    0xf0, 0xf2, 0x22, 0xc3, 0x98, 0xfd, 0x0f, 0xd5, 0xf0, 0xea, 0x22, 0xc5, 0xf0, 0xf8, 0xa3, 0xe0, 
    0x28, 0xf0, 0xc5, 0xf0, 0xf8, 0xe5, 0x82, 0x15, 0x82, 0x70, 0x02, 0x15, 0x83, 0xe0, 0x38, 0xf0, 
    0x22, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xa3, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x22, 0xec, 0xf0, 0xa3, 
    0xed, 0xf0, 0xa3, 0xee, 0xf0, 0xa3, 0xef, 0xf0, 0x22, 0xa4, 0x25, 0x82, 0xf5, 0x82, 0xe5, 0xf0, 
    0x35, 0x83, 0xf5, 0x83, 0x22, 0xd0, 0x83, 0xd0, 0x82, 0xf8, 0xe4, 0x93, 0x70, 0x12, 0x74, 0x01, 
    0x93, 0x70, 0x0d, 0xa3, 0xa3, 0x93, 0xf8, 0x74, 0x01, 0x93, 0xf5, 0x82, 0x88, 0x83, 0xe4, 0x73, 
    0x74, 0x02, 0x93, 0x68, 0x60, 0xef, 0xa3, 0xa3, 0xa3, 0x80, 0xdf, 0x8a, 0x83, 0x89, 0x82, 0xe4, 
    0x73, 0xe4, 0xff, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xef, 0x90, 0x1b, 0x51, 0x93, 0x44, 0x80, 0x90, 
    0x30, 0x8d, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 0xfe, 0x74, 
    0x36, 0x2f, 0xf8, 0xc6, 0xee, 0xc6, 0xa3, 0xe0, 0xfe, 0xef, 0x90, 0x1b, 0x51, 0x93, 0x44, 0x80, 
    0x6e, 0x60, 0x01, 0x1f, 0x0f, 0xef, 0xc3, 0x94, 0x09, 0x40, 0xc8, 0x22, 0x00, 0x00, 0x00, 0x00, 
    0xe5, 0x30, 0x12, 0x08, 0x25, 0x08, 0xb1, 0x00, 0x09, 0x1f, 0x01, 0x09, 0x87, 0x02, 0x0a, 0x1b, 
    0x03, 0x0a, 0x6f, 0x04, 0x0a, 0xb6, 0x05, 0x0b, 0x29, 0x06, 0x0b, 0x98, 0x07, 0x00, 0x00, 0x0b, 
    0xd0, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 0x20, 0xe5, 
    0x08, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 
    0xe5, 0x26, 0x30, 0xe6, 0x0f, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x12, 0x43, 
    0x12, 0x02, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 0x53, 0x12, 
    0xfd, 0xe5, 0x26, 0x30, 0xe7, 0x0f, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x12, 
    0x43, 0x12, 0x08, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 0x03, 0x53, 
    0x12, 0xf7, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0xc2, 
    0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 0x20, 0xe5, 0x08, 0x90, 
    0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x26, 
    0x54, 0xc0, 0x60, 0x1c, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x03, 0x43, 0x12, 
    0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x1f, 0x43, 0x12, 0x08, 0x80, 0x1a, 
    0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 0x53, 0x12, 0xfd, 0xe5, 0x27, 0x30, 
    0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 0x03, 0x53, 0x12, 0xf7, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 
    0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 
    0xf5, 0x12, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0xe5, 0x26, 0x30, 0xe5, 0x5c, 0x90, 0x34, 0x98, 
    0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x26, 0x54, 0xc0, 0x60, 0x1c, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 
    0x12, 0xfd, 0x80, 0x03, 0x43, 0x12, 0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 
    0x30, 0x43, 0x12, 0x08, 0x80, 0x2b, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 
    0x53, 0x12, 0xfd, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 0x03, 0x53, 0x12, 0xf7, 
    0xe5, 0x27, 0xf4, 0x54, 0x1f, 0xff, 0x90, 0x30, 0x34, 0xe0, 0x54, 0xe0, 0x4f, 0xf0, 0xe4, 0xf5, 
    0x2c, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x80, 0x15, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 
    0xe5, 0x27, 0xf4, 0x54, 0x1f, 0xff, 0x90, 0x30, 0x34, 0xe0, 0x54, 0xe0, 0x4f, 0xf0, 0x90, 0x30, 
    0x35, 0xe0, 0xf5, 0x12, 0x53, 0x12, 0xe0, 0xe5, 0x12, 0xf0, 0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 
    0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 0x30, 0xe5, 0x3c, 0x90, 0x34, 0x98, 0xe0, 0x44, 
    0x01, 0xf0, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x03, 0x43, 0x12, 0x02, 0xe5, 
    0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x03, 0x43, 0x12, 0x08, 0xe5, 0x26, 0x54, 0xc0, 
    0x60, 0x08, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x80, 0x06, 0x53, 0x12, 0xfe, 0x43, 0x12, 0x04, 
    0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x22, 0xc2, 
    0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 
    0x12, 0x02, 0x80, 0x03, 0x53, 0x12, 0xfd, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 
    0x03, 0x53, 0x12, 0xf7, 0xe5, 0x26, 0x54, 0xc0, 0x60, 0x08, 0x53, 0x12, 0xfe, 0x53, 0x12, 0xfb, 
    0x80, 0x06, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0x90, 
    0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0x20, 0x02, 0x13, 0x12, 0x1c, 0x1e, 0xaf, 0x29, 0x7e, 0x00, 
    0x12, 0x1c, 0x74, 0xaf, 0x35, 0x7e, 0x00, 0x12, 0x1c, 0x7b, 0xd2, 0x02, 0x90, 0x30, 0x3a, 0xe0, 
    0xf5, 0x12, 0xe5, 0x26, 0x20, 0xe5, 0x0d, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x34, 0x98, 0xe0, 
    0x54, 0xfe, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x26, 0x54, 0xc0, 0x60, 
    0x2c, 0xc2, 0x01, 0x12, 0x00, 0x06, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x03, 
    0x43, 0x12, 0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x03, 0x43, 0x12, 0x08, 
    0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0x30, 0x01, 0x03, 
    0x02, 0x0b, 0xd0, 0x12, 0x15, 0xc0, 0xd2, 0x01, 0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 0xe5, 0x26, 
    0x20, 0xe5, 0x09, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x80, 0x55, 0x90, 0x34, 0x98, 0xe0, 
    0x44, 0x01, 0xf0, 0xe5, 0x26, 0x30, 0xe6, 0x0f, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 
    0x80, 0x12, 0x43, 0x12, 0x02, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 
    0x03, 0x53, 0x12, 0xfd, 0xe5, 0x26, 0x30, 0xe7, 0x0f, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 
    0xf7, 0x80, 0x12, 0x43, 0x12, 0x08, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 
    0x80, 0x03, 0x53, 0x12, 0xf7, 0x43, 0x12, 0x01, 0x53, 0x12, 0xfb, 0x90, 0x30, 0x3a, 0xe5, 0x12, 
    0xf0, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0x22, 0xe5, 0x26, 0x30, 0xe5, 0x2c, 0x20, 0x03, 0x21, 
    0xd2, 0x03, 0x12, 0x1c, 0x1e, 0x75, 0x35, 0x06, 0x75, 0x29, 0x09, 0xaf, 0x29, 0x7e, 0x00, 0x12, 
    0x1c, 0x74, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0x53, 0x12, 0xfe, 0x43, 0x12, 0x04, 0xe5, 0x12, 
    0xf0, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 
    0x22, 0xe5, 0x31, 0x64, 0x01, 0x70, 0x41, 0x12, 0x1a, 0xd4, 0x40, 0x03, 0x02, 0x0d, 0x4f, 0x12, 
    0x1b, 0x65, 0x50, 0x20, 0x7e, 0x2b, 0x7f, 0x80, 0x7d, 0x03, 0x12, 0x04, 0x0e, 0x7f, 0x01, 0x12, 
    0x19, 0x78, 0x40, 0x09, 0xd2, 0x09, 0x12, 0x0f, 0xee, 0xe4, 0xf5, 0x2f, 0x22, 0x12, 0x0d, 0x50, 
    0x75, 0x2f, 0x01, 0x22, 0x7f, 0x01, 0x12, 0x19, 0x78, 0x50, 0x04, 0x75, 0x2f, 0x02, 0x22, 0xd2, 
    0x09, 0x12, 0x0f, 0xee, 0xe4, 0xf5, 0x2f, 0x22, 0x12, 0x1a, 0x1d, 0x50, 0x51, 0x12, 0x1b, 0xcb, 
    0x90, 0x30, 0xf4, 0xe0, 0xf5, 0x2a, 0x7e, 0x30, 0x7f, 0xec, 0xa3, 0xe0, 0xfd, 0xe4, 0xfb, 0x12, 
    0x19, 0x2b, 0xe4, 0xff, 0xfe, 0x12, 0x1c, 0x36, 0x90, 0x00, 0x0a, 0x74, 0x02, 0xf0, 0x90, 0x00, 
    0x0b, 0xe0, 0x44, 0x02, 0xff, 0xf0, 0xfd, 0x90, 0x01, 0x05, 0x74, 0x20, 0xf0, 0x90, 0x01, 0x06, 
    0xe0, 0x44, 0x20, 0xf0, 0xed, 0x54, 0xbf, 0x90, 0x00, 0x0b, 0xf0, 0x90, 0x34, 0xcc, 0xe0, 0x44, 
    0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x01, 0xf0, 0xd2, 0x04, 0x12, 0x1a, 
    0x3a, 0x50, 0x43, 0x12, 0x1a, 0x57, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x30, 0x7d, 0xec, 0x75, 0x1b, 
    0x11, 0x7b, 0x06, 0x12, 0x14, 0xab, 0x90, 0x30, 0xf5, 0xe0, 0x75, 0xf0, 0x20, 0xa4, 0xff, 0xae, 
    0xf0, 0x12, 0x1c, 0x36, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 0xff, 0xf0, 0xfd, 0xe4, 0x90, 0x00, 
    0x04, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0x90, 0x00, 0x0a, 0x74, 0x40, 0xf0, 0x4d, 
    0x90, 0x00, 0x0b, 0xf0, 0xc2, 0x04, 0x12, 0x1a, 0xfe, 0x50, 0x38, 0x12, 0x1a, 0x57, 0x7e, 0x30, 
    0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x82, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x14, 0xab, 0x90, 0x00, 
    0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xe4, 0xff, 0xfe, 0x12, 0x1c, 0x36, 0x90, 0x00, 
    0x0b, 0xe0, 0x54, 0xfd, 0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 
    0xf0, 0xc2, 0x04, 0x12, 0x1b, 0x28, 0x50, 0x25, 0x12, 0x1a, 0x57, 0x7f, 0x02, 0x12, 0x19, 0x78, 
    0x90, 0x01, 0x04, 0xe0, 0x54, 0x7f, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 0xff, 0xf0, 0xe4, 
    0x90, 0x00, 0x04, 0xf0, 0xef, 0x54, 0xbf, 0x90, 0x00, 0x0b, 0xf0, 0xc2, 0x04, 0x12, 0x1a, 0xd4, 
    0x50, 0x2d, 0x12, 0x1a, 0x57, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x82, 0x75, 0x1b, 0x12, 
    0x7b, 0x06, 0x12, 0x14, 0xab, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0x90, 
    0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 0xc2, 0x04, 0x22, 
    0x90, 0x34, 0xcd, 0xe0, 0xf9, 0x20, 0xe3, 0xf8, 0xe5, 0x2b, 0xf4, 0x60, 0x66, 0x90, 0x34, 0xc0, 
    0x12, 0x08, 0x01, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 0xe5, 0x2b, 0x12, 0x08, 
    0x19, 0xe5, 0x82, 0x24, 0x04, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 0x12, 0x08, 0x0d, 0x90, 
    0x34, 0xc8, 0x12, 0x08, 0x01, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 0xe5, 0x2b, 
    0x12, 0x08, 0x19, 0xe5, 0x82, 0x24, 0x08, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 0x12, 0x08, 
    0x0d, 0x90, 0x34, 0xd0, 0x12, 0x08, 0x01, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 
    0xe5, 0x2b, 0x12, 0x08, 0x19, 0xe5, 0x82, 0x24, 0x0c, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 
    0x12, 0x08, 0x0d, 0xe5, 0x34, 0x24, 0xf0, 0xff, 0xe5, 0x33, 0x34, 0xde, 0xfe, 0xef, 0x78, 0x05, 
    0xce, 0xc3, 0x13, 0xce, 0x13, 0xd8, 0xf9, 0xf5, 0x2b, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 
    0xf0, 0x20, 0x12, 0x08, 0x19, 0xe5, 0x82, 0x24, 0x04, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 
    0x12, 0x08, 0x01, 0x90, 0x34, 0xc0, 0x12, 0x08, 0x0d, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 
    0xf0, 0x20, 0xe5, 0x2b, 0x12, 0x08, 0x19, 0xe5, 0x82, 0x24, 0x08, 0xf5, 0x82, 0xe4, 0x35, 0x83, 
    0xf5, 0x83, 0x12, 0x08, 0x01, 0x90, 0x34, 0xc8, 0x12, 0x08, 0x0d, 0x85, 0x34, 0x82, 0x85, 0x33, 
    0x83, 0x75, 0xf0, 0x20, 0xe5, 0x2b, 0x12, 0x08, 0x19, 0xe5, 0x82, 0x24, 0x0c, 0xf5, 0x82, 0xe4, 
    0x35, 0x83, 0xf5, 0x83, 0x12, 0x08, 0x01, 0x90, 0x34, 0xc4, 0x12, 0x08, 0x0d, 0x90, 0x01, 0x01, 
    0xe0, 0x44, 0x40, 0xf0, 0x90, 0x01, 0x00, 0xe0, 0x44, 0x08, 0xf0, 0xe9, 0x44, 0x04, 0x90, 0x34, 
    0xcd, 0xf0, 0x90, 0x34, 0xcc, 0xe0, 0x44, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x01, 0xf0, 0xa3, 0xe0, 
    0x44, 0x01, 0xf0, 0x22, 0x8f, 0x15, 0x8c, 0x16, 0x8d, 0x17, 0xe5, 0x15, 0xc3, 0x94, 0x04, 0x50, 
    0x56, 0xe5, 0x15, 0x94, 0x00, 0x40, 0x06, 0x7a, 0x00, 0x7b, 0x60, 0x80, 0x04, 0x7a, 0x00, 0x7b, 
    0xc0, 0xe5, 0x17, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 0xe5, 0x16, 0xc4, 0x54, 0xf0, 0x48, 
    0xfe, 0xe5, 0x15, 0x90, 0x1a, 0x8e, 0x93, 0xfd, 0x7c, 0x00, 0x12, 0x07, 0x96, 0xef, 0x2b, 0xfb, 
    0xee, 0x3a, 0xfa, 0xe5, 0x17, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 0xe5, 0x16, 0xc4, 0x54, 
    0xf0, 0x48, 0xfe, 0xe5, 0x15, 0x93, 0xfd, 0x7c, 0x00, 0x12, 0x07, 0x96, 0xed, 0x4c, 0x60, 0x63, 
    0x0b, 0xbb, 0x00, 0x01, 0x0a, 0x80, 0x5c, 0x7a, 0x00, 0x7b, 0x1a, 0xe5, 0x17, 0xae, 0x16, 0x78, 
    0x02, 0xc3, 0x33, 0xce, 0x33, 0xce, 0xd8, 0xf9, 0x24, 0x0b, 0xff, 0xe4, 0x3e, 0xfe, 0xe5, 0x15, 
    0x90, 0x1a, 0x8e, 0x93, 0xfd, 0x7c, 0x00, 0x12, 0x07, 0x96, 0xef, 0x78, 0x02, 0xc3, 0x33, 0xce, 
    0x33, 0xce, 0xd8, 0xf9, 0x2b, 0xfb, 0xee, 0x3a, 0xfa, 0xe5, 0x17, 0xae, 0x16, 0x78, 0x02, 0xc3, 
    0x33, 0xce, 0x33, 0xce, 0xd8, 0xf9, 0x24, 0x0b, 0xff, 0xe4, 0x3e, 0xfe, 0xe5, 0x15, 0x90, 0x1a, 
    0x8e, 0x93, 0xfd, 0x7c, 0x00, 0x12, 0x07, 0x96, 0xed, 0x4c, 0x60, 0x07, 0x74, 0x04, 0x2b, 0xfb, 
    0xe4, 0x3a, 0xfa, 0xcf, 0xeb, 0xcf, 0xce, 0xea, 0xce, 0x22, 0xe5, 0x2e, 0x14, 0x60, 0x1d, 0x14, 
    0x60, 0x3d, 0x14, 0x60, 0x5d, 0x14, 0x70, 0x03, 0x02, 0x0f, 0xd7, 0x24, 0x04, 0x60, 0x03, 0x02, 
    0x0f, 0xed, 0x20, 0x0d, 0x03, 0x02, 0x0f, 0xed, 0x75, 0x2e, 0x01, 0x22, 0x90, 0x00, 0x0a, 0xe0, 
    0xff, 0x30, 0xe5, 0x03, 0x44, 0x20, 0xf0, 0xe5, 0x40, 0x45, 0x3f, 0x60, 0x03, 0x02, 0x0f, 0xed, 
    0x75, 0x2e, 0x02, 0x12, 0x19, 0x9b, 0x12, 0x1b, 0x78, 0xaf, 0x28, 0x12, 0x1a, 0xa8, 0x22, 0x90, 
    0x01, 0x03, 0xe0, 0xff, 0x30, 0xe7, 0x76, 0xef, 0x44, 0x80, 0x90, 0x01, 0x03, 0xf0, 0x12, 0x08, 
    0x51, 0x12, 0x19, 0xde, 0x12, 0x1b, 0xbb, 0x75, 0x2e, 0x03, 0xaf, 0x22, 0x7e, 0x00, 0x12, 0x1c, 
    0x2a, 0x22, 0xe5, 0x40, 0x45, 0x3f, 0x70, 0x21, 0x12, 0x14, 0x41, 0x12, 0x1b, 0x78, 0x12, 0x19, 
    0xbe, 0x12, 0x1b, 0xbb, 0x12, 0x1c, 0x04, 0x30, 0x0d, 0x0b, 0x75, 0x2e, 0x01, 0xaf, 0x32, 0x7e, 
    0x00, 0x12, 0x1c, 0x2a, 0x22, 0xe4, 0xf5, 0x2e, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0xff, 0x30, 0xe5, 
    0x2c, 0x44, 0x20, 0xf0, 0x12, 0x14, 0x41, 0x12, 0x1b, 0x78, 0x12, 0x19, 0xbe, 0x12, 0x1b, 0xbb, 
    0x12, 0x1c, 0x04, 0x75, 0x2e, 0x04, 0x22, 0xe5, 0x40, 0x45, 0x3f, 0x70, 0x10, 0x30, 0x0d, 0x0a, 
    0x75, 0x2e, 0x01, 0xaf, 0x32, 0xfe, 0x12, 0x1c, 0x2a, 0x22, 0xe4, 0xf5, 0x2e, 0x22, 0x90, 0x00, 
    0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0x30, 0x09, 0x32, 0xe5, 0x34, 0x45, 0x33, 0x70, 
    0x02, 0xc3, 0x22, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 0xe0, 0xfe, 0xa3, 
    0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 
    0xef, 0x9d, 0xff, 0xee, 0x9c, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 0xe5, 0x34, 0x45, 
    0x33, 0x70, 0x02, 0xc3, 0x22, 0x12, 0x05, 0xed, 0x50, 0xf3, 0x90, 0x00, 0x0a, 0xe0, 0x20, 0xe5, 
    0x03, 0x30, 0x07, 0x41, 0xe5, 0x34, 0x45, 0x33, 0x70, 0x02, 0xc3, 0x22, 0x85, 0x34, 0x82, 0x85, 
    0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 
    0x83, 0xa3, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xd0, 0x82, 
    0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 0xe5, 0x34, 0x45, 0x33, 0x70, 0x02, 0xc3, 0x22, 0x12, 0x05, 
    0xed, 0x50, 0xf3, 0x80, 0xb5, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 
    0x12, 0x16, 0xea, 0xd3, 0x22, 0x12, 0x1a, 0xfe, 0x40, 0x05, 0x12, 0x1a, 0xd4, 0x50, 0x44, 0x7e, 
    0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x82, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x14, 0xab, 0x90, 
    0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xe4, 0xff, 0xfe, 0x12, 0x1c, 0x36, 0x90, 
    0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 0x54, 0x7f, 0xff, 0xf0, 0xe4, 0x90, 0x30, 0xe9, 0xf0, 0xef, 
    0x54, 0xfd, 0x90, 0x00, 0x0b, 0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0xd2, 0x09, 0x12, 0x0f, 0xee, 
    0xe4, 0xf5, 0x2f, 0x12, 0x1b, 0x13, 0x50, 0x48, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x82, 
    0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x14, 0xab, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 
    0x0a, 0xf0, 0xe4, 0xff, 0xfe, 0x12, 0x1c, 0x36, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 0x54, 
    0xfd, 0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0xff, 0x12, 0x19, 0x78, 0x50, 0x04, 0x75, 0x2f, 0x07, 
    0x22, 0x90, 0x01, 0x04, 0xe0, 0x54, 0x7f, 0xf0, 0xd2, 0x09, 0x12, 0x0f, 0xee, 0xe4, 0xf5, 0x2f, 
    0x22, 0xc2, 0xaf, 0xe4, 0xf5, 0x2f, 0xf5, 0x88, 0x75, 0xa8, 0x0f, 0x75, 0x89, 0x11, 0xf5, 0xb8, 
    0xf5, 0xe8, 0x75, 0x90, 0x0f, 0x75, 0x31, 0xff, 0x75, 0x2b, 0xff, 0x90, 0x22, 0x2e, 0xf0, 0xa3, 
    0xf0, 0x90, 0x22, 0x4e, 0xf0, 0xa3, 0xf0, 0xc2, 0x05, 0xc2, 0x08, 0xc2, 0x00, 0xc2, 0x07, 0xc2, 
    0x04, 0x90, 0x00, 0x0a, 0x74, 0xff, 0xf0, 0x90, 0x00, 0x0b, 0x74, 0x01, 0xf0, 0x90, 0x01, 0x03, 
    0x74, 0xff, 0xf0, 0xe4, 0x90, 0x01, 0x04, 0xf0, 0x90, 0x01, 0x05, 0x74, 0xff, 0xf0, 0xe4, 0x90, 
    0x01, 0x06, 0xf0, 0x90, 0x00, 0x04, 0xf0, 0x90, 0x30, 0xe8, 0x74, 0x10, 0xf0, 0x90, 0x01, 0x07, 
    0xf0, 0x90, 0x01, 0x08, 0x04, 0xf0, 0x90, 0x01, 0x09, 0x74, 0x48, 0xf0, 0x90, 0x01, 0x0a, 0x74, 
    0x7f, 0xf0, 0x90, 0x01, 0x02, 0x74, 0x1f, 0xf0, 0x90, 0x01, 0x00, 0x74, 0x14, 0xf0, 0x90, 0x01, 
    0x01, 0x74, 0x20, 0xf0, 0x90, 0x00, 0x00, 0xe0, 0x44, 0x80, 0xf0, 0x75, 0x49, 0x00, 0x75, 0x4a, 
    0x01, 0xc2, 0x01, 0xd2, 0xaf, 0x22, 0x12, 0x1a, 0xd4, 0x50, 0x2d, 0x12, 0x18, 0x48, 0x90, 0x01, 
    0x06, 0xe0, 0x54, 0xdf, 0xf0, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x82, 0x75, 0x1b, 0x12, 
    0x7b, 0x06, 0x12, 0x14, 0xab, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xd2, 
    0x09, 0x12, 0x0f, 0xee, 0xe4, 0xf5, 0x2f, 0x22, 0x12, 0x1b, 0x28, 0x50, 0x50, 0x12, 0x18, 0x48, 
    0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0x90, 0x01, 0x03, 0x74, 
    0x80, 0xf0, 0x90, 0x01, 0x04, 0xe0, 0x44, 0x80, 0xf0, 0x7f, 0x02, 0x12, 0x19, 0x78, 0x50, 0x04, 
    0x75, 0x2f, 0x05, 0x22, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x82, 0x75, 0x1b, 0x12, 0x7b, 
    0x06, 0x12, 0x14, 0xab, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xd2, 0x09, 
    0x12, 0x0f, 0xee, 0x90, 0x01, 0x04, 0xe0, 0x54, 0x7f, 0xf0, 0xe4, 0xf5, 0x2f, 0x22, 0x90, 0x30, 
    0x30, 0x74, 0x02, 0xf0, 0x75, 0x11, 0x07, 0x75, 0x12, 0xd0, 0x90, 0x30, 0x30, 0xe0, 0x30, 0xe0, 
    0x0e, 0xe5, 0x12, 0x15, 0x12, 0x70, 0x02, 0x15, 0x11, 0xe5, 0x12, 0x45, 0x11, 0x70, 0xeb, 0xe5, 
    0x12, 0x45, 0x11, 0x70, 0x12, 0x12, 0x1a, 0x74, 0x90, 0x21, 0x00, 0xe0, 0x60, 0x07, 0x90, 0x34, 
    0x98, 0xe0, 0x44, 0x04, 0xf0, 0xc3, 0x22, 0xe4, 0x90, 0x34, 0x58, 0xf0, 0x90, 0x34, 0x32, 0x74, 
    0x1f, 0xf0, 0x75, 0x11, 0x07, 0x75, 0x12, 0xd0, 0x90, 0x34, 0x81, 0xe0, 0x64, 0x03, 0x60, 0x0e, 
    0xe5, 0x12, 0x15, 0x12, 0x70, 0x02, 0x15, 0x11, 0xe5, 0x12, 0x45, 0x11, 0x70, 0xea, 0xe5, 0x12, 
    0x45, 0x11, 0x70, 0x12, 0x12, 0x1a, 0x74, 0x90, 0x21, 0x00, 0xe0, 0x60, 0x07, 0x90, 0x34, 0x98, 
    0xe0, 0x44, 0x04, 0xf0, 0xc3, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x04, 0xf0, 0xe4, 0x90, 0x00, 
    0x01, 0xf0, 0xd3, 0x22, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x10, 0x12, 0x1c, 0x57, 0x50, 0x26, 0xe5, 
    0x27, 0x30, 0xe6, 0x05, 0x53, 0x10, 0xfd, 0x80, 0x03, 0x43, 0x10, 0x02, 0xe5, 0x27, 0x30, 0xe7, 
    0x05, 0x53, 0x10, 0xf7, 0x80, 0x03, 0x43, 0x10, 0x08, 0x53, 0x10, 0xfe, 0x43, 0x10, 0x04, 0x90, 
    0x30, 0x3a, 0xe5, 0x10, 0xf0, 0x12, 0x1c, 0x4c, 0x50, 0x48, 0x90, 0x01, 0x03, 0xe0, 0xf5, 0x10, 
    0x54, 0x1c, 0x60, 0x3e, 0xe5, 0x10, 0x54, 0xe3, 0xf0, 0xa3, 0xe0, 0xf5, 0x10, 0xf0, 0xe5, 0x27, 
    0x30, 0xe6, 0x05, 0x43, 0x10, 0x02, 0x80, 0x03, 0x53, 0x10, 0xfd, 0xe5, 0x27, 0x30, 0xe7, 0x05, 
    0x43, 0x10, 0x08, 0x80, 0x03, 0x53, 0x10, 0xf7, 0x53, 0x10, 0xfe, 0x43, 0x10, 0x04, 0x90, 0x30, 
    0x3a, 0xe5, 0x10, 0xf0, 0xaf, 0x29, 0x7e, 0x00, 0x12, 0x1c, 0x74, 0xaf, 0x35, 0x7e, 0x00, 0x12, 
    0x1c, 0x7b, 0x22, 0x12, 0x1a, 0xbf, 0x50, 0x72, 0x12, 0x1c, 0x41, 0x85, 0x34, 0x82, 0x85, 0x33, 
    0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xc3, 0x9f, 0xf5, 0x12, 0xec, 0x9e, 0xf5, 0x11, 0xd3, 0xe5, 0x12, 
    0x94, 0x00, 0xe5, 0x11, 0x64, 0x80, 0x94, 0x80, 0x40, 0x06, 0xae, 0x11, 0xaf, 0x12, 0x80, 0x04, 
    0x7e, 0x00, 0x7f, 0x00, 0x8e, 0x11, 0x8f, 0x12, 0xe5, 0x34, 0x24, 0x10, 0xf5, 0x82, 0xe4, 0x35, 
    0x33, 0xf5, 0x83, 0xe0, 0xc3, 0x95, 0x12, 0xf5, 0x12, 0xe4, 0x95, 0x11, 0xf5, 0x11, 0xc3, 0x64, 
    0x80, 0x94, 0x80, 0x50, 0x05, 0xe4, 0xf5, 0x11, 0xf5, 0x12, 0xe5, 0x34, 0x24, 0x12, 0xff, 0xe4, 
    0x35, 0x33, 0xfe, 0xad, 0x12, 0x7b, 0x01, 0x12, 0x19, 0x2b, 0x90, 0x01, 0x05, 0x74, 0x20, 0xf0, 
    0x90, 0x01, 0x06, 0xe0, 0x44, 0x20, 0xf0, 0x75, 0x2f, 0x03, 0x22, 0xc0, 0xe0, 0xc0, 0xf0, 0xc0, 
    0x83, 0xc0, 0x82, 0xc0, 0xd0, 0x75, 0xd0, 0x08, 0xc2, 0xaf, 0x90, 0x22, 0x2e, 0xe0, 0xfe, 0xa3, 
    0xe0, 0x8e, 0x33, 0xf5, 0x34, 0xe5, 0x2f, 0x25, 0xe0, 0x24, 0x9b, 0xf5, 0x82, 0xe4, 0x34, 0x1b, 
    0xf5, 0x83, 0xe4, 0x93, 0xfe, 0x74, 0x01, 0x93, 0xca, 0xee, 0xca, 0xf9, 0x12, 0x08, 0x4b, 0x12, 
    0x1b, 0xf6, 0x50, 0x02, 0xd2, 0x07, 0x12, 0x17, 0x2c, 0x12, 0x00, 0x1e, 0x12, 0x1a, 0xe9, 0x50, 
    0x05, 0xaf, 0x25, 0x12, 0x1c, 0x62, 0x30, 0x05, 0x1b, 0xe5, 0x2f, 0x70, 0x17, 0x20, 0x04, 0x14, 
    0x12, 0x12, 0x4e, 0x92, 0x00, 0xc2, 0x05, 0xd2, 0x0b, 0xa2, 0x00, 0xe4, 0x33, 0xf5, 0x14, 0xaf, 
    0x23, 0x12, 0x16, 0xa2, 0xd2, 0xaf, 0xd0, 0xd0, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xf0, 0xd0, 0xe0, 
    0x32, 0x90, 0x29, 0xa0, 0xe0, 0x70, 0x63, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xa3, 0x74, 0xc2, 0xf0, 
    0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 0xff, 0x90, 0x29, 0xa0, 0xf0, 
    0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xa3, 0x74, 0xc5, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 
    0x90, 0x30, 0x8c, 0xe0, 0xff, 0x90, 0x29, 0xa1, 0xf0, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xa3, 0x74, 
    0xc4, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 0xff, 0x90, 0x29, 
    0xa2, 0xf0, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xa3, 0x74, 0xc3, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 
    0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 0x90, 0x29, 0xa3, 0xf0, 0x22, 0x8e, 0x16, 0x8f, 0x17, 0x8c, 
    0x18, 0x8d, 0x19, 0xe4, 0xff, 0xef, 0xc3, 0x9b, 0x50, 0x53, 0xe5, 0x1b, 0x30, 0xe0, 0x12, 0xef, 
    0x7c, 0x00, 0x25, 0x19, 0xfd, 0xec, 0x35, 0x18, 0x8d, 0x82, 0xf5, 0x83, 0xe0, 0xf5, 0x1c, 0x80, 
    0x1f, 0xe5, 0x1b, 0x30, 0xe1, 0x13, 0xef, 0x7c, 0x00, 0x25, 0x19, 0xfd, 0xec, 0x35, 0x18, 0x8d, 
    0x82, 0xf5, 0x83, 0xe4, 0x93, 0xf5, 0x1c, 0x80, 0x07, 0xe5, 0x19, 0x2f, 0xf8, 0xe6, 0xf5, 0x1c, 
    0xe5, 0x1b, 0x30, 0xe4, 0x0f, 0xe5, 0x17, 0x2f, 0xf5, 0x82, 0xe4, 0x35, 0x16, 0xf5, 0x83, 0xe5, 
    0x1c, 0xf0, 0x80, 0x06, 0xe5, 0x17, 0x2f, 0xf8, 0xa6, 0x1c, 0x0f, 0x80, 0xa8, 0x22, 0x8c, 0x13, 
    0x8d, 0x14, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0x4c, 
    0x60, 0x41, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xf5, 
    0x82, 0x8c, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x85, 0x14, 0x82, 0x85, 0x13, 0x83, 0xe0, 0xfa, 
    0xa3, 0xe0, 0xfb, 0xd3, 0xed, 0x9b, 0xea, 0x64, 0x80, 0xf8, 0xec, 0x64, 0x80, 0x98, 0x40, 0x13, 
    0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xce, 0xec, 0xce, 
    0xff, 0x80, 0xaf, 0xad, 0x14, 0xac, 0x13, 0x12, 0x18, 0xaf, 0x22, 0x12, 0x1a, 0xbf, 0x50, 0x4f, 
    0xe5, 0x34, 0x24, 0x12, 0xff, 0xe4, 0x35, 0x33, 0xfe, 0xe5, 0x34, 0x24, 0x10, 0xf5, 0x82, 0xe4, 
    0x35, 0x33, 0xf5, 0x83, 0xe0, 0xfd, 0xe4, 0xfb, 0x12, 0x19, 0x2b, 0xe5, 0x34, 0x24, 0x10, 0xf5, 
    0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x7e, 0x00, 0x12, 0x1c, 0x36, 0x90, 0x00, 0x0a, 
    0x74, 0x40, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x40, 0xff, 0xf0, 0x90, 0x00, 0x0a, 0x74, 0x80, 
    0xf0, 0x4f, 0x90, 0x00, 0x0b, 0xf0, 0x90, 0x30, 0xe9, 0x74, 0x01, 0xf0, 0x75, 0x2f, 0x06, 0x22, 
    0x90, 0x30, 0x3a, 0xe0, 0xff, 0xe5, 0x27, 0x30, 0xe6, 0x12, 0x30, 0x0c, 0x06, 0xef, 0x54, 0xf5, 
    0xfe, 0x80, 0x04, 0xef, 0x44, 0x0a, 0xfe, 0xcf, 0xee, 0xcf, 0x80, 0x10, 0x30, 0x0c, 0x06, 0xef, 
    0x44, 0x0a, 0xfe, 0x80, 0x04, 0xef, 0x54, 0xf5, 0xfe, 0xcf, 0xee, 0xcf, 0xcf, 0x54, 0xfe, 0xcf, 
    0xcf, 0x44, 0x04, 0xcf, 0x90, 0x30, 0x3a, 0xef, 0xf0, 0x30, 0x0c, 0x09, 0x7f, 0x08, 0x7e, 0x00, 
    0x12, 0x1c, 0x74, 0x80, 0x07, 0x7f, 0x22, 0x7e, 0x01, 0x12, 0x1c, 0x74, 0xb2, 0x0c, 0x22, 0xc0, 
    0xe0, 0xc0, 0xf0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0xd0, 0x75, 0xd0, 0x08, 0xc2, 0xaf, 0xc2, 0x8c, 
    0xc2, 0x8d, 0xd3, 0xe5, 0x4a, 0x94, 0x00, 0xe5, 0x49, 0x94, 0x00, 0x40, 0x08, 0xe5, 0x4a, 0x15, 
    0x4a, 0x70, 0x02, 0x15, 0x49, 0xd3, 0xe5, 0x4c, 0x94, 0x00, 0xe5, 0x4b, 0x94, 0x00, 0x40, 0x08, 
    0xe5, 0x4c, 0x15, 0x4c, 0x70, 0x02, 0x15, 0x4b, 0x12, 0x00, 0x0e, 0xd2, 0x8c, 0xd2, 0xaf, 0xd0, 
    0xd0, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xf0, 0xd0, 0xe0, 0x32, 0xc3, 0xef, 0x94, 0x04, 0xee, 0x64, 
    0x80, 0x94, 0x80, 0x40, 0x0c, 0xd3, 0xed, 0x94, 0x04, 0xec, 0x64, 0x80, 0x94, 0x80, 0x50, 0x01, 
    0x22, 0xc3, 0xef, 0x94, 0xfc, 0xee, 0x64, 0x80, 0x94, 0x7f, 0x40, 0x0c, 0xd3, 0xed, 0x94, 0xfc, 
    0xec, 0x64, 0x80, 0x94, 0x7f, 0x50, 0x01, 0x22, 0xd3, 0xef, 0x94, 0x04, 0xee, 0x64, 0x80, 0x94, 
    0x80, 0x50, 0x0d, 0xc3, 0xed, 0x94, 0xfc, 0xec, 0x64, 0x80, 0x94, 0x7f, 0x40, 0x02, 0xd3, 0x22, 
    0xc3, 0x22, 0xe4, 0xfe, 0xef, 0xf4, 0x60, 0x41, 0x74, 0x04, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x21, 
    0xf5, 0x83, 0xe0, 0xb4, 0xff, 0x23, 0x74, 0x04, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 
    0xef, 0xf0, 0x30, 0x0b, 0x0d, 0x74, 0x08, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe5, 
    0x14, 0xf0, 0x90, 0x00, 0x02, 0x74, 0x01, 0xf0, 0x22, 0xbe, 0x03, 0x0a, 0x90, 0x00, 0x02, 0x74, 
    0x01, 0xf0, 0xe4, 0xfe, 0x80, 0xc2, 0x0e, 0x80, 0xbf, 0x22, 0x8e, 0x13, 0x8f, 0x14, 0x12, 0x1c, 
    0x41, 0xc3, 0xef, 0x95, 0x14, 0xff, 0xee, 0x95, 0x13, 0xcd, 0xef, 0xcd, 0xfc, 0xd3, 0xed, 0x94, 
    0x00, 0xec, 0x64, 0x80, 0x94, 0x80, 0x40, 0x05, 0xce, 0xec, 0xce, 0x80, 0x04, 0x7e, 0x00, 0x7f, 
    0x01, 0xcc, 0xee, 0xcc, 0xec, 0x90, 0x00, 0x05, 0xf0, 0x90, 0x00, 0x06, 0xef, 0xf0, 0x90, 0x00, 
    0x04, 0x74, 0x51, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x02, 0xf0, 0x22, 0x30, 0x07, 0x3c, 0xe5, 
    0x2f, 0x70, 0x38, 0xc2, 0x07, 0x90, 0x22, 0x2e, 0xe0, 0xfe, 0xa3, 0xe0, 0x8e, 0x11, 0xf5, 0x12, 
    0x90, 0x22, 0x4e, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x90, 0x22, 0x2e, 0xee, 0xf0, 0xa3, 0xef, 0xf0, 
    0x90, 0x22, 0x4e, 0xe5, 0x11, 0xf0, 0xa3, 0xe5, 0x12, 0xf0, 0x8e, 0x33, 0x8f, 0x34, 0x30, 0x08, 
    0x05, 0x12, 0x17, 0xa5, 0xc2, 0x08, 0xc2, 0x09, 0x12, 0x0f, 0xee, 0x22, 0x7f, 0x80, 0x7e, 0x29, 
    0xe4, 0xfd, 0xfc, 0x8f, 0x82, 0x8e, 0x83, 0xe0, 0xfb, 0x74, 0x45, 0x2d, 0xf8, 0xc6, 0xeb, 0xc6, 
    0x74, 0x04, 0x2f, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfb, 0x74, 0x41, 0x2d, 0xf8, 0xc6, 
    0xeb, 0xc6, 0x74, 0x08, 0x2f, 0xff, 0xe4, 0x3e, 0xfe, 0x0d, 0xbd, 0x00, 0x01, 0x0c, 0xed, 0x64, 
    0x04, 0x4c, 0x70, 0xcf, 0x22, 0x90, 0x21, 0x00, 0xe0, 0xc4, 0x33, 0x54, 0xe0, 0x24, 0x10, 0xf5, 
    0x82, 0xe4, 0x34, 0x21, 0xab, 0x82, 0xfa, 0x12, 0x1b, 0xab, 0x8b, 0x82, 0x8a, 0x83, 0xee, 0x8f, 
    0xf0, 0x12, 0x07, 0xeb, 0x7e, 0x22, 0x7f, 0x30, 0xcd, 0xeb, 0xcd, 0xcc, 0xea, 0xcc, 0x12, 0x15, 
    0x0e, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0x62, 0x22, 0x90, 0x00, 0x00, 0x74, 
    0x0e, 0xf0, 0x00, 0x00, 0x00, 0xe4, 0xf0, 0x12, 0x11, 0x31, 0x12, 0x1c, 0x88, 0x90, 0x34, 0x98, 
    0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x30, 0xb4, 0x05, 0x0a, 0x12, 0x1c, 0x4c, 0x50, 0x0d, 0x12, 0x15, 
    0xc0, 0x80, 0x08, 0xe5, 0x30, 0xb4, 0x07, 0x03, 0x12, 0x12, 0xd4, 0x12, 0x0f, 0x2a, 0x80, 0xe4, 
    0x80, 0xfe, 0x22, 0xe4, 0xff, 0xe5, 0x30, 0x24, 0xfe, 0x70, 0x2c, 0xe4, 0xfe, 0xee, 0xc3, 0x95, 
    0x2c, 0x50, 0x12, 0x74, 0x01, 0xc8, 0xee, 0xc8, 0x08, 0x80, 0x02, 0xc3, 0x33, 0xd8, 0xfc, 0xcf, 
    0x4f, 0xcf, 0x0e, 0x80, 0xe8, 0x90, 0x30, 0x34, 0xe0, 0x54, 0xe0, 0xfe, 0xe5, 0x27, 0x54, 0x1f, 
    0x6f, 0xf4, 0xce, 0x4e, 0xce, 0xee, 0xf0, 0x22, 0x90, 0x34, 0xce, 0xe0, 0x44, 0x02, 0xf0, 0x90, 
    0x34, 0xcd, 0xe0, 0x54, 0xfe, 0xf0, 0x90, 0x34, 0xcd, 0xe0, 0x20, 0xe3, 0xf9, 0x90, 0x01, 0x11, 
    0xe0, 0x54, 0x22, 0xff, 0xbf, 0x22, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x50, 0xf0, 0x90, 0x01, 0x00, 
    0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x54, 0xbf, 0xf0, 0x22, 0xef, 0x24, 0x1e, 0xf5, 
    0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xfb, 0xca, 0xec, 0xca, 0x24, 0x1e, 0xf5, 
    0x82, 0xe4, 0x3c, 0xf5, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 
    0x3e, 0xf5, 0x83, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0xce, 0xea, 0xce, 0xcf, 0xeb, 0xcf, 0x22, 0xef, 
    0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xed, 0x24, 0x1e, 
    0xf5, 0x82, 0xe4, 0x3c, 0xf5, 0x83, 0xea, 0xf0, 0xa3, 0xeb, 0xf0, 0xef, 0x24, 0x1e, 0xf5, 0x82, 
    0xe4, 0x3e, 0xf5, 0x83, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0x22, 0xc0, 0xe0, 0xc0, 0xd0, 0xc2, 0xaf, 
    0xc2, 0x8e, 0xc2, 0x8f, 0xd3, 0xe5, 0x40, 0x94, 0x00, 0xe5, 0x3f, 0x94, 0x00, 0x40, 0x0d, 0xe5, 
    0x40, 0x15, 0x40, 0x70, 0x02, 0x15, 0x3f, 0x12, 0x1c, 0x6b, 0xd2, 0x8e, 0xd2, 0xaf, 0xd0, 0xd0, 
    0xd0, 0xe0, 0x32, 0x12, 0x1a, 0xbf, 0x50, 0x22, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x82, 
    0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x14, 0xab, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 
    0x0a, 0xf0, 0xd2, 0x09, 0x12, 0x0f, 0xee, 0xe4, 0xf5, 0x2f, 0x22, 0x8e, 0x13, 0x8f, 0x14, 0x8d, 
    0x15, 0xeb, 0x60, 0x09, 0x14, 0x70, 0x1b, 0xaf, 0x15, 0x12, 0x19, 0xfe, 0x22, 0x7e, 0x30, 0x7f, 
    0xe0, 0xac, 0x13, 0xad, 0x14, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x14, 0xab, 0xaf, 0x15, 0x12, 
    0x19, 0xfe, 0x22, 0x12, 0x17, 0x6c, 0x90, 0x21, 0x01, 0xe0, 0xf5, 0x28, 0x74, 0x41, 0x25, 0x28, 
    0xf8, 0xe6, 0xf5, 0x32, 0x74, 0x45, 0x25, 0x28, 0xf8, 0xe6, 0xf5, 0x22, 0x90, 0x21, 0x00, 0xe0, 
    0x60, 0x03, 0xd2, 0x0d, 0x22, 0xc2, 0x0d, 0x22, 0xcd, 0xef, 0xcd, 0x90, 0x01, 0x02, 0xe0, 0x30, 
    0xe7, 0x02, 0xc3, 0x22, 0x7e, 0x2a, 0x7f, 0x00, 0x12, 0x04, 0x0e, 0x90, 0x01, 0x04, 0xe0, 0x44, 
    0x80, 0xf0, 0x90, 0x01, 0x02, 0xe0, 0x44, 0x80, 0xf0, 0xd3, 0x22, 0x90, 0x34, 0x30, 0xe4, 0xf0, 
    0xa3, 0xf0, 0xa3, 0x74, 0x1f, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x01, 0x10, 0xe0, 0x20, 0xe1, 0x03, 
    0x00, 0x80, 0xf6, 0x90, 0x01, 0x12, 0xe0, 0x20, 0xe1, 0x03, 0x00, 0x80, 0xf6, 0x22, 0xe4, 0xff, 
    0x74, 0x36, 0x2f, 0xf8, 0xe6, 0x90, 0x30, 0x8c, 0xf0, 0xef, 0x90, 0x1b, 0x51, 0x93, 0x90, 0x30, 
    0x8d, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x0f, 0xbf, 0x09, 0xe3, 0x22, 0xe4, 0xff, 
    0xef, 0x90, 0x1b, 0x5b, 0x93, 0x90, 0x30, 0x8c, 0xf0, 0xef, 0x90, 0x1b, 0x51, 0x93, 0x90, 0x30, 
    0x8d, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x0f, 0xbf, 0x09, 0xe3, 0x22, 0xe4, 0x90, 
    0x00, 0x05, 0xf0, 0xef, 0x60, 0x02, 0x80, 0x02, 0x7f, 0x01, 0x90, 0x00, 0x06, 0xef, 0xf0, 0x90, 
    0x00, 0x04, 0x74, 0x51, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x02, 0xf0, 0x22, 0x90, 0x30, 0xf0, 
    0xe0, 0xf5, 0x2a, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe4, 0x0e, 0x90, 0x30, 0xf2, 0xe0, 0x60, 0x08, 
    0x90, 0x00, 0x0a, 0x74, 0x10, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x30, 0xf0, 0xe0, 0xf5, 0x2a, 
    0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe4, 0x0e, 0x90, 0x30, 0xf2, 0xe0, 0x70, 0x08, 0x90, 0x00, 0x0a, 
    0x74, 0x10, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x34, 0xce, 0xe0, 0x44, 0x02, 0xf0, 0x90, 0x34, 
    0xcd, 0xe0, 0x54, 0xfe, 0xf0, 0x90, 0x01, 0x00, 0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 
    0x54, 0xbf, 0xf0, 0x22, 0x90, 0x00, 0x01, 0x74, 0x0e, 0xf0, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfb, 
    0xf0, 0x90, 0x34, 0x58, 0x74, 0x01, 0xf0, 0x90, 0x30, 0x30, 0x74, 0x04, 0xf0, 0x22, 0x02, 0x04, 
    0x0b, 0x16, 0x0c, 0x12, 0x18, 0x24, 0x30, 0x48, 0x60, 0x6c, 0x90, 0xc8, 0x00, 0x01, 0x02, 0x03, 
    0x0b, 0x0f, 0x0a, 0x0e, 0x09, 0x0d, 0x08, 0x0c, 0xef, 0xc4, 0x33, 0x33, 0x54, 0xc0, 0xff, 0x90, 
    0x01, 0x00, 0xe0, 0x54, 0x3f, 0x4f, 0xf0, 0x90, 0x01, 0x02, 0xe0, 0x44, 0x80, 0xf0, 0x22, 0x90, 
    0x01, 0x03, 0xe0, 0x30, 0xe7, 0x0c, 0x74, 0x80, 0xf0, 0x90, 0x01, 0x04, 0xe0, 0x54, 0x7f, 0xf0, 
    0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe1, 0x0c, 0x74, 0x02, 0xf0, 0x90, 0x00, 
    0x0b, 0xe0, 0x54, 0xfd, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe2, 0x0c, 
    0x74, 0x04, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfb, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 
    0x0a, 0xe0, 0x30, 0xe6, 0x0c, 0x74, 0x40, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 0xd3, 
    0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe7, 0x0c, 0x74, 0x80, 0xf0, 0x90, 0x00, 0x0b, 
    0xe0, 0x54, 0x7f, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x01, 0x05, 0xe0, 0x30, 0xe5, 0x0c, 0x74, 
    0x20, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0xe4, 0xf5, 0x31, 
    0x90, 0x00, 0x0a, 0x74, 0xff, 0xf0, 0x90, 0x22, 0x2e, 0x74, 0x21, 0xf0, 0xa3, 0x74, 0x10, 0xf0, 
    0x22, 0x52, 0x53, 0x54, 0x12, 0x15, 0x16, 0x10, 0x11, 0x40, 0x00, 0x20, 0x00, 0x40, 0xff, 0x3f, 
    0x3f, 0xbd, 0x28, 0x21, 0x00, 0xe5, 0x34, 0x24, 0x11, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 
    0xe0, 0x30, 0xe6, 0x02, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x30, 0x40, 0x74, 0x32, 0xf0, 0xa3, 0x74, 
    0xb0, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x22, 0x75, 0x31, 0x01, 0x90, 0x00, 0x0a, 
    0x74, 0xff, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x20, 0xf0, 0x22, 0x0b, 0xd1, 0x13, 0x53, 0x15, 
    0x6b, 0x11, 0xc6, 0x00, 0x09, 0x19, 0x03, 0x10, 0x95, 0x1b, 0xda, 0x90, 0x30, 0x64, 0xe0, 0xfd, 
    0xa3, 0xe0, 0xfe, 0xed, 0x25, 0xe0, 0xff, 0xee, 0x33, 0xfe, 0x22, 0x90, 0x30, 0x40, 0x74, 0x32, 
    0xf0, 0xa3, 0x74, 0xb0, 0xf0, 0xa3, 0xe4, 0xf0, 0xa3, 0xf0, 0x22, 0x90, 0x01, 0x00, 0xe0, 0x44, 
    0x08, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x44, 0x40, 0xf0, 0x22, 0x12, 0x1a, 0xbf, 0x50, 0x08, 0xd2, 
    0x09, 0x12, 0x0f, 0xee, 0xe4, 0xf5, 0x2f, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe0, 0x05, 0x74, 
    0x01, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe5, 0x05, 0x74, 0x20, 0xf0, 
    0xd3, 0x22, 0xc3, 0x22, 0x90, 0x34, 0x30, 0x74, 0x1f, 0xf0, 0xa3, 0xe4, 0xf0, 0xa3, 0xf0, 0xa3, 
    0xf0, 0x22, 0x78, 0x7f, 0xe4, 0xf6, 0xd8, 0xfd, 0x75, 0x81, 0x4c, 0x02, 0x17, 0xdc, 0xc2, 0xaf, 
    0xc2, 0x8c, 0xc2, 0x8d, 0x12, 0x00, 0x0e, 0xd2, 0xaf, 0x22, 0xc2, 0x8e, 0x8e, 0x3f, 0x8f, 0x40, 
    0x12, 0x1c, 0x6b, 0xd2, 0x8e, 0x22, 0x90, 0x30, 0x3c, 0xef, 0xf0, 0xee, 0x44, 0x80, 0xa3, 0xf0, 
    0x22, 0x90, 0x30, 0x78, 0xe0, 0xfd, 0xa3, 0xe0, 0xfe, 0xed, 0xff, 0x22, 0xe5, 0x4a, 0x45, 0x49, 
    0x70, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x22, 0xe5, 0x4c, 0x45, 0x4b, 0x70, 0x03, 0xd3, 0x80, 0x01, 
    0xc3, 0x22, 0xc2, 0x0b, 0xe4, 0xf5, 0x14, 0x12, 0x16, 0xa2, 0x22, 0xc2, 0x8f, 0x75, 0x8d, 0xf5, 
    0x75, 0x8b, 0x41, 0x22, 0x8e, 0x49, 0x8f, 0x4a, 0xd2, 0x8c, 0x22, 0x8e, 0x4b, 0x8f, 0x4c, 0xd2, 
    0x8c, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x0d, 0xe4, 0xf5, 0x2e, 0x22, 0x00, 0x00
};
#define	RT2561_FIRMIM_LEN		(sizeof (RT2561_FirmwareImage) / sizeof(UCHAR))

static UCHAR RT2561S_FirmwareImage[] = {
    0x02, 0x1c, 0x2d, 0x02, 0x07, 0xdf, 0xc2, 0x8c, 0x22, 0x22, 0x00, 0x02, 0x19, 0x43, 0xc2, 0xaf, 
    0xc2, 0x8d, 0x75, 0x8c, 0x94, 0x75, 0x8a, 0x93, 0xd2, 0xaf, 0x22, 0x02, 0x1a, 0x9c, 0x12, 0x08, 
    0xdf, 0x40, 0x03, 0x02, 0x02, 0x1e, 0x90, 0x21, 0x02, 0xe0, 0xf5, 0x2d, 0x90, 0x00, 0x03, 0xe0, 
    0x12, 0x04, 0x3f, 0x00, 0xb0, 0x00, 0x00, 0xce, 0x01, 0x00, 0x5e, 0x10, 0x00, 0x6f, 0x11, 0x00, 
    0xf2, 0x20, 0x01, 0x4d, 0x21, 0x01, 0x70, 0x22, 0x01, 0x84, 0x30, 0x01, 0x8f, 0x31, 0x01, 0xd5, 
    0x50, 0x01, 0x9f, 0x51, 0x01, 0xf2, 0x52, 0x02, 0x06, 0x60, 0x00, 0x00, 0x02, 0x14, 0x90, 0x00, 
    0x0a, 0xe0, 0x20, 0xe5, 0x03, 0x30, 0x07, 0x03, 0xd2, 0x08, 0x22, 0x12, 0x14, 0x2b, 0x22, 0x90, 
    0x21, 0x00, 0xe0, 0xf5, 0x11, 0xe5, 0x11, 0xc4, 0x33, 0x54, 0xe0, 0x24, 0x21, 0xf5, 0x82, 0xe4, 
    0x34, 0x21, 0xf5, 0x83, 0xe0, 0x44, 0x80, 0xf0, 0xe5, 0x11, 0xc4, 0x33, 0x54, 0xe0, 0x24, 0x2c, 
    0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe5, 0x11, 0xf0, 0xc4, 0x33, 0x54, 0xe0, 0x24, 0x2d, 
    0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe5, 0x2d, 0xf0, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0x22, 
    0x12, 0x05, 0xcb, 0x90, 0x21, 0x00, 0xe0, 0xf5, 0x31, 0x60, 0x05, 0x12, 0x1b, 0xe0, 0x80, 0x03, 
    0x12, 0x1b, 0xa6, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x10, 0xe8, 0x22, 0x75, 0x31, 
    0xff, 0x90, 0x01, 0x00, 0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x54, 0xfe, 0xf0, 0x54, 
    0x3e, 0xf0, 0xe4, 0x90, 0x00, 0x0b, 0xf0, 0xf0, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x10, 
    0xe8, 0x22, 0x7e, 0x2b, 0x7f, 0x80, 0x7d, 0x03, 0x12, 0x0a, 0xfb, 0x90, 0x34, 0xcd, 0xe0, 0x20, 
    0xe3, 0xf9, 0x90, 0x21, 0x14, 0x12, 0x04, 0x1b, 0x90, 0x34, 0xc0, 0x12, 0x04, 0x27, 0x90, 0x21, 
    0x18, 0x12, 0x04, 0x1b, 0x90, 0x34, 0xc8, 0x12, 0x04, 0x27, 0x90, 0x21, 0x1c, 0x12, 0x04, 0x1b, 
    0x90, 0x34, 0xc4, 0x12, 0x04, 0x27, 0x90, 0x34, 0xcc, 0x74, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x04, 
    0xf0, 0x90, 0x01, 0x01, 0xe0, 0x44, 0x01, 0xf0, 0x44, 0x40, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 
    0x10, 0xf0, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x10, 0xe8, 0x22, 0x90, 0x01, 0x00, 
    0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x54, 0xfe, 0xf0, 0x54, 0xbf, 0xf0, 0x90, 0x00, 
    0x0b, 0xe0, 0x54, 0xef, 0xf0, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x10, 0xe8, 0x22, 
    0x7e, 0x2b, 0x7f, 0x80, 0x7d, 0x03, 0x12, 0x0a, 0xfb, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 
    0x12, 0x10, 0xe8, 0x22, 0xd2, 0x05, 0x85, 0x2d, 0x23, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0x22, 0x12, 
    0x13, 0xae, 0xc2, 0x00, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x10, 0xe8, 0x22, 0x85, 
    0x2d, 0x25, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfb, 0xff, 0xf0, 0xe4, 0x90, 0x00, 0x07, 0xf0, 0x90, 
    0x00, 0x0a, 0x74, 0x04, 0xf0, 0xe4, 0x90, 0x00, 0x08, 0xf0, 0x90, 0x21, 0x00, 0xe0, 0x90, 0x00, 
    0x09, 0xf0, 0x90, 0x00, 0x07, 0x74, 0x71, 0xf0, 0xef, 0x44, 0x04, 0x90, 0x00, 0x0b, 0xf0, 0xe4, 
    0x90, 0x21, 0x03, 0xf0, 0x22, 0x90, 0x21, 0x00, 0xe0, 0xff, 0x54, 0x1f, 0xf5, 0x30, 0xa3, 0xe0, 
    0xf5, 0x27, 0x8f, 0x26, 0x12, 0x14, 0x62, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x10, 
    0xe8, 0x22, 0x90, 0x21, 0x00, 0xe0, 0xf5, 0x2c, 0x12, 0x17, 0xa3, 0xe4, 0x90, 0x21, 0x03, 0xf0, 
    0xaf, 0x2d, 0x12, 0x10, 0xe8, 0x22, 0x12, 0x1a, 0xed, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 
    0x12, 0x10, 0xe8, 0x22, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x10, 0xe8, 0x22, 0xe5, 
    0x31, 0x64, 0x01, 0x70, 0x41, 0x12, 0x08, 0xed, 0x40, 0x03, 0x02, 0x03, 0x9d, 0x12, 0x0e, 0x34, 
    0x50, 0x20, 0x7e, 0x2b, 0x7f, 0x80, 0x7d, 0x03, 0x12, 0x0a, 0xfb, 0x7f, 0x01, 0x12, 0x0a, 0xd8, 
    0x40, 0x09, 0xd2, 0x09, 0x12, 0x0e, 0x47, 0xe4, 0xf5, 0x2f, 0x22, 0x12, 0x09, 0x64, 0x75, 0x2f, 
    0x01, 0x22, 0x7f, 0x01, 0x12, 0x0a, 0xd8, 0x50, 0x04, 0x75, 0x2f, 0x02, 0x22, 0xd2, 0x09, 0x12, 
    0x0e, 0x47, 0xe4, 0xf5, 0x2f, 0x22, 0x12, 0x08, 0x90, 0x50, 0x51, 0x12, 0x0a, 0xac, 0x90, 0x30, 
    0xf4, 0xe0, 0xf5, 0x2a, 0x7e, 0x30, 0x7f, 0xec, 0xa3, 0xe0, 0xfd, 0xe4, 0xfb, 0x12, 0x0d, 0xa0, 
    0xe4, 0xff, 0xfe, 0x12, 0x0e, 0x29, 0x90, 0x00, 0x0a, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 
    0x44, 0x02, 0xff, 0xf0, 0xfd, 0x90, 0x01, 0x05, 0x74, 0x20, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x44, 
    0x20, 0xf0, 0xed, 0x54, 0xbf, 0x90, 0x00, 0x0b, 0xf0, 0x90, 0x34, 0xcc, 0xe0, 0x44, 0x01, 0xf0, 
    0xa3, 0xe0, 0x44, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x01, 0xf0, 0xd2, 0x04, 0x12, 0x08, 0xad, 0x50, 
    0x43, 0x12, 0x0a, 0xbb, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x30, 0x7d, 0xec, 0x75, 0x1b, 0x11, 0x7b, 
    0x06, 0x12, 0x13, 0xc8, 0x90, 0x30, 0xf5, 0xe0, 0x75, 0xf0, 0x20, 0xa4, 0xff, 0xae, 0xf0, 0x12, 
    0x0e, 0x29, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 0xff, 0xf0, 0xfd, 0xe4, 0x90, 0x00, 0x04, 0xf0, 
    0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0x90, 0x00, 0x0a, 0x74, 0x40, 0xf0, 0x4d, 0x90, 0x00, 
    0x0b, 0xf0, 0xc2, 0x04, 0x12, 0x09, 0x25, 0x50, 0x38, 0x12, 0x0a, 0xbb, 0x7e, 0x30, 0x7f, 0xe0, 
    0x7c, 0x1c, 0x7d, 0x7e, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x13, 0xc8, 0x90, 0x00, 0x04, 0x74, 
    0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xe4, 0xff, 0xfe, 0x12, 0x0e, 0x29, 0x90, 0x00, 0x0b, 0xe0, 
    0x54, 0xfd, 0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0xc2, 
    0x04, 0x12, 0x09, 0x4f, 0x50, 0x25, 0x12, 0x0a, 0xbb, 0x7f, 0x02, 0x12, 0x0a, 0xd8, 0x90, 0x01, 
    0x04, 0xe0, 0x54, 0x7f, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 0xff, 0xf0, 0xe4, 0x90, 0x00, 
    0x04, 0xf0, 0xef, 0x54, 0xbf, 0x90, 0x00, 0x0b, 0xf0, 0xc2, 0x04, 0x12, 0x08, 0xed, 0x50, 0x2d, 
    0x12, 0x0a, 0xbb, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x7e, 0x75, 0x1b, 0x12, 0x7b, 0x06, 
    0x12, 0x13, 0xc8, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0x90, 0x01, 0x06, 
    0xe0, 0x54, 0xdf, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 0xc2, 0x04, 0x22, 0xef, 0x8d, 
    0xf0, 0xa4, 0xa8, 0xf0, 0xcf, 0x8c, 0xf0, 0xa4, 0x28, 0xce, 0x8d, 0xf0, 0xa4, 0x2e, 0xfe, 0x22, 
    0xbc, 0x00, 0x0b, 0xbe, 0x00, 0x29, 0xef, 0x8d, 0xf0, 0x84, 0xff, 0xad, 0xf0, 0x22, 0xe4, 0xcc, 
    0xf8, 0x75, 0xf0, 0x08, 0xef, 0x2f, 0xff, 0xee, 0x33, 0xfe, 0xec, 0x33, 0xfc, 0xee, 0x9d, 0xec, 
    0x98, 0x40, 0x05, 0xfc, 0xee, 0x9d, 0xfe, 0x0f, 0xd5, 0xf0, 0xe9, 0xe4, 0xce, 0xfd, 0x22, 0xed, 
    0xf8, 0xf5, 0xf0, 0xee, 0x84, 0x20, 0xd2, 0x1c, 0xfe, 0xad, 0xf0, 0x75, 0xf0, 0x08, 0xef, 0x2f, 
    0xff, 0xed, 0x33, 0xfd, 0x40, 0x07, 0x98, 0x50, 0x06, 0xd5, 0xf0, 0xf2, 0x22, 0xc3, 0x98, 0xfd, 
    0x0f, 0xd5, 0xf0, 0xea, 0x22, 0xc5, 0xf0, 0xf8, 0xa3, 0xe0, 0x28, 0xf0, 0xc5, 0xf0, 0xf8, 0xe5, 
    0x82, 0x15, 0x82, 0x70, 0x02, 0x15, 0x83, 0xe0, 0x38, 0xf0, 0x22, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 
    0xa3, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x22, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0xa3, 0xee, 0xf0, 0xa3, 
    0xef, 0xf0, 0x22, 0xa4, 0x25, 0x82, 0xf5, 0x82, 0xe5, 0xf0, 0x35, 0x83, 0xf5, 0x83, 0x22, 0xd0, 
    0x83, 0xd0, 0x82, 0xf8, 0xe4, 0x93, 0x70, 0x12, 0x74, 0x01, 0x93, 0x70, 0x0d, 0xa3, 0xa3, 0x93, 
    0xf8, 0x74, 0x01, 0x93, 0xf5, 0x82, 0x88, 0x83, 0xe4, 0x73, 0x74, 0x02, 0x93, 0x68, 0x60, 0xef, 
    0xa3, 0xa3, 0xa3, 0x80, 0xdf, 0x8a, 0x83, 0x89, 0x82, 0xe4, 0x73, 0xe5, 0x2e, 0x14, 0x60, 0x1d, 
    0x14, 0x60, 0x3d, 0x14, 0x60, 0x5d, 0x14, 0x70, 0x03, 0x02, 0x05, 0x18, 0x24, 0x04, 0x60, 0x03, 
    0x02, 0x05, 0x2e, 0x20, 0x0d, 0x03, 0x02, 0x05, 0x2e, 0x75, 0x2e, 0x01, 0x22, 0x90, 0x00, 0x0a, 
    0xe0, 0xff, 0x30, 0xe5, 0x03, 0x44, 0x20, 0xf0, 0xe5, 0x40, 0x45, 0x3f, 0x60, 0x03, 0x02, 0x05, 
    0x2e, 0x75, 0x2e, 0x02, 0x12, 0x1b, 0x12, 0x12, 0x1b, 0xce, 0xaf, 0x28, 0x12, 0x1b, 0x8f, 0x22, 
    0x90, 0x01, 0x03, 0xe0, 0xff, 0x30, 0xe7, 0x76, 0xef, 0x44, 0x80, 0x90, 0x01, 0x03, 0xf0, 0x12, 
    0x08, 0x55, 0x12, 0x1b, 0x55, 0x12, 0x1c, 0x01, 0x75, 0x2e, 0x03, 0xaf, 0x22, 0x7e, 0x00, 0x12, 
    0x1c, 0x45, 0x22, 0xe5, 0x40, 0x45, 0x3f, 0x70, 0x21, 0x12, 0x17, 0xd8, 0x12, 0x1b, 0xce, 0x12, 
    0x1b, 0x35, 0x12, 0x1c, 0x01, 0x12, 0x1c, 0x1f, 0x30, 0x0d, 0x0b, 0x75, 0x2e, 0x01, 0xaf, 0x32, 
    0x7e, 0x00, 0x12, 0x1c, 0x45, 0x22, 0xe4, 0xf5, 0x2e, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0xff, 0x30, 
    0xe5, 0x2c, 0x44, 0x20, 0xf0, 0x12, 0x17, 0xd8, 0x12, 0x1b, 0xce, 0x12, 0x1b, 0x35, 0x12, 0x1c, 
    0x01, 0x12, 0x1c, 0x1f, 0x75, 0x2e, 0x04, 0x22, 0xe5, 0x40, 0x45, 0x3f, 0x70, 0x10, 0x30, 0x0d, 
    0x0a, 0x75, 0x2e, 0x01, 0xaf, 0x32, 0xfe, 0x12, 0x1c, 0x45, 0x22, 0xe4, 0xf5, 0x2e, 0x22, 0x12, 
    0x09, 0x25, 0x40, 0x05, 0x12, 0x08, 0xed, 0x50, 0x44, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 
    0x7e, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x13, 0xc8, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 
    0x00, 0x0a, 0xf0, 0xe4, 0xff, 0xfe, 0x12, 0x0e, 0x29, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 
    0x54, 0x7f, 0xff, 0xf0, 0xe4, 0x90, 0x30, 0xe9, 0xf0, 0xef, 0x54, 0xfd, 0x90, 0x00, 0x0b, 0xf0, 
    0xe4, 0x90, 0x00, 0x04, 0xf0, 0xd2, 0x09, 0x12, 0x0e, 0x47, 0xe4, 0xf5, 0x2f, 0x12, 0x09, 0x3a, 
    0x50, 0x48, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x7e, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 
    0x13, 0xc8, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xe4, 0xff, 0xfe, 0x12, 
    0x0e, 0x29, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 0x54, 0xfd, 0xf0, 0xe4, 0x90, 0x00, 0x04, 
    0xf0, 0xff, 0x12, 0x0a, 0xd8, 0x50, 0x04, 0x75, 0x2f, 0x07, 0x22, 0x90, 0x01, 0x04, 0xe0, 0x54, 
    0x7f, 0xf0, 0xd2, 0x09, 0x12, 0x0e, 0x47, 0xe4, 0xf5, 0x2f, 0x22, 0xc2, 0xaf, 0xe4, 0xf5, 0x2f, 
    0xf5, 0x88, 0x75, 0xa8, 0x0f, 0x75, 0x89, 0x11, 0xf5, 0xb8, 0xf5, 0xe8, 0x75, 0x90, 0x0f, 0x75, 
    0x31, 0xff, 0x75, 0x2b, 0xff, 0x90, 0x22, 0x2e, 0xf0, 0xa3, 0xf0, 0x90, 0x22, 0x4e, 0xf0, 0xa3, 
    0xf0, 0xc2, 0x05, 0xc2, 0x08, 0xc2, 0x00, 0xc2, 0x07, 0xc2, 0x04, 0x90, 0x00, 0x0a, 0x74, 0xff, 
    0xf0, 0x90, 0x00, 0x0b, 0x74, 0x01, 0xf0, 0x90, 0x01, 0x03, 0x74, 0xff, 0xf0, 0xe4, 0x90, 0x01, 
    0x04, 0xf0, 0x90, 0x01, 0x05, 0x74, 0xff, 0xf0, 0xe4, 0x90, 0x01, 0x06, 0xf0, 0x90, 0x00, 0x04, 
    0xf0, 0x90, 0x30, 0xe8, 0x74, 0x10, 0xf0, 0x90, 0x01, 0x07, 0xf0, 0x90, 0x01, 0x08, 0x04, 0xf0, 
    0x90, 0x01, 0x09, 0x74, 0x48, 0xf0, 0x90, 0x01, 0x0a, 0x74, 0x7f, 0xf0, 0x90, 0x01, 0x02, 0x74, 
    0x1f, 0xf0, 0x90, 0x01, 0x00, 0x74, 0x14, 0xf0, 0x90, 0x01, 0x01, 0x74, 0x20, 0xf0, 0x90, 0x00, 
    0x00, 0xe0, 0x44, 0x80, 0xf0, 0x75, 0x49, 0x00, 0x75, 0x4a, 0x01, 0xc2, 0x01, 0xd2, 0xaf, 0x22, 
    0x12, 0x08, 0xed, 0x50, 0x2d, 0x12, 0x0a, 0x78, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0x7e, 
    0x30, 0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x7e, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x13, 0xc8, 0x90, 
    0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xd2, 0x09, 0x12, 0x0e, 0x47, 0xe4, 0xf5, 
    0x2f, 0x22, 0x12, 0x09, 0x4f, 0x50, 0x50, 0x12, 0x0a, 0x78, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 
    0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0x90, 0x01, 0x03, 0x74, 0x80, 0xf0, 0x90, 0x01, 0x04, 0xe0, 
    0x44, 0x80, 0xf0, 0x7f, 0x02, 0x12, 0x0a, 0xd8, 0x50, 0x04, 0x75, 0x2f, 0x05, 0x22, 0x7e, 0x30, 
    0x7f, 0xe0, 0x7c, 0x1c, 0x7d, 0x7e, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x13, 0xc8, 0x90, 0x00, 
    0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xd2, 0x09, 0x12, 0x0e, 0x47, 0x90, 0x01, 0x04, 
    0xe0, 0x54, 0x7f, 0xf0, 0xe4, 0xf5, 0x2f, 0x22, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x10, 0x12, 0x1c, 
    0x5c, 0x50, 0x26, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x10, 0xfd, 0x80, 0x03, 0x43, 0x10, 0x02, 
    0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x10, 0xf7, 0x80, 0x03, 0x43, 0x10, 0x08, 0x53, 0x10, 0xfe, 
    0x43, 0x10, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x10, 0xf0, 0x12, 0x1c, 0x51, 0x50, 0x48, 0x90, 0x01, 
    0x03, 0xe0, 0xf5, 0x10, 0x54, 0x1c, 0x60, 0x3e, 0xe5, 0x10, 0x54, 0xe3, 0xf0, 0xa3, 0xe0, 0xf5, 
    0x10, 0xf0, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x10, 0x02, 0x80, 0x03, 0x53, 0x10, 0xfd, 0xe5, 
    0x27, 0x30, 0xe7, 0x05, 0x43, 0x10, 0x08, 0x80, 0x03, 0x53, 0x10, 0xf7, 0x53, 0x10, 0xfe, 0x43, 
    0x10, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x10, 0xf0, 0xaf, 0x29, 0x7e, 0x00, 0x12, 0x1c, 0x70, 0xaf, 
    0x35, 0x7e, 0x00, 0x12, 0x1c, 0x77, 0x22, 0x12, 0x08, 0xca, 0x50, 0x72, 0x12, 0x10, 0xcd, 0x85, 
    0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xc3, 0x9f, 0xf5, 0x12, 0xec, 0x9e, 0xf5, 
    0x11, 0xd3, 0xe5, 0x12, 0x94, 0x00, 0xe5, 0x11, 0x64, 0x80, 0x94, 0x80, 0x40, 0x06, 0xae, 0x11, 
    0xaf, 0x12, 0x80, 0x04, 0x7e, 0x00, 0x7f, 0x00, 0x8e, 0x11, 0x8f, 0x12, 0xe5, 0x34, 0x24, 0x10, 
    0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xc3, 0x95, 0x12, 0xf5, 0x12, 0xe4, 0x95, 0x11, 
    0xf5, 0x11, 0xc3, 0x64, 0x80, 0x94, 0x80, 0x50, 0x05, 0xe4, 0xf5, 0x11, 0xf5, 0x12, 0xe5, 0x34, 
    0x24, 0x12, 0xff, 0xe4, 0x35, 0x33, 0xfe, 0xad, 0x12, 0x7b, 0x01, 0x12, 0x0d, 0xa0, 0x90, 0x01, 
    0x05, 0x74, 0x20, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x44, 0x20, 0xf0, 0x75, 0x2f, 0x03, 0x22, 0xc0, 
    0xe0, 0xc0, 0xf0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0xd0, 0x75, 0xd0, 0x08, 0xc2, 0xaf, 0x90, 0x22, 
    0x2e, 0xe0, 0xfe, 0xa3, 0xe0, 0x8e, 0x33, 0xf5, 0x34, 0xe5, 0x2f, 0x25, 0xe0, 0x24, 0xf1, 0xf5, 
    0x82, 0xe4, 0x34, 0x1b, 0xf5, 0x83, 0xe4, 0x93, 0xfe, 0x74, 0x01, 0x93, 0xca, 0xee, 0xca, 0xf9, 
    0x12, 0x04, 0x65, 0x12, 0x09, 0x17, 0x50, 0x02, 0xd2, 0x07, 0x12, 0x19, 0x8e, 0x12, 0x00, 0x1e, 
    0x12, 0x09, 0x02, 0x50, 0x05, 0xaf, 0x25, 0x12, 0x10, 0xe8, 0x30, 0x05, 0x1b, 0xe5, 0x2f, 0x70, 
    0x17, 0x20, 0x04, 0x14, 0x12, 0x13, 0x28, 0x92, 0x00, 0xc2, 0x05, 0xd2, 0x0b, 0xa2, 0x00, 0xe4, 
    0x33, 0xf5, 0x14, 0xaf, 0x23, 0x12, 0x10, 0xf1, 0xd2, 0xaf, 0xd0, 0xd0, 0xd0, 0x82, 0xd0, 0x83, 
    0xd0, 0xf0, 0xd0, 0xe0, 0x32, 0xe4, 0xff, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xef, 0x90, 0x1b, 0xba, 
    0x93, 0x44, 0x80, 0x90, 0x30, 0x8d, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 
    0x8c, 0xe0, 0xfe, 0x74, 0x36, 0x2f, 0xf8, 0xc6, 0xee, 0xc6, 0xa3, 0xe0, 0xfe, 0xef, 0x90, 0x1b, 
    0xba, 0x93, 0x44, 0x80, 0x6e, 0x60, 0x01, 0x1f, 0x0f, 0xef, 0xc3, 0x94, 0x09, 0x40, 0xc8, 0x22, 
    0x90, 0x30, 0xf0, 0xe0, 0xf5, 0x2a, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe4, 0x0e, 0x90, 0x30, 0xf2, 
    0xe0, 0x60, 0x08, 0x90, 0x00, 0x0a, 0x74, 0x10, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x30, 0xf0, 
    0xe0, 0xf5, 0x2a, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe4, 0x0e, 0x90, 0x30, 0xf2, 0xe0, 0x70, 0x08, 
    0x90, 0x00, 0x0a, 0x74, 0x10, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x01, 0x03, 0xe0, 0x30, 0xe7, 
    0x0c, 0x74, 0x80, 0xf0, 0x90, 0x01, 0x04, 0xe0, 0x54, 0x7f, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 
    0x00, 0x0a, 0xe0, 0x30, 0xe0, 0x05, 0x74, 0x01, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 
    0xe0, 0x30, 0xe1, 0x0c, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 0xf0, 0xd3, 0x22, 
    0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe2, 0x0c, 0x74, 0x04, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 
    0x54, 0xfb, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe5, 0x05, 0x74, 0x20, 
    0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe6, 0x0c, 0x74, 0x40, 0xf0, 0x90, 
    0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe7, 
    0x0c, 0x74, 0x80, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0x7f, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 
    0x01, 0x05, 0xe0, 0x30, 0xe5, 0x0c, 0x74, 0x20, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 
    0xd3, 0x22, 0xc3, 0x22, 0x90, 0x34, 0xcd, 0xe0, 0xf9, 0x20, 0xe3, 0xf8, 0xe5, 0x2b, 0xf4, 0x60, 
    0x66, 0x90, 0x34, 0xc0, 0x12, 0x04, 0x1b, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 
    0xe5, 0x2b, 0x12, 0x04, 0x33, 0xe5, 0x82, 0x24, 0x04, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 
    0x12, 0x04, 0x27, 0x90, 0x34, 0xc8, 0x12, 0x04, 0x1b, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 
    0xf0, 0x20, 0xe5, 0x2b, 0x12, 0x04, 0x33, 0xe5, 0x82, 0x24, 0x08, 0xf5, 0x82, 0xe4, 0x35, 0x83, 
    0xf5, 0x83, 0x12, 0x04, 0x27, 0x90, 0x34, 0xd0, 0x12, 0x04, 0x1b, 0x85, 0x34, 0x82, 0x85, 0x33, 
    0x83, 0x75, 0xf0, 0x20, 0xe5, 0x2b, 0x12, 0x04, 0x33, 0xe5, 0x82, 0x24, 0x0c, 0xf5, 0x82, 0xe4, 
    0x35, 0x83, 0xf5, 0x83, 0x12, 0x04, 0x27, 0xe5, 0x34, 0x24, 0xf0, 0xff, 0xe5, 0x33, 0x34, 0xde, 
    0xfe, 0xef, 0x78, 0x05, 0xce, 0xc3, 0x13, 0xce, 0x13, 0xd8, 0xf9, 0xf5, 0x2b, 0x85, 0x34, 0x82, 
    0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 0x12, 0x04, 0x33, 0xe5, 0x82, 0x24, 0x04, 0xf5, 0x82, 0xe4, 
    0x35, 0x83, 0xf5, 0x83, 0x12, 0x04, 0x1b, 0x90, 0x34, 0xc0, 0x12, 0x04, 0x27, 0x85, 0x34, 0x82, 
    0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 0xe5, 0x2b, 0x12, 0x04, 0x33, 0xe5, 0x82, 0x24, 0x08, 0xf5, 
    0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 0x12, 0x04, 0x1b, 0x90, 0x34, 0xc8, 0x12, 0x04, 0x27, 0x85, 
    0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 0xe5, 0x2b, 0x12, 0x04, 0x33, 0xe5, 0x82, 0x24, 
    0x0c, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 0x12, 0x04, 0x1b, 0x90, 0x34, 0xc4, 0x12, 0x04, 
    0x27, 0x90, 0x01, 0x01, 0xe0, 0x44, 0x40, 0xf0, 0x90, 0x01, 0x00, 0xe0, 0x44, 0x08, 0xf0, 0xe9, 
    0x44, 0x04, 0x90, 0x34, 0xcd, 0xf0, 0x90, 0x34, 0xcc, 0xe0, 0x44, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 
    0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x01, 0xf0, 0x22, 0x90, 0x34, 0xce, 0xe0, 0x44, 0x02, 0xf0, 0x90, 
    0x34, 0xcd, 0xe0, 0x54, 0xfe, 0xf0, 0x90, 0x34, 0xcd, 0xe0, 0x20, 0xe3, 0xf9, 0x90, 0x01, 0x11, 
    0xe0, 0x54, 0x22, 0xff, 0xbf, 0x22, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x50, 0xf0, 0x90, 0x01, 0x00, 
    0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x54, 0xbf, 0xf0, 0x22, 0x90, 0x01, 0x00, 0xe0, 
    0x44, 0x08, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x44, 0x40, 0xf0, 0x22, 0x90, 0x34, 0xce, 0xe0, 0x44, 
    0x02, 0xf0, 0x90, 0x34, 0xcd, 0xe0, 0x54, 0xfe, 0xf0, 0x90, 0x01, 0x00, 0xe0, 0x54, 0xf7, 0xf0, 
    0x90, 0x01, 0x01, 0xe0, 0x54, 0xbf, 0xf0, 0x22, 0xcd, 0xef, 0xcd, 0x90, 0x01, 0x02, 0xe0, 0x30, 
    0xe7, 0x02, 0xc3, 0x22, 0x7e, 0x2a, 0x7f, 0x00, 0x12, 0x0a, 0xfb, 0x90, 0x01, 0x04, 0xe0, 0x44, 
    0x80, 0xf0, 0x90, 0x01, 0x02, 0xe0, 0x44, 0x80, 0xf0, 0xd3, 0x22, 0x8e, 0x12, 0x8f, 0x13, 0x8d, 
    0x14, 0xe5, 0x14, 0xa2, 0xe1, 0x92, 0x09, 0xe5, 0x34, 0x24, 0x19, 0xf5, 0x82, 0xe4, 0x35, 0x33, 
    0xf5, 0x83, 0xe0, 0xfd, 0xe5, 0x34, 0x24, 0x1a, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 
    0xfb, 0xa2, 0x09, 0x92, 0x0a, 0x75, 0x19, 0x00, 0x75, 0x1a, 0x1a, 0x12, 0x11, 0x39, 0x30, 0x09, 
    0x04, 0x7f, 0xc8, 0x80, 0x02, 0x7f, 0xe8, 0xe5, 0x13, 0x24, 0x18, 0xf5, 0x82, 0xe4, 0x35, 0x12, 
    0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x31, 0x60, 0x04, 0x7f, 0x02, 0x80, 0x02, 0x7f, 0x01, 0xe5, 0x13, 
    0x24, 0x19, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x34, 0x24, 0x19, 0xf5, 
    0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x7d, 0x1a, 0x7c, 0x00, 0x12, 0x0c, 0xda, 0xe5, 
    0x13, 0x24, 0x1a, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x13, 0x24, 0x1b, 
    0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xee, 0xf0, 0xe5, 0x31, 0x60, 0x60, 0xe5, 0x13, 0x24, 
    0x1c, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0xe5, 0x34, 0x24, 0x12, 0xfd, 0xe4, 0x35, 0x33, 0xfc, 0x75, 
    0x1b, 0x11, 0x7b, 0x06, 0x12, 0x13, 0xc8, 0xe5, 0x13, 0x24, 0x22, 0xff, 0xe4, 0x35, 0x12, 0xfe, 
    0x7c, 0x30, 0x7d, 0x10, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x13, 0xc8, 0xe5, 0x13, 0x24, 0x28, 
    0xff, 0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x08, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x13, 
    0xc8, 0xe5, 0x34, 0x24, 0x18, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0xe5, 0x13, 
    0x24, 0x2d, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x80, 0x3f, 0xe5, 0x13, 0x24, 
    0x1c, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x10, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 
    0x13, 0xc8, 0xe5, 0x13, 0x24, 0x22, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x08, 0x75, 
    0x1b, 0x11, 0x7b, 0x06, 0x12, 0x13, 0xc8, 0xe5, 0x13, 0x24, 0x28, 0xff, 0xe4, 0x35, 0x12, 0xfe, 
    0x7c, 0x30, 0x7d, 0x10, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x13, 0xc8, 0xe5, 0x13, 0x24, 0x2e, 
    0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 0x13, 0x24, 0x2f, 0xf5, 0x82, 0xe4, 
    0x35, 0x12, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 0x34, 0x24, 0x11, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 
    0x83, 0xe0, 0xff, 0xc3, 0x13, 0xff, 0xe5, 0x13, 0x24, 0x30, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 
    0x83, 0xef, 0xf0, 0x30, 0x09, 0x41, 0xe5, 0x13, 0x24, 0x30, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 
    0x83, 0xe0, 0xff, 0xe5, 0x31, 0x60, 0x04, 0x7e, 0x00, 0x80, 0x02, 0x7e, 0x10, 0xef, 0x4e, 0xf0, 
    0xe5, 0x31, 0x60, 0x06, 0x7e, 0x00, 0x7f, 0x00, 0x80, 0x0f, 0xe5, 0x14, 0x30, 0xe0, 0x06, 0x7e, 
    0x00, 0x7f, 0xff, 0x80, 0x04, 0x7e, 0x00, 0x7f, 0x00, 0xe5, 0x13, 0x24, 0x31, 0xf5, 0x82, 0xe4, 
    0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x22, 0xe5, 0x13, 0x24, 0x30, 0xf5, 0x82, 0xe4, 0x35, 0x12, 
    0xf5, 0x83, 0xe0, 0x44, 0x40, 0xf0, 0xe5, 0x14, 0x30, 0xe0, 0x0f, 0xe5, 0x34, 0x24, 0x10, 0xf5, 
    0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x80, 0x02, 0x7f, 0x00, 0xe5, 0x13, 0x24, 0x31, 
    0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x22, 0x8f, 0x15, 0x8c, 0x16, 0x8d, 0x17, 
    0xe5, 0x15, 0xc3, 0x94, 0x04, 0x50, 0x56, 0xe5, 0x15, 0x94, 0x00, 0x40, 0x06, 0x7a, 0x00, 0x7b, 
    0x60, 0x80, 0x04, 0x7a, 0x00, 0x7b, 0xc0, 0xe5, 0x17, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 
    0xe5, 0x16, 0xc4, 0x54, 0xf0, 0x48, 0xfe, 0xe5, 0x15, 0x90, 0x1b, 0x75, 0x93, 0xfd, 0x7c, 0x00, 
    0x12, 0x03, 0xb0, 0xef, 0x2b, 0xfb, 0xee, 0x3a, 0xfa, 0xe5, 0x17, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 
    0x68, 0xff, 0xe5, 0x16, 0xc4, 0x54, 0xf0, 0x48, 0xfe, 0xe5, 0x15, 0x93, 0xfd, 0x7c, 0x00, 0x12, 
    0x03, 0xb0, 0xed, 0x4c, 0x60, 0x63, 0x0b, 0xbb, 0x00, 0x01, 0x0a, 0x80, 0x5c, 0x7a, 0x00, 0x7b, 
    0x1a, 0xe5, 0x17, 0xae, 0x16, 0x78, 0x02, 0xc3, 0x33, 0xce, 0x33, 0xce, 0xd8, 0xf9, 0x24, 0x0b, 
    0xff, 0xe4, 0x3e, 0xfe, 0xe5, 0x15, 0x90, 0x1b, 0x75, 0x93, 0xfd, 0x7c, 0x00, 0x12, 0x03, 0xb0, 
    0xef, 0x78, 0x02, 0xc3, 0x33, 0xce, 0x33, 0xce, 0xd8, 0xf9, 0x2b, 0xfb, 0xee, 0x3a, 0xfa, 0xe5, 
    0x17, 0xae, 0x16, 0x78, 0x02, 0xc3, 0x33, 0xce, 0x33, 0xce, 0xd8, 0xf9, 0x24, 0x0b, 0xff, 0xe4, 
    0x3e, 0xfe, 0xe5, 0x15, 0x90, 0x1b, 0x75, 0x93, 0xfd, 0x7c, 0x00, 0x12, 0x03, 0xb0, 0xed, 0x4c, 
    0x60, 0x07, 0x74, 0x04, 0x2b, 0xfb, 0xe4, 0x3a, 0xfa, 0xcf, 0xeb, 0xcf, 0xce, 0xea, 0xce, 0x22, 
    0x8e, 0x13, 0x8f, 0x14, 0x8d, 0x15, 0xeb, 0x60, 0x09, 0x14, 0x70, 0x1b, 0xaf, 0x15, 0x12, 0x0e, 
    0x0a, 0x22, 0x7e, 0x30, 0x7f, 0xe0, 0xac, 0x13, 0xad, 0x14, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 
    0x13, 0xc8, 0xaf, 0x15, 0x12, 0x0e, 0x0a, 0x22, 0x8e, 0x13, 0x8f, 0x14, 0x12, 0x10, 0xcd, 0xc3, 
    0xef, 0x95, 0x14, 0xff, 0xee, 0x95, 0x13, 0xcd, 0xef, 0xcd, 0xfc, 0xd3, 0xed, 0x94, 0x00, 0xec, 
    0x64, 0x80, 0x94, 0x80, 0x40, 0x05, 0xce, 0xec, 0xce, 0x80, 0x04, 0x7e, 0x00, 0x7f, 0x01, 0xcc, 
    0xee, 0xcc, 0xec, 0x90, 0x00, 0x05, 0xf0, 0x90, 0x00, 0x06, 0xef, 0xf0, 0x90, 0x00, 0x04, 0x74, 
    0x51, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x02, 0xf0, 0x22, 0xe4, 0x90, 0x00, 0x05, 0xf0, 0xef, 
    0x60, 0x02, 0x80, 0x02, 0x7f, 0x01, 0x90, 0x00, 0x06, 0xef, 0xf0, 0x90, 0x00, 0x04, 0x74, 0x51, 
    0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x02, 0xf0, 0x22, 0x90, 0x30, 0x3c, 0xef, 0xf0, 0xee, 0x44, 
    0x80, 0xa3, 0xf0, 0x22, 0xe5, 0x34, 0x24, 0x11, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 
    0x30, 0xe6, 0x02, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 
    0xf0, 0x30, 0x09, 0x32, 0xe5, 0x34, 0x45, 0x33, 0x70, 0x02, 0xc3, 0x22, 0x85, 0x34, 0x82, 0x85, 
    0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 
    0x83, 0xa3, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xd0, 0x82, 
    0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 0xe5, 0x34, 0x45, 0x33, 0x70, 0x02, 0xc3, 0x22, 0x12, 0x0e, 
    0xee, 0x50, 0xf3, 0x90, 0x00, 0x0a, 0xe0, 0x20, 0xe5, 0x03, 0x30, 0x07, 0x41, 0xe5, 0x34, 0x45, 
    0x33, 0x70, 0x02, 0xc3, 0x22, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 0xe0, 
    0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 
    0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 0xe5, 
    0x34, 0x45, 0x33, 0x70, 0x02, 0xc3, 0x22, 0x12, 0x0e, 0xee, 0x50, 0xf3, 0x80, 0xb5, 0x85, 0x34, 
    0x82, 0x85, 0x33, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x12, 0x0d, 0xc8, 0xd3, 0x22, 0xe5, 0x34, 
    0x24, 0x11, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0x30, 0xe7, 0x3b, 0xe5, 0x34, 0x24, 
    0x1c, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0x65, 0x2b, 0x70, 0x03, 0x75, 0x2b, 0xff, 
    0xe5, 0x34, 0x24, 0x1d, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x12, 0x10, 0xe8, 
    0x7e, 0x22, 0x7f, 0x10, 0x12, 0x1a, 0x3e, 0x8e, 0x33, 0x8f, 0x34, 0x90, 0x22, 0x2e, 0xe0, 0xfe, 
    0xa3, 0xe0, 0x8e, 0x33, 0xf5, 0x34, 0xc3, 0x22, 0xd2, 0x0a, 0xe5, 0x34, 0x24, 0x1b, 0xf5, 0x82, 
    0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0x70, 0x3a, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 
    0xc0, 0x82, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 0xe0, 
    0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xfe, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 
    0xa3, 0xef, 0xf0, 0xd3, 0x94, 0x00, 0xee, 0x64, 0x80, 0x94, 0x80, 0x50, 0x03, 0x02, 0x10, 0x28, 
    0x80, 0xc6, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xc3, 0xee, 0x64, 0x80, 
    0x94, 0x80, 0x50, 0x03, 0x02, 0x10, 0x28, 0x12, 0x10, 0xcd, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 
    0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0x9f, 0xee, 0x64, 0x80, 0xf8, 0xec, 0x64, 0x80, 0x98, 0x40, 
    0x20, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 0xa3, 0xa3, 0xe0, 0xfe, 0xa3, 
    0xe0, 0xff, 0xed, 0x9f, 0xff, 0xec, 0x9e, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 0xc2, 
    0x0a, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0xe5, 0x34, 0x24, 0x10, 
    0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xfd, 0xee, 0x94, 0x00, 
    0xfc, 0x12, 0x10, 0x85, 0x50, 0x2c, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 
    0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 0xe0, 0xfc, 0xa3, 
    0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 
    0xc2, 0x0a, 0x20, 0x0a, 0x03, 0x02, 0x0f, 0x38, 0x7e, 0x22, 0x7f, 0x10, 0x12, 0x1a, 0x3e, 0x8e, 
    0x33, 0x8f, 0x34, 0x8f, 0x82, 0x8e, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xd3, 0x94, 0x00, 0xee, 0x64, 
    0x80, 0x94, 0x80, 0x40, 0x0d, 0x7e, 0x22, 0x7f, 0x10, 0xad, 0x34, 0xac, 0x33, 0x12, 0x18, 0x42, 
    0x80, 0x1a, 0x12, 0x10, 0xd8, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xee, 0x8f, 0xf0, 0x12, 0x04, 
    0x05, 0x7e, 0x22, 0x7f, 0x30, 0xad, 0x34, 0xac, 0x33, 0x12, 0x18, 0x42, 0x90, 0x22, 0x2e, 0xe0, 
    0xfe, 0xa3, 0xe0, 0xff, 0x65, 0x34, 0x70, 0x03, 0xee, 0x65, 0x33, 0x70, 0x02, 0xd3, 0x22, 0x8e, 
    0x33, 0x8f, 0x34, 0xc3, 0x22, 0xc3, 0xef, 0x94, 0x04, 0xee, 0x64, 0x80, 0x94, 0x80, 0x40, 0x0c, 
    0xd3, 0xed, 0x94, 0x04, 0xec, 0x64, 0x80, 0x94, 0x80, 0x50, 0x01, 0x22, 0xc3, 0xef, 0x94, 0xfc, 
    0xee, 0x64, 0x80, 0x94, 0x7f, 0x40, 0x0c, 0xd3, 0xed, 0x94, 0xfc, 0xec, 0x64, 0x80, 0x94, 0x7f, 
    0x50, 0x01, 0x22, 0xd3, 0xef, 0x94, 0x04, 0xee, 0x64, 0x80, 0x94, 0x80, 0x50, 0x0d, 0xc3, 0xed, 
    0x94, 0xfc, 0xec, 0x64, 0x80, 0x94, 0x7f, 0x40, 0x02, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x30, 0x78, 
    0xe0, 0xfd, 0xa3, 0xe0, 0xfe, 0xed, 0xff, 0x22, 0x90, 0x30, 0x64, 0xe0, 0xfd, 0xa3, 0xe0, 0xfe, 
    0xed, 0x25, 0xe0, 0xff, 0xee, 0x33, 0xfe, 0x22, 0xc2, 0x0b, 0xe4, 0xf5, 0x14, 0x12, 0x10, 0xf1, 
    0x22, 0xe4, 0xfe, 0xef, 0xf4, 0x60, 0x41, 0x74, 0x04, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 
    0x83, 0xe0, 0xb4, 0xff, 0x23, 0x74, 0x04, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xef, 
    0xf0, 0x30, 0x0b, 0x0d, 0x74, 0x08, 0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe5, 0x14, 
    0xf0, 0x90, 0x00, 0x02, 0x74, 0x01, 0xf0, 0x22, 0xbe, 0x03, 0x0a, 0x90, 0x00, 0x02, 0x74, 0x01, 
    0xf0, 0xe4, 0xfe, 0x80, 0xc2, 0x0e, 0x80, 0xbf, 0x22, 0x8e, 0x15, 0x8f, 0x16, 0xca, 0xed, 0xca, 
    0xc9, 0xeb, 0xc9, 0x30, 0x0a, 0x04, 0x7f, 0x4a, 0x80, 0x02, 0x7f, 0x42, 0xcb, 0xef, 0xcb, 0xea, 
    0xc3, 0x94, 0x04, 0x50, 0x02, 0x80, 0x01, 0xc3, 0x40, 0x04, 0xcb, 0x44, 0x20, 0xcb, 0x85, 0x16, 
    0x82, 0x85, 0x15, 0x83, 0xeb, 0xf0, 0xa3, 0xe4, 0xf0, 0x85, 0x16, 0x82, 0x85, 0x15, 0x83, 0xa3, 
    0xa3, 0xe5, 0x1a, 0xf0, 0xe5, 0x19, 0x85, 0x16, 0x82, 0x85, 0x15, 0x83, 0xa3, 0xa3, 0xa3, 0xf0, 
    0xe5, 0x16, 0x24, 0x04, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0x74, 0x0f, 0xf0, 0xe5, 0x16, 
    0x24, 0x05, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 0x16, 0x24, 0x06, 0xf5, 
    0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 0x16, 0x24, 0x07, 0xf5, 0x82, 0xe4, 0x35, 
    0x15, 0xf5, 0x83, 0x74, 0x10, 0xf0, 0xea, 0x90, 0x1b, 0x83, 0x93, 0xfb, 0xea, 0x64, 0x01, 0x60, 
    0x08, 0xea, 0x64, 0x02, 0x60, 0x03, 0xba, 0x03, 0x04, 0xcb, 0x44, 0x08, 0xcb, 0xe5, 0x16, 0x24, 
    0x08, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xeb, 0xf0, 0xe5, 0x16, 0x24, 0x15, 0xf5, 0x82, 
    0xe4, 0x35, 0x15, 0xf5, 0x83, 0x74, 0xff, 0xf0, 0xe5, 0x16, 0x24, 0x16, 0xf5, 0x82, 0xe4, 0x35, 
    0x15, 0xf5, 0x83, 0xe9, 0xf0, 0xe5, 0x16, 0x24, 0x09, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 
    0x74, 0x04, 0xf0, 0x25, 0x1a, 0xf5, 0x1a, 0xe4, 0x35, 0x19, 0xf5, 0x19, 0xea, 0xc3, 0x94, 0x04, 
    0x40, 0x03, 0x02, 0x12, 0xf0, 0xea, 0x60, 0x03, 0xba, 0x01, 0x1f, 0xea, 0x24, 0x01, 0xfd, 0xe4, 
    0x33, 0xfc, 0xe5, 0x1a, 0xae, 0x19, 0x78, 0x03, 0xc3, 0x33, 0xce, 0x33, 0xce, 0xd8, 0xf9, 0xff, 
    0x12, 0x03, 0xb0, 0x8e, 0x19, 0x8f, 0x1a, 0x02, 0x12, 0xd0, 0xea, 0x24, 0xff, 0xfd, 0xe4, 0x34, 
    0xff, 0xfc, 0x7e, 0x00, 0x7f, 0x0b, 0x12, 0x03, 0x9e, 0xcc, 0xee, 0xcc, 0xcd, 0xef, 0xcd, 0xe5, 
    0x1a, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 0xe5, 0x19, 0xc4, 0x54, 0xf0, 0x48, 0xfe, 0x12, 
    0x03, 0xb0, 0x8c, 0x1b, 0x8d, 0x1c, 0xea, 0x24, 0xff, 0xfd, 0xe4, 0x34, 0xff, 0xfc, 0x7e, 0x00, 
    0x7f, 0x0b, 0x12, 0x03, 0x9e, 0xcc, 0xee, 0xcc, 0xcd, 0xef, 0xcd, 0xe5, 0x1a, 0xc4, 0xf8, 0x54, 
    0x0f, 0xc8, 0x68, 0xff, 0xe5, 0x19, 0xc4, 0x54, 0xf0, 0x48, 0xfe, 0x12, 0x03, 0xb0, 0x8e, 0x19, 
    0x8f, 0x1a, 0xe5, 0x1c, 0x45, 0x1b, 0x60, 0x08, 0x05, 0x1a, 0xe5, 0x1a, 0x70, 0x02, 0x05, 0x19, 
    0xea, 0x24, 0xff, 0xfd, 0xe4, 0x34, 0xff, 0xfc, 0x7e, 0x00, 0x7f, 0x03, 0x12, 0x03, 0x9e, 0xd3, 
    0xe5, 0x1c, 0x9f, 0xe5, 0x1b, 0x9e, 0x50, 0x18, 0xe5, 0x1c, 0x45, 0x1b, 0x60, 0x12, 0xba, 0x03, 
    0x0f, 0xe5, 0x16, 0x24, 0x09, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xe0, 0x44, 0x80, 0xf0, 
    0xe5, 0x16, 0x24, 0x0a, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xe5, 0x1a, 0xf0, 0xe5, 0x19, 
    0xff, 0xe5, 0x16, 0x24, 0x0b, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xef, 0xf0, 0x80, 0x2d, 
    0xe5, 0x1a, 0x54, 0x3f, 0xff, 0xe5, 0x16, 0x24, 0x0a, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 
    0xef, 0xf0, 0xe5, 0x1a, 0xae, 0x19, 0x78, 0x06, 0xce, 0xc3, 0x13, 0xce, 0x13, 0xd8, 0xf9, 0xff, 
    0xe5, 0x16, 0x24, 0x0b, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xef, 0xf0, 0x85, 0x16, 0x82, 
    0x85, 0x15, 0x83, 0xe0, 0x44, 0x01, 0xf0, 0x22, 0x90, 0x30, 0x30, 0x74, 0x02, 0xf0, 0x75, 0x11, 
    0x07, 0x75, 0x12, 0xd0, 0x90, 0x30, 0x30, 0xe0, 0x30, 0xe0, 0x0e, 0xe5, 0x12, 0x15, 0x12, 0x70, 
    0x02, 0x15, 0x11, 0xe5, 0x12, 0x45, 0x11, 0x70, 0xeb, 0xe5, 0x12, 0x45, 0x11, 0x70, 0x12, 0x12, 
    0x13, 0xae, 0x90, 0x21, 0x00, 0xe0, 0x60, 0x07, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x04, 0xf0, 0xc3, 
    0x22, 0xe4, 0x90, 0x34, 0x58, 0xf0, 0x90, 0x34, 0x32, 0x74, 0x1f, 0xf0, 0x75, 0x11, 0x07, 0x75, 
    0x12, 0xd0, 0x90, 0x34, 0x81, 0xe0, 0x64, 0x03, 0x60, 0x0e, 0xe5, 0x12, 0x15, 0x12, 0x70, 0x02, 
    0x15, 0x11, 0xe5, 0x12, 0x45, 0x11, 0x70, 0xea, 0xe5, 0x12, 0x45, 0x11, 0x70, 0x12, 0x12, 0x13, 
    0xae, 0x90, 0x21, 0x00, 0xe0, 0x60, 0x07, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x04, 0xf0, 0xc3, 0x22, 
    0x90, 0x34, 0x98, 0xe0, 0x44, 0x04, 0xf0, 0xe4, 0x90, 0x00, 0x01, 0xf0, 0xd3, 0x22, 0x90, 0x00, 
    0x01, 0x74, 0x0e, 0xf0, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfb, 0xf0, 0x90, 0x34, 0x58, 0x74, 0x01, 
    0xf0, 0x90, 0x30, 0x30, 0x74, 0x04, 0xf0, 0x22, 0x8e, 0x16, 0x8f, 0x17, 0x8c, 0x18, 0x8d, 0x19, 
    0xe4, 0xff, 0xef, 0xc3, 0x9b, 0x50, 0x53, 0xe5, 0x1b, 0x30, 0xe0, 0x12, 0xef, 0x7c, 0x00, 0x25, 
    0x19, 0xfd, 0xec, 0x35, 0x18, 0x8d, 0x82, 0xf5, 0x83, 0xe0, 0xf5, 0x1c, 0x80, 0x1f, 0xe5, 0x1b, 
    0x30, 0xe1, 0x13, 0xef, 0x7c, 0x00, 0x25, 0x19, 0xfd, 0xec, 0x35, 0x18, 0x8d, 0x82, 0xf5, 0x83, 
    0xe4, 0x93, 0xf5, 0x1c, 0x80, 0x07, 0xe5, 0x19, 0x2f, 0xf8, 0xe6, 0xf5, 0x1c, 0xe5, 0x1b, 0x30, 
    0xe4, 0x0f, 0xe5, 0x17, 0x2f, 0xf5, 0x82, 0xe4, 0x35, 0x16, 0xf5, 0x83, 0xe5, 0x1c, 0xf0, 0x80, 
    0x06, 0xe5, 0x17, 0x2f, 0xf8, 0xa6, 0x1c, 0x0f, 0x80, 0xa8, 0x22, 0x90, 0x21, 0x00, 0xe0, 0xc4, 
    0x33, 0x54, 0xe0, 0x24, 0x10, 0xf5, 0x82, 0xe4, 0x34, 0x21, 0xab, 0x82, 0xfa, 0x12, 0x10, 0xd8, 
    0x8b, 0x82, 0x8a, 0x83, 0xee, 0x8f, 0xf0, 0x12, 0x04, 0x05, 0x7e, 0x22, 0x7f, 0x30, 0xcd, 0xeb, 
    0xcd, 0xcc, 0xea, 0xcc, 0x12, 0x18, 0x42, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x10, 
    0xe8, 0x22, 0xe5, 0x30, 0x12, 0x04, 0x3f, 0x14, 0x83, 0x00, 0x14, 0xf1, 0x01, 0x15, 0x59, 0x02, 
    0x15, 0xed, 0x03, 0x16, 0x41, 0x04, 0x16, 0x88, 0x05, 0x16, 0xfb, 0x06, 0x17, 0x6a, 0x07, 0x00, 
    0x00, 0x17, 0xa2, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 
    0x20, 0xe5, 0x08, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 
    0x01, 0xf0, 0xe5, 0x26, 0x30, 0xe6, 0x0f, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 
    0x12, 0x43, 0x12, 0x02, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 
    0x53, 0x12, 0xfd, 0xe5, 0x26, 0x30, 0xe7, 0x0f, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 
    0x80, 0x12, 0x43, 0x12, 0x08, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 
    0x03, 0x53, 0x12, 0xf7, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 
    0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 0x20, 0xe5, 
    0x08, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 
    0xe5, 0x26, 0x54, 0xc0, 0x60, 0x1c, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x03, 
    0x43, 0x12, 0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x1f, 0x43, 0x12, 0x08, 
    0x80, 0x1a, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 0x53, 0x12, 0xfd, 0xe5, 
    0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 0x03, 0x53, 0x12, 0xf7, 0x43, 0x12, 0x01, 0x43, 
    0x12, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 
    0x3a, 0xe0, 0xf5, 0x12, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0xe5, 0x26, 0x30, 0xe5, 0x5c, 0x90, 
    0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x26, 0x54, 0xc0, 0x60, 0x1c, 0xe5, 0x27, 0x30, 0xe6, 
    0x05, 0x53, 0x12, 0xfd, 0x80, 0x03, 0x43, 0x12, 0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 
    0xf7, 0x80, 0x30, 0x43, 0x12, 0x08, 0x80, 0x2b, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 
    0x80, 0x03, 0x53, 0x12, 0xfd, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 0x03, 0x53, 
    0x12, 0xf7, 0xe5, 0x27, 0xf4, 0x54, 0x1f, 0xff, 0x90, 0x30, 0x34, 0xe0, 0x54, 0xe0, 0x4f, 0xf0, 
    0xe4, 0xf5, 0x2c, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x80, 0x15, 0x90, 0x34, 0x98, 0xe0, 0x54, 
    0xfe, 0xf0, 0xe5, 0x27, 0xf4, 0x54, 0x1f, 0xff, 0x90, 0x30, 0x34, 0xe0, 0x54, 0xe0, 0x4f, 0xf0, 
    0x90, 0x30, 0x35, 0xe0, 0xf5, 0x12, 0x53, 0x12, 0xe0, 0xe5, 0x12, 0xf0, 0x22, 0xc2, 0x01, 0x12, 
    0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 0x30, 0xe5, 0x3c, 0x90, 0x34, 0x98, 
    0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x03, 0x43, 0x12, 
    0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x03, 0x43, 0x12, 0x08, 0xe5, 0x26, 
    0x54, 0xc0, 0x60, 0x08, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x80, 0x06, 0x53, 0x12, 0xfe, 0x43, 
    0x12, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 
    0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x27, 0x30, 0xe6, 
    0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 0x53, 0x12, 0xfd, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 
    0x08, 0x80, 0x03, 0x53, 0x12, 0xf7, 0xe5, 0x26, 0x54, 0xc0, 0x60, 0x08, 0x53, 0x12, 0xfe, 0x53, 
    0x12, 0xfb, 0x80, 0x06, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 
    0xf0, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0x20, 0x02, 0x13, 0x12, 0x1c, 0x39, 0xaf, 0x29, 
    0x7e, 0x00, 0x12, 0x1c, 0x70, 0xaf, 0x35, 0x7e, 0x00, 0x12, 0x1c, 0x77, 0xd2, 0x02, 0x90, 0x30, 
    0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 0x20, 0xe5, 0x0d, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x34, 
    0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x26, 0x54, 
    0xc0, 0x60, 0x2c, 0xc2, 0x01, 0x12, 0x00, 0x06, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 
    0x80, 0x03, 0x43, 0x12, 0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x03, 0x43, 
    0x12, 0x08, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0x30, 
    0x01, 0x03, 0x02, 0x17, 0xa2, 0x12, 0x18, 0xf4, 0xd2, 0x01, 0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 
    0xe5, 0x26, 0x20, 0xe5, 0x09, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x80, 0x55, 0x90, 0x34, 
    0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x26, 0x30, 0xe6, 0x0f, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 
    0x12, 0xfd, 0x80, 0x12, 0x43, 0x12, 0x02, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 
    0x02, 0x80, 0x03, 0x53, 0x12, 0xfd, 0xe5, 0x26, 0x30, 0xe7, 0x0f, 0xe5, 0x27, 0x30, 0xe7, 0x05, 
    0x53, 0x12, 0xf7, 0x80, 0x12, 0x43, 0x12, 0x08, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 
    0x12, 0x08, 0x80, 0x03, 0x53, 0x12, 0xf7, 0x43, 0x12, 0x01, 0x53, 0x12, 0xfb, 0x90, 0x30, 0x3a, 
    0xe5, 0x12, 0xf0, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0x22, 0xe5, 0x26, 0x30, 0xe5, 0x2c, 0x20, 
    0x03, 0x21, 0xd2, 0x03, 0x12, 0x1c, 0x39, 0x75, 0x35, 0x06, 0x75, 0x29, 0x09, 0xaf, 0x29, 0x7e, 
    0x00, 0x12, 0x1c, 0x70, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0x53, 0x12, 0xfe, 0x43, 0x12, 0x04, 
    0xe5, 0x12, 0xf0, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x54, 
    0xfe, 0xf0, 0x22, 0xe4, 0xff, 0xe5, 0x30, 0x24, 0xfe, 0x70, 0x2c, 0xe4, 0xfe, 0xee, 0xc3, 0x95, 
    0x2c, 0x50, 0x12, 0x74, 0x01, 0xc8, 0xee, 0xc8, 0x08, 0x80, 0x02, 0xc3, 0x33, 0xd8, 0xfc, 0xcf, 
    0x4f, 0xcf, 0x0e, 0x80, 0xe8, 0x90, 0x30, 0x34, 0xe0, 0x54, 0xe0, 0xfe, 0xe5, 0x27, 0x54, 0x1f, 
    0x6f, 0xf4, 0xce, 0x4e, 0xce, 0xee, 0xf0, 0x22, 0x90, 0x29, 0xa0, 0xe0, 0x70, 0x63, 0x90, 0x30, 
    0x8c, 0xe4, 0xf0, 0xa3, 0x74, 0xc2, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 
    0x8c, 0xe0, 0xff, 0x90, 0x29, 0xa0, 0xf0, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xa3, 0x74, 0xc5, 0xf0, 
    0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 0xff, 0x90, 0x29, 0xa1, 0xf0, 
    0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xa3, 0x74, 0xc4, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 
    0x90, 0x30, 0x8c, 0xe0, 0xff, 0x90, 0x29, 0xa2, 0xf0, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xa3, 0x74, 
    0xc3, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 0x90, 0x29, 0xa3, 
    0xf0, 0x22, 0x8c, 0x13, 0x8d, 0x14, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 
    0xfc, 0xa3, 0xe0, 0x4c, 0x60, 0x41, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 
    0xfc, 0xa3, 0xe0, 0xf5, 0x82, 0x8c, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x85, 0x14, 0x82, 0x85, 
    0x13, 0x83, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xd3, 0xed, 0x9b, 0xea, 0x64, 0x80, 0xf8, 0xec, 0x64, 
    0x80, 0x98, 0x40, 0x13, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfc, 0xa3, 
    0xe0, 0xce, 0xec, 0xce, 0xff, 0x80, 0xaf, 0xad, 0x14, 0xac, 0x13, 0x12, 0x1a, 0x71, 0x22, 0x12, 
    0x08, 0xca, 0x50, 0x4f, 0xe5, 0x34, 0x24, 0x12, 0xff, 0xe4, 0x35, 0x33, 0xfe, 0xe5, 0x34, 0x24, 
    0x10, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xfd, 0xe4, 0xfb, 0x12, 0x0d, 0xa0, 0xe5, 
    0x34, 0x24, 0x10, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x7e, 0x00, 0x12, 0x0e, 
    0x29, 0x90, 0x00, 0x0a, 0x74, 0x40, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x40, 0xff, 0xf0, 0x90, 
    0x00, 0x0a, 0x74, 0x80, 0xf0, 0x4f, 0x90, 0x00, 0x0b, 0xf0, 0x90, 0x30, 0xe9, 0x74, 0x01, 0xf0, 
    0x75, 0x2f, 0x06, 0x22, 0x90, 0x30, 0x3a, 0xe0, 0xff, 0xe5, 0x27, 0x30, 0xe6, 0x12, 0x30, 0x0c, 
    0x06, 0xef, 0x54, 0xf5, 0xfe, 0x80, 0x04, 0xef, 0x44, 0x0a, 0xfe, 0xcf, 0xee, 0xcf, 0x80, 0x10, 
    0x30, 0x0c, 0x06, 0xef, 0x44, 0x0a, 0xfe, 0x80, 0x04, 0xef, 0x54, 0xf5, 0xfe, 0xcf, 0xee, 0xcf, 
    0xcf, 0x54, 0xfe, 0xcf, 0xcf, 0x44, 0x04, 0xcf, 0x90, 0x30, 0x3a, 0xef, 0xf0, 0x30, 0x0c, 0x09, 
    0x7f, 0x08, 0x7e, 0x00, 0x12, 0x1c, 0x70, 0x80, 0x07, 0x7f, 0x22, 0x7e, 0x01, 0x12, 0x1c, 0x70, 
    0xb2, 0x0c, 0x22, 0xc0, 0xe0, 0xc0, 0xf0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0xd0, 0x75, 0xd0, 0x08, 
    0xc2, 0xaf, 0xc2, 0x8c, 0xc2, 0x8d, 0xd3, 0xe5, 0x4a, 0x94, 0x00, 0xe5, 0x49, 0x94, 0x00, 0x40, 
    0x08, 0xe5, 0x4a, 0x15, 0x4a, 0x70, 0x02, 0x15, 0x49, 0xd3, 0xe5, 0x4c, 0x94, 0x00, 0xe5, 0x4b, 
    0x94, 0x00, 0x40, 0x08, 0xe5, 0x4c, 0x15, 0x4c, 0x70, 0x02, 0x15, 0x4b, 0x12, 0x00, 0x0e, 0xd2, 
    0x8c, 0xd2, 0xaf, 0xd0, 0xd0, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xf0, 0xd0, 0xe0, 0x32, 0x30, 0x07, 
    0x3c, 0xe5, 0x2f, 0x70, 0x38, 0xc2, 0x07, 0x90, 0x22, 0x2e, 0xe0, 0xfe, 0xa3, 0xe0, 0x8e, 0x11, 
    0xf5, 0x12, 0x90, 0x22, 0x4e, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x90, 0x22, 0x2e, 0xee, 0xf0, 0xa3, 
    0xef, 0xf0, 0x90, 0x22, 0x4e, 0xe5, 0x11, 0xf0, 0xa3, 0xe5, 0x12, 0xf0, 0x8e, 0x33, 0x8f, 0x34, 
    0x30, 0x08, 0x05, 0x12, 0x14, 0x2b, 0xc2, 0x08, 0xc2, 0x09, 0x12, 0x0e, 0x47, 0x22, 0x7f, 0x80, 
    0x7e, 0x29, 0xe4, 0xfd, 0xfc, 0x8f, 0x82, 0x8e, 0x83, 0xe0, 0xfb, 0x74, 0x45, 0x2d, 0xf8, 0xc6, 
    0xeb, 0xc6, 0x74, 0x04, 0x2f, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfb, 0x74, 0x41, 0x2d, 
    0xf8, 0xc6, 0xeb, 0xc6, 0x74, 0x08, 0x2f, 0xff, 0xe4, 0x3e, 0xfe, 0x0d, 0xbd, 0x00, 0x01, 0x0c, 
    0xed, 0x64, 0x04, 0x4c, 0x70, 0xcf, 0x22, 0x90, 0x00, 0x00, 0x74, 0x0e, 0xf0, 0x00, 0x00, 0x00, 
    0xe4, 0xf0, 0x12, 0x05, 0xcb, 0x12, 0x1c, 0x84, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 
    0x30, 0xb4, 0x05, 0x0a, 0x12, 0x1c, 0x51, 0x50, 0x0d, 0x12, 0x18, 0xf4, 0x80, 0x08, 0xe5, 0x30, 
    0xb4, 0x07, 0x03, 0x12, 0x06, 0xe8, 0x12, 0x04, 0x6b, 0x80, 0xe4, 0x80, 0xfe, 0x22, 0xef, 0x24, 
    0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xfb, 0xca, 0xec, 0xca, 0x24, 
    0x1e, 0xf5, 0x82, 0xe4, 0x3c, 0xf5, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xef, 0x24, 0x1e, 0xf5, 
    0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0xce, 0xea, 0xce, 0xcf, 0xeb, 0xcf, 
    0x22, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xed, 
    0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3c, 0xf5, 0x83, 0xea, 0xf0, 0xa3, 0xeb, 0xf0, 0xef, 0x24, 0x1e, 
    0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0x22, 0xc0, 0xe0, 0xc0, 0xd0, 
    0xc2, 0xaf, 0xc2, 0x8e, 0xc2, 0x8f, 0xd3, 0xe5, 0x40, 0x94, 0x00, 0xe5, 0x3f, 0x94, 0x00, 0x40, 
    0x0d, 0xe5, 0x40, 0x15, 0x40, 0x70, 0x02, 0x15, 0x3f, 0x12, 0x1c, 0x67, 0xd2, 0x8e, 0xd2, 0xaf, 
    0xd0, 0xd0, 0xd0, 0xe0, 0x32, 0x12, 0x08, 0xca, 0x50, 0x22, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1c, 
    0x7d, 0x7e, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x13, 0xc8, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 
    0x90, 0x00, 0x0a, 0xf0, 0xd2, 0x09, 0x12, 0x0e, 0x47, 0xe4, 0xf5, 0x2f, 0x22, 0x12, 0x19, 0xce, 
    0x90, 0x21, 0x01, 0xe0, 0xf5, 0x28, 0x74, 0x41, 0x25, 0x28, 0xf8, 0xe6, 0xf5, 0x32, 0x74, 0x45, 
    0x25, 0x28, 0xf8, 0xe6, 0xf5, 0x22, 0x90, 0x21, 0x00, 0xe0, 0x60, 0x03, 0xd2, 0x0d, 0x22, 0xc2, 
    0x0d, 0x22, 0x90, 0x34, 0x30, 0xe4, 0xf0, 0xa3, 0xf0, 0xa3, 0x74, 0x1f, 0xf0, 0xa3, 0xe4, 0xf0, 
    0x90, 0x01, 0x10, 0xe0, 0x20, 0xe1, 0x03, 0x00, 0x80, 0xf6, 0x90, 0x01, 0x12, 0xe0, 0x20, 0xe1, 
    0x03, 0x00, 0x80, 0xf6, 0x22, 0xe4, 0xff, 0x74, 0x36, 0x2f, 0xf8, 0xe6, 0x90, 0x30, 0x8c, 0xf0, 
    0xef, 0x90, 0x1b, 0xba, 0x93, 0x90, 0x30, 0x8d, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 
    0x0f, 0xbf, 0x09, 0xe3, 0x22, 0xe4, 0xff, 0xef, 0x90, 0x1b, 0xc4, 0x93, 0x90, 0x30, 0x8c, 0xf0, 
    0xef, 0x90, 0x1b, 0xba, 0x93, 0x90, 0x30, 0x8d, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 
    0x0f, 0xbf, 0x09, 0xe3, 0x22, 0x02, 0x04, 0x0b, 0x16, 0x0c, 0x12, 0x18, 0x24, 0x30, 0x48, 0x60, 
    0x6c, 0x90, 0xc8, 0x00, 0x01, 0x02, 0x03, 0x0b, 0x0f, 0x0a, 0x0e, 0x09, 0x0d, 0x08, 0x0c, 0xef, 
    0xc4, 0x33, 0x33, 0x54, 0xc0, 0xff, 0x90, 0x01, 0x00, 0xe0, 0x54, 0x3f, 0x4f, 0xf0, 0x90, 0x01, 
    0x02, 0xe0, 0x44, 0x80, 0xf0, 0x22, 0xe4, 0xf5, 0x31, 0x90, 0x00, 0x0a, 0x74, 0xff, 0xf0, 0x90, 
    0x22, 0x2e, 0x74, 0x21, 0xf0, 0xa3, 0x74, 0x10, 0xf0, 0x22, 0x52, 0x53, 0x54, 0x12, 0x15, 0x16, 
    0x10, 0x11, 0x40, 0x00, 0x20, 0x00, 0x40, 0xff, 0x3f, 0x3f, 0xbd, 0x28, 0x21, 0x00, 0x90, 0x30, 
    0x40, 0x74, 0x32, 0xf0, 0xa3, 0x74, 0xb0, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x22, 
    0x75, 0x31, 0x01, 0x90, 0x00, 0x0a, 0x74, 0xff, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x20, 0xf0, 
    0x22, 0x02, 0x1f, 0x07, 0x67, 0x18, 0x9f, 0x06, 0x60, 0x00, 0x09, 0x1a, 0xc5, 0x05, 0x2f, 0x1c, 
    0x11, 0x90, 0x30, 0x40, 0x74, 0x32, 0xf0, 0xa3, 0x74, 0xb0, 0xf0, 0xa3, 0xe4, 0xf0, 0xa3, 0xf0, 
    0x22, 0x12, 0x08, 0xca, 0x50, 0x08, 0xd2, 0x09, 0x12, 0x0e, 0x47, 0xe4, 0xf5, 0x2f, 0x22, 0x90, 
    0x34, 0x30, 0x74, 0x1f, 0xf0, 0xa3, 0xe4, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0, 0x22, 0x78, 0x7f, 0xe4, 
    0xf6, 0xd8, 0xfd, 0x75, 0x81, 0x4c, 0x02, 0x1a, 0x07, 0xc2, 0xaf, 0xc2, 0x8c, 0xc2, 0x8d, 0x12, 
    0x00, 0x0e, 0xd2, 0xaf, 0x22, 0xc2, 0x8e, 0x8e, 0x3f, 0x8f, 0x40, 0x12, 0x1c, 0x67, 0xd2, 0x8e, 
    0x22, 0xe5, 0x4a, 0x45, 0x49, 0x70, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x22, 0xe5, 0x4c, 0x45, 0x4b, 
    0x70, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x22, 0xc2, 0x8f, 0x75, 0x8d, 0xf5, 0x75, 0x8b, 0x41, 0x22, 
    0x8e, 0x49, 0x8f, 0x4a, 0xd2, 0x8c, 0x22, 0x8e, 0x4b, 0x8f, 0x4c, 0xd2, 0x8c, 0x22, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0xc2, 0x0d, 0xe4, 0xf5, 0x2e, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};
#define	RT2561S_FIRMIM_LEN		(sizeof (RT2561S_FirmwareImage) / sizeof(UCHAR))

static UCHAR RT2661_FirmwareImage[] = {
    0x02, 0x12, 0xde, 0x02, 0x14, 0xf0, 0xc2, 0x8c, 0x22, 0x22, 0x00, 0x02, 0x16, 0xe5, 0xc2, 0xaf, 
    0xc2, 0x8d, 0x75, 0x8c, 0x94, 0x75, 0x8a, 0x93, 0xd2, 0xaf, 0x22, 0x02, 0x19, 0x89, 0xe5, 0x30, 
    0x12, 0x0f, 0xe5, 0x00, 0x3f, 0x00, 0x00, 0xad, 0x01, 0x01, 0x15, 0x02, 0x01, 0xa9, 0x03, 0x01, 
    0xfd, 0x04, 0x02, 0x44, 0x05, 0x02, 0xb7, 0x06, 0x03, 0x26, 0x07, 0x00, 0x00, 0x03, 0x5e, 0xc2, 
    0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 0x20, 0xe5, 0x08, 0x90, 
    0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x26, 
    0x30, 0xe6, 0x0f, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x12, 0x43, 0x12, 0x02, 
    0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 0x53, 0x12, 0xfd, 0xe5, 
    0x26, 0x30, 0xe7, 0x0f, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x12, 0x43, 0x12, 
    0x08, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 0x03, 0x53, 0x12, 0xf7, 
    0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0xc2, 0x01, 0x12, 
    0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 0x20, 0xe5, 0x08, 0x90, 0x34, 0x98, 
    0xe0, 0x54, 0xfe, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x26, 0x54, 0xc0, 
    0x60, 0x1c, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x03, 0x43, 0x12, 0x02, 0xe5, 
    0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x1f, 0x43, 0x12, 0x08, 0x80, 0x1a, 0xe5, 0x27, 
    0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 0x53, 0x12, 0xfd, 0xe5, 0x27, 0x30, 0xe7, 0x05, 
    0x43, 0x12, 0x08, 0x80, 0x03, 0x53, 0x12, 0xf7, 0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x90, 0x30, 
    0x3a, 0xe5, 0x12, 0xf0, 0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 
    0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0xe5, 0x26, 0x30, 0xe5, 0x5c, 0x90, 0x34, 0x98, 0xe0, 0x44, 
    0x01, 0xf0, 0xe5, 0x26, 0x54, 0xc0, 0x60, 0x1c, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 
    0x80, 0x03, 0x43, 0x12, 0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x30, 0x43, 
    0x12, 0x08, 0x80, 0x2b, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 0x53, 0x12, 
    0xfd, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 0x03, 0x53, 0x12, 0xf7, 0xe5, 0x27, 
    0xf4, 0x54, 0x1f, 0xff, 0x90, 0x30, 0x34, 0xe0, 0x54, 0xe0, 0x4f, 0xf0, 0xe4, 0xf5, 0x2c, 0x90, 
    0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x80, 0x15, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0xe5, 0x27, 
    0xf4, 0x54, 0x1f, 0xff, 0x90, 0x30, 0x34, 0xe0, 0x54, 0xe0, 0x4f, 0xf0, 0x90, 0x30, 0x35, 0xe0, 
    0xf5, 0x12, 0x53, 0x12, 0xe0, 0xe5, 0x12, 0xf0, 0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x30, 
    0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x26, 0x30, 0xe5, 0x3c, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 
    0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x03, 0x43, 0x12, 0x02, 0xe5, 0x27, 0x30, 
    0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x03, 0x43, 0x12, 0x08, 0xe5, 0x26, 0x54, 0xc0, 0x60, 0x08, 
    0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x80, 0x06, 0x53, 0x12, 0xfe, 0x43, 0x12, 0x04, 0x90, 0x30, 
    0x3a, 0xe5, 0x12, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x22, 0xc2, 0x01, 0x12, 
    0x00, 0x06, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 
    0x80, 0x03, 0x53, 0x12, 0xfd, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 0x03, 0x53, 
    0x12, 0xf7, 0xe5, 0x26, 0x54, 0xc0, 0x60, 0x08, 0x53, 0x12, 0xfe, 0x53, 0x12, 0xfb, 0x80, 0x06, 
    0x43, 0x12, 0x01, 0x43, 0x12, 0x04, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0x90, 0x30, 0x3a, 
    0xe5, 0x12, 0xf0, 0x22, 0x20, 0x02, 0x13, 0x12, 0x1c, 0x9c, 0xaf, 0x29, 0x7e, 0x00, 0x12, 0x1c, 
    0xf2, 0xaf, 0x35, 0x7e, 0x00, 0x12, 0x1c, 0xf9, 0xd2, 0x02, 0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 
    0xe5, 0x26, 0x20, 0xe5, 0x0d, 0xc2, 0x01, 0x12, 0x00, 0x06, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 
    0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x26, 0x54, 0xc0, 0x60, 0x2c, 0xc2, 
    0x01, 0x12, 0x00, 0x06, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x03, 0x43, 0x12, 
    0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 0x03, 0x43, 0x12, 0x08, 0x43, 0x12, 
    0x01, 0x43, 0x12, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x22, 0x30, 0x01, 0x03, 0x02, 0x03, 
    0x5e, 0x12, 0x09, 0x81, 0xd2, 0x01, 0x22, 0xc2, 0x01, 0x12, 0x00, 0x06, 0xe5, 0x26, 0x20, 0xe5, 
    0x09, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x80, 0x55, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 
    0xf0, 0xe5, 0x26, 0x30, 0xe6, 0x0f, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x53, 0x12, 0xfd, 0x80, 0x12, 
    0x43, 0x12, 0x02, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 0x12, 0x02, 0x80, 0x03, 0x53, 
    0x12, 0xfd, 0xe5, 0x26, 0x30, 0xe7, 0x0f, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x12, 0xf7, 0x80, 
    0x12, 0x43, 0x12, 0x08, 0x80, 0x0d, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x12, 0x08, 0x80, 0x03, 
    0x53, 0x12, 0xf7, 0x43, 0x12, 0x01, 0x53, 0x12, 0xfb, 0x90, 0x30, 0x3a, 0xe5, 0x12, 0xf0, 0x90, 
    0x30, 0x3a, 0xe0, 0xf5, 0x12, 0x22, 0xe5, 0x26, 0x30, 0xe5, 0x2c, 0x20, 0x03, 0x21, 0xd2, 0x03, 
    0x12, 0x1c, 0x9c, 0x75, 0x35, 0x06, 0x75, 0x29, 0x09, 0xaf, 0x29, 0x7e, 0x00, 0x12, 0x1c, 0xf2, 
    0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x12, 0x53, 0x12, 0xfe, 0x43, 0x12, 0x04, 0xe5, 0x12, 0xf0, 0x90, 
    0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfe, 0xf0, 0x22, 0x12, 
    0x1c, 0x72, 0x40, 0x03, 0x02, 0x05, 0x5f, 0x90, 0x21, 0x02, 0xe0, 0xf5, 0x2d, 0x90, 0x00, 0x03, 
    0xe0, 0x12, 0x0f, 0xe5, 0x03, 0xf1, 0x00, 0x04, 0x0f, 0x01, 0x03, 0x9f, 0x10, 0x03, 0xb0, 0x11, 
    0x04, 0x33, 0x20, 0x04, 0x8e, 0x21, 0x04, 0xb1, 0x22, 0x04, 0xc5, 0x30, 0x04, 0xd0, 0x31, 0x05, 
    0x16, 0x50, 0x04, 0xe0, 0x51, 0x05, 0x33, 0x52, 0x05, 0x47, 0x60, 0x00, 0x00, 0x05, 0x55, 0x90, 
    0x00, 0x0a, 0xe0, 0x20, 0xe5, 0x03, 0x30, 0x07, 0x03, 0xd2, 0x08, 0x22, 0x12, 0x18, 0xb6, 0x22, 
    0x90, 0x21, 0x00, 0xe0, 0xf5, 0x11, 0xe5, 0x11, 0xc4, 0x33, 0x54, 0xe0, 0x24, 0x21, 0xf5, 0x82, 
    0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe0, 0x44, 0x80, 0xf0, 0xe5, 0x11, 0xc4, 0x33, 0x54, 0xe0, 0x24, 
    0x2c, 0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe5, 0x11, 0xf0, 0xc4, 0x33, 0x54, 0xe0, 0x24, 
    0x2d, 0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe5, 0x2d, 0xf0, 0xe4, 0x90, 0x21, 0x03, 0xf0, 
    0x22, 0x12, 0x08, 0xc7, 0x90, 0x21, 0x00, 0xe0, 0xf5, 0x31, 0x60, 0x05, 0x12, 0x09, 0x5c, 0x80, 
    0x03, 0x12, 0x09, 0x6d, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0xe0, 0x22, 0x75, 
    0x31, 0xff, 0x90, 0x01, 0x00, 0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x54, 0xfe, 0xf0, 
    0x54, 0x3e, 0xf0, 0xe4, 0x90, 0x00, 0x0b, 0xf0, 0xf0, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 
    0x1c, 0xe0, 0x22, 0x7e, 0x2b, 0x7f, 0x80, 0x7d, 0x03, 0x12, 0x0a, 0x4f, 0x90, 0x34, 0xcd, 0xe0, 
    0x20, 0xe3, 0xf9, 0x90, 0x21, 0x14, 0x12, 0x0f, 0xc1, 0x90, 0x34, 0xc0, 0x12, 0x0f, 0xcd, 0x90, 
    0x21, 0x18, 0x12, 0x0f, 0xc1, 0x90, 0x34, 0xc8, 0x12, 0x0f, 0xcd, 0x90, 0x21, 0x1c, 0x12, 0x0f, 
    0xc1, 0x90, 0x34, 0xc4, 0x12, 0x0f, 0xcd, 0x90, 0x34, 0xcc, 0x74, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 
    0x04, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x44, 0x01, 0xf0, 0x44, 0x40, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 
    0x44, 0x10, 0xf0, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0xe0, 0x22, 0x90, 0x01, 
    0x00, 0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x54, 0xfe, 0xf0, 0x54, 0xbf, 0xf0, 0x90, 
    0x00, 0x0b, 0xe0, 0x54, 0xef, 0xf0, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0xe0, 
    0x22, 0x7e, 0x2b, 0x7f, 0x80, 0x7d, 0x03, 0x12, 0x0a, 0x4f, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 
    0x2d, 0x12, 0x1c, 0xe0, 0x22, 0xd2, 0x05, 0x85, 0x2d, 0x23, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0x22, 
    0x12, 0x1b, 0x23, 0xc2, 0x00, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0xe0, 0x22, 
    0x85, 0x2d, 0x25, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfb, 0xff, 0xf0, 0xe4, 0x90, 0x00, 0x07, 0xf0, 
    0x90, 0x00, 0x0a, 0x74, 0x04, 0xf0, 0xe4, 0x90, 0x00, 0x08, 0xf0, 0x90, 0x21, 0x00, 0xe0, 0x90, 
    0x00, 0x09, 0xf0, 0x90, 0x00, 0x07, 0x74, 0x71, 0xf0, 0xef, 0x44, 0x04, 0x90, 0x00, 0x0b, 0xf0, 
    0xe4, 0x90, 0x21, 0x03, 0xf0, 0x22, 0x90, 0x21, 0x00, 0xe0, 0xff, 0x54, 0x1f, 0xf5, 0x30, 0xa3, 
    0xe0, 0xf5, 0x27, 0x8f, 0x26, 0x12, 0x00, 0x1e, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 
    0x1c, 0xe0, 0x22, 0x90, 0x21, 0x00, 0xe0, 0xf5, 0x2c, 0x12, 0x18, 0xed, 0xe4, 0x90, 0x21, 0x03, 
    0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0xe0, 0x22, 0x12, 0x1a, 0x02, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 
    0x2d, 0x12, 0x1c, 0xe0, 0x22, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0xe0, 0x22, 
    0x8e, 0x15, 0x8f, 0x16, 0xca, 0xed, 0xca, 0xc9, 0xeb, 0xc9, 0x30, 0x0a, 0x04, 0x7f, 0x4a, 0x80, 
    0x02, 0x7f, 0x42, 0xcb, 0xef, 0xcb, 0xea, 0xc3, 0x94, 0x04, 0x50, 0x02, 0x80, 0x01, 0xc3, 0x40, 
    0x04, 0xcb, 0x44, 0x20, 0xcb, 0x85, 0x16, 0x82, 0x85, 0x15, 0x83, 0xeb, 0xf0, 0xa3, 0xe4, 0xf0, 
    0x85, 0x16, 0x82, 0x85, 0x15, 0x83, 0xa3, 0xa3, 0xe5, 0x1a, 0xf0, 0xe5, 0x19, 0x85, 0x16, 0x82, 
    0x85, 0x15, 0x83, 0xa3, 0xa3, 0xa3, 0xf0, 0xe5, 0x16, 0x24, 0x04, 0xf5, 0x82, 0xe4, 0x35, 0x15, 
    0xf5, 0x83, 0x74, 0x0f, 0xf0, 0xe5, 0x16, 0x24, 0x05, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 
    0xe4, 0xf0, 0xe5, 0x16, 0x24, 0x06, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 
    0x16, 0x24, 0x07, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0x74, 0x10, 0xf0, 0xea, 0x90, 0x1b, 
    0x4b, 0x93, 0xfb, 0xea, 0x64, 0x01, 0x60, 0x08, 0xea, 0x64, 0x02, 0x60, 0x03, 0xba, 0x03, 0x04, 
    0xcb, 0x44, 0x08, 0xcb, 0xe5, 0x16, 0x24, 0x08, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xeb, 
    0xf0, 0xe5, 0x16, 0x24, 0x15, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0x74, 0xff, 0xf0, 0xe5, 
    0x16, 0x24, 0x16, 0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xe9, 0xf0, 0xe5, 0x16, 0x24, 0x09, 
    0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0x74, 0x04, 0xf0, 0x25, 0x1a, 0xf5, 0x1a, 0xe4, 0x35, 
    0x19, 0xf5, 0x19, 0xea, 0xc3, 0x94, 0x04, 0x40, 0x03, 0x02, 0x07, 0x17, 0xea, 0x60, 0x03, 0xba, 
    0x01, 0x1f, 0xea, 0x24, 0x01, 0xfd, 0xe4, 0x33, 0xfc, 0xe5, 0x1a, 0xae, 0x19, 0x78, 0x03, 0xc3, 
    0x33, 0xce, 0x33, 0xce, 0xd8, 0xf9, 0xff, 0x12, 0x0f, 0x56, 0x8e, 0x19, 0x8f, 0x1a, 0x02, 0x06, 
    0xf7, 0xea, 0x24, 0xff, 0xfd, 0xe4, 0x34, 0xff, 0xfc, 0x7e, 0x00, 0x7f, 0x0b, 0x12, 0x0f, 0x44, 
    0xcc, 0xee, 0xcc, 0xcd, 0xef, 0xcd, 0xe5, 0x1a, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 0xe5, 
    0x19, 0xc4, 0x54, 0xf0, 0x48, 0xfe, 0x12, 0x0f, 0x56, 0x8c, 0x1b, 0x8d, 0x1c, 0xea, 0x24, 0xff, 
    0xfd, 0xe4, 0x34, 0xff, 0xfc, 0x7e, 0x00, 0x7f, 0x0b, 0x12, 0x0f, 0x44, 0xcc, 0xee, 0xcc, 0xcd, 
    0xef, 0xcd, 0xe5, 0x1a, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 0xe5, 0x19, 0xc4, 0x54, 0xf0, 
    0x48, 0xfe, 0x12, 0x0f, 0x56, 0x8e, 0x19, 0x8f, 0x1a, 0xe5, 0x1c, 0x45, 0x1b, 0x60, 0x08, 0x05, 
    0x1a, 0xe5, 0x1a, 0x70, 0x02, 0x05, 0x19, 0xea, 0x24, 0xff, 0xfd, 0xe4, 0x34, 0xff, 0xfc, 0x7e, 
    0x00, 0x7f, 0x03, 0x12, 0x0f, 0x44, 0xd3, 0xe5, 0x1c, 0x9f, 0xe5, 0x1b, 0x9e, 0x50, 0x18, 0xe5, 
    0x1c, 0x45, 0x1b, 0x60, 0x12, 0xba, 0x03, 0x0f, 0xe5, 0x16, 0x24, 0x09, 0xf5, 0x82, 0xe4, 0x35, 
    0x15, 0xf5, 0x83, 0xe0, 0x44, 0x80, 0xf0, 0xe5, 0x16, 0x24, 0x0a, 0xf5, 0x82, 0xe4, 0x35, 0x15, 
    0xf5, 0x83, 0xe5, 0x1a, 0xf0, 0xe5, 0x19, 0xff, 0xe5, 0x16, 0x24, 0x0b, 0xf5, 0x82, 0xe4, 0x35, 
    0x15, 0xf5, 0x83, 0xef, 0xf0, 0x80, 0x2d, 0xe5, 0x1a, 0x54, 0x3f, 0xff, 0xe5, 0x16, 0x24, 0x0a, 
    0xf5, 0x82, 0xe4, 0x35, 0x15, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x1a, 0xae, 0x19, 0x78, 0x06, 0xce, 
    0xc3, 0x13, 0xce, 0x13, 0xd8, 0xf9, 0xff, 0xe5, 0x16, 0x24, 0x0b, 0xf5, 0x82, 0xe4, 0x35, 0x15, 
    0xf5, 0x83, 0xef, 0xf0, 0x85, 0x16, 0x82, 0x85, 0x15, 0x83, 0xe0, 0x44, 0x01, 0xf0, 0x22, 0x90, 
    0x34, 0xcd, 0xe0, 0xf9, 0x20, 0xe3, 0xf8, 0xe5, 0x2b, 0xf4, 0x60, 0x66, 0x90, 0x34, 0xc0, 0x12, 
    0x0f, 0xc1, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 0xe5, 0x2b, 0x12, 0x0f, 0xd9, 
    0xe5, 0x82, 0x24, 0x04, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 0x12, 0x0f, 0xcd, 0x90, 0x34, 
    0xc8, 0x12, 0x0f, 0xc1, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 0xe5, 0x2b, 0x12, 
    0x0f, 0xd9, 0xe5, 0x82, 0x24, 0x08, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 0x12, 0x0f, 0xcd, 
    0x90, 0x34, 0xd0, 0x12, 0x0f, 0xc1, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 0x20, 0xe5, 
    0x2b, 0x12, 0x0f, 0xd9, 0xe5, 0x82, 0x24, 0x0c, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 0x12, 
    0x0f, 0xcd, 0xe5, 0x34, 0x24, 0xf0, 0xff, 0xe5, 0x33, 0x34, 0xde, 0xfe, 0xef, 0x78, 0x05, 0xce, 
    0xc3, 0x13, 0xce, 0x13, 0xd8, 0xf9, 0xf5, 0x2b, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 
    0x20, 0x12, 0x0f, 0xd9, 0xe5, 0x82, 0x24, 0x04, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 0x83, 0x12, 
    0x0f, 0xc1, 0x90, 0x34, 0xc0, 0x12, 0x0f, 0xcd, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0x75, 0xf0, 
    0x20, 0xe5, 0x2b, 0x12, 0x0f, 0xd9, 0xe5, 0x82, 0x24, 0x08, 0xf5, 0x82, 0xe4, 0x35, 0x83, 0xf5, 
    0x83, 0x12, 0x0f, 0xc1, 0x90, 0x34, 0xc8, 0x12, 0x0f, 0xcd, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 
    0x75, 0xf0, 0x20, 0xe5, 0x2b, 0x12, 0x0f, 0xd9, 0xe5, 0x82, 0x24, 0x0c, 0xf5, 0x82, 0xe4, 0x35, 
    0x83, 0xf5, 0x83, 0x12, 0x0f, 0xc1, 0x90, 0x34, 0xc4, 0x12, 0x0f, 0xcd, 0x90, 0x01, 0x01, 0xe0, 
    0x44, 0x40, 0xf0, 0x90, 0x01, 0x00, 0xe0, 0x44, 0x08, 0xf0, 0xe9, 0x44, 0x04, 0x90, 0x34, 0xcd, 
    0xf0, 0x90, 0x34, 0xcc, 0xe0, 0x44, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 
    0x01, 0xf0, 0x22, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfa, 0xa3, 0xe0, 
    0xfb, 0xed, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3c, 0xf5, 0x83, 0xea, 0xf0, 0xa3, 0xeb, 0xf0, 0xef, 
    0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xec, 0xf0, 0xa3, 0xed, 0xf0, 0x22, 0x00, 0x00, 
    0x90, 0x00, 0x00, 0x74, 0x0e, 0xf0, 0x00, 0x00, 0x00, 0xe4, 0xf0, 0x12, 0x08, 0xc7, 0x12, 0x1d, 
    0x06, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x01, 0xf0, 0xe5, 0x30, 0xb4, 0x05, 0x0a, 0x12, 0x1c, 0xca, 
    0x50, 0x0d, 0x12, 0x09, 0x81, 0x80, 0x08, 0xe5, 0x30, 0xb4, 0x07, 0x03, 0x12, 0x09, 0xd0, 0x12, 
    0x10, 0xd7, 0x80, 0xe4, 0x80, 0xfe, 0x22, 0xc2, 0xaf, 0xe4, 0xf5, 0x2f, 0xf5, 0x88, 0x75, 0xa8, 
    0x0f, 0x75, 0x89, 0x11, 0xf5, 0xb8, 0xf5, 0xe8, 0x75, 0x90, 0x0f, 0x75, 0x31, 0xff, 0x75, 0x2b, 
    0xff, 0x90, 0x22, 0x2e, 0xf0, 0xa3, 0xf0, 0x90, 0x22, 0x4e, 0xf0, 0xa3, 0xf0, 0xc2, 0x05, 0xc2, 
    0x08, 0xc2, 0x00, 0xc2, 0x07, 0xc2, 0x04, 0x90, 0x00, 0x0a, 0x74, 0xff, 0xf0, 0x90, 0x00, 0x0b, 
    0x74, 0x01, 0xf0, 0x90, 0x01, 0x03, 0x74, 0xff, 0xf0, 0xe4, 0x90, 0x01, 0x04, 0xf0, 0x90, 0x01, 
    0x05, 0x74, 0xff, 0xf0, 0xe4, 0x90, 0x01, 0x06, 0xf0, 0x90, 0x00, 0x04, 0xf0, 0x90, 0x30, 0xe8, 
    0x74, 0x10, 0xf0, 0x90, 0x01, 0x07, 0xf0, 0x90, 0x01, 0x08, 0x04, 0xf0, 0x90, 0x01, 0x09, 0x74, 
    0x48, 0xf0, 0x90, 0x01, 0x0a, 0x74, 0x7f, 0xf0, 0x90, 0x01, 0x02, 0x74, 0x1f, 0xf0, 0x90, 0x01, 
    0x00, 0x74, 0x14, 0xf0, 0x90, 0x01, 0x01, 0x74, 0x20, 0xf0, 0x90, 0x00, 0x00, 0xe0, 0x44, 0x80, 
    0xf0, 0x75, 0x49, 0x00, 0x75, 0x4a, 0x01, 0xc2, 0x01, 0xd2, 0xaf, 0x22, 0x75, 0x31, 0x01, 0x90, 
    0x00, 0x0a, 0x74, 0xff, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x20, 0xf0, 0x22, 0xe4, 0xf5, 0x31, 
    0x90, 0x00, 0x0a, 0x74, 0xff, 0xf0, 0x90, 0x22, 0x2e, 0x74, 0x21, 0xf0, 0xa3, 0x74, 0x10, 0xf0, 
    0x22, 0x90, 0x30, 0x3a, 0xe0, 0xff, 0xe5, 0x27, 0x30, 0xe6, 0x12, 0x30, 0x0c, 0x06, 0xef, 0x54, 
    0xf5, 0xfe, 0x80, 0x04, 0xef, 0x44, 0x0a, 0xfe, 0xcf, 0xee, 0xcf, 0x80, 0x10, 0x30, 0x0c, 0x06, 
    0xef, 0x44, 0x0a, 0xfe, 0x80, 0x04, 0xef, 0x54, 0xf5, 0xfe, 0xcf, 0xee, 0xcf, 0xcf, 0x54, 0xfe, 
    0xcf, 0xcf, 0x44, 0x04, 0xcf, 0x90, 0x30, 0x3a, 0xef, 0xf0, 0x30, 0x0c, 0x09, 0x7f, 0x08, 0x7e, 
    0x00, 0x12, 0x1c, 0xf2, 0x80, 0x07, 0x7f, 0x22, 0x7e, 0x01, 0x12, 0x1c, 0xf2, 0xb2, 0x0c, 0x22, 
    0x90, 0x30, 0x3a, 0xe0, 0xf5, 0x10, 0x12, 0x1c, 0xd5, 0x50, 0x26, 0xe5, 0x27, 0x30, 0xe6, 0x05, 
    0x53, 0x10, 0xfd, 0x80, 0x03, 0x43, 0x10, 0x02, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x53, 0x10, 0xf7, 
    0x80, 0x03, 0x43, 0x10, 0x08, 0x53, 0x10, 0xfe, 0x43, 0x10, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x10, 
    0xf0, 0x12, 0x1c, 0xca, 0x50, 0x48, 0x90, 0x01, 0x03, 0xe0, 0xf5, 0x10, 0x54, 0x1c, 0x60, 0x3e, 
    0xe5, 0x10, 0x54, 0xe3, 0xf0, 0xa3, 0xe0, 0xf5, 0x10, 0xf0, 0xe5, 0x27, 0x30, 0xe6, 0x05, 0x43, 
    0x10, 0x02, 0x80, 0x03, 0x53, 0x10, 0xfd, 0xe5, 0x27, 0x30, 0xe7, 0x05, 0x43, 0x10, 0x08, 0x80, 
    0x03, 0x53, 0x10, 0xf7, 0x53, 0x10, 0xfe, 0x43, 0x10, 0x04, 0x90, 0x30, 0x3a, 0xe5, 0x10, 0xf0, 
    0xaf, 0x29, 0x7e, 0x00, 0x12, 0x1c, 0xf2, 0xaf, 0x35, 0x7e, 0x00, 0x12, 0x1c, 0xf9, 0x22, 0x8e, 
    0x12, 0x8f, 0x13, 0x8d, 0x14, 0xe5, 0x14, 0xa2, 0xe1, 0x92, 0x09, 0xe5, 0x34, 0x24, 0x19, 0xf5, 
    0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xfd, 0xe5, 0x34, 0x24, 0x1a, 0xf5, 0x82, 0xe4, 0x35, 
    0x33, 0xf5, 0x83, 0xe0, 0xfb, 0xa2, 0x09, 0x92, 0x0a, 0x75, 0x19, 0x00, 0x75, 0x1a, 0x1a, 0x12, 
    0x05, 0x60, 0x30, 0x09, 0x04, 0x7f, 0xc8, 0x80, 0x02, 0x7f, 0xe8, 0xe5, 0x13, 0x24, 0x18, 0xf5, 
    0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 0x31, 0x60, 0x04, 0x7f, 0x02, 0x80, 0x02, 
    0x7f, 0x01, 0xe5, 0x13, 0x24, 0x19, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0xe5, 
    0x34, 0x24, 0x19, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x7d, 0x1a, 0x7c, 0x00, 
    0x12, 0x10, 0x11, 0xe5, 0x13, 0x24, 0x1a, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 
    0xe5, 0x13, 0x24, 0x1b, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xee, 0xf0, 0xe5, 0x31, 0x60, 
    0x60, 0xe5, 0x13, 0x24, 0x1c, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0xe5, 0x34, 0x24, 0x12, 0xfd, 0xe4, 
    0x35, 0x33, 0xfc, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0xe5, 0x13, 0x24, 0x22, 0xff, 
    0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x10, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x15, 0xd0, 
    0xe5, 0x13, 0x24, 0x28, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x08, 0x75, 0x1b, 0x11, 
    0x7b, 0x06, 0x12, 0x15, 0xd0, 0xe5, 0x34, 0x24, 0x18, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 
    0xe0, 0xff, 0xe5, 0x13, 0x24, 0x2d, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x80, 
    0x3f, 0xe5, 0x13, 0x24, 0x1c, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x10, 0x75, 0x1b, 
    0x11, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0xe5, 0x13, 0x24, 0x22, 0xff, 0xe4, 0x35, 0x12, 0xfe, 0x7c, 
    0x30, 0x7d, 0x08, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0xe5, 0x13, 0x24, 0x28, 0xff, 
    0xe4, 0x35, 0x12, 0xfe, 0x7c, 0x30, 0x7d, 0x10, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x15, 0xd0, 
    0xe5, 0x13, 0x24, 0x2e, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 0x13, 0x24, 
    0x2f, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xe4, 0xf0, 0xe5, 0x34, 0x24, 0x11, 0xf5, 0x82, 
    0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0xc3, 0x13, 0xff, 0xe5, 0x13, 0x24, 0x30, 0xf5, 0x82, 
    0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x30, 0x09, 0x41, 0xe5, 0x13, 0x24, 0x30, 0xf5, 0x82, 
    0xe4, 0x35, 0x12, 0xf5, 0x83, 0xe0, 0xff, 0xe5, 0x31, 0x60, 0x04, 0x7e, 0x00, 0x80, 0x02, 0x7e, 
    0x10, 0xef, 0x4e, 0xf0, 0xe5, 0x31, 0x60, 0x06, 0x7e, 0x00, 0x7f, 0x00, 0x80, 0x0f, 0xe5, 0x14, 
    0x30, 0xe0, 0x06, 0x7e, 0x00, 0x7f, 0xff, 0x80, 0x04, 0x7e, 0x00, 0x7f, 0x00, 0xe5, 0x13, 0x24, 
    0x31, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x22, 0xe5, 0x13, 0x24, 0x30, 0xf5, 
    0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xe0, 0x44, 0x40, 0xf0, 0xe5, 0x14, 0x30, 0xe0, 0x0f, 0xe5, 
    0x34, 0x24, 0x10, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x80, 0x02, 0x7f, 0x00, 
    0xe5, 0x13, 0x24, 0x31, 0xf5, 0x82, 0xe4, 0x35, 0x12, 0xf5, 0x83, 0xef, 0xf0, 0x22, 0xe5, 0x34, 
    0x24, 0x11, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0x30, 0xe7, 0x3b, 0xe5, 0x34, 0x24, 
    0x1c, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0x65, 0x2b, 0x70, 0x03, 0x75, 0x2b, 0xff, 
    0xe5, 0x34, 0x24, 0x1d, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x12, 0x1c, 0xe0, 
    0x7e, 0x22, 0x7f, 0x10, 0x12, 0x19, 0x56, 0x8e, 0x33, 0x8f, 0x34, 0x90, 0x22, 0x2e, 0xe0, 0xfe, 
    0xa3, 0xe0, 0x8e, 0x33, 0xf5, 0x34, 0xc3, 0x22, 0xd2, 0x0a, 0xe5, 0x34, 0x24, 0x1b, 0xf5, 0x82, 
    0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0x70, 0x3a, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 
    0xc0, 0x82, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 0xe0, 
    0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xfe, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 
    0xa3, 0xef, 0xf0, 0xd3, 0x94, 0x00, 0xee, 0x64, 0x80, 0x94, 0x80, 0x50, 0x03, 0x02, 0x0d, 0x68, 
    0x80, 0xc6, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xc3, 0xee, 0x64, 0x80, 
    0x94, 0x80, 0x50, 0x03, 0x02, 0x0d, 0x68, 0x12, 0x1c, 0xbf, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 
    0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0x9f, 0xee, 0x64, 0x80, 0xf8, 0xec, 0x64, 0x80, 0x98, 0x40, 
    0x20, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 0xa3, 0xa3, 0xe0, 0xfe, 0xa3, 
    0xe0, 0xff, 0xed, 0x9f, 0xff, 0xec, 0x9e, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 0xc2, 
    0x0a, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0xe5, 0x34, 0x24, 0x10, 
    0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xfd, 0xee, 0x94, 0x00, 
    0xfc, 0x12, 0x17, 0x30, 0x50, 0x2c, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 
    0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 0xe0, 0xfc, 0xa3, 
    0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 
    0xc2, 0x0a, 0x20, 0x0a, 0x03, 0x02, 0x0c, 0x78, 0x7e, 0x22, 0x7f, 0x10, 0x12, 0x19, 0x56, 0x8e, 
    0x33, 0x8f, 0x34, 0x8f, 0x82, 0x8e, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xd3, 0x94, 0x00, 0xee, 0x64, 
    0x80, 0x94, 0x80, 0x40, 0x0d, 0x7e, 0x22, 0x7f, 0x10, 0xad, 0x34, 0xac, 0x33, 0x12, 0x16, 0x33, 
    0x80, 0x1a, 0x12, 0x1c, 0x35, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xee, 0x8f, 0xf0, 0x12, 0x0f, 
    0xab, 0x7e, 0x22, 0x7f, 0x30, 0xad, 0x34, 0xac, 0x33, 0x12, 0x16, 0x33, 0x90, 0x22, 0x2e, 0xe0, 
    0xfe, 0xa3, 0xe0, 0xff, 0x65, 0x34, 0x70, 0x03, 0xee, 0x65, 0x33, 0x70, 0x02, 0xd3, 0x22, 0x8e, 
    0x33, 0x8f, 0x34, 0xc3, 0x22, 0xe5, 0x31, 0x64, 0x01, 0x70, 0x41, 0x12, 0x1b, 0x83, 0x40, 0x03, 
    0x02, 0x0f, 0x43, 0x12, 0x1c, 0x00, 0x50, 0x20, 0x7e, 0x2b, 0x7f, 0x80, 0x7d, 0x03, 0x12, 0x0a, 
    0x4f, 0x7f, 0x01, 0x12, 0x1a, 0x27, 0x40, 0x09, 0xd2, 0x09, 0x12, 0x11, 0x9b, 0xe4, 0xf5, 0x2f, 
    0x22, 0x12, 0x07, 0x4f, 0x75, 0x2f, 0x01, 0x22, 0x7f, 0x01, 0x12, 0x1a, 0x27, 0x50, 0x04, 0x75, 
    0x2f, 0x02, 0x22, 0xd2, 0x09, 0x12, 0x11, 0x9b, 0xe4, 0xf5, 0x2f, 0x22, 0x12, 0x1a, 0xcc, 0x50, 
    0x51, 0x12, 0x1c, 0x55, 0x90, 0x30, 0xf4, 0xe0, 0xf5, 0x2a, 0x7e, 0x30, 0x7f, 0xec, 0xa3, 0xe0, 
    0xfd, 0xe4, 0xfb, 0x12, 0x19, 0xda, 0xe4, 0xff, 0xfe, 0x12, 0x1c, 0xb4, 0x90, 0x00, 0x0a, 0x74, 
    0x02, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x02, 0xff, 0xf0, 0xfd, 0x90, 0x01, 0x05, 0x74, 0x20, 
    0xf0, 0x90, 0x01, 0x06, 0xe0, 0x44, 0x20, 0xf0, 0xed, 0x54, 0xbf, 0x90, 0x00, 0x0b, 0xf0, 0x90, 
    0x34, 0xcc, 0xe0, 0x44, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x01, 0xf0, 0xa3, 0xe0, 0x44, 0x01, 0xf0, 
    0xd2, 0x04, 0x12, 0x1a, 0xe9, 0x50, 0x43, 0x12, 0x1b, 0x06, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x30, 
    0x7d, 0xec, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0x90, 0x30, 0xf5, 0xe0, 0x75, 0xf0, 
    0x20, 0xa4, 0xff, 0xae, 0xf0, 0x12, 0x1c, 0xb4, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 0xff, 0xf0, 
    0xfd, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0x90, 0x00, 0x0a, 
    0x74, 0x40, 0xf0, 0x4d, 0x90, 0x00, 0x0b, 0xf0, 0xc2, 0x04, 0x12, 0x1b, 0xad, 0x50, 0x38, 0x12, 
    0x1b, 0x06, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1d, 0x7d, 0x00, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 
    0x15, 0xd0, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xe4, 0xff, 0xfe, 0x12, 
    0x1c, 0xb4, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0x90, 0x01, 
    0x06, 0xe0, 0x54, 0xdf, 0xf0, 0xc2, 0x04, 0x12, 0x1b, 0xd7, 0x50, 0x25, 0x12, 0x1b, 0x06, 0x7f, 
    0x02, 0x12, 0x1a, 0x27, 0x90, 0x01, 0x04, 0xe0, 0x54, 0x7f, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 
    0xfd, 0xff, 0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0xef, 0x54, 0xbf, 0x90, 0x00, 0x0b, 0xf0, 0xc2, 
    0x04, 0x12, 0x1b, 0x83, 0x50, 0x2d, 0x12, 0x1b, 0x06, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1d, 0x7d, 
    0x00, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 
    0x00, 0x0a, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xbf, 
    0xf0, 0xc2, 0x04, 0x22, 0xef, 0x8d, 0xf0, 0xa4, 0xa8, 0xf0, 0xcf, 0x8c, 0xf0, 0xa4, 0x28, 0xce, 
    0x8d, 0xf0, 0xa4, 0x2e, 0xfe, 0x22, 0xbc, 0x00, 0x0b, 0xbe, 0x00, 0x29, 0xef, 0x8d, 0xf0, 0x84, 
    0xff, 0xad, 0xf0, 0x22, 0xe4, 0xcc, 0xf8, 0x75, 0xf0, 0x08, 0xef, 0x2f, 0xff, 0xee, 0x33, 0xfe, 
    0xec, 0x33, 0xfc, 0xee, 0x9d, 0xec, 0x98, 0x40, 0x05, 0xfc, 0xee, 0x9d, 0xfe, 0x0f, 0xd5, 0xf0, 
    0xe9, 0xe4, 0xce, 0xfd, 0x22, 0xed, 0xf8, 0xf5, 0xf0, 0xee, 0x84, 0x20, 0xd2, 0x1c, 0xfe, 0xad, 
    0xf0, 0x75, 0xf0, 0x08, 0xef, 0x2f, 0xff, 0xed, 0x33, 0xfd, 0x40, 0x07, 0x98, 0x50, 0x06, 0xd5, 
    0xf0, 0xf2, 0x22, 0xc3, 0x98, 0xfd, 0x0f, 0xd5, 0xf0, 0xea, 0x22, 0xc5, 0xf0, 0xf8, 0xa3, 0xe0, 
    0x28, 0xf0, 0xc5, 0xf0, 0xf8, 0xe5, 0x82, 0x15, 0x82, 0x70, 0x02, 0x15, 0x83, 0xe0, 0x38, 0xf0, 
    0x22, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xa3, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x22, 0xec, 0xf0, 0xa3, 
    0xed, 0xf0, 0xa3, 0xee, 0xf0, 0xa3, 0xef, 0xf0, 0x22, 0xa4, 0x25, 0x82, 0xf5, 0x82, 0xe5, 0xf0, 
    0x35, 0x83, 0xf5, 0x83, 0x22, 0xd0, 0x83, 0xd0, 0x82, 0xf8, 0xe4, 0x93, 0x70, 0x12, 0x74, 0x01, 
    0x93, 0x70, 0x0d, 0xa3, 0xa3, 0x93, 0xf8, 0x74, 0x01, 0x93, 0xf5, 0x82, 0x88, 0x83, 0xe4, 0x73, 
    0x74, 0x02, 0x93, 0x68, 0x60, 0xef, 0xa3, 0xa3, 0xa3, 0x80, 0xdf, 0x8a, 0x83, 0x89, 0x82, 0xe4, 
    0x73, 0x8f, 0x15, 0x8c, 0x16, 0x8d, 0x17, 0xe5, 0x15, 0xc3, 0x94, 0x04, 0x50, 0x56, 0xe5, 0x15, 
    0x94, 0x00, 0x40, 0x06, 0x7a, 0x00, 0x7b, 0x60, 0x80, 0x04, 0x7a, 0x00, 0x7b, 0xc0, 0xe5, 0x17, 
    0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 0xe5, 0x16, 0xc4, 0x54, 0xf0, 0x48, 0xfe, 0xe5, 0x15, 
    0x90, 0x1b, 0x3d, 0x93, 0xfd, 0x7c, 0x00, 0x12, 0x0f, 0x56, 0xef, 0x2b, 0xfb, 0xee, 0x3a, 0xfa, 
    0xe5, 0x17, 0xc4, 0xf8, 0x54, 0x0f, 0xc8, 0x68, 0xff, 0xe5, 0x16, 0xc4, 0x54, 0xf0, 0x48, 0xfe, 
    0xe5, 0x15, 0x93, 0xfd, 0x7c, 0x00, 0x12, 0x0f, 0x56, 0xed, 0x4c, 0x60, 0x63, 0x0b, 0xbb, 0x00, 
    0x01, 0x0a, 0x80, 0x5c, 0x7a, 0x00, 0x7b, 0x1a, 0xe5, 0x17, 0xae, 0x16, 0x78, 0x02, 0xc3, 0x33, 
    0xce, 0x33, 0xce, 0xd8, 0xf9, 0x24, 0x0b, 0xff, 0xe4, 0x3e, 0xfe, 0xe5, 0x15, 0x90, 0x1b, 0x3d, 
    0x93, 0xfd, 0x7c, 0x00, 0x12, 0x0f, 0x56, 0xef, 0x78, 0x02, 0xc3, 0x33, 0xce, 0x33, 0xce, 0xd8, 
    0xf9, 0x2b, 0xfb, 0xee, 0x3a, 0xfa, 0xe5, 0x17, 0xae, 0x16, 0x78, 0x02, 0xc3, 0x33, 0xce, 0x33, 
    0xce, 0xd8, 0xf9, 0x24, 0x0b, 0xff, 0xe4, 0x3e, 0xfe, 0xe5, 0x15, 0x90, 0x1b, 0x3d, 0x93, 0xfd, 
    0x7c, 0x00, 0x12, 0x0f, 0x56, 0xed, 0x4c, 0x60, 0x07, 0x74, 0x04, 0x2b, 0xfb, 0xe4, 0x3a, 0xfa, 
    0xcf, 0xeb, 0xcf, 0xce, 0xea, 0xce, 0x22, 0xe5, 0x2e, 0x14, 0x60, 0x1d, 0x14, 0x60, 0x3d, 0x14, 
    0x60, 0x5d, 0x14, 0x70, 0x03, 0x02, 0x11, 0x84, 0x24, 0x04, 0x60, 0x03, 0x02, 0x11, 0x9a, 0x20, 
    0x0d, 0x03, 0x02, 0x11, 0x9a, 0x75, 0x2e, 0x01, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0xff, 0x30, 0xe5, 
    0x03, 0x44, 0x20, 0xf0, 0xe5, 0x40, 0x45, 0x3f, 0x60, 0x03, 0x02, 0x11, 0x9a, 0x75, 0x2e, 0x02, 
    0x12, 0x1a, 0x4a, 0x12, 0x1c, 0x13, 0xaf, 0x28, 0x12, 0x1b, 0x57, 0x22, 0x90, 0x01, 0x03, 0xe0, 
    0xff, 0x30, 0xe7, 0x76, 0xef, 0x44, 0x80, 0x90, 0x01, 0x03, 0xf0, 0x12, 0x18, 0x42, 0x12, 0x1a, 
    0x8d, 0x12, 0x1c, 0x45, 0x75, 0x2e, 0x03, 0xaf, 0x22, 0x7e, 0x00, 0x12, 0x1c, 0xa8, 0x22, 0xe5, 
    0x40, 0x45, 0x3f, 0x70, 0x21, 0x12, 0x15, 0x66, 0x12, 0x1c, 0x13, 0x12, 0x1a, 0x6d, 0x12, 0x1c, 
    0x45, 0x12, 0x1c, 0x8e, 0x30, 0x0d, 0x0b, 0x75, 0x2e, 0x01, 0xaf, 0x32, 0x7e, 0x00, 0x12, 0x1c, 
    0xa8, 0x22, 0xe4, 0xf5, 0x2e, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0xff, 0x30, 0xe5, 0x2c, 0x44, 0x20, 
    0xf0, 0x12, 0x15, 0x66, 0x12, 0x1c, 0x13, 0x12, 0x1a, 0x6d, 0x12, 0x1c, 0x45, 0x12, 0x1c, 0x8e, 
    0x75, 0x2e, 0x04, 0x22, 0xe5, 0x40, 0x45, 0x3f, 0x70, 0x10, 0x30, 0x0d, 0x0a, 0x75, 0x2e, 0x01, 
    0xaf, 0x32, 0xfe, 0x12, 0x1c, 0xa8, 0x22, 0xe4, 0xf5, 0x2e, 0x22, 0x90, 0x00, 0x04, 0x74, 0x02, 
    0xf0, 0x90, 0x00, 0x0a, 0xf0, 0x30, 0x09, 0x32, 0xe5, 0x34, 0x45, 0x33, 0x70, 0x02, 0xc3, 0x22, 
    0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 0x83, 0xc0, 0x82, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x85, 
    0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 
    0xee, 0x9c, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 0xa3, 0xef, 0xf0, 0xe5, 0x34, 0x45, 0x33, 0x70, 0x02, 
    0xc3, 0x22, 0x12, 0x0c, 0x2e, 0x50, 0xf3, 0x90, 0x00, 0x0a, 0xe0, 0x20, 0xe5, 0x03, 0x30, 0x07, 
    0x41, 0xe5, 0x34, 0x45, 0x33, 0x70, 0x02, 0xc3, 0x22, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xc0, 
    0x83, 0xc0, 0x82, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xa3, 0xa3, 
    0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0xc3, 0xef, 0x9d, 0xff, 0xee, 0x9c, 0xd0, 0x82, 0xd0, 0x83, 0xf0, 
    0xa3, 0xef, 0xf0, 0xe5, 0x34, 0x45, 0x33, 0x70, 0x02, 0xc3, 0x22, 0x12, 0x0c, 0x2e, 0x50, 0xf3, 
    0x80, 0xb5, 0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x12, 0x17, 0xc0, 
    0xd3, 0x22, 0x12, 0x1b, 0xad, 0x40, 0x05, 0x12, 0x1b, 0x83, 0x50, 0x44, 0x7e, 0x30, 0x7f, 0xe0, 
    0x7c, 0x1d, 0x7d, 0x00, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0x90, 0x00, 0x04, 0x74, 
    0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xe4, 0xff, 0xfe, 0x12, 0x1c, 0xb4, 0x90, 0x00, 0x0b, 0xe0, 
    0x54, 0xbf, 0xf0, 0x54, 0x7f, 0xff, 0xf0, 0xe4, 0x90, 0x30, 0xe9, 0xf0, 0xef, 0x54, 0xfd, 0x90, 
    0x00, 0x0b, 0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 0xd2, 0x09, 0x12, 0x11, 0x9b, 0xe4, 0xf5, 0x2f, 
    0x12, 0x1b, 0xc2, 0x50, 0x48, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1d, 0x7d, 0x00, 0x75, 0x1b, 0x12, 
    0x7b, 0x06, 0x12, 0x15, 0xd0, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 0xf0, 0xe4, 
    0xff, 0xfe, 0x12, 0x1c, 0xb4, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 0x54, 0xfd, 0xf0, 0xe4, 
    0x90, 0x00, 0x04, 0xf0, 0xff, 0x12, 0x1a, 0x27, 0x50, 0x04, 0x75, 0x2f, 0x07, 0x22, 0x90, 0x01, 
    0x04, 0xe0, 0x54, 0x7f, 0xf0, 0xd2, 0x09, 0x12, 0x11, 0x9b, 0xe4, 0xf5, 0x2f, 0x22, 0x78, 0x7f, 
    0xe4, 0xf6, 0xd8, 0xfd, 0x75, 0x81, 0x4c, 0x02, 0x13, 0x25, 0x02, 0x08, 0x90, 0xe4, 0x93, 0xa3, 
    0xf8, 0xe4, 0x93, 0xa3, 0x40, 0x03, 0xf6, 0x80, 0x01, 0xf2, 0x08, 0xdf, 0xf4, 0x80, 0x29, 0xe4, 
    0x93, 0xa3, 0xf8, 0x54, 0x07, 0x24, 0x0c, 0xc8, 0xc3, 0x33, 0xc4, 0x54, 0x0f, 0x44, 0x20, 0xc8, 
    0x83, 0x40, 0x04, 0xf4, 0x56, 0x80, 0x01, 0x46, 0xf6, 0xdf, 0xe4, 0x80, 0x0b, 0x01, 0x02, 0x04, 
    0x08, 0x10, 0x20, 0x40, 0x80, 0x90, 0x00, 0x0a, 0xe4, 0x7e, 0x01, 0x93, 0x60, 0xbc, 0xa3, 0xff, 
    0x54, 0x3f, 0x30, 0xe5, 0x09, 0x54, 0x1f, 0xfe, 0xe4, 0x93, 0xa3, 0x60, 0x01, 0x0e, 0xcf, 0x54, 
    0xc0, 0x25, 0xe0, 0x60, 0xa8, 0x40, 0xb8, 0xe4, 0x93, 0xa3, 0xfa, 0xe4, 0x93, 0xa3, 0xf8, 0xe4, 
    0x93, 0xa3, 0xc8, 0xc5, 0x82, 0xc8, 0xca, 0xc5, 0x83, 0xca, 0xf0, 0xa3, 0xc8, 0xc5, 0x82, 0xc8, 
    0xca, 0xc5, 0x83, 0xca, 0xdf, 0xe9, 0xde, 0xe7, 0x80, 0xbe, 0x12, 0x1b, 0x83, 0x50, 0x2d, 0x12, 
    0x19, 0x22, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1d, 0x7d, 
    0x00, 0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 
    0x00, 0x0a, 0xf0, 0xd2, 0x09, 0x12, 0x11, 0x9b, 0xe4, 0xf5, 0x2f, 0x22, 0x12, 0x1b, 0xd7, 0x50, 
    0x50, 0x12, 0x19, 0x22, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfd, 0xf0, 0xe4, 0x90, 0x00, 0x04, 0xf0, 
    0x90, 0x01, 0x03, 0x74, 0x80, 0xf0, 0x90, 0x01, 0x04, 0xe0, 0x44, 0x80, 0xf0, 0x7f, 0x02, 0x12, 
    0x1a, 0x27, 0x50, 0x04, 0x75, 0x2f, 0x05, 0x22, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1d, 0x7d, 0x00, 
    0x75, 0x1b, 0x12, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 
    0x0a, 0xf0, 0xd2, 0x09, 0x12, 0x11, 0x9b, 0x90, 0x01, 0x04, 0xe0, 0x54, 0x7f, 0xf0, 0xe4, 0xf5, 
    0x2f, 0x22, 0x90, 0x30, 0x30, 0x74, 0x02, 0xf0, 0x75, 0x11, 0x07, 0x75, 0x12, 0xd0, 0x90, 0x30, 
    0x30, 0xe0, 0x30, 0xe0, 0x0e, 0xe5, 0x12, 0x15, 0x12, 0x70, 0x02, 0x15, 0x11, 0xe5, 0x12, 0x45, 
    0x11, 0x70, 0xeb, 0xe5, 0x12, 0x45, 0x11, 0x70, 0x12, 0x12, 0x1b, 0x23, 0x90, 0x21, 0x00, 0xe0, 
    0x60, 0x07, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x04, 0xf0, 0xc3, 0x22, 0xe4, 0x90, 0x34, 0x58, 0xf0, 
    0x90, 0x34, 0x32, 0x74, 0x1f, 0xf0, 0x75, 0x11, 0x07, 0x75, 0x12, 0xd0, 0x90, 0x34, 0x81, 0xe0, 
    0x64, 0x03, 0x60, 0x0e, 0xe5, 0x12, 0x15, 0x12, 0x70, 0x02, 0x15, 0x11, 0xe5, 0x12, 0x45, 0x11, 
    0x70, 0xea, 0xe5, 0x12, 0x45, 0x11, 0x70, 0x12, 0x12, 0x1b, 0x23, 0x90, 0x21, 0x00, 0xe0, 0x60, 
    0x07, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x04, 0xf0, 0xc3, 0x22, 0x90, 0x34, 0x98, 0xe0, 0x44, 0x04, 
    0xf0, 0xe4, 0x90, 0x00, 0x01, 0xf0, 0xd3, 0x22, 0x12, 0x1b, 0x6e, 0x50, 0x72, 0x12, 0x1c, 0xbf, 
    0x85, 0x34, 0x82, 0x85, 0x33, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xc3, 0x9f, 0xf5, 0x12, 0xec, 0x9e, 
    0xf5, 0x11, 0xd3, 0xe5, 0x12, 0x94, 0x00, 0xe5, 0x11, 0x64, 0x80, 0x94, 0x80, 0x40, 0x06, 0xae, 
    0x11, 0xaf, 0x12, 0x80, 0x04, 0x7e, 0x00, 0x7f, 0x00, 0x8e, 0x11, 0x8f, 0x12, 0xe5, 0x34, 0x24, 
    0x10, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xc3, 0x95, 0x12, 0xf5, 0x12, 0xe4, 0x95, 
    0x11, 0xf5, 0x11, 0xc3, 0x64, 0x80, 0x94, 0x80, 0x50, 0x05, 0xe4, 0xf5, 0x11, 0xf5, 0x12, 0xe5, 
    0x34, 0x24, 0x12, 0xff, 0xe4, 0x35, 0x33, 0xfe, 0xad, 0x12, 0x7b, 0x01, 0x12, 0x19, 0xda, 0x90, 
    0x01, 0x05, 0x74, 0x20, 0xf0, 0x90, 0x01, 0x06, 0xe0, 0x44, 0x20, 0xf0, 0x75, 0x2f, 0x03, 0x22, 
    0xc0, 0xe0, 0xc0, 0xf0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0xd0, 0x75, 0xd0, 0x08, 0xc2, 0xaf, 0x90, 
    0x22, 0x2e, 0xe0, 0xfe, 0xa3, 0xe0, 0x8e, 0x33, 0xf5, 0x34, 0xe5, 0x2f, 0x25, 0xe0, 0x24, 0x25, 
    0xf5, 0x82, 0xe4, 0x34, 0x1c, 0xf5, 0x83, 0xe4, 0x93, 0xfe, 0x74, 0x01, 0x93, 0xca, 0xee, 0xca, 
    0xf9, 0x12, 0x10, 0x0b, 0x12, 0x1c, 0x80, 0x50, 0x02, 0xd2, 0x07, 0x12, 0x18, 0x02, 0x12, 0x03, 
    0x5f, 0x12, 0x1b, 0x98, 0x50, 0x05, 0xaf, 0x25, 0x12, 0x1c, 0xe0, 0x30, 0x05, 0x1b, 0xe5, 0x2f, 
    0x70, 0x17, 0x20, 0x04, 0x14, 0x12, 0x13, 0xf2, 0x92, 0x00, 0xc2, 0x05, 0xd2, 0x0b, 0xa2, 0x00, 
    0xe4, 0x33, 0xf5, 0x14, 0xaf, 0x23, 0x12, 0x17, 0x78, 0xd2, 0xaf, 0xd0, 0xd0, 0xd0, 0x82, 0xd0, 
    0x83, 0xd0, 0xf0, 0xd0, 0xe0, 0x32, 0x90, 0x29, 0xa0, 0xe0, 0x70, 0x63, 0x90, 0x30, 0x8c, 0xe4, 
    0xf0, 0xa3, 0x74, 0xc2, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 
    0xff, 0x90, 0x29, 0xa0, 0xf0, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xa3, 0x74, 0xc5, 0xf0, 0xa3, 0x74, 
    0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 0xff, 0x90, 0x29, 0xa1, 0xf0, 0x90, 0x30, 
    0x8c, 0xe4, 0xf0, 0xa3, 0x74, 0xc4, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 
    0x8c, 0xe0, 0xff, 0x90, 0x29, 0xa2, 0xf0, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xa3, 0x74, 0xc3, 0xf0, 
    0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 0x90, 0x29, 0xa3, 0xf0, 0x22, 
    0x8e, 0x16, 0x8f, 0x17, 0x8c, 0x18, 0x8d, 0x19, 0xe4, 0xff, 0xef, 0xc3, 0x9b, 0x50, 0x53, 0xe5, 
    0x1b, 0x30, 0xe0, 0x12, 0xef, 0x7c, 0x00, 0x25, 0x19, 0xfd, 0xec, 0x35, 0x18, 0x8d, 0x82, 0xf5, 
    0x83, 0xe0, 0xf5, 0x1c, 0x80, 0x1f, 0xe5, 0x1b, 0x30, 0xe1, 0x13, 0xef, 0x7c, 0x00, 0x25, 0x19, 
    0xfd, 0xec, 0x35, 0x18, 0x8d, 0x82, 0xf5, 0x83, 0xe4, 0x93, 0xf5, 0x1c, 0x80, 0x07, 0xe5, 0x19, 
    0x2f, 0xf8, 0xe6, 0xf5, 0x1c, 0xe5, 0x1b, 0x30, 0xe4, 0x0f, 0xe5, 0x17, 0x2f, 0xf5, 0x82, 0xe4, 
    0x35, 0x16, 0xf5, 0x83, 0xe5, 0x1c, 0xf0, 0x80, 0x06, 0xe5, 0x17, 0x2f, 0xf8, 0xa6, 0x1c, 0x0f, 
    0x80, 0xa8, 0x22, 0x8c, 0x13, 0x8d, 0x14, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 
    0xe0, 0xfc, 0xa3, 0xe0, 0x4c, 0x60, 0x41, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 
    0xe0, 0xfc, 0xa3, 0xe0, 0xf5, 0x82, 0x8c, 0x83, 0xe0, 0xfc, 0xa3, 0xe0, 0xfd, 0x85, 0x14, 0x82, 
    0x85, 0x13, 0x83, 0xe0, 0xfa, 0xa3, 0xe0, 0xfb, 0xd3, 0xed, 0x9b, 0xea, 0x64, 0x80, 0xf8, 0xec, 
    0x64, 0x80, 0x98, 0x40, 0x13, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfc, 
    0xa3, 0xe0, 0xce, 0xec, 0xce, 0xff, 0x80, 0xaf, 0xad, 0x14, 0xac, 0x13, 0x12, 0x08, 0x63, 0x22, 
    0x12, 0x1b, 0x6e, 0x50, 0x4f, 0xe5, 0x34, 0x24, 0x12, 0xff, 0xe4, 0x35, 0x33, 0xfe, 0xe5, 0x34, 
    0x24, 0x10, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xfd, 0xe4, 0xfb, 0x12, 0x19, 0xda, 
    0xe5, 0x34, 0x24, 0x10, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0xff, 0x7e, 0x00, 0x12, 
    0x1c, 0xb4, 0x90, 0x00, 0x0a, 0x74, 0x40, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x40, 0xff, 0xf0, 
    0x90, 0x00, 0x0a, 0x74, 0x80, 0xf0, 0x4f, 0x90, 0x00, 0x0b, 0xf0, 0x90, 0x30, 0xe9, 0x74, 0x01, 
    0xf0, 0x75, 0x2f, 0x06, 0x22, 0xc0, 0xe0, 0xc0, 0xf0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, 0xd0, 0x75, 
    0xd0, 0x08, 0xc2, 0xaf, 0xc2, 0x8c, 0xc2, 0x8d, 0xd3, 0xe5, 0x4a, 0x94, 0x00, 0xe5, 0x49, 0x94, 
    0x00, 0x40, 0x08, 0xe5, 0x4a, 0x15, 0x4a, 0x70, 0x02, 0x15, 0x49, 0xd3, 0xe5, 0x4c, 0x94, 0x00, 
    0xe5, 0x4b, 0x94, 0x00, 0x40, 0x08, 0xe5, 0x4c, 0x15, 0x4c, 0x70, 0x02, 0x15, 0x4b, 0x12, 0x00, 
    0x0e, 0xd2, 0x8c, 0xd2, 0xaf, 0xd0, 0xd0, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xf0, 0xd0, 0xe0, 0x32, 
    0xc3, 0xef, 0x94, 0x04, 0xee, 0x64, 0x80, 0x94, 0x80, 0x40, 0x0c, 0xd3, 0xed, 0x94, 0x04, 0xec, 
    0x64, 0x80, 0x94, 0x80, 0x50, 0x01, 0x22, 0xc3, 0xef, 0x94, 0xfc, 0xee, 0x64, 0x80, 0x94, 0x7f, 
    0x40, 0x0c, 0xd3, 0xed, 0x94, 0xfc, 0xec, 0x64, 0x80, 0x94, 0x7f, 0x50, 0x01, 0x22, 0xd3, 0xef, 
    0x94, 0x04, 0xee, 0x64, 0x80, 0x94, 0x80, 0x50, 0x0d, 0xc3, 0xed, 0x94, 0xfc, 0xec, 0x64, 0x80, 
    0x94, 0x7f, 0x40, 0x02, 0xd3, 0x22, 0xc3, 0x22, 0xe4, 0xfe, 0xef, 0xf4, 0x60, 0x41, 0x74, 0x04, 
    0x2e, 0xf5, 0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe0, 0xb4, 0xff, 0x23, 0x74, 0x04, 0x2e, 0xf5, 
    0x82, 0xe4, 0x34, 0x21, 0xf5, 0x83, 0xef, 0xf0, 0x30, 0x0b, 0x0d, 0x74, 0x08, 0x2e, 0xf5, 0x82, 
    0xe4, 0x34, 0x21, 0xf5, 0x83, 0xe5, 0x14, 0xf0, 0x90, 0x00, 0x02, 0x74, 0x01, 0xf0, 0x22, 0xbe, 
    0x03, 0x0a, 0x90, 0x00, 0x02, 0x74, 0x01, 0xf0, 0xe4, 0xfe, 0x80, 0xc2, 0x0e, 0x80, 0xbf, 0x22, 
    0x8e, 0x13, 0x8f, 0x14, 0x12, 0x1c, 0xbf, 0xc3, 0xef, 0x95, 0x14, 0xff, 0xee, 0x95, 0x13, 0xcd, 
    0xef, 0xcd, 0xfc, 0xd3, 0xed, 0x94, 0x00, 0xec, 0x64, 0x80, 0x94, 0x80, 0x40, 0x05, 0xce, 0xec, 
    0xce, 0x80, 0x04, 0x7e, 0x00, 0x7f, 0x01, 0xcc, 0xee, 0xcc, 0xec, 0x90, 0x00, 0x05, 0xf0, 0x90, 
    0x00, 0x06, 0xef, 0xf0, 0x90, 0x00, 0x04, 0x74, 0x51, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x02, 
    0xf0, 0x22, 0x30, 0x07, 0x3c, 0xe5, 0x2f, 0x70, 0x38, 0xc2, 0x07, 0x90, 0x22, 0x2e, 0xe0, 0xfe, 
    0xa3, 0xe0, 0x8e, 0x11, 0xf5, 0x12, 0x90, 0x22, 0x4e, 0xe0, 0xfe, 0xa3, 0xe0, 0xff, 0x90, 0x22, 
    0x2e, 0xee, 0xf0, 0xa3, 0xef, 0xf0, 0x90, 0x22, 0x4e, 0xe5, 0x11, 0xf0, 0xa3, 0xe5, 0x12, 0xf0, 
    0x8e, 0x33, 0x8f, 0x34, 0x30, 0x08, 0x05, 0x12, 0x18, 0xb6, 0xc2, 0x08, 0xc2, 0x09, 0x12, 0x11, 
    0x9b, 0x22, 0xe4, 0xff, 0x90, 0x30, 0x8c, 0xe4, 0xf0, 0xef, 0x90, 0x1b, 0xec, 0x93, 0x44, 0x80, 
    0x90, 0x30, 0x8d, 0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x30, 0x8c, 0xe0, 0xfe, 
    0x74, 0x36, 0x2f, 0xf8, 0xc6, 0xee, 0xc6, 0xa3, 0xe0, 0xfe, 0xef, 0x90, 0x1b, 0xec, 0x93, 0x44, 
    0x80, 0x6e, 0x60, 0x01, 0x1f, 0x0f, 0xef, 0xc3, 0x94, 0x09, 0x40, 0xc8, 0x22, 0x7f, 0x80, 0x7e, 
    0x29, 0xe4, 0xfd, 0xfc, 0x8f, 0x82, 0x8e, 0x83, 0xe0, 0xfb, 0x74, 0x45, 0x2d, 0xf8, 0xc6, 0xeb, 
    0xc6, 0x74, 0x04, 0x2f, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 0xfb, 0x74, 0x41, 0x2d, 0xf8, 
    0xc6, 0xeb, 0xc6, 0x74, 0x08, 0x2f, 0xff, 0xe4, 0x3e, 0xfe, 0x0d, 0xbd, 0x00, 0x01, 0x0c, 0xed, 
    0x64, 0x04, 0x4c, 0x70, 0xcf, 0x22, 0x90, 0x21, 0x00, 0xe0, 0xc4, 0x33, 0x54, 0xe0, 0x24, 0x10, 
    0xf5, 0x82, 0xe4, 0x34, 0x21, 0xab, 0x82, 0xfa, 0x12, 0x1c, 0x35, 0x8b, 0x82, 0x8a, 0x83, 0xee, 
    0x8f, 0xf0, 0x12, 0x0f, 0xab, 0x7e, 0x22, 0x7f, 0x30, 0xcd, 0xeb, 0xcd, 0xcc, 0xea, 0xcc, 0x12, 
    0x16, 0x33, 0xe4, 0x90, 0x21, 0x03, 0xf0, 0xaf, 0x2d, 0x12, 0x1c, 0xe0, 0x22, 0xe4, 0xff, 0xe5, 
    0x30, 0x24, 0xfe, 0x70, 0x2c, 0xe4, 0xfe, 0xee, 0xc3, 0x95, 0x2c, 0x50, 0x12, 0x74, 0x01, 0xc8, 
    0xee, 0xc8, 0x08, 0x80, 0x02, 0xc3, 0x33, 0xd8, 0xfc, 0xcf, 0x4f, 0xcf, 0x0e, 0x80, 0xe8, 0x90, 
    0x30, 0x34, 0xe0, 0x54, 0xe0, 0xfe, 0xe5, 0x27, 0x54, 0x1f, 0x6f, 0xf4, 0xce, 0x4e, 0xce, 0xee, 
    0xf0, 0x22, 0x90, 0x34, 0xce, 0xe0, 0x44, 0x02, 0xf0, 0x90, 0x34, 0xcd, 0xe0, 0x54, 0xfe, 0xf0, 
    0x90, 0x34, 0xcd, 0xe0, 0x20, 0xe3, 0xf9, 0x90, 0x01, 0x11, 0xe0, 0x54, 0x22, 0xff, 0xbf, 0x22, 
    0x03, 0xd3, 0x80, 0x01, 0xc3, 0x50, 0xf0, 0x90, 0x01, 0x00, 0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 
    0x01, 0xe0, 0x54, 0xbf, 0xf0, 0x22, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xe0, 
    0xfc, 0xa3, 0xe0, 0xfb, 0xca, 0xec, 0xca, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3c, 0xf5, 0x83, 0xe0, 
    0xfc, 0xa3, 0xe0, 0xfd, 0xef, 0x24, 0x1e, 0xf5, 0x82, 0xe4, 0x3e, 0xf5, 0x83, 0xec, 0xf0, 0xa3, 
    0xed, 0xf0, 0xce, 0xea, 0xce, 0xcf, 0xeb, 0xcf, 0x22, 0xc0, 0xe0, 0xc0, 0xd0, 0xc2, 0xaf, 0xc2, 
    0x8e, 0xc2, 0x8f, 0xd3, 0xe5, 0x40, 0x94, 0x00, 0xe5, 0x3f, 0x94, 0x00, 0x40, 0x0d, 0xe5, 0x40, 
    0x15, 0x40, 0x70, 0x02, 0x15, 0x3f, 0x12, 0x1c, 0xe9, 0xd2, 0x8e, 0xd2, 0xaf, 0xd0, 0xd0, 0xd0, 
    0xe0, 0x32, 0x12, 0x1b, 0x6e, 0x50, 0x22, 0x7e, 0x30, 0x7f, 0xe0, 0x7c, 0x1d, 0x7d, 0x00, 0x75, 
    0x1b, 0x12, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0x90, 0x00, 0x04, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0a, 
    0xf0, 0xd2, 0x09, 0x12, 0x11, 0x9b, 0xe4, 0xf5, 0x2f, 0x22, 0x8e, 0x13, 0x8f, 0x14, 0x8d, 0x15, 
    0xeb, 0x60, 0x09, 0x14, 0x70, 0x1b, 0xaf, 0x15, 0x12, 0x1a, 0xad, 0x22, 0x7e, 0x30, 0x7f, 0xe0, 
    0xac, 0x13, 0xad, 0x14, 0x75, 0x1b, 0x11, 0x7b, 0x06, 0x12, 0x15, 0xd0, 0xaf, 0x15, 0x12, 0x1a, 
    0xad, 0x22, 0x12, 0x18, 0x7d, 0x90, 0x21, 0x01, 0xe0, 0xf5, 0x28, 0x74, 0x41, 0x25, 0x28, 0xf8, 
    0xe6, 0xf5, 0x32, 0x74, 0x45, 0x25, 0x28, 0xf8, 0xe6, 0xf5, 0x22, 0x90, 0x21, 0x00, 0xe0, 0x60, 
    0x03, 0xd2, 0x0d, 0x22, 0xc2, 0x0d, 0x22, 0xcd, 0xef, 0xcd, 0x90, 0x01, 0x02, 0xe0, 0x30, 0xe7, 
    0x02, 0xc3, 0x22, 0x7e, 0x2a, 0x7f, 0x00, 0x12, 0x0a, 0x4f, 0x90, 0x01, 0x04, 0xe0, 0x44, 0x80, 
    0xf0, 0x90, 0x01, 0x02, 0xe0, 0x44, 0x80, 0xf0, 0xd3, 0x22, 0x90, 0x34, 0x30, 0xe4, 0xf0, 0xa3, 
    0xf0, 0xa3, 0x74, 0x1f, 0xf0, 0xa3, 0xe4, 0xf0, 0x90, 0x01, 0x10, 0xe0, 0x20, 0xe1, 0x03, 0x00, 
    0x80, 0xf6, 0x90, 0x01, 0x12, 0xe0, 0x20, 0xe1, 0x03, 0x00, 0x80, 0xf6, 0x22, 0xe4, 0xff, 0x74, 
    0x36, 0x2f, 0xf8, 0xe6, 0x90, 0x30, 0x8c, 0xf0, 0xef, 0x90, 0x1b, 0xec, 0x93, 0x90, 0x30, 0x8d, 
    0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x0f, 0xbf, 0x09, 0xe3, 0x22, 0xe4, 0xff, 0xef, 
    0x90, 0x1b, 0xf6, 0x93, 0x90, 0x30, 0x8c, 0xf0, 0xef, 0x90, 0x1b, 0xec, 0x93, 0x90, 0x30, 0x8d, 
    0xf0, 0xa3, 0x74, 0x01, 0xf0, 0xa3, 0xe4, 0xf0, 0x0f, 0xbf, 0x09, 0xe3, 0x22, 0xe4, 0x90, 0x00, 
    0x05, 0xf0, 0xef, 0x60, 0x02, 0x80, 0x02, 0x7f, 0x01, 0x90, 0x00, 0x06, 0xef, 0xf0, 0x90, 0x00, 
    0x04, 0x74, 0x51, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x44, 0x02, 0xf0, 0x22, 0x90, 0x30, 0xf0, 0xe0, 
    0xf5, 0x2a, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe4, 0x0e, 0x90, 0x30, 0xf2, 0xe0, 0x60, 0x08, 0x90, 
    0x00, 0x0a, 0x74, 0x10, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x30, 0xf0, 0xe0, 0xf5, 0x2a, 0x90, 
    0x00, 0x0a, 0xe0, 0x30, 0xe4, 0x0e, 0x90, 0x30, 0xf2, 0xe0, 0x70, 0x08, 0x90, 0x00, 0x0a, 0x74, 
    0x10, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x34, 0xce, 0xe0, 0x44, 0x02, 0xf0, 0x90, 0x34, 0xcd, 
    0xe0, 0x54, 0xfe, 0xf0, 0x90, 0x01, 0x00, 0xe0, 0x54, 0xf7, 0xf0, 0x90, 0x01, 0x01, 0xe0, 0x54, 
    0xbf, 0xf0, 0x22, 0x90, 0x00, 0x01, 0x74, 0x0e, 0xf0, 0x90, 0x34, 0x98, 0xe0, 0x54, 0xfb, 0xf0, 
    0x90, 0x34, 0x58, 0x74, 0x01, 0xf0, 0x90, 0x30, 0x30, 0x74, 0x04, 0xf0, 0x22, 0x02, 0x04, 0x0b, 
    0x16, 0x0c, 0x12, 0x18, 0x24, 0x30, 0x48, 0x60, 0x6c, 0x90, 0xc8, 0x00, 0x01, 0x02, 0x03, 0x0b, 
    0x0f, 0x0a, 0x0e, 0x09, 0x0d, 0x08, 0x0c, 0xef, 0xc4, 0x33, 0x33, 0x54, 0xc0, 0xff, 0x90, 0x01, 
    0x00, 0xe0, 0x54, 0x3f, 0x4f, 0xf0, 0x90, 0x01, 0x02, 0xe0, 0x44, 0x80, 0xf0, 0x22, 0x90, 0x01, 
    0x03, 0xe0, 0x30, 0xe7, 0x0c, 0x74, 0x80, 0xf0, 0x90, 0x01, 0x04, 0xe0, 0x54, 0x7f, 0xf0, 0xd3, 
    0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe1, 0x0c, 0x74, 0x02, 0xf0, 0x90, 0x00, 0x0b, 
    0xe0, 0x54, 0xfd, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe2, 0x0c, 0x74, 
    0x04, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xfb, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x00, 0x0a, 
    0xe0, 0x30, 0xe6, 0x0c, 0x74, 0x40, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 0x54, 0xbf, 0xf0, 0xd3, 0x22, 
    0xc3, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe7, 0x0c, 0x74, 0x80, 0xf0, 0x90, 0x00, 0x0b, 0xe0, 
    0x54, 0x7f, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x01, 0x05, 0xe0, 0x30, 0xe5, 0x0c, 0x74, 0x20, 
    0xf0, 0x90, 0x01, 0x06, 0xe0, 0x54, 0xdf, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x52, 0x53, 0x54, 0x12, 
    0x15, 0x16, 0x10, 0x11, 0x40, 0x00, 0x20, 0x00, 0x40, 0xff, 0x3f, 0x3f, 0xbd, 0x28, 0x21, 0x00, 
    0xe5, 0x34, 0x24, 0x11, 0xf5, 0x82, 0xe4, 0x35, 0x33, 0xf5, 0x83, 0xe0, 0x30, 0xe6, 0x02, 0xd3, 
    0x22, 0xc3, 0x22, 0x90, 0x30, 0x40, 0x74, 0x32, 0xf0, 0xa3, 0x74, 0xb0, 0xf0, 0xa3, 0x74, 0x01, 
    0xf0, 0xa3, 0xe4, 0xf0, 0x22, 0x0d, 0xc5, 0x14, 0x78, 0x16, 0x90, 0x13, 0x6a, 0x00, 0x09, 0x19, 
    0xb2, 0x12, 0x42, 0x1c, 0x64, 0x90, 0x30, 0x64, 0xe0, 0xfd, 0xa3, 0xe0, 0xfe, 0xed, 0x25, 0xe0, 
    0xff, 0xee, 0x33, 0xfe, 0x22, 0x90, 0x30, 0x40, 0x74, 0x32, 0xf0, 0xa3, 0x74, 0xb0, 0xf0, 0xa3, 
    0xe4, 0xf0, 0xa3, 0xf0, 0x22, 0x90, 0x01, 0x00, 0xe0, 0x44, 0x08, 0xf0, 0x90, 0x01, 0x01, 0xe0, 
    0x44, 0x40, 0xf0, 0x22, 0x12, 0x1b, 0x6e, 0x50, 0x08, 0xd2, 0x09, 0x12, 0x11, 0x9b, 0xe4, 0xf5, 
    0x2f, 0x22, 0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe0, 0x05, 0x74, 0x01, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 
    0x90, 0x00, 0x0a, 0xe0, 0x30, 0xe5, 0x05, 0x74, 0x20, 0xf0, 0xd3, 0x22, 0xc3, 0x22, 0x90, 0x34, 
    0x30, 0x74, 0x1f, 0xf0, 0xa3, 0xe4, 0xf0, 0xa3, 0xf0, 0xa3, 0xf0, 0x22, 0xc2, 0xaf, 0xc2, 0x8c, 
    0xc2, 0x8d, 0x12, 0x00, 0x0e, 0xd2, 0xaf, 0x22, 0xc2, 0x8e, 0x8e, 0x3f, 0x8f, 0x40, 0x12, 0x1c, 
    0xe9, 0xd2, 0x8e, 0x22, 0x90, 0x30, 0x3c, 0xef, 0xf0, 0xee, 0x44, 0x80, 0xa3, 0xf0, 0x22, 0x90, 
    0x30, 0x78, 0xe0, 0xfd, 0xa3, 0xe0, 0xfe, 0xed, 0xff, 0x22, 0xe5, 0x4a, 0x45, 0x49, 0x70, 0x03, 
    0xd3, 0x80, 0x01, 0xc3, 0x22, 0xe5, 0x4c, 0x45, 0x4b, 0x70, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x22, 
    0xc2, 0x0b, 0xe4, 0xf5, 0x14, 0x12, 0x17, 0x78, 0x22, 0xc2, 0x8f, 0x75, 0x8d, 0xf5, 0x75, 0x8b, 
    0x41, 0x22, 0x8e, 0x49, 0x8f, 0x4a, 0xd2, 0x8c, 0x22, 0x8e, 0x4b, 0x8f, 0x4c, 0xd2, 0x8c, 0x22, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc2, 0x0d, 0xe4, 0xf5, 0x2e, 0x22, 0x00, 0x00, 0x00, 0x00
};
#define	RT2661_FIRMIM_LEN		(sizeof (RT2661_FirmwareImage) / sizeof(UCHAR))

#define FIRMWARE_MAJOR_VERSION	0
#define FIRMWARE_MINOR_VERSION	8
// ===================  End of Tables of FirmareImage   =================

/*
	========================================================================
	
	Routine Description:
		Allocate RTMP_ADAPTER data block and do some initialization

	Arguments:
		Adapter		Pointer to our adapter

	Return Value:
		NDIS_STATUS_SUCCESS
		NDIS_STATUS_FAILURE

	Note:
	
	========================================================================
*/
NDIS_STATUS	RTMPAllocAdapterBlock(
	IN	PRTMP_ADAPTER	pAdapter)
{
	DBGPRINT(RT_DEBUG_TRACE, "--> RTMPAllocAdapterBlock\n");

	do
	{
		// Init spin locks
		NdisAllocateSpinLock(&pAdapter->TxRingLock);
		NdisAllocateSpinLock(&pAdapter->MgmtRingLock);
		NdisAllocateSpinLock(&pAdapter->RxRingLock);
        NdisAllocateSpinLock(&pAdapter->TxSwQueueLock);
	} while (FALSE);

	DBGPRINT(RT_DEBUG_TRACE, "<-- RTMPAllocAdapterBlock\n");
	
	return (NDIS_STATUS_SUCCESS);
}

/*
    ========================================================================

    Routine Description:
        Allocate all DMA releated resources

    Arguments:
        Adapter         Pointer to our adapter

    Return Value:
        None

    Note:

    ========================================================================
*/
NDIS_STATUS RTMPAllocDMAMemory(
    IN  PRTMP_ADAPTER   pAdapter)
{
	ULONG			RingBasePa;
	PVOID			RingBaseVa;
	INT             index, num;
	PTXD_STRUC		pTxD;
	PRXD_STRUC		pRxD;
	PRTMP_TX_RING   pTxRing;
    PRTMP_DMABUF    pDmaBuf;
    struct sk_buff	*pSkb;
    NDIS_STATUS     Status=NDIS_STATUS_SUCCESS;
    
	DBGPRINT(RT_DEBUG_TRACE, "--> RTMPAllocDMAMemory\n");
	do
	{
		//
		// Allocate all ring descriptors, include TxD, RxD, MgmtD.
		// Although each size is different, to prevent cacheline and alignment
		// issue, I intentional set them all to 64 bytes.
		//
		for (num=0; num<NUM_OF_TX_RING; num++)
		{
		    ULONG  BufBasePaLow;
		    PVOID  BufBaseVa;
		    
    		// 
    		// Allocate Tx ring descriptor's memory (5 TX rings = 4 ACs + 1 HCCA)
    		//
            pAdapter->TxDescRing[num].AllocSize = TX_RING_SIZE * TXD_SIZE;
    		pAdapter->TxDescRing[num].AllocVa
            	= pci_alloc_consistent(pAdapter->pPci_Dev, pAdapter->TxDescRing[num].AllocSize, &pAdapter->TxDescRing[num].AllocPa);

    		if (pAdapter->TxDescRing[num].AllocVa == NULL)
    		{
		    	DBGPRINT_ERR("Failed to allocate a big buffer\n");
                Status = NDIS_STATUS_RESOURCES;
    			break;
	    	}

    		// Zero init this memory block
	    	NdisZeroMemory(pAdapter->TxDescRing[num].AllocVa, pAdapter->TxDescRing[num].AllocSize);

    		// Save PA & VA for further operation
		    RingBasePa     = pAdapter->TxDescRing[num].AllocPa;
    		RingBaseVa     = pAdapter->TxDescRing[num].AllocVa;

    		// 
    		// Allocate all 1st TXBuf's memory for this TxRing
    		//
            pAdapter->TxBufSpace[num].AllocSize = TX_RING_SIZE * TX_DMA_1ST_BUFFER_SIZE;
    		pAdapter->TxBufSpace[num].AllocVa
            	= pci_alloc_consistent(pAdapter->pPci_Dev, pAdapter->TxBufSpace[num].AllocSize, &pAdapter->TxBufSpace[num].AllocPa);

    		if (pAdapter->TxBufSpace[num].AllocVa == NULL)
    		{
		    	DBGPRINT_ERR("Failed to allocate a big buffer\n");
		    	Status = NDIS_STATUS_RESOURCES;
    			break;
	    	}

    		// Zero init this memory block
	    	NdisZeroMemory(pAdapter->TxBufSpace[num].AllocVa, pAdapter->TxBufSpace[num].AllocSize);

    		// Save PA & VA for further operation
		    BufBasePaLow  = pAdapter->TxBufSpace[num].AllocPa;
    		BufBaseVa     = pAdapter->TxBufSpace[num].AllocVa;

    		//
	    	// Initialize Tx Ring Descriptor and associated buffer memory
		    //
		    pTxRing = &pAdapter->TxRing[num];
		    for (index = 0; index < TX_RING_SIZE; index++)
		    {
			    // Init Tx Ring Size, Va, Pa variables
			    pTxRing->Cell[index].AllocSize = TXD_SIZE;
			    pTxRing->Cell[index].AllocVa = RingBaseVa;
			    pTxRing->Cell[index].AllocPa = RingBasePa;

			    // Setup Tx Buffer size & address. only 802.11 header will store in this space
			    pDmaBuf = &pTxRing->Cell[index].DmaBuf;
                pDmaBuf->AllocSize = TX_DMA_1ST_BUFFER_SIZE;
                pDmaBuf->AllocVa = BufBaseVa;
                pDmaBuf->AllocPa = BufBasePaLow;
                
			    // link the pre-allocated TxBuf to TXD
			    pTxD = (PTXD_STRUC) pTxRing->Cell[index].AllocVa;
			    pTxD->BufCount = 1;
			    pTxD->BufPhyAddr0 = BufBasePaLow;

#ifdef BIG_ENDIAN
				RTMPDescriptorEndianChange((PUCHAR)pTxD, TYPE_TXD);
#endif
                // advance to next ring descriptor address
                RingBasePa += TXD_SIZE;
                RingBaseVa = (PUCHAR) RingBaseVa + TXD_SIZE;
            
                // advance to next TxBuf address
                BufBasePaLow += TX_DMA_1ST_BUFFER_SIZE;
                BufBaseVa = (PUCHAR) BufBaseVa + TX_DMA_1ST_BUFFER_SIZE;
		    }
            DBGPRINT(RT_DEBUG_TRACE, "TxRing[%d]: total %d entry allocated\n", num, index);
	    }

		//
		// Allocate MGMT ring descriptor's memory except Tx ring which allocated eariler
		//
		pAdapter->MgmtDescRing.AllocSize = MGMT_RING_SIZE * TXD_SIZE;
		pAdapter->MgmtDescRing.AllocVa
           	= pci_alloc_consistent(pAdapter->pPci_Dev, pAdapter->MgmtDescRing.AllocSize, &pAdapter->MgmtDescRing.AllocPa);

		if (pAdapter->MgmtDescRing.AllocVa == NULL)
		{
			DBGPRINT_ERR("Failed to allocate a big buffer\n");
			Status = NDIS_STATUS_RESOURCES;
			break;
		}

		// Zero init this memory block
		NdisZeroMemory(pAdapter->MgmtDescRing.AllocVa, pAdapter->MgmtDescRing.AllocSize);

		// Save PA & VA for further operation
		RingBasePa     = pAdapter->MgmtDescRing.AllocPa;
		RingBaseVa     = pAdapter->MgmtDescRing.AllocVa;

		//
		// Initialize MGMT Ring and associated buffer memory
		//
		for (index = 0; index < MGMT_RING_SIZE; index++)
		{
			// Init MGMT Ring Size, Va, Pa variables
			pAdapter->MgmtRing.Cell[index].AllocSize = TXD_SIZE;
			pAdapter->MgmtRing.Cell[index].AllocVa = RingBaseVa;
			pAdapter->MgmtRing.Cell[index].AllocPa = RingBasePa;

            // Offset to next ring descriptor address
            RingBasePa += TXD_SIZE;
            RingBaseVa = (PUCHAR) RingBaseVa + TXD_SIZE;

            // no pre-allocated buffer required in MgmtRing for scatter-gather case
		}
        DBGPRINT(RT_DEBUG_TRACE, "MGMT Ring: total %d entry allocated\n", index);

		//
		// Allocate RX ring descriptor's memory except Tx ring which allocated eariler
		//
		pAdapter->RxDescRing.AllocSize = RX_RING_SIZE * RXD_SIZE;
		pAdapter->RxDescRing.AllocVa
           	= pci_alloc_consistent(pAdapter->pPci_Dev, pAdapter->RxDescRing.AllocSize, &pAdapter->RxDescRing.AllocPa);

		if (pAdapter->RxDescRing.AllocVa == NULL)
		{
			DBGPRINT_ERR("Failed to allocate a big buffer\n");
			Status = NDIS_STATUS_RESOURCES;
			break;
		}

		// Zero init this memory block
		NdisZeroMemory(pAdapter->RxDescRing.AllocVa, pAdapter->RxDescRing.AllocSize);

		// Save PA & VA for further operation
		RingBasePa     = pAdapter->RxDescRing.AllocPa;
		RingBaseVa     = pAdapter->RxDescRing.AllocVa;

		//
		// Initialize Rx Ring and associated buffer memory
		//
		for (index = 0; index < RX_RING_SIZE; index++)
		{
			// Init RX Ring Size, Va, Pa variables
			pAdapter->RxRing.Cell[index].AllocSize = RXD_SIZE;
			pAdapter->RxRing.Cell[index].AllocVa = RingBaseVa;
			pAdapter->RxRing.Cell[index].AllocPa = RingBasePa;

            // Offset to next ring descriptor address
            RingBasePa += RXD_SIZE;
            RingBaseVa = (PUCHAR) RingBaseVa + RXD_SIZE;

			// Setup Rx associated Buffer size & allocate share memory
			pDmaBuf = &pAdapter->RxRing.Cell[index].DmaBuf;
			pDmaBuf->AllocSize = RX_DMA_BUFFER_SIZE;
			
			pSkb = __dev_alloc_skb(pDmaBuf->AllocSize, MEM_ALLOC_FLAG);
			RTMP_SET_PACKET_SOURCE(pSkb, PKTSRC_DRIVER);
			pDmaBuf->pSkb    = pSkb;
			pDmaBuf->AllocVa = pSkb->data;
			pDmaBuf->AllocPa = pci_map_single(pAdapter->pPci_Dev, (PVOID)pSkb->data, pDmaBuf->AllocSize, PCI_DMA_FROMDEVICE);

			// Error handling
			if (pDmaBuf->AllocVa == NULL)
			{
				DBGPRINT_ERR("Failed to allocate RxRing's 1st buffer\n");
				Status = NDIS_STATUS_RESOURCES;
				break;
			}

			// Zero init this memory block
			NdisZeroMemory(pDmaBuf->AllocVa, pDmaBuf->AllocSize);
            
			// Write RxD buffer address & allocated buffer length
			pRxD = (PRXD_STRUC) pAdapter->RxRing.Cell[index].AllocVa;
			pRxD->BufPhyAddr = pDmaBuf->AllocPa;

			// Rx owner bit assign to NIC immediately
			pRxD->Owner = DESC_OWN_NIC;

#ifdef BIG_ENDIAN
			RTMPDescriptorEndianChange((PUCHAR)pRxD, TYPE_RXD);
#endif			
		}
        DBGPRINT(RT_DEBUG_TRACE, "Rx Ring: total %d entry allocated\n", index);

	}	while (FALSE);

	DBGPRINT(RT_DEBUG_TRACE, "<-- RTMPAllocDMAMemory\n");

    return Status;
}

/*
    ========================================================================

    Routine Description:
        Free all DMA memory.

    Arguments:
        Adapter         Pointer to our adapter

    Return Value:
        None

    Note:

    ========================================================================
*/
VOID    RTMPFreeDMAMemory(
    IN  PRTMP_ADAPTER   pAdapter)
{
	INT		    index, num;

	DBGPRINT(RT_DEBUG_TRACE, "--> RTMPFreeDMAMemory\n");

	//
	// Free RX Ring related space
	//
	for (index = RX_RING_SIZE - 1 ; index >= 0; index--)
	{
		if ((pAdapter->RxRing.Cell[index].DmaBuf.AllocVa) && (pAdapter->RxRing.Cell[index].DmaBuf.pSkb))
		{
			pci_unmap_single(pAdapter->pPci_Dev, pAdapter->RxRing.Cell[index].DmaBuf.AllocPa, pAdapter->RxRing.Cell[index].DmaBuf.AllocSize, PCI_DMA_FROMDEVICE);
			RELEASE_NDIS_PACKET(pAdapter, pAdapter->RxRing.Cell[index].DmaBuf.pSkb);
		}
	}
	NdisZeroMemory(pAdapter->RxRing.Cell, RX_RING_SIZE * sizeof(RTMP_DMACB));

    if (pAdapter->RxDescRing.AllocVa)
    {
    	pci_free_consistent(pAdapter->pPci_Dev, pAdapter->RxDescRing.AllocSize,
			pAdapter->RxDescRing.AllocVa, pAdapter->RxDescRing.AllocPa);
    }
    NdisZeroMemory(&pAdapter->RxDescRing, sizeof(RTMP_DMABUF));

	//
	// Free MGMT Ring related space
	//
	if (pAdapter->MgmtDescRing.AllocVa)
	{
		pci_free_consistent(pAdapter->pPci_Dev, pAdapter->MgmtDescRing.AllocSize,
			pAdapter->MgmtDescRing.AllocVa, pAdapter->MgmtDescRing.AllocPa);
	}
	NdisZeroMemory(&pAdapter->MgmtDescRing, sizeof(RTMP_DMABUF));

	//
	// Free TX Ring buffer
	//
	for (num = 0; num < NUM_OF_TX_RING; num++)
	{
    	if (pAdapter->TxBufSpace[num].AllocVa)
	    {
	    	pci_free_consistent(pAdapter->pPci_Dev, pAdapter->TxBufSpace[num].AllocSize,
				pAdapter->TxBufSpace[num].AllocVa, pAdapter->TxBufSpace[num].AllocPa);
	    }
	    NdisZeroMemory(&pAdapter->TxBufSpace[num], sizeof(RTMP_DMABUF));
	    
    	if (pAdapter->TxDescRing[num].AllocVa)
	    {
	    	pci_free_consistent(pAdapter->pPci_Dev, pAdapter->TxDescRing[num].AllocSize,
				pAdapter->TxDescRing[num].AllocVa, pAdapter->TxDescRing[num].AllocPa);
	    }
	    NdisZeroMemory(&pAdapter->TxDescRing[num], sizeof(RTMP_DMABUF));
	}

	//
	// Free preallocated shared memory
	//
    NdisFreeSpinLock(&pAdapter->TxSwQueueLock);
	NdisFreeSpinLock(&pAdapter->RxRingLock);
	NdisFreeSpinLock(&pAdapter->MgmtRingLock);
	NdisFreeSpinLock(&pAdapter->TxRingLock);

	DBGPRINT(RT_DEBUG_TRACE, "<-- RTMPFreeDMAMemory\n");
}

// By removing 'inline' directive from the function definitions. 
// Then Driverloader is compiled and runs smooth after kernel 2.6.9
#ifdef BIG_ENDIAN
inline VOID
#else
VOID
#endif
NICDisableInterrupt(    
    IN  PRTMP_ADAPTER   pAdapter)
{
    RTMP_IO_WRITE32(pAdapter, INT_MASK_CSR, 0xffffff7f);     // 0xffffff7f
    RTMP_IO_WRITE32(pAdapter, MCU_INT_MASK_CSR, 0xffffffff);
    RTMP_CLEAR_FLAG(pAdapter, fRTMP_ADAPTER_INTERRUPT_ACTIVE);
}

#ifdef BIG_ENDIAN
inline VOID
#else
VOID
#endif
NICEnableInterrupt(
    IN  PRTMP_ADAPTER   pAdapter)
{
    //
	// Flag "fOP_STATUS_DOZE" On, means ASIC put to sleep, else means ASIC WakeUp
	// To prevent System hang, we should enalbe the interrupt when
	// ASIC is already Wake Up.
	//
    if (!OPSTATUS_TEST_FLAG(pAdapter, fOP_STATUS_DOZE))
	{
		RTMP_IO_WRITE32(pAdapter, INT_MASK_CSR, 0x0000ff10);     // 0x0000ff00
	}
    RTMP_IO_WRITE32(pAdapter, MCU_INT_MASK_CSR, 0x00000000); // 0x000001ff
    RTMP_SET_FLAG(pAdapter, fRTMP_ADAPTER_INTERRUPT_ACTIVE);
}

/*
	========================================================================
	
	Routine Description:
		Initialize transmit data structures

	Arguments:
		Adapter						Pointer to our adapter

	Return Value:
		None

	Note:
		Initialize all transmit releated private buffer, include those define
		in RTMP_ADAPTER structure and all private data structures.
		
	========================================================================
*/
VOID	NICInitTxRxRingAndBacklogQueue(
	IN	PRTMP_ADAPTER	pAdapter)
{
	DBGPRINT(RT_DEBUG_TRACE, "<--> NICInitTxRxRingAndBacklogQueue\n");

    // Initialize all transmit related software queues
    InitializeQueueHeader(&pAdapter->TxSwQueue[QID_AC_BE]);
    InitializeQueueHeader(&pAdapter->TxSwQueue[QID_AC_BK]);
    InitializeQueueHeader(&pAdapter->TxSwQueue[QID_AC_VI]);
    InitializeQueueHeader(&pAdapter->TxSwQueue[QID_AC_VO]);
    InitializeQueueHeader(&pAdapter->TxSwQueue[QID_HCCA]);
    
	// Init RX Ring index pointer
	pAdapter->RxRing.CurRxIndex           = 0;
	
    // Init TX rings index pointer
    {
        INT i;
        for (i=0; i<NUM_OF_TX_RING; i++)
        {
	        pAdapter->TxRing[i].CurTxIndex         = 0;
            pAdapter->TxRing[i].NextTxDmaDoneIndex = 0;
        }
    }

    // init MGMT ring index pointer
    pAdapter->MgmtRing.CurTxIndex              = 0;
    pAdapter->MgmtRing.NextTxDmaDoneIndex      = 0;
        
	pAdapter->PrivateInfo.TxRingFullCnt       = 0;
}

/*
    ========================================================================

    Routine Description:
        Read initial parameters from EEPROM

    Arguments:
        Adapter                     Pointer to our adapter

    Return Value:
        None

    Note:
        
    ========================================================================
*/
VOID    NICReadEEPROMParameters(
    IN  PRTMP_ADAPTER   pAd)
{
	ULONG			data;
	USHORT			i, value, value2;
	UCHAR           TmpPhy;
	EEPROM_TX_PWR_STRUC	    Power;
    EEPROM_VERSION_STRUC    Version;
	EEPROM_ANTENNA_STRUC	Antenna;
	EEPROM_LED_STRUC		LedSetting;

	DBGPRINT(RT_DEBUG_TRACE, "--> NICReadEEPROMParameters\n");

	// Init EEPROM Address Number, before access EEPROM; if 93c46, EEPROMAddressNum=6, else if 93c66, EEPROMAddressNum=8
	RTMP_IO_READ32(pAd, E2PROM_CSR, &data);

	if(data & 0x20)
		pAd->EEPROMAddressNum = 6;		// 93C46
	else
		pAd->EEPROMAddressNum = 8;     // 93C66

    // RT2660 MAC no longer auto load MAC address from E2PROM. Driver has to intialize
    // MAC address registers according to E2PROM setting
    {
        USHORT  Addr01,Addr23,Addr45 ;

        Addr01=RTMP_EEPROM_READ16(pAd, 0x04);
        Addr23=RTMP_EEPROM_READ16(pAd, 0x06);
        Addr45=RTMP_EEPROM_READ16(pAd, 0x08);

        pAd->PermanentAddress[0] = (UCHAR)(Addr01 & 0xff);
        pAd->PermanentAddress[1] = (UCHAR)(Addr01 >> 8);
        pAd->PermanentAddress[2] = (UCHAR)(Addr23 & 0xff);
        pAd->PermanentAddress[3] = (UCHAR)(Addr23 >> 8);
        pAd->PermanentAddress[4] = (UCHAR)(Addr45 & 0xff);
        pAd->PermanentAddress[5] = (UCHAR)(Addr45 >> 8);

        if (pAd->bLocalAdminMAC == FALSE)
        {
            MAC_CSR2_STRUC csr2;
            MAC_CSR3_STRUC csr3;
            COPY_MAC_ADDR(pAd->CurrentAddress, pAd->PermanentAddress);
            csr2.field.Byte0 = pAd->CurrentAddress[0];
            csr2.field.Byte1 = pAd->CurrentAddress[1];
            csr2.field.Byte2 = pAd->CurrentAddress[2];
            csr2.field.Byte3 = pAd->CurrentAddress[3];
            RTMP_IO_WRITE32(pAd, MAC_CSR2, csr2.word);
            csr3.word = 0;
            csr3.field.Byte4 = pAd->CurrentAddress[4];
            csr3.field.Byte5 = pAd->CurrentAddress[5];
            csr3.field.U2MeMask = 0xff;
            RTMP_IO_WRITE32(pAd, MAC_CSR3, csr3.word);
        }
    }    
    DBGPRINT(RT_DEBUG_TRACE,"E2PROM: MAC=%02x:%02x:%02x:%02x:%02x:%02x\n",
        pAd->PermanentAddress[0], pAd->PermanentAddress[1], 
        pAd->PermanentAddress[2], pAd->PermanentAddress[3], 
        pAd->PermanentAddress[4], pAd->PermanentAddress[5]);
        
            
    // Init the channel number for TX channel power
    // 0. 11b/g
    for (i = 0; i < 14; i++)
        pAd->TxPower[i].Channel = i + 1;
    // 1. UNI 36 - 64
    for (i = 0; i < 8; i++)
        pAd->TxPower[i + 14].Channel = 36 + i * 4;
    // 2. HipperLAN 2 100 - 140
    for (i = 0; i < 11; i++)
        pAd->TxPower[i + 22].Channel = 100 + i * 4;
    // 3. UNI 140 - 165
    for (i = 0; i < 5; i++)
        pAd->TxPower[i + 33].Channel = 149 + i * 4;        

    // if E2PROM version mismatch with driver's expectation, then skip
    // all subsequent E2RPOM retieval and set a system error bit to notify GUI
    Version.word = RTMP_EEPROM_READ16(pAd, EEPROM_VERSION_OFFSET);
    pAd->EepromVersion = Version.field.Version + Version.field.FaeReleaseNumber * 256;
    DBGPRINT(RT_DEBUG_TRACE, "E2PROM: Version = %d, FAE release #%d\n", Version.field.Version, Version.field.FaeReleaseNumber);
    
    if (Version.field.Version > VALID_EEPROM_VERSION)
    {
        DBGPRINT_ERR("E2PROM: WRONG VERSION %d, should be %d\n",Version.field.Version, VALID_EEPROM_VERSION);
        pAd->SystemErrorBitmap |= 0x00000001;

        // hard-code default value when no proper E2PROM installed
        pAd->bAutoTxAgcA = FALSE;
        pAd->bAutoTxAgcG = FALSE;
        
        // Default the channel power
        for (i = 0; i < MAX_NUM_OF_CHANNELS; i++)
            pAd->TxPower[i].Power = DEFAULT_RF_TX_POWER;
    
        pAd->RfIcType = RFIC_5225;
        for(i = 0; i < NUM_EEPROM_BBP_PARMS; i++)
            pAd->EEPROMDefaultValue[i] = 0xffff;
        return;
    }

	// Read BBP default value from EEPROM and store to array(EEPROMDefaultValue) in pAd
	for(i = 0; i < NUM_EEPROM_BBP_PARMS; i++)
	{
		value = RTMP_EEPROM_READ16(pAd, EEPROM_BBP_BASE_OFFSET + i*2);
		
		pAd->EEPROMDefaultValue[i] = value;
	}

	// We have to parse NIC configuration 0 at here.
	// If TSSI did not have preloaded value, it should reset the TxAutoAgc to false
	// Therefore, we have to read TxAutoAgc control beforehand.
	// Read Tx AGC control bit
	Antenna.word = pAd->EEPROMDefaultValue[0];
	if (Antenna.field.DynamicTxAgcControl == 1)
		pAd->bAutoTxAgcA = pAd->bAutoTxAgcG = TRUE;
	else
		pAd->bAutoTxAgcA = pAd->bAutoTxAgcG = FALSE;		
	
	//
	// Reset PhyMode if we don't support 802.11a
	//
	if ((pAd->PortCfg.PhyMode == PHY_11ABG_MIXED) || (pAd->PortCfg.PhyMode == PHY_11A))
	{
		//
		// Only RFIC_5225 & RFIC_5325 support 802.11a
		//
		if ((Antenna.field.RfIcType != RFIC_5225) && (Antenna.field.RfIcType != RFIC_5325))
			pAd->PortCfg.PhyMode = PHY_11BG_MIXED;
	}
	
#if 0   // Hard set without switching in case of MIMO
	if ((Antenna.field.RfIcType != RFIC_5325) || (Antenna.field.RfIcType != RFIC_2529))
	{
	    //
	    // MIMO Case, RSSI_A+RSSI_B
	    //
		pAd->Mlme.bTxRateReportPeriod = FALSE;
		RTMP_IO_WRITE32(pAd, TXRX_CSR1, 0x9eb39eb3);
	}
	else
	{
	    //
	    // Otherwise, RSSI+RxRate.
	    //
		pAd->Mlme.bTxRateReportPeriod = TRUE;
		RTMP_IO_WRITE32(pAd, TXRX_CSR1, 0x9eaa9eaf);
	}
#endif

	// Read Tx power value for all channels
	// Value from 1 - 0x7f. Default value is 24.
	// 0. 11b/g
	for (i = 0; i < 7; i++)
	{
		Power.word = RTMP_EEPROM_READ16(pAd, EEPROM_G_TX_PWR_OFFSET + i * 2);
		pAd->TxPower[i * 2].Power     = ((Power.field.Byte0 > 32) ? DEFAULT_RF_TX_POWER : Power.field.Byte0);
		pAd->TxPower[i * 2 + 1].Power = ((Power.field.Byte1 > 32) ? DEFAULT_RF_TX_POWER : Power.field.Byte1);
	}
	// 1. UNI 36 - 64, HipperLAN 2 100 - 140, UNI 140 - 165
	for (i = 0; i < 12; i++)
	{
		Power.word = RTMP_EEPROM_READ16(pAd, EEPROM_A_TX_PWR_OFFSET + i * 2);
		pAd->TxPower[i * 2 + 14].Power = ((Power.field.Byte0 > 32) ? DEFAULT_RF_TX_POWER : Power.field.Byte0);
		pAd->TxPower[i * 2 + 15].Power = ((Power.field.Byte1 > 32) ? DEFAULT_RF_TX_POWER : Power.field.Byte1);
	}

	// Read TSSI reference and TSSI boundary for temperature compensation. This is ugly
	// 0. 11b/g
	{
		Power.word = RTMP_EEPROM_READ16(pAd, 0x54);
		pAd->TssiMinusBoundaryG[4] = Power.field.Byte0;
		pAd->TssiMinusBoundaryG[3] = Power.field.Byte1;
		Power.word = RTMP_EEPROM_READ16(pAd, 0x56);
		pAd->TssiMinusBoundaryG[2] = Power.field.Byte0;
		pAd->TssiMinusBoundaryG[1] = Power.field.Byte1;
		Power.word = RTMP_EEPROM_READ16(pAd, 0x58);
		pAd->TssiPlusBoundaryG[1] = Power.field.Byte0;
		pAd->TssiPlusBoundaryG[2] = Power.field.Byte1;
		Power.word = RTMP_EEPROM_READ16(pAd, 0x5a);
		pAd->TssiPlusBoundaryG[3] = Power.field.Byte0;
		pAd->TssiPlusBoundaryG[4] = Power.field.Byte1;
        Power.word = RTMP_EEPROM_READ16(pAd, 0x5c);
        pAd->TssiRefG   = Power.field.Byte0;
        pAd->TxAgcStepG = Power.field.Byte1;    
        pAd->TxAgcCompensateG = 0;
        pAd->TssiMinusBoundaryG[0] = pAd->TssiRefG;
        pAd->TssiPlusBoundaryG[0]  = pAd->TssiRefG;

		// Disable TxAgc if the based value is not right
		if (pAd->TssiRefG == 0xff)
			pAd->bAutoTxAgcG = FALSE;

        DBGPRINT(RT_DEBUG_TRACE,"E2PROM: G Tssi[-4 .. +4] = %d %d %d %d - %d -%d %d %d %d, step=%d, tuning=%d\n",
            pAd->TssiMinusBoundaryG[4], pAd->TssiMinusBoundaryG[3], pAd->TssiMinusBoundaryG[2], pAd->TssiMinusBoundaryG[1],
            pAd->TssiRefG,
            pAd->TssiPlusBoundaryG[1], pAd->TssiPlusBoundaryG[2], pAd->TssiPlusBoundaryG[3], pAd->TssiPlusBoundaryG[4],
            pAd->TxAgcStepG, pAd->bAutoTxAgcG);
	}	
	// 1. 11a
	{
		Power.word = RTMP_EEPROM_READ16(pAd, 0x90);
		pAd->TssiMinusBoundaryA[4] = Power.field.Byte0;
		pAd->TssiMinusBoundaryA[3] = Power.field.Byte1;
		Power.word = RTMP_EEPROM_READ16(pAd, 0x92);
		pAd->TssiMinusBoundaryA[2] = Power.field.Byte0;
		pAd->TssiMinusBoundaryA[1] = Power.field.Byte1;
		Power.word = RTMP_EEPROM_READ16(pAd, 0x94);
		pAd->TssiPlusBoundaryA[1] = Power.field.Byte0;
		pAd->TssiPlusBoundaryA[2] = Power.field.Byte1;
		Power.word = RTMP_EEPROM_READ16(pAd, 0x96);
		pAd->TssiPlusBoundaryA[3] = Power.field.Byte0;
		pAd->TssiPlusBoundaryA[4] = Power.field.Byte1;
        Power.word = RTMP_EEPROM_READ16(pAd, 0x98);
        pAd->TssiRefA   = Power.field.Byte0;
        pAd->TxAgcStepA = Power.field.Byte1;    
        pAd->TxAgcCompensateA = 0;
        pAd->TssiMinusBoundaryA[0] = pAd->TssiRefA;
        pAd->TssiPlusBoundaryA[0]  = pAd->TssiRefA;

		// Disable TxAgc if the based value is not right
		if (pAd->TssiRefA == 0xff)
			pAd->bAutoTxAgcA = FALSE;

        DBGPRINT(RT_DEBUG_TRACE,"E2PROM: A Tssi[-4 .. +4] = %d %d %d %d - %d -%d %d %d %d, step=%d, tuning=%d\n",
            pAd->TssiMinusBoundaryA[4], pAd->TssiMinusBoundaryA[3], pAd->TssiMinusBoundaryA[2], pAd->TssiMinusBoundaryA[1],
            pAd->TssiRefA,
            pAd->TssiPlusBoundaryA[1], pAd->TssiPlusBoundaryA[2], pAd->TssiPlusBoundaryA[3], pAd->TssiPlusBoundaryA[4],
            pAd->TxAgcStepA, pAd->bAutoTxAgcA);
	}	
    pAd->BbpRssiToDbmDelta = 0x79;
	
	// Read frequency offset and RF programming sequence setting for RT5225
    value = RTMP_EEPROM_READ16(pAd, EEPROM_FREQ_OFFSET);
	if ((value & 0xFF00) == 0xFF00)
	{
		pAd->RFProgSeq = 0;
	}
	else
	{
		pAd->RFProgSeq = (value & 0x0300) >> 8;	// bit 8,9
	}
	
	value &= 0x00FF;
	if (value != 0x00FF)
		pAd->RfFreqOffset = (ULONG) value;
	else
		pAd->RfFreqOffset = 0;
	DBGPRINT(RT_DEBUG_TRACE, "E2PROM: RF freq offset=0x%x, RF programming seq=%d\n", pAd->RfFreqOffset,pAd->RFProgSeq);

	//CountryRegion byte offset = 0x25
	value = pAd->EEPROMDefaultValue[2] >> 8;
	value2 = pAd->EEPROMDefaultValue[2] & 0x00FF;
	if ((value <= 6) && (value2 <= 7))
	{
		pAd->PortCfg.CountryRegion = ((UCHAR) value) | 0x80;
		pAd->PortCfg.CountryRegionForABand = ((UCHAR) value2) | 0x80;
		TmpPhy = pAd->PortCfg.PhyMode;
    	pAd->PortCfg.PhyMode = 0xff;
		RTMPSetPhyMode(pAd, TmpPhy);
	}
	
	//
	// Get RSSI Offset on EEPROM 0x9Ah & 0x9Ch.
	// The valid value are (-10 ~ 10) 
	// 
	value = RTMP_EEPROM_READ16(pAd, EEPROM_RSSI_BG_OFFSET);
	pAd->BGRssiOffset1 = value & 0x00ff;
	pAd->BGRssiOffset2 = (value >> 8);

	// Validate 11b/g RSSI_1 offset.
	if ((pAd->BGRssiOffset1 < -10) || (pAd->BGRssiOffset1 > 10))
		pAd->BGRssiOffset1 = 0;

	// Validate 11b/g RSSI_2 offset.
	if ((pAd->BGRssiOffset2 < -10) || (pAd->BGRssiOffset2 > 10))
		pAd->BGRssiOffset2 = 0;
		
	value = RTMP_EEPROM_READ16(pAd, EEPROM_RSSI_A_OFFSET);
	pAd->ARssiOffset1 = value & 0x00ff;
	pAd->ARssiOffset2 = (value >> 8);

	// Validate 11a RSSI_1 offset.
	if ((pAd->ARssiOffset1 < -10) || (pAd->ARssiOffset1 > 10))
		pAd->ARssiOffset1 = 0;

	//Validate 11a RSSI_2 offset.
	if ((pAd->ARssiOffset2 < -10) || (pAd->ARssiOffset2 > 10))
		pAd->ARssiOffset2 = 0;

	//
	// Get LED Setting.
	//
	LedSetting.word = RTMP_EEPROM_READ16(pAd, EEPROM_LED_OFFSET);
	if (LedSetting.word == 0xFFFF)
	{
		//
		// Set it to Default.
		//
		LedSetting.field.PolarityRDY_G = 1;   // Active High.
		LedSetting.field.PolarityRDY_A = 1;   // Active High.
		LedSetting.field.PolarityACT = 1;    // Active High.
		LedSetting.field.PolarityGPIO_0 = 1; // Active High.
		LedSetting.field.PolarityGPIO_1 = 1; // Active High.
		LedSetting.field.PolarityGPIO_2 = 1; // Active High.
		LedSetting.field.PolarityGPIO_3 = 1; // Active High.
		LedSetting.field.PolarityGPIO_4 = 1; // Active High.
		LedSetting.field.LedMode = LED_MODE_DEFAULT;		
	}
	pAd->LedCntl.word = 0;
	pAd->LedCntl.field.LedMode = LedSetting.field.LedMode;
	pAd->LedCntl.field.PolarityRDY_G = LedSetting.field.PolarityRDY_G;
	pAd->LedCntl.field.PolarityRDY_A = LedSetting.field.PolarityRDY_A;
	pAd->LedCntl.field.PolarityACT = LedSetting.field.PolarityACT;
	pAd->LedCntl.field.PolarityGPIO_0 = LedSetting.field.PolarityGPIO_0;
	pAd->LedCntl.field.PolarityGPIO_1 = LedSetting.field.PolarityGPIO_1;
	pAd->LedCntl.field.PolarityGPIO_2 = LedSetting.field.PolarityGPIO_2;
	pAd->LedCntl.field.PolarityGPIO_3 = LedSetting.field.PolarityGPIO_3;
	pAd->LedCntl.field.PolarityGPIO_4 = LedSetting.field.PolarityGPIO_4;
		
	value = RTMP_EEPROM_READ16(pAd, EEPROM_TXPOWER_DELTA_OFFSET);
	value = value & 0x00ff;
	if (value != 0xff)
	{
		pAd->TxPowerDeltaConfig.value = (UCHAR) value;
		if (pAd->TxPowerDeltaConfig.field.DeltaValue > 0x04)
			pAd->TxPowerDeltaConfig.field.DeltaValue = 0x04;
	}
	else
		pAd->TxPowerDeltaConfig.field.TxPowerEnable = FALSE;

	DBGPRINT(RT_DEBUG_TRACE, "<-- NICReadEEPROMParameters\n");
}

/*
    ========================================================================

    Routine Description:
        Set default value from EEPROM

    Arguments:
        Adapter                     Pointer to our adapter

    Return Value:
        None

    Note:

    ========================================================================
*/
VOID    NICInitAsicFromEEPROM(
    IN  PRTMP_ADAPTER   pAd)
{
    ULONG					data;
	USHORT					i;
	EEPROM_ANTENNA_STRUC	Antenna;
	EEPROM_NIC_CONFIG2_STRUC    NicConfig2;

	DBGPRINT(RT_DEBUG_TRACE, "--> NICInitAsicFromEEPROM\n");

   	for(i = 3; i < NUM_EEPROM_BBP_PARMS; i++)
    {
        UCHAR BbpRegIdx, BbpValue;
	
   		if ((pAd->EEPROMDefaultValue[i] != 0xFFFF) && (pAd->EEPROMDefaultValue[i] != 0))
    	{
    	    BbpRegIdx = (UCHAR)(pAd->EEPROMDefaultValue[i] >> 8);
    	    BbpValue  = (UCHAR)(pAd->EEPROMDefaultValue[i] & 0xff);
    	    RTMP_BBP_IO_WRITE8_BY_REG_ID(pAd, BbpRegIdx, BbpValue);
   		}
    }
    
	Antenna.word = pAd->EEPROMDefaultValue[0];

	if (Antenna.word == 0xFFFF)
	{
	    Antenna.word = 0;
        Antenna.field.RfIcType = RFIC_5225;
        Antenna.field.HardwareRadioControl = 0;     // no hardware control
        Antenna.field.DynamicTxAgcControl = 0;
        Antenna.field.RxDefaultAntenna = 2;         // Ant-B
        Antenna.field.TxDefaultAntenna = 2;         // Ant-B
        Antenna.field.NumOfAntenna = 2;
        DBGPRINT(RT_DEBUG_TRACE, "E2PROM, Antenna parameter error, hard code as 0x%04x\n", Antenna.word);
	}

    pAd->RfIcType = (UCHAR) Antenna.field.RfIcType;
    printk("RT61: RfIcType= %d\n", pAd->RfIcType);

	// Save the antenna for future use
	pAd->Antenna.word = Antenna.word;
	    
    // Read Hardware controlled Radio state enable bit
    if (Antenna.field.HardwareRadioControl == 1)
	{
	    pAd->PortCfg.bHardwareRadio = TRUE;
		
	    // Read GPIO pin5 as Hardware controlled radio state
	    RTMP_IO_READ32(pAd, MAC_CSR13, &data);
	    if ((data & 0x20) == 0)
	    {
		    pAd->PortCfg.bHardwareRadio = FALSE;
		    pAd->PortCfg.bRadio = FALSE;
		    RTMP_IO_WRITE32(pAd, MAC_CSR10, 0x00001818);
		    RTMP_SET_FLAG(pAd, fRTMP_ADAPTER_RADIO_OFF);
	    }
    }
    else
	    pAd->PortCfg.bHardwareRadio = FALSE;	

	if (pAd->PortCfg.bRadio == FALSE)
	{
		RTMPSetLED(pAd, LED_RADIO_OFF);
	}
	else
	{
		RTMPSetLED(pAd, LED_RADIO_ON);
	}
	
	NicConfig2.word = pAd->EEPROMDefaultValue[1];
	if (NicConfig2.word == 0xffff)
	{
		NicConfig2.word = 0;
	}
	// Save the antenna for future use
	pAd->NicConfig2.word = NicConfig2.word;
	
    //
	// Since BBP has been progamed, to make sure BBP setting will be 
	// upate inside of AsicAntennaSelect, so reset to UNKNOWN_BAND!!
	//
	pAd->PortCfg.BandState = UNKNOWN_BAND;
    DBGPRINT(RT_DEBUG_TRACE,"Use Hw Radio Control Pin=%d; if used Pin=%d;\n",
        pAd->PortCfg.bHardwareRadio, pAd->PortCfg.bHardwareRadio);
        
   	DBGPRINT(RT_DEBUG_TRACE, "RFIC=%d, LED mode=%d\n", pAd->RfIcType, pAd->LedCntl.field.LedMode);

	DBGPRINT(RT_DEBUG_TRACE, "<-- NICInitAsicFromEEPROM\n");
}

NDIS_STATUS NICInitializeAdapter(
	IN PRTMP_ADAPTER   pAdapter)
{
	TX_RING_CSR0_STRUC TxCsr0;
	TX_RING_CSR1_STRUC TxCsr1;
	RX_RING_CSR_STRUC  RxCsr;
	ULONG			Value;
    NDIS_STATUS     Status = NDIS_STATUS_SUCCESS;

	DBGPRINT(RT_DEBUG_TRACE, "--> NICInitializeAdapter\n");

    //
    // write all shared Ring's base address into ASIC
    //
    
    // Write AC_BK base address register
    Value = pAdapter->TxRing[QID_AC_BK].Cell[0].AllocPa;
    RTMP_IO_WRITE32(pAdapter, AC1_BASE_CSR, Value);
            
    // Write AC_BE base address register
    Value = pAdapter->TxRing[QID_AC_BE].Cell[0].AllocPa;
    RTMP_IO_WRITE32(pAdapter, AC0_BASE_CSR, Value);
            
    // Write AC_VI base address register
    Value = pAdapter->TxRing[QID_AC_VI].Cell[0].AllocPa;
    RTMP_IO_WRITE32(pAdapter, AC2_BASE_CSR, Value);
            
    // Write AC_VO base address register
    Value = pAdapter->TxRing[QID_AC_VO].Cell[0].AllocPa;
    RTMP_IO_WRITE32(pAdapter, AC3_BASE_CSR, Value);
            
    // Write HCCA base address register
    //  Value = pci_map_single(pAdapter->pPci_Dev, pAdapter->TxRing[QID_HCCA].Cell[0].AllocVa, 
    //                         pAdapter->TxRing[QID_HCCA].Cell[0].AllocSize, PCI_DMA_TODEVICE);
    //  RTMP_IO_WRITE32(pAdapter, HCCA_BASE_CSR, Value);
            
    // Write MGMT_BASE_CSR register
    Value = pAdapter->MgmtRing.Cell[0].AllocPa;
    RTMP_IO_WRITE32(pAdapter, MGMT_BASE_CSR, Value);
            
    // Write RX_BASE_CSR register
    Value = pAdapter->RxRing.Cell[0].AllocPa;
    RTMP_IO_WRITE32(pAdapter, RX_BASE_CSR, Value);

    //
    // set each Ring's SIZE and DESCRIPTOR size into ASIC
    //
    
	// Write TX_RING_CSR0 register
	TxCsr0.word = 0;
	TxCsr0.field.Ac0Total = TX_RING_SIZE;
	TxCsr0.field.Ac1Total = TX_RING_SIZE;
	TxCsr0.field.Ac2Total = TX_RING_SIZE;
	TxCsr0.field.Ac3Total = TX_RING_SIZE;
	RTMP_IO_WRITE32(pAdapter, TX_RING_CSR0, TxCsr0.word);

	// Write TX_RING_CSR1 register
	TxCsr1.word = 0;
    TxCsr1.field.TxdSize = TXD_SIZE/4;
    TxCsr1.field.HccaTotal = TX_RING_SIZE;
    TxCsr1.field.MgmtTotal = MGMT_RING_SIZE;
	RTMP_IO_WRITE32(pAdapter, TX_RING_CSR1, TxCsr1.word);

	// Write RX_RING_CSR register
	RxCsr.word = 0;
	RxCsr.field.RxdSize = RXD_SIZE/4;
	RxCsr.field.RxRingTotal = RX_RING_SIZE;
	RxCsr.field.RxdWritebackSize = 4;
	RTMP_IO_WRITE32(pAdapter, RX_RING_CSR, RxCsr.word);

    //
    // Load shared memeory configuration to ASIC DMA block
    //

    // 0x342c, ASIC TX FIFO to host shared memory mapping
    RTMP_IO_WRITE32(pAdapter, TX_DMA_DST_CSR, 0x000000aa); 

    // ASIC load all TX ring's base address
    RTMP_IO_WRITE32(pAdapter, LOAD_TX_RING_CSR, 0x1f);

    // ASIC load RX ring's base address. still disable RX
    RTMP_IO_WRITE32(pAdapter, RX_CNTL_CSR, 0x00000002);
    
	// Initialze ASIC for TX & Rx operation
	NICInitializeAsic(pAdapter);

    // Load firmware
    //Status = NICLoadFirmware(pAdapter);
    
	DBGPRINT(RT_DEBUG_TRACE, "<-- NICInitializeAdapter\n");
    return Status;
}

VOID    NICInitializeAsic(
	IN    PRTMP_ADAPTER   pAdapter)
{
	ULONG			Index, Counter;
	UCHAR			Value = 0xff;
    ULONG			MacCsr12;
    
	DBGPRINT(RT_DEBUG_TRACE, "--> NICInitializeAsic\n");

	// Initialize MAC register to default value
	for (Index = 0; Index < NUM_MAC_REG_PARMS; Index++)
	{
		RTMP_IO_WRITE32(pAdapter, MACRegTable[Index].Register, MACRegTable[Index].Value);
	}
	
	// Set Host ready before kicking Rx
//	RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x1); // reset MAC state machine, requested by Kevin 2003-2-11
	RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x3);
    RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x0);

    //
	// Before program BBP, we need to wait BBP/RF get wake up.
	//
	Index = 0;
	do
	{
		RTMP_IO_READ32(pAdapter, MAC_CSR12, &MacCsr12);

		if (MacCsr12 & 0x08)
			break;
		
		RTMPusecDelay(1000);
	} while (Index++ < 1000);
 
	// Read BBP register, make sure BBP is up and running before write new data
	Index = 0;
	do 
	{
		RTMP_BBP_IO_READ8_BY_REG_ID(pAdapter, BBP_R0, &Value);
		DBGPRINT(RT_DEBUG_TRACE, "BBP version = %d\n", Value);
	} while ((++Index < 100) && ((Value == 0xff) || (Value == 0x00)));
    //ASSERT(Index < 20);   //this will cause BSOD on Check-build driver
    
	// Initialize BBP register to default value
	for (Index = 0; Index < NUM_BBP_REG_PARMS; Index++)
	{
		RTMP_BBP_IO_WRITE8_BY_REG_ID(pAdapter, BBPRegTable[Index].Register, BBPRegTable[Index].Value);
	}
    
    
    // Add radio off control
	if (pAdapter->PortCfg.bRadio == FALSE)
	{
		RTMP_IO_WRITE32(pAdapter, MAC_CSR10, 0x00001818);
		RTMP_SET_FLAG(pAdapter, fRTMP_ADAPTER_RADIO_OFF);
	}
	
	// Kick Rx
    //RTMP_IO_WRITE32(pAdapter, RX_CNTL_CSR, 0x00000001);     // enable RX of DMA block

    // This delay is needed when ATE(RXFRAME) turn on
    RTMPusecDelay(10);

    RTMP_IO_WRITE32(pAdapter, TXRX_CSR0, 0x025eb032);	// Staion not drop control frame will fail WiFi Certification.

	// Clear raw counters
	RTMP_IO_READ32(pAdapter, STA_CSR0, &Counter);
	RTMP_IO_READ32(pAdapter, STA_CSR1, &Counter);
	RTMP_IO_READ32(pAdapter, STA_CSR2, &Counter);
	
    // assert HOST ready bit
//  RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x0); // 2004-09-14 asked by Mark
//  RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x4);

    RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x4);
	DBGPRINT(RT_DEBUG_TRACE, "<-- NICInitializeAsic\n");
}

/*
    ========================================================================

    Routine Description:
        Reset NIC Asics

    Arguments:
        Adapter                     Pointer to our adapter

    Return Value:
        None

    Note:
        Reset NIC to initial state AS IS system boot up time.

    ========================================================================
*/
VOID    NICIssueReset(
    IN  PRTMP_ADAPTER   pAdapter)
{
    MAC_CSR2_STRUC          StaMacReg0;
	MAC_CSR3_STRUC	        StaMacReg1;
	
	DBGPRINT(RT_DEBUG_TRACE, "--> NICIssueReset\n");

	// Abort Tx, prevent ASIC from writing to Host memory
	RTMP_IO_WRITE32(pAdapter, TX_CNTL_CSR, 0x001f0000);
	
	// Disable Rx, register value supposed will remain after reset
    RTMP_IO_WRITE32(pAdapter, TXRX_CSR0, 0x0257b032);

    if (pAdapter->bLocalAdminMAC)
    {
        // Write Back Permanent MAC address to CSR3 & CSR4
        StaMacReg0.field.Byte0 = pAdapter->PermanentAddress[0];
        StaMacReg0.field.Byte1 = pAdapter->PermanentAddress[1];
        StaMacReg0.field.Byte2 = pAdapter->PermanentAddress[2];
        StaMacReg0.field.Byte3 = pAdapter->PermanentAddress[3];
        StaMacReg1.field.Byte4 = pAdapter->PermanentAddress[4];
        StaMacReg1.field.Byte5 = pAdapter->PermanentAddress[5];
        RTMP_IO_WRITE32(pAdapter, MAC_CSR2, StaMacReg0.word);
        RTMP_IO_WRITE32(pAdapter, MAC_CSR3, StaMacReg1.word);
    }
    
	// Issue reset and clear from reset state
	RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x03); // 2004-09-17 change from 0x01
	RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x00);

	DBGPRINT(RT_DEBUG_TRACE, "<-- NICIssueReset\n");
}

/*
    ========================================================================

    Routine Description:
        Check ASIC registers and find any reason the system might hang

    Arguments:
        Adapter                     Pointer to our adapter

    Return Value:
        None

    Note:


    ========================================================================
*/
BOOLEAN NICCheckForHang(
    IN  PRTMP_ADAPTER   pAd)
{
    return (FALSE);
}

/*
	========================================================================
	
	Routine Description:
		Read statistical counters from hardware registers and record them
		in software variables for later on query

	Arguments:
		pAdapter					Pointer to our adapter

	Return Value:
		None

	========================================================================
*/
VOID NICUpdateRawCounters(
    IN PRTMP_ADAPTER pAdapter)
{
	STA_CSR0_STRUC StaCsr0;
    STA_CSR1_STRUC StaCsr1;
	STA_CSR2_STRUC StaCsr2;
    STA_CSR3_STRUC StaCsr3;
    ULONG          OldValue;
    
    RTMP_IO_READ32(pAdapter, STA_CSR0, &StaCsr0.word);

    // Update RX PLCP error counter
    pAdapter->PrivateInfo.PhyRxErrCnt += StaCsr0.field.PlcpErr;

    // Update FCS counters
    OldValue= pAdapter->WlanCounters.FCSErrorCount.vv.LowPart;
    pAdapter->WlanCounters.FCSErrorCount.vv.LowPart += (StaCsr0.field.CrcErr); // >> 7);
    if (pAdapter->WlanCounters.FCSErrorCount.vv.LowPart < OldValue)
       	pAdapter->WlanCounters.FCSErrorCount.vv.HighPart++;
            
    // Add FCS error count to private counters
    pAdapter->RalinkCounters.OneSecRxFcsErrCnt += StaCsr0.field.CrcErr;
    OldValue = pAdapter->RalinkCounters.RealFcsErrCount.vv.LowPart;
    pAdapter->RalinkCounters.RealFcsErrCount.vv.LowPart += StaCsr0.field.CrcErr;
    if (pAdapter->RalinkCounters.RealFcsErrCount.vv.LowPart < OldValue)
    	pAdapter->RalinkCounters.RealFcsErrCount.vv.HighPart++;
    	
	// Update False CCA counter
	RTMP_IO_READ32(pAdapter, STA_CSR1, &StaCsr1.word);
	pAdapter->RalinkCounters.OneSecFalseCCACnt += StaCsr1.field.FalseCca;
	DBGPRINT(RT_DEBUG_INFO, "OneSecFalseCCACnt = %d\n", pAdapter->RalinkCounters.OneSecFalseCCACnt);

	// Update RX Overflow counter
 	RTMP_IO_READ32(pAdapter, STA_CSR2, &StaCsr2.word);
	pAdapter->Counters8023.RxNoBuffer += (StaCsr2.field.RxOverflowCount + StaCsr2.field.RxFifoOverflowCount);

	// Update BEACON sent count
 	RTMP_IO_READ32(pAdapter, STA_CSR3, &StaCsr3.word);
	pAdapter->RalinkCounters.OneSecBeaconSentCnt += StaCsr3.field.TxBeaconCount;
}

/*
    ========================================================================

    Routine Description:
        Reset NIC from error

    Arguments:
        Adapter                     Pointer to our adapter

    Return Value:
        None

    Note:
        Reset NIC from error state

    ========================================================================
*/
VOID    NICResetFromError(
    IN  PRTMP_ADAPTER   pAdapter)
{
	// Reset BBP (according to alex, reset ASIC will force reset BBP
	// Therefore, skip the reset BBP
	// RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x2);
	// Release BBP reset
	// RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x0);
		
	RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x1);
	// Remove ASIC from reset state
	RTMP_IO_WRITE32(pAdapter, MAC_CSR1, 0x0);

	// Init send data structures and related parameters
	NICInitTxRxRingAndBacklogQueue(pAdapter);

	NICInitializeAdapter(pAdapter);	
    NICInitAsicFromEEPROM(pAdapter);

	// Switch to current channel, since during reset process, the connection should remains on.	
    AsicSwitchChannel(pAdapter, pAdapter->PortCfg.Channel);
    AsicLockChannel(pAdapter, pAdapter->PortCfg.Channel);
}

/*
	========================================================================
	
	Routine Description:
		Load 8051 firmware RT2561.BIN file into MAC ASIC

	Arguments:
		Adapter						Pointer to our adapter

	Return Value:
		NDIS_STATUS_SUCCESS         firmware image load ok
		NDIS_STATUS_FAILURE         image not found

	========================================================================
*/
NDIS_STATUS NICLoadFirmware(
    IN PRTMP_ADAPTER pAd)
{
	NDIS_STATUS				Status = NDIS_STATUS_SUCCESS;
	PUCHAR					src = NULL;
	struct file				*srcf;
	INT 					retval = 0, orgfsuid, orgfsgid, i;
	mm_segment_t			orgfs;
	PUCHAR					pFirmwareImage, pLocalFirmware;
	UINT					FileLength = 0;
	ULONG					LocalFirmwareLen=0;
	ULONG					MacReg;
	ULONG					Index;

	
	DBGPRINT(RT_DEBUG_TRACE,"===> NICLoadFirmware\n");

    pAd->FirmwareVersion = (FIRMWARE_MAJOR_VERSION << 8) + FIRMWARE_MINOR_VERSION; //default version.

	if (pAd->pPci_Dev->device == NIC2561_PCI_DEVICE_ID)
		src = RT2561_IMAGE_FILE_NAME;
	else if (pAd->pPci_Dev->device == NIC2561Turbo_PCI_DEVICE_ID)
		src = RT2561S_IMAGE_FILE_NAME;
	else if (pAd->pPci_Dev->device == NIC2661_PCI_DEVICE_ID)
		src = RT2661_IMAGE_FILE_NAME;
	else
	{
		DBGPRINT_ERR("NICLoadFirmware: wrong DeviceID = 0x%04x, can't find firmware\n", pAd->pPci_Dev->device);
        pAd->SystemErrorBitmap |= 0x00000002;
		return NDIS_STATUS_FAILURE;
	}

	
	// hold 8051 in reset state
	RTMP_IO_WRITE32(pAd, MCU_CNTL_CSR, 0x02);
	RTMP_IO_WRITE32(pAd, M2H_CMD_DONE_CSR, 0xffffffff);    // clear all CmdToken
	RTMP_IO_WRITE32(pAd, H2M_MAILBOX_CSR, 0x00000000);     // MBOX owned by HOST
	RTMP_IO_WRITE32(pAd, HOST_CMD_CSR, 0x00000000);        // 
   	
	// Save uid and gid used for filesystem access.
	// Set user and group to 0 (root)	
	orgfsuid = current->fsuid;
	orgfsgid = current->fsgid;
	current->fsuid=current->fsgid = 0;
	orgfs = get_fs();
	set_fs(KERNEL_DS);

    pFirmwareImage = kmalloc(MAX_FIRMWARE_IMAGE_SIZE, MEM_ALLOC_FLAG);
	if (pFirmwareImage == NULL) 
	{
		DBGPRINT(RT_DEBUG_ERROR, "NICLoadFirmware-Memory allocate fail\n");
        Status = NDIS_STATUS_FAILURE;
		goto out;
	}

	if (src && *src) 
	{
		srcf = filp_open(src, O_RDONLY, 0);
		if (IS_ERR(srcf)) 
		{
			Status = NDIS_STATUS_FAILURE;
			DBGPRINT(RT_DEBUG_ERROR, "--> Error %ld opening %s\n", -PTR_ERR(srcf),src);    
		}
		else 
		{
			// The object must have a read method
			if (srcf->f_op && srcf->f_op->read) 
			{
				memset(pFirmwareImage, 0x00, MAX_FIRMWARE_IMAGE_SIZE);

				FileLength = srcf->f_op->read(srcf, pFirmwareImage, MAX_FIRMWARE_IMAGE_SIZE, &srcf->f_pos);
				if (FileLength != MAX_FIRMWARE_IMAGE_SIZE)
				{
					DBGPRINT_ERR("NICLoadFirmware: error file length (=%d) in BIN file\n",FileLength);
					Status = NDIS_STATUS_FAILURE;
				}
				else
				{  //FileLength == MAX_FIRMWARE_IMAGE_SIZE
					PUCHAR ptr = pFirmwareImage;
					USHORT crc = 0;
					
					for (i=0; i<(MAX_FIRMWARE_IMAGE_SIZE-2); i++, ptr++)
						crc = ByteCRC16(*ptr, crc);
					crc = ByteCRC16(0x00, crc);
					crc = ByteCRC16(0x00, crc);
					
					if ((pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-2] != (UCHAR)(crc>>8)) ||
						(pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-1] != (UCHAR)(crc)))
					{
						DBGPRINT_ERR("NICLoadFirmware: CRC = 0x%02x 0x%02x error, should be 0x%02x 0x%02x\n",
							pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-2], pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-1],
							(UCHAR)(crc>>8), (UCHAR)(crc) );

						if (retval)
						{
							DBGPRINT(RT_DEBUG_ERROR, "--> Error %d closing %s\n", -retval, src);
						}

						Status = NDIS_STATUS_FAILURE;
					}
					else
					{

                        if ((pAd->FirmwareVersion) > ((pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-4] << 8) + pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-3]))
				        {
					        DBGPRINT_ERR("NICLoadFirmware: Ver=%d.%d, local Ver=%d.%d, used FirmwareImage talbe instead\n",
								pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-4], pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-3],
								FIRMWARE_MAJOR_VERSION, FIRMWARE_MINOR_VERSION);

					        Status = NDIS_STATUS_FAILURE;
				        }
				        else
				        {
				            pAd->FirmwareVersion = (pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-4] << 8) + pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-3];
                            DBGPRINT(RT_DEBUG_TRACE,"NICLoadFirmware OK: CRC = 0x%04x ver=%d.%d\n", crc,
							    pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-4], pFirmwareImage[MAX_FIRMWARE_IMAGE_SIZE-3]);
					    }

					}
				}
			}
			else
			{
				Status = NDIS_STATUS_FAILURE;
				DBGPRINT(RT_DEBUG_ERROR, "--> %s does not have a write method\n", src);
			}
			
			retval = filp_close(srcf, NULL);			
			if (retval)
			{
				Status = NDIS_STATUS_FAILURE;
				DBGPRINT(RT_DEBUG_ERROR, "--> Error %d closing %s\n", -retval, src);
			}
		}
	}
	else
	{
		Status = NDIS_STATUS_FAILURE;
		DBGPRINT(RT_DEBUG_ERROR, "Error src not available\n");
	}

    //
    // error handling
    //
	if (Status != NDIS_STATUS_SUCCESS)
	{   
	    // pLocalFirmware : memory alloc
        if (pAd->pPci_Dev->device == NIC2561_PCI_DEVICE_ID)
            LocalFirmwareLen = RT2561_FIRMIM_LEN; 
	    else if (pAd->pPci_Dev->device == NIC2561Turbo_PCI_DEVICE_ID)
            LocalFirmwareLen = RT2561S_FIRMIM_LEN;
	    else if (pAd->pPci_Dev->device == NIC2661_PCI_DEVICE_ID)
            LocalFirmwareLen = RT2661_FIRMIM_LEN;
            
        pLocalFirmware = kmalloc(LocalFirmwareLen, MEM_ALLOC_FLAG); 
	    if (pLocalFirmware == NULL) 
	    {
		    DBGPRINT(RT_DEBUG_ERROR, "NICLoadFirmware-Memory allocate fail\n");
		    Status = NDIS_STATUS_FAILURE;
		    goto out;
	    }
	    else
	    {
	        if (pAd->pPci_Dev->device == NIC2561_PCI_DEVICE_ID)
	            pLocalFirmware = RT2561_FirmwareImage;
	        else if (pAd->pPci_Dev->device == NIC2561Turbo_PCI_DEVICE_ID)
		        pLocalFirmware = RT2561S_FirmwareImage;
	        else if (pAd->pPci_Dev->device == NIC2661_PCI_DEVICE_ID)
		        pLocalFirmware = RT2661_FirmwareImage;

		    pFirmwareImage = pLocalFirmware;
		    FileLength = LocalFirmwareLen;
		    Status = NDIS_STATUS_SUCCESS;   // change to success
		    
		    DBGPRINT(RT_DEBUG_TRACE,"NICLoadFirmware failed, used local Firmware(v %d.%d) instead\n",
		        FIRMWARE_MAJOR_VERSION, FIRMWARE_MINOR_VERSION);
		}        
	}
	
	// select 8051 program bank; write entire firmware image
	RTMP_IO_WRITE32(pAd, MCU_CNTL_CSR, 0x03); 
	for (i=0; i<FileLength; i++)
	{
		RTMP_IO_WRITE8(pAd, FIRMWARE_IMAGE_BASE + i, pFirmwareImage[i]);
	}

	// de-select 8051 program bank
	RTMP_IO_WRITE32(pAd, MCU_CNTL_CSR, 0x02);

	// 8051 get out of RESET state
	RTMP_IO_WRITE32(pAd, MCU_CNTL_CSR, 0x00);


out:
    if (pLocalFirmware == NULL)
	    kfree(pLocalFirmware);
	    
	if (pFirmwareImage == NULL)    
        kfree(pFirmwareImage);
		
	set_fs(orgfs);
	current->fsuid = orgfsuid;
	current->fsgid = orgfsgid;

	if (Status == NDIS_STATUS_SUCCESS) 
	{
	    Index = 0;
	    do
	    {
		    RTMP_IO_READ32(pAd, MCU_CNTL_CSR, &MacReg);

		    if (MacReg & 0x04)
		    {
		        RTMPusecDelay(1000);
			    break;
		    }
		    
		    RTMPusecDelay(1000);
	    } while (Index++ < 1000);

        if (Index >= 1000)
	    {
		    Status = NDIS_STATUS_FAILURE;
		    DBGPRINT(RT_DEBUG_ERROR,"NICLoadFirmware: MCU is not ready\n\n\n");
	    }
	}


	DBGPRINT(RT_DEBUG_TRACE,"<=== NICLoadFirmware (src=%s, status=%d)\n", src, Status);

	return Status;
}

/*
    ========================================================================

    Routine Description:
        Find key section for Get key parameter.

    Arguments:
        buffer                      Pointer to the buffer to start find the key section
        section                     the key of the secion to be find

    Return Value:
        NULL                        Fail
        Others                      Success
    ========================================================================
*/
PUCHAR  RTMPFindSection(
    IN  PCHAR   buffer)
{
    CHAR temp_buf[255];
    PUCHAR  ptr;
    
    strcpy(temp_buf, "[");                  /*  and the opening bracket [  */
    strcat(temp_buf, "Default");
    strcat(temp_buf, "]");

    if((ptr = rtstrstr(buffer, temp_buf)) != NULL)
            return (ptr+strlen("\n"));
        else
            return NULL;
}

 /**
  * strstr - Find the first substring in a %NUL terminated string
  * @s1: The string to be searched
  * @s2: The string to search for
  */
char * rtstrstr(const char * s1,const char * s2)
{
	INT l1, l2;

	l2 = strlen(s2);
	if (!l2)
		return (char *) s1;
	
	l1 = strlen(s1);
	
	while (l1 >= l2)
	{
		l1--;
		if (!memcmp(s1,s2,l2))
			return (char *) s1;
		s1++;
	}
	
	return NULL;
}

/*
    ========================================================================

    Routine Description:
        Get key parameter.

    Arguments:
        key                         Pointer to key string
        dest                        Pointer to destination      
        destsize                    The datasize of the destination
        buffer                      Pointer to the buffer to start find the key

    Return Value:
        TRUE                        Success
        FALSE                       Fail

    Note:
        This routine get the value with the matched key (case case-sensitive)
    ========================================================================
*/
INT RTMPGetKeyParameter(
    IN  PCHAR   key,
    OUT PCHAR   dest,   
    IN  INT     destsize,
    IN  PCHAR   buffer)
{
    CHAR temp_buf1[600];
    CHAR temp_buf2[600];
    CHAR *start_ptr;
    CHAR *end_ptr;
    CHAR *ptr;
    CHAR *offset = 0;
    INT  len;

    //find section
    if((offset = RTMPFindSection(buffer)) == NULL)
        return (FALSE);

    strcpy(temp_buf1, "\n");
    strcat(temp_buf1, key);
    strcat(temp_buf1, "=");

    //search key
    if((start_ptr=rtstrstr(offset, temp_buf1))==NULL)
        return FALSE;

    start_ptr+=strlen("\n");
   
    if((end_ptr=rtstrstr(start_ptr, "\n"))==NULL)
       end_ptr=start_ptr+strlen(start_ptr);

    if (end_ptr<start_ptr)
        return FALSE;

    memcpy(temp_buf2, start_ptr, end_ptr-start_ptr);
    temp_buf2[end_ptr-start_ptr]='\0';
    len = strlen(temp_buf2);
    strcpy(temp_buf1, temp_buf2);
    if((start_ptr=rtstrstr(temp_buf1, "=")) == NULL)
        return FALSE;

    strcpy(temp_buf2, start_ptr+1);
    ptr = temp_buf2;
    //trim space or tab
    while(*ptr != 0x00)
    {
        if( (*ptr == ' ') || (*ptr == '\t') )
            ptr++;
        else
           break;
    }

    len = strlen(ptr);    
    memset(dest, 0x00, destsize);
    strncpy(dest, ptr, len >= destsize ?  destsize: len);

    return TRUE;
}

/*
    ========================================================================

    Routine Description:
        In kernel mode read parameters from file

    Arguments:
        src                     the location of the file.
        dest                        put the parameters to the destination.
        Length                  size to read.

    Return Value:
        None

    Note:

    ========================================================================
*/
VOID RTMPReadParametersFromFile(
    IN  PRTMP_ADAPTER pAd)
{
    NDIS_STATUS				                Status = NDIS_STATUS_SUCCESS;
    PUCHAR                                  src;
    struct file                             *srcf;
    INT                                     retval, orgfsuid, orgfsgid;
    mm_segment_t                            orgfs;
    UCHAR				                    *buffer, *mpool=NULL;
    CHAR                                    *tmpbuf; //[640];
    UCHAR                                   keyMaterial[40];
    UCHAR                                   Channel;
    ULONG                                   ulInfo;
    UCHAR                                   ucInfo;
    RT_802_11_PREAMBLE                      Preamble;
    INT                                     KeyLen, KeyType;
    UCHAR                                   CipherAlg =CIPHER_WEP64;
    
    
    src = PROFILE_PATH;

    // Save uid and gid used for filesystem access.
    // Set user and group to 0 (root)   
    orgfsuid = current->fsuid;
    orgfsgid = current->fsgid;
    current->fsuid=current->fsgid = 0;
    orgfs = get_fs();
    set_fs(KERNEL_DS);

    mpool = kmalloc(sizeof(CHAR)*(2*MAX_INI_BUFFER_SIZE+10), MEM_ALLOC_FLAG);  // allocate memory
    if (mpool == NULL)  
    {
        DBGPRINT(RT_DEBUG_ERROR, "Not enough memory\n");
        goto done;
    }
                    

    if (src && *src)
    {
        srcf = filp_open(src, O_RDONLY, 0);
        if (IS_ERR(srcf))
        {
             Status = NDIS_STATUS_FAILURE;
            DBGPRINT(RT_DEBUG_TRACE, "--> Error %ld opening %s\n", -PTR_ERR(srcf),src);
        }       
        else
        {        
            /* The object must have a read method */
            if (srcf->f_op && srcf->f_op->read) 
            {   
                buffer = (UCHAR *) (((ULONG)(mpool+3)) & ((ULONG)~(0x03)));
                tmpbuf = (UCHAR *) (((ULONG)(mpool+ MAX_INI_BUFFER_SIZE +3)) & ((ULONG)~(0x03)));  
                memset(buffer, 0x00, MAX_INI_BUFFER_SIZE);
                memset(tmpbuf, 0x00, MAX_INI_BUFFER_SIZE);
                retval=srcf->f_op->read(srcf, buffer, MAX_INI_BUFFER_SIZE, &srcf->f_pos);
                if (retval < 0)
                {
                    Status = NDIS_STATUS_FAILURE;
                    DBGPRINT(RT_DEBUG_TRACE, "--> Read %s error %d\n", src, -retval);
                }                
                else
                {                   
                    // set file parameter to portcfg
                    //CountryRegion
                    if (RTMPGetKeyParameter("CountryRegion", tmpbuf, 255, buffer))
                    {
                        ucInfo = (UCHAR) simple_strtol(tmpbuf, 0, 10);
                        if (ucInfo <= 7)
                            pAd->PortCfg.CountryRegion = ucInfo; 
                        else
                        {   
                            ucInfo = 0; // default
                            pAd->PortCfg.CountryRegion = ucInfo;    
                        }
                        DBGPRINT(RT_DEBUG_TRACE, "%s::(CountryRegion=%d)\n", __FUNCTION__, pAd->PortCfg.CountryRegion);
                    } 
                    //CountryRegionABand
					if(RTMPGetKeyParameter("CountryRegionABand", tmpbuf, 25, buffer))
					{
					    ucInfo = (UCHAR) simple_strtol(tmpbuf, 0, 10);
					    if (ucInfo <= 7)
						    pAd->PortCfg.CountryRegionForABand = ucInfo;
                        else
                        {
                            ucInfo = 7; // default
                            pAd->PortCfg.CountryRegionForABand = ucInfo;
                        }
                        DBGPRINT(RT_DEBUG_TRACE, "%s::(CountryRegionABand=%d)\n", __FUNCTION__, pAd->PortCfg.CountryRegionForABand);
					} 					
                    //SSID
                    memset(tmpbuf, 0x00, 255);
                    if (RTMPGetKeyParameter("SSID", tmpbuf, 64, buffer))
                    {
                        if (strlen(tmpbuf) <= 32)
                        {
                            pAd->PortCfg.SsidLen = (UCHAR) strlen(tmpbuf);
                            memcpy(pAd->PortCfg.Ssid, tmpbuf, pAd->PortCfg.SsidLen);

						    pAd->MlmeAux.AutoReconnectSsidLen = pAd->PortCfg.SsidLen;
						    memcpy(pAd->MlmeAux.AutoReconnectSsid, tmpbuf, pAd->MlmeAux.AutoReconnectSsidLen);
                            pAd->MlmeAux.SsidLen = pAd->PortCfg.SsidLen;
                            memcpy(pAd->MlmeAux.Ssid, tmpbuf, pAd->MlmeAux.SsidLen);

                            DBGPRINT(RT_DEBUG_TRACE, "%s::(SSID=%s)\n", __FUNCTION__, tmpbuf);

                        }
                    }    
                    //NetworkType
                    if (RTMPGetKeyParameter("NetworkType", tmpbuf, 25, buffer))
                    {
                        pAd->bConfigChanged = TRUE;
                        if (strcmp(tmpbuf, "Adhoc") == 0)
                            pAd->PortCfg.BssType = BSS_ADHOC;
                        else //Default Infrastructure mode
                            pAd->PortCfg.BssType = BSS_INFRA;
                        // Reset Ralink supplicant to not use, it will be set to start when UI set PMK key
                        pAd->PortCfg.WpaState = SS_NOTUSE;
                        DBGPRINT(RT_DEBUG_TRACE, "%s::(NetworkType=%d)\n", __FUNCTION__, pAd->PortCfg.BssType);
                    }                 
                    //WirelessMode
                    if (RTMPGetKeyParameter("WirelessMode", tmpbuf, 10, buffer))
                    {   
                        ulInfo = (ULONG)simple_strtol(tmpbuf, 0, 10);
                       
                        if ((ulInfo == PHY_11BG_MIXED) || (ulInfo == PHY_11B) ||
                            (ulInfo == PHY_11A) || (ulInfo == PHY_11ABG_MIXED) ||
                            (ulInfo == PHY_11G))
                        {                                                 
    	                    pAd->PortCfg.PhyMode = 0xff;
                            RTMPSetPhyMode(pAd, ulInfo);

                            // Set AdhocMode rates
                            if (pAd->PortCfg.BssType == BSS_ADHOC)
                            {
                                if (ulInfo == PHY_11B)
                                    pAd->PortCfg.AdhocMode = 0;
                                if ((ulInfo == PHY_11BG_MIXED) || (ulInfo == PHY_11ABG_MIXED))
                                    pAd->PortCfg.AdhocMode = 1;
                                if ((ulInfo == PHY_11A) || (ulInfo == PHY_11G))
                                    pAd->PortCfg.AdhocMode = 2;       
                            }
                            
                            DBGPRINT(RT_DEBUG_TRACE, "%s::(WirelessMode=%d)\n", __FUNCTION__, ulInfo);
                        }
                    }       
                    //TxRate
                    if (RTMPGetKeyParameter("TxRate", tmpbuf, 10, buffer))
                    {
                        ulInfo = (ULONG)simple_strtol(tmpbuf, 0, 10);

                        if ((pAd->PortCfg.PhyMode == PHY_11B && ulInfo <= 4) ||\
                            ((pAd->PortCfg.PhyMode == PHY_11BG_MIXED || pAd->PortCfg.PhyMode == PHY_11ABG_MIXED) && ulInfo <= 12) ||\
                            ((pAd->PortCfg.PhyMode == PHY_11A || pAd->PortCfg.PhyMode == PHY_11G) && (ulInfo == 0 ||(ulInfo > 4 && ulInfo <= 12))))
                        {    
                            if (ulInfo == 0)
                                RTMPSetDesiredRates(pAd, -1);
                            else
                                RTMPSetDesiredRates(pAd, (LONG) (RateIdToMbps[ulInfo-1] * 1000000));
                        }
                        else
                        {
                            ulInfo = 0; // default, TxRate=Auto
                            RTMPSetDesiredRates(pAd, -1);
                        }
                        
                        DBGPRINT(RT_DEBUG_TRACE, "%s::(TxRate=%d)\n", __FUNCTION__, ulInfo);
                    }                    
                    //Channel
                    if (RTMPGetKeyParameter("Channel", tmpbuf, 10, buffer))
                    {
                        Channel = (UCHAR) simple_strtol(tmpbuf, 0, 10);
                        if (ChannelSanity(pAd, Channel) == TRUE)
                        {
                            pAd->PortCfg.Channel = Channel;
                            
                            DBGPRINT(RT_DEBUG_TRACE, "%s::(Channel=%d)\n", __FUNCTION__, Channel);
                        }
                    }                   
                    //BGProtection
                    if (RTMPGetKeyParameter("BGProtection", tmpbuf, 10, buffer))
                    {
                        switch (simple_strtol(tmpbuf, 0, 10))
                        {
                            case 1: //Always On
                                pAd->PortCfg.UseBGProtection = 1;
                                break;
                            case 2: //Always OFF
                                pAd->PortCfg.UseBGProtection = 2;
                                break;
                            case 0: //AUTO
                            default:
                                pAd->PortCfg.UseBGProtection = 0;
                                break;
                        }
                        DBGPRINT(RT_DEBUG_TRACE, "%s::(BGProtection=%d)\n", __FUNCTION__, pAd->PortCfg.UseBGProtection);
                    }                  
                    //TxPreamble
                    if (RTMPGetKeyParameter("TxPreamble", tmpbuf, 10, buffer))
                    {
                        Preamble = simple_strtol(tmpbuf, 0, 10);
                        switch (Preamble)
                        {
                            case Rt802_11PreambleShort:
                                pAd->PortCfg.TxPreamble = Preamble;
                                MlmeSetTxPreamble(pAd, Rt802_11PreambleShort);
                                break;
                            case Rt802_11PreambleLong:
                            case Rt802_11PreambleAuto:
                            default:
                                // if user wants AUTO, initialize to LONG here, then change according to AP's
                                // capability upon association.
                                pAd->PortCfg.TxPreamble = Preamble;
                                MlmeSetTxPreamble(pAd, Rt802_11PreambleLong);
                        }
                        DBGPRINT(RT_DEBUG_TRACE, "%s::(TxPreamble=%d)\n", __FUNCTION__, Preamble);
                    }
                    //RTSThreshold
                    if (RTMPGetKeyParameter("RTSThreshold", tmpbuf, 10, buffer))
                    {
                        ulInfo = simple_strtol(tmpbuf, 0, 10);

                        if((ulInfo > 0) && (ulInfo <= MAX_RTS_THRESHOLD))
                            pAd->PortCfg.RtsThreshold = (USHORT)ulInfo;
                        else 
                            pAd->PortCfg.RtsThreshold = MAX_RTS_THRESHOLD;

                        DBGPRINT(RT_DEBUG_TRACE, "%s::(RTSThreshold=%d)\n", __FUNCTION__, pAd->PortCfg.RtsThreshold);
                    }
                    //FragThreshold
                    if (RTMPGetKeyParameter("FragThreshold", tmpbuf, 10, buffer))
                    {
                        ulInfo = simple_strtol(tmpbuf, 0, 10);

                        if ( (ulInfo >= MIN_FRAG_THRESHOLD) && (ulInfo <= MAX_FRAG_THRESHOLD))
                            pAd->PortCfg.FragmentThreshold = (USHORT)ulInfo;
                        else
                            pAd->PortCfg.FragmentThreshold = MAX_FRAG_THRESHOLD;

                        if (pAd->PortCfg.FragmentThreshold == MAX_FRAG_THRESHOLD)
                            pAd->PortCfg.bFragmentZeroDisable = TRUE;
                        else
                            pAd->PortCfg.bFragmentZeroDisable = FALSE;

                        DBGPRINT(RT_DEBUG_TRACE, "%s::(FragThreshold=%d)\n", __FUNCTION__, ulInfo);
                    }
                    //TxBurst
                    if (RTMPGetKeyParameter("TxBurst", tmpbuf, 10, buffer))
                    {
                        ulInfo = simple_strtol(tmpbuf, 0, 10);

                        if (ulInfo == 1)
                            pAd->PortCfg.bEnableTxBurst = TRUE;
                        else
                            pAd->PortCfg.bEnableTxBurst = FALSE;

                        DBGPRINT(RT_DEBUG_TRACE, "%s::(TxBurst=%d)\n", __FUNCTION__, pAd->PortCfg.bEnableTxBurst);
                    } 
                    
#ifdef AGGREGATION_SUPPORT
					//PktAggregate
					if(RTMPGetKeyParameter("PktAggregate", tmpbuf, 10, buffer))
					{
						if(simple_strtol(tmpbuf, 0, 10) != 0)  //Enable
							pAd->PortCfg.bAggregationCapable = TRUE;
						else //Disable
							pAd->PortCfg.bAggregationCapable = FALSE;

                        DBGPRINT(RT_DEBUG_TRACE, "%s::(PktAggregate=%d)\n", __FUNCTION__, pAd->PortCfg.bAggregationCapable);
					}
#else
					pAd->PortCfg.bAggregationCapable = FALSE;
#endif /* !AGGREGATION_SUPPORT */

                    //TurboRate
                    if (RTMPGetKeyParameter("TurboRate", tmpbuf, 10, buffer))
                    {
                        ulInfo = simple_strtol(tmpbuf, 0, 10);

                        if (ulInfo == 1)
                            pAd->PortCfg.EnableTurboRate = TRUE;
                        else
                            pAd->PortCfg.EnableTurboRate = FALSE;

                        DBGPRINT(RT_DEBUG_TRACE, "%s::(TurboRate=%d)\n", __FUNCTION__, pAd->PortCfg.EnableTurboRate);
                    }
                    
#ifdef WMM_SUPPORT
					//WmmCapable
					if(RTMPGetKeyParameter("WmmCapable", tmpbuf, 32, buffer))
					{
    				    if(simple_strtol(tmpbuf, 0, 10) != 0)  //Enable
    					    pAd->PortCfg.bWmmCapable = TRUE;
    				    else //Disable
    				        pAd->PortCfg.bWmmCapable = FALSE;
    				        
                        DBGPRINT(RT_DEBUG_TRACE, "%s::(WmmCapable=%d)\n", __FUNCTION__, pAd->PortCfg.bWmmCapable); 
					}
					//AckPolicy1 for AC_BK 
					if(RTMPGetKeyParameter("AckPolicy1", tmpbuf, 32, buffer))
					{
                        pAd->PortCfg.AckPolicy[0] = (UCHAR)simple_strtol(tmpbuf, 0, 10);
    				    DBGPRINT(RT_DEBUG_TRACE, "%s::(AckPolicy[0]=%d)\n", __FUNCTION__, pAd->PortCfg.AckPolicy[0]);
					}
					//AckPolicy2 for AC_BE 
					if(RTMPGetKeyParameter("AckPolicy2", tmpbuf, 32, buffer))
					{
                        pAd->PortCfg.AckPolicy[1] = (UCHAR)simple_strtol(tmpbuf, 0, 10);
    				    DBGPRINT(RT_DEBUG_TRACE, "%s::(AckPolicy[1]=%d)\n", __FUNCTION__, pAd->PortCfg.AckPolicy[1]);
					}
					//AckPolicy3 for AC_VI 
					if(RTMPGetKeyParameter("AckPolicy3", tmpbuf, 32, buffer))
					{
                        pAd->PortCfg.AckPolicy[2] = (UCHAR)simple_strtol(tmpbuf, 0, 10);
    				    DBGPRINT(RT_DEBUG_TRACE, "%s::(AckPolicy[2]=%d)\n", __FUNCTION__, pAd->PortCfg.AckPolicy[2]);
					}
					//AckPolicy4 for AC_VO
					if(RTMPGetKeyParameter("AckPolicy4", tmpbuf, 32, buffer))
					{
                        pAd->PortCfg.AckPolicy[3] = (UCHAR)simple_strtol(tmpbuf, 0, 10);
    				    DBGPRINT(RT_DEBUG_TRACE, "%s::(AckPolicy[3]=%d)\n", __FUNCTION__, pAd->PortCfg.AckPolicy[3]);
					}
					
#else	 
				    pAd->PortCfg.bWmmCapable = FALSE;
#endif /* !WMM_SUPPORT */

                    //ShortSlot
                    if (RTMPGetKeyParameter("ShortSlot", tmpbuf, 10, buffer))
                    {
                        ulInfo = simple_strtol(tmpbuf, 0, 10);

                        if (ulInfo == 1)
                            pAd->PortCfg.UseShortSlotTime = TRUE;
                        else
                            pAd->PortCfg.UseShortSlotTime = FALSE;

                        DBGPRINT(RT_DEBUG_TRACE, "%s::(ShortSlot=%d)\n", __FUNCTION__, pAd->PortCfg.UseShortSlotTime);
                    }                   
                    //IEEE80211H
					if(RTMPGetKeyParameter("IEEE80211H", tmpbuf, 10, buffer))
					{
    			        if(simple_strtol(tmpbuf, 0, 10) != 0)  //Enable
    				        pAd->PortCfg.bIEEE80211H = TRUE;
    				    else //Disable
    					    pAd->PortCfg.bIEEE80211H = FALSE;

    				    DBGPRINT(RT_DEBUG_TRACE, "%s::(IEEE80211H=%d)\n", __FUNCTION__, pAd->PortCfg.bIEEE80211H);
					}
                    //POWER_MODE
                    if (RTMPGetKeyParameter("PSMode", tmpbuf, 10, buffer))
                    {
                        if (pAd->PortCfg.BssType == BSS_INFRA)
                        {
                            if ((strcmp(tmpbuf, "MAX_PSP") == 0) || (strcmp(tmpbuf, "max_psp") == 0))
                            {
                                // do NOT turn on PSM bit here, wait until MlmeCheckForPsmChange()
                                // to exclude certain situations.
                                //     MlmeSetPsmBit(pAdapter, PWR_SAVE);
                                if (pAd->PortCfg.bWindowsACCAMEnable == FALSE)
                                    pAd->PortCfg.WindowsPowerMode = Ndis802_11PowerModeMAX_PSP;
                                pAd->PortCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeMAX_PSP;
                                OPSTATUS_SET_FLAG(pAd, fOP_STATUS_RECEIVE_DTIM);
                                pAd->PortCfg.DefaultListenCount = 5;
                            }
                            else if ((strcmp(tmpbuf, "Fast_PSP") == 0) || (strcmp(tmpbuf, "fast_psp") == 0) 
                                || (strcmp(tmpbuf, "FAST_PSP") == 0))
                            {
                                // do NOT turn on PSM bit here, wait until MlmeCheckForPsmChange()
                                // to exclude certain situations.
                                //     MlmeSetPsmBit(pAdapter, PWR_SAVE);
                                OPSTATUS_SET_FLAG(pAd, fOP_STATUS_RECEIVE_DTIM);
                                if (pAd->PortCfg.bWindowsACCAMEnable == FALSE)
                                    pAd->PortCfg.WindowsPowerMode = Ndis802_11PowerModeFast_PSP;
                                pAd->PortCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeFast_PSP;
                                pAd->PortCfg.DefaultListenCount = 3;
                            }
                            else
                            { //Default Ndis802_11PowerModeCAM
                                // clear PSM bit immediately
                                MlmeSetPsmBit(pAd, PWR_ACTIVE);
                                OPSTATUS_SET_FLAG(pAd, fOP_STATUS_RECEIVE_DTIM);
                                if (pAd->PortCfg.bWindowsACCAMEnable == FALSE)
                                    pAd->PortCfg.WindowsPowerMode = Ndis802_11PowerModeCAM;
                                pAd->PortCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeCAM;
                            }
                            DBGPRINT(RT_DEBUG_TRACE, "%s::(PSMode=%d)\n", __FUNCTION__, pAd->PortCfg.WindowsPowerMode);
                        }
                    }
                    //AuthMode
                    if (RTMPGetKeyParameter("AuthMode", tmpbuf, 32, buffer))
                    { 
                        if ((strcmp(tmpbuf, "WEPAUTO") == 0) || (strcmp(tmpbuf, "wepauto") == 0))
                            pAd->PortCfg.AuthMode = Ndis802_11AuthModeAutoSwitch;
                        else if ((strcmp(tmpbuf, "SHARED") == 0) || (strcmp(tmpbuf, "shared") == 0))
                            pAd->PortCfg.AuthMode = Ndis802_11AuthModeShared;
                        else if ((strcmp(tmpbuf, "WPAPSK") == 0) || (strcmp(tmpbuf, "wpapsk") == 0))
                            pAd->PortCfg.AuthMode = Ndis802_11AuthModeWPAPSK;
                        else if ((strcmp(tmpbuf, "WPANONE") == 0) || (strcmp(tmpbuf, "wpanone") == 0))
                            pAd->PortCfg.AuthMode = Ndis802_11AuthModeWPANone;
                        else if ((strcmp(tmpbuf, "WPA2PSK") == 0) || (strcmp(tmpbuf, "wpa2psk") == 0))
                            pAd->PortCfg.AuthMode = Ndis802_11AuthModeWPA2PSK;  
                        else
                            pAd->PortCfg.AuthMode = Ndis802_11AuthModeOpen;

                        pAd->PortCfg.PortSecured = WPA_802_1X_PORT_NOT_SECURED;
                        DBGPRINT(RT_DEBUG_TRACE, "%s::(AuthMode=%d)\n", __FUNCTION__, pAd->PortCfg.AuthMode);
                    }           
                    //EncrypType
                    if (RTMPGetKeyParameter("EncrypType", tmpbuf, 32, buffer))
                    {
                        if ((strcmp(tmpbuf, "WEP") == 0) || (strcmp(tmpbuf, "wep") == 0))
                        {
                            if (pAd->PortCfg.AuthMode < Ndis802_11AuthModeWPA)
                            {
                                pAd->PortCfg.WepStatus      = Ndis802_11WEPEnabled;
                                pAd->PortCfg.PairCipher     = Ndis802_11WEPDisabled;
	                            pAd->PortCfg.GroupCipher    = Ndis802_11WEPDisabled;
	                        }    
                        }
                        else if ((strcmp(tmpbuf, "TKIP") == 0) || (strcmp(tmpbuf, "tkip") == 0))
                        {
                            if (pAd->PortCfg.AuthMode >= Ndis802_11AuthModeWPA)
                            {
                                pAd->PortCfg.WepStatus      = Ndis802_11Encryption2Enabled;
                                pAd->PortCfg.PairCipher     = Ndis802_11Encryption2Enabled;
	                            pAd->PortCfg.GroupCipher    = Ndis802_11Encryption2Enabled;
	                        }    
                        }
                        else if ((strcmp(tmpbuf, "AES") == 0) || (strcmp(tmpbuf, "aes") == 0))
                        {
                            if (pAd->PortCfg.AuthMode >= Ndis802_11AuthModeWPA)
                            {
                                pAd->PortCfg.WepStatus      = Ndis802_11Encryption3Enabled;
                                pAd->PortCfg.PairCipher     = Ndis802_11Encryption3Enabled;
	                            pAd->PortCfg.GroupCipher    = Ndis802_11Encryption3Enabled;
	                        }    
                        }    
                        else
                        {
                            pAd->PortCfg.WepStatus      = Ndis802_11WEPDisabled;
                            pAd->PortCfg.PairCipher     = Ndis802_11WEPDisabled;
	                        pAd->PortCfg.GroupCipher    = Ndis802_11WEPDisabled;
                        }
                        RTMPMakeRSNIE(pAd, pAd->PortCfg.GroupCipher);
                        DBGPRINT(RT_DEBUG_TRACE, "%s::(EncrypType=%d)\n", __FUNCTION__, pAd->PortCfg.WepStatus);
                    }
                    //WPAPSK_KEY
                    if (RTMPGetKeyParameter("WPAPSK", tmpbuf, 255, buffer))
                    {
                        int     err=0;

                        if ((pAd->PortCfg.AuthMode != Ndis802_11AuthModeWPAPSK) &&\
				            (pAd->PortCfg.AuthMode != Ndis802_11AuthModeWPA2PSK) &&\
				            (pAd->PortCfg.AuthMode != Ndis802_11AuthModeWPANone) )
				        {
				            err = 1;
				        }
                        else if ((strlen(tmpbuf) >= 8) && (strlen(tmpbuf) < 64))
                        {
                            PasswordHash((char *)tmpbuf, pAd->PortCfg.Ssid, pAd->PortCfg.SsidLen, keyMaterial);
                            NdisMoveMemory(pAd->PortCfg.PskKey.Key, keyMaterial, 32);
                            
                        }
                        else if (strlen(tmpbuf) == 64)
                        {                            
                            AtoH(tmpbuf, keyMaterial, 32);
                            NdisMoveMemory(pAd->PortCfg.PskKey.Key, keyMaterial, 32);
                        }
                        else
                        {   
                            err = 1;
                            DBGPRINT(RT_DEBUG_ERROR, "%s::(WPAPSK key-string required 8 ~ 64 characters!)\n", __FUNCTION__);
                        }
                        
                        if (err == 0)
                        {  
                            RTMPMakeRSNIE(pAd, pAd->PortCfg.GroupCipher);
                            
                            if ((pAd->PortCfg.AuthMode == Ndis802_11AuthModeWPAPSK) ||\
                                (pAd->PortCfg.AuthMode == Ndis802_11AuthModeWPA2PSK))
                            {
                                // Use RaConfig as PSK agent.
                                // Start STA supplicant state machine
                                pAd->PortCfg.WpaState = SS_START;
                            }
                            else if (pAd->PortCfg.AuthMode == Ndis802_11AuthModeWPANone)
                            {
                                // Set wpapsk key later
                                // set the flag 
                                pAd->PortCfg.WpaState = SS_START;
                            }
                            DBGPRINT(RT_DEBUG_TRACE, "%s::(WPAPSK=%s)\n", __FUNCTION__, tmpbuf);
                        }     
                    }                    
                    //DefaultKeyID
                    if (RTMPGetKeyParameter("DefaultKeyID", tmpbuf, 10, buffer))
                    {
                        ulInfo = simple_strtol(tmpbuf, 0, 10);
                        if((ulInfo >= 1 ) && (ulInfo <= 4))
                            pAd->PortCfg.DefaultKeyId = (UCHAR) (ulInfo - 1 );
                        else
                            pAd->PortCfg.DefaultKeyId = 0;

                        DBGPRINT(RT_DEBUG_TRACE, "%s::(DefaultKeyID=%d)\n", __FUNCTION__, pAd->PortCfg.DefaultKeyId);
                    }       
                    //Key1Type
					if(RTMPGetKeyParameter("Key1Type", tmpbuf, 32, buffer))
					{
                        if (pAd->PortCfg.WepStatus == Ndis802_11WEPEnabled &&\
                            pAd->PortCfg.DefaultKeyId == 0)
                        {
						KeyType = simple_strtol(tmpbuf, 0, 10);    
	
						if(RTMPGetKeyParameter("Key1Str", tmpbuf, 128, buffer))
						{
                            KeyLen  = strlen(tmpbuf);
                            if (KeyLen > 0)
                            {
    						    if(KeyType == 0)
    						    {//Hex type
    							    if( (KeyLen == 10) || (KeyLen == 26))
    							    {
    								    pAd->SharedKey[0].KeyLen = KeyLen / 2;
    								    AtoH(tmpbuf, pAd->SharedKey[0].Key, KeyLen / 2);
    								    if (KeyLen == 10)
    									    CipherAlg = CIPHER_WEP64;
    								    else
    									    CipherAlg = CIPHER_WEP128;
    								    pAd->SharedKey[0].CipherAlg = CipherAlg;
                        	
    								    DBGPRINT(RT_DEBUG_TRACE, "%s::(Key1Str=%s and type=%s)\n", __FUNCTION__, tmpbuf, (KeyType==0) ? "Hex":"Ascii");
    							    }
    							    else
    							    { //Invalid key length
    								    DBGPRINT(RT_DEBUG_ERROR, "%s::(Key1Str is Invalid key length!)\n", __FUNCTION__);
    							    }								
    						    }
    						    else
    						    {//Ascii								
    							    if( (KeyLen == 5) || (KeyLen == 13))
    							    {
    								    pAd->SharedKey[0].KeyLen = KeyLen;
    								    NdisMoveMemory(pAd->SharedKey[0].Key, tmpbuf, KeyLen);
    								    if (KeyLen == 5)
    									    CipherAlg = CIPHER_WEP64;
    								    else
    									    CipherAlg = CIPHER_WEP128;
    								    pAd->SharedKey[0].CipherAlg = CipherAlg;
    						
    								    DBGPRINT(RT_DEBUG_TRACE, "%s::(Key1Str=%s and type=%s)\n", __FUNCTION__, tmpbuf, (KeyType==0) ? "Hex":"Ascii");	
    							    }
    							    else
    							    { //Invalid key length
    								    DBGPRINT(RT_DEBUG_ERROR, "%s::(Key1Str is Invalid key length!)\n", __FUNCTION__);
    							    }
    						    }   
    				        }   
						}
					  }
					}
					//Key2Type
					if(RTMPGetKeyParameter("Key2Type", tmpbuf, 32, buffer))
					{
					    if (pAd->PortCfg.WepStatus == Ndis802_11WEPEnabled &&\
                            pAd->PortCfg.DefaultKeyId == 1)
                        {    
						KeyType = simple_strtol(tmpbuf, 0, 10);    
						
						if(RTMPGetKeyParameter("Key2Str", tmpbuf, 128, buffer))
						{
                            KeyLen  = strlen(tmpbuf);
                            if (KeyLen > 0)
                            {
    						    if(KeyType == 0)
    						    {//Hex type
    							    if( (KeyLen == 10) || (KeyLen == 26))
    							    {
    								    pAd->SharedKey[1].KeyLen = KeyLen / 2;
    								    AtoH(tmpbuf, pAd->SharedKey[1].Key, KeyLen / 2);
    								    if (KeyLen == 10)
    									    CipherAlg = CIPHER_WEP64;
    								    else
    									    CipherAlg = CIPHER_WEP128;
    								    pAd->SharedKey[1].CipherAlg = CipherAlg;
                        	
    								    DBGPRINT(RT_DEBUG_TRACE, "%s::(Key2Str=%s and type=%s)\n", __FUNCTION__, tmpbuf, (KeyType==0) ? "Hex":"Ascii");
    							    }
    							    else
    							    { //Invalid key length
    								    DBGPRINT(RT_DEBUG_ERROR, "%s::(Key2Str is Invalid key length!)\n", __FUNCTION__);
    							    }								
    						    }
    						    else
    						    {//Ascii								
    							    if( (KeyLen == 5) || (KeyLen == 13))
    							    {
    								    pAd->SharedKey[1].KeyLen = KeyLen;
    								    NdisMoveMemory(pAd->SharedKey[1].Key, tmpbuf, KeyLen);
    								    if (KeyLen == 5)
    									    CipherAlg = CIPHER_WEP64;
    								    else
    									    CipherAlg = CIPHER_WEP128;
    								    pAd->SharedKey[1].CipherAlg = CipherAlg;
    						
    								    DBGPRINT(RT_DEBUG_TRACE, "%s::(Key2Str=%s and type=%s)\n", __FUNCTION__, tmpbuf, (KeyType==0) ? "Hex":"Ascii");
    							    }
    							    else
    							    { //Invalid key length
    								    DBGPRINT(RT_DEBUG_ERROR, "%s::(Key2Str is Invalid key length!)\n", __FUNCTION__);
    							    } 
    						    }
    						}
						}
						}
					}
					//Key3Type
					if(RTMPGetKeyParameter("Key3Type", tmpbuf, 32, buffer))
					{
                        if (pAd->PortCfg.WepStatus == Ndis802_11WEPEnabled &&\
                            pAd->PortCfg.DefaultKeyId == 2)
                        {    
						KeyType = simple_strtol(tmpbuf, 0, 10);    
						
						if(RTMPGetKeyParameter("Key3Str", tmpbuf, 128, buffer))
						{
                            KeyLen  = strlen(tmpbuf);
                            if (KeyLen > 0)
                            {   
    						    if(KeyType == 0)
    						    {//Hex type
    							    if( (KeyLen == 10) || (KeyLen == 26))
    							    {
    								    pAd->SharedKey[2].KeyLen = KeyLen / 2;
    								    AtoH(tmpbuf, pAd->SharedKey[2].Key, KeyLen / 2);
    								    if (KeyLen == 10)
    									    CipherAlg = CIPHER_WEP64;
    								    else
    									    CipherAlg = CIPHER_WEP128;
    								    pAd->SharedKey[2].CipherAlg = CipherAlg;
                        	
    								    DBGPRINT(RT_DEBUG_TRACE, "%s::(Key3Str=%s and type=%s)\n", __FUNCTION__, tmpbuf, (KeyType==0) ? "Hex":"Ascii");
    							    }
    							    else
    							    { //Invalid key length
    								    DBGPRINT(RT_DEBUG_ERROR, "%s::(Key3Str is Invalid key length!)\n", __FUNCTION__);
    							    }								
    						    }
    						    else
    						    {//Ascii								
    							    if( (KeyLen == 5) || (KeyLen == 13))
    							    {
    								    pAd->SharedKey[2].KeyLen = KeyLen;
    								    NdisMoveMemory(pAd->SharedKey[2].Key, tmpbuf, KeyLen);
    								    if (KeyLen == 5)
    									    CipherAlg = CIPHER_WEP64;
    								    else
    									    CipherAlg = CIPHER_WEP128;
    								    pAd->SharedKey[2].CipherAlg = CipherAlg;
    						
    								    DBGPRINT(RT_DEBUG_TRACE, "%s::(Key3Str=%s and type=%s)\n", __FUNCTION__, tmpbuf, (KeyType==0) ? "Hex":"Ascii");	
    							    }
    							    else
    							    { //Invalid key length
    								    DBGPRINT(RT_DEBUG_ERROR, "%s::(Key3Str is Invalid key length!)\n", __FUNCTION__);
    							    }
    						    }
    						}
						}
						}
					}
					//Key4Type
					if(RTMPGetKeyParameter("Key4Type", tmpbuf, 32, buffer)) 
					{
                        if (pAd->PortCfg.WepStatus == Ndis802_11WEPEnabled &&\
                            pAd->PortCfg.DefaultKeyId == 3)
                        {    
						KeyType = simple_strtol(tmpbuf, 0, 10);    
						
						if(RTMPGetKeyParameter("Key4Str", tmpbuf, 128, buffer))
						{
                            KeyLen  = strlen(tmpbuf);
                            if (KeyLen > 0)
                            {      
    						    if(KeyType == 0)
    						    {//Hex type
    							    if( (KeyLen == 10) || (KeyLen == 26))
    							    {
    								    pAd->SharedKey[3].KeyLen = KeyLen / 2;
    								    AtoH(tmpbuf, pAd->SharedKey[3].Key, KeyLen / 2);
    								    if (KeyLen == 10)
    									    CipherAlg = CIPHER_WEP64;
    								    else
    									    CipherAlg = CIPHER_WEP128;
    								    pAd->SharedKey[3].CipherAlg = CipherAlg;
                        	
    								    DBGPRINT(RT_DEBUG_TRACE, "%s::(Key4Str=%s and type=%s)\n", __FUNCTION__, tmpbuf, (KeyType==0) ? "Hex":"Ascii");
    							    }
    							    else
    							    { //Invalid key length
    								    DBGPRINT(RT_DEBUG_ERROR, "%s::(Key4Str is Invalid key length!)\n", __FUNCTION__);
    							    }								
    						    }
    						    else
    						    {//Ascii								
    							    if( (KeyLen == 5) || (KeyLen == 13))
    							    {
    								    pAd->SharedKey[3].KeyLen = KeyLen;
    								    NdisMoveMemory(pAd->SharedKey[3].Key, tmpbuf, KeyLen);
    								    if (KeyLen == 5)
    									    CipherAlg = CIPHER_WEP64;
    								    else
    									    CipherAlg = CIPHER_WEP128;
    								    pAd->SharedKey[3].CipherAlg = CipherAlg;
    						
    								    DBGPRINT(RT_DEBUG_TRACE, "%s::(Key4Str=%s and type=%s)\n", __FUNCTION__, tmpbuf, (KeyType==0) ? "Hex":"Ascii");	
    							    }
    							    else
    							    { //Invalid key length
    								    DBGPRINT(RT_DEBUG_ERROR, "%s::(Key4Str is Invalid key length!)\n", __FUNCTION__);
    							    }
    						    }
    						}
						}
						}
					}				
					// Set keys into ASIC
                    if (pAd->PortCfg.WepStatus == Ndis802_11WEPEnabled)
                    {   
                        //if ((pAd->PortCfg.DefaultKeyId >= 0) && (pAd->PortCfg.DefaultKeyId < 4))    
                            AsicAddSharedKeyEntry(pAd, 
                                                  0, 
                                                  pAd->PortCfg.DefaultKeyId, 
                                                  pAd->SharedKey[pAd->PortCfg.DefaultKeyId].CipherAlg, 
                                                  pAd->SharedKey[pAd->PortCfg.DefaultKeyId].Key, 
                                                  NULL,
                                                  NULL);
                    }                  
                }                     
            }
            else
            {
                Status = NDIS_STATUS_FAILURE;
                DBGPRINT(RT_DEBUG_TRACE, "--> %s does not have a write method\n", src);
            }

            retval=filp_close(srcf,NULL);
            if (retval)
            {
                Status = NDIS_STATUS_FAILURE;
                DBGPRINT(RT_DEBUG_TRACE, "--> Error %d closing %s\n", -retval, src);
            }
        } // else (IS_ERR(srcf))      
    } //if (src && *src)


done:
    // Error handling
	if ((mpool == NULL) || (Status != NDIS_STATUS_SUCCESS))		    
	    kfree(mpool);
	    
    set_fs(orgfs);
    current->fsuid = orgfsuid;
    current->fsgid = orgfsgid;

}

/*
    ========================================================================

    Routine Description:
        Reset NIC Asics

    Arguments:
        Adapter                     Pointer to our adapter

    Return Value:
        None

    Note:
        Reset NIC to initial state AS IS system boot up time.

    ========================================================================
*/
VOID    RTMPRingCleanUp(
    IN  PRTMP_ADAPTER   pAdapter,
    IN  UCHAR           RingType)
{
	PTXD_STRUC		pTxD;
	PRXD_STRUC		pRxD;
#ifdef	BIG_ENDIAN
    PTXD_STRUC      pDestTxD;
    TXD_STRUC       TxD;
    PRXD_STRUC      pDestRxD;
    RXD_STRUC       RxD;
#endif

	struct sk_buff  *pSkb;
	INT             i;
	PRTMP_TX_RING   pTxRing;
#if SL_IRQSAVE 
    ULONG			IrqFlags;
#endif

    DBGPRINT(RT_DEBUG_TRACE,"RTMPRingCleanUp(RingIdx=%d, p-NDIS=%d)\n", RingType, pAdapter->RalinkCounters.PendingNdisPacketCount);

	switch (RingType)
	{
		case QID_AC_BK:
		case QID_AC_BE:
		case QID_AC_VI:
		case QID_AC_VO:
		case QID_HCCA:
#if SL_IRQSAVE 
            spin_lock_irqsave(&pAdapter->TxRingLock, IrqFlags);
#else    
            spin_lock_bh(&pAdapter->TxRingLock);
#endif

		    pTxRing = &pAdapter->TxRing[RingType];
			// We have to clean all descriptors in case some error happened with reset
			for (i=0; i<TX_RING_SIZE; i++) // We have to scan all TX ring
			{
#ifndef BIG_ENDIAN
				pTxD  = (PTXD_STRUC) pTxRing->Cell[i].AllocVa;
#else
		        pDestTxD = (PTXD_STRUC) pTxRing->Cell[i].AllocVa;
		        TxD = *pDestTxD;
		        pTxD = &TxD;
		        RTMPDescriptorEndianChange((PUCHAR)pTxD, TYPE_TXD);
#endif

				// release scatter-and-gather NDIS_PACKET
				if (pTxD->pSkb)
				{
                    RELEASE_NDIS_PACKET(pAdapter, pTxD->pSkb);
                    pTxD->pSkb = 0;
                    DBGPRINT(RT_DEBUG_TRACE,"Release 1 skb buffer at TxRing%d[%d]=%d.%d\n", RingType, i, pTxD->Owner, pTxD->bWaitingDmaDoneInt);
				}

                // release scatter-and-gather NDIS_PACKET
                if (pTxD->pNextSkb)
                {
                    RELEASE_NDIS_PACKET(pAdapter, pTxD->pNextSkb);
                    pTxD->pNextSkb = 0;
                    DBGPRINT(RT_DEBUG_TRACE,"Release 1 skb buffer at TxRing%d[%d]\n", RingType, i);
                }

				pTxD->Owner = DESC_OWN_HOST;
                pTxD->bWaitingDmaDoneInt = 0;
#ifdef BIG_ENDIAN
		        RTMPDescriptorEndianChange((PUCHAR)pTxD, TYPE_TXD);
        		WriteBackToDescriptor((PUCHAR)pDestTxD, (PUCHAR)pTxD, FALSE, TYPE_TXD);
#endif
			}
            pTxRing->CurTxIndex = 0;
            pTxRing->NextTxDmaDoneIndex = 0;
#if SL_IRQSAVE 
            spin_unlock_irqrestore(&pAdapter->TxRingLock, (unsigned long) IrqFlags);
#else    
            spin_unlock_bh(&pAdapter->TxRingLock);
#endif

#if SL_IRQSAVE 
            spin_lock_irqsave(&pAdapter->TxSwQueueLock, IrqFlags);
#else    
            spin_lock_bh(&pAdapter->TxSwQueueLock);
#endif

            while (pAdapter->TxSwQueue[RingType].Head != NULL)
            {
                pSkb = (struct sk_buff *)RemoveHeadQueue(&pAdapter->TxSwQueue[RingType]);
                RELEASE_NDIS_PACKET(pAdapter, pSkb);
                DBGPRINT(RT_DEBUG_TRACE,"Release 1 skb buffer from s/w backlog queue\n");
            }
#if SL_IRQSAVE 
            spin_unlock_irqrestore(&pAdapter->TxSwQueueLock, (unsigned long) IrqFlags);
#else    
            spin_unlock_bh(&pAdapter->TxSwQueueLock);
#endif
			break;

		case QID_MGMT:
			// We have to clean all descriptors in case some error happened with reset
#if SL_IRQSAVE 
            spin_lock_irqsave(&pAdapter->MgmtRingLock, IrqFlags);
#else    
            spin_lock_bh(&pAdapter->MgmtRingLock);
#endif    
			for (i=0; i<MGMT_RING_SIZE; i++)
			{
#ifndef BIG_ENDIAN
				pTxD  = (PTXD_STRUC) pAdapter->MgmtRing.Cell[i].AllocVa;
#else
		        pDestTxD = (PTXD_STRUC) pAdapter->MgmtRing.Cell[i].AllocVa;
		        TxD = *pDestTxD;
		        pTxD = &TxD;
		        RTMPDescriptorEndianChange((PUCHAR)pTxD, TYPE_TXD);
#endif

				pTxD->Owner = DESC_OWN_HOST;
                pTxD->bWaitingDmaDoneInt = 0;

                pci_unmap_single(pAdapter->pPci_Dev, pTxD->BufPhyAddr0, pTxD->BufLen0, PCI_DMA_TODEVICE);

				// rlease scatter-and-gather NDIS_PACKET
				if (pTxD->pSkb)
				{
                    RELEASE_NDIS_PACKET(pAdapter, pTxD->pSkb);
                    pTxD->pSkb = 0;
				}
#ifdef BIG_ENDIAN
		        RTMPDescriptorEndianChange((PUCHAR)pTxD, TYPE_TXD);
        		WriteBackToDescriptor((PUCHAR)pDestTxD, (PUCHAR)pTxD, FALSE, TYPE_TXD);
#endif
			}
            pAdapter->MgmtRing.CurTxIndex = 0;
            pAdapter->MgmtRing.NextTxDmaDoneIndex = 0;
#if SL_IRQSAVE 
            spin_unlock_irqrestore(&pAdapter->MgmtRingLock, (unsigned long) IrqFlags);
#else    
            spin_unlock_bh(&pAdapter->MgmtRingLock);
#endif
			pAdapter->RalinkCounters.MgmtRingFullCount = 0;
			break;
			
		case QID_RX:
			// We have to clean all descriptors in case some error happened with reset
#if SL_IRQSAVE 
            spin_lock_irqsave(&pAdapter->RxRingLock, IrqFlags);
#else    
            spin_lock_bh(&pAdapter->RxRingLock);
#endif
			for (i=0; i<RX_RING_SIZE; i++)
			{
#ifndef BIG_ENDIAN
				pRxD  = (PRXD_STRUC) pAdapter->RxRing.Cell[i].AllocVa;
#else
		        pDestRxD = (PRXD_STRUC) pAdapter->RxRing.Cell[i].AllocVa;
		        RxD = *pDestRxD;
		        pRxD = &RxD;
		        RTMPDescriptorEndianChange((PUCHAR)pRxD, TYPE_RXD);
#endif
				pRxD->Owner = DESC_OWN_NIC;
#ifdef BIG_ENDIAN
		        RTMPDescriptorEndianChange((PUCHAR)pRxD, TYPE_RXD);
        		WriteBackToDescriptor((PUCHAR)pDestRxD, (PUCHAR)pRxD, FALSE, TYPE_RXD);
#endif				
			}
            pAdapter->RxRing.CurRxIndex = 0;
#if SL_IRQSAVE 
            spin_unlock_irqrestore(&pAdapter->RxRingLock, (unsigned long) IrqFlags);
#else    
            spin_unlock_bh(&pAdapter->RxRingLock);
#endif
			break;
			
		default:
			break;
			
	}
}
#ifndef BIG_ENDIAN
/*
    ========================================================================

    Routine Description:
        Compare two memory block

    Arguments:
        Adapter                     Pointer to our adapter

    Return Value:
        1:          memory are equal
        0:          memory are not equal

    Note:

    ========================================================================
*/
ULONG   RTMPEqualMemory(
    IN  PVOID   pSrc1,
    IN  PVOID   pSrc2,
    IN  ULONG   Length)
{
    PUCHAR  pMem1;
    PUCHAR  pMem2;
    ULONG   Index = 0;

    pMem1 = (PUCHAR) pSrc1;
    pMem2 = (PUCHAR) pSrc2;

    for (Index = 0; Index < Length; Index++)
    {
        if (pMem1[Index] != pMem2[Index])
        {
            break;
        }
    }

    if (Index == Length)
    {
        return (1);
    }
    else
    {
        return (0);
	}
}
#endif
/*
    ========================================================================

    Routine Description:
        Compare two memory block

    Arguments:
		pSrc1		Pointer to first memory address
		pSrc2		Pointer to second memory addres

    Return Value:
        0:          memory is equal
        1:          pSrc1 memory is larger
        2:          pSrc2 memory is larger

    Note:

    ========================================================================
*/
ULONG   RTMPCompareMemory(
    IN  PVOID   pSrc1,
    IN  PVOID   pSrc2,
    IN  ULONG   Length)
{
    PUCHAR  pMem1;
    PUCHAR  pMem2;
    ULONG   Index = 0;

    pMem1 = (PUCHAR) pSrc1;
    pMem2 = (PUCHAR) pSrc2;

    for (Index = 0; Index < Length; Index++)
    {
        if (pMem1[Index] > pMem2[Index])
            return (1);
        else if (pMem1[Index] < pMem2[Index])
            return (2);
    }

    // Equal
    return (0);
}

/*
	========================================================================
	
	Routine Description:
		Zero out memory block

	Arguments:
		pSrc1		Pointer to memory address
		Length		Size

	Return Value:
		None
		
	Note:
		
	========================================================================
*/
VOID    NdisZeroMemory(
    IN  PVOID   pSrc,
    IN  ULONG   Length)
{
    memset(pSrc, 0, Length);
}

VOID    NdisFillMemory(
    IN  PVOID   pSrc,
    IN  ULONG   Length,
    IN  UCHAR   Fill)
{
    memset(pSrc, Fill, Length);
}

/*
	========================================================================
	
	Routine Description:
		Copy data from memory block 1 to memory block 2

	Arguments:
		pDest		Pointer to destination memory address
		pSrc		Pointer to source memory address
		Length		Copy size
		
	Return Value:
		None

	Note:
		
	========================================================================
*/
VOID    NdisMoveMemory(
    OUT PVOID   pDest,
    IN  PVOID   pSrc,
    IN  ULONG   Length)
{
#ifdef RTMP_EMBEDDED
    if(Length <= 8)
	{
		*(((PUCHAR)pDest)++) = *(((PUCHAR)pSrc)++);
		if(--Length == 0)	return;
		*(((PUCHAR)pDest)++) = *(((PUCHAR)pSrc)++);
		if(--Length == 0)	return;
		*(((PUCHAR)pDest)++) = *(((PUCHAR)pSrc)++);
		if(--Length == 0)	return;
		*(((PUCHAR)pDest)++) = *(((PUCHAR)pSrc)++);
		if(--Length == 0)	return;
		*(((PUCHAR)pDest)++) = *(((PUCHAR)pSrc)++);
		if(--Length == 0)	return;
		*(((PUCHAR)pDest)++) = *(((PUCHAR)pSrc)++);
		if(--Length == 0)	return;
		*(((PUCHAR)pDest)++) = *(((PUCHAR)pSrc)++);
		if(--Length == 0)	return;
		*(((PUCHAR)pDest)++) = *(((PUCHAR)pSrc)++);
		if(--Length == 0)	return;
	}
	else
	    memcpy(pDest, pSrc, Length);
#else
    memcpy(pDest, pSrc, Length);
#endif
}

/*
	========================================================================
	
	Routine Description:
		Initialize port configuration structure

	Arguments:
		Adapter						Pointer to our adapter

	Return Value:
		None

	Note:
		
	========================================================================
*/
VOID	PortCfgInit(
	IN	PRTMP_ADAPTER pAd)
{
    UINT i;

    DBGPRINT(RT_DEBUG_TRACE, "--> PortCfgInit\n");    

    for(i = 0; i < SHARE_KEY_NUM; i++) 
    {
        pAd->SharedKey[i].KeyLen = 0;  
        pAd->SharedKey[i].CipherAlg = CIPHER_NONE;  
    }

    pAd->Antenna.field.TxDefaultAntenna = 2;    // Ant-B
    pAd->Antenna.field.RxDefaultAntenna = 2;    // Ant-B
    pAd->Antenna.field.NumOfAntenna = 2;

    pAd->LedCntl.field.LedMode = LED_MODE_DEFAULT;
    pAd->LedIndicatorStregth = 0;

	pAd->bAutoTxAgcA = FALSE;			// Default is OFF
	pAd->bAutoTxAgcG = FALSE;			// Default is OFF
    pAd->RfIcType = RFIC_5225;
    pAd->PortCfg.PhyMode = 0xff;     // unknown
    pAd->PortCfg.BandState = UNKNOWN_BAND;
    
    
    init_timer(&pAd->RfTuningTimer);
    pAd->RfTuningTimer.data = (unsigned long)pAd;
	pAd->RfTuningTimer.function = &AsicRfTuningExec;

    pAd->bAcceptDirect = TRUE;
    pAd->bAcceptMulticast = FALSE;
    pAd->bAcceptBroadcast = TRUE;
    pAd->bAcceptAllMulticast = TRUE;

    pAd->bLocalAdminMAC = FALSE; //TRUE;
   
    pAd->PortCfg.Dsifs = 10;      // in units of usec 
    pAd->PortCfg.PrivacyFilter = Ndis802_11PrivFilterAcceptAll;
    pAd->PortCfg.TxPower = 100; //mW
    pAd->PortCfg.TxPowerPercentage = 0xffffffff; // AUTO
    pAd->PortCfg.TxPowerDefault = 0xffffffff; // AUTO
    pAd->PortCfg.TxPreamble = Rt802_11PreambleAuto; // use Long preamble on TX by defaut
    pAd->PortCfg.RtsThreshold = 2347;
    pAd->PortCfg.FragmentThreshold = 2346;
    pAd->PortCfg.UseBGProtection = 0;    // 0: AUTO
    pAd->PortCfg.bEnableTxBurst = 0;
    
    // PHY specification
    pAd->PortCfg.PhyMode = PHY_11BG_MIXED;
    OPSTATUS_CLEAR_FLAG(pAd, fOP_STATUS_SHORT_PREAMBLE_INUSED);  // CCK use LONG preamble
	
	
    pAd->PortCfg.Psm = PWR_ACTIVE;
    pAd->PortCfg.BeaconPeriod = 100;     // in mSec

    // Patch for Ndtest
	pAd->PortCfg.ScanCnt = 0;

    pAd->PortCfg.bIEEE80211H = FALSE;
    pAd->PortCfg.RadarDetect.RDMode = RD_NORMAL_MODE; 

	pAd->PortCfg.AuthMode = Ndis802_11AuthModeOpen;
    pAd->PortCfg.WepStatus = Ndis802_11EncryptionDisabled;
    pAd->PortCfg.PairCipher = Ndis802_11EncryptionDisabled;
    pAd->PortCfg.GroupCipher = Ndis802_11EncryptionDisabled;
    pAd->PortCfg.bMixCipher = FALSE;
    pAd->PortCfg.DefaultKeyId = 0;

	// 802.1x port control
	pAd->PortCfg.PortSecured = WPA_802_1X_PORT_NOT_SECURED;
	pAd->PortCfg.LastMicErrorTime = 0;
	pAd->PortCfg.MicErrCnt        = 0;
	pAd->PortCfg.bBlockAssoc      = FALSE;
	pAd->PortCfg.WpaState         = SS_NOTUSE;		// Handle by microsoft unless RaConfig changed it.

    pAd->PortCfg.RssiTrigger = 0;
    pAd->PortCfg.LastRssi = 0;
    pAd->PortCfg.LastRssi2 = 0;
    pAd->PortCfg.AvgRssi  = 0;
    pAd->PortCfg.AvgRssiX8 = 0;
    pAd->PortCfg.RssiTriggerMode = RSSI_TRIGGERED_UPON_BELOW_THRESHOLD;
    pAd->PortCfg.AtimWin = 0;
    pAd->PortCfg.DefaultListenCount = 3;//default listen count;
    pAd->PortCfg.BssType = BSS_INFRA;  // BSS_INFRA or BSS_ADHOC

    // global variables mXXXX used in MAC protocol state machines
    OPSTATUS_SET_FLAG(pAd, fOP_STATUS_RECEIVE_DTIM);
    OPSTATUS_CLEAR_FLAG(pAd, fOP_STATUS_ADHOC_ON);
    OPSTATUS_CLEAR_FLAG(pAd, fOP_STATUS_INFRA_ON);

   
    // user desired power mode
    pAd->PortCfg.WindowsPowerMode = Ndis802_11PowerModeCAM;
    pAd->PortCfg.WindowsBatteryPowerMode = Ndis802_11PowerModeCAM;
    pAd->PortCfg.bWindowsACCAMEnable = FALSE;

 
	init_timer(&pAd->PortCfg.QuickResponeForRateUpTimer);
	pAd->PortCfg.QuickResponeForRateUpTimer.data = (unsigned long)pAd;
	pAd->PortCfg.QuickResponeForRateUpTimer.function = &StaQuickResponeForRateUpExec;
	pAd->PortCfg.QuickResponeForRateUpTimerRunning = FALSE;


    pAd->PortCfg.bHwRadio  = TRUE; // Default Hardware Radio status is On
    pAd->PortCfg.bSwRadio  = TRUE; // Default Software Radio status is On
    pAd->PortCfg.bRadio    = TRUE; // bHwRadio && bSwRadio
    pAd->PortCfg.bHardwareRadio = FALSE;		// Default is OFF
	pAd->PortCfg.bShowHiddenSSID = FALSE;		// Default no show 
	
    // Nitro mode control
	pAd->PortCfg.bAutoReconnect = TRUE;

	// Save the init time as last scan time, the system should do scan after 2 seconds.
	// This patch is for driver wake up from standby mode, system will do scan right away.
	pAd->PortCfg.LastScanTime = 0;

	// Default for extra information is not valid
	pAd->ExtraInfo = EXTRA_INFO_CLEAR;
	
	// Default Config change flag
	pAd->bConfigChanged = FALSE;

	// dynamic BBP R17:sensibity tuning to overcome background noise
  	pAd->BbpTuning.bEnable                = TRUE;  
	pAd->BbpTuning.R17LowerBoundG         = 0x20; // for best RX sensibility
	pAd->BbpTuning.R17UpperBoundG         = 0x40; // for best RX noise isolation to prevent false CCA
	pAd->BbpTuning.R17LowerBoundA         = 0x28; // for best RX sensibility
	pAd->BbpTuning.R17UpperBoundA         = 0x48; // for best RX noise isolation to prevent false CCA
	pAd->BbpTuning.FalseCcaLowerThreshold = 100;
	pAd->BbpTuning.FalseCcaUpperThreshold = 512;   
	pAd->BbpTuning.R17Delta               = 1;


	pAd->Bbp94 = BBPR94_DEFAULT;
	pAd->BbpForCCK = FALSE;
	
#ifdef RALINK_ATE
	memset(&pAd->ate, 0, sizeof(ATE_INFO));
	pAd->ate.Mode = ATE_STASTART;
	pAd->ate.TxCount = TX_RING_SIZE;
	pAd->ate.TxLength = 1024;
	pAd->ate.TxRate = RATE_11;
    pAd->ate.Channel = 1;
    pAd->ate.Addr1[0] = 0x00;
    pAd->ate.Addr1[1] = 0x11;
    pAd->ate.Addr1[2] = 0x22;
    pAd->ate.Addr1[3] = 0xAA;
    pAd->ate.Addr1[4] = 0xBB;
    pAd->ate.Addr1[5] = 0xCC;
	memcpy(&pAd->ate.Addr2, pAd->ate.Addr1, MAC_ADDR_LEN);
	memcpy(&pAd->ate.Addr3, pAd->ate.Addr1, MAC_ADDR_LEN);
#endif	//RALINK_ATE

    DBGPRINT(RT_DEBUG_TRACE, "<-- PortCfgInit\n");

}

UCHAR BtoH(
	IN CHAR		ch)
{
    if (ch >= '0' && ch <= '9') return (ch - '0');        // Handle numerals
    if (ch >= 'A' && ch <= 'F') return (ch - 'A' + 0xA);  // Handle capitol hex digits
    if (ch >= 'a' && ch <= 'f') return (ch - 'a' + 0xA);  // Handle small hex digits
    return(255);
}

//
//  PURPOSE:  Converts ascii string to network order hex
//
//  PARAMETERS:
//    src    - pointer to input ascii string
//    dest   - pointer to output hex
//    destlen - size of dest
//
//  COMMENTS:
//
//    2 ascii bytes make a hex byte so must put 1st ascii byte of pair
//    into upper nibble and 2nd ascii byte of pair into lower nibble.
//
VOID AtoH(
	IN CHAR		*src,
	OUT UCHAR	*dest,
	IN INT		destlen)
{
    CHAR *srcptr;
    PUCHAR destTemp;

    srcptr = src;   
    destTemp = (PUCHAR) dest; 

    while(destlen--)
    {
        *destTemp = BtoH(*srcptr++) << 4;    // Put 1st ascii byte in upper nibble.
        *destTemp += BtoH(*srcptr++);      // Add 2nd ascii byte to above.
        destTemp++;
    }
}

// Unify all delay routine by using udelay
VOID	RTMPusecDelay(
	IN	ULONG	usec)
{
	ULONG	i;

	for (i = 0; i < (usec / 50); i++)
		udelay(50);

	if (usec % 50)
		udelay(usec % 50);
}

/*
	========================================================================
	
	Routine Description:
		Set LED Status

	Arguments:
		pAd						Pointer to our adapter
		Status					LED Status

	Return Value:
		None

	Note:
		
	========================================================================
*/
VOID RTMPSetLED(
	IN PRTMP_ADAPTER 	pAd, 
	IN UCHAR			Status)
{
	UCHAR			HighByte=0;
	UCHAR			LowByte=0;

	switch (Status)
	{
		case LED_LINK_DOWN:
			pAd->LedCntl.field.LinkGStatus = 0;
			pAd->LedCntl.field.LinkAStatus = 0;
			
			HighByte = pAd->LedCntl.word >> 8;
			LowByte = pAd->LedCntl.word & 0xFF;			
			AsicSendCommandToMcu(pAd, 0x50, 0xff, LowByte, HighByte);
			pAd->LedIndicatorStregth = 0; 
			break;
		case LED_LINK_UP:
			if (pAd->PortCfg.Channel <= 14)
			{
				// 11 G mode
				pAd->LedCntl.field.LinkGStatus = 1;
				pAd->LedCntl.field.LinkAStatus = 0;
			}
			else
			{ 
				//11 A mode
				pAd->LedCntl.field.LinkGStatus = 0;
				pAd->LedCntl.field.LinkAStatus = 1;
			}
			
			HighByte = pAd->LedCntl.word >> 8;
			LowByte = pAd->LedCntl.word & 0xFF;			
			AsicSendCommandToMcu(pAd, 0x50, 0xff, LowByte, HighByte);
			break;
		case LED_RADIO_ON:
			pAd->LedCntl.field.RadioStatus = 1;
			HighByte = pAd->LedCntl.word >> 8;
			LowByte = pAd->LedCntl.word & 0xFF;
			AsicSendCommandToMcu(pAd, 0x50, 0xff, LowByte, HighByte);
			break;
		case LED_HALT: 
			//Same as Radio Off.
		case LED_RADIO_OFF:
			pAd->LedCntl.field.RadioStatus = 0;
			pAd->LedCntl.field.LinkGStatus = 0;
			pAd->LedCntl.field.LinkAStatus = 0;
			HighByte = pAd->LedCntl.word >> 8;
			LowByte = pAd->LedCntl.word & 0xFF;
			AsicSendCommandToMcu(pAd, 0x50, 0xff, LowByte, HighByte);
			break;
		default:
			DBGPRINT(RT_DEBUG_WARN, "RTMPSetLED::Unknown Status %d\n", Status);
			break;
	}

	DBGPRINT(RT_DEBUG_INFO, "RTMPSetLED::Mode=%d,HighByte=0x%02x,LowByte=0x%02x\n", pAd->LedCntl.field.LedMode, HighByte, LowByte);
}

/*
	========================================================================
	
	Routine Description:
		Set LED Signal Stregth 

	Arguments:
		pAd						Pointer to our adapter
		Dbm						Signal Stregth

	Return Value:
		None


	Note:
		Can be run on any IRQL level. 

		According to Microsoft Zero Config Wireless Signal Stregth definition as belows.
		<= -90  No Signal
		<= -81  Very Low
		<= -71  Low
		<= -67  Good
		<= -57  Very Good
		 > -57  Excellent		
	========================================================================
*/
VOID RTMPSetSignalLED(
	IN PRTMP_ADAPTER 	pAd, 
	IN NDIS_802_11_RSSI Dbm)
{
	UCHAR		nLed = 0;

	//
	// if not Signal Stregth, then do nothing.
	//
	if (pAd->LedCntl.field.LedMode != LED_MODE_SIGNAL_STREGTH)
	{
		return;
	}

	if (Dbm <= -90)
		nLed = 0;
	else if (Dbm <= -81)
		nLed = 1;
	else if (Dbm <= -71)
		nLed = 2;
	else if (Dbm <= -67)
		nLed = 3;
	else if (Dbm <= -57)
		nLed = 4;
	else 
		nLed = 5;

	//
	// Update Signal Stregth to firmware if changed.
	//
	if (pAd->LedIndicatorStregth != nLed)
	{
		AsicSendCommandToMcu(pAd, 0x52, 0xff, nLed, 0);
		pAd->LedIndicatorStregth = nLed;
	}	
}

