/*
  
  Marvell Libertas wireless driver

  Copyright (c) 2005 Luc Saillard <luc@saillard.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
  Boston, MA 02110-1301, USA.

*/

#include <linux/firmware.h>
#include "mrv8k.h"

#ifdef MRV8K_INCLUDE_FIRMWARE
#include "mrv8k_fw_boot.h"
#include "mrv8k_fw_main.h"
#endif

/**
 * Load the bootloader in memory
 *
 */
int mrv8k_load_firmwares(struct mrv8k_private *priv)
{
	int rc;

	rc = request_firmware(&priv->bootloader, "mrv8k-b.fw", &priv->pci_dev->dev);
	if (rc < 0) {
		MRV8K_ERROR("Firmware 'mrv8k-b.fw' not available or load failed.\n");
		return rc;
	}
	MRV8K_DEBUG_FIRMWARE("bootloader data at %p size %Zd",
			     priv->bootloader->data, priv->bootloader->size);

	rc = request_firmware(&priv->firmware, "mrv8k-f.fw", &priv->pci_dev->dev);
	if (rc < 0) {
		MRV8K_ERROR("Firmware 'mrv8k-f.fw' not available or load failed.\n");
		return rc;
	}
	MRV8K_DEBUG_FIRMWARE("firmware data at %p size %Zd",
			     priv->firmware->data, priv->firmware->size);
	return 0;
}

void mrv8k_release_firmwares(struct mrv8k_private *priv)
{
	 release_firmware(priv->firmware);
	 release_firmware(priv->bootloader);
	 priv->firmware = NULL;
	 priv->bootloader = NULL;
}


/*
 * vim:sw=8:sts=8:ts=8:cino=
 */

