/*
 * Copyright 2007	Luis R. Rodriguez <mcgrof@winlab.rutgers.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Compatibility file for Linux wireless for kernels 2.6.22 - tip
 * The headers don't need to be modified as we're simply adding them.
 */

#include <net/compat.h>

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,28))

/* 2.6.27 compat code goes here */

void __iomem *pci_ioremap_bar(struct pci_dev *pdev, int bar)
{
	/*
	 * Make sure the BAR is actually a memory resource, not an IO resource
	 */
	if (!(pci_resource_flags(pdev, bar) & IORESOURCE_MEM)) {
		WARN_ON(1);
		return NULL;
	}
	return ioremap_nocache(pci_resource_start(pdev, bar),
				     pci_resource_len(pdev, bar));
}
EXPORT_SYMBOL_GPL(pci_ioremap_bar);

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,6,28) */

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,29))

/* 2.6.28 compat code goes here */

#endif /* LINUX_VERSION_CODE < KERNEL_VERSION(2,6,29) */

