import unittest, shutil, tempfile
from linda.funcs import run_external_cmd
from linda.parser.data import DataFileParser
from sets import Set

class DataFileParserTest(unittest.TestCase):
    def setUp(self):
        self.dir = tempfile.mkdtemp()
        run_external_cmd('tar zxCf %s tests/parser_data.tar.gz' % \
            self.dir)

    def tearDown(self):
        shutil.rmtree(self.dir)

    def test_correct_data(self):
        "Check a correct data file parses"
        dfp = DataFileParser('%s/correct.data' % self.dir)
        keys = Set(('incorrect-standards-version', \
            'ancient-standards-version'))
        self.assertEqual(keys.intersection(dfp.keys()), keys)
        self.assertEqual(dfp['incorrect-standards-version'].keys(), ['Type'])
        points = Set(('Justification', 'Type'))
        self.assertEqual(points.intersection(dfp['ancient-standards-version'].keys()), points)
        self.assertEqual(dfp['incorrect-standards-version']['Type'], 'Error')
        self.assertEqual(dfp['ancient-standards-version']['Type'], 'Error')
        self.assertEqual(dfp['ancient-standards-version']['Justification'], \
            'Policy, section 2.4.1')
        
    def test_missing(self):
        "Check an errornous stanza isn't parsed"
        dfp = DataFileParser('%s/missing.data' % self.dir)
        self.assertEqual(dfp.keys(), ['incorrect-standards-version'])
        self.assertEqual(dfp['incorrect-standards-version'].keys(), ['Type'])
        self.assertEqual(dfp['incorrect-standards-version']['Type'], 'Error')

