import sys, os, unittest, linda, tempfile
from linda import clparser
from linda.funcs import run_external_cmd
from linda.output import OutputFormats
from linda.parser.clparser import CLParser

class FigletOutputTest(unittest.TestCase):
    def setUp(self):
        self.filename = tempfile.mkstemp()[1]
        linda.outputformats = OutputFormats()
        execfile('output/figlet.py')
        for klass in linda.outputformats.registry.keys():
            self.instance = linda.outputformats.registry[klass]()
        clparser = CLParser()
        
    def tearDown(self):
        os.unlink(self.filename)
        
    def test_output(self):
        "Check the output FigletOutput gives"
        if not os.path.exists('/usr/bin/figlet'):
            return None
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.pkg_name = 'test'
        self.instance.type_char = 'E'
        self.instance.description = ['Lala']
        self.instance.data = []
        method = getattr(self.instance, 'print_short')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        file = []
        f = open(self.filename)
        for line in f:
            file.append(line[:-1])
        self.assertEqual(len(file), 6)
        f.close()
        f = open(self.filename, 'w')
        f.close()

    def test_output_data(self):
        "Check the output FigletOutput gives with data provided"
        if not os.path.exists('/usr/bin/figlet'):
            return None
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.pkg_name = 'test'
        self.instance.type_char = 'E'
        self.instance.description = ['%s Lala %s']
        self.instance.data = ['a', 'b']
        method = getattr(self.instance, 'print_short')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        file = []
        f = open(self.filename)
        for line in f:
            file.append(line[:-1])
        self.assertEqual(len(file), 6)
        f.close()
        f = open(self.filename, 'w')
        f.close()

    def test_long(self):
        "Check the long output FigletOutput gives"
        if not os.path.exists('/usr/bin/figlet'):
            return None
        f = open(self.filename, 'w')
        sys.stdout = f
        self.instance.pkg_name = 'test'
        self.instance.type_char = 'E'
        self.instance.description = ['', ' Foo bar baz']
        method = getattr(self.instance, 'print_long')
        method()
        f.close()
        sys.stdout = sys.__stdout__
        file = []
        f = open(self.filename)
        for line in f:
            file.append(line[:-1])
        self.assertEqual(len(file), 6)
        f.close()
        f = open(self.filename, 'w')
        f.close()

