import unittest, gettext, os, linda
from linda.debug import dprint
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from sets import Set

linda.checks = Checks()

class ControlCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/control.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})

    def test_build_depends(self):
        "Check build_depends() method of ControlCheck"
        method = getattr(self.instance, 'build_depends')
        self.instance.information['control'] = {'self': [{'build-depends': \
            {'debhelper': {'arch': '', 'relation': ''}}}]}
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        self.instance.information['control']['self'][0]['build-depends'] = \
            {'debhelper': {'arch': ['some'], 'relation': ''}}
        method()
        self.assert_('invalid-arch-in-b-d' in self.instance.err_dict.keys())
        self.instance.information['control']['self'][0]['build-depends'] = \
            {'automake': {'arch': '', 'relation': ''}}
        method()
        self.assert_('package-b-d-on-autostar' in \
            self.instance.err_dict.keys())

    def test_source(self):
        "Check source() method of ControlCheck"
        method = getattr(self.instance, 'source')
        self.instance.information['control'] = {'self': [{'essential': \
            'maybe'}]}
        method()
        self.assert_('essential-field-in-source' in \
            self.instance.err_dict.keys())
        self.instance.information['control']['self'][0] = {}
        method()
        self.assert_('no-source-field-in-source' in \
            self.instance.err_dict.keys())
        for key in self.instance.err_dict.keys():
            del self.instance.err_dict[key]
        self.instance.information['control']['self'][0]['description'] = \
           ['foo\n', ' foobar\n']
        method()
        self.assert_('char-forbidden-rfc822' not in \
           self.instance.err_dict.keys())
        self.instance.information['control']['self'][0]['source'] = \
            '%s%s' % (chr(129), chr(176))
        method()
        expected_errs = Set(('bad-source-field', 'source-not-like-package', \
            'char-forbidden-rfc822'))
        self.assertEqual(expected_errs.intersection(self.instance.err_dict.keys()), expected_errs)
        self.instance.information['control']['self'][0]['architecture'] = 'all'
        method()

