import unittest, gettext, os, linda, tempfile, shutil
from linda.debug import dprint
from linda.funcs import run_external_cmd
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks

linda.checks = Checks()

class ChangelogCheckSourceTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/changelog.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['source'][2]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.instance.information['dir'] = tempfile.mkdtemp()
        os.mkdir('%s/debian' % self.instance.information['dir'])
        run_external_cmd('tar zxCf %s tests/source_changelog.tar.gz' % \
            self.instance.information['dir'])

    def tearDown(self):
        shutil.rmtree(self.instance.information['dir'])

    def test_check_version(self):
        "Check the sanity of ChangelogCheck"
        method = getattr(self.instance, 'check_version')
        os.rename('%s/changelog.fine' % self.instance.information['dir'], \
            '%s/debian/changelog' % self.instance.information['dir'])
        method()
        self.assertEqual(self.instance.err_dict.keys(), [])
        os.unlink('%s/debian/changelog' % self.instance.information['dir'])
        os.rename('%s/changelog.wrong' % self.instance.information['dir'], \
            '%s/debian/changelog' % self.instance.information['dir'])
        method()
        self.assert_('next-ver-less-than-prev' in \
            self.instance.err_dict.keys())
        os.unlink('%s/debian/changelog' % self.instance.information['dir'])
        os.rename('%s/changelog.switch' % self.instance.information['dir'], \
            '%s/debian/changelog' % self.instance.information['dir'])
        method()
        self.assert_('switching-native-nonnative' in \
            self.instance.err_dict.keys())
        os.unlink('%s/debian/changelog' % self.instance.information['dir'])

