import sys, unittest
from linda.parser.clparser import CLParser, CLParsingException

class CLParserTest(unittest.TestCase):
    def test_empty(self):
        "Check passing no arguments"
        sys.argv = [sys.argv[0]]
        clparser = CLParser()
        self.assertEqual(clparser['files'], [])
        
    def test_numerical_arguments(self):
        "Check parsing of simple numeric arguments"
        sys.argv = [sys.argv[0], '-D', '-i', '-n', '-o', '-p', '-P', '-q', \
            '-s', '-T']
        clparser = CLParser()
        self.assertEqual(clparser['disable-local'] + clparser['info'] + \
            clparser['no-cull'] + clparser['show-overridden'] + \
            clparser['print-overrides'] + clparser['profiling'] + \
            clparser['quiet'] + clparser['show-tag'] + \
            clparser['traceback'], 9)

    def test_mulitple_numeric_args(self):
        "Check parsing of multiple numeric arguments"
        sys.argv = [sys.argv[0], '-d', '-v', '-d', '-d']
        clparser = CLParser()
        self.assertEqual(clparser['debug'], 3)
        self.assertEqual(clparser['verbose'], 1)

    def test_list_checks(self):
        "Check parsing of list-checks"
        sys.argv = [sys.argv[0], '-L', 'foo']
        # assertRaises is way stupid
        try:
            clparser = CLParser()
        except CLParsingException:
            pass
        else:
            self.fail()
        sys.argv[2] = 'all'
        clparser = CLParser()
        self.assertEqual(clparser['list-checks'], (('binary', 'source'), \
            (1, 2)))
        sys.argv[2] = 'src1'
        clparser = CLParser()
        self.assertEqual(clparser['list-checks'], (('source',), (1,)))
        sys.argv[2] = 'bin2'
        clparser = CLParser()
        self.assertEqual(clparser['list-checks'], (('binary',), (2,)))

    def test_unpack(self):
        "Check parsing of unpack"
        sys.argv = [sys.argv[0], '-u', '3']
        try:
            clparser = CLParser()
        except CLParsingException:
            pass
        else:
            self.fail()
        sys.argv[2] = '1'
        clparser = CLParser()
        self.assertEqual(clparser['unpack'], 1)

    def test_lab_config(self):
        "Check printing of lab-root and config"
        things_check = {'-l': 'lab-root', '-c': 'config'}
        for thing in things_check.keys():
            sys.argv = [sys.argv[0], thing, '/usr/local/lala']
            try:
                clparser = CLParser()
            except CLParsingException:
                pass
            else:
                self.fail()
            sys.argv[2] = '/tmp'
            clparser = CLParser()
            self.assertEqual(clparser[things_check[thing]], '/tmp')

    def test_moreoverrides(self):
        "Check parsing of more-overiddes"
        sys.argv = [sys.argv[0], '-m', '/usr/local/lala']
        try:
            clparser = CLParser()
        except CLParsingException:
            pass
        else:
            self.fail()
        sys.argv[2] = '/bin/ls'
        clparser = CLParser()
        self.assertEqual(clparser['more-overrides'], '/bin/ls')

    def test_types(self):
        "Check parsing of types"
        sys.argv = [sys.argv[0], '-t', 'E,W,F']
        try:
            clparser = CLParser()
        except CLParsingException:
            pass
        else:
            self.fail()
        sys.argv[2] = 'E, W, F'
        try:
            clparser = CLParser()
        except CLParsingException:
            pass
        else:
            self.fail()
        sys.argv[2] = 'E,W'
        clparser = CLParser()
        self.assertEqual(clparser['types'], ['E', 'W'])

