import unittest, gettext, os, linda, tempfile, shutil
from po_count import POFileParser
from linda.debug import dprint
from linda.parser.datavalidator import DataValidator
from linda.libchecks import Checks
from sets import Set

linda.checks = Checks()

class UDebControlCheckUDebTest(unittest.TestCase):
    def setUp(self):
        execfile('checks/udebcontrol.py', {'_': gettext.gettext, 'dprint': \
            dprint, 'DataValidator': DataValidator, 'os': os})
        for klass in linda.checks.registry['udeb'][1]:
            self.instance = klass('/tmp', '/tmp/test_0.0.1-1_all.deb', {})
        self.po_keys = POFileParser('po/en.po')
        
    def test_control(self):
        "Check the sanity of UDebControlCheck"
        method = getattr(self.instance, 'check_control')
        self.instance.information['control'] = {'self': [{'priority': \
            'foo', 'section': 'video', 'essential': 'yes'}], 'info': \
            {'preinst': ''}}
        method()
        expected_errs = Set(('section-not-di', 'unknown-priority', \
            'invalid-control-header', 'invalid-control-file'))
        self.assertEqual(expected_errs.intersection(self.instance.err_dict.keys()), expected_errs)
        for key in expected_errs:
            self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
                key), True)
        self.instance.information['control']['self'][0] = {'depends-orig': \
            'lala|foo'}
        method()
        self.assert_('no-dependency-alternatives' in self.instance.err_dict.keys())
        self.assertEqual(self.po_keys.compare(self.instance.err_dict, \
            'no-dependency-alternatives'), True)

