/* Editor Settings: expandtabs and use 4 spaces for indentation
 * ex: set softtabstop=4 tabstop=8 expandtab shiftwidth=4: *
 */

/*
 * Copyright Likewise Software    2004-2008
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.  You should have received a copy of the GNU General
 * Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * LIKEWISE SOFTWARE MAKES THIS SOFTWARE AVAILABLE UNDER OTHER LICENSING
 * TERMS AS WELL.  IF YOU HAVE ENTERED INTO A SEPARATE LICENSE AGREEMENT
 * WITH LIKEWISE SOFTWARE, THEN YOU MAY ELECT TO USE THE SOFTWARE UNDER THE
 * TERMS OF THAT SOFTWARE LICENSE AGREEMENT INSTEAD OF THE TERMS OF THE GNU
 * GENERAL PUBLIC LICENSE, NOTWITHSTANDING THE ABOVE NOTICE.  IF YOU
 * HAVE QUESTIONS, OR WISH TO REQUEST A COPY OF THE ALTERNATE LICENSING
 * TERMS OFFERED BY LIKEWISE SOFTWARE, PLEASE CONTACT LIKEWISE SOFTWARE AT
 * license@likewisesoftware.com
 */

/*
 * Copyright (C) Likewise Software. All rights reserved.
 *
 * Module Name:
 *
 *        ipc_protocol.c
 *
 * Abstract:
 *
 *        Likewise Security and Authentication Subsystem (LSASS)
 *
 *
 *
 * Authors: Krishna Ganugapati (krishnag@likewisesoftware.com)
 *          Sriram Nambakam (snambakam@likewisesoftware.com)
 *          Wei Fu (wfu@likewisesoftware.com)
 *
 */

#include "ipc.h"

static LWMsgTypeSpec gLsaIPCErrorSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_IPC_ERROR),
    LWMSG_MEMBER_UINT32(LSA_IPC_ERROR, dwError),
    LWMSG_MEMBER_PSTR(LSA_IPC_ERROR, pszErrorMessage),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaStringSpec[] =
{
    LWMSG_PSTR,
    LWMSG_TYPE_END
};

LWMsgTypeSpec gLsaGroupInfo0Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_GROUP_INFO_0),
    LWMSG_MEMBER_UINT32(LSA_GROUP_INFO_0, gid),
    LWMSG_MEMBER_PSTR(LSA_GROUP_INFO_0, pszName),
    LWMSG_MEMBER_PSTR(LSA_GROUP_INFO_0, pszSid),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

LWMsgTypeSpec gLsaGroupInfo1Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_GROUP_INFO_1),
    LWMSG_MEMBER_UINT32(LSA_GROUP_INFO_1, gid),
    LWMSG_MEMBER_PSTR(LSA_GROUP_INFO_1, pszName),
    LWMSG_MEMBER_PSTR(LSA_GROUP_INFO_1, pszSid),
    LWMSG_MEMBER_PSTR(LSA_GROUP_INFO_1, pszDN),
    LWMSG_MEMBER_PSTR(LSA_GROUP_INFO_1, pszPasswd),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_GROUP_INFO_1, ppszMembers),
    LWMSG_PSTR,
    LWMSG_POINTER_END,
    LWMSG_ATTR_ZERO_TERMINATED,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

#define GROUP_INFO_LEVEL_0 0
#define GROUP_INFO_LEVEL_1 1

LWMsgTypeSpec gLsaGroupInfoListSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_GROUP_INFO_LIST),
    LWMSG_MEMBER_UINT32(LSA_GROUP_INFO_LIST, dwGroupInfoLevel),
    LWMSG_MEMBER_UINT32(LSA_GROUP_INFO_LIST, dwNumGroups),
    LWMSG_MEMBER_UNION_BEGIN(LSA_GROUP_INFO_LIST, ppGroupInfoList),
    LWMSG_MEMBER_POINTER_BEGIN(union _GROUP_INFO_LIST, ppInfoList0),
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaGroupInfo0Spec),
    LWMSG_POINTER_END,
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_GROUP_INFO_LIST, dwNumGroups),
    LWMSG_ATTR_TAG(GROUP_INFO_LEVEL_0),
    LWMSG_MEMBER_POINTER_BEGIN(union _GROUP_INFO_LIST, ppInfoList1),
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaGroupInfo1Spec),
    LWMSG_POINTER_END,
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_GROUP_INFO_LIST, dwNumGroups),
    LWMSG_ATTR_TAG(GROUP_INFO_LEVEL_1),
    LWMSG_UNION_END,
    LWMSG_ATTR_DISCRIM(LSA_GROUP_INFO_LIST, dwGroupInfoLevel),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaUserInfo0Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_USER_INFO_0),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_0, uid),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_0, gid),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_0, pszName),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_0, pszPasswd),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_0, pszGecos),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_0, pszShell),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_0, pszHomedir),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_0, pszSid),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaUserInfo1Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_USER_INFO_1),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_1, uid),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_1, gid),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_1, pszName),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_1, pszPasswd),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_1, pszGecos),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_1, pszShell),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_1, pszHomedir),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_1, pszSid),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_1, pszDN),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_1, pszUPN),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_1, bIsGeneratedUPN),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_1, bIsLocalUser),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_1, dwLMHashLen),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_USER_INFO_1, pLMHash),
    LWMSG_UINT8(BYTE),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_USER_INFO_1, dwLMHashLen),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_1, dwNTHashLen),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_USER_INFO_1, pNTHash),
    LWMSG_UINT8(BYTE),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_USER_INFO_1, dwNTHashLen),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaUserInfo2Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_USER_INFO_2),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_2, uid),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_2, gid),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_2, pszName),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_2, pszPasswd),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_2, pszGecos),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_2, pszShell),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_2, pszHomedir),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_2, pszSid),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_2, pszDN),
    LWMSG_MEMBER_PSTR(LSA_USER_INFO_2, pszUPN),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_2, bIsGeneratedUPN),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_2, bIsLocalUser),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_2, dwLMHashLen),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_USER_INFO_2, pLMHash),
    LWMSG_UINT8(BYTE),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_USER_INFO_2, dwLMHashLen),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_2, dwNTHashLen),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_USER_INFO_2, pNTHash),
    LWMSG_UINT8(BYTE),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_USER_INFO_2, dwNTHashLen),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_2, dwDaysToPasswordExpiry),
    LWMSG_MEMBER_INT8(LSA_USER_INFO_2, bPasswordExpired),
    LWMSG_MEMBER_INT8(LSA_USER_INFO_2, bPasswordNeverExpires),
    LWMSG_MEMBER_INT8(LSA_USER_INFO_2, bPromptPasswordChange),
    LWMSG_MEMBER_INT8(LSA_USER_INFO_2, bUserCanChangePassword),
    LWMSG_MEMBER_INT8(LSA_USER_INFO_2, bAccountDisabled),
    LWMSG_MEMBER_INT8(LSA_USER_INFO_2, bAccountExpired),
    LWMSG_MEMBER_INT8(LSA_USER_INFO_2, bAccountLocked),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

#define USER_INFO_LEVEL_0 0
#define USER_INFO_LEVEL_1 1
#define USER_INFO_LEVEL_2 2

LWMsgTypeSpec gLsaUserInfoListSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_USER_INFO_LIST),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_LIST, dwUserInfoLevel),
    LWMSG_MEMBER_UINT32(LSA_USER_INFO_LIST, dwNumUsers),
    LWMSG_MEMBER_UNION_BEGIN(LSA_USER_INFO_LIST, ppUserInfoList),
    LWMSG_MEMBER_POINTER_BEGIN(union _USER_INFO_LIST, ppInfoList0),
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaUserInfo0Spec),
    LWMSG_POINTER_END,
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_USER_INFO_LIST, dwNumUsers),
    LWMSG_ATTR_TAG(USER_INFO_LEVEL_0),
    LWMSG_MEMBER_POINTER_BEGIN(union _USER_INFO_LIST, ppInfoList1),
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaUserInfo1Spec),
    LWMSG_POINTER_END,
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_USER_INFO_LIST, dwNumUsers),
    LWMSG_ATTR_TAG(GROUP_INFO_LEVEL_1),
    LWMSG_MEMBER_POINTER_BEGIN(union _USER_INFO_LIST, ppInfoList2),
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaUserInfo2Spec),
    LWMSG_POINTER_END,
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_USER_INFO_LIST, dwNumUsers),
    LWMSG_ATTR_TAG(USER_INFO_LEVEL_2),
    LWMSG_UNION_END,
    LWMSG_ATTR_DISCRIM(LSA_USER_INFO_LIST, dwUserInfoLevel),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

LWMsgTypeSpec gLsaGroupAddInfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_GROUP_ADD_INFO),
    LWMSG_MEMBER_PSTR(LSA_GROUP_ADD_INFO, pszName),
    LWMSG_MEMBER_UINT32(LSA_GROUP_ADD_INFO, gid),
    LWMSG_MEMBER_UINT32(LSA_GROUP_ADD_INFO, dwMemberCount),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_GROUP_ADD_INFO, ppszMemberSids),
    LWMSG_PSTR,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_GROUP_ADD_INFO, dwMemberCount),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaUserAddInfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_USER_ADD_INFO),
    LWMSG_MEMBER_PSTR(LSA_USER_ADD_INFO, pszName),
    LWMSG_MEMBER_UINT32(LSA_USER_ADD_INFO, uid),
    LWMSG_MEMBER_PSTR(LSA_USER_ADD_INFO, pszPrimaryGroupSid),
    LWMSG_MEMBER_PSTR(LSA_USER_ADD_INFO, pszPassword),
    LWMSG_MEMBER_PSTR(LSA_USER_ADD_INFO, pszGecos),
    LWMSG_MEMBER_PSTR(LSA_USER_ADD_INFO, pszShell),
    LWMSG_MEMBER_PSTR(LSA_USER_ADD_INFO, pszHomedir),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaNssArtefactInfo0Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_NSS_ARTEFACT_INFO_0),
    LWMSG_MEMBER_PSTR(LSA_NSS_ARTEFACT_INFO_0, pszName),
    LWMSG_MEMBER_PSTR(LSA_NSS_ARTEFACT_INFO_0, pszValue),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

#define NSS_ARTEFACT_INFO_LEVEL_0 0

static LWMsgTypeSpec gLsaNssArtefactInfoListSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_NSS_ARTEFACT_INFO_LIST),
    LWMSG_MEMBER_UINT32(LSA_NSS_ARTEFACT_INFO_LIST, dwNssArtefactInfoLevel),
    LWMSG_MEMBER_UINT32(LSA_NSS_ARTEFACT_INFO_LIST, dwNumNssArtefacts),
    LWMSG_MEMBER_UNION_BEGIN(LSA_NSS_ARTEFACT_INFO_LIST, ppNssArtefactInfoList),
    LWMSG_MEMBER_POINTER_BEGIN(union _NSS_ARTEFACT_INFO_LIST, ppInfoList0),
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaNssArtefactInfo0Spec),
    LWMSG_POINTER_END,
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_NSS_ARTEFACT_INFO_LIST, dwNumNssArtefacts),
    LWMSG_ATTR_TAG(NSS_ARTEFACT_INFO_LEVEL_0),
    LWMSG_UNION_END,
    LWMSG_ATTR_DISCRIM(LSA_NSS_ARTEFACT_INFO_LIST, dwNssArtefactInfoLevel),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCDataBlobSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_DATA_BLOB),
    LWMSG_MEMBER_UINT32(LSA_DATA_BLOB, dwLen),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_DATA_BLOB, pData),
    LWMSG_UINT8(BYTE),
    LWMSG_POINTER_END,
    LWMSG_ATTR_SENSITIVE,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_DATA_BLOB, dwLen),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCUserModInfo2Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_USER_MOD_INFO_2),
    LWMSG_MEMBER_PSTR(LSA_USER_MOD_INFO_2, pszSid),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_MEMBER_STRUCT_BEGIN(LSA_USER_MOD_INFO_2, actions),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bEnableUser),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bDisableUser),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bUnlockUser),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetChangePasswordOnNextLogon),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetPasswordNeverExpires),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetPasswordMustExpire),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bAddToGroups),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bRemoveFromGroups),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetAccountExpiryDate),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetHomedir),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetShell),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetGecos),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetPassword),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetPrimaryGroup),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetNtPasswordHash),
    LWMSG_MEMBER_INT8(struct _usermod_actions_2, bSetLmPasswordHash),
    LWMSG_STRUCT_END,
    LWMSG_MEMBER_PSTR(LSA_USER_MOD_INFO_2, pszPrimaryGroupSid),
    LWMSG_MEMBER_PSTR(LSA_USER_MOD_INFO_2, pszAddToGroups),
    LWMSG_MEMBER_PSTR(LSA_USER_MOD_INFO_2, pszRemoveFromGroups),
    LWMSG_MEMBER_PSTR(LSA_USER_MOD_INFO_2, pszExpiryDate),
    LWMSG_MEMBER_PSTR(LSA_USER_MOD_INFO_2, pszHomedir),
    LWMSG_MEMBER_PSTR(LSA_USER_MOD_INFO_2, pszShell),
    LWMSG_MEMBER_PSTR(LSA_USER_MOD_INFO_2, pszGecos),
    LWMSG_MEMBER_PSTR(LSA_USER_MOD_INFO_2, pszPassword),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_USER_MOD_INFO_2, pNtPasswordHash),
    LWMSG_TYPESPEC(gLsaIPCDataBlobSpec),
    LWMSG_POINTER_END,
    LWMSG_MEMBER_POINTER_BEGIN(LSA_USER_MOD_INFO_2, pLmPasswordHash),
    LWMSG_TYPESPEC(gLsaIPCDataBlobSpec),
    LWMSG_POINTER_END,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};


static LWMsgTypeSpec gLsaIPCGroupMemberInfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_GROUP_MEMBER_INFO),
    LWMSG_MEMBER_PSTR(LSA_GROUP_MEMBER_INFO, pszSid),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCGroupModInfo2Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_GROUP_MOD_INFO_2),
    LWMSG_MEMBER_PSTR(LSA_GROUP_MOD_INFO_2, pszSid),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_MEMBER_STRUCT_BEGIN(LSA_GROUP_MOD_INFO_2, actions),
    LWMSG_MEMBER_INT8(struct _groupmod_actions_2, bAddMembers),
    LWMSG_MEMBER_INT8(struct _groupmod_actions_2, bRemoveMembers),
    LWMSG_STRUCT_END,
    LWMSG_MEMBER_UINT32(LSA_GROUP_MOD_INFO_2, dwAddMembersNum),
    LWMSG_MEMBER_UINT32(LSA_GROUP_MOD_INFO_2, dwRemoveMembersNum),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_GROUP_MOD_INFO_2, ppszAddMembers),
    LWMSG_PSTR,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_GROUP_MOD_INFO_2, dwAddMembersNum),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_MEMBER_POINTER_BEGIN(LSA_GROUP_MOD_INFO_2, ppszRemoveMembers),
    LWMSG_PSTR,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_GROUP_MOD_INFO_2, dwRemoveMembersNum),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaMetricPack0Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_METRIC_PACK_0),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_0, failedAuthentications),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_0, failedUserLookupsByName),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_0, failedUserLookupsById),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_0, failedGroupLookupsByName),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_0, failedGroupLookupsById),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_0, failedOpenSession),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_0, failedCloseSession),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_0, failedChangePassword),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaMetricPack1Spec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_METRIC_PACK_1),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, successfulAuthentications),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, failedAuthentications),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, rootUserAuthentications),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, successfulUserLookupsByName),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, failedUserLookupsByName),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, successfulUserLookupsById),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, failedUserLookupsById),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, successfulGroupLookupsByName),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, failedGroupLookupsByName),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, successfulGroupLookupsById),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, failedGroupLookupsById),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, successfulOpenSession),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, failedOpenSession),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, successfulCloseSession),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, failedCloseSession),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, successfulChangePassword),
    LWMSG_MEMBER_UINT64(LSA_METRIC_PACK_1, failedChangePassword),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

#define METRIC_INFO_LEVEL_0 0
#define METRIC_INFO_LEVEL_1 1

static LWMsgTypeSpec gLsaMetricPackSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_METRIC_PACK),
    LWMSG_MEMBER_UINT32(LSA_METRIC_PACK, dwInfoLevel),
    LWMSG_MEMBER_UNION_BEGIN(LSA_METRIC_PACK, pMetricPack),
    LWMSG_MEMBER_POINTER_BEGIN(union _METRIC_PACK, pMetricPack0),
    LWMSG_TYPESPEC(gLsaMetricPack0Spec),
    LWMSG_POINTER_END,
    LWMSG_ATTR_TAG(METRIC_INFO_LEVEL_0),
    LWMSG_MEMBER_POINTER_BEGIN(union _METRIC_PACK, pMetricPack1),
    LWMSG_TYPESPEC(gLsaMetricPack1Spec),
    LWMSG_POINTER_END,
    LWMSG_ATTR_TAG(METRIC_INFO_LEVEL_1),
    LWMSG_UNION_END,
    LWMSG_ATTR_DISCRIM(LSA_METRIC_PACK, dwInfoLevel),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaDcInfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_DC_INFO),
    LWMSG_MEMBER_PSTR(LSA_DC_INFO, pszName),
    LWMSG_MEMBER_PSTR(LSA_DC_INFO, pszAddress),
    LWMSG_MEMBER_PSTR(LSA_DC_INFO, pszSiteName),
    LWMSG_MEMBER_UINT32(LSA_DC_INFO, dwFlags),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaTrustedDomainInfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_TRUSTED_DOMAIN_INFO),
    LWMSG_MEMBER_PSTR(LSA_TRUSTED_DOMAIN_INFO, pszDnsDomain),
    LWMSG_MEMBER_PSTR(LSA_TRUSTED_DOMAIN_INFO, pszNetbiosDomain),
    LWMSG_MEMBER_PSTR(LSA_TRUSTED_DOMAIN_INFO, pszTrusteeDnsDomain),
    LWMSG_MEMBER_PSTR(LSA_TRUSTED_DOMAIN_INFO, pszDomainSID),
    LWMSG_MEMBER_PSTR(LSA_TRUSTED_DOMAIN_INFO, pszDomainGUID),
    LWMSG_MEMBER_PSTR(LSA_TRUSTED_DOMAIN_INFO, pszForestName),
    LWMSG_MEMBER_PSTR(LSA_TRUSTED_DOMAIN_INFO, pszClientSiteName),
    LWMSG_MEMBER_UINT32(LSA_TRUSTED_DOMAIN_INFO, dwTrustFlags),
    LWMSG_MEMBER_UINT32(LSA_TRUSTED_DOMAIN_INFO, dwTrustType),
    LWMSG_MEMBER_UINT32(LSA_TRUSTED_DOMAIN_INFO, dwTrustAttributes),
    LWMSG_MEMBER_UINT32(LSA_TRUSTED_DOMAIN_INFO, dwTrustDirection),
    LWMSG_MEMBER_UINT32(LSA_TRUSTED_DOMAIN_INFO, dwTrustMode),
    LWMSG_MEMBER_UINT32(LSA_TRUSTED_DOMAIN_INFO, dwDomainFlags),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_TRUSTED_DOMAIN_INFO, pDCInfo),
    LWMSG_TYPESPEC(gLsaDcInfoSpec),
    LWMSG_POINTER_END,
    LWMSG_MEMBER_POINTER_BEGIN(LSA_TRUSTED_DOMAIN_INFO, pGCInfo),
    LWMSG_TYPESPEC(gLsaDcInfoSpec),
    LWMSG_POINTER_END,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaAuthProviderStatusSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_AUTH_PROVIDER_STATUS),
    LWMSG_MEMBER_PSTR(LSA_AUTH_PROVIDER_STATUS, pszId),
    LWMSG_MEMBER_UINT8(LSA_AUTH_PROVIDER_STATUS, mode),
    LWMSG_MEMBER_UINT8(LSA_AUTH_PROVIDER_STATUS, subMode),
    LWMSG_MEMBER_UINT8(LSA_AUTH_PROVIDER_STATUS, status),
    LWMSG_MEMBER_PSTR(LSA_AUTH_PROVIDER_STATUS, pszDomain),
    LWMSG_MEMBER_PSTR(LSA_AUTH_PROVIDER_STATUS, pszForest),
    LWMSG_MEMBER_PSTR(LSA_AUTH_PROVIDER_STATUS, pszSite),
    LWMSG_MEMBER_PSTR(LSA_AUTH_PROVIDER_STATUS, pszCell),
    LWMSG_MEMBER_UINT32(LSA_AUTH_PROVIDER_STATUS, dwNetworkCheckInterval),
    LWMSG_MEMBER_UINT32(LSA_AUTH_PROVIDER_STATUS, dwNumTrustedDomains),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_AUTH_PROVIDER_STATUS, pTrustedDomainInfoArray),
    LWMSG_TYPESPEC(gLsaTrustedDomainInfoSpec),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_AUTH_PROVIDER_STATUS, dwNumTrustedDomains),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaVersionSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSASTATUS),
    LWMSG_MEMBER_UINT32(LSA_VERSION, dwMajor),
    LWMSG_MEMBER_UINT32(LSA_VERSION, dwMinor),
    LWMSG_MEMBER_UINT32(LSA_VERSION, dwBuild),
    LWMSG_MEMBER_UINT32(LSA_VERSION, dwRevision),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaStatusSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSASTATUS),
    LWMSG_MEMBER_UINT32(LSASTATUS, dwUptime),
    LWMSG_MEMBER_TYPESPEC(LSASTATUS, lsassVersion, gLsaVersionSpec),
    LWMSG_MEMBER_TYPESPEC(LSASTATUS, productVersion, gLsaVersionSpec),
    LWMSG_MEMBER_UINT32(LSASTATUS, dwCount),
    LWMSG_MEMBER_POINTER_BEGIN(LSASTATUS, pAuthProviderStatusList),
    LWMSG_TYPESPEC(gLsaAuthProviderStatusSpec),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSASTATUS, dwCount),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaStatusPtrSpec[] =
{
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaStatusSpec),
    LWMSG_POINTER_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIpcEnumUsersHandleExistingSpec[] =
{
    /* Identify type name of handle */
    LWMSG_HANDLE(EnumUsers),
    /* Must be local to receiver (server) */
    LWMSG_ATTR_HANDLE_LOCAL_FOR_RECEIVER,
    /* Must be non-NULL */
    LWMSG_ATTR_NOT_NULL,
    /* End specification */
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIpcEnumGroupsHandleExistingSpec[] =
{
    /* Identify type name of handle */
    LWMSG_HANDLE(EnumGroups),
    /* Must be local to receiver (server) */
    LWMSG_ATTR_HANDLE_LOCAL_FOR_RECEIVER,
    /* Must be non-NULL */
    LWMSG_ATTR_NOT_NULL,
    /* End specification */
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIpcEnumArtefactsHandleExistingSpec[] =
{
    /* Identify type name of handle */
    LWMSG_HANDLE(EnumArtefacts),
    /* Must be local to receiver (server) */
    LWMSG_ATTR_HANDLE_LOCAL_FOR_RECEIVER,
    /* Must be non-NULL */
    LWMSG_ATTR_NOT_NULL,
    /* End specification */
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIpcEnumUsersHandleNewSpec[] =
{
    /* Identify type name of handle */
    LWMSG_HANDLE(EnumUsers),
    /* Must be local to sender (server) */
    LWMSG_ATTR_HANDLE_LOCAL_FOR_SENDER,
    /* Must be non-NULL */
    LWMSG_ATTR_NOT_NULL,
    /* End specification */
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIpcEnumGroupsHandleNewSpec[] =
{
    /* Identify type name of handle */
    LWMSG_HANDLE(EnumGroups),
    /* Must be local to sender (server) */
    LWMSG_ATTR_HANDLE_LOCAL_FOR_SENDER,
    /* Must be non-NULL */
    LWMSG_ATTR_NOT_NULL,
    /* End specification */
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIpcEnumArtefactsHandleNewSpec[] =
{
    /* Identify type name of handle */
    LWMSG_HANDLE(EnumArtefacts),
    /* Must be local to sender (server) */
    LWMSG_ATTR_HANDLE_LOCAL_FOR_SENDER,
    /* Must be non-NULL */
    LWMSG_ATTR_NOT_NULL,
    /* End specification */
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCFindNssArtefactByKeyReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_IPC_FIND_NSSARTEFACT_BY_KEY_REQ),
    LWMSG_MEMBER_UINT32(LSA_IPC_FIND_NSSARTEFACT_BY_KEY_REQ, dwFlags),
    LWMSG_MEMBER_UINT32(LSA_IPC_FIND_NSSARTEFACT_BY_KEY_REQ, dwInfoLevel),
    LWMSG_MEMBER_PSTR(LSA_IPC_FIND_NSSARTEFACT_BY_KEY_REQ, pszKeyName),
    LWMSG_MEMBER_PSTR(LSA_IPC_FIND_NSSARTEFACT_BY_KEY_REQ, pszMapName),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCBeginNssArtefactEnumReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_IPC_BEGIN_ENUM_NSSARTEFACT_REQ),
    LWMSG_MEMBER_UINT32(LSA_IPC_BEGIN_ENUM_NSSARTEFACT_REQ, dwInfoLevel),
    LWMSG_MEMBER_UINT32(LSA_IPC_BEGIN_ENUM_NSSARTEFACT_REQ, dwMaxNumNSSArtefacts),
    LWMSG_MEMBER_UINT32(LSA_IPC_BEGIN_ENUM_NSSARTEFACT_REQ, dwFlags),
    LWMSG_MEMBER_PSTR(LSA_IPC_BEGIN_ENUM_NSSARTEFACT_REQ, pszMapName),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCDelObjectInfoReqSpec[] =
{
    LWMSG_PSTR,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCAuthUserReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_IPC_AUTH_USER_REQ),
    LWMSG_MEMBER_PSTR(LSA_IPC_AUTH_USER_REQ, pszLoginName),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_MEMBER_PSTR(LSA_IPC_AUTH_USER_REQ, pszPassword),
    LWMSG_ATTR_SENSITIVE,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaAuthUserPamParamsSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_AUTH_USER_PAM_PARAMS),
    LWMSG_MEMBER_UINT32(LSA_AUTH_USER_PAM_PARAMS, dwFlags),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_PAM_PARAMS, pszLoginName),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_PAM_PARAMS, pszPassword),
    LWMSG_ATTR_SENSITIVE,
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_PAM_PARAMS, pszPamSource),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaAuthUserPamInfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_AUTH_USER_PAM_INFO),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_PAM_INFO, pszMessage),
    LWMSG_MEMBER_UINT8(LSA_AUTH_USER_PAM_INFO, bOnlineLogon),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCChangePasswordReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_IPC_CHANGE_PASSWORD_REQ),
    LWMSG_MEMBER_PSTR(LSA_IPC_CHANGE_PASSWORD_REQ, pszLoginName),
    LWMSG_MEMBER_PSTR(LSA_IPC_CHANGE_PASSWORD_REQ, pszNewPassword),
    LWMSG_ATTR_SENSITIVE,
    LWMSG_MEMBER_PSTR(LSA_IPC_CHANGE_PASSWORD_REQ, pszOldPassword),
    LWMSG_ATTR_SENSITIVE,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCSetPasswordReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_IPC_SET_PASSWORD_REQ),
    LWMSG_MEMBER_PSTR(LSA_IPC_SET_PASSWORD_REQ, pszLoginName),
    LWMSG_MEMBER_PSTR(LSA_IPC_SET_PASSWORD_REQ, pszNewPassword),
    LWMSG_ATTR_SENSITIVE,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCOpenOrCloseSessionReqSpec[] =
{
    LWMSG_PSTR,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCLoginfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_LOG_INFO),
    LWMSG_MEMBER_UINT8(LSA_LOG_INFO, maxAllowedLogLevel),
    LWMSG_MEMBER_UINT8(LSA_LOG_INFO, logTarget),
    LWMSG_MEMBER_PSTR(LSA_LOG_INFO, pszPath),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCSetLoginfoReqSpec[] =
{
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaIPCLoginfoSpec),
    LWMSG_POINTER_END,
    LWMSG_TYPE_END
};


static LWMsgTypeSpec gLsaIPCGetMetricsReqSpec[] =
{
    LWMSG_POINTER_BEGIN,
    LWMSG_UINT32(DWORD),
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCCheckUserInListReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_IPC_CHECK_USER_IN_LIST_REQ),
    LWMSG_MEMBER_PSTR(LSA_IPC_CHECK_USER_IN_LIST_REQ, pszLoginName),
    LWMSG_MEMBER_PSTR(LSA_IPC_CHECK_USER_IN_LIST_REQ, pszListName),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaTraceinfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_TRACE_INFO),
    LWMSG_MEMBER_UINT32(LSA_TRACE_INFO, dwTraceFlag),
    LWMSG_MEMBER_INT8(LSA_TRACE_INFO, bStatus),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaTraceinfoArraySpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_TRACE_INFO_LIST),
    LWMSG_MEMBER_UINT32(LSA_TRACE_INFO_LIST, dwNumFlags),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_TRACE_INFO_LIST, pTraceInfoArray),
    LWMSG_TYPESPEC(gLsaTraceinfoSpec),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_TRACE_INFO_LIST, dwNumFlags),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCSetTraceinfoReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_IPC_SET_TRACE_INFO_REQ),
    LWMSG_MEMBER_UINT32(LSA_IPC_SET_TRACE_INFO_REQ, dwNumFlags),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_IPC_SET_TRACE_INFO_REQ, pTraceFlagArray),
    LWMSG_TYPESPEC(gLsaTraceinfoSpec),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_IPC_SET_TRACE_INFO_REQ, dwNumFlags),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCAuthClearTextParamSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_AUTH_CLEARTEXT_PARAM),
    LWMSG_MEMBER_PSTR(LSA_AUTH_CLEARTEXT_PARAM, pszPassword),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCAuthChapParamSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_AUTH_CHAP_PARAM),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_AUTH_CHAP_PARAM, pChallenge),
    LWMSG_TYPESPEC(gLsaIPCDataBlobSpec),
    LWMSG_POINTER_END,
    LWMSG_MEMBER_POINTER_BEGIN(LSA_AUTH_CHAP_PARAM, pLM_resp),
    LWMSG_TYPESPEC(gLsaIPCDataBlobSpec),
    LWMSG_POINTER_END,
    LWMSG_MEMBER_POINTER_BEGIN(LSA_AUTH_CHAP_PARAM, pNT_resp),
    LWMSG_TYPESPEC(gLsaIPCDataBlobSpec),
    LWMSG_POINTER_END,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCAuthUserParamSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_AUTH_USER_PARAMS),
    LWMSG_MEMBER_UINT8(LSA_AUTH_USER_PARAMS, AuthType),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_PARAMS, pszAccountName),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_PARAMS, pszDomain),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_PARAMS, pszWorkstation),
    LWMSG_MEMBER_UNION_BEGIN(LSA_AUTH_USER_PARAMS, pass),
    LWMSG_MEMBER_TYPESPEC(union _PASS, clear, gLsaIPCAuthClearTextParamSpec),
    LWMSG_ATTR_TAG(LSA_AUTH_PLAINTEXT),
    LWMSG_MEMBER_TYPESPEC(union _PASS, chap, gLsaIPCAuthChapParamSpec),
    LWMSG_ATTR_TAG(LSA_AUTH_CHAP),
    LWMSG_UNION_END,
    LWMSG_ATTR_DISCRIM(LSA_AUTH_USER_PARAMS, AuthType),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCAuthUserExReqSpec[] =
{
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaIPCAuthUserParamSpec),
    LWMSG_POINTER_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCLsaRidAttribSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_RID_ATTRIB),
    LWMSG_MEMBER_UINT32(LSA_RID_ATTRIB, Rid),
    LWMSG_MEMBER_UINT32(LSA_RID_ATTRIB, dwAttrib),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCLsaRidAttribPtrSpec[] =
{
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaIPCLsaRidAttribSpec),
    LWMSG_POINTER_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCLsaSidAttribSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_SID_ATTRIB),
    LWMSG_MEMBER_PSTR(LSA_SID_ATTRIB, pszSid),
    LWMSG_MEMBER_UINT32(LSA_SID_ATTRIB, dwAttrib),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCLsaSidAttribPtrSpec[] =
{
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaIPCLsaSidAttribSpec),
    LWMSG_POINTER_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaAuthUserInfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_AUTH_USER_INFO),

    LWMSG_MEMBER_UINT32(LSA_AUTH_USER_INFO, dwUserFlags),

    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszAccount),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszUserPrincipalName),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszFullName),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszDomain),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszDnsDomain),

    LWMSG_MEMBER_UINT32(LSA_AUTH_USER_INFO, dwAcctFlags),

    LWMSG_MEMBER_POINTER_BEGIN(LSA_AUTH_USER_INFO, pSessionKey),
    LWMSG_TYPESPEC(gLsaIPCDataBlobSpec),
    LWMSG_POINTER_END,

    LWMSG_MEMBER_POINTER_BEGIN(LSA_AUTH_USER_INFO, pLmSessionKey),
    LWMSG_TYPESPEC(gLsaIPCDataBlobSpec),
    LWMSG_POINTER_END,

    LWMSG_MEMBER_UINT16(LSA_AUTH_USER_INFO, LogonCount),
    LWMSG_MEMBER_UINT16(LSA_AUTH_USER_INFO, BadPasswordCount),

    LWMSG_MEMBER_INT64(LSA_AUTH_USER_INFO, LogonTime),
    LWMSG_MEMBER_INT64(LSA_AUTH_USER_INFO, LogoffTime),
    LWMSG_MEMBER_INT64(LSA_AUTH_USER_INFO, KickoffTime),
    LWMSG_MEMBER_INT64(LSA_AUTH_USER_INFO, LastPasswordChange),
    LWMSG_MEMBER_INT64(LSA_AUTH_USER_INFO, CanChangePassword),
    LWMSG_MEMBER_INT64(LSA_AUTH_USER_INFO, MustChangePassword),

    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszLogonServer),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszLogonScript),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszProfilePath),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszHomeDirectory),
    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszHomeDrive),

    LWMSG_MEMBER_PSTR(LSA_AUTH_USER_INFO, pszDomainSid),
    LWMSG_MEMBER_UINT32(LSA_AUTH_USER_INFO, dwUserRid),
    LWMSG_MEMBER_UINT32(LSA_AUTH_USER_INFO, dwPrimaryGroupRid),

    LWMSG_MEMBER_UINT32(LSA_AUTH_USER_INFO, dwNumRids),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_AUTH_USER_INFO, pRidAttribList),
    LWMSG_TYPESPEC(gLsaIPCLsaRidAttribSpec),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_AUTH_USER_INFO, dwNumRids),

    LWMSG_MEMBER_UINT32(LSA_AUTH_USER_INFO, dwNumSids),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_AUTH_USER_INFO, pSidAttribList),
    LWMSG_TYPESPEC(gLsaIPCLsaSidAttribSpec),
    LWMSG_POINTER_END,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_AUTH_USER_INFO, dwNumSids),

    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaAuthUserInfoPtrSpec[] =
{
    LWMSG_POINTER_BEGIN,
    LWMSG_TYPESPEC(gLsaAuthUserInfoSpec),
    LWMSG_POINTER_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCGetTraceinfoReqSpec[] =
{
    LWMSG_POINTER_BEGIN,
    LWMSG_UINT32(DWORD),
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCProviderIoControlReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_IPC_PROVIDER_IO_CONTROL_REQ),
    LWMSG_MEMBER_PSTR(LSA_IPC_PROVIDER_IO_CONTROL_REQ, pszProvider),
    LWMSG_MEMBER_UINT32(LSA_IPC_PROVIDER_IO_CONTROL_REQ, dwIoControlCode),
    LWMSG_MEMBER_UINT32(LSA_IPC_PROVIDER_IO_CONTROL_REQ, dwDataLen),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_IPC_PROVIDER_IO_CONTROL_REQ, pData),
    LWMSG_UINT8(BYTE),
    LWMSG_POINTER_END,
    LWMSG_ATTR_SENSITIVE,
    LWMSG_ATTR_LENGTH_MEMBER(LSA_IPC_PROVIDER_IO_CONTROL_REQ, dwDataLen),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaIPCGetPamConfigSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_PAM_CONFIG),
    LWMSG_MEMBER_UINT32(LSA_PAM_CONFIG, dwLogLevel),
    LWMSG_MEMBER_UINT32(LSA_PAM_CONFIG, bLsaPamDisplayMOTD),
    LWMSG_MEMBER_PSTR(LSA_PAM_CONFIG, pszAccessDeniedMessage),
    LWMSG_MEMBER_UINT32(LSA_PAM_CONFIG, dwNumSmartCardServices),
    LWMSG_MEMBER_POINTER(LSA_PAM_CONFIG, ppszSmartCardServices, LWMSG_PSTR),
    LWMSG_ATTR_LENGTH_MEMBER(LSA_PAM_CONFIG, dwNumSmartCardServices),
    LWMSG_MEMBER_UINT32(LSA_PAM_CONFIG, dwNumSmartCardPromptGecos),
    LWMSG_MEMBER_POINTER(LSA_PAM_CONFIG, ppszSmartCardPromptGecos, LWMSG_PSTR),
    LWMSG_ATTR_LENGTH_MEMBER(LSA_PAM_CONFIG, dwNumSmartCardPromptGecos),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaSecurityObjectUserInfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_SECURITY_OBJECT_USER_INFO),
    LWMSG_MEMBER_UINT32(LSA_SECURITY_OBJECT_USER_INFO, uid),
    LWMSG_MEMBER_UINT32(LSA_SECURITY_OBJECT_USER_INFO, gid),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_USER_INFO, pszPrimaryGroupSid),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_USER_INFO, pszUPN),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_USER_INFO, pszAliasName),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_USER_INFO, pszUnixName),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_USER_INFO, pszPasswd),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_USER_INFO, pszGecos),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_USER_INFO, pszShell),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_USER_INFO, pszHomedir),
    LWMSG_MEMBER_UINT64(LSA_SECURITY_OBJECT_USER_INFO, qwPwdLastSet),
    LWMSG_MEMBER_UINT64(LSA_SECURITY_OBJECT_USER_INFO, qwMaxPwdAge),
    LWMSG_MEMBER_UINT64(LSA_SECURITY_OBJECT_USER_INFO, qwPwdExpires),
    LWMSG_MEMBER_UINT64(LSA_SECURITY_OBJECT_USER_INFO, qwAccountExpires),

    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT_USER_INFO, bIsGeneratedUPN),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT_USER_INFO, bIsAccountInfoKnown),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT_USER_INFO, bPasswordExpired),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT_USER_INFO, bPasswordNeverExpires),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT_USER_INFO, bPromptPasswordChange),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT_USER_INFO, bUserCanChangePassword),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT_USER_INFO, bAccountDisabled),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT_USER_INFO, bAccountExpired),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT_USER_INFO, bAccountLocked),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsaSecurityObjectGroupInfoSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_SECURITY_OBJECT_GROUP_INFO),
    LWMSG_MEMBER_UINT32(LSA_SECURITY_OBJECT_GROUP_INFO, gid),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_GROUP_INFO, pszAliasName),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_GROUP_INFO, pszUnixName),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT_GROUP_INFO, pszPasswd),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

LWMsgTypeSpec gLsaSecurityObjectSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA_SECURITY_OBJECT),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT, pszDN),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT, pszObjectSid),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT, enabled),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT, bIsLocal),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT, pszNetbiosDomainName),
    LWMSG_MEMBER_PSTR(LSA_SECURITY_OBJECT, pszSamAccountName),
    LWMSG_MEMBER_UINT8(LSA_SECURITY_OBJECT, type),
    LWMSG_ATTR_RANGE(LSA_OBJECT_TYPE_UNDEFINED, LSA_OBJECT_TYPE_COMPUTER),
    LWMSG_MEMBER_UNION_BEGIN(LSA_SECURITY_OBJECT, typeInfo),
    LWMSG_MEMBER_TYPESPEC(LSA_SECURITY_OBJECT, userInfo, gLsaSecurityObjectUserInfoSpec),
    LWMSG_ATTR_TAG(LSA_OBJECT_TYPE_USER),
    LWMSG_MEMBER_TYPESPEC(LSA_SECURITY_OBJECT, groupInfo, gLsaSecurityObjectGroupInfoSpec),
    LWMSG_ATTR_TAG(LSA_OBJECT_TYPE_GROUP),
    LWMSG_UNION_END,
    LWMSG_ATTR_DISCRIM(LSA_SECURITY_OBJECT, type),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcFindObjectsReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_FIND_OBJECTS_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_FIND_OBJECTS_REQ, pszTargetProvider),
    LWMSG_MEMBER_UINT32(LSA2_IPC_FIND_OBJECTS_REQ, FindFlags),
    LWMSG_MEMBER_UINT8(LSA2_IPC_FIND_OBJECTS_REQ, ObjectType),
    LWMSG_MEMBER_UINT8(LSA2_IPC_FIND_OBJECTS_REQ, QueryType),
    LWMSG_MEMBER_UINT8(LSA2_IPC_FIND_OBJECTS_REQ, IpcQueryType),
    LWMSG_MEMBER_UINT32(LSA2_IPC_FIND_OBJECTS_REQ, dwCount),
    LWMSG_MEMBER_UNION_BEGIN(LSA2_IPC_FIND_OBJECTS_REQ, QueryList),
    LWMSG_MEMBER_POINTER_BEGIN(LSA_QUERY_LIST, ppszStrings),
    LWMSG_PSTR,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_POINTER_END,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_ATTR_LENGTH_MEMBER(LSA2_IPC_FIND_OBJECTS_REQ, dwCount),
    LWMSG_ATTR_TAG(LSA2_IPC_QUERY_STRINGS),
    LWMSG_MEMBER_POINTER(LSA_QUERY_LIST, pdwIds, LWMSG_UINT32(DWORD)),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_ATTR_LENGTH_MEMBER(LSA2_IPC_FIND_OBJECTS_REQ, dwCount),
    LWMSG_ATTR_TAG(LSA2_IPC_QUERY_DWORDS),
    LWMSG_UNION_END,
    LWMSG_ATTR_DISCRIM(LSA2_IPC_FIND_OBJECTS_REQ, IpcQueryType),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcFindObjectsResSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_FIND_OBJECTS_RES),
    LWMSG_MEMBER_UINT32(LSA2_IPC_FIND_OBJECTS_RES, dwCount),
    LWMSG_MEMBER_POINTER_BEGIN(LSA2_IPC_FIND_OBJECTS_RES, ppObjects),
    LWMSG_POINTER(LWMSG_TYPESPEC(gLsaSecurityObjectSpec)),
    LWMSG_POINTER_END,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_ATTR_LENGTH_MEMBER(LSA2_IPC_FIND_OBJECTS_RES, dwCount),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcOpenEnumObjectsReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_OPEN_ENUM_OBJECTS_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_OPEN_ENUM_OBJECTS_REQ, pszTargetProvider),
    LWMSG_MEMBER_UINT32(LSA2_IPC_OPEN_ENUM_OBJECTS_REQ, FindFlags),
    LWMSG_MEMBER_UINT8(LSA2_IPC_OPEN_ENUM_OBJECTS_REQ, ObjectType),
    LWMSG_MEMBER_PSTR(LSA2_IPC_OPEN_ENUM_OBJECTS_REQ, pszDomainName),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcOpenEnumObjectsResSpec[] =
{
    LWMSG_HANDLE(LSA2_IPC_ENUM_HANDLE),
    LWMSG_ATTR_HANDLE_LOCAL_FOR_SENDER,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcEnumObjectsReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_ENUM_OBJECTS_REQ),
    LWMSG_MEMBER_HANDLE(LSA2_IPC_ENUM_OBJECTS_REQ, hEnum, LSA2_IPC_ENUM_HANDLE),
    LWMSG_ATTR_HANDLE_LOCAL_FOR_RECEIVER,
    LWMSG_MEMBER_UINT32(LSA2_IPC_ENUM_OBJECTS_REQ, dwMaxObjectsCount),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcEnumObjectsResSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_ENUM_OBJECTS_RES),
    LWMSG_MEMBER_UINT32(LSA2_IPC_ENUM_OBJECTS_RES, dwObjectsCount),
    LWMSG_MEMBER_POINTER_BEGIN(LSA2_IPC_ENUM_OBJECTS_RES, ppObjects),
    LWMSG_POINTER(LWMSG_TYPESPEC(gLsaSecurityObjectSpec)),
    LWMSG_POINTER_END,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_ATTR_LENGTH_MEMBER(LSA2_IPC_ENUM_OBJECTS_RES, dwObjectsCount),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcOpenEnumMembersReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_OPEN_ENUM_MEMBERS_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_OPEN_ENUM_MEMBERS_REQ, pszTargetProvider),
    LWMSG_MEMBER_UINT32(LSA2_IPC_OPEN_ENUM_MEMBERS_REQ, FindFlags),
    LWMSG_MEMBER_PSTR(LSA2_IPC_OPEN_ENUM_MEMBERS_REQ, pszSid),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcOpenEnumMembersResSpec[] =
{
    LWMSG_HANDLE(LSA2_IPC_ENUM_HANDLE),
    LWMSG_ATTR_HANDLE_LOCAL_FOR_SENDER,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcEnumMembersReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_ENUM_MEMBERS_REQ),
    LWMSG_MEMBER_HANDLE(LSA2_IPC_ENUM_MEMBERS_REQ, hEnum, LSA2_IPC_ENUM_HANDLE),
    LWMSG_ATTR_HANDLE_LOCAL_FOR_RECEIVER,
    LWMSG_MEMBER_UINT32(LSA2_IPC_ENUM_MEMBERS_REQ, dwMaxSidCount),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcEnumMembersResSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_ENUM_MEMBERS_RES),
    LWMSG_MEMBER_UINT32(LSA2_IPC_ENUM_MEMBERS_RES, dwSidCount),
    LWMSG_MEMBER_POINTER_BEGIN(LSA2_IPC_ENUM_MEMBERS_RES, ppszMemberSids),
    LWMSG_PSTR,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_POINTER_END,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_ATTR_LENGTH_MEMBER(LSA2_IPC_ENUM_MEMBERS_RES, dwSidCount),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcQueryMemberOfReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_QUERY_MEMBER_OF_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_QUERY_MEMBER_OF_REQ, pszTargetProvider),
    LWMSG_MEMBER_UINT32(LSA2_IPC_QUERY_MEMBER_OF_REQ, FindFlags),
    LWMSG_MEMBER_UINT32(LSA2_IPC_QUERY_MEMBER_OF_REQ, dwSidCount),
    LWMSG_MEMBER_POINTER_BEGIN(LSA2_IPC_QUERY_MEMBER_OF_REQ, ppszSids),
    LWMSG_PSTR,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_POINTER_END,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_ATTR_LENGTH_MEMBER(LSA2_IPC_QUERY_MEMBER_OF_REQ, dwSidCount),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcQueryMemberOfResSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_QUERY_MEMBER_OF_RES),
    LWMSG_MEMBER_UINT32(LSA2_IPC_QUERY_MEMBER_OF_RES, dwGroupSidCount),
    LWMSG_MEMBER_POINTER_BEGIN(LSA2_IPC_QUERY_MEMBER_OF_RES, ppszGroupSids),
    LWMSG_PSTR,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_POINTER_END,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_ATTR_LENGTH_MEMBER(LSA2_IPC_QUERY_MEMBER_OF_RES, dwGroupSidCount),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcFindGroupAndExpandedGroupMembersReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_REQ, pszTargetProvider),
    LWMSG_MEMBER_UINT32(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_REQ, FindFlags),
    LWMSG_MEMBER_UINT8(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_REQ, QueryType),
    LWMSG_MEMBER_UINT8(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_REQ, IpcQueryType),
    LWMSG_MEMBER_UNION_BEGIN(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_REQ, QueryItem),
    LWMSG_MEMBER_PSTR(LSA_QUERY_ITEM, pszString),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_ATTR_TAG(LSA2_IPC_QUERY_STRINGS),
    LWMSG_MEMBER_UINT32(LSA_QUERY_ITEM, dwId),
    LWMSG_ATTR_TAG(LSA2_IPC_QUERY_DWORDS),
    LWMSG_UNION_END,
    LWMSG_ATTR_DISCRIM(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_REQ, IpcQueryType),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcFindGroupAndExpandedGroupMembersResSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_RES),
    LWMSG_MEMBER_POINTER(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_RES, pGroup, LWMSG_TYPESPEC(gLsaSecurityObjectSpec)),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_MEMBER_UINT32(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_RES, dwMemberObjectCount),
    LWMSG_MEMBER_POINTER_BEGIN(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_RES, ppMemberObjects),
    LWMSG_POINTER(LWMSG_TYPESPEC(gLsaSecurityObjectSpec)),
    LWMSG_POINTER_END,
    LWMSG_ATTR_NOT_NULL,
    LWMSG_ATTR_LENGTH_MEMBER(LSA2_IPC_FIND_GROUP_AND_EXPANDED_MEMBERS_RES, dwMemberObjectCount),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcCloseEnumReqSpec[] =
{
    LWMSG_HANDLE(LSA2_IPC_ENUM_HANDLE),
    LWMSG_ATTR_HANDLE_LOCAL_FOR_RECEIVER
};

static LWMsgTypeSpec gLsa2IpcModifyUserReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_MODIFY_USER_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_MODIFY_USER_REQ, pszTargetProvider),
    LWMSG_MEMBER_POINTER(LSA2_IPC_MODIFY_USER_REQ, pUserModInfo, LWMSG_TYPESPEC(gLsaIPCUserModInfo2Spec)),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcModifyGroupReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_MODIFY_GROUP_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_MODIFY_GROUP_REQ, pszTargetProvider),
    LWMSG_MEMBER_POINTER(LSA2_IPC_MODIFY_GROUP_REQ, pGroupModInfo, LWMSG_TYPESPEC(gLsaIPCGroupModInfo2Spec)),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcAddUserReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_ADD_USER_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_ADD_USER_REQ, pszTargetProvider),
    LWMSG_MEMBER_POINTER(LSA2_IPC_ADD_USER_REQ, pUserAddInfo, LWMSG_TYPESPEC(gLsaUserAddInfoSpec)),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcAddGroupReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_ADD_GROUP_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_ADD_GROUP_REQ, pszTargetProvider),
    LWMSG_MEMBER_POINTER(LSA2_IPC_ADD_GROUP_REQ, pGroupAddInfo, LWMSG_TYPESPEC(gLsaGroupAddInfoSpec)),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcDeleteObjectReqSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_DELETE_OBJECT_REQ),
    LWMSG_MEMBER_PSTR(LSA2_IPC_DELETE_OBJECT_REQ, pszTargetProvider),
    LWMSG_MEMBER_PSTR(LSA2_IPC_DELETE_OBJECT_REQ, pszSid),
    LWMSG_ATTR_NOT_NULL,
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgTypeSpec gLsa2IpcGetSmartCardUserObjectResSpec[] =
{
    LWMSG_STRUCT_BEGIN(LSA2_IPC_GET_SMART_CARD_USER_RES),
    LWMSG_MEMBER_POINTER(LSA2_IPC_GET_SMART_CARD_USER_RES, pObject,
            LWMSG_TYPESPEC(gLsaSecurityObjectSpec)),
    LWMSG_MEMBER_PSTR(LSA2_IPC_GET_SMART_CARD_USER_RES, pszSmartCardReader),
    LWMSG_STRUCT_END,
    LWMSG_TYPE_END
};

static LWMsgProtocolSpec gLsaIPCSpec[] =
{
    LWMSG_MESSAGE(LSA_Q_AUTH_USER_PAM, gLsaAuthUserPamParamsSpec),
    LWMSG_MESSAGE(LSA_R_AUTH_USER_PAM_SUCCESS, gLsaAuthUserPamInfoSpec),
    LWMSG_MESSAGE(LSA_R_AUTH_USER_PAM_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_AUTH_USER_EX, gLsaIPCAuthUserExReqSpec),
    LWMSG_MESSAGE(LSA_R_AUTH_USER_EX_SUCCESS, gLsaAuthUserInfoPtrSpec),
    LWMSG_MESSAGE(LSA_R_AUTH_USER_EX_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_VALIDATE_USER, gLsaIPCAuthUserReqSpec),
    LWMSG_MESSAGE(LSA_R_VALIDATE_USER_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_VALIDATE_USER_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_CHANGE_PASSWORD, gLsaIPCChangePasswordReqSpec),
    LWMSG_MESSAGE(LSA_R_CHANGE_PASSWORD_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_CHANGE_PASSWORD_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_SET_PASSWORD, gLsaIPCSetPasswordReqSpec),
    LWMSG_MESSAGE(LSA_R_SET_PASSWORD_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_SET_PASSWORD_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_OPEN_SESSION, gLsaIPCOpenOrCloseSessionReqSpec),
    LWMSG_MESSAGE(LSA_R_OPEN_SESSION_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_OPEN_SESSION_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_CLOSE_SESSION, gLsaIPCOpenOrCloseSessionReqSpec),
    LWMSG_MESSAGE(LSA_R_CLOSE_SESSION_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_CLOSE_SESSION_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_CHECK_USER_IN_LIST, gLsaIPCCheckUserInListReqSpec),
    LWMSG_MESSAGE(LSA_R_CHECK_USER_IN_LIST_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_CHECK_USER_IN_LIST_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_SET_LOGINFO, gLsaIPCSetLoginfoReqSpec),
    LWMSG_MESSAGE(LSA_R_SET_LOGINFO_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_SET_LOGINFO_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_GET_LOGINFO, NULL),
    LWMSG_MESSAGE(LSA_R_GET_LOGINFO_SUCCESS, gLsaIPCLoginfoSpec),
    LWMSG_MESSAGE(LSA_R_GET_LOGINFO_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_GET_METRICS, gLsaIPCGetMetricsReqSpec),
    LWMSG_MESSAGE(LSA_R_GET_METRICS_SUCCESS, gLsaMetricPackSpec),
    LWMSG_MESSAGE(LSA_R_GET_METRICS_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_GET_STATUS, NULL),
    LWMSG_MESSAGE(LSA_R_GET_STATUS_SUCCESS, gLsaStatusPtrSpec),
    LWMSG_MESSAGE(LSA_R_GET_STATUS_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_REFRESH_CONFIGURATION, NULL),
    LWMSG_MESSAGE(LSA_R_REFRESH_CONFIGURATION_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_REFRESH_CONFIGURATION_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_BEGIN_ENUM_NSS_ARTEFACTS, gLsaIPCBeginNssArtefactEnumReqSpec),
    LWMSG_MESSAGE(LSA_R_BEGIN_ENUM_NSS_ARTEFACTS_SUCCESS, gLsaIpcEnumArtefactsHandleNewSpec),
    LWMSG_MESSAGE(LSA_R_BEGIN_ENUM_NSS_ARTEFACTS_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_ENUM_NSS_ARTEFACTS, gLsaIpcEnumArtefactsHandleExistingSpec),
    LWMSG_MESSAGE(LSA_R_ENUM_NSS_ARTEFACTS_SUCCESS, gLsaNssArtefactInfoListSpec),
    LWMSG_MESSAGE(LSA_R_ENUM_NSS_ARTEFACTS_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_END_ENUM_NSS_ARTEFACTS, gLsaIpcEnumArtefactsHandleExistingSpec),
    LWMSG_MESSAGE(LSA_R_END_ENUM_NSS_ARTEFACTS_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_END_ENUM_NSS_ARTEFACTS_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_FIND_NSS_ARTEFACT_BY_KEY, gLsaIPCFindNssArtefactByKeyReqSpec),
    LWMSG_MESSAGE(LSA_R_FIND_NSS_ARTEFACT_BY_KEY_SUCCESS, gLsaNssArtefactInfoListSpec),
    LWMSG_MESSAGE(LSA_R_FIND_NSS_ARTEFACT_BY_KEY_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_SET_TRACE_INFO, gLsaIPCSetTraceinfoReqSpec),
    LWMSG_MESSAGE(LSA_R_SET_TRACE_INFO_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_SET_TRACE_INFO_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_GET_TRACE_INFO, gLsaIPCGetTraceinfoReqSpec),
    LWMSG_MESSAGE(LSA_R_GET_TRACE_INFO_SUCCESS, gLsaTraceinfoArraySpec),
    LWMSG_MESSAGE(LSA_R_GET_TRACE_INFO_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_ENUM_TRACE_INFO, NULL),
    LWMSG_MESSAGE(LSA_R_ENUM_TRACE_INFO_SUCCESS, gLsaTraceinfoArraySpec),
    LWMSG_MESSAGE(LSA_R_ENUM_TRACE_INFO_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_PROVIDER_IO_CONTROL, gLsaIPCProviderIoControlReqSpec),
    LWMSG_MESSAGE(LSA_R_PROVIDER_IO_CONTROL_SUCCESS, NULL),
    LWMSG_MESSAGE(LSA_R_PROVIDER_IO_CONTROL_SUCCESS_DATA, gLsaIPCDataBlobSpec),
    LWMSG_MESSAGE(LSA_R_PROVIDER_IO_CONTROL_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA_Q_GET_PAM_CONFIG, NULL),
    LWMSG_MESSAGE(LSA_R_GET_PAM_CONFIG_SUCCESS, gLsaIPCGetPamConfigSpec),
    LWMSG_MESSAGE(LSA_R_GET_PAM_CONFIG_FAILURE, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA2_R_ERROR, gLsaIPCErrorSpec),
    LWMSG_MESSAGE(LSA2_Q_FIND_OBJECTS, gLsa2IpcFindObjectsReqSpec),
    LWMSG_MESSAGE(LSA2_R_FIND_OBJECTS, gLsa2IpcFindObjectsResSpec),
    LWMSG_MESSAGE(LSA2_Q_OPEN_ENUM_OBJECTS, gLsa2IpcOpenEnumObjectsReqSpec),
    LWMSG_MESSAGE(LSA2_R_OPEN_ENUM_OBJECTS, gLsa2IpcOpenEnumObjectsResSpec),
    LWMSG_MESSAGE(LSA2_Q_ENUM_OBJECTS, gLsa2IpcEnumObjectsReqSpec),
    LWMSG_MESSAGE(LSA2_R_ENUM_OBJECTS, gLsa2IpcEnumObjectsResSpec),
    LWMSG_MESSAGE(LSA2_Q_OPEN_ENUM_MEMBERS, gLsa2IpcOpenEnumMembersReqSpec),
    LWMSG_MESSAGE(LSA2_R_OPEN_ENUM_MEMBERS, gLsa2IpcOpenEnumMembersResSpec),
    LWMSG_MESSAGE(LSA2_Q_ENUM_MEMBERS, gLsa2IpcEnumMembersReqSpec),
    LWMSG_MESSAGE(LSA2_R_ENUM_MEMBERS, gLsa2IpcEnumMembersResSpec),
    LWMSG_MESSAGE(LSA2_Q_CLOSE_ENUM, gLsa2IpcCloseEnumReqSpec),
    LWMSG_MESSAGE(LSA2_R_CLOSE_ENUM, NULL),
    LWMSG_MESSAGE(LSA2_Q_QUERY_MEMBER_OF, gLsa2IpcQueryMemberOfReqSpec),
    LWMSG_MESSAGE(LSA2_R_QUERY_MEMBER_OF, gLsa2IpcQueryMemberOfResSpec),
    LWMSG_MESSAGE(LSA2_Q_FIND_GROUP_AND_EXPANDED_MEMBERS, gLsa2IpcFindGroupAndExpandedGroupMembersReqSpec),
    LWMSG_MESSAGE(LSA2_R_FIND_GROUP_AND_EXPANDED_MEMBERS, gLsa2IpcFindGroupAndExpandedGroupMembersResSpec),
    LWMSG_MESSAGE(LSA2_R_QUERY_MEMBER_OF, gLsa2IpcQueryMemberOfResSpec),
    LWMSG_MESSAGE(LSA2_Q_ADD_GROUP, gLsa2IpcAddGroupReqSpec),
    LWMSG_MESSAGE(LSA2_R_ADD_GROUP, NULL),
    LWMSG_MESSAGE(LSA2_Q_MODIFY_GROUP, gLsa2IpcModifyGroupReqSpec),
    LWMSG_MESSAGE(LSA2_R_MODIFY_GROUP, NULL),
    LWMSG_MESSAGE(LSA2_Q_DELETE_OBJECT, gLsa2IpcDeleteObjectReqSpec),
    LWMSG_MESSAGE(LSA2_R_DELETE_OBJECT, NULL),
    LWMSG_MESSAGE(LSA2_Q_ADD_USER, gLsa2IpcAddUserReqSpec),
    LWMSG_MESSAGE(LSA2_R_ADD_USER, NULL),
    LWMSG_MESSAGE(LSA2_Q_MODIFY_USER, gLsa2IpcModifyUserReqSpec),
    LWMSG_MESSAGE(LSA2_R_MODIFY_USER, NULL),
    LWMSG_MESSAGE(LSA2_Q_GET_SMARTCARD_USER_OBJECT, NULL),
    LWMSG_MESSAGE(LSA2_R_GET_SMARTCARD_USER_OBJECT, gLsa2IpcGetSmartCardUserObjectResSpec),
    LWMSG_PROTOCOL_END
};

LWMsgProtocolSpec*
LsaIPCGetProtocolSpec(
    void
    )
{
    return gLsaIPCSpec;
}

/*
local variables:
mode: c
c-basic-offset: 4
indent-tabs-mode: nil
tab-width: 4
end:
*/
