dnl -*- shell-script -*-
dnl
dnl Copyright (c) 2001-2004 The Trustees of Indiana University.  
dnl                         All rights reserved.
dnl Copyright (c) 1998-2001 University of Notre Dame. 
dnl                         All rights reserved.
dnl Copyright (c) 1994-1998 The Ohio State University.  
dnl                         All rights reserved.
dnl 
dnl This file is part of the LAM/MPI software package.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl LAM/MPI source distribution.
dnl
dnl $Id: lam_rpi_gm_setup.m4,v 1.7.2.4 2004/03/12 01:19:07 vsahay Exp $
dnl

AC_DEFUN([LAM_RPI_GM_SETUP],[
#
# Arguments: none
#
# Dependencies: None
#
# Setup the gm RPI
#
# Sets:
#
# GMSHORT: subst
# GMTINY: subst
# GMMAXPORT: subst
# GMPORT: subst
#

#
# Where is libgm/gm.h located?
#

GMDIR=
AC_ARG_WITH(gm, 
	    AC_HELP_STRING([--with-gm],
			   [directory where the gm software was installed]),
            [GMDIR=$withval])
GMLIBDIR=
AC_ARG_WITH(rpi-gm-lib, 
	    AC_HELP_STRING([--with-rpi-gm-lib],
			   [directory where the gm library can be found, if it is not in $GMDIR/lib or $GMDIR/binary/lib]),
            [GMLIBDIR=$withval])

#
# Check that we have all the right flags to compile with gm
#

WRAPPER_EXTRA_LDFLAGS=
WRAPPER_EXTRA_LIBS="-lgm"

if test -n "$GMDIR" -o -n "$GMLIBDIR"; then
    CPPFLAGS="$CPPFLAGS -I$GMDIR/include"
    AC_CHECK_HEADERS(gm.h,,
	AC_MSG_ERROR([*** Cannot find working gm.h.]))

    # Note that it is possible to find the library even if -L is not
    # specified, if the LD_LIBRARY_PATH includes the directory where
    # the shared gm library is kept.  Hence, we unset LD_LIBRARY_PATH
    # before running this test.

    LD_LIBRARY_PATH_save="$LD_LIBRARY_PATH"
    unset LD_LIBRARY_PATH

    LIBS_save="$LIBS"
    LDFLAGS_save="$LDFLAGS"

    if test -n "$GMLIBDIR" -a -d "$GMLIBDIR"; then
	WRAPPER_EXTRA_LDFLAGS="-L$GMLIBDIR"
    elif test -d "$GMDIR/lib"; then
	WRAPPER_EXTRA_LDFLAGS="-L$GMDIR/lib"
    elif test -d "$GMDIR/binary/lib"; then
	WRAPPER_EXTRA_LDFLAGS="-L$GMDIR/binary/lib"
    else
	AC_MSG_WARN([*** No directory $GMDIR/lib or $GMDIR/binary/lib])
	AC_MSG_ERROR([*** Cannot continue])
    fi

    LDFLAGS="$LDFLAGS $WRAPPER_EXTRA_LDFLAGS"
    AC_CHECK_LIB(gm, gm_init)
    if test "$LIBS" = "$LIBS_save"; then
	WRAPPER_EXTRA_LDFLAGS="-L$GMDIR/binary/lib"
	LDFLAGS="$LDFLAGS_save $WRAPPER_EXTRA_LDFLAGS"
	AC_CHECK_LIB(gm, gm_exit,[],
	    AC_MSG_ERROR([*** Cannot find working libgm.]) )
    fi

    LD_LIBRARY_PATH="$LD_LIBRARY_PATH_save"
else
    AC_CHECK_LIB(gm, main,[], 
	AC_MSG_ERROR([*** Cannot find working libgm.]))
    AC_CHECK_HEADERS(gm.h,, 
	AC_MSG_ERROR([*** Cannot find working gm.h]))
fi

#
# If we're on Solaris up through 2.8, make the default not to try to
# pin memory -- it's broken in the OS.  :-(
#

AC_MSG_CHECKING([if can register arbitrary memory])
CAN_REGISTER_MEM=1
MSG=yes
case "$host" in
*solaris*)
    CAN_REGISTER_MEM=0
    MSG=no
    ;;
esac
AC_MSG_RESULT([$MSG])
unset MSG

# Now that we know if we can register memory, check the command line
# options that were specified.  If nothing was specified about
# ptmalloc, follow the default that was found regarding whether we can
# pin arbitrary memory or not.

if test "$enable_rpi_gm_ptmalloc" = ""; then
    if test "$CAN_REGISTER_MEM" = "1"; then
	enable_rpi_gm_ptmalloc=yes
    else
	enable_rpi_gm_ptmalloc=no
    fi
fi

#
# See if we have GM_API_VERSION.  If we do, use it.  If not, find the
# highest one available.  It seems that GM_API_VERSION was introduced
# somewhere after 1.3 but before 1.6. :-\
#

AC_MSG_CHECKING(for GM_API_VERSION)
AC_TRY_COMPILE([#include<gm.h>],
[int foo = GM_API_VERSION;], 
    have_gm_api_ver_msg=yes gm_api_ver=GM_API_VERSION,
    have_gm_api_ver_msg=no  gm_api_ver="")
AC_MSG_RESULT([$have_gm_api_ver_msg])
if test "$gm_api_ver" = ""; then
    found=0
    for val in 5 4 3; do
	if test "$found" = "0"; then
	    var="GM_API_VERSION_1_$val"
	    AC_MSG_CHECKING(for $var)
	    AC_TRY_COMPILE([#include<gm.h>],
		[int foo = $var;], 
		msg=yes found=1 gm_api_ver=$var,
		msg=no found=0 gm_api_ver="")
	    AC_MSG_RESULT($msg)
	fi
    done
fi
if test "$gm_api_ver" = ""; then
    AC_MSG_WARN([*** Could not find a supported GM_API_VERSION])
    AC_MSG_ERROR([*** Cannot continue])
fi
AC_DEFINE_UNQUOTED(LAM_SSI_RPI_GM_API_VERSION, $gm_api_ver,
    [Version of the GM API to use])
unset gm_api_ver have_gm_api_ver_msg found val msg


#
# Check command line args
# config/lam_rpi_gm_params.m4
#

LAM_SSI_RPI_GM_PARAMS])dnl
