/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: ssi_coll_lam_basic_gatherv.c,v 1.2 2003/05/28 00:16:28 jsquyres Exp $
 *
 *	Function:	- Basic collective routines
 */

#include <lam_config.h>
#if LAM_WANT_PROFILE
#define LAM_PROFILELIB 1
#endif
#include <lam-ssi-coll-lam-basic-config.h>

#include <lam-ssi-coll.h>
#include <lam-ssi-coll-lam-basic.h>
#include <mpi.h>
#include <blktype.h>
#include <mpisys.h>
#include <rpisys.h>


/*
 *	gatherv
 *
 *	Function:	- basic gatherv operation
 *	Accepts:	- same arguments as MPI_Bcast()
 *	Returns:	- MPI_SUCCESS or error code
 */
int
lam_ssi_coll_lam_basic_gatherv(void *sbuf, int scount, MPI_Datatype sdtype,
			       void *rbuf, int *rcounts, int *disps,
			       MPI_Datatype rdtype, int root,
			       MPI_Comm comm)
{
  int i;
  int rank;
  int size;
  int err;
  char *ptmp;
  MPI_Aint extent;
  struct _gps *p;

  MPI_Comm_size(comm, &size);
  MPI_Comm_rank(comm, &rank);

  /* Remember required parameters. */

  p = &(comm->c_group->g_procs[root]->p_gps);
  lam_setparam(BLKMPIGATHERV, root | (p->gps_grank << 16),
	       (p->gps_node << 16) | p->gps_idx);

  /* Switch to collective communicator. */

  lam_mkcoll(comm);

  /* Everyone but root sends data and returns. */

  if (rank != root) {
    err = MPI_Send(sbuf, scount, sdtype, root, BLKMPIGATHERV, comm);
    lam_mkpt(comm);
    return err;
  }

  /* I am the root, loop receiving data. */

  MPI_Type_extent(rdtype, &extent);
  for (i = 0; i < size; ++i) {
    ptmp = ((char *) rbuf) + (extent * disps[i]);

    /* simple optimization */

    if (i == rank) {
      err = lam_dtsndrcv(sbuf, scount, sdtype,
			 ptmp, rcounts[i], rdtype, BLKMPIGATHERV, comm);
    } else {
      err = MPI_Recv(ptmp, rcounts[i], rdtype, i,
		     BLKMPIGATHERV, comm, MPI_STATUS_IGNORE);
    }

    if (err != MPI_SUCCESS) {
      lam_mkpt(comm);
      return err;
    }
  }

  /* All done */

  lam_mkpt(comm);
  return MPI_SUCCESS;
}
