/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 * $HEADER$
 *
 * $Id: ssi_coll_lam_basic_allgather.c,v 1.2 2003/05/28 00:16:28 jsquyres Exp $
 *
 *	Function:	- Basic collective routines
 */

#include <lam_config.h>
#if LAM_WANT_PROFILE
#define LAM_PROFILELIB 1
#endif
#include <lam-ssi-coll-lam-basic-config.h>

#include <lam-ssi-coll.h>
#include <lam-ssi-coll-lam-basic.h>
#include <mpi.h>
#include <mpisys.h>


/*
 *	allgather
 *
 *	Function:	- allgather using other MPI collections
 *	Accepts:	- same as MPI_Allgather()
 *	Returns:	- MPI_SUCCESS or error code
 */
int 
lam_ssi_coll_lam_basic_allgather(void *sbuf, int scount, 
				 MPI_Datatype sdtype, void *rbuf, 
				 int rcount, MPI_Datatype rdtype, 
				 MPI_Comm comm)
{
  int size;
  int err;

  /* Gather and broadcast. */

  MPI_Comm_size(comm, &size);
  
  err = MPI_Gather(sbuf, scount, sdtype, rbuf, rcount, rdtype, 0, comm);
  if (err != MPI_SUCCESS)
    return err;
  
  err = MPI_Bcast(rbuf, rcount * size, rdtype, 0, comm);
  return err;
}
