/***************************************************************************
 *   Copyright Sean Meiners 2004 <Sean.Meiners@LinspireInc.com>            *
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License (version 2) as   *
 *   published by the Free Software Foundation. (The original KSplash/ML   *
 *   codebase (upto version 0.95.3) is BSD-licensed.)                      *
 *                                                                         *
 ***************************************************************************/

#ifndef FADEWIDGET_H
#define FADEWIDGET_H

#include <qwidget.h>
#include <qptrlist.h>
#include <qpixmap.h>
#include <qimage.h>

#include <kimageeffect.h>

class QTimer;

class EffectWidget : public QWidget
{
  Q_OBJECT

 public:
  EffectWidget(QWidget *parent = 0,const char *name = 0);

  static void setBackgroundImage(QImage *image) { bgImage = image; }

  void setImage(QImage *i);
  void setDelay(int delayInMS);
  void setLoop(bool loop);
  void setSteps(int steps);
  void setStart(float begin, float end = 1.0, bool reverse = false);

  void start();
  void stop();
  void rewind();

  void paintEvent(QPaintEvent *);
  void resizeEvent(QResizeEvent *);
  void moveEvent(QMoveEvent *);

  void updateCache();

 public slots:
  void timerTick();

 private:
  static QImage *bgImage;

  QTimer *timer;
  QImage *image;
  QImage background;
  unsigned int delayMS;
  unsigned int currentStep;
  unsigned int totalSteps;
  bool playing;
  bool loop;
  float
    beginOpacity,
    endOpacity;
};

#endif
