/***************************************************************************
 *
 * knetworkmanager-vpn_connection.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <qhostaddress.h>
#include <qvariant.h>
#include <qvaluelist.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDbus headers */
#include <dbus/qdbusconnection.h>
#include <dbus/qdbusobjectpath.h>
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatamap.h>
#include <dbus/qdbusvariant.h>

/* NM headers */
#include <NetworkManager.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-vpn_connection.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-connection_setting_ipv4.h"
#include "knetworkmanager-connection_setting_vpn.h"
#include "knetworkmanager-nmsettings.h"

using namespace ConnectionSettings;

/*
	class VPNConnection
*/
VPNConnection::VPNConnection()
	: GenericConnection(NM_SETTING_VPN_SETTING_NAME)
{
	// add all settings needed for a VPN connection
	appendSetting(new VPN(this));

	// TODO: Maybe IPv4 Setting?
}

VPN* VPNConnection::getVPNSetting() const
{
	return dynamic_cast<VPN*>(getSetting(NM_SETTING_VPN_SETTING_NAME));
}

Connection* VPNConnection::duplicate()
{
	VPNConnection* conn = new VPNConnection();
	conn->updateSettings(this);
	return conn;
}


#include "knetworkmanager-vpn_connection.moc"
