/***************************************************************************
 *
 * knetworkmanager-menuitem.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006, 2008 Novell, Inc.
 *
 * Author: Timo Hoenig        <thoenig@suse.de>, <thoenig@nouse.net>
 *         Will Stephenson    <wstephenson@suse.de>, <wstephenson@kde.org>
 *         Valentine Sinitsyn <e_val@inbox.ru>
 *         Helmut Schaa       <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include "knetworkmanager-menuitem.h"

#include <qevent.h>
#include <qguardedptr.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qpixmap.h>
#include <qpixmapcache.h>
#include <qpainter.h>
#include <qstyle.h>
#include <dcopclient.h>
#include <kdebug.h>
#include <kdialogbase.h>
#include <knotifyclient.h>
#include <knotifydialog.h>
#include <klocale.h>
#include <kstdguiitem.h>
#include <khelpmenu.h>
#include <kprocess.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kmessagebox.h>

#include <dbus/qdbusobjectpath.h>
#include <dbus/qdbuserror.h>

#include "knetworkmanager-connection.h"
#include "knetworkmanager-device.h"
#include "knetworkmanager-nm_proxy.h"

using namespace ConnectionSettings;

class NetworkMenuItemPrivate
{
	public:
		NetworkMenuItemPrivate(Device* device, Connection* connection)
		: dev(device), conn(connection)
		{

		}
		~NetworkMenuItemPrivate() {}
	
		QGuardedPtr<Device> dev;
		QGuardedPtr<Connection> conn;
};

void NetworkMenuItem::slotActivate()
{
	int id;
	QDBusError err;
	printf("NetworkMenuItem::slotActivate()\n");
	NMProxy* nm = NMProxy::getInstance();

	if (d->dev && d->conn)
	{
		NMProxy* nm = NMProxy::getInstance();
		if (nm)
		{
			printf("Activate Connection %s on Device %s\n", d->conn->getObjectPath().data(), d->dev->getObjectPath().ascii());
			if (nm->ActivateConnectionAsync(id, NM_DBUS_SERVICE_USER_SETTINGS, d->conn->getObjectPath(), QDBusObjectPath(QCString(d->dev->getObjectPath())), d->conn->getObjectPath(), err))
			{

			}
			else
				printf("ActivateDevice failed\n");
		}
	}
	else if (d->conn)
	{
		// no device given, just take the default device
		QDBusObjectPath act_conn = nm->getDefaultActiveConnection();
		QDBusObjectPath device   = nm->getDeviceForActiveConnection(act_conn);
		nm->ActivateConnectionAsync(id,NM_DBUS_SERVICE_USER_SETTINGS, d->conn->getObjectPath(), device, act_conn, err);
	}
	else
		printf("Device or Connection invalid\n");
}

NetworkMenuItem::NetworkMenuItem (Device* dev, Connection* conn, QObject* parent, const char* name)
		       : QObject(parent, name)
{
	d = new NetworkMenuItemPrivate(dev, conn);
}

NetworkMenuItem::~NetworkMenuItem ()
{
	delete d;
}



#include "knetworkmanager-menuitem.moc"
