/***************************************************************************
 *
 * knetworkmanager-generic_connection.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <qhostaddress.h>
#include <qvariant.h>
#include <qvaluelist.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDbus headers */
#include <dbus/qdbusconnection.h>
#include <dbus/qdbusobjectpath.h>
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatamap.h>
#include <dbus/qdbusvariant.h>

/* NM headers */
#include <NetworkManager.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-generic_connection.h"
#include "knetworkmanager-connection_setting.h"
#include "knetworkmanager-connection_setting_info.h"
#include "knetworkmanager-nmsettings.h"

using namespace ConnectionSettings;

/*
	class GenericConnection
*/
GenericConnection::GenericConnection(const QString& type)
	: Connection()
{
	// every connection needs an info-setting
	appendSetting(new Info(this, type, ""));
}

QString
GenericConnection::getType()
{
	Info* info = dynamic_cast<Info*>(getSetting("connection"));
	if (info)
		return info->getDevType();
	else
		return QString::null;
}

QString
GenericConnection::getID() const
{
	return getInfoSetting()->getUUID();
}

void
GenericConnection::setID(const QString& id)
{
	getInfoSetting()->setUUID(id);
}

Info* GenericConnection::getInfoSetting() const
{
	return dynamic_cast<Info*>(getSetting("connection"));
}

#include "knetworkmanager-generic_connection.moc"
