/***************************************************************************
 *
 * knetworkmanager-connection_setting_vpn_widget.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// qt headers
#include <qwidget.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qiconset.h>
#include <kiconloader.h>
#include <qwidgetstack.h>
#include <kuser.h>

// knm headers
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_vpn.h"
#include "knetworkmanager-connection_setting_vpn_widget.h"
#include "knetworkmanager-device.h"
#include "knetworkmanager-vpnmanager.h"
#include "knetworkmanager-vpnservice.h"

using namespace ConnectionSettings;

VPNWidgetImpl::VPNWidgetImpl(Connection* conn, bool new_conn, QWidget* parent, const char* name, WFlags fl)
	: WidgetInterface(parent, name, fl)
	, _new_conn(new_conn)
{
	_vpnsetting = dynamic_cast<ConnectionSettings::VPN*> (conn->getSetting(NM_SETTING_VPN_SETTING_NAME));

	QVBoxLayout* layout = new QVBoxLayout(this, 1, 1);
	_mainWid = new ConnectionSettingVPNWidget(this);
	layout->addWidget(_mainWid);

	Init();
}

void
VPNWidgetImpl::Init()
{
	// fill in all possible VPN services
	VPNServiceList list = VPNManager::getVPNServices();

	if (list.isEmpty())
	{
		// FIXME Do something useful here
	}
	else
	{
		int index = 0;
		for (VPNServiceList::Iterator it = list.begin(); it != list.end(); ++it)
		{
			QString icon;
			QString disp_name;

			// get service icon and display name
			VPNService* service = *it;
			if (service)
			{
				icon = service->getIcon();
				disp_name = service->getDisplayName();
			}

			// the service should not get changed when editing a connection
			if (service->getService() != _vpnsetting->getServiceType() && !_new_conn)
				continue;

			// no special icon for this service, use default
			if (icon.isEmpty())
				icon = "encrypted";

			_mainWid->cboServices->insertItem(SmallIcon(icon, QIconSet::Automatic), disp_name, index);
			_mapServiceCombo.insert(index++, *it);

			if (service->getService() == _vpnsetting->getServiceType())
			{
				// preselect the correct service
				_mainWid->cboServices->setCurrentItem(index - 1);
				slotServiceComboActivated(index - 1);
			}
		}
	}

	// lock the combo when editing an already existing connection
	if (!_new_conn)
		_mainWid->cboServices->setEnabled(false);
	else
	{
		// preselect the correct service
		_mainWid->cboServices->setCurrentItem(0);
		slotServiceComboActivated(0);
	}

	// update the username to the current one
	KUser user;
	_vpnsetting->setUserName(user.loginName());

	// notification if VPN service is selected
	connect(_mainWid->cboServices, SIGNAL(activated(int)), this, SLOT(slotServiceComboActivated(int)));
}

VPNConfigWidget*
VPNWidgetImpl::getVPNConfigWidget(VPNService* service)
{
	if (_mapServiceWidget.find(service) != _mapServiceWidget.end())
	{
		// return the already available config widget
		return *_mapServiceWidget.find(service);
	}
	else
	{
		// we have to create a new one
		VPNPlugin* plugin = service->getVPNPlugin();
		if (plugin)
		{
			VPNConfigWidget* config = plugin->CreateConfigWidget(_mainWid->widgetStack);
			_mapServiceWidget.insert(service, config);
			return config;
		}
	}
	return NULL;
}


void
VPNWidgetImpl::slotServiceComboActivated(int index)
{
	VPNService* service;
	if (_mapServiceCombo.find(index) != _mapServiceCombo.end())
	{
		service = *_mapServiceCombo.find(index);
		if (service)
		{
			VPNConfigWidget* config = getVPNConfigWidget(service);
			_mainWid->widgetStack->raiseWidget(config);

			config->setVPNData(_vpnsetting->getRoutes(), _vpnsetting->getData());
		}
	}
	else
	{
		//FIXME - do something useful here
	}
}

void
VPNWidgetImpl::Deactivate()
{
	// update the setting from the currently selected vpn service
	VPNService* service = *_mapServiceCombo.find(_mainWid->cboServices->currentItem());
	if (service)
	{
		// set the correct service type
		_vpnsetting->setServiceType(service->getService());

		VPNConfigWidget* config = *_mapServiceWidget.find(service);
		if (config)
		{
			// update the vpn properties
			_vpnsetting->setData(config->getVPNProperties());
		}
	}
}

void
VPNWidgetImpl::Activate()
{

}

#include "knetworkmanager-connection_setting_vpn_widget.moc"
