/***************************************************************************
 *
 * knetworkmanager-connection_setting_gsm.cpp - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

/* qt headers */
#include <qhostaddress.h>
#include <qvariant.h>

/* kde headers */
#include <kdebug.h>
#include <klocale.h>

/* QDBus headers*/
#include <dbus/qdbusdata.h>
#include <dbus/qdbusdatamap.h>

/* knetworkmanager headers */
#include "knetworkmanager.h"
#include "knetworkmanager-connection.h"
#include "knetworkmanager-connection_setting_gsm.h"

using namespace ConnectionSettings;

/*
	class GSM
*/
GSM::GSM(Connection* conn)
	: ConnectionSetting(conn, NM_SETTING_GSM_SETTING_NAME), _number("*99#"), _network_type(-1), _band(-1)
{
}

void GSM::setNumber(const QString& number)
{
	_number = number;
}

QString GSM::getNumber() const
{
	return _number;
}

void GSM::setUsername(const QString& username)
{
	_username = username;
}

QString GSM::getUsername() const
{
	return _username;
}

void GSM::setPassword(const QString& password)
{
	_password = password;
}

QString GSM::getPassword() const
{
	return _password;
}

void GSM::setPin(const QString& pin)
{
	_pin = pin;
}

QString GSM::getPin() const
{
	return _pin;
}

void GSM::setPuk(const QString& puk)
{
	_puk = puk;
}

QString GSM::getPuk() const
{
	return _puk;
}

void GSM::setAPN(const QString& apn)
{
	_apn = apn;
}

QString GSM::getAPN() const
{
	return _apn;
}

void GSM::setNetworkID(const QString& id)
{
	_network_id = id;
}

QString GSM::getNetworkID() const
{
	return _network_id;
}

void GSM::setNetworkType(int type)
{
	_network_type = type;
}

int GSM::getNetworkType() const
{
	return _network_type;
}

void GSM::setBand(int band)
{
	_band = band;
}

int GSM::getBand() const
{
	return _band;
}

bool
GSM::isValid() const
{
	return true;
}

SettingsMap
GSM::toMap() const
{
	SettingsMap map;

	if (!_number.isEmpty()) {
		map.insert(NM_SETTING_GSM_NUMBER, QDBusData::fromString(_number));
	}
	if (!_username.isEmpty()) {
		map.insert(NM_SETTING_GSM_USERNAME, QDBusData::fromString(_username));
	}
	if (!_apn.isEmpty()) {
		map.insert(NM_SETTING_GSM_APN, QDBusData::fromString(_apn));
	}
	if (!_network_id.isEmpty()) {
		map.insert(NM_SETTING_GSM_NETWORK_ID, QDBusData::fromString(_network_id));
	}
	map.insert(NM_SETTING_GSM_NETWORK_TYPE, QDBusData::fromInt32(_network_type));
	map.insert(NM_SETTING_GSM_BAND, QDBusData::fromInt32(_band));
	
	return map;
}

SettingsMap
GSM::toSecretsMap(bool with_settings) const
{
	SettingsMap map;

	// first serialize the settings if needed
	if (with_settings)
		map = toMap();

	if (!_password.isEmpty()) {
		map.insert(NM_SETTING_GSM_PASSWORD, QDBusData::fromString(_password));
	}
	if (!_pin.isEmpty()) {
		map.insert(NM_SETTING_GSM_PIN, QDBusData::fromString(_pin));
	}
	if (!_puk.isEmpty()) {
		map.insert(NM_SETTING_GSM_PUK, QDBusData::fromString(_puk));
	}

	return map;
}

bool
GSM::fromSecretsMap(const SettingsMap& map)
{
	for (SettingsMap::ConstIterator it = map.begin(); it != map.end(); ++it)
	{
		// TODO: add all secrets
		if (it.key() == NM_SETTING_GSM_PASSWORD)
			setPassword(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_PIN)
			setPin(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_PUK)
			setPuk(it.data().toString());
		else
			kdWarning() << k_funcinfo << " Unknown secret: " << it.key() << endl;
	}
	return true;
}

void
GSM::fromMap(const SettingsMap& map)
{
	// TODO: add all attributes
	for (SettingsMap::ConstIterator it = map.begin(); it != map.end(); ++it)
	{
		if (it.key() == NM_SETTING_GSM_NUMBER)
			setNumber(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_USERNAME)
			setUsername(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_APN)
			setAPN(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_NETWORK_ID)
			setNetworkID(it.data().toString());
		else if (it.key() == NM_SETTING_GSM_NETWORK_TYPE)
			setNetworkType(it.data().toUInt32());
		else if (it.key() == NM_SETTING_GSM_BAND)
			setBand(it.data().toUInt32());
		else
			kdWarning() << k_funcinfo << " Unknown setting: " << it.key() << endl;
	}
}
