/***************************************************************************
 *
 * knetworkmanager-vpnc.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <Helmut.Schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <klocale.h>
#include <qmessagebox.h>
#include <qbutton.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <qobjectlist.h>
#include <qobject.h>
#include <qcheckbox.h>
#include <kpassdlg.h>
#include <kgenericfactory.h>
#include <qlabel.h>

#include "knetworkmanager-vpnc.h"

typedef KGenericFactory<VPNCPlugin> VPNCPluginFactory;
K_EXPORT_COMPONENT_FACTORY( knetworkmanager_vpnc, VPNCPluginFactory("knetworkmanager_vpnc"));


VPNCPlugin::VPNCPlugin(QObject* parent, const char* name, const QStringList& args) 
	: VPNPlugin(parent, name, args)
{
	KLocale* loc = KGlobal::locale();
	loc->insertCatalogue("NetworkManager-vpnc");
}

VPNCPlugin::~VPNCPlugin()
{

}

VPNConfigWidget* VPNCPlugin::CreateConfigWidget(QWidget* parent)
{
	return new VPNCConfig(parent);
}

VPNAuthenticationWidget* VPNCPlugin::CreateAuthenticationWidget(QWidget* parent)
{
	return new VPNCAuthentication(parent);
}


VPNCConfig::VPNCConfig(QWidget* parent)
	: VPNConfigWidget(parent)
{
	QVBoxLayout* layout = new QVBoxLayout(this, 1, 1);
	_vpncWidget = new VPNCConfigWidget(this);
	layout->addWidget(_vpncWidget);
	
	connect(_vpncWidget->chkOverrideUsername, SIGNAL(toggled(bool)), _vpncWidget->Xauth_username, SLOT(setEnabled(bool)));
	connect(_vpncWidget->chkOverrideUsername, SIGNAL(toggled(bool)), _vpncWidget->lblUsername, SLOT(setEnabled(bool)));

	connect(_vpncWidget->chkUseDomain, SIGNAL(toggled(bool)), _vpncWidget->Domain, SLOT(setEnabled(bool)));
	connect(_vpncWidget->chkUseDomain, SIGNAL(toggled(bool)), _vpncWidget->lblDomain, SLOT(setEnabled(bool)));

	connect(_vpncWidget->chkIPAdresses, SIGNAL(toggled(bool)), _vpncWidget->routes, SLOT(setEnabled(bool)));

	connect(_vpncWidget->chkUseKeepAlive, SIGNAL(toggled(bool)), _vpncWidget->nat_keep_alive_interval, SLOT(setEnabled(bool)));
	connect(_vpncWidget->chkUseKeepAlive, SIGNAL(toggled(bool)), _vpncWidget->lblKeepAliveInterval, SLOT(setEnabled(bool)));

	this->languageChange();
}

VPNCConfig::~VPNCConfig()
{

}

void VPNCConfig::languageChange()
{

}

void VPNCConfig::setVPNData(const QStringList& routes, const QStringList& properties)
{
	// fill up our inputfields (only textfields atm)
	for(QStringList::ConstIterator it = properties.begin(); it != properties.end(); ++it)
	{
		QString entry = (*it);
		
		if (entry == "IPSec gateway")
		{
			_vpncWidget->IPSec_gateway->setText(*(++it));
		}
		else if (entry == "IPSec ID")
		{
			_vpncWidget->IPSec_ID->setText(*(++it));
		}
		else if (entry == "Xauth username")
		{
			_vpncWidget->Xauth_username->setText(*(++it));
			_vpncWidget->chkOverrideUsername->setChecked(true);
		}
		else if (entry == "Domain")
		{
			_vpncWidget->Domain->setText(*(++it));
			_vpncWidget->chkUseDomain->setChecked(true);
		}
		else if (entry == "NAT-Keepalive packet interval")
		{
			_vpncWidget->nat_keep_alive_interval->setText(*(++it));
			_vpncWidget->chkUseKeepAlive->setChecked(true);
		}
		else if (entry == "Disable NAT Traversal")
		{
			_vpncWidget->chkDisableNatTraversal->setChecked(true);
		}
		else if (entry == "Enable Single DES")
		{
			_vpncWidget->chkSingleDES->setChecked(true);
		}
	}

	// set routes
	if (!routes.empty())
	{
		_vpncWidget->chkIPAdresses->setChecked(true);
		_vpncWidget->routes->setText(routes.join(" "));
	}
}

QStringList VPNCConfig::getVPNProperties()
{
	// build a StingList of properties
	QStringList strlist;
	strlist.append("IPSec gateway");
	strlist.append(_vpncWidget->IPSec_gateway->text());

	strlist.append("IPSec ID");
	strlist.append(_vpncWidget->IPSec_ID->text());

	if (_vpncWidget->chkOverrideUsername->isChecked())
	{
		strlist.append("Xauth username");
		strlist.append(_vpncWidget->Xauth_username->text());
	}

	if (_vpncWidget->chkUseDomain->isChecked())
	{
		strlist.append("Domain");
		strlist.append(_vpncWidget->Domain->text());
	}
	
	if (_vpncWidget->chkUseKeepAlive->isChecked())
	{
		strlist.append("NAT-Keepalive packet interval");
		strlist.append(_vpncWidget->nat_keep_alive_interval->text());
	}

	if (_vpncWidget->chkDisableNatTraversal->isChecked())
	{
		strlist.append("Disable NAT Traversal");
 	}

	if (_vpncWidget->chkSingleDES->isChecked())
	{
		strlist.append("Enable Single DES");
	}

	return strlist;
}

QStringList VPNCConfig::getVPNRoutes()
{
	QStringList strlist;
	if(_vpncWidget->chkIPAdresses->isChecked())
	{
		strlist = QStringList::split(" ", _vpncWidget->routes->text());
	}
	return strlist;

}

bool VPNCConfig::hasChanged()
{
	return true;
}

bool VPNCConfig::isValid(QStringList& err_msg)
{
	bool retval = true;
	if(_vpncWidget->IPSec_gateway->text() == "" || _vpncWidget->IPSec_ID->text() == "")
	{
		err_msg.append(i18n("At least the gateway and group has to be supplied."));
		retval = false;
	}
	return retval;
}

VPNCAuthentication::VPNCAuthentication(QWidget* parent, char* name)
	: VPNAuthenticationWidget(parent, name)
{
	QVBoxLayout* layout = new QVBoxLayout(this, 1, 1);
	_vpncAuth = new VPNCAuthenticationWidget(this);
	layout->addWidget(_vpncAuth);
}

VPNCAuthentication::~VPNCAuthentication()
{

}

QStringList VPNCAuthentication::getPasswords()
{
	QStringList pwds;
	pwds.push_back(_vpncAuth->editGroupPassword->password());
	pwds.push_back(_vpncAuth->editUserPassword->password());
	return pwds;
}
