/***************************************************************************
 *
 * knetworkmanager-dialup.cpp - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include "knetworkmanager-dialup.h"

void
DialUp::setName (const QString & name)
{
	_name = name;
}

QString
DialUp::getName () const
{
	return _name;
}

void
DialUp::setActive (bool active)
{
	_active = active;
}

bool
DialUp::isActive () const
{
	return _active;
}

bool
DialUp::operator == (const DialUp & dialup)
{
	return (this->getName () == dialup.getName ());
}

DialUp::DialUp (const QString & name)
{
	_name = name;
	_active = false;
}

DialUp::DialUp ()
{
	_name = QString::null;
	_active = false;
}

DialUp::~DialUp ()
{

}
